//
//  BingoDatabase.h
//  BingoGame
//
//  Created by Jenny Wu on 11/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ImageProof.h"
#import "Gameboard.h"
#import "GameHistory.h"
#import <sqlite3.h>

@interface BingoDatabase : NSObject

@property (nonatomic, readonly)sqlite3 *database;
@property (nonatomic, readonly) NSString *databaseFilePath;
//-(BOOL) saveData:(NSArray *)dataArray toTable:(NSString *)tableName;
-(BOOL)createDatabaseSchema;
-(BOOL)saveImageProofData:(ImageProof *) imageProof ForGame:(NSNumber *) gameID;
-(BOOL)saveGameData:(Gameboard *) game;
-(NSNumber *)maxRowIDForGameBoard;
-(NSNumber *)maxRowIDForImageProof;

-(Gameboard *) getLastGame;
-(GameHistory *) getGameHistory;

@end
