//
//  BingoDetailViewController.m
//  BingoGame
//
//  Created by Jenny Wu on 19/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "BingoDetailViewController.h"
//#import "GameboardCollectionViewController.h"
#import "Utility.h"
#import <CoreLocation/CoreLocation.h>


@interface BingoDetailViewController ()
@property (nonatomic,strong)CLGeocoder *geocoder;
@end

@implementation BingoDetailViewController{
    
    bool showVerificationAlert;

}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    //show road sign to be matched
    NSString *cardImageName = self.imageProof.bingoSignID;
    self.bingoCardImageView.image = [UIImage imageNamed:cardImageName];
    
    //show proof
    NSURL *fileURL = [NSURL URLWithString:self.imageProof.fileName];
    UIImage *proofImage = [Utility imageFromURL:fileURL];
    self.proofImageView.image = proofImage;

    //there is no use checking image orientation information now, it is too late, we need to save the image orientation.  Seems that all images need to be rotated by 90 degree.  With screen locked, it should be ok to rotate all image.
    self.proofImageView.transform = CGAffineTransformMakeRotation(M_PI_2);
    
    //show location and date
    self.proofDetailTextView.text = [Utility mediumDateString:self.imageProof.dateTaken];
    double latitude = [self.imageProof.latitude doubleValue];
    double longitude = [self.imageProof.longitude doubleValue];
    CLLocation *loc = [[CLLocation alloc] initWithLatitude:latitude longitude:longitude];
    if(self.isEditMode){
        self.btnRetake.enabled = self.isEditMode;
        self.btnRetake.hidden = !self.isEditMode;
        self.btnCancel.enabled = self.isEditMode;
        self.btnCancel.hidden = !self.isEditMode;
    }
    else{
        NSString *title = self.imageProof.checked? @"Incorrect" : @"Correct";
        [self.btnToggleCorrect setTitle: title];
    }
    
    float radius = self.btnRetake.bounds.size.height * 0.1;
    self.btnRetake.layer.cornerRadius = radius;
    self.btnCancel.layer.cornerRadius = radius;
    
    [self reverseGeocodeLocation:loc];
    
}

-(void)viewWillAppear:(BOOL)animated{
    showVerificationAlert = YES;
}


-(void)viewWillDisappear:(BOOL)animated{
    if(showVerificationAlert){
        if(!self.isEditMode && !self.imageProof.checked){
            [Utility showAlertMessageWithTitle:@"Image not verified" message:@"Photo has not be verified as correct match. Use the correct button on top right hand side to verify correct match" delegate:Nil canceltButtonText:@"OK"];
        }
    }
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (IBAction)dismissModalView:(id)sender {
    //cancel button clicked
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)retakePhoto:(id)sender {
    //dimiss itself and on completion, ask delegate to handle retaking photo
    [self dismissViewControllerAnimated:YES completion:^(void){[_retakePhotoDelegate retakeImageProofPhoto];}];
}

- (IBAction)btnToggleCorrect:(id)sender
{
    self.imageProof.checked = !self.imageProof.checked;
    [self.imageProof saveImageProof];
    showVerificationAlert = NO;
    [self.navigationController popViewControllerAnimated:YES];
}


- (void)reverseGeocodeLocation:(CLLocation *)location
{
    [self.geocoder reverseGeocodeLocation:location completionHandler:^(NSArray* placemarks, NSError *error) {
        if (placemarks.count){
            CLPlacemark *placemark = placemarks[0];
            
            NSString *streetStr = placemark.thoroughfare;
            NSString *city = placemark.locality;
            NSString *state = placemark.administrativeArea;
            NSString *country = placemark.country;
            NSMutableString *addressStr = [[NSMutableString alloc] init];
            if(streetStr) [addressStr appendFormat:@"\n%@,",streetStr];
            if(city) [addressStr appendFormat:@"\n%@,", city];
            if(state) [addressStr appendFormat:@"\n%@,", state];
            if(country) [addressStr appendFormat:@"\n%@,", country];
            
            //keep date info on text view and append street information, remove last comma
            if([addressStr length]){
                self.proofDetailTextView.text = [NSString stringWithFormat:@"%@%@", self.proofDetailTextView.text, [addressStr substringToIndex:addressStr.length-2]];
            }
            
        }
        
    }];
}



-(CLGeocoder *)geocoder
{
    if(!_geocoder){
        _geocoder = [[CLGeocoder alloc] init];
    }
    return _geocoder;
}

@end

