//
//  BingoTableViewController.m
//  BingoGame
//
//  Created by Jenny Wu on 18/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "BingoTableViewController.h"
#import "BingoTableViewCell.h"
#import "BingoAppDelegate.h"
#import "Gameboard.h"
#import "ImageProof.h"
#import "BingoDetailViewController.h"

#define NUM_SECTION 1

@interface BingoTableViewController ()
@property (nonatomic,strong) NSArray *bingoWinningCards;
@property (nonatomic,strong) NSDictionary *dictionaryImageProofs;
@property (nonatomic,strong) Gameboard *currentGame;
@end

@implementation BingoTableViewController
    UIImageView *bingoSpinningImage;
    BingoAppDelegate *appDelegate;

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    appDelegate = [[UIApplication sharedApplication] delegate];
    
    
    UIImage *image = [UIImage imageNamed:@"BingoSpin"];


    bingoSpinningImage = [[UIImageView alloc] initWithImage:image];//this will init imageview with the size of the image
    CGRect frameRect = [[UIScreen mainScreen] applicationFrame];
    float imageWidth = bingoSpinningImage.frame.size.width;
    float imageHeight = bingoSpinningImage.frame.size.height;
    float x = (frameRect.size.width - imageWidth)/2.0;
    float y = ((frameRect.size.height - imageHeight)/2.0) - imageHeight;
    CGRect rect = CGRectMake(x,y,imageWidth,imageHeight);
    [bingoSpinningImage setFrame:rect];

}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return NUM_SECTION;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    return self.bingoWinningCards.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"tableCell";
    BingoTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier forIndexPath:indexPath];
    
    // Configure the cell...
    long rowID = [indexPath row];
    NSString *bingCardImageName  = self.bingoWinningCards[rowID];
    cell.imageView.image = [UIImage imageNamed:bingCardImageName];
    
    //show checkbox if the image was approved already. Otherwise show detail disclosure button
    ImageProof *proof = [self.dictionaryImageProofs objectForKey:bingCardImageName];
    cell.accessoryType = (proof.checked? UITableViewCellAccessoryCheckmark: UITableViewCellAccessoryDetailDisclosureButton);
    cell.imageView.alpha = (proof.checked? 0.5: 1);
    
    return cell;
}

-(void)viewWillAppear:(BOOL)animated{

    if (self.currentGame.bingoVerified){;
        [self.currentGame saveGameBoard];
        self.navigationController.tabBarItem.badgeValue = nil;
        [self animateBingo];
    }
    else{
        [bingoSpinningImage removeFromSuperview];
    }
    
    [self.tableView reloadData];

}

-(Gameboard *)currentGame{
    return appDelegate.currentGameBoard;
}

-(NSArray *)bingoWinningCards{
    if(self.currentGame.bingo)
        return self.currentGame.bingoCards;
    else
        return nil;
}

-(NSDictionary *)dictionaryImageProofs{
    if(self.currentGame.bingo)
        return self.currentGame.dictionaryImageProofs;
    else
        return nil;
}

-(void)animateBingo{

    [self.view addSubview:bingoSpinningImage];
    
    [self rotateSpinningView];

}

//rotate 360 degree
- (void)rotateSpinningView
{
//    [UIView animateWithDuration:1 delay:0 options:UIViewAnimationOptionCurveLinear animations:^{
//        [bingoSpinningImage setTransform:CGAffineTransformRotate(bingoSpinningImage.transform, M_PI_2)];
//    } completion:^(BOOL finished) {
//        if (finished && !CGAffineTransformEqualToTransform(bingoSpinningImage.transform, CGAffineTransformIdentity)) {
//            [self rotateSpinningView];
//        }
//        else{
//            sleep(2);
//            BingoAppDelegate *appDelegate = [[UIApplication sharedApplication] delegate];
//            [self.tabBarController setSelectedIndex:appDelegate.historyTabItemIndex];
//        }
//    }];
    
    
    CABasicAnimation *rotationAnimation = [CABasicAnimation animationWithKeyPath:@"transform.rotation.z"];
    //2 full rotation with Ease Out effect (start fast then slow down)
    rotationAnimation.toValue = [NSNumber numberWithFloat:M_PI * 2.0 * 2.0];
    rotationAnimation.duration = 3.0;
    [rotationAnimation setTimingFunction:[CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseOut]];
    [bingoSpinningImage.layer addAnimation:rotationAnimation forKey:@"rotationAnimation"];
    
    
}

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath
{
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/


#pragma mark - Navigation

// In a story board-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
    if([segue.identifier isEqualToString:@"showProof"]){
        BingoDetailViewController* detailViewController = (BingoDetailViewController *)[segue destinationViewController];
        
        NSInteger rowID = [[self.tableView indexPathForSelectedRow] row];
        
        NSNumber *bingoCardID = self.bingoWinningCards[rowID];

        detailViewController.imageProof = [self.dictionaryImageProofs objectForKey:bingoCardID];
        detailViewController.isEditMode = NO;
    }
}


@end
