//
//  Camera.h
//  BingoGame
//
//  Created by Jenny Wu on 20/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol CameraDelegate <NSObject>
@required
-(void) cameraDidTakePhoto:(NSString *)fileName ForCell:(NSInteger)cellID;// atLatitude:(double)latitude andLongitude:(double)longitude;
-(void) cameraFailToTakePhoto;

@end

@interface Camera : NSObject <UIImagePickerControllerDelegate, UINavigationControllerDelegate> // required protocol for showing camera

@property id<CameraDelegate> delegate;

//Designated initializer
-(id) initWithViewController:(UIViewController *) sender;
-(void)takePhotoForCell:(NSInteger) cellID;



@end
