//
//  Camera.m
//  BingoGame
//
//  Created by Jenny Wu on 20/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "Camera.h"
#import "Utility.h"
#import <MobileCoreServices/MobileCoreServices.h>

@implementation Camera{
    UIViewController *_viewController;
    //CLLocationManager *_locationMgr;
    NSString *_savedImageFileName;
    NSInteger _cellRowID;
    //CLLocation *_pictureLocation;
}

-(id)initWithViewController:(UIViewController *)sender{
    self = [super init];
    if(self){
        _viewController = sender;
    }
    return self;
}

#pragma mark UIImagePickerControllerDelegate

-(BOOL) canTakePhoto
{
    //there is no need to check if a camera is present on the device as "still-camera" is added to project's info.plist as UIRequiredDeviceCapabilities
    //device with no camera will not be able to install the BingoGame app. But we need to check if we can access the camera at the moment, because
    //the camera could be disabled by the user on the device even tho a camera is present on the device
    return [UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera];
    
}

//Creates an ImagePickerController and set the camera to allow picture taking only
-(void) takePhotoForCell:(NSInteger)cellID
{
    if ([self canTakePhoto]){
        _cellRowID = cellID;
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.delegate = self;
        imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
        [_viewController presentViewController:imagePicker animated:YES completion:NULL];
        //only allow camera to take photos, no support for video
        imagePicker.mediaTypes = @[(NSString *)kUTTypeImage];
    }
    else{
        [Utility showAlertMessageWithTitle:@"Camera Error" message:@"Camera not available" delegate:nil canceltButtonText:@"OK"];
    }
}

-(void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    BOOL savedOK = NO;
    //info is an NSDictionary and UIImagePickerControllerMediaType is of the keys
    NSString *mediaType = info[UIImagePickerControllerMediaType];
    
    if ([mediaType isEqualToString:(NSString *) kUTTypeImage]){
        UIImage *image = info[UIImagePickerControllerOriginalImage];
        savedOK = [self saveImage:image];
    }
    
    savedOK ? [_delegate cameraDidTakePhoto:_savedImageFileName ForCell:_cellRowID] : [_delegate cameraFailToTakePhoto];
    
    [_viewController dismissViewControllerAnimated:YES completion:nil];
}

//this method saves the image to the bingo app database
-(BOOL) saveImage:(UIImage *) image
{
    _savedImageFileName = [Utility saveImageToDocumentDir:image];
    return _savedImageFileName ? YES: NO;
}


//contoller will be notified via the following method if the user clicked on cancel and did not take a picture
-(void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    [picker dismissViewControllerAnimated:YES completion:nil];
}


@end
