//
//  Deck.m
//  BingoGame
//
//  Created by Jenny Wu on 12/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "Deck.h"
@interface Deck()
@property (nonatomic) NSInteger maxCardCount;
@property (nonatomic) NSMutableArray *cards;
@property (nonatomic) NSMutableArray *shuffledCards;
@end

@implementation Deck

const int COUNT = 38;

-(NSMutableArray *)cards
{
    if(!_cards.count){
        _cards = [[NSMutableArray alloc] init];
        for (int i = 0; i < self.maxCardCount ; i++) {
            //[_cards addObject:[NSNumber numberWithInt:i+1]];
            //[_cards addObject:[NSNumber numberWithInt:i+1]];
            [_cards addObject:[NSString stringWithFormat:@"%d", i+1]];
        }
    }
    return _cards;
}

-(NSInteger)maxCardCount
{
    return COUNT;
}



-(NSArray *)drawRandomCardsWithCount:(NSInteger) count
{
    return [self.shuffledCards subarrayWithRange:NSMakeRange(0,count)];
}

-(NSMutableArray *) shuffledCards
{
    _shuffledCards = [[NSMutableArray alloc] init];
    NSInteger count = [self.cards count];
    
    NSInteger remainingCount = count;
    for (int i=0; i<count; i++) {
        unsigned randIndex = arc4random_uniform(remainingCount); //random int between 0 to N-1
        [_shuffledCards addObject:_cards[randIndex]];
        [_cards removeObjectAtIndex:randIndex];
        remainingCount--;
    }
    
    _cards = nil;
    return _shuffledCards;
}

@end
