//
//  Gameboard.h
//  BingoGame
//
//  Created by Jenny Wu on 13/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ImageProof.h"
#import "Deck.h"
@protocol GameboardDelegate<NSObject>
@required
-(void)bingoReady:(bool)ready;
@end

@interface Gameboard : NSObject
@property id<GameboardDelegate> delegate;
@property (nonatomic,strong) NSArray *boardLayout;
@property (nonatomic,readonly) NSInteger boardSize;
@property (nonatomic,strong,readonly) NSMutableArray *boardStatus;//this stores the selected status of each cell. Size of this array is the same as boardSize
@property (nonatomic,readonly) unsigned long boardStatusAsNumber;
@property (nonatomic,readonly) BOOL bingo; //indicates if a winning configuration has been achieved
@property (nonatomic,readonly) BOOL bingoVerified;
@property (nonatomic,strong,readonly) NSArray *bingoCards;//the cards that caused bing
@property (nonatomic,strong) NSMutableDictionary *dictionaryImageProofs;//stores the image proofs for each sign on the board
@property (nonatomic,strong,readonly) NSDate *startTime;
@property (nonatomic,strong, readonly) NSDate *endTime;
@property (nonatomic,strong,readonly) NSNumber *ID;

+(Gameboard *)getLastGame;
//Designated initializer, size is the number of cells per row e.g. size = 5 for a 5x5 board
-(id)initNewGameWithRowSize:(NSInteger) size;
-(id)initExistingGameWithLayout:(NSArray*)layout status:(NSNumber *) statusAsNumber StartTime:(NSDate *)start EndTime:(NSDate *)end ID:(NSNumber *) ID;
//-(void)selectCell:(int)cellIndex;
//-(void)deselectCell:(int)cellIndex;
-(bool)isCellSelected:(int)cellIndex;
-(void)matchCell:(NSInteger)cellIndex withPhotoFile:(NSString *) fileName;
-(void)updateMatchedCell:(NSInteger)cellIndex withLatitude:(NSNumber *)latitude AndLongitude:(NSNumber *)longitude;
-(ImageProof *)imageProofForCellIndex:(NSInteger)cellIndex;
-(BOOL)saveGameBoard;
-(void)quitGame;
//need init with existing game method

@end
