//
//  HistoryViewController.m
//  BingoGame
//
//  Created by Jenny Wu on 3/03/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "HistoryViewController.h"
#import "Utility.h"
#import "BingoAppDelegate.h"
#import "GameHistory.h"


@interface HistoryViewController () <UIAlertViewDelegate>
@property (nonatomic,strong) GameHistory *gameHistory;
@property (nonatomic,strong) BingoAppDelegate *appDelegate;
@end

@implementation HistoryViewController


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    //set current game board information
    self.appDelegate = (BingoAppDelegate *)[[UIApplication sharedApplication] delegate];
}

-(void)viewWillAppear:(BOOL)animated
{
    self.gameHistory = [self.appDelegate.bingodatabase getGameHistory];
    self.currentGameDurationTextField.text = [Utility formatMinutes:self.gameHistory.currentGameDurationMinutes];
    
    self.wonCountTextField.text = [self.gameHistory.wonCount stringValue];
    
    self.lostCountTextField.text = [self.gameHistory.lostCount stringValue];
    
    self.fastestTimeTextField.text = [Utility formatMinutes: self.gameHistory.fastestTimeMinutes];

}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)startNewGame:(id)sender {
    Gameboard *currentGame = self.appDelegate.currentGameBoard;
    bool canStartNewGame = YES;

    if(!currentGame.bingoVerified){
        if(currentGame.bingo){
            canStartNewGame = NO;
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Quit a winning game" message:@"Image photos are not verified as correct match yet. Are you sure you want to quit current winning game?" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"OK", nil];
            [alert show];
        }
        else{
            [currentGame quitGame];
        }
    }
    
    if (canStartNewGame){
        [self.appDelegate startNewGame];
    }
}

-(void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex{
    bool canQuitGame = YES;
    canQuitGame = (buttonIndex == 1);
    if(canQuitGame){
        Gameboard *currentGame = self.appDelegate.currentGameBoard;
        [currentGame quitGame];
        [self.appDelegate startNewGame];
    }
}
@end
