//
//  ImageProof.h
//  BingoGame
//
//  Created by Jenny Wu on 21/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface ImageProof : NSObject

@property (nonatomic,strong) NSString *fileName;
@property (nonatomic,strong) NSNumber *latitude;
@property (nonatomic,strong) NSNumber *longitude;
@property (nonatomic,strong) NSDate *dateTaken;
@property (nonatomic,readonly) NSString *bingoSignID;
@property (nonatomic) BOOL checked;
@property (nonatomic,strong,readonly) NSNumber *ID;
@property (nonatomic,strong) NSNumber *gameID;
//designated initializer
-(id)initWithFileName:(NSString*)fileName latitude:(NSNumber *)latitude longitude:(NSNumber *)longitude checked:(BOOL) imageApproved bingoSignID:(NSString *)bingoSignID forGame:(NSNumber *) gameID;
-(id)initWithExistingImageProofWithFileName:(NSString *)fileName latitude:(NSNumber *)latitude longitude:(NSNumber *)longitude checked:(BOOL)imageApproved bingoSignID:(NSString *)bingoSignID forGame:(NSNumber *) gameID dateTaken:(NSDate *)date RecordID:(NSNumber *) recordID;
-(BOOL)saveImageProof;
@end
