//
//  ImageProof.m
//  BingoGame
//
//  Created by Jenny Wu on 21/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "ImageProof.h"
#import "BingoAppDelegate.h"
@interface ImageProof()
@property (nonatomic,readwrite) NSString *bingoSignID;
@property (nonatomic,weak) BingoDatabase *database;
@property (nonatomic,strong,readwrite) NSNumber *ID;
@end

@implementation ImageProof

-(id)initWithFileName:(NSString *)fileName latitude:(NSNumber *)latitude longitude:(NSNumber *)longitude checked:(BOOL)imageApproved bingoSignID:(NSString *)bingoSignID forGame:(NSNumber *) gameID
{
    self = [super init];
    if(self){
        _fileName = fileName;
        _latitude = latitude;
        _longitude = longitude;
        _bingoSignID = bingoSignID;
        _checked = imageApproved;
        _dateTaken =[NSDate date];
        _gameID = gameID;
    }
    return self;
}

-(id)initWithExistingImageProofWithFileName:(NSString *)fileName latitude:(NSNumber *)latitude longitude:(NSNumber *)longitude checked:(BOOL)imageApproved bingoSignID:(NSString *)bingoSignID forGame:(NSNumber *) gameID dateTaken:(NSDate *)date
                                   RecordID:(NSNumber *) recordID
{
    self = [super init];
    if(self){
        _fileName = fileName;
        _latitude = latitude;
        _longitude = longitude;
        _bingoSignID = bingoSignID;
        _checked = imageApproved;
        _dateTaken = date;
        _gameID = gameID;
        _ID = recordID;
    }
    return self;
}

-(BingoDatabase *)database
{
    if(!_database){
        BingoAppDelegate *appDelegate = (BingoAppDelegate *)[[UIApplication sharedApplication] delegate];
        _database = appDelegate.bingodatabase;
    }
    return _database;
}

-(BOOL)saveImageProof
{
    if([self.database saveImageProofData:self ForGame:self.gameID]){
        if (!self.ID){
            self.ID =[self.database maxRowIDForImageProof];
        }
        return YES;
    }
    else{
        return NO;
    }
}

@end
