//
//  Location.h
//  BingoGame
//
//  Created by Jenny Wu on 21/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
@class Location; //forward declaration

@protocol LocationDelegate <NSObject>
@required
-(void)locationManagerDidUpdateLatitude:(NSNumber *)latitude longtitude:(NSNumber *)longitude forCell:(NSInteger)cellRowID;
-(void)locationManagerUpdateFailedWithError:(NSError *) error;
@end



@interface Location : NSObject<CLLocationManagerDelegate>
@property id<LocationDelegate> delegate;
-(void)startUpdatingLocationForBingoCell:(NSInteger) cellRowID;


@end
