//
//  Location.m
//  BingoGame
//
//  Created by Jenny Wu on 21/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "Location.h"

@implementation Location{
    CLLocationManager *_locationMgr;
    NSInteger _cellRowID;
}


-(void)startUpdatingLocationForBingoCell:(NSInteger) cellRowID
{
    _cellRowID = cellRowID;
    _locationMgr = [[CLLocationManager alloc]init];
    _locationMgr.desiredAccuracy = kCLLocationAccuracyBest;
    _locationMgr.delegate = self;
    [_locationMgr startUpdatingLocation];
}

#pragma mark CLLocationManagerDelegate

-(void)locationManager:(CLLocationManager *)manager didUpdateLocations:(NSArray *)locations
{
    //locations always contain at least one entry, the last entry is the latest location.
    CLLocation *pictureLocation = [locations lastObject];
    
    //stop location update
    [manager stopUpdatingLocation];
    NSNumber *latitude = [NSNumber numberWithDouble:pictureLocation.coordinate.latitude];
    NSNumber *longitude = [NSNumber numberWithDouble:pictureLocation.coordinate.longitude];
    //notify delegate of the location
    [self.delegate locationManagerDidUpdateLatitude:latitude
                                         longtitude:longitude
                                            forCell:_cellRowID];
    
}

//location service will return error if the service is disabled
-(void)locationManager:(CLLocationManager *)manager didFailWithError:(NSError *)error{
    [manager stopUpdatingLocation];
    
    [self.delegate locationManagerUpdateFailedWithError:error];
}

@end
