//
//  Utility.m
//  BingoGame
//
//  Created by Jenny Wu on 17/02/14.
//  Copyright (c) 2014 Jenny Wu. All rights reserved.
//

#import "Utility.h"

@implementation Utility

#define IMAGE_FILE_EXT @"png"
#define EMPTY_NSSTRING @""

+(void)showAlertMessageWithTitle:(NSString *)title message:(NSString *)message delegate:(id)delegate canceltButtonText:(NSString *)cancelButtonText
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:cancelButtonText otherButtonTitles:nil];
    [alert show];
}

+(NSString *)saveImageToDocumentDir:(UIImage *)image
{
    NSString *savedFileName;
    NSError *error;
    BOOL savedOK;
    
    NSURL *imageFileName = [self uniqueFileNameWithFullPath];
    imageFileName = [imageFileName URLByAppendingPathExtension:IMAGE_FILE_EXT];
    NSData *binaryImageData = UIImagePNGRepresentation(image);

    if (binaryImageData){
        savedOK = [binaryImageData writeToURL:imageFileName options:NSDataWritingAtomic error:&error];
        if (savedOK){
            savedFileName = [imageFileName absoluteString];
        }
        else{
            [Utility showAlertMessageWithTitle:@"Save Failed"
                                       message:@"Failed to save image. Please retake the picture"
                                      delegate:nil
                             canceltButtonText:@"OK"];
        }
    }
    return savedFileName;
}

+(NSString *)uniqueFileName
{
    NSDate *now = [NSDate date];
    long long int nowInMilliSeconds = (long long int)[now timeIntervalSince1970] * 1000;
    return [NSString stringWithFormat:@"%lld", nowInMilliSeconds];
}

+(NSURL *)uniqueFileNameWithFullPath
{
    NSFileManager *fileMgr = [NSFileManager defaultManager];
    NSArray * docPaths = [fileMgr URLsForDirectory:NSDocumentDirectory inDomains:NSUserDomainMask];
    NSURL *imageFile;
    if([docPaths count] > 0) {
        NSURL *docDir = docPaths[0];
        NSString *fileName = [self uniqueFileName];
        imageFile =[docDir URLByAppendingPathComponent:fileName isDirectory:NO];
    }
    
    return imageFile;
}

+(UIImage *)imageFromURL:(NSURL *)fileName
{
    UIImage *image;
    NSFileManager *fileMgr = [NSFileManager defaultManager];
    NSString *p= [fileName path];
    //fileMgr
    if ([fileMgr fileExistsAtPath:p]){
        image = [UIImage imageWithContentsOfFile:[fileName path]];
    }
    return image;
}

+(NSString *)mediumDateString:(NSDate *) date
{
    if(date){
        NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
        [formatter setDateStyle:NSDateFormatterMediumStyle];
        [formatter setTimeStyle:NSDateFormatterMediumStyle];
        return [formatter stringFromDate:date];
    }
    else
    {
        return EMPTY_NSSTRING;
    }
}


+(NSString *)dataBaseDateString:(NSDate *)date
{
    if(date){
        NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
        [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss.sss"];
        return [formatter stringFromDate:date];
    }
    else
    {
        return EMPTY_NSSTRING;
    }
}

+(NSDate *)dateFromDatabaseString:(NSString *)dateStr
{
    if(dateStr)
    {
        NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
        [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss.sss"];
        return [formatter dateFromString:dateStr];
    }
    else{
        return nil;
    }
}

+(NSString *)formatMinutes:(NSNumber *)minutes
{
    
    NSString *timeDuration;

    int _hours = [minutes intValue] / 60;
    int _minutes = [minutes intValue] % 60;
    int _seconds = ([minutes doubleValue] - [minutes intValue]) * 60;

    timeDuration = [NSString stringWithFormat:@"%dhr %dmin %dsec",_hours,_minutes,_seconds];
    
    return timeDuration;
}

+(BOOL)isIpad{
    return [UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPad;
}



@end
