//
//  CourseDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/13/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "CourseDAO.h"

@implementation CourseDAO

- (void) initDb
{
    [super initDb];
}

- (NSInteger) addCourse:(Course *)course
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    NSInteger id = -1;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * insertSQL = [NSString stringWithFormat:
                                @"INSERT INTO COURSES (NAME, LAT, LON, IS_SELECTED) VALUES (\"%@\", \"%ld\", \"%ld\", \"%d\")",
                                course.name, (long) course.lat, (long) course.lon, course.isSelected ? 1:0];
        
        const char * insert_stmt = [insertSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, insert_stmt, -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Added new course to DB.");
            id = (int) sqlite3_last_insert_rowid(golfrDB);
        }
        else
        {
            NSLog(@"Failed to add course to DB");
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    
    return id;
}

// Return nil if no courses found
- (NSMutableArray *) getCourses
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * courses = [NSMutableArray array];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSES"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                Course * c = [Course alloc];
                [c setCourseId:sqlite3_column_int(statement, 0)];
                [c setName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [c setLat:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setLon:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setIsSelected:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue] == 1 ? YES:NO];
                [courses addObject:c];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return courses;
}

// Returns nil if player is not found
- (Course *) getCourse:(int)id
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    Course * c = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSES WHERE ID = %i", id];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                c = [Course alloc];
                [c setCourseId:sqlite3_column_int(statement, 0)];
                [c setName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [c setLat:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setLon:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setIsSelected:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue] == 1 ? YES:NO];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    return c;
    
}

- (BOOL) updateCourse:(Course *)course
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:
                                @"REPLACE INTO COURSES (ID, NAME, LAT, LON, IS_SELECTED) VALUES (\"%i\", \"%@\", \"%ld\", \"%f\", \"%d\")",
                                (int) course.courseId, course.name, (long) course.lat, course.lon, course.isSelected ? 1:0];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Updated course in DB.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to update course to DB");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
    
}

- (BOOL) deleteCourse:(int)id
{
    BOOL success = false;
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * deleteSQL = [NSString stringWithFormat:@"DELETE from COURSES WHERE id = %i", id];
        
        const char * delete_stmt = [deleteSQL UTF8String];
        if (sqlite3_prepare_v2(golfrDB, delete_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                success = true;
            }
        }
        else
        {
            NSLog(@"Did not delete course with id %d", id);
            success = false;
        }
        
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

- (BOOL) clearIsSelectedFlag
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:@"UPDATE COURSES SET IS_SELECTED = 0"];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Cleared isSelected flag in courses table.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to clear isSelected flag in courses table.");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

- (Course *) getSelectedCourse
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    Course * c = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSES WHERE IS_SELECTED = 1"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                c = [Course alloc];
                [c setCourseId:sqlite3_column_int(statement, 0)];
                [c setName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [c setLat:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setLon:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setIsSelected:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue] == 1 ? YES:NO];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    return c;
    
}

@end
