//
//  CourseDetailDAO.h
//  holeinsome
//
//  Created by Antti Myllykoski on 2/28/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "GolfrDAO.h"
#import "CourseDetail.h"

@interface CourseDetailDAO : GolfrDAO

- (NSInteger) addCourseDetail:(CourseDetail *)courseDetail;

// Return an empty dictionary if no course details found
- (NSMutableArray *) getCourseDetails;
- (NSMutableDictionary *) getCourseDetails:(int)courseId;

// Returns nil if course detail is not found
- (CourseDetail *) getCourseDetail:(int)id;

- (CourseDetail *) getCourseDetail:(int)courseId teeColorId:(int)teeColorId;


- (BOOL) updateCourseDetail:(CourseDetail *)courseDetail;

- (BOOL) deleteCourseDetail:(int)id;

@end
