//
//  CourseDetailDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/28/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "CourseDetailDAO.h"

@implementation CourseDetailDAO

- (void) initDb
{
    [super initDb];
}

- (NSInteger) addCourseDetail:(CourseDetail *)courseDetail
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    NSInteger id = -1;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * insertSQL = [NSString stringWithFormat:
                                @"INSERT INTO COURSEDETAILS (COURSE_ID_FK, TEE_COLOR_ID_FK, PAR, SLOPE) VALUES (\"%i\", \"%i\", \"%f\", \"%f\")",
                                (int) courseDetail.courseId, (int) courseDetail.teeColorId, courseDetail.par, courseDetail.slope];
        
        const char * insert_stmt = [insertSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, insert_stmt, -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Added new course detail to DB.");
            id = (int) sqlite3_last_insert_rowid(golfrDB);
        }
        else
        {
            NSLog(@"Failed to add course detail to DB");
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    
    return id;
}

- (NSMutableArray *) getCourseDetails
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * courses = [[NSMutableArray alloc] init];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSEDETAILS"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                CourseDetail * c = [CourseDetail alloc];
                [c setCourseDetailId:sqlite3_column_int(statement, 0)];
                [c setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [c setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [c setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setSlope:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
                [courses addObject:c];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return courses;
}

- (NSMutableDictionary *) getCourseDetails:(int)courseId
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableDictionary * courses = [[NSMutableDictionary alloc] init];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSEDETAILS WHERE COURSE_ID_FK = %i", courseId];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                CourseDetail * c = [CourseDetail alloc];
                [c setCourseDetailId:sqlite3_column_int(statement, 0)];
                [c setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [c setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [c setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setSlope:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
                [courses setObject:c forKey:[NSString stringWithFormat:@"%li", (long) c.teeColorId]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return courses;
}


- (CourseDetail *) getCourseDetail:(int)id;
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    CourseDetail * c = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSEDETAILS WHERE ID = %i", id];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                c = [CourseDetail alloc];
                [c setCourseDetailId:sqlite3_column_int(statement, 0)];
                [c setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [c setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [c setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setSlope:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return c;
}

- (CourseDetail *) getCourseDetail:(int)courseId teeColorId:(int)teeColorId;
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    CourseDetail * c = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM COURSEDETAILS WHERE COURSE_ID_FK = %i AND TEE_COLOR_ID_FK = %i", courseId, teeColorId];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                c = [CourseDetail alloc];
                [c setCourseDetailId:sqlite3_column_int(statement, 0)];
                [c setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [c setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [c setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] doubleValue]];
                [c setSlope:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return c;
}

- (BOOL) updateCourseDetail:(CourseDetail *)courseDetail
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:
                                @"REPLACE INTO COURSEDETAILS (ID, COURSE_ID_FK, TEE_COLOR_ID_FK, PAR, SLOPE) VALUES (\"%i\", \"%i\", \"%i\", \"%f\", \"%f\")",
                                (int) courseDetail.courseDetailId, (int) courseDetail.courseId, (int) courseDetail.teeColorId, courseDetail.par, courseDetail.slope];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Updated course detail in DB.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to update course detail to DB");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

- (BOOL) deleteCourseDetail:(int)id
{
    BOOL success = false;
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * deleteSQL = [NSString stringWithFormat:@"DELETE from COURSEDETAILS WHERE COURSE_ID_FK = %i", id];
        
        const char * delete_stmt = [deleteSQL UTF8String];
        if (sqlite3_prepare_v2(golfrDB, delete_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                success = true;
            }
        }
        else
        {
            NSLog(@"Did not delete course detail with id %d", id);
            success = false;
        }
        
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}


@end
