//
//  CourseDetailViewController.m
//  holeinsome
//
//  Created by Antti Myllykoski on 3/9/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//


#import "CourseDetailViewController.h"
#import "Toast+UIView.h"
#import "HoleDAO.h"

@interface CourseDetailViewController ()
@property int currentHole;
@property int currentHcp;
@property HoleDAO * holeDAO;
@property NSMutableArray * holes;
@end

@implementation CourseDetailViewController

- (id) initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self)
    {
    }
    return self;
}

- (void) viewDidLoad
{
    [super viewDidLoad];
    if (_holeDAO == nil)
    {
        _holeDAO = [[HoleDAO alloc] init];
        [_holeDAO initDb];
    }
    
    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"background.png"]];
    _currentHole = 1;
    _currentHcp = 0;
    _currentHoleField.text = [NSString stringWithFormat:@"%i", _currentHole];
    _teeColorBox.layer.cornerRadius = 15;
    [_teeColorBox setBackgroundColor:[_teeColor getUIColorFromRGB]];
    _holes = [_holeDAO getHoles:(int) _courseId teeColorId:(int) _teeColor.teeColorId];
    
    Hole * h = [_holes objectAtIndex:_currentHole - 1];
    _currentHcp = (int) h.hcp;
    if (_currentHcp > 0)
    {
        [self updateHcpGrid:NO];
    }
    [self updateHeaderAfterScroll];
}


- (void) didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (void) viewWillDisappear:(BOOL)animated
{
    [self updateHole];
}

- (void) updateHcpGrid:(BOOL)shouldBeCleared
{
    if (shouldBeCleared && _currentHcp > 0)
    {
        ((UITextField *) [_hcpButton objectAtIndex:_currentHcp - 1]).backgroundColor = [UIColor clearColor];
        ((UITextField *) [_hcpButton objectAtIndex:_currentHcp - 1]).textColor = [UIColor whiteColor];
    }
    else if (!shouldBeCleared && _currentHcp > 0)
    {
        ((UITextField *) [_hcpButton objectAtIndex:_currentHcp - 1]).backgroundColor = [UIColor whiteColor];
        ((UITextField *) [_hcpButton objectAtIndex:_currentHcp - 1]).textColor = [UIColor grayColor];
    }
}

- (IBAction) onNumberTapped:(id)sender
{
    if (_currentHcp > 0)
    {
        [self updateHcpGrid:YES];
    }
    _currentHcp = (int) [sender tag];
    if (_currentHcp > 0)
    {
        [self updateHcpGrid:NO];
    }
    [self updateHeaderAfterEdit];
}

- (void) updateHole
{
    Hole * h = [_holes objectAtIndex:_currentHole - 1];
    int par = (int) [_parSegments selectedSegmentIndex];
    
    [h setPar:par == UISegmentedControlNoSegment ? 0:par + 3];
    if (_currentHcp > 0)
    {
        [h setHcp:_currentHcp];
    }
    [_holeDAO updateHole:h];
}

- (IBAction) onPrevTapped:(id)sender
{
    if (_currentHcp > 0)
    {
        [self updateHole];
    }
    
    if (_currentHole > 1)
    {
        [self updateHcpGrid:YES];
        _currentHole--;
        Hole * h = [_holes objectAtIndex:_currentHole - 1];
        _currentHcp = (int) h.hcp;
        [self scrollLeft];
        if (_currentHcp > 0)
        {
            [self updateHcpGrid:NO];
        }
        [self updateHeaderAfterScroll];
    }
    _currentHoleField.text = [NSString stringWithFormat:@"%i", (int) _currentHole];
}

- (IBAction) onNextTapped:(id)sender
{
    if (_currentHcp > 0)
    {
        [self updateHole];
    }
    else
    {
        [self toast:@"Hole Information Missing" msg:@"Please Give Par and Hcp Values"];
        return;
    }
    
    if (_currentHole < 18)
    {
        [self updateHcpGrid:YES];
        _currentHole++;
        Hole * h = [_holes objectAtIndex:_currentHole - 1];
        _currentHcp = (int) h.hcp;
        [self scrollRight];
        if (_currentHcp > 0)
        {
            [self updateHcpGrid:NO];
        }
        [self updateHeaderAfterScroll];
    }
    _currentHoleField.text = [NSString stringWithFormat:@"%i", (int) _currentHole];
}

- (void) updateHeaderAfterEdit
{
    NSString * par = nil;
    
    if ([_parSegments selectedSegmentIndex] == UISegmentedControlNoSegment)
    {
        par = @"N/A";
    }
    else
    {
        par = [NSString stringWithFormat:@"%i", (int) [_parSegments selectedSegmentIndex] + 3];
    }
    NSString * t = [NSString stringWithFormat:@"Hole %i: par %@, hcp %i", _currentHole, par, _currentHcp];
    
    self.navigationItem.title = t;
}

- (void) updateHeaderAfterScroll
{
    Hole * h = [_holes objectAtIndex:_currentHole - 1];
    
    _currentHcp = (int) h.hcp;
    NSInteger par = h.par;
    [_parSegments setSelectedSegmentIndex:par == 0 ? UISegmentedControlNoSegment:par - 3];
    
    NSString * parString = nil;
    if ([_parSegments selectedSegmentIndex] == UISegmentedControlNoSegment)
    {
        parString = @"N/A";
    }
    else
    {
        parString = [NSString stringWithFormat:@"%i", (int) [h par]];
    }
    
    NSString * t = [NSString stringWithFormat:@"Hole %i: par %@, hcp %i", _currentHole, parString, _currentHcp];
    self.navigationItem.title = t;
}

- (void) scrollLeft
{
    CATransition * animation = [CATransition animation];
    
    [animation setDelegate:self];
    [animation setType:kCATransitionPush];
    [animation setSubtype:kCATransitionFromLeft];
    [animation setDuration:0.40];
    [animation setTimingFunction:
     [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut]];
    [_mainView.layer addAnimation:animation forKey:kCATransition];
}

- (void) scrollRight
{
    CATransition * animation = [CATransition animation];
    
    [animation setDelegate:self];
    [animation setType:kCATransitionPush];
    [animation setSubtype:kCATransitionFromRight];
    [animation setDuration:0.50];
    [animation setTimingFunction:
     [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut]];
    [_mainView.layer addAnimation:animation forKey:kCATransition];
}

- (void) toast:(NSString *)title msg:(NSString *)msg
{
    [self.view makeToast:msg
                duration:3.0
                position:@"center"
                   title:title];
}



@end
