//
//  CourseViewController.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/1/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "CourseViewController.h"
#import "TeeColorDAO.h"
#import "CourseDAO.h"
#import "CourseDetailDAO.h"
#import "CourseDetailViewController.h"
#import "CourseWrapper.h"
#import "Toast+UIView.h"

@interface CourseViewController ()
@property NSInteger currentTeeColor;
@property NSInteger currentHole;
@property NSInteger currentPar;
@property CourseWrapper * cw;
@end

@implementation CourseViewController

- (void) viewDidLoad
{
    [super viewDidLoad];
    [self initVariables];
    [self initSwipers];
}

- (void) initSwipers
{
    UISwipeGestureRecognizer * rightRecognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:self action:@selector(rightSwipeHandler:)];
    
    [rightRecognizer setDirection:(UISwipeGestureRecognizerDirectionRight)];
    [self.view addGestureRecognizer:rightRecognizer];
    UISwipeGestureRecognizer * leftRecognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:self action:@selector(leftSwipeHandler:)];
    [leftRecognizer setDirection:(UISwipeGestureRecognizerDirectionLeft)];
    [_swipeView addGestureRecognizer:leftRecognizer];
}

- (void) updateViewWithCurrentTeeColor
{
    _teeColorNameLabel.text = [_cw getTeeColorName:_currentTeeColor];
    [_teeColorField setBackgroundColor:[_cw getTeeColor:_currentTeeColor]];
    _teeColorField.layer.cornerRadius = 16;
    _slopeField.text = [_cw getSlope:_currentTeeColor];
    _courseParField.text = [_cw getPar:_currentTeeColor];
    [_cw displayParValuesForHoles:_parFields teeColorId:_currentTeeColor];
    [_cw displayHcpValuesForHoles:_hcpFields teeColorId:_currentTeeColor];
}

- (void) initVariables
{
    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"background.png"]];
    _currentTeeColor = 1;
    _currentHole = 0;     // index, add 1 for right hole
    _courseNameField.delegate = self;
    _slopeField.delegate = self;
    _courseParField.delegate = self;
    _cw = [[CourseWrapper alloc]initWithCourseId:_selectedCourseId];
    _courseNameField.text = [_cw getCourseName];
    [self updateViewWithCurrentTeeColor];
}

- (void) viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self updateViewWithCurrentTeeColor];
}

- (void) scrollLeft
{
    CATransition * animation = [CATransition animation];
    
    [animation setDelegate:self];
    [animation setType:kCATransitionPush];
    [animation setSubtype:kCATransitionFromLeft];
    [animation setDuration:0.40];
    [animation setTimingFunction:
     [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut]];
    [_swipeView.layer addAnimation:animation forKey:kCATransition];
}

- (void) rightSwipeHandler:(UISwipeGestureRecognizer *)recognizer
{
    if (_currentTeeColor > 1)
    {
        _currentTeeColor--;
        [self scrollLeft];
        [self updateViewWithCurrentTeeColor];
    }
}

- (void) scrollRight
{
    CATransition * animation = [CATransition animation];
    
    [animation setDelegate:self];
    [animation setType:kCATransitionPush];
    [animation setSubtype:kCATransitionFromRight];
    [animation setDuration:0.50];
    [animation setTimingFunction:
     [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut]];
    [_swipeView.layer addAnimation:animation forKey:kCATransition];
}

- (void) leftSwipeHandler:(UISwipeGestureRecognizer *)recognizer
{
    if (_currentTeeColor < [_cw getTeeColorCount] - 1)
    {
        _currentTeeColor++;
        [self scrollRight];
        [self updateViewWithCurrentTeeColor];
    }
}

- (void) didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    for (UIView * txt in self.view.subviews)
    {
        if ([txt isKindOfClass:[UITextField class]] && [txt isFirstResponder])
        {
            [txt resignFirstResponder];
        }
    }
}

- (void) prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    CourseDetailViewController * vc = [segue destinationViewController];
    
    [vc setTeeColor:[_cw getTeeColorObject:_currentTeeColor]];
    [vc setCourseId:_selectedCourseId];
}

- (IBAction) saveOrUpdateCourseDetails:(id)sender
{
    if (![self fieldsValidatedOk])
    {
        NSLog(@"Fields not ok -- toast to come");
        return;
    }
    
    if (_selectedCourseId == -1)
    {
        Course * c = [[Course alloc] initWithData:_courseNameField.text lat:0. lon:0. isSelected:NO];
        _selectedCourseId = [_cw addCourse:c];
    }
    
    [_cw setCourseName:_courseNameField.text];
    
    if ([_slopeField.text length] > 0)
    {
        [_cw setSlopeForTeeColor:_currentTeeColor slope:[_slopeField.text doubleValue]];
    }
    
    if ([_courseParField.text length] > 0)
    {
        [_cw setParForTeeColor:_currentTeeColor par:[_courseParField.text doubleValue]];
    }
    [_cw setParValuesForHoles:_parFields teeColorId:_currentTeeColor];
    [_cw setHcpValuesForHoles:_hcpFields teeColorId:_currentTeeColor];
    [_cw updateCourse:_currentTeeColor];
}

- (void) viewWillDisappear:(BOOL)animated
{
    if (_selectedCourseId != -1)
    {
        [self saveOrUpdateCourseDetails:self];
    }
}

-(BOOL)textFieldShouldReturn:(UITextField*)textField;
{
    NSInteger nextTag = textField.tag + 1;
    UIResponder* nextResponder = [textField.superview viewWithTag:nextTag];
    if (nextResponder) {
        [nextResponder becomeFirstResponder];
    } else {
        [textField resignFirstResponder];
    }
    return NO;
}

- (BOOL) fieldsValidatedOk
{
    return [_courseNameField.text length] > 0;
    //    ; &&
    //            ([_slopeField.text length] > 0) &&
    //            ([_courseParField.text length] > 0);
}

- (void) toast:(NSString *)title msg:(NSString *)msg
{
    [self.view makeToast:msg
                duration:3.0
                position:@"center"
                   title:title];
}

- (IBAction) onAddCourseDetailButton:(id)sender
{
    if ([_courseNameField.text length] == 0)
    {
        [self toast:@"Course Name Missing" msg:@"Please Give the Golf Course Name."];
        return;
    }
    else
    {
        if (_selectedCourseId < 1)
        {
            [self toast:@"Creating Golf Course" msg:@"Please Wait a Sec..."];
            Course * c = [[Course alloc] init];
            [c setName:_courseNameField.text];
            [c setCourseId:-1];
            [c setLat:0];
            [c setLon:0];
            _selectedCourseId = [_cw addCourse:c];
        }
        [self performSegueWithIdentifier:@"courseDetails" sender:self];
    }
}
@end
