//
//  CourseWrapper.h
//  holeinsome
//
//  Created by Antti Myllykoski on 2/28/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Course.h"
#import "CourseDetail.h"
#import "TeeColor.h"

@interface CourseWrapper : NSObject
- (id) initWithCourseId:(NSInteger)selectedCourseId;
- (NSString *) getCourseName;
- (NSInteger) getCourseId;
- (BOOL) isSelected;
- (NSString *) getTeeColorName:(NSInteger)teeColorId;
- (UIColor *) getTeeColor:(NSInteger)teeColorId;
- (NSString *) getSlope:(NSInteger)teeColorId;
- (NSString *) getPar:(NSInteger)teeColorId;
- (NSInteger) getTeeColorCount;
- (NSInteger) addCourse:(Course *)newCourse;
- (TeeColor *) getTeeColorObject:(NSInteger)teeColorId;
- (void) setCourseName:(NSString *)courseName;
- (BOOL) updateCourse:(NSInteger)teeColorId;
- (void) setSlopeForTeeColor:(NSInteger)teeColorId slope:(double)slope;
- (void) setParForTeeColor:(NSInteger)teeColorId par:(double)par;
- (void) setParValuesForHoles:(NSArray *)parFields teeColorId:(NSInteger)teeColorId;
- (void) setHcpValuesForHoles:(NSArray *)hcpFields teeColorId:(NSInteger)teeColorId;
- (void) displayParValuesForHoles:(NSArray *)parFields teeColorId:(NSInteger)teeColorId;
- (void) displayHcpValuesForHoles:(NSArray *)hcpFields teeColorId:(NSInteger)teeColorId;
@end
