//
//  CourseWrapper.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/28/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "CourseWrapper.h"
#import "TeeColorDAO.h"
#import "CourseDAO.h"
#import "CourseDetailDAO.h"
#import "HoleDAO.h"


@implementation CourseWrapper {}

TeeColorDAO * teeColorDAO;
NSMutableArray * teeColors; // key: teeColorId, value: course detail
CourseDAO * courseDAO;
CourseDetailDAO * courseDetailDAO;
NSMutableDictionary * courseDetails;
Course * course;
NSInteger courseId;
HoleDAO * holeDAO;
NSMutableDictionary * holes;  // key: teeColorId, value: 18 holes array

- (id) initWithCourseId:(NSInteger)selectedCourseId
{
    self = [super init];
    [self initCourse:selectedCourseId];
    [self initTeeColors];
    [self initCourseDetails];
    [self initHoles];
    return self;
}

- (void) initCourse:(NSInteger)selectedCourseId
{
    courseId = selectedCourseId;
    if (courseDAO == nil)
    {
        courseDAO = [[CourseDAO alloc] init];
        [courseDAO initDb];
    }
    course = [[Course alloc] init];
    
    if (courseId >= 0)
    {
        course = [courseDAO getCourse:(int) courseId];
    }
    else
    {
        course.courseId = selectedCourseId;
    }
}

- (void) initTeeColors
{
    if (teeColorDAO == nil)
    {
        teeColorDAO = [[TeeColorDAO alloc] init];
        [teeColorDAO initDb];
    }
    teeColors = [teeColorDAO getTeeColors];
    [teeColors insertObject:[[TeeColor alloc] init] atIndex:0];
}

- (void) initCourseDetails
{
    if (courseDetailDAO == nil)
    {
        courseDetailDAO = [[CourseDetailDAO alloc] init];
        [courseDetailDAO initDb];
    }
    courseDetails = [courseDetailDAO getCourseDetails:(int) courseId];
}

- (void) initHoles
{
    holes = [[NSMutableDictionary alloc] init];
    if (holeDAO == nil)
    {
        holeDAO = [[HoleDAO alloc] init];
        [holeDAO initDb];
    }
    
    if (courseId >= 0)
    {
        for (TeeColor * t in teeColors)
        {
            NSMutableArray * holesForATeeColor = [holeDAO getHoles:(int) courseId teeColorId:(int) t.teeColorId];
            [holes setObject:holesForATeeColor forKey:[NSString stringWithFormat:@"%li", (long) t.teeColorId]];
        }
    }
}

- (NSString *) getCourseName
{
    return course.name;
}

- (NSInteger) getCourseId
{
    return course.courseId;
}

- (BOOL) isSelected
{
    return course.isSelected;
}

// - (CourseDetail *) getCourseDetail:(NSInteger)teeColorId
// {
//    return [courseDetails objectForKey:[NSString stringWithFormat:@"%i", teeColorId]];
// }

- (NSString *) getTeeColorName:(NSInteger)teeColorId
{
    for (TeeColor * t in teeColors)
    {
        if (t.teeColorId == teeColorId)
        {
            return t.teeColorName;
        }
    }
    return @" ";
}

- (UIColor *) getTeeColor:(NSInteger)teeColorId
{
    for (TeeColor * t in teeColors)
    {
        if (t.teeColorId == teeColorId)
        {
            return [t getUIColorFromRGB];
        }
    }
    return [UIColor clearColor];
}

- (NSString *) getSlope:(NSInteger)teeColorId
{
    CourseDetail * c = (CourseDetail *) [courseDetails objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    
    return [NSString stringWithFormat:@"%.01f", c.slope];
}

- (NSString *) getPar:(NSInteger)teeColorId
{
    CourseDetail * c = (CourseDetail *) [courseDetails objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    
    return [NSString stringWithFormat:@"%.01f", c.par];
}

- (NSInteger) getTeeColorCount
{
    return [teeColors count];
}

- (NSInteger) addCourse:(Course *)newCourse
{
    courseId = [courseDAO addCourse:newCourse];
    CourseDetail * c = nil;
    Hole * h = nil;
    
    for (TeeColor * t in teeColors)
    {
        if (t.teeColorId == 0) // This is a placeholder
        {
            continue;
        }
        
        c = [[CourseDetail alloc] init];
        [c setCourseId:courseId];
        [c setTeeColorId:t.teeColorId];
        [courseDetailDAO addCourseDetail:c];
        for (int i = 1; i <= 18; i++)
        {
            h = [[Hole alloc] init];
            [h setCourseId:courseId];
            [h setTeeColorId:[t teeColorId]];
            [h setPar:0];
            [h setHcp:0];
            [h setHoleNumber:i];
            [holeDAO addHole:h];
        }
        NSMutableArray * holesForATeeColor = [holeDAO getHoles:(int) courseId teeColorId:(int) t.teeColorId];
        [holes setObject:holesForATeeColor forKey:[NSString stringWithFormat:@"%i", (int) t.teeColorId]];
    }
    
    courseDetails = [courseDetailDAO getCourseDetails:(int) courseId];
    course = [courseDAO getCourse:(int) courseId];
    return courseId;
}


- (void) setCourseName:(NSString *)courseName
{
    course.name = courseName;
}

// Updates all course, coursedetails and holes -information
- (BOOL) updateCourse:(NSInteger)teeColorId
{
    BOOL retVal = [courseDAO updateCourse:course];
    
    for (id key in courseDetails)
    {
        id obj = [courseDetails objectForKey:key];
        retVal &= [courseDetailDAO updateCourseDetail:(CourseDetail *) obj];
    }
    NSArray * holesForTeeColor = [holes objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    for (Hole * h in holesForTeeColor)
    {
        retVal &= [holeDAO updateHole:h];
    }
    return retVal;
}

- (void) setSlopeForTeeColor:(NSInteger)teeColorId slope:(double)slope
{
    assert(courseId > 0);
    NSString * key = [NSString stringWithFormat:@"%i", (int) teeColorId];
    CourseDetail * c = [courseDetails objectForKey:key];
    if (!c)
    {
        NSLog(@"Did not find course detail for teeColorId: %i.", (int) teeColorId);
        return;
    }
    [c setSlope:slope];
    [courseDetails setObject:c forKey:key];
    [courseDetailDAO updateCourseDetail:c];
}

- (void) setParForTeeColor:(NSInteger)teeColorId par:(double)par
{
    assert(courseId > 0);
    NSString * key = [NSString stringWithFormat:@"%i", (int) teeColorId];
    CourseDetail * c = [courseDetails objectForKey:key];
    if (!c)
    {
        NSLog(@"Did not find course detail for teeColorId: %i.", (int) teeColorId);
        return;
    }
    [c setPar:par];
    [courseDetails setObject:c forKey:key];
    [courseDetailDAO updateCourseDetail:c];
}

- (void) setParValuesForHoles:(NSArray *)parFields teeColorId:(NSInteger)teeColorId
{
    NSArray * holesForTeeColor = [holes objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    int i = 0;
    
    for (id h in holesForTeeColor)
    {
        [(Hole *) h setPar :[((UITextField *) [parFields objectAtIndex:i++]).text integerValue]];
    }
}

- (void) setHcpValuesForHoles:(NSArray *)hcpFields teeColorId:(NSInteger)teeColorId
{
    NSArray * holesForTeeColor = [holes objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    int i = 0;
    
    for (id h in holesForTeeColor)
    {
        [(Hole *) h setHcp :[((UITextField *) [hcpFields objectAtIndex:i++]).text integerValue]];
    }
}

- (void) displayParValuesForHoles:(NSArray *)parFields teeColorId:(NSInteger)teeColorId
{
    NSMutableArray * holesForATeeColor = [holeDAO getHoles:(int) courseId teeColorId:(int) teeColorId];
    
    [holes setObject:holesForATeeColor forKey:[NSString stringWithFormat:@"%li", (long) teeColorId]];
    NSArray * holesForTeeColor = [holes objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    NSString * parValue = nil;
    int i = 0;
    
    for (id h in holesForTeeColor)
    {
        parValue = ((Hole *) h).par == 0 ? @" " : [NSString stringWithFormat:@"%i", (int) ((Hole *) h).par];
        ((UITextField *) [parFields objectAtIndex:i++]).text = parValue;
    }
}

- (void) displayHcpValuesForHoles:(NSArray *)hcpFields teeColorId:(NSInteger)teeColorId
{
    NSArray * holesForTeeColor = [holes objectForKey:[NSString stringWithFormat:@"%i", (int) teeColorId]];
    NSString * hcpValue = nil;
    int i = 0;
    
    for (id h in holesForTeeColor)
    {
        hcpValue = ((Hole *) h).hcp == 0 ? @" " : [NSString stringWithFormat:@"%i", (int) ((Hole *) h).hcp];
        ((UITextField *) [hcpFields objectAtIndex:i++]).text = hcpValue;
    }
}

- (TeeColor *) getTeeColorObject:(NSInteger)teeColorId
{
    if (teeColorDAO != nil )
    {
        return [teeColorDAO getTeeColor:(int) teeColorId];
    }
    else
    {
        teeColorDAO = [[TeeColorDAO alloc] init];
        [teeColorDAO initDb];
        return [teeColorDAO getTeeColor:(int) teeColorId];
    }
    return nil;
}
@end
