//
//  CoursesViewController.m
//  holeinsome
//
//  Created by Antti Myllykoski on 1/21/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "CoursesViewController.h"
#import "CourseViewController.h"
#import "CourseTableCell.h"
#import "CourseDAO.h"
#import "CourseDetailDAO.h"
#import "HoleDAO.h"

@interface CoursesViewController ()
@property NSMutableArray * courses;
@property CourseDAO * courseDAO;
@property CourseDetailDAO * courseDetailDAO;
@property HoleDAO * holeDAO;
@property NSInteger selectedCourseId;
@end

BOOL isCourseSelected;

@implementation CoursesViewController

- (void) viewDidLoad
{
    [super viewDidLoad];
    if (_courseDAO == nil)
    {
        _courseDAO = [[CourseDAO alloc] init];
        [_courseDAO initDb];
    }
    _courses = [_courseDAO getCourses];
    
    if ([_courseDAO getSelectedCourse] == nil)
    {
        isCourseSelected = NO;
    }
    else
    {
        isCourseSelected = YES;
    }
    
    if (_courseDetailDAO == nil)
    {
        _courseDetailDAO = [[CourseDetailDAO alloc] init];
        [_courseDetailDAO initDb];
    }
    
    if (_holeDAO == nil)
    {
        _holeDAO = [[HoleDAO alloc] init];
        [_holeDAO initDb];
    }
    _selectedCourseId = -1;
    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"background.png"]];
}

- (void) didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}


- (void) viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    _courses = [_courseDAO getCourses];
    [[self tableView] reloadData];
}

- (void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    for (UIView * txt in self.view.subviews)
    {
        if ([txt isKindOfClass:[UITextField class]] && [txt isFirstResponder])
        {
            [txt resignFirstResponder];
        }
    }
}

#pragma mark - Table View

- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [_courses count];
}

- (UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CourseTableCell * cell = [tableView dequeueReusableCellWithIdentifier:@"courseCell"];
    Course * c = (Course *) [_courses objectAtIndex:indexPath.row];
    
    cell.courseName.text = c.name;
    cell.courseId = c.courseId;
    if (c.isSelected)
    {
        _selectedCourseId = c.courseId;
    }
    [[cell courseSelectionSwitch] setOn:c.isSelected];
    return cell;
}

- (BOOL) tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
}

- (void) tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete)
    {
        Course * c = (Course *) [_courses objectAtIndex:indexPath.row];
        [_courseDAO deleteCourse:(int) [c courseId]];
        [_courseDetailDAO deleteCourseDetail:(int) [c courseId]];
        [_holeDAO deleteHoles:(int) [c courseId]];
        [_courses removeObjectAtIndex:indexPath.row];
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
        [[self tableView] reloadData];
    }
}

#pragma mark - Segue

- (void) prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if ([[segue identifier] isEqualToString:@"addCourse"])
    {
        CourseViewController * vc = [segue destinationViewController];
        [vc setSelectedCourseId:-1];
    }
    else if ([[segue identifier] isEqualToString:@"courseView"])
    {
        NSIndexPath * indexPath = [sender isKindOfClass:[NSIndexPath class]] ? (NSIndexPath *) sender : [self.tableView indexPathForSelectedRow];
        Course * c = [_courses objectAtIndex:[indexPath row]];
        CourseViewController * vc = [segue destinationViewController];
        [vc setSelectedCourseId:c.courseId];
    }
    //    else if ([[segue identifier] isEqualToString:@"toMain"])
    //    {
    //        int indexOfTableRow = (int) ((UITableViewCell *) sender).tag;
    //        [_courseDAO clearIsSelectedFlag];
    //        Course * c = [_courses objectAtIndex:indexOfTableRow];
    //        [c setIsSelected:YES];
    //        [_courseDAO updateCourse:c];
    //    }
}

@end
