//
//  GolfrDbDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/6/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//


#import "GolfrDAO.h"
#import "TeeColorDAO.h"

@interface GolfrDAO ()

@end

@implementation GolfrDAO

- (void) initDb
{
    NSString * docsDir;
    NSArray * dirPaths;
    
    // Get the documents directory
    dirPaths = NSSearchPathForDirectoriesInDomains(
                                                   NSDocumentDirectory, NSUserDomainMask, YES);
    
    docsDir = dirPaths[0];
    
    // Build the path to the database file
    databasePath = [[NSString alloc]
                    initWithString:[docsDir stringByAppendingPathComponent:
                                    @"golfr.db"]];
    
    NSFileManager * filemgr = [NSFileManager defaultManager];
    
    if ([filemgr fileExistsAtPath:databasePath ] == NO)
    {
        const char * dbpath = [databasePath UTF8String];
        char * errMsg;
        
        if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
        {
            char * sql_stmt = "CREATE TABLE IF NOT EXISTS PLAYERS (ID INTEGER PRIMARY KEY AUTOINCREMENT, \
            FIRST_NAME TEXT, LAST_NAME TEXT, IMAGE_PATH TEXT, EMAIL TEXT, USGA_HCP REAL, IS_RECENT INTEGER, TEE_COLOR_FK INTEGER, STROKES TEXT)";
            
            if (sqlite3_exec(golfrDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                NSLog(@"Failed to create table: PLAYERS");
            }
            
            sql_stmt = "CREATE TABLE IF NOT EXISTS COURSES (ID INTEGER PRIMARY KEY AUTOINCREMENT, \
            NAME TEXT, LAT REAL, LON REAL, IS_SELECTED INTEGER)";
            
            if (sqlite3_exec(golfrDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                NSLog(@"Failed to create table: COURSES");
            }
            
            sql_stmt = "CREATE TABLE IF NOT EXISTS HOLES (ID INTEGER PRIMARY KEY AUTOINCREMENT, \
            COURSE_ID_FK INTEGER, TEE_COLOR_ID_FK INTEGER, PAR INTEGER, HCP INTEGER, HOLE_NUMBER INTEGER)";
            
            if (sqlite3_exec(golfrDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                NSLog(@"Failed to create table: HOLES");
            }
            
            sql_stmt = "CREATE TABLE IF NOT EXISTS TEECOLORS (ID INTEGER PRIMARY KEY AUTOINCREMENT, \
            TEE_COLOR_NAME TEXT, TEE_COLOR_RGB TEXT)";
            
            if (sqlite3_exec(golfrDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                NSLog(@"Failed to create table: HOLES");
            }
            
            sql_stmt = "CREATE TABLE IF NOT EXISTS COURSEDETAILS (ID INTEGER PRIMARY KEY AUTOINCREMENT, \
            COURSE_ID_FK INTEGER, TEE_COLOR_ID_FK INTEGER, PAR REAL, SLOPE REAL)";
            
            if (sqlite3_exec(golfrDB, sql_stmt, NULL, NULL, &errMsg) != SQLITE_OK)
            {
                NSLog(@"Failed to create table: HOLES");
            }
            
            
            sqlite3_close(golfrDB);
        }
        else
        {
            NSLog(@"Failed to open/create database");
        }
        
        [self insertDefaultTeeColors];
    }
}

- (void) insertDefaultTeeColors
{
    TeeColorDAO * db = [[TeeColorDAO alloc] init];
    
    [db initDb];
    
    TeeColor * t = [TeeColor alloc];
    [t setTeeColorName:@"White"];
    [t setRgbInHex:@"0xFFFFFF"];
    [db addTeeColor:t];
    
    [t setTeeColorName:@"Blue"];
    [t setRgbInHex:@"0x0000CD"];
    [db addTeeColor:t];
    
    [t setTeeColorName:@"Red"];
    [t setRgbInHex:@"0xB22222"];
    [db addTeeColor:t];
    
    [t setTeeColorName:@"Black"];
    [t setRgbInHex:@"0x000000"];
    [db addTeeColor:t];
    
    [t setTeeColorName:@"Yellow"];
    [t setRgbInHex:@"0xFFFF00"];
    [db addTeeColor:t];
}
@end
