//
//  HoleDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/28/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "HoleDAO.h"

@implementation HoleDAO

- (void) initDb
{
    [super initDb];
}

- (NSInteger) addHole:(Hole *)hole
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    NSInteger id = -1;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * insertSQL = [NSString stringWithFormat:
                                @"INSERT INTO HOLES (COURSE_ID_FK, TEE_COLOR_ID_FK, PAR, HCP, HOLE_NUMBER) VALUES (\"%li\", \"%li\", \"%li\", \"%ld\", \"%li\")",
                                (long) hole.courseId, (long) hole.teeColorId, (long) hole.par, (long) hole.hcp, (long) hole.holeNumber];
        
        const char * insert_stmt = [insertSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, insert_stmt, -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Added new hole to DB.");
            id = (int) sqlite3_last_insert_rowid(golfrDB);
        }
        else
        {
            NSLog(@"Failed to add hole to DB");
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    
    return id;
}

- (NSMutableArray *) getHoles
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * holes = [[NSMutableArray alloc] init];
    Hole * h;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM HOLES"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                h = [Hole alloc];
                [h setHoleId:sqlite3_column_int(statement, 0)];
                [h setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [h setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [h setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHoleNumber:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] integerValue]];
                [holes addObject:h];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return holes;
}

- (NSMutableArray *) getHoles:(int)courseId teeColorId:(int)teeColorId
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * holes = [[NSMutableArray alloc] init];
    Hole * h = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM HOLES WHERE COURSE_ID_FK = %i AND TEE_COLOR_ID_FK = %i", courseId, teeColorId];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                h = [Hole alloc];
                [h setHoleId:sqlite3_column_int(statement, 0)];
                [h setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [h setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [h setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHoleNumber:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] integerValue]];
                [holes addObject:h];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return holes;
}

- (Hole *) getHole:(int)courseId teeColorId:(int)teeColorId holeNumber:(int)holeNumber
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    Hole * h = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM HOLES WHERE COURSE_ID_FK = %i AND TEE_COLOR_ID_FK = %i AND HOLE_NUMBER = %i", courseId, teeColorId, holeNumber];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                h = [Hole alloc];
                [h setHoleId:sqlite3_column_int(statement, 0)];
                [h setCourseId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding] integerValue]];
                [h setTeeColorId:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding] integerValue]];
                [h setPar:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding] integerValue]];
                [h setHoleNumber:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] integerValue]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return h;
}


- (BOOL) updateHole:(Hole *)hole
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:
                                @"REPLACE INTO HOLES (ID, COURSE_ID_FK, TEE_COLOR_ID_FK, PAR, HCP, HOLE_NUMBER) VALUES (\"%li\", \"%li\", \"%li\", \"%li\", \"%li\", \"%li\")",
                                (long) hole.holeId,  (long) hole.courseId, (long) hole.teeColorId, (long) hole.par, (long) hole.hcp, (long) hole.holeNumber];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Updated holes in DB.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to update holes to DB");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

- (BOOL) deleteHoles:(int)id
{
    BOOL success = false;
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * deleteSQL = [NSString stringWithFormat:@"DELETE from HOLES WHERE COURSE_ID_FK = %i", id];
        
        const char * delete_stmt = [deleteSQL UTF8String];
        if (sqlite3_prepare_v2(golfrDB, delete_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                success = true;
            }
        }
        else
        {
            NSLog(@"Did not delete holes with id %d", id);
            success = false;
        }
        
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

@end
