//
//  MainViewController.h
//  holeinsome
//
//  Created by Antti Myllykoski on 2/19/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import <UIKit/UIKit.h>

@class HorizontalPickerView;

@interface MainViewController : UIViewController <UITableViewDataSource, UITableViewDelegate>

@property (weak, nonatomic) IBOutlet UITextField * parField;
@property (weak, nonatomic) IBOutlet UILabel * courseNameLabel;
@property (weak, nonatomic) IBOutlet UITableView * tableView;
@property (weak, nonatomic) IBOutlet UITextField * currentHoleField;
@property (weak, nonatomic) IBOutlet UIView * swipeView;

// Collections for tee color -specific par and hcp for current hole. Order:
// upper left, upper righ, lower left and lower right.
@property (strong, nonatomic)IBOutletCollection(UILabel) NSArray * parLabel;
@property (strong, nonatomic)IBOutletCollection(UILabel) NSArray * hcpLabel;
@property (strong, nonatomic)IBOutletCollection(UITextField) NSArray * parText;
@property (strong, nonatomic)IBOutletCollection(UITextField) NSArray * hcpText;
@property (strong, nonatomic)IBOutletCollection(UITextField) NSArray * teeColorBox;
@property (weak, nonatomic) IBOutlet UIBarButtonItem * scoreCardButton;

- (IBAction) onLeftUpperParHcp:(id)sender;
- (IBAction) onRightUpperParHcp:(id)sender;
- (IBAction) onLeftLowerParHcp:(id)sender;
- (IBAction) onRightLowerParHcp:(id)sender;
- (IBAction) onCourseNameTapped:(id)sender;

+ (int) highestHolePlayed;

@end
