//
//  Player.h
//  holeinsome
//
//  Created by Antti Myllykoski on 1/21/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface Player : NSObject
@property NSString * firstName;
@property NSString * lastName;
@property NSString * imagePath;
@property NSString * email;
@property NSInteger playerId;
@property NSInteger teeColor;
@property double hdcp;
@property BOOL isRecent;

- (id) initWithData:(NSString *)firstName lastName:(NSString *)lastName imagePath:(NSString *)imagePath email:(NSString *)email hdcp:(double)hdcp teeColor:(NSInteger)teeColor;
- (void) setStrokes:(NSString *)strokes forHole:(NSString *)forHole;
- (NSString *) getStrokesForHole:(NSInteger)forHole;
- (void) resetStrokes;
- (void) setStrokesForAllHoles:(NSString *)base64Json;
- (NSString *) getStrokesJsonInBase64;
@end
