//
//  Player.m
//  holeinsome
//
//  Created by Antti Myllykoski on 1/21/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "Player.h"

@implementation Player {
    NSMutableDictionary * strokesDict;
}

- (id) init
{
    self = [super init];
    strokesDict = [[NSMutableDictionary alloc] init];
    for (int i = 1; i <= 18; i++)
    {
        [strokesDict setObject:@"4" forKey:[NSString stringWithFormat:@"%i", i]];
    }
    return self;
}

- (id) initWithData:(NSString *)firstName lastName:(NSString *)lastName imagePath:(NSString *)imagePath email:(NSString *)email hdcp:(double)hdcp teeColor:(NSInteger)teeColor
{
    self = [super init];
    _firstName = [firstName copy];
    _lastName  = [lastName copy];
    _imagePath = [imagePath copy];
    _email = [email copy];
    _hdcp = hdcp;
    _teeColor = teeColor;
    _playerId = -1;
    _isRecent = NO;
    strokesDict = [[NSMutableDictionary alloc] init];
    for (int i = 1; i <= 18; i++)
    {
        [strokesDict setObject:@"4" forKey:[NSString stringWithFormat:@"%i", i]];
    }
    return self;
}

- (NSString *) description
{
    return [NSString stringWithFormat:@"\nID: %ld \nFirst name: %@\nLast name: %@\nImage path: %@\nEmail: %@\nHCP = %3.2f\nIsRecent = %s\nTeeColor = %li\nStrokes = %@", (long) _playerId, _firstName, _lastName, _imagePath, _email, _hdcp, _isRecent ? "YES":"NO", (long) _teeColor, [self getStrokesJsonInBase64]];
}

- (NSString *) getStrokesJsonInBase64
{
    NSError * writeError = nil;
    NSData * jsonData = [NSJSONSerialization dataWithJSONObject:strokesDict options:NSJSONWritingPrettyPrinted error:&writeError];
    NSString * jsonString = [jsonData base64EncodedStringWithOptions:0];
    
    return jsonString;
}

- (void) setStrokes:(NSString *)strokes forHole:(NSString *)forHole
{
    assert(strokesDict != Nil);
    [strokesDict setObject:strokes forKey:forHole];
}

- (NSString *) getStrokesForHole:(NSInteger)forHole
{
    return [strokesDict objectForKey:[NSString stringWithFormat:@"%i", (int) forHole]];
}

- (void) resetStrokes
{
    strokesDict = [[NSMutableDictionary alloc] init];
    for (int i = 1; i <= 18; i++)
    {
        [strokesDict setObject:@"0" forKey:[NSString stringWithFormat:@"%i", i]];
    }
    [self getStrokesJsonInBase64];
}

- (void) setStrokesForAllHoles:(NSString *)base64Json
{
    NSData * decodedData = [[NSData alloc] initWithBase64EncodedString:base64Json options:0];
    // NSString * decodedString = [[NSString alloc] initWithData:decodedData encoding:NSUTF8StringEncoding];
    // NSLog(@"Decoded string %@ ", decodedString);
    NSError * err = nil;
    
    strokesDict = [NSJSONSerialization JSONObjectWithData:decodedData options:NSJSONReadingMutableContainers error:&err];
    NSLog(@"strokesDict  %@ ", strokesDict.description);
}

@end
