//
//  PlayerDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/6/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "PlayerDAO.h"

@implementation PlayerDAO

- (void) initDb
{
    [super initDb];
}

- (NSInteger) addPlayer:(Player *)player
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    NSInteger id = -1;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * insertSQL = [NSString stringWithFormat:
                                @"INSERT INTO PLAYERS (FIRST_NAME, LAST_NAME, IMAGE_PATH, EMAIL, USGA_HCP, IS_RECENT, TEE_COLOR_FK, STROKES) VALUES (\"%@\", \"%@\", \"%@\", \"%@\", \"%f\", \"%f\", \"%li\", \"%@\")",
                                player.firstName, player.lastName, player.imagePath, player.email, player.hdcp, player.isRecent ? 1.0:0, (long) player.teeColor, [player getStrokesJsonInBase64]];
        
        const char * insert_stmt = [insertSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, insert_stmt, -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Added new player to DB.");
            id = (int) sqlite3_last_insert_rowid(golfrDB);
        }
        else
        {
            NSLog(@"Failed to add player to DB");
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    
    return id;
}

- (NSMutableArray *) getPlayers
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * players = [NSMutableArray array];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM PLAYERS"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                Player * p = [[Player alloc] init];
                [p setPlayerId:sqlite3_column_int(statement, 0)];
                [p setFirstName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [p setLastName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
                [p setImagePath:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding]];
                [p setEmail:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding]];
                [p setHdcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] doubleValue]];
                [p setIsRecent:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 6) encoding:NSUTF8StringEncoding] doubleValue] == 1.0 ? YES:NO];
                [p setTeeColor:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 7) encoding:NSUTF8StringEncoding] intValue]];
                [p setStrokesForAllHoles:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 8) encoding:NSUTF8StringEncoding]];
                [players addObject:p];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return players;
}


- (NSMutableArray *) getPlayersNotOnScorecard
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * players = [NSMutableArray array];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM PLAYERS WHERE IS_RECENT = 0"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                Player * p = [[Player alloc] init];
                [p setPlayerId:sqlite3_column_int(statement, 0)];
                [p setFirstName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [p setLastName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
                [p setImagePath:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding]];
                [p setEmail:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding]];
                [p setHdcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] doubleValue]];
                [p setIsRecent:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 6) encoding:NSUTF8StringEncoding] intValue] == 1 ? YES:NO];
                [p setTeeColor:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 7) encoding:NSUTF8StringEncoding] intValue]];
                [p setStrokesForAllHoles:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 8) encoding:NSUTF8StringEncoding]];
                [players addObject:p];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return players;
}



- (NSMutableArray *) getPlayersOnScorecard
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * players = [NSMutableArray array];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM PLAYERS WHERE IS_RECENT = 1"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                Player * p = [[Player alloc] init];
                [p setPlayerId:sqlite3_column_int(statement, 0)];
                [p setFirstName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [p setLastName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
                [p setImagePath:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding]];
                [p setEmail:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding]];
                [p setHdcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] doubleValue]];
                [p setIsRecent:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 6) encoding:NSUTF8StringEncoding] intValue] == 1 ? YES:NO];
                [p setTeeColor:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 7) encoding:NSUTF8StringEncoding] intValue]];
                [p setStrokesForAllHoles:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 8) encoding:NSUTF8StringEncoding]];
                [players addObject:p];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    return players;
}

- (Player *) getPlayer:(int)id
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    Player * p = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM PLAYERS WHERE ID = %i", id];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                p = [[Player alloc] init];
                [p setPlayerId:sqlite3_column_int(statement, 0)];
                [p setFirstName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [p setLastName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
                [p setImagePath:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 3) encoding:NSUTF8StringEncoding]];
                [p setEmail:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 4) encoding:NSUTF8StringEncoding]];
                [p setHdcp:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 5) encoding:NSUTF8StringEncoding] doubleValue]];
                [p setIsRecent:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 6) encoding:NSUTF8StringEncoding] doubleValue] == 1.0 ? YES:NO];
                [p setTeeColor:[[NSString stringWithCString:(char *) sqlite3_column_text(statement, 7) encoding:NSUTF8StringEncoding] intValue]];
                [p setStrokesForAllHoles:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 8) encoding:NSUTF8StringEncoding]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    return p;
}

- (BOOL) updatePlayer:(Player *)player
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:
                                @"REPLACE INTO PLAYERS (ID, FIRST_NAME, LAST_NAME, IMAGE_PATH, EMAIL, USGA_HCP, IS_RECENT, TEE_COLOR_FK, STROKES) VALUES (\"%i\", \"%@\", \"%@\", \"%@\", \"%@\", \"%f\", \"%d\", \"%li\", \"%@\")",
                                (int) player.playerId, player.firstName, player.lastName, player.imagePath, player.email, player.hdcp, player.isRecent ? 1:0, (long) player.teeColor, player.getStrokesJsonInBase64];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Updated player in DB.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to update player to DB");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

- (BOOL) deletePlayer:(int)id
{
    BOOL success = false;
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * deleteSQL = [NSString stringWithFormat:@"DELETE from PLAYERS WHERE id = %i", id];
        
        const char * delete_stmt = [deleteSQL UTF8String];
        if (sqlite3_prepare_v2(golfrDB, delete_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                success = true;
            }
        }
        else
        {
            NSLog(@"Did not delete player with id %d", id);
            success = false;
        }
        
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

@end
