//
//  PlayerTableCell.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/20/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "PlayerTableCell.h"
#import "PlayerDAO.h"

@implementation PlayerTableCell

- (id) initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self)
    {
        // Initialization code
    }
    return self;
}

- (void) setSelected:(BOOL)selected animated:(BOOL)animated
{
    [super setSelected:selected animated:animated];
}

- (IBAction) choosePlayer:(id)sender
{
    if (nbrOfSelectedPlayers == 4 && [_playerSelectionSwitch isOn])
    {
        [_playerSelectionSwitch setOn:NO];
        return;
    }
    
    PlayerDAO * playerDAO;
    playerDAO = [[PlayerDAO alloc] init];
    [playerDAO initDb];
    Player * p = [playerDAO getPlayer:(int) _playerId];
    if ([_playerSelectionSwitch isOn])
    {
        nbrOfSelectedPlayers++;
        [p setIsRecent:YES];
        [playerDAO updatePlayer:p];
    }
    else
    {
        nbrOfSelectedPlayers--;
        [p setIsRecent:NO];
        [playerDAO updatePlayer:p];
    }
    NSLog(@"Nbr of players selected %li.", (long) nbrOfSelectedPlayers);
    
}
@end
