//
//  PlayersViewController.m
//  holeinsome
//
//  Created by Antti Myllykoski on 1/21/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "PlayersViewController.h"
#import "PlayerViewController.h"
#import "MainViewController.h"
#import "PlayerDAO.h"
#import "PlayerTableCell.h"
#import "Toast+UIView.h"

@interface PlayersViewController ()
@property NSMutableArray * players;
@property PlayerDAO * playerDAO;
@end

NSInteger nbrOfSelectedPlayers;

@implementation PlayersViewController

- (void) viewDidLoad
{
    [super viewDidLoad];
    if (_playerDAO == nil)
    {
        _playerDAO = [[PlayerDAO alloc] init];
        [_playerDAO initDb];
    }
    _players = [_playerDAO getPlayers];
    
    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"background.png"]];
}

- (void) didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (void) viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    nbrOfSelectedPlayers = [[_playerDAO getPlayersOnScorecard] count];
    _players = [_playerDAO getPlayers];
    [[self tableView] reloadData];
}

#pragma mark - Table View

- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [_players count];
}

- (UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PlayerTableCell * cell = [tableView dequeueReusableCellWithIdentifier:@"playerCell"];
    Player * p = (Player *) [_players objectAtIndex:indexPath.row];
    
    cell.firstName.text = p.firstName;
    cell.lastName.text = p.lastName;
    cell.playerId = p.playerId;
    [[cell playerSelectionSwitch] setOn:p.isRecent];
    
    if (p.imagePath.length > 0)
    {
        NSString * imageFilePath = [NSHomeDirectory() stringByAppendingPathComponent:p.imagePath];
        cell.image.image = [UIImage imageWithContentsOfFile:imageFilePath];
    }
    else
    {
        cell.image.image = [UIImage imageNamed:@"golf_hat.png"];
    }
    
    return cell;
}

- (void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    for (UIView * txt in self.view.subviews)
    {
        if ([txt isKindOfClass:[UITextField class]] && [txt isFirstResponder])
        {
            [txt resignFirstResponder];
        }
    }
}

- (BOOL) tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
}

- (void) tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete)
    {
        Player * p = (Player *) [_players objectAtIndex:indexPath.row];
        [_playerDAO deletePlayer:(int) [p playerId]];
        [_players removeObjectAtIndex:indexPath.row];
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
        nbrOfSelectedPlayers = [[_playerDAO getPlayersOnScorecard] count];
        [[self tableView] reloadData];
    }
}

- (void) tableView:(UITableView *)tableView accessoryButtonTappedForRowWithIndexPath:(NSIndexPath *)indexPath
{
    [self performSegueWithIdentifier:@"toPlayerDetails" sender:indexPath];
}

#pragma mark - Segue

- (void) prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if ([[segue identifier] isEqualToString:@"toMain"])
    {
        //     PickerViewController * vc = [segue destinationViewController];
        int indexOfTableRow = (int) ((UITableViewCell *) sender).tag;
        Player * p = [_players objectAtIndex:indexOfTableRow];
        [p setIsRecent:YES];
        [_playerDAO updatePlayer:p];
        //        [[vc playersOnScorecard] objectAtIndex:indexOfPlayerInScorecard] = p.playerId;
        //        [vc playersOnScorecard][indexOfPlayerInScorecard] = p.playerId;
        NSLog(@"Chose player %@", p.description);
    }
    else if ([[segue identifier] isEqualToString:@"addPlayer"])
    {
        PlayerViewController * vc = [segue destinationViewController];
        [vc setSelectedPlayerId:-1];
    }
    else if ([[segue identifier] isEqualToString:@"backToMain"])
    {
        // Just go back
    }
    else
    {
        NSIndexPath * indexPath = [sender isKindOfClass:[NSIndexPath class]] ? (NSIndexPath *) sender : [self.tableView indexPathForSelectedRow];
        PlayerViewController * vc = [segue destinationViewController];
        Player * p = [_players objectAtIndex:[indexPath row]];
        [vc setSelectedPlayerId:p.playerId];
    }
}

- (UIImage *) loadImage:(NSInteger)row
{
    Player * p = (Player *) [_players objectAtIndex:row];
    NSString * imageFilePath = [NSHomeDirectory() stringByAppendingPathComponent:p.imagePath];
    
    return [UIImage imageWithContentsOfFile:imageFilePath];
}

- (void) viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    //    if (self.isMovingFromParentViewController)
    //    {
    //        NSMutableArray * playerIds = [[NSMutableArray alloc] init];
    //        for (Player * p in _players)
    //        {
    //            if ([p isRecent])
    //            {
    //                [playerIds addObject:[NSString stringWithFormat:@"%li", (long) [p playerId]]];
    //            }
    //        }
    //
    //        if ([self.delegate respondsToSelector:@selector(playersViewController:didChoosePlayers:)])
    //        {
    //            [self.delegate playersViewController:self didChoosePlayers:playerIds];
    //        }
    //    }
}

@end
