//
//  ScoreCell.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/19/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "ScoreCell.h"

@implementation ScoreCell

- (id) init
{
    _strokePicker.style = HPStyle_iOS7;
    _strokePicker.font = [UIFont systemFontOfSize:60.0f];
    _source = self.dataSource;
    // [_strokePicker selectRow:3 animated:YES];
    [_teeColor setBackgroundColor:[UIColor blueColor]];
    return self;
}

// - (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
// {
//    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
//    if (self) {
//        // Initialization code
//    }
//    _strokePicker.style = HPStyle_iOS7;
//    _strokePicker.font = [UIFont systemFontOfSize:50.0f];
//    return self;
// }

- (void) setSelected:(BOOL)selected animated:(BOOL)animated
{
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

#pragma mark -  HPickerViewDataSource

- (NSInteger) numberOfRowsInPickerView:(HorizontalPickerView *)pickerView
{
    return self.source.count;
}

#pragma mark -  HPickerViewDelegate

- (NSString *) pickerView:(HorizontalPickerView *)pickerView titleForRow:(NSInteger)row
{
    return [NSNumberFormatter localizedStringFromNumber:self.source[row] numberStyle:NSNumberFormatterDecimalStyle];
}

- (void) pickerView:(HorizontalPickerView *)pickerView didSelectRow:(NSInteger)row
{
    //    self.selectedRowLabel.text = [NSString stringWithFormat:@"%@", @(row)];
    //    [_playerInThisCell setStrokes:[NSString stringWithFormat:@"%i", row + 1] forHole:[NSString stringWithFormat:@"%i", _currentHole]];
    NSLog(@"Selected %@", [NSString stringWithFormat:@"Score %@", @(row + 1)]);
}

- (NSArray *) dataSource
{
    if (nil == _dataSource)
    {
        _dataSource = @[@1, @2, @3, @4, @5, @6, @7, @8, @9, @10];
    }
    return _dataSource;
}


@end
