//
//  TeeColorDAO.m
//  holeinsome
//
//  Created by Antti Myllykoski on 2/23/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import "TeeColorDAO.h"

@implementation TeeColorDAO

- (void) initDb
{
    [super initDb];
}

- (NSInteger) addTeeColor:(TeeColor *)teeColor
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    NSInteger id = -1;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * insertSQL = [NSString stringWithFormat:
                                @"INSERT INTO TEECOLORS (TEE_COLOR_NAME, TEE_COLOR_RGB) VALUES (\"%@\", \"%@\")",
                                teeColor.teeColorName, teeColor.rgbInHex];
        
        const char * insert_stmt = [insertSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, insert_stmt, -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Added new teecolor to DB.");
            id = (int) sqlite3_last_insert_rowid(golfrDB);
        }
        else
        {
            NSLog(@"Failed to add teecolor to DB");
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    
    return id;
}

// Return nil if no courses found
- (NSMutableArray *) getTeeColors
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    NSMutableArray * teeColors = [NSMutableArray array];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM TEECOLORS"];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                TeeColor * t = [TeeColor alloc];
                [t setTeeColorId:sqlite3_column_int(statement, 0)];
                [t setTeeColorName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [t setRgbInHex:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
                [teeColors addObject:t];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    
    return teeColors;
}

// Returns nil if player is not found
- (TeeColor *) getTeeColor:(int)id
{
    const char * dbpath = [databasePath UTF8String];
    sqlite3_stmt * statement;
    TeeColor * t = nil;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * querySQL = [NSString stringWithFormat:@"SELECT * FROM TEECOLORS WHERE ID = %i", id];
        
        const char * query_stmt = [querySQL UTF8String];
        
        if (sqlite3_prepare_v2(golfrDB,
                               query_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            while (sqlite3_step(statement) == SQLITE_ROW)
            {
                t = [TeeColor alloc];
                [t setTeeColorId:sqlite3_column_int(statement, 0)];
                [t setTeeColorName:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 1) encoding:NSUTF8StringEncoding]];
                [t setRgbInHex:[NSString stringWithCString:(char *) sqlite3_column_text(statement, 2) encoding:NSUTF8StringEncoding]];
            }
            sqlite3_finalize(statement);
        }
        sqlite3_close(golfrDB);
    }
    return t;
    
}

- (BOOL) updateTeeColor:(TeeColor *)teeColor
{
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    BOOL success = false;
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * updateSQL = [NSString stringWithFormat:
                                @"REPLACE INTO TEECOLORS (ID, TEE_COLOR_NAME, TEE_COLOR_RGB) VALUES (\"%i\", \"%@\", \"%@\")",
                                (int) teeColor.teeColorId, teeColor.teeColorName, teeColor.rgbInHex];
        
        const char * update_stmt = [updateSQL UTF8String];
        sqlite3_prepare_v2(golfrDB, update_stmt,
                           -1, &statement, NULL);
        if (sqlite3_step(statement) == SQLITE_DONE)
        {
            NSLog(@"Updated tee color in DB.");
            success = true;
        }
        else
        {
            NSLog(@"Failed to update tee color to DB");
            success = false;
        }
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
    
}

- (BOOL) deleteTeeColor:(int)id
{
    BOOL success = false;
    sqlite3_stmt * statement = NULL;
    const char * dbpath = [databasePath UTF8String];
    
    if (sqlite3_open(dbpath, &golfrDB) == SQLITE_OK)
    {
        NSString * deleteSQL = [NSString stringWithFormat:@"DELETE from TEECOLORS WHERE id = %i", id];
        
        const char * delete_stmt = [deleteSQL UTF8String];
        if (sqlite3_prepare_v2(golfrDB, delete_stmt, -1, &statement, NULL) == SQLITE_OK)
        {
            if (sqlite3_step(statement) == SQLITE_DONE)
            {
                success = true;
            }
        }
        else
        {
            NSLog(@"Did not delete tee color with id %d", id);
            success = false;
        }
        
        sqlite3_finalize(statement);
        sqlite3_close(golfrDB);
    }
    return success;
}

@end
