//
//  holeinsomeTests.m
//  holeinsomeTests
//
//  Created by Antti Myllykoski on 1/21/14.
//  Copyright (c) 2014 amyllykoski.com. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "PlayerDAO.h"
#import "CourseDAO.h"


@interface holeinsomeTests : XCTestCase

@end

@implementation holeinsomeTests

PlayerDAO *p;
CourseDAO *c;

- (void)setUp
{
    [super setUp];
    [p initDb];
    p = [[PlayerDAO alloc] init];
    [c initDb];
    c = [[CourseDAO alloc] init];
}

- (void)tearDown
{
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
}

- (void)testAddPlayer
{
    [p initDb];
    Player *player = [Player alloc];
    [player setFirstName:@"Test"];
    [player setLastName:@"Osterone"];
    [player setImagePath:@"dafile.png"];
    [player setEmail:@"daemail@hotmail.com"];
    [player setHdcp:12.2];
    NSLog(@"Added player with id: %ld to DB.", (long)[p addPlayer:player]);
    
    XCTAssertTrue(@"First test");
    //    XCTFail(@"No implementation for \"%s\"", __PRETTY_FUNCTION__);
}

-(void) testGetPlayers {
    [p initDb];
    NSArray *players = [p getPlayers];
    for (int i = 0; i < [players count]; i++) {
        NSLog(@"Player %i: %@", i, [players[i] description]);
    }
}

-(void) testGetOnePlayer {
    [p initDb];
    NSLog(@"Player with id = 1: %@", [p getPlayer:1]);
}

-(void) testGetNonExistingPlayer {
    [p initDb];
    NSLog(@"Player with id = 1000: %@", [p getPlayer:1000]);
}

-(void) testDeletePlayer {
    [p initDb];
    XCTAssert([p deletePlayer:3] == YES);
}

-(void) testUpdatePlayer {
    [p initDb];
    Player *player = [p getPlayer:3];
    if(player != nil) {
        [player setFirstName:@"Zappo"];
    }
    XCTAssert([p updatePlayer:player] == true);
}

- (void)testAddCourse
{
    [c initDb];
    Course *course = [Course alloc];
    [course setName:@"Torrey Pines"];
//    [course setPar:72];
//    [course setSlope:123.2];
//    [course setTeeColor:TeeBlack];
    NSLog(@"Added player with id: %ld to DB.", (long)[c addCourse:course]);
    
    XCTAssertTrue(@"First test");
    //    XCTFail(@"No implementation for \"%s\"", __PRETTY_FUNCTION__);
}

-(void) testGetCourses {
    [c initDb];
    NSArray *courses = [c getCourses];
    for (int i = 0; i < [courses count]; i++) {
        NSLog(@"Course %i: %@", i, [courses[i] description]);
    }
}

-(void) testGetOneCourse {
    [c initDb];
    NSLog(@"Course with id = 1: %@", [c getCourse:1]);
}

-(void) testGetNonExistingCourse {
    [c initDb];
    NSLog(@"Course with id = 1000: %@", [c getCourse:1000]);
}

-(void) testDeleteCourse {
    [c initDb];
    XCTAssert([c deleteCourse:3] == YES);
}

-(void) testUpdateCourse {
    [c initDb];
    Course *course = [c getCourse:3];
    if(course != nil) {
        [course setName:@"Zappo"];
    }
    XCTAssert([c updateCourse:course] == true);
}


@end
