"use strict";

const calculateDays = function( date ) {
    if (date instanceof Date) {
        const today = new Date();
        const msFromToday = date.getTime() - today.getTime();
        const msForOneDay = 24 * 60 * 60 * 1000; // hrs * mins * secs * milliseconds  
        return Math.ceil( msFromToday / msForOneDay );            
    }
    else {
        throw new ReferenceError(
            "The calculateDays function requires a Date parameter.");            
    }
};

$( document ).ready( () => { 

    $("#countdown").click( () => {
        const eventName = $("#event").val();
        const eventDate = $("#date").val();  
        const messageLbl = $("#message");  
        
        // make sure user entered task and event date 
        if (eventName.length == 0 || eventDate.length == 0) {
            messageLbl.text( "Please enter both a name and a date." );
            return;
        }  
      
        // make sure event date string has two slashes 
        const dateParts = eventDate.split("/");
        if (dateParts.length != 3) {   
            messageLbl.text( "Please enter the date in MM/DD/YYYY format." );
            return;
        } 
        // make sure event date string has a 4-digit year
        const year = eventDate.substring(eventDate.length - 4); 
        if (isNaN(year)) {
            messageLbl.text( "Please enter the date in MM/DD/YYYY format." );
            return;
        }     
        // convert event date string to Date object and check for validity
        let date = new Date(eventDate);
        if (date == "Invalid Date") {
            messageLbl.text( "Please enter the date in MM/DD/YYYY format." );
            return;
        }

        // capitalize each word of event name
        let formattedName = "";
        const words = eventName.split(" ");
        for (const i in words) {
            const firstLetter = words[i].substring(0,1).toUpperCase();
            const word = firstLetter + words[i].substring(1).toLowerCase();
            formattedName += word.padEnd(word.length + 1);
        } 
        formattedName = formattedName.trimEnd();     

        // calculate days
        // let daysToDate = calculateDays(date);
        try {
            let daysToDate = calculateDays(date);

            // create and display message 
            let msg = "";
            date = date.toDateString();
            if (daysToDate == 0) {
                msg = `Hooray! Today is ${formattedName}! (${date})`;
            }
            else if (daysToDate > 0) {
                msg = `${daysToDate} day(s) until ${formattedName}! (${date})`;
            }
            else if (daysToDate < 0) {
                daysToDate = Math.abs(daysToDate);
                msg = `${formattedName} happened ${daysToDate} day(s) ago. 
                    (${date})`;
            }
            messageLbl.text(msg);            
        }
        catch(error) {
            messageLbl.text( error.name + ": " + error.message );
        } 
    });
    
    $("#event").focus();
});