//JavaScript for Final Quiz - Intro to JavaScript (Online Order Form)
//LeAnne Plaisted Zafar

//JSON strings provided (as menu.json file)
var json = `{
    "menu": {
        "slice of pizza": "2.00",
        "toppings": {
            "pepperoni": ".25",
            "meatballs": ".35",
            "mushrooms": ".40",
            "olives": ".20"
        },
        "sides": {
            "potato salad": "1.25",
            "hummus": "2.50",
            "caesar salad": "3.50",
            "garden salad": "2.25"
        },
        "drinks": {
            "soda": {
                "small": "1.95",
                "medium": "2.20",
                "large": "2.50"
            },
            "juice": "2.00",
            "water": "1.25"
        }
    }
}`;

//Part 1: Convert JSON to HTML & display to user in an input form
//(the user should be able to order via the displayed JSON information)
var obj = JSON.parse(json);
var content = '';
var menu = obj.menu;
  for (i in menu){
    content += '<br/>';

    //Main section headers
    if(i == 'slice of pizza'){
      //Pizza section
      //Slice of pizza header (include price)
      content += '<h3>' + i + '</h3>' + ':<span class="prices"> $' + menu[i] + '</span><br/>';
      //Number input for slices
      content += '<input type="number" name="slicesorder" id="slices" placeholder="0" min="0"><br/>'
    }else {
      //Toppings, sides, drinks header
      content += '<h3>' + i + '</h3>' + '<br/>';
    }

      //Pizza Toppings v.2
        if(i == 'toppings'){
          content += '<select name="toppingsorder" class="dropdown">';
          content += '<option value="none">No Toppings: $0.00</option>';
          for (j in menu[i]){
            content += '<option value=' + j + '>' + j + ' :<span class="prices"> $0' + menu[i][j] + '</span></option>';
          }
          content += '</select><br/>';
        }

      //Sides section
      if(i == 'sides'){
        for (j in menu[i]){
          let idName = j.split(" ").join(""); //add an id name based on the side's name, no spaces
          content += '<input type="checkbox"  name="sidesorder[]" value=' + j + ' id=' + idName + '>' + j + ':<span class="prices"> $' + menu[i][j] + '</span><br/>';
        }
        content;
      }

        //Drinks section v.2
        if(i == 'drinks'){
          for (j in menu[i]){
            let idName1 = j; //add an id name based on the drink's name
              if(j == 'soda'){
                content += '<input type="checkbox" name="drinksorder[]" value=' + j + ' id=' + idName1 + '>' + j; //v.2
                content += '<select name="sodasize" class="dropdown" id="sodadropdown">';
                content += '<option value="nosize">Choose Size</option>';
                for (k in menu[i][j]){
                  content += '<option value=' + k + '>' + k + ':<span class="prices"> $' + menu[i][j][k] + '</span></option>';  //v.2
                }
                content += '</select><br/>';
              }else{
                content += '<input type="checkbox" name="drinksorder[]" value=' + j +  ' id=' + idName1 + '>' + j + ':<span class="prices"> $' + menu[i][j] + '</span><br/>'; //v.2
              }
            }
          }
  };
  //Show menu to user
  const orderOnlineHeading = "<h2>Order Online</h2>";
  document.getElementById('orderOnlineDiv').innerHTML = orderOnlineHeading;
  document.getElementById('menu').innerHTML = content;




//Part Two: Function: Take user's input, validate, save values in theOrder object's properties,
//convert theOrder object to JSON, & save the JSON order to local storage
function placePizzaOrder(slicesorder,toppingsorder,drinksorder,sodasize){
  //1. Declare object for the user's order (properties to be deleted/modified based on their input)
  const theOrder = {
    'Items': {
      'Slice': {
        'Slices': 0,
        'Price': 2.00
      },
      'Toppings': {
          'Choice': 'None',
          'Price': 0,
      },
      'Sides': {
          'Potato Salad': 1.25,
          'Hummus': 2.50,
          'Caesar Salad': 3.50,
          'Garden Salad': 2.25
      },
      'Drinks': {
          'Soda': {
            'Size': 'None',
            'Cost': 0
          },
          'Juice': 2.00,
          'Water': 1.25
      },
    },
    'Total Cost': {
      'Subtotal': 0,
      'Taxes': 0,
      'Total': 0,
    }
  };

  //2. Declare variables
  let totalTaxes = 0; //variable for taxes
  let subTotal = 0; //variable for subtotal (will be updated depending on input)
  const sliceCost = 2;  //each slice is $2
  const potatoCost = 1.25;  //potato salad cost
  const hummusCost = 2.5;  //hummus cost
  const caesarCost = 3.5;  //caesar salad cost
  const gardenCost = 2.25;  //garden salad cost
  let totalSidesCost = potatoCost + hummusCost + caesarCost + gardenCost; //total cost of the sides
  const smallSodaCost = 1.95; //small soda cost
  const mediumSodaCost = 2.2;  //medium soda cost
  const largeSodaCost = 2.5; //large soda cost
  const juiceCost = 2; //juice cost
  const waterCost = 1.25; //water cost
  let totalDrinksCost = juiceCost + waterCost;
  const restaurantTax = 0.09  //New Hampshire restaurant tax

  //Declare variables for sides to check if they've been selected
  let sodaSizeOrdered = document.getElementById("sodadropdown");  //soda size
  let sodaSize = sodaSizeOrdered.value; //soda size value
  let checkPotatoSalad = document.getElementById("potatosalad"); //potato salad
  let checkHummus = document.getElementById("hummus");  //hummus
  let checkCaesarSalad = document.getElementById("caesarsalad"); //caesar salad
  let checkGardenSalad = document.getElementById("gardensalad"); //garden salad

  //Declare variables for drinks to check if they've been selected
  let checkSoda = document.getElementById("soda"); //soda
  let checkJuice = document.getElementById("juice");  //juice
  let checkWater = document.getElementById("water"); //water

  //3. Validate (did they put put in their order before submitting?) & then update order
  if((slicesorder == 0) && (checkPotatoSalad.checked == false) && (checkHummus.checked == false) && (checkCaesarSalad.checked == false) && (checkGardenSalad.checked == false) && (checkSoda.checked == false) && (checkJuice.checked == false) && (checkWater.checked == false)){
    alert("Don't forget to add something to your order!");
    return false;
  }else if((checkSoda.checked == true) && (sodaSize == 'nosize')){  //did they select a soda size?
     alert('Please choose the size of your soda');
     return false;
  }else{
    //4. Slices: Based on how many slices were specified, update theOrder object
    if (slicesorder > 0){
      theOrder['Items']['Slice']['Slices'] = slicesorder;  //update order: number of slices
      let totalSliceCost = sliceCost * slicesorder; //declare variable for cost of pizza slices (total)
      theOrder['Items']['Slice']['Price'] = totalSliceCost; //update order: cost of slices
      subTotal += totalSliceCost; //update total to include cost of pizza
    }else { //if slices weren't put in by the user
      delete theOrder['Items']['Slice']; //remove property
      delete theOrder['Items']['Toppings']; //remove property
    }


    //5. Toppings: Based on which topping was selected, add it to theOrder object
    if((slicesorder > 0) && (toppingsorder != 'none')){
      if(toppingsorder == 'pepperoni'){
        const pepperoniCost = 0.25;  //cost of pepperoni topping
        theOrder['Items']['Toppings']['Choice'] = toppingsorder;
        theOrder['Items']['Toppings']['Price'] = pepperoniCost;
        subTotal += pepperoniCost; //update total to include cost of pepperoni
      } else if(toppingsorder == 'meatballs'){
        const meatballCost = 0.35; //cost of meatball topping
        theOrder['Items']['Toppings']['Choice'] = toppingsorder;
        theOrder['Items']['Toppings']['Price'] = meatballCost;
        subTotal += meatballCost; //update total to include cost of meatball
      } else if(toppingsorder == 'mushrooms'){
        const shroomCost = 0.40; //cost of mushroom topping
        theOrder['Items']['Toppings']['Choice'] = toppingsorder;
        theOrder['Items']['Toppings']['Price'] = shroomCost;
        subTotal += shroomCost; //update total to include cost of mushrooms
      } else {  //if(toppingsOrder == 'olives')
        const oliveCost = 0.20; //cost of olives topping
        theOrder['Items']['Toppings']['Choice'] = toppingsorder;
        theOrder['Items']['Toppings']['Price'] = oliveCost;
        subTotal += oliveCost; //update total to include cost of olives
      }
    }

    //6. Check the sides checkboxes to update the order (if they weren't selected, remove the property)
    //Were the checkboxes selected by the user? If not, remove from theOrder
    //If potato salad wasn't selected, remove its property from theOrder object
    if(checkPotatoSalad.checked == false){
      delete theOrder['Items']['Sides']['Potato Salad']; //remove property
      totalSidesCost -= potatoCost; //remove potato salad cost
    }

    //If hummus wasn't selected, remove its property from theOrder object
    if(checkHummus.checked == false){
      delete theOrder['Items']['Sides']['Hummus']; //remove property
      totalSidesCost -= hummusCost; //remove hummus cost
    }

    //If caesar salad wasn't selected, remove its property from theOrder object
    if(checkCaesarSalad.checked == false){
      delete theOrder['Items']['Sides']['Caesar Salad']; //remove property
      totalSidesCost -= caesarCost; //remove caesar salad cost
    }

    //If garden salad wasn't selected, remove its property from theOrder object
    if(checkGardenSalad.checked == false){
      delete theOrder['Items']['Sides']['Garden Salad']; //remove property
      totalSidesCost -= gardenCost; //remove garden salad cost
    }

    //If no sides were  selected, remove the sides property from theOrder object
    if((checkPotatoSalad.checked == false) && (checkHummus.checked == false) && (checkCaesarSalad.checked == false) && (checkGardenSalad.checked == false)){
      delete theOrder['Items']['Sides'];
    }
    //Update the subtotal (with the cost of the sides)
    subTotal += totalSidesCost; //subtotal + cost of sides (to be modified later)


    //7. Check the drinks checkboxes to update the order (if they weren't selected, remove the property)
    //Were the checkboxes selected by the user? If not, remove from theOrder
    //If soda wasn't selected, remove its property from theOrder object
    if(checkSoda.checked == false){
      delete theOrder['Items']['Drinks']['Soda'];
    } else{
      if(sodaSize != 'nosize'){
        if(sodaSize == 'small'){
          theOrder['Items']['Drinks']['Soda']['Size'] = sodaSize;
          theOrder['Items']['Drinks']['Soda']['Cost'] = smallSodaCost;
          totalDrinksCost += smallSodaCost; //add small soda cost to drinks total
        } else if(sodaSize == 'medium'){
          theOrder['Items']['Drinks']['Soda']['Size'] = sodaSize;
          theOrder['Items']['Drinks']['Soda']['Cost'] = mediumSodaCost;
          totalDrinksCost += mediumSodaCost; //add medium soda cost to drinks total
        } else {  //(sodaSize == 'large')
          theOrder['Items']['Drinks']['Soda']['Size'] = sodaSize;
          theOrder['Items']['Drinks']['Soda']['Cost'] = largeSodaCost;
          totalDrinksCost += largeSodaCost; //add large soda cost to drinks total
        }
      }
    }

    //If juice wasn't selected, remove its property from theOrder object
    if(checkJuice.checked == false){
      delete theOrder['Items']['Drinks']['Juice'];
      totalDrinksCost -= juiceCost; //remove juice cost from drinks total
    }

    //If water wasn't selected, remove its property from theOrder object
    if(checkWater.checked == false){
      delete theOrder['Items']['Drinks']['Water'];
      totalDrinksCost -= waterCost; //remove water cost from drinks total
    }

    //If no drinks were  selected, remove the sides property from theOrder object
    if((checkSoda.checked == false) && (checkJuice.checked == false) && (checkWater.checked == false)){
      delete theOrder['Items']['Drinks'];
    }

    subTotal += totalDrinksCost; //subtotal + total cost of drinks

    //8. Update the cost: Update subtotal, taxes, and total
    theOrder['Total Cost']['Subtotal'] = subTotal;  //update the subtotal property
    totalTaxes = (restaurantTax * subTotal);  //calculate tax
    totalTaxes = Math.round(totalTaxes * 100) / 100; //make sure there aren't extra decimal amounts
    theOrder['Total Cost']['Taxes'] = totalTaxes; //update the taxes property
    let totalAmount = subTotal + totalTaxes;  //total amount of order
    totalAmount = Math.round(totalAmount * 100) / 100;  //make sure there aren't extra decimal amounts
    theOrder['Total Cost']['Total'] = totalAmount;  //update the total property

    //9. Update the Order number
    const orderNumber = Math.floor(Math.random() * 1000); //Assign a random number to order number

    //10. Save the updated order and total cost as JSON to local storage
    localStorage.setItem('theOrder', JSON.stringify(theOrder));

    //11. Update the page
    //First, clear the current form & button
    document.getElementById("orderOnlineDiv").style.display="none";  //clear the current form
    document.getElementById("thePizzaOrderForm").style.display="none";  //clear the current form
    //Second, show the order confirmation message & the "See Your Order" button
    const orderConfirmedHeading = "<h2>Thank You!</h2>";
    let seeOrderButton = '<input type="button" value="Your Order" class="button" id="seeOrder" onclick=seeUsersOrder()>'  //button
    const orderConfirmedMessage = "<br/><p>Thank you for your order!</p><p>Your order confirmation number is <b>" + orderNumber + "</b>.</p><br/>" + seeOrderButton;

    document.getElementById("thankyouDiv").innerHTML = orderConfirmedHeading;
    document.getElementById("orderPlaced").innerHTML = orderConfirmedMessage;
  }
}




//Part Three: Show the User Their Orders
function seeUsersOrder(){
  const theUsersOrder = JSON.parse(localStorage.getItem('theOrder'));
  var obj = JSON.parse(localStorage.getItem('theOrder'));
  var orderContent = '';
  var orderLength = theUsersOrder.length;
  var userOrder = theUsersOrder;
    for (i in userOrder){
      //Headings (Items & Total Cost)
      orderContent += '<h4>' + i + '</h4>';
      if(i == 'Items'){
        orderContent += '<div id="itemssection">';
        for(j in userOrder[i]){
          //Slice
          if(j == 'Slice'){
            for(k in userOrder[i][j]){
              if(k == 'Slices'){
                orderContent += userOrder[i][j][k] + ' ' + k + ': ';
              }else{
                orderContent += ' $' + userOrder[i][j][k] + '.00';

              }
            }
            orderContent += '<br/>';
          }else if(j == 'Toppings'){  //Toppings
            orderContent += j + ': ';
            for(k in userOrder[i][j]){
              if(k == 'Choice'){
                orderContent += userOrder[i][j][k] + ' - ';
              }else{
                orderContent += ' $' + userOrder[i][j][k].toFixed(2);
              }
            }
            orderContent += '<br/>';

          }else{  //Drinks and Sides
            orderContent += '<span id="seeYourOrder2">' + j + ':</span><ul>';
            for(k in userOrder[i][j]){

              if(k == 'Soda'){  //Soda
                orderContent += '<li>';
                for(l in userOrder[i][j][k]){
                  if(l == "Size"){  //Soda sizes
                    orderContent += userOrder[i][j][k][l] + ' ' + k + ' - $';
                  } else{
                    orderContent += userOrder[i][j][k][l].toFixed(2);
                  }
                }
                orderContent += '</li>';

              }else{
                orderContent += '<li>' + k + ' - $' + userOrder[i][j][k].toFixed(2) + '</li>';
              }
            }
            orderContent += '</ul>';
          }
        }
      orderContent += '</div><hr/>';
    }else{  //Total Cost
      for(j in userOrder[i]){
        if(j == 'Total'){
          orderContent += '<b>' + j + ': $' + userOrder[i][j].toFixed(2) + '</b>';
        }else{
          //Properties (Subtotal & Taxes)
          orderContent += j + ': $' + userOrder[i][j].toFixed(2) + '<br/>';
        }
      }
    }
  }

  //Clear the form and show the user their order information
  const yourOrderHeading = "<h2>Your Order</h2>";
  document.getElementById("orderPlaced").style.display="none";  //clear the current form
  document.getElementById("thankyouDiv").style.display="none";  //clear the current form

  document.getElementById('newHeadingDiv').innerHTML = yourOrderHeading;
  document.getElementById('seeYourOrder').innerHTML = orderContent;
}
