<?php

namespace PhpOffice\PhpSpreadsheetTests\Calculation\Functions\Information;

use PhpOffice\PhpSpreadsheet\Calculation\Calculation;
use PhpOffice\PhpSpreadsheet\Calculation\Information\ErrorValue;
use PHPUnit\Framework\TestCase;

class IsErrTest extends TestCase
{
    public function testIsErrNoArgument(): void
    {
        $result = ErrorValue::isErr();
        self::assertFalse($result);
    }

    /**
     * @dataProvider providerIsErr
     *
     * @param mixed $value
     */
    public function testIsErr(bool $expectedResult, $value): void
    {
        $result = ErrorValue::isErr($value);
        self::assertEquals($expectedResult, $result);
    }

    public function providerIsErr(): array
    {
        return require 'tests/data/Calculation/Information/IS_ERR.php';
    }

    /**
     * @dataProvider providerIsErrArray
     */
    public function testIsErrArray(array $expectedResult, string $values): void
    {
        $calculation = Calculation::getInstance();

        $formula = "=ISERR({$values})";
        $result = $calculation->_calculateFormulaValue($formula);
        self::assertEquals($expectedResult, $result);
    }

    public function providerIsErrArray(): array
    {
        return [
            'vector' => [
                [[true, true, false, false, false, false]],
                '{5/0, "#REF!", "#N/A", 1.2, TRUE, "PHP"}',
            ],
        ];
    }
}
