Использование прямых команд
=======================

Redis имеет множество полезных команд, которые могут быть использованы непосредственно из соединения. После настройки приложения как показано в [установке](installation.md), соединение может быть получено следующим образом:

```php
$redis = Yii::$app->redis;
```

После этого можно выполнять команды. Самый общий способ сделать это - использовать метод `executeCommand`:

```php
$result = $redis->executeCommand('hmset', ['test_collection', 'key1', 'val1', 'key2', 'val2']);
```

Доступны сочетания для каждой поддерживаемой команды, поэтому вместо вышесказанного ее можно использовать следующим образом:

```php
$result = $redis->hmset('test_collection', 'key1', 'val1', 'key2', 'val2');
```

Список доступных команд и их параметры см. в разделе <http://redis.io/commands>.