///////////////////////////////////////////////////////////////////////////////
// userModel.js
// This script has functions wrapping the IndexedDB functionality and provide
// the login user data model and operations.
///////////////////////////////////////////////////////////////////////////////

var indexDbHandle = null;

//
// Check if IndexDB is supported.
//
function isIndexedDBSupported() {
  return "indexedDB" in window;
}

//
// Open Index DB and create the object stores.
//
function initIndexedDb() {
	if (isIndexedDBSupported() == false)
    return;

  // Open the database.
	var openRequest = indexedDB.open("yyAutoMaintDb", 1);

  // Determine if an update is needed.
	openRequest.onupgradeneeded = function(e) {
		var dbObj = e.target.result;

    // Check if the User object store exists.
		if (dbObj.objectStoreNames.contains("User") == false) {
			var objStore = dbObj.createObjectStore("User", {autoIncrement:true});

			objStore.createIndex("loginname", "loginname", {unique:true});
		}
	}

	openRequest.onsuccess = function(e) {
  	console.log("Indexed DB opened and User object store created");
		indexDbHandle = e.target.result;
	}	

	openRequest.onerror = indexDbErrorHandler;
}

//
// Add a new user to index db.
//
function addUserToDb(loginName, userPassword, successCallbackFunc) {
	console.log("Registering: " + loginName + "/" + userPassword);

	// Get a transaction and the object store.
	var transaction = indexDbHandle.transaction(["User"], "readwrite");
	var objStore = transaction.objectStore("User");

	// Define a user db object
	var user = {
		loginname:loginName,
		password:userPassword,
		created:new Date()
	}

	// Perform the add
	var request = objStore.add(user);

	request.onerror = indexDbErrorHandler;
  request.onsuccess = successCallbackFunc;
}

//
// Check if the specified user is registered (in DB).
//
function isUserRegistered(loginName, userPassword, successCallbackFunc) {
	console.log("Checking user: " + loginName + "/" + userPassword);

  var retVal = false;
  
	// Get a transaction and the object store.
	var transaction = indexDbHandle.transaction(["User"], "readonly");
	var store = transaction.objectStore("User");
  
  // Open the DB index to the loginname field.
	var index = store.index("loginname");

  // Query (find) the user.
	var request = index.get(loginName);

  // On success, traverse the result and get each field.
	request.onsuccess = function(e) {
		var result = e.target.result;
    
		if (result) {
      if ("password" in result) {
        if (result["password"] == userPassword)
          retVal = true;
        else
          console.log("Password mismatch");
			}
      else
        console.log("Password field not found.");
		}
    else {
    	console.log("User not found");
		}
    
    successCallbackFunc(retVal);	
	}	
}

//
// Database error handler.
// 
function indexDbErrorHandler(e) {
  console.log("indexedDB Error: " + e.target.error.name);
}
