///////////////////////////////////////////////////////////////////////////////
// loginPage.js
// This script has functions specific to the loginPage.html.
// A lot of the DB interaction code was taken from the week7:test10.html file
// from the JavaScript I class material.
///////////////////////////////////////////////////////////////////////////////

function onLoadLoginPage() {
  // Check if browser provides support for IndexedDB and WebSQL.
  if (isIndexedDBSupported() == false)
    showBrowserSupportError("This browser does not support client side storage IndexedDB.");

  if (("openDatabase" in window) == false)
    showBrowserSupportError("This browser does not support client side storage WebSQL.");
  
  if (("sessionStorage" in window) == false)
    showBrowserSupportError("This browser does not support session storage.");

  // Call the global On Load function.
  onLoad(pageOnLoad);
}

//
// Write out the message onto the page showing the missing browser support.
//
function showBrowserSupportError(msg) {
  document.write("<p>" + msg + "</p><br>This web app can not run.  Please use Google Chrome.");
}

//
// OnLoad callback method for the page.
//
function pageOnLoad() {
  document.getElementById("loginname").focus();
  
  // If user had checked Remember Me, then load the user login
  var checkedRememberMe = localStorage.getItem("yyAutoMaintRememberMe");
  
  if (checkedRememberMe != null && checkedRememberMe == "true") {
    var lastLogin = localStorage.getItem("yyAutoMaintLastLoginname");
    if (lastLogin != null)
      document.getElementById("loginname").value = lastLogin;
    document.getElementById("rememberme").checked = true;
  }
  
  // Initialize the user registeration database.
  initIndexedDb();
}

//
// Validate the input fields.
//
function validateFields() {
  var isValid = true;

  isValid &= validateInput("loginname");
  isValid &= validateInput("password");

  return isValid;
}

//
// Handle the Sign In button click event.
//
function signIn() {
  if (validateFields() == false)
    return false;

  var loginName = getElementValue("loginname");
  var userPassword = getElementValue("password");

  // Check the user account against what's in the user management database.
  isUserRegistered(loginName, userPassword, signInSuccessCallback);
}

//
// Callback function when user registration succeeds.
// 
function signInSuccessCallback(userIsValid) {
  if (userIsValid) {
    // Save the user in the session to be used by the other pages.
    sessionStorage.setItem(gUserNameKey, getElementValue("loginname"));

    if (document.getElementById("rememberme").checked == true) {
      localStorage.setItem("yyAutoMaintRememberMe", "true");
      localStorage.setItem("yyAutoMaintLastLoginname", getElementValue("loginname"));
    }
    else 
      localStorage.setItem("yyAutoMaintRememberMe", "false");
      
    // Open the auto list page.
    window.location.href = "autoListPage.html";
  }
  else {
    openPopupBox("Invalid user/password.");
  }
}

//
// Handle the Register button click event.
//
function registerUser() {
  if (validateFields() == false)
    return false;

  var loginName = getElementValue("loginname");
  var userPassword = getElementValue("password");

  // Add the user to the user management database.
  addUserToDb(loginName, userPassword, registrationSuccessCallback);
}

//
// Callback function when user registration succeeds.
// 
function registrationSuccessCallback() {
  // Notify the user has been registered.
  openPopupBox("User has been registered.");
}
