///////////////////////////////////////////////////////////////////////////////
// commonDbPrep.js
// This script has functions aware of auto db tables.
///////////////////////////////////////////////////////////////////////////////

//
// Define the database table names.
//
var TBL_AUTOINFO = "AutoInfo";
var TBL_SERVICERECORD = "ServiceRecord";

var lgCreateSqlArray = [
      TBL_AUTOINFO + " (AutoId INTEGER NOT NULL PRIMARY KEY, AliasName TEXT NOT NULL, MakeName TEXT NOT NULL, ModelName TEXT NOT NULL, AutoYear TEXT NOT NULL, UserId TEXT NOT NULL)",
      TBL_SERVICERECORD + " (ServiceId INTEGER NOT NULL PRIMARY KEY, AutoId INTEGER NOT NULL, ServiceDate TEXT NOT NULL, ServiceType TEXT NOT NULL, Notes TEXT NULL, Cost REAL NOT NULL)"
    ];
var lgCreateSqlArrayIdx = 0;

//
// Open/Create the Auto database and the tables.
//
function prepareAutoDB() {
  // Open the Web SQL database.
  openDB("yyAutoMaintDb", "1.0");
  
  // Create the tables, but only once, since this code is executed on page reloads.
  console.log("window.name: " + window.name);
  if (window.name != "appDidInitialize")
  {
    // Create the first table in the array.  The callback function will create the rest.
    createTable(lgCreateSqlArray[lgCreateSqlArrayIdx++], createTableCallback);
  }
}

//
// Callback function called when createTable completes.
//
function createTableCallback() {
  console.log("Current table idx: " + lgCreateSqlArrayIdx);
  
  // If not done, create the next table.  Otherwise signify we are done.
  if (lgCreateSqlArrayIdx < lgCreateSqlArray.length)
    createTable(lgCreateSqlArray[lgCreateSqlArrayIdx++], createTableCallback);
  else
    window.name = "appDidInitialize";
}
