var Editor = (function () {
  'use strict';

  function _typeof$2(obj) {
    "@babel/helpers - typeof";

    return _typeof$2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _typeof$2(obj);
  }

  function _classCallCheck$1(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    Object.defineProperty(subClass, "prototype", {
      writable: false
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof$2(call) === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _defineProperty$2(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }
    return arr2;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
  }

  function ownKeys$5(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$3(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$5(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$5(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  var consoleLogger = {
    type: 'logger',
    log: function log(args) {
      this.output('log', args);
    },
    warn: function warn(args) {
      this.output('warn', args);
    },
    error: function error(args) {
      this.output('error', args);
    },
    output: function output(type, args) {
      if (console && console[type]) console[type].apply(console, args);
    }
  };
  var Logger = function () {
    function Logger(concreteLogger) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck$1(this, Logger);
      this.init(concreteLogger, options);
    }
    _createClass(Logger, [{
      key: "init",
      value: function init(concreteLogger) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        this.prefix = options.prefix || 'i18next:';
        this.logger = concreteLogger || consoleLogger;
        this.options = options;
        this.debug = options.debug;
      }
    }, {
      key: "setDebug",
      value: function setDebug(bool) {
        this.debug = bool;
      }
    }, {
      key: "log",
      value: function log() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        return this.forward(args, 'log', '', true);
      }
    }, {
      key: "warn",
      value: function warn() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }
        return this.forward(args, 'warn', '', true);
      }
    }, {
      key: "error",
      value: function error() {
        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }
        return this.forward(args, 'error', '');
      }
    }, {
      key: "deprecate",
      value: function deprecate() {
        for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
          args[_key4] = arguments[_key4];
        }
        return this.forward(args, 'warn', 'WARNING DEPRECATED: ', true);
      }
    }, {
      key: "forward",
      value: function forward(args, lvl, prefix, debugOnly) {
        if (debugOnly && !this.debug) return null;
        if (typeof args[0] === 'string') args[0] = "".concat(prefix).concat(this.prefix, " ").concat(args[0]);
        return this.logger[lvl](args);
      }
    }, {
      key: "create",
      value: function create(moduleName) {
        return new Logger(this.logger, _objectSpread$3(_objectSpread$3({}, {
          prefix: "".concat(this.prefix, ":").concat(moduleName, ":")
        }), this.options));
      }
    }, {
      key: "clone",
      value: function clone(options) {
        options = options || this.options;
        options.prefix = options.prefix || this.prefix;
        return new Logger(this.logger, options);
      }
    }]);
    return Logger;
  }();
  var baseLogger = new Logger();
  var EventEmitter = function () {
    function EventEmitter() {
      _classCallCheck$1(this, EventEmitter);
      this.observers = {};
    }
    _createClass(EventEmitter, [{
      key: "on",
      value: function on(events, listener) {
        var _this = this;
        events.split(' ').forEach(function (event) {
          _this.observers[event] = _this.observers[event] || [];
          _this.observers[event].push(listener);
        });
        return this;
      }
    }, {
      key: "off",
      value: function off(event, listener) {
        if (!this.observers[event]) return;
        if (!listener) {
          delete this.observers[event];
          return;
        }
        this.observers[event] = this.observers[event].filter(function (l) {
          return l !== listener;
        });
      }
    }, {
      key: "emit",
      value: function emit(event) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        if (this.observers[event]) {
          var cloned = [].concat(this.observers[event]);
          cloned.forEach(function (observer) {
            observer.apply(void 0, args);
          });
        }
        if (this.observers['*']) {
          var _cloned = [].concat(this.observers['*']);
          _cloned.forEach(function (observer) {
            observer.apply(observer, [event].concat(args));
          });
        }
      }
    }]);
    return EventEmitter;
  }();
  function defer$1() {
    var res;
    var rej;
    var promise = new Promise(function (resolve, reject) {
      res = resolve;
      rej = reject;
    });
    promise.resolve = res;
    promise.reject = rej;
    return promise;
  }
  function makeString(object) {
    if (object == null) return '';
    return '' + object;
  }
  function copy(a, s, t) {
    a.forEach(function (m) {
      if (s[m]) t[m] = s[m];
    });
  }
  function getLastOfPath(object, path, Empty) {
    function cleanKey(key) {
      return key && key.indexOf('###') > -1 ? key.replace(/###/g, '.') : key;
    }
    function canNotTraverseDeeper() {
      return !object || typeof object === 'string';
    }
    var stack = typeof path !== 'string' ? [].concat(path) : path.split('.');
    while (stack.length > 1) {
      if (canNotTraverseDeeper()) return {};
      var key = cleanKey(stack.shift());
      if (!object[key] && Empty) object[key] = new Empty();
      if (Object.prototype.hasOwnProperty.call(object, key)) {
        object = object[key];
      } else {
        object = {};
      }
    }
    if (canNotTraverseDeeper()) return {};
    return {
      obj: object,
      k: cleanKey(stack.shift())
    };
  }
  function setPath(object, path, newValue) {
    var _getLastOfPath = getLastOfPath(object, path, Object),
      obj = _getLastOfPath.obj,
      k = _getLastOfPath.k;
    obj[k] = newValue;
  }
  function pushPath(object, path, newValue, concat) {
    var _getLastOfPath2 = getLastOfPath(object, path, Object),
      obj = _getLastOfPath2.obj,
      k = _getLastOfPath2.k;
    obj[k] = obj[k] || [];
    if (concat) obj[k] = obj[k].concat(newValue);
    if (!concat) obj[k].push(newValue);
  }
  function getPath(object, path) {
    var _getLastOfPath3 = getLastOfPath(object, path),
      obj = _getLastOfPath3.obj,
      k = _getLastOfPath3.k;
    if (!obj) return undefined;
    return obj[k];
  }
  function getPathWithDefaults(data, defaultData, key) {
    var value = getPath(data, key);
    if (value !== undefined) {
      return value;
    }
    return getPath(defaultData, key);
  }
  function deepExtend(target, source, overwrite) {
    for (var prop in source) {
      if (prop !== '__proto__' && prop !== 'constructor') {
        if (prop in target) {
          if (typeof target[prop] === 'string' || target[prop] instanceof String || typeof source[prop] === 'string' || source[prop] instanceof String) {
            if (overwrite) target[prop] = source[prop];
          } else {
            deepExtend(target[prop], source[prop], overwrite);
          }
        } else {
          target[prop] = source[prop];
        }
      }
    }
    return target;
  }
  function regexEscape$1(str) {
    return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
  }
  var _entityMap = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
    '/': '&#x2F;'
  };
  function escape$1(data) {
    if (typeof data === 'string') {
      return data.replace(/[&<>"'\/]/g, function (s) {
        return _entityMap[s];
      });
    }
    return data;
  }
  var isIE10 = typeof window !== 'undefined' && window.navigator && typeof window.navigator.userAgentData === 'undefined' && window.navigator.userAgent && window.navigator.userAgent.indexOf('MSIE') > -1;
  var chars = [' ', ',', '?', '!', ';'];
  function looksLikeObjectPath(key, nsSeparator, keySeparator) {
    nsSeparator = nsSeparator || '';
    keySeparator = keySeparator || '';
    var possibleChars = chars.filter(function (c) {
      return nsSeparator.indexOf(c) < 0 && keySeparator.indexOf(c) < 0;
    });
    if (possibleChars.length === 0) return true;
    var r = new RegExp("(".concat(possibleChars.map(function (c) {
      return c === '?' ? '\\?' : c;
    }).join('|'), ")"));
    var matched = !r.test(key);
    if (!matched) {
      var ki = key.indexOf(keySeparator);
      if (ki > 0 && !r.test(key.substring(0, ki))) {
        matched = true;
      }
    }
    return matched;
  }
  function ownKeys$1$1(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$1$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$1$1(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$1$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
        result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function deepFind(obj, path) {
    var keySeparator = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '.';
    if (!obj) return undefined;
    if (obj[path]) return obj[path];
    var paths = path.split(keySeparator);
    var current = obj;
    for (var i = 0; i < paths.length; ++i) {
      if (!current) return undefined;
      if (typeof current[paths[i]] === 'string' && i + 1 < paths.length) {
        return undefined;
      }
      if (current[paths[i]] === undefined) {
        var j = 2;
        var p = paths.slice(i, i + j).join(keySeparator);
        var mix = current[p];
        while (mix === undefined && paths.length > i + j) {
          j++;
          p = paths.slice(i, i + j).join(keySeparator);
          mix = current[p];
        }
        if (mix === undefined) return undefined;
        if (mix === null) return null;
        if (path.endsWith(p)) {
          if (typeof mix === 'string') return mix;
          if (p && typeof mix[p] === 'string') return mix[p];
        }
        var joinedPath = paths.slice(i + j).join(keySeparator);
        if (joinedPath) return deepFind(mix, joinedPath, keySeparator);
        return undefined;
      }
      current = current[paths[i]];
    }
    return current;
  }
  var ResourceStore = function (_EventEmitter) {
    _inherits(ResourceStore, _EventEmitter);
    var _super = _createSuper(ResourceStore);
    function ResourceStore(data) {
      var _this;
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
        ns: ['translation'],
        defaultNS: 'translation'
      };
      _classCallCheck$1(this, ResourceStore);
      _this = _super.call(this);
      if (isIE10) {
        EventEmitter.call(_assertThisInitialized(_this));
      }
      _this.data = data || {};
      _this.options = options;
      if (_this.options.keySeparator === undefined) {
        _this.options.keySeparator = '.';
      }
      if (_this.options.ignoreJSONStructure === undefined) {
        _this.options.ignoreJSONStructure = true;
      }
      return _this;
    }
    _createClass(ResourceStore, [{
      key: "addNamespaces",
      value: function addNamespaces(ns) {
        if (this.options.ns.indexOf(ns) < 0) {
          this.options.ns.push(ns);
        }
      }
    }, {
      key: "removeNamespaces",
      value: function removeNamespaces(ns) {
        var index = this.options.ns.indexOf(ns);
        if (index > -1) {
          this.options.ns.splice(index, 1);
        }
      }
    }, {
      key: "getResource",
      value: function getResource(lng, ns, key) {
        var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
        var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
        var ignoreJSONStructure = options.ignoreJSONStructure !== undefined ? options.ignoreJSONStructure : this.options.ignoreJSONStructure;
        var path = [lng, ns];
        if (key && typeof key !== 'string') path = path.concat(key);
        if (key && typeof key === 'string') path = path.concat(keySeparator ? key.split(keySeparator) : key);
        if (lng.indexOf('.') > -1) {
          path = lng.split('.');
        }
        var result = getPath(this.data, path);
        if (result || !ignoreJSONStructure || typeof key !== 'string') return result;
        return deepFind(this.data && this.data[lng] && this.data[lng][ns], key, keySeparator);
      }
    }, {
      key: "addResource",
      value: function addResource(lng, ns, key, value) {
        var options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {
          silent: false
        };
        var keySeparator = this.options.keySeparator;
        if (keySeparator === undefined) keySeparator = '.';
        var path = [lng, ns];
        if (key) path = path.concat(keySeparator ? key.split(keySeparator) : key);
        if (lng.indexOf('.') > -1) {
          path = lng.split('.');
          value = ns;
          ns = path[1];
        }
        this.addNamespaces(ns);
        setPath(this.data, path, value);
        if (!options.silent) this.emit('added', lng, ns, key, value);
      }
    }, {
      key: "addResources",
      value: function addResources(lng, ns, resources) {
        var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
          silent: false
        };
        for (var m in resources) {
          if (typeof resources[m] === 'string' || Object.prototype.toString.apply(resources[m]) === '[object Array]') this.addResource(lng, ns, m, resources[m], {
            silent: true
          });
        }
        if (!options.silent) this.emit('added', lng, ns, resources);
      }
    }, {
      key: "addResourceBundle",
      value: function addResourceBundle(lng, ns, resources, deep, overwrite) {
        var options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {
          silent: false
        };
        var path = [lng, ns];
        if (lng.indexOf('.') > -1) {
          path = lng.split('.');
          deep = resources;
          resources = ns;
          ns = path[1];
        }
        this.addNamespaces(ns);
        var pack = getPath(this.data, path) || {};
        if (deep) {
          deepExtend(pack, resources, overwrite);
        } else {
          pack = _objectSpread$1$1(_objectSpread$1$1({}, pack), resources);
        }
        setPath(this.data, path, pack);
        if (!options.silent) this.emit('added', lng, ns, resources);
      }
    }, {
      key: "removeResourceBundle",
      value: function removeResourceBundle(lng, ns) {
        if (this.hasResourceBundle(lng, ns)) {
          delete this.data[lng][ns];
        }
        this.removeNamespaces(ns);
        this.emit('removed', lng, ns);
      }
    }, {
      key: "hasResourceBundle",
      value: function hasResourceBundle(lng, ns) {
        return this.getResource(lng, ns) !== undefined;
      }
    }, {
      key: "getResourceBundle",
      value: function getResourceBundle(lng, ns) {
        if (!ns) ns = this.options.defaultNS;
        if (this.options.compatibilityAPI === 'v1') return _objectSpread$1$1(_objectSpread$1$1({}, {}), this.getResource(lng, ns));
        return this.getResource(lng, ns);
      }
    }, {
      key: "getDataByLanguage",
      value: function getDataByLanguage(lng) {
        return this.data[lng];
      }
    }, {
      key: "hasLanguageSomeTranslations",
      value: function hasLanguageSomeTranslations(lng) {
        var data = this.getDataByLanguage(lng);
        var n = data && Object.keys(data) || [];
        return !!n.find(function (v) {
          return data[v] && Object.keys(data[v]).length > 0;
        });
      }
    }, {
      key: "toJSON",
      value: function toJSON() {
        return this.data;
      }
    }]);
    return ResourceStore;
  }(EventEmitter);
  var postProcessor = {
    processors: {},
    addPostProcessor: function addPostProcessor(module) {
      this.processors[module.name] = module;
    },
    handle: function handle(processors, value, key, options, translator) {
      var _this = this;
      processors.forEach(function (processor) {
        if (_this.processors[processor]) value = _this.processors[processor].process(value, key, options, translator);
      });
      return value;
    }
  };
  function ownKeys$2$1(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$2$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$2$1(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$2$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _createSuper$1(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$1();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
        result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _isNativeReflectConstruct$1() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  var checkedLoadedFor = {};
  var Translator = function (_EventEmitter) {
    _inherits(Translator, _EventEmitter);
    var _super = _createSuper$1(Translator);
    function Translator(services) {
      var _this;
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck$1(this, Translator);
      _this = _super.call(this);
      if (isIE10) {
        EventEmitter.call(_assertThisInitialized(_this));
      }
      copy(['resourceStore', 'languageUtils', 'pluralResolver', 'interpolator', 'backendConnector', 'i18nFormat', 'utils'], services, _assertThisInitialized(_this));
      _this.options = options;
      if (_this.options.keySeparator === undefined) {
        _this.options.keySeparator = '.';
      }
      _this.logger = baseLogger.create('translator');
      return _this;
    }
    _createClass(Translator, [{
      key: "changeLanguage",
      value: function changeLanguage(lng) {
        if (lng) this.language = lng;
      }
    }, {
      key: "exists",
      value: function exists(key) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          interpolation: {}
        };
        if (key === undefined || key === null) {
          return false;
        }
        var resolved = this.resolve(key, options);
        return resolved && resolved.res !== undefined;
      }
    }, {
      key: "extractFromKey",
      value: function extractFromKey(key, options) {
        var nsSeparator = options.nsSeparator !== undefined ? options.nsSeparator : this.options.nsSeparator;
        if (nsSeparator === undefined) nsSeparator = ':';
        var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
        var namespaces = options.ns || this.options.defaultNS || [];
        var wouldCheckForNsInKey = nsSeparator && key.indexOf(nsSeparator) > -1;
        var seemsNaturalLanguage = !this.options.userDefinedKeySeparator && !options.keySeparator && !this.options.userDefinedNsSeparator && !options.nsSeparator && !looksLikeObjectPath(key, nsSeparator, keySeparator);
        if (wouldCheckForNsInKey && !seemsNaturalLanguage) {
          var m = key.match(this.interpolator.nestingRegexp);
          if (m && m.length > 0) {
            return {
              key: key,
              namespaces: namespaces
            };
          }
          var parts = key.split(nsSeparator);
          if (nsSeparator !== keySeparator || nsSeparator === keySeparator && this.options.ns.indexOf(parts[0]) > -1) namespaces = parts.shift();
          key = parts.join(keySeparator);
        }
        if (typeof namespaces === 'string') namespaces = [namespaces];
        return {
          key: key,
          namespaces: namespaces
        };
      }
    }, {
      key: "translate",
      value: function translate(keys, options, lastKey) {
        var _this2 = this;
        if (_typeof$2(options) !== 'object' && this.options.overloadTranslationOptionHandler) {
          options = this.options.overloadTranslationOptionHandler(arguments);
        }
        if (!options) options = {};
        if (keys === undefined || keys === null) return '';
        if (!Array.isArray(keys)) keys = [String(keys)];
        var returnDetails = options.returnDetails !== undefined ? options.returnDetails : this.options.returnDetails;
        var keySeparator = options.keySeparator !== undefined ? options.keySeparator : this.options.keySeparator;
        var _this$extractFromKey = this.extractFromKey(keys[keys.length - 1], options),
          key = _this$extractFromKey.key,
          namespaces = _this$extractFromKey.namespaces;
        var namespace = namespaces[namespaces.length - 1];
        var lng = options.lng || this.language;
        var appendNamespaceToCIMode = options.appendNamespaceToCIMode || this.options.appendNamespaceToCIMode;
        if (lng && lng.toLowerCase() === 'cimode') {
          if (appendNamespaceToCIMode) {
            var nsSeparator = options.nsSeparator || this.options.nsSeparator;
            if (returnDetails) {
              resolved.res = "".concat(namespace).concat(nsSeparator).concat(key);
              return resolved;
            }
            return "".concat(namespace).concat(nsSeparator).concat(key);
          }
          if (returnDetails) {
            resolved.res = key;
            return resolved;
          }
          return key;
        }
        var resolved = this.resolve(keys, options);
        var res = resolved && resolved.res;
        var resUsedKey = resolved && resolved.usedKey || key;
        var resExactUsedKey = resolved && resolved.exactUsedKey || key;
        var resType = Object.prototype.toString.apply(res);
        var noObject = ['[object Number]', '[object Function]', '[object RegExp]'];
        var joinArrays = options.joinArrays !== undefined ? options.joinArrays : this.options.joinArrays;
        var handleAsObjectInI18nFormat = !this.i18nFormat || this.i18nFormat.handleAsObject;
        var handleAsObject = typeof res !== 'string' && typeof res !== 'boolean' && typeof res !== 'number';
        if (handleAsObjectInI18nFormat && res && handleAsObject && noObject.indexOf(resType) < 0 && !(typeof joinArrays === 'string' && resType === '[object Array]')) {
          if (!options.returnObjects && !this.options.returnObjects) {
            if (!this.options.returnedObjectHandler) {
              this.logger.warn('accessing an object - but returnObjects options is not enabled!');
            }
            var r = this.options.returnedObjectHandler ? this.options.returnedObjectHandler(resUsedKey, res, _objectSpread$2$1(_objectSpread$2$1({}, options), {}, {
              ns: namespaces
            })) : "key '".concat(key, " (").concat(this.language, ")' returned an object instead of string.");
            if (returnDetails) {
              resolved.res = r;
              return resolved;
            }
            return r;
          }
          if (keySeparator) {
            var resTypeIsArray = resType === '[object Array]';
            var copy = resTypeIsArray ? [] : {};
            var newKeyToUse = resTypeIsArray ? resExactUsedKey : resUsedKey;
            for (var m in res) {
              if (Object.prototype.hasOwnProperty.call(res, m)) {
                var deepKey = "".concat(newKeyToUse).concat(keySeparator).concat(m);
                copy[m] = this.translate(deepKey, _objectSpread$2$1(_objectSpread$2$1({}, options), {
                  joinArrays: false,
                  ns: namespaces
                }));
                if (copy[m] === deepKey) copy[m] = res[m];
              }
            }
            res = copy;
          }
        } else if (handleAsObjectInI18nFormat && typeof joinArrays === 'string' && resType === '[object Array]') {
          res = res.join(joinArrays);
          if (res) res = this.extendTranslation(res, keys, options, lastKey);
        } else {
          var usedDefault = false;
          var usedKey = false;
          var needsPluralHandling = options.count !== undefined && typeof options.count !== 'string';
          var hasDefaultValue = Translator.hasDefaultValue(options);
          var defaultValueSuffix = needsPluralHandling ? this.pluralResolver.getSuffix(lng, options.count, options) : '';
          var defaultValue = options["defaultValue".concat(defaultValueSuffix)] || options.defaultValue;
          if (!this.isValidLookup(res) && hasDefaultValue) {
            usedDefault = true;
            res = defaultValue;
          }
          if (!this.isValidLookup(res)) {
            usedKey = true;
            res = key;
          }
          var missingKeyNoValueFallbackToKey = options.missingKeyNoValueFallbackToKey || this.options.missingKeyNoValueFallbackToKey;
          var resForMissing = missingKeyNoValueFallbackToKey && usedKey ? undefined : res;
          var updateMissing = hasDefaultValue && defaultValue !== res && this.options.updateMissing;
          if (usedKey || usedDefault || updateMissing) {
            this.logger.log(updateMissing ? 'updateKey' : 'missingKey', lng, namespace, key, updateMissing ? defaultValue : res);
            if (keySeparator) {
              var fk = this.resolve(key, _objectSpread$2$1(_objectSpread$2$1({}, options), {}, {
                keySeparator: false
              }));
              if (fk && fk.res) this.logger.warn('Seems the loaded translations were in flat JSON format instead of nested. Either set keySeparator: false on init or make sure your translations are published in nested format.');
            }
            var lngs = [];
            var fallbackLngs = this.languageUtils.getFallbackCodes(this.options.fallbackLng, options.lng || this.language);
            if (this.options.saveMissingTo === 'fallback' && fallbackLngs && fallbackLngs[0]) {
              for (var i = 0; i < fallbackLngs.length; i++) {
                lngs.push(fallbackLngs[i]);
              }
            } else if (this.options.saveMissingTo === 'all') {
              lngs = this.languageUtils.toResolveHierarchy(options.lng || this.language);
            } else {
              lngs.push(options.lng || this.language);
            }
            var send = function send(l, k, specificDefaultValue) {
              var defaultForMissing = hasDefaultValue && specificDefaultValue !== res ? specificDefaultValue : resForMissing;
              if (_this2.options.missingKeyHandler) {
                _this2.options.missingKeyHandler(l, namespace, k, defaultForMissing, updateMissing, options);
              } else if (_this2.backendConnector && _this2.backendConnector.saveMissing) {
                _this2.backendConnector.saveMissing(l, namespace, k, defaultForMissing, updateMissing, options);
              }
              _this2.emit('missingKey', l, namespace, k, res);
            };
            if (this.options.saveMissing) {
              if (this.options.saveMissingPlurals && needsPluralHandling) {
                lngs.forEach(function (language) {
                  _this2.pluralResolver.getSuffixes(language, options).forEach(function (suffix) {
                    send([language], key + suffix, options["defaultValue".concat(suffix)] || defaultValue);
                  });
                });
              } else {
                send(lngs, key, defaultValue);
              }
            }
          }
          res = this.extendTranslation(res, keys, options, resolved, lastKey);
          if (usedKey && res === key && this.options.appendNamespaceToMissingKey) res = "".concat(namespace, ":").concat(key);
          if ((usedKey || usedDefault) && this.options.parseMissingKeyHandler) {
            if (this.options.compatibilityAPI !== 'v1') {
              res = this.options.parseMissingKeyHandler(this.options.appendNamespaceToMissingKey ? "".concat(namespace, ":").concat(key) : key, usedDefault ? res : undefined);
            } else {
              res = this.options.parseMissingKeyHandler(res);
            }
          }
        }
        if (returnDetails) {
          resolved.res = res;
          return resolved;
        }
        return res;
      }
    }, {
      key: "extendTranslation",
      value: function extendTranslation(res, key, options, resolved, lastKey) {
        var _this3 = this;
        if (this.i18nFormat && this.i18nFormat.parse) {
          res = this.i18nFormat.parse(res, _objectSpread$2$1(_objectSpread$2$1({}, this.options.interpolation.defaultVariables), options), resolved.usedLng, resolved.usedNS, resolved.usedKey, {
            resolved: resolved
          });
        } else if (!options.skipInterpolation) {
          if (options.interpolation) this.interpolator.init(_objectSpread$2$1(_objectSpread$2$1({}, options), {
            interpolation: _objectSpread$2$1(_objectSpread$2$1({}, this.options.interpolation), options.interpolation)
          }));
          var skipOnVariables = typeof res === 'string' && (options && options.interpolation && options.interpolation.skipOnVariables !== undefined ? options.interpolation.skipOnVariables : this.options.interpolation.skipOnVariables);
          var nestBef;
          if (skipOnVariables) {
            var nb = res.match(this.interpolator.nestingRegexp);
            nestBef = nb && nb.length;
          }
          var data = options.replace && typeof options.replace !== 'string' ? options.replace : options;
          if (this.options.interpolation.defaultVariables) data = _objectSpread$2$1(_objectSpread$2$1({}, this.options.interpolation.defaultVariables), data);
          res = this.interpolator.interpolate(res, data, options.lng || this.language, options);
          if (skipOnVariables) {
            var na = res.match(this.interpolator.nestingRegexp);
            var nestAft = na && na.length;
            if (nestBef < nestAft) options.nest = false;
          }
          if (options.nest !== false) res = this.interpolator.nest(res, function () {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }
            if (lastKey && lastKey[0] === args[0] && !options.context) {
              _this3.logger.warn("It seems you are nesting recursively key: ".concat(args[0], " in key: ").concat(key[0]));
              return null;
            }
            return _this3.translate.apply(_this3, args.concat([key]));
          }, options);
          if (options.interpolation) this.interpolator.reset();
        }
        var postProcess = options.postProcess || this.options.postProcess;
        var postProcessorNames = typeof postProcess === 'string' ? [postProcess] : postProcess;
        if (res !== undefined && res !== null && postProcessorNames && postProcessorNames.length && options.applyPostProcessor !== false) {
          res = postProcessor.handle(postProcessorNames, res, key, this.options && this.options.postProcessPassResolved ? _objectSpread$2$1({
            i18nResolved: resolved
          }, options) : options, this);
        }
        return res;
      }
    }, {
      key: "resolve",
      value: function resolve(keys) {
        var _this4 = this;
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var found;
        var usedKey;
        var exactUsedKey;
        var usedLng;
        var usedNS;
        if (typeof keys === 'string') keys = [keys];
        keys.forEach(function (k) {
          if (_this4.isValidLookup(found)) return;
          var extracted = _this4.extractFromKey(k, options);
          var key = extracted.key;
          usedKey = key;
          var namespaces = extracted.namespaces;
          if (_this4.options.fallbackNS) namespaces = namespaces.concat(_this4.options.fallbackNS);
          var needsPluralHandling = options.count !== undefined && typeof options.count !== 'string';
          var needsZeroSuffixLookup = needsPluralHandling && !options.ordinal && options.count === 0 && _this4.pluralResolver.shouldUseIntlApi();
          var needsContextHandling = options.context !== undefined && (typeof options.context === 'string' || typeof options.context === 'number') && options.context !== '';
          var codes = options.lngs ? options.lngs : _this4.languageUtils.toResolveHierarchy(options.lng || _this4.language, options.fallbackLng);
          namespaces.forEach(function (ns) {
            if (_this4.isValidLookup(found)) return;
            usedNS = ns;
            if (!checkedLoadedFor["".concat(codes[0], "-").concat(ns)] && _this4.utils && _this4.utils.hasLoadedNamespace && !_this4.utils.hasLoadedNamespace(usedNS)) {
              checkedLoadedFor["".concat(codes[0], "-").concat(ns)] = true;
              _this4.logger.warn("key \"".concat(usedKey, "\" for languages \"").concat(codes.join(', '), "\" won't get resolved as namespace \"").concat(usedNS, "\" was not yet loaded"), 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
            }
            codes.forEach(function (code) {
              if (_this4.isValidLookup(found)) return;
              usedLng = code;
              var finalKeys = [key];
              if (_this4.i18nFormat && _this4.i18nFormat.addLookupKeys) {
                _this4.i18nFormat.addLookupKeys(finalKeys, key, code, ns, options);
              } else {
                var pluralSuffix;
                if (needsPluralHandling) pluralSuffix = _this4.pluralResolver.getSuffix(code, options.count, options);
                var zeroSuffix = "".concat(_this4.options.pluralSeparator, "zero");
                if (needsPluralHandling) {
                  finalKeys.push(key + pluralSuffix);
                  if (needsZeroSuffixLookup) {
                    finalKeys.push(key + zeroSuffix);
                  }
                }
                if (needsContextHandling) {
                  var contextKey = "".concat(key).concat(_this4.options.contextSeparator).concat(options.context);
                  finalKeys.push(contextKey);
                  if (needsPluralHandling) {
                    finalKeys.push(contextKey + pluralSuffix);
                    if (needsZeroSuffixLookup) {
                      finalKeys.push(contextKey + zeroSuffix);
                    }
                  }
                }
              }
              var possibleKey;
              while (possibleKey = finalKeys.pop()) {
                if (!_this4.isValidLookup(found)) {
                  exactUsedKey = possibleKey;
                  found = _this4.getResource(code, ns, possibleKey, options);
                }
              }
            });
          });
        });
        return {
          res: found,
          usedKey: usedKey,
          exactUsedKey: exactUsedKey,
          usedLng: usedLng,
          usedNS: usedNS
        };
      }
    }, {
      key: "isValidLookup",
      value: function isValidLookup(res) {
        return res !== undefined && !(!this.options.returnNull && res === null) && !(!this.options.returnEmptyString && res === '');
      }
    }, {
      key: "getResource",
      value: function getResource(code, ns, key) {
        var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
        if (this.i18nFormat && this.i18nFormat.getResource) return this.i18nFormat.getResource(code, ns, key, options);
        return this.resourceStore.getResource(code, ns, key, options);
      }
    }], [{
      key: "hasDefaultValue",
      value: function hasDefaultValue(options) {
        var prefix = 'defaultValue';
        for (var option in options) {
          if (Object.prototype.hasOwnProperty.call(options, option) && prefix === option.substring(0, prefix.length) && undefined !== options[option]) {
            return true;
          }
        }
        return false;
      }
    }]);
    return Translator;
  }(EventEmitter);
  function capitalize(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
  }
  var LanguageUtil = function () {
    function LanguageUtil(options) {
      _classCallCheck$1(this, LanguageUtil);
      this.options = options;
      this.supportedLngs = this.options.supportedLngs || false;
      this.logger = baseLogger.create('languageUtils');
    }
    _createClass(LanguageUtil, [{
      key: "getScriptPartFromCode",
      value: function getScriptPartFromCode(code) {
        if (!code || code.indexOf('-') < 0) return null;
        var p = code.split('-');
        if (p.length === 2) return null;
        p.pop();
        if (p[p.length - 1].toLowerCase() === 'x') return null;
        return this.formatLanguageCode(p.join('-'));
      }
    }, {
      key: "getLanguagePartFromCode",
      value: function getLanguagePartFromCode(code) {
        if (!code || code.indexOf('-') < 0) return code;
        var p = code.split('-');
        return this.formatLanguageCode(p[0]);
      }
    }, {
      key: "formatLanguageCode",
      value: function formatLanguageCode(code) {
        if (typeof code === 'string' && code.indexOf('-') > -1) {
          var specialCases = ['hans', 'hant', 'latn', 'cyrl', 'cans', 'mong', 'arab'];
          var p = code.split('-');
          if (this.options.lowerCaseLng) {
            p = p.map(function (part) {
              return part.toLowerCase();
            });
          } else if (p.length === 2) {
            p[0] = p[0].toLowerCase();
            p[1] = p[1].toUpperCase();
            if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
          } else if (p.length === 3) {
            p[0] = p[0].toLowerCase();
            if (p[1].length === 2) p[1] = p[1].toUpperCase();
            if (p[0] !== 'sgn' && p[2].length === 2) p[2] = p[2].toUpperCase();
            if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
            if (specialCases.indexOf(p[2].toLowerCase()) > -1) p[2] = capitalize(p[2].toLowerCase());
          }
          return p.join('-');
        }
        return this.options.cleanCode || this.options.lowerCaseLng ? code.toLowerCase() : code;
      }
    }, {
      key: "isSupportedCode",
      value: function isSupportedCode(code) {
        if (this.options.load === 'languageOnly' || this.options.nonExplicitSupportedLngs) {
          code = this.getLanguagePartFromCode(code);
        }
        return !this.supportedLngs || !this.supportedLngs.length || this.supportedLngs.indexOf(code) > -1;
      }
    }, {
      key: "getBestMatchFromCodes",
      value: function getBestMatchFromCodes(codes) {
        var _this = this;
        if (!codes) return null;
        var found;
        codes.forEach(function (code) {
          if (found) return;
          var cleanedLng = _this.formatLanguageCode(code);
          if (!_this.options.supportedLngs || _this.isSupportedCode(cleanedLng)) found = cleanedLng;
        });
        if (!found && this.options.supportedLngs) {
          codes.forEach(function (code) {
            if (found) return;
            var lngOnly = _this.getLanguagePartFromCode(code);
            if (_this.isSupportedCode(lngOnly)) return found = lngOnly;
            found = _this.options.supportedLngs.find(function (supportedLng) {
              if (supportedLng.indexOf(lngOnly) === 0) return supportedLng;
            });
          });
        }
        if (!found) found = this.getFallbackCodes(this.options.fallbackLng)[0];
        return found;
      }
    }, {
      key: "getFallbackCodes",
      value: function getFallbackCodes(fallbacks, code) {
        if (!fallbacks) return [];
        if (typeof fallbacks === 'function') fallbacks = fallbacks(code);
        if (typeof fallbacks === 'string') fallbacks = [fallbacks];
        if (Object.prototype.toString.apply(fallbacks) === '[object Array]') return fallbacks;
        if (!code) return fallbacks["default"] || [];
        var found = fallbacks[code];
        if (!found) found = fallbacks[this.getScriptPartFromCode(code)];
        if (!found) found = fallbacks[this.formatLanguageCode(code)];
        if (!found) found = fallbacks[this.getLanguagePartFromCode(code)];
        if (!found) found = fallbacks["default"];
        return found || [];
      }
    }, {
      key: "toResolveHierarchy",
      value: function toResolveHierarchy(code, fallbackCode) {
        var _this2 = this;
        var fallbackCodes = this.getFallbackCodes(fallbackCode || this.options.fallbackLng || [], code);
        var codes = [];
        var addCode = function addCode(c) {
          if (!c) return;
          if (_this2.isSupportedCode(c)) {
            codes.push(c);
          } else {
            _this2.logger.warn("rejecting language code not found in supportedLngs: ".concat(c));
          }
        };
        if (typeof code === 'string' && code.indexOf('-') > -1) {
          if (this.options.load !== 'languageOnly') addCode(this.formatLanguageCode(code));
          if (this.options.load !== 'languageOnly' && this.options.load !== 'currentOnly') addCode(this.getScriptPartFromCode(code));
          if (this.options.load !== 'currentOnly') addCode(this.getLanguagePartFromCode(code));
        } else if (typeof code === 'string') {
          addCode(this.formatLanguageCode(code));
        }
        fallbackCodes.forEach(function (fc) {
          if (codes.indexOf(fc) < 0) addCode(_this2.formatLanguageCode(fc));
        });
        return codes;
      }
    }]);
    return LanguageUtil;
  }();
  var sets = [{
    lngs: ['ach', 'ak', 'am', 'arn', 'br', 'fil', 'gun', 'ln', 'mfe', 'mg', 'mi', 'oc', 'pt', 'pt-BR', 'tg', 'tl', 'ti', 'tr', 'uz', 'wa'],
    nr: [1, 2],
    fc: 1
  }, {
    lngs: ['af', 'an', 'ast', 'az', 'bg', 'bn', 'ca', 'da', 'de', 'dev', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fi', 'fo', 'fur', 'fy', 'gl', 'gu', 'ha', 'hi', 'hu', 'hy', 'ia', 'it', 'kk', 'kn', 'ku', 'lb', 'mai', 'ml', 'mn', 'mr', 'nah', 'nap', 'nb', 'ne', 'nl', 'nn', 'no', 'nso', 'pa', 'pap', 'pms', 'ps', 'pt-PT', 'rm', 'sco', 'se', 'si', 'so', 'son', 'sq', 'sv', 'sw', 'ta', 'te', 'tk', 'ur', 'yo'],
    nr: [1, 2],
    fc: 2
  }, {
    lngs: ['ay', 'bo', 'cgg', 'fa', 'ht', 'id', 'ja', 'jbo', 'ka', 'km', 'ko', 'ky', 'lo', 'ms', 'sah', 'su', 'th', 'tt', 'ug', 'vi', 'wo', 'zh'],
    nr: [1],
    fc: 3
  }, {
    lngs: ['be', 'bs', 'cnr', 'dz', 'hr', 'ru', 'sr', 'uk'],
    nr: [1, 2, 5],
    fc: 4
  }, {
    lngs: ['ar'],
    nr: [0, 1, 2, 3, 11, 100],
    fc: 5
  }, {
    lngs: ['cs', 'sk'],
    nr: [1, 2, 5],
    fc: 6
  }, {
    lngs: ['csb', 'pl'],
    nr: [1, 2, 5],
    fc: 7
  }, {
    lngs: ['cy'],
    nr: [1, 2, 3, 8],
    fc: 8
  }, {
    lngs: ['fr'],
    nr: [1, 2],
    fc: 9
  }, {
    lngs: ['ga'],
    nr: [1, 2, 3, 7, 11],
    fc: 10
  }, {
    lngs: ['gd'],
    nr: [1, 2, 3, 20],
    fc: 11
  }, {
    lngs: ['is'],
    nr: [1, 2],
    fc: 12
  }, {
    lngs: ['jv'],
    nr: [0, 1],
    fc: 13
  }, {
    lngs: ['kw'],
    nr: [1, 2, 3, 4],
    fc: 14
  }, {
    lngs: ['lt'],
    nr: [1, 2, 10],
    fc: 15
  }, {
    lngs: ['lv'],
    nr: [1, 2, 0],
    fc: 16
  }, {
    lngs: ['mk'],
    nr: [1, 2],
    fc: 17
  }, {
    lngs: ['mnk'],
    nr: [0, 1, 2],
    fc: 18
  }, {
    lngs: ['mt'],
    nr: [1, 2, 11, 20],
    fc: 19
  }, {
    lngs: ['or'],
    nr: [2, 1],
    fc: 2
  }, {
    lngs: ['ro'],
    nr: [1, 2, 20],
    fc: 20
  }, {
    lngs: ['sl'],
    nr: [5, 1, 2, 3],
    fc: 21
  }, {
    lngs: ['he', 'iw'],
    nr: [1, 2, 20, 21],
    fc: 22
  }];
  var _rulesPluralsTypes = {
    1: function _(n) {
      return Number(n > 1);
    },
    2: function _(n) {
      return Number(n != 1);
    },
    3: function _(n) {
      return 0;
    },
    4: function _(n) {
      return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
    },
    5: function _(n) {
      return Number(n == 0 ? 0 : n == 1 ? 1 : n == 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5);
    },
    6: function _(n) {
      return Number(n == 1 ? 0 : n >= 2 && n <= 4 ? 1 : 2);
    },
    7: function _(n) {
      return Number(n == 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
    },
    8: function _(n) {
      return Number(n == 1 ? 0 : n == 2 ? 1 : n != 8 && n != 11 ? 2 : 3);
    },
    9: function _(n) {
      return Number(n >= 2);
    },
    10: function _(n) {
      return Number(n == 1 ? 0 : n == 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4);
    },
    11: function _(n) {
      return Number(n == 1 || n == 11 ? 0 : n == 2 || n == 12 ? 1 : n > 2 && n < 20 ? 2 : 3);
    },
    12: function _(n) {
      return Number(n % 10 != 1 || n % 100 == 11);
    },
    13: function _(n) {
      return Number(n !== 0);
    },
    14: function _(n) {
      return Number(n == 1 ? 0 : n == 2 ? 1 : n == 3 ? 2 : 3);
    },
    15: function _(n) {
      return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
    },
    16: function _(n) {
      return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n !== 0 ? 1 : 2);
    },
    17: function _(n) {
      return Number(n == 1 || n % 10 == 1 && n % 100 != 11 ? 0 : 1);
    },
    18: function _(n) {
      return Number(n == 0 ? 0 : n == 1 ? 1 : 2);
    },
    19: function _(n) {
      return Number(n == 1 ? 0 : n == 0 || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3);
    },
    20: function _(n) {
      return Number(n == 1 ? 0 : n == 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2);
    },
    21: function _(n) {
      return Number(n % 100 == 1 ? 1 : n % 100 == 2 ? 2 : n % 100 == 3 || n % 100 == 4 ? 3 : 0);
    },
    22: function _(n) {
      return Number(n == 1 ? 0 : n == 2 ? 1 : (n < 0 || n > 10) && n % 10 == 0 ? 2 : 3);
    }
  };
  var deprecatedJsonVersions = ['v1', 'v2', 'v3'];
  var suffixesOrder = {
    zero: 0,
    one: 1,
    two: 2,
    few: 3,
    many: 4,
    other: 5
  };
  function createRules() {
    var rules = {};
    sets.forEach(function (set) {
      set.lngs.forEach(function (l) {
        rules[l] = {
          numbers: set.nr,
          plurals: _rulesPluralsTypes[set.fc]
        };
      });
    });
    return rules;
  }
  var PluralResolver = function () {
    function PluralResolver(languageUtils) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck$1(this, PluralResolver);
      this.languageUtils = languageUtils;
      this.options = options;
      this.logger = baseLogger.create('pluralResolver');
      if ((!this.options.compatibilityJSON || this.options.compatibilityJSON === 'v4') && (typeof Intl === 'undefined' || !Intl.PluralRules)) {
        this.options.compatibilityJSON = 'v3';
        this.logger.error('Your environment seems not to be Intl API compatible, use an Intl.PluralRules polyfill. Will fallback to the compatibilityJSON v3 format handling.');
      }
      this.rules = createRules();
    }
    _createClass(PluralResolver, [{
      key: "addRule",
      value: function addRule(lng, obj) {
        this.rules[lng] = obj;
      }
    }, {
      key: "getRule",
      value: function getRule(code) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (this.shouldUseIntlApi()) {
          try {
            return new Intl.PluralRules(code, {
              type: options.ordinal ? 'ordinal' : 'cardinal'
            });
          } catch (_unused) {
            return;
          }
        }
        return this.rules[code] || this.rules[this.languageUtils.getLanguagePartFromCode(code)];
      }
    }, {
      key: "needsPlural",
      value: function needsPlural(code) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var rule = this.getRule(code, options);
        if (this.shouldUseIntlApi()) {
          return rule && rule.resolvedOptions().pluralCategories.length > 1;
        }
        return rule && rule.numbers.length > 1;
      }
    }, {
      key: "getPluralFormsOfKey",
      value: function getPluralFormsOfKey(code, key) {
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.getSuffixes(code, options).map(function (suffix) {
          return "".concat(key).concat(suffix);
        });
      }
    }, {
      key: "getSuffixes",
      value: function getSuffixes(code) {
        var _this = this;
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var rule = this.getRule(code, options);
        if (!rule) {
          return [];
        }
        if (this.shouldUseIntlApi()) {
          return rule.resolvedOptions().pluralCategories.sort(function (pluralCategory1, pluralCategory2) {
            return suffixesOrder[pluralCategory1] - suffixesOrder[pluralCategory2];
          }).map(function (pluralCategory) {
            return "".concat(_this.options.prepend).concat(pluralCategory);
          });
        }
        return rule.numbers.map(function (number) {
          return _this.getSuffix(code, number, options);
        });
      }
    }, {
      key: "getSuffix",
      value: function getSuffix(code, count) {
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var rule = this.getRule(code, options);
        if (rule) {
          if (this.shouldUseIntlApi()) {
            return "".concat(this.options.prepend).concat(rule.select(count));
          }
          return this.getSuffixRetroCompatible(rule, count);
        }
        this.logger.warn("no plural rule found for: ".concat(code));
        return '';
      }
    }, {
      key: "getSuffixRetroCompatible",
      value: function getSuffixRetroCompatible(rule, count) {
        var _this2 = this;
        var idx = rule.noAbs ? rule.plurals(count) : rule.plurals(Math.abs(count));
        var suffix = rule.numbers[idx];
        if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
          if (suffix === 2) {
            suffix = 'plural';
          } else if (suffix === 1) {
            suffix = '';
          }
        }
        var returnSuffix = function returnSuffix() {
          return _this2.options.prepend && suffix.toString() ? _this2.options.prepend + suffix.toString() : suffix.toString();
        };
        if (this.options.compatibilityJSON === 'v1') {
          if (suffix === 1) return '';
          if (typeof suffix === 'number') return "_plural_".concat(suffix.toString());
          return returnSuffix();
        } else if (this.options.compatibilityJSON === 'v2') {
          return returnSuffix();
        } else if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
          return returnSuffix();
        }
        return this.options.prepend && idx.toString() ? this.options.prepend + idx.toString() : idx.toString();
      }
    }, {
      key: "shouldUseIntlApi",
      value: function shouldUseIntlApi() {
        return !deprecatedJsonVersions.includes(this.options.compatibilityJSON);
      }
    }]);
    return PluralResolver;
  }();
  function ownKeys$3$1(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$3$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$3$1(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$3$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  var Interpolator = function () {
    function Interpolator() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck$1(this, Interpolator);
      this.logger = baseLogger.create('interpolator');
      this.options = options;
      this.format = options.interpolation && options.interpolation.format || function (value) {
        return value;
      };
      this.init(options);
    }
    _createClass(Interpolator, [{
      key: "init",
      value: function init() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        if (!options.interpolation) options.interpolation = {
          escapeValue: true
        };
        var iOpts = options.interpolation;
        this.escape = iOpts.escape !== undefined ? iOpts.escape : escape$1;
        this.escapeValue = iOpts.escapeValue !== undefined ? iOpts.escapeValue : true;
        this.useRawValueToEscape = iOpts.useRawValueToEscape !== undefined ? iOpts.useRawValueToEscape : false;
        this.prefix = iOpts.prefix ? regexEscape$1(iOpts.prefix) : iOpts.prefixEscaped || '{{';
        this.suffix = iOpts.suffix ? regexEscape$1(iOpts.suffix) : iOpts.suffixEscaped || '}}';
        this.formatSeparator = iOpts.formatSeparator ? iOpts.formatSeparator : iOpts.formatSeparator || ',';
        this.unescapePrefix = iOpts.unescapeSuffix ? '' : iOpts.unescapePrefix || '-';
        this.unescapeSuffix = this.unescapePrefix ? '' : iOpts.unescapeSuffix || '';
        this.nestingPrefix = iOpts.nestingPrefix ? regexEscape$1(iOpts.nestingPrefix) : iOpts.nestingPrefixEscaped || regexEscape$1('$t(');
        this.nestingSuffix = iOpts.nestingSuffix ? regexEscape$1(iOpts.nestingSuffix) : iOpts.nestingSuffixEscaped || regexEscape$1(')');
        this.nestingOptionsSeparator = iOpts.nestingOptionsSeparator ? iOpts.nestingOptionsSeparator : iOpts.nestingOptionsSeparator || ',';
        this.maxReplaces = iOpts.maxReplaces ? iOpts.maxReplaces : 1000;
        this.alwaysFormat = iOpts.alwaysFormat !== undefined ? iOpts.alwaysFormat : false;
        this.resetRegExp();
      }
    }, {
      key: "reset",
      value: function reset() {
        if (this.options) this.init(this.options);
      }
    }, {
      key: "resetRegExp",
      value: function resetRegExp() {
        var regexpStr = "".concat(this.prefix, "(.+?)").concat(this.suffix);
        this.regexp = new RegExp(regexpStr, 'g');
        var regexpUnescapeStr = "".concat(this.prefix).concat(this.unescapePrefix, "(.+?)").concat(this.unescapeSuffix).concat(this.suffix);
        this.regexpUnescape = new RegExp(regexpUnescapeStr, 'g');
        var nestingRegexpStr = "".concat(this.nestingPrefix, "(.+?)").concat(this.nestingSuffix);
        this.nestingRegexp = new RegExp(nestingRegexpStr, 'g');
      }
    }, {
      key: "interpolate",
      value: function interpolate(str, data, lng, options) {
        var _this = this;
        var match;
        var value;
        var replaces;
        var defaultData = this.options && this.options.interpolation && this.options.interpolation.defaultVariables || {};
        function regexSafe(val) {
          return val.replace(/\$/g, '$$$$');
        }
        var handleFormat = function handleFormat(key) {
          if (key.indexOf(_this.formatSeparator) < 0) {
            var path = getPathWithDefaults(data, defaultData, key);
            return _this.alwaysFormat ? _this.format(path, undefined, lng, _objectSpread$3$1(_objectSpread$3$1(_objectSpread$3$1({}, options), data), {}, {
              interpolationkey: key
            })) : path;
          }
          var p = key.split(_this.formatSeparator);
          var k = p.shift().trim();
          var f = p.join(_this.formatSeparator).trim();
          return _this.format(getPathWithDefaults(data, defaultData, k), f, lng, _objectSpread$3$1(_objectSpread$3$1(_objectSpread$3$1({}, options), data), {}, {
            interpolationkey: k
          }));
        };
        this.resetRegExp();
        var missingInterpolationHandler = options && options.missingInterpolationHandler || this.options.missingInterpolationHandler;
        var skipOnVariables = options && options.interpolation && options.interpolation.skipOnVariables !== undefined ? options.interpolation.skipOnVariables : this.options.interpolation.skipOnVariables;
        var todos = [{
          regex: this.regexpUnescape,
          safeValue: function safeValue(val) {
            return regexSafe(val);
          }
        }, {
          regex: this.regexp,
          safeValue: function safeValue(val) {
            return _this.escapeValue ? regexSafe(_this.escape(val)) : regexSafe(val);
          }
        }];
        todos.forEach(function (todo) {
          replaces = 0;
          while (match = todo.regex.exec(str)) {
            var matchedVar = match[1].trim();
            value = handleFormat(matchedVar);
            if (value === undefined) {
              if (typeof missingInterpolationHandler === 'function') {
                var temp = missingInterpolationHandler(str, match, options);
                value = typeof temp === 'string' ? temp : '';
              } else if (options && options.hasOwnProperty(matchedVar)) {
                value = '';
              } else if (skipOnVariables) {
                value = match[0];
                continue;
              } else {
                _this.logger.warn("missed to pass in variable ".concat(matchedVar, " for interpolating ").concat(str));
                value = '';
              }
            } else if (typeof value !== 'string' && !_this.useRawValueToEscape) {
              value = makeString(value);
            }
            var safeValue = todo.safeValue(value);
            str = str.replace(match[0], safeValue);
            if (skipOnVariables) {
              todo.regex.lastIndex += value.length;
              todo.regex.lastIndex -= match[0].length;
            } else {
              todo.regex.lastIndex = 0;
            }
            replaces++;
            if (replaces >= _this.maxReplaces) {
              break;
            }
          }
        });
        return str;
      }
    }, {
      key: "nest",
      value: function nest(str, fc) {
        var _this2 = this;
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var match;
        var value;
        var clonedOptions = _objectSpread$3$1({}, options);
        clonedOptions.applyPostProcessor = false;
        delete clonedOptions.defaultValue;
        function handleHasOptions(key, inheritedOptions) {
          var sep = this.nestingOptionsSeparator;
          if (key.indexOf(sep) < 0) return key;
          var c = key.split(new RegExp("".concat(sep, "[ ]*{")));
          var optionsString = "{".concat(c[1]);
          key = c[0];
          optionsString = this.interpolate(optionsString, clonedOptions);
          var matchedSingleQuotes = optionsString.match(/'/g);
          var matchedDoubleQuotes = optionsString.match(/"/g);
          if (matchedSingleQuotes && matchedSingleQuotes.length % 2 === 0 && !matchedDoubleQuotes || matchedDoubleQuotes.length % 2 !== 0) {
            optionsString = optionsString.replace(/'/g, '"');
          }
          try {
            clonedOptions = JSON.parse(optionsString);
            if (inheritedOptions) clonedOptions = _objectSpread$3$1(_objectSpread$3$1({}, inheritedOptions), clonedOptions);
          } catch (e) {
            this.logger.warn("failed parsing options string in nesting for key ".concat(key), e);
            return "".concat(key).concat(sep).concat(optionsString);
          }
          delete clonedOptions.defaultValue;
          return key;
        }
        while (match = this.nestingRegexp.exec(str)) {
          var formatters = [];
          var doReduce = false;
          if (match[0].indexOf(this.formatSeparator) !== -1 && !/{.*}/.test(match[1])) {
            var r = match[1].split(this.formatSeparator).map(function (elem) {
              return elem.trim();
            });
            match[1] = r.shift();
            formatters = r;
            doReduce = true;
          }
          value = fc(handleHasOptions.call(this, match[1].trim(), clonedOptions), clonedOptions);
          if (value && match[0] === str && typeof value !== 'string') return value;
          if (typeof value !== 'string') value = makeString(value);
          if (!value) {
            this.logger.warn("missed to resolve ".concat(match[1], " for nesting ").concat(str));
            value = '';
          }
          if (doReduce) {
            value = formatters.reduce(function (v, f) {
              return _this2.format(v, f, options.lng, _objectSpread$3$1(_objectSpread$3$1({}, options), {}, {
                interpolationkey: match[1].trim()
              }));
            }, value.trim());
          }
          str = str.replace(match[0], value);
          this.regexp.lastIndex = 0;
        }
        return str;
      }
    }]);
    return Interpolator;
  }();
  function ownKeys$4$1(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$4(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$4$1(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$4$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function parseFormatStr(formatStr) {
    var formatName = formatStr.toLowerCase().trim();
    var formatOptions = {};
    if (formatStr.indexOf('(') > -1) {
      var p = formatStr.split('(');
      formatName = p[0].toLowerCase().trim();
      var optStr = p[1].substring(0, p[1].length - 1);
      if (formatName === 'currency' && optStr.indexOf(':') < 0) {
        if (!formatOptions.currency) formatOptions.currency = optStr.trim();
      } else if (formatName === 'relativetime' && optStr.indexOf(':') < 0) {
        if (!formatOptions.range) formatOptions.range = optStr.trim();
      } else {
        var opts = optStr.split(';');
        opts.forEach(function (opt) {
          if (!opt) return;
          var _opt$split = opt.split(':'),
            _opt$split2 = _toArray(_opt$split),
            key = _opt$split2[0],
            rest = _opt$split2.slice(1);
          var val = rest.join(':').trim().replace(/^'+|'+$/g, '');
          if (!formatOptions[key.trim()]) formatOptions[key.trim()] = val;
          if (val === 'false') formatOptions[key.trim()] = false;
          if (val === 'true') formatOptions[key.trim()] = true;
          if (!isNaN(val)) formatOptions[key.trim()] = parseInt(val, 10);
        });
      }
    }
    return {
      formatName: formatName,
      formatOptions: formatOptions
    };
  }
  function createCachedFormatter(fn) {
    var cache = {};
    return function invokeFormatter(val, lng, options) {
      var key = lng + JSON.stringify(options);
      var formatter = cache[key];
      if (!formatter) {
        formatter = fn(lng, options);
        cache[key] = formatter;
      }
      return formatter(val);
    };
  }
  var Formatter = function () {
    function Formatter() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck$1(this, Formatter);
      this.logger = baseLogger.create('formatter');
      this.options = options;
      this.formats = {
        number: createCachedFormatter(function (lng, options) {
          var formatter = new Intl.NumberFormat(lng, options);
          return function (val) {
            return formatter.format(val);
          };
        }),
        currency: createCachedFormatter(function (lng, options) {
          var formatter = new Intl.NumberFormat(lng, _objectSpread$4(_objectSpread$4({}, options), {}, {
            style: 'currency'
          }));
          return function (val) {
            return formatter.format(val);
          };
        }),
        datetime: createCachedFormatter(function (lng, options) {
          var formatter = new Intl.DateTimeFormat(lng, _objectSpread$4({}, options));
          return function (val) {
            return formatter.format(val);
          };
        }),
        relativetime: createCachedFormatter(function (lng, options) {
          var formatter = new Intl.RelativeTimeFormat(lng, _objectSpread$4({}, options));
          return function (val) {
            return formatter.format(val, options.range || 'day');
          };
        }),
        list: createCachedFormatter(function (lng, options) {
          var formatter = new Intl.ListFormat(lng, _objectSpread$4({}, options));
          return function (val) {
            return formatter.format(val);
          };
        })
      };
      this.init(options);
    }
    _createClass(Formatter, [{
      key: "init",
      value: function init(services) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          interpolation: {}
        };
        var iOpts = options.interpolation;
        this.formatSeparator = iOpts.formatSeparator ? iOpts.formatSeparator : iOpts.formatSeparator || ',';
      }
    }, {
      key: "add",
      value: function add(name, fc) {
        this.formats[name.toLowerCase().trim()] = fc;
      }
    }, {
      key: "addCached",
      value: function addCached(name, fc) {
        this.formats[name.toLowerCase().trim()] = createCachedFormatter(fc);
      }
    }, {
      key: "format",
      value: function format(value, _format, lng, options) {
        var _this = this;
        var formats = _format.split(this.formatSeparator);
        var result = formats.reduce(function (mem, f) {
          var _parseFormatStr = parseFormatStr(f),
            formatName = _parseFormatStr.formatName,
            formatOptions = _parseFormatStr.formatOptions;
          if (_this.formats[formatName]) {
            var formatted = mem;
            try {
              var valOptions = options && options.formatParams && options.formatParams[options.interpolationkey] || {};
              var l = valOptions.locale || valOptions.lng || options.locale || options.lng || lng;
              formatted = _this.formats[formatName](mem, l, _objectSpread$4(_objectSpread$4(_objectSpread$4({}, formatOptions), options), valOptions));
            } catch (error) {
              _this.logger.warn(error);
            }
            return formatted;
          } else {
            _this.logger.warn("there was no format function for ".concat(formatName));
          }
          return mem;
        }, value);
        return result;
      }
    }]);
    return Formatter;
  }();
  function ownKeys$5$1(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$5(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$5$1(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$5$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _createSuper$2(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$2();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
        result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _isNativeReflectConstruct$2() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function removePending(q, name) {
    if (q.pending[name] !== undefined) {
      delete q.pending[name];
      q.pendingCount--;
    }
  }
  var Connector = function (_EventEmitter) {
    _inherits(Connector, _EventEmitter);
    var _super = _createSuper$2(Connector);
    function Connector(backend, store, services) {
      var _this;
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      _classCallCheck$1(this, Connector);
      _this = _super.call(this);
      if (isIE10) {
        EventEmitter.call(_assertThisInitialized(_this));
      }
      _this.backend = backend;
      _this.store = store;
      _this.services = services;
      _this.languageUtils = services.languageUtils;
      _this.options = options;
      _this.logger = baseLogger.create('backendConnector');
      _this.waitingReads = [];
      _this.maxParallelReads = options.maxParallelReads || 10;
      _this.readingCalls = 0;
      _this.maxRetries = options.maxRetries >= 0 ? options.maxRetries : 5;
      _this.retryTimeout = options.retryTimeout >= 1 ? options.retryTimeout : 350;
      _this.state = {};
      _this.queue = [];
      if (_this.backend && _this.backend.init) {
        _this.backend.init(services, options.backend, options);
      }
      return _this;
    }
    _createClass(Connector, [{
      key: "queueLoad",
      value: function queueLoad(languages, namespaces, options, callback) {
        var _this2 = this;
        var toLoad = {};
        var pending = {};
        var toLoadLanguages = {};
        var toLoadNamespaces = {};
        languages.forEach(function (lng) {
          var hasAllNamespaces = true;
          namespaces.forEach(function (ns) {
            var name = "".concat(lng, "|").concat(ns);
            if (!options.reload && _this2.store.hasResourceBundle(lng, ns)) {
              _this2.state[name] = 2;
            } else if (_this2.state[name] < 0) ;else if (_this2.state[name] === 1) {
              if (pending[name] === undefined) pending[name] = true;
            } else {
              _this2.state[name] = 1;
              hasAllNamespaces = false;
              if (pending[name] === undefined) pending[name] = true;
              if (toLoad[name] === undefined) toLoad[name] = true;
              if (toLoadNamespaces[ns] === undefined) toLoadNamespaces[ns] = true;
            }
          });
          if (!hasAllNamespaces) toLoadLanguages[lng] = true;
        });
        if (Object.keys(toLoad).length || Object.keys(pending).length) {
          this.queue.push({
            pending: pending,
            pendingCount: Object.keys(pending).length,
            loaded: {},
            errors: [],
            callback: callback
          });
        }
        return {
          toLoad: Object.keys(toLoad),
          pending: Object.keys(pending),
          toLoadLanguages: Object.keys(toLoadLanguages),
          toLoadNamespaces: Object.keys(toLoadNamespaces)
        };
      }
    }, {
      key: "loaded",
      value: function loaded(name, err, data) {
        var s = name.split('|');
        var lng = s[0];
        var ns = s[1];
        if (err) this.emit('failedLoading', lng, ns, err);
        if (data) {
          this.store.addResourceBundle(lng, ns, data);
        }
        this.state[name] = err ? -1 : 2;
        var loaded = {};
        this.queue.forEach(function (q) {
          pushPath(q.loaded, [lng], ns);
          removePending(q, name);
          if (err) q.errors.push(err);
          if (q.pendingCount === 0 && !q.done) {
            Object.keys(q.loaded).forEach(function (l) {
              if (!loaded[l]) loaded[l] = {};
              var loadedKeys = q.loaded[l];
              if (loadedKeys.length) {
                loadedKeys.forEach(function (ns) {
                  if (loaded[l][ns] === undefined) loaded[l][ns] = true;
                });
              }
            });
            q.done = true;
            if (q.errors.length) {
              q.callback(q.errors);
            } else {
              q.callback();
            }
          }
        });
        this.emit('loaded', loaded);
        this.queue = this.queue.filter(function (q) {
          return !q.done;
        });
      }
    }, {
      key: "read",
      value: function read(lng, ns, fcName) {
        var _this3 = this;
        var tried = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
        var wait = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.retryTimeout;
        var callback = arguments.length > 5 ? arguments[5] : undefined;
        if (!lng.length) return callback(null, {});
        if (this.readingCalls >= this.maxParallelReads) {
          this.waitingReads.push({
            lng: lng,
            ns: ns,
            fcName: fcName,
            tried: tried,
            wait: wait,
            callback: callback
          });
          return;
        }
        this.readingCalls++;
        return this.backend[fcName](lng, ns, function (err, data) {
          _this3.readingCalls--;
          if (_this3.waitingReads.length > 0) {
            var next = _this3.waitingReads.shift();
            _this3.read(next.lng, next.ns, next.fcName, next.tried, next.wait, next.callback);
          }
          if (err && data && tried < _this3.maxRetries) {
            setTimeout(function () {
              _this3.read.call(_this3, lng, ns, fcName, tried + 1, wait * 2, callback);
            }, wait);
            return;
          }
          callback(err, data);
        });
      }
    }, {
      key: "prepareLoading",
      value: function prepareLoading(languages, namespaces) {
        var _this4 = this;
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        var callback = arguments.length > 3 ? arguments[3] : undefined;
        if (!this.backend) {
          this.logger.warn('No backend was added via i18next.use. Will not load resources.');
          return callback && callback();
        }
        if (typeof languages === 'string') languages = this.languageUtils.toResolveHierarchy(languages);
        if (typeof namespaces === 'string') namespaces = [namespaces];
        var toLoad = this.queueLoad(languages, namespaces, options, callback);
        if (!toLoad.toLoad.length) {
          if (!toLoad.pending.length) callback();
          return null;
        }
        toLoad.toLoad.forEach(function (name) {
          _this4.loadOne(name);
        });
      }
    }, {
      key: "load",
      value: function load(languages, namespaces, callback) {
        this.prepareLoading(languages, namespaces, {}, callback);
      }
    }, {
      key: "reload",
      value: function reload(languages, namespaces, callback) {
        this.prepareLoading(languages, namespaces, {
          reload: true
        }, callback);
      }
    }, {
      key: "loadOne",
      value: function loadOne(name) {
        var _this5 = this;
        var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var s = name.split('|');
        var lng = s[0];
        var ns = s[1];
        this.read(lng, ns, 'read', undefined, undefined, function (err, data) {
          if (err) _this5.logger.warn("".concat(prefix, "loading namespace ").concat(ns, " for language ").concat(lng, " failed"), err);
          if (!err && data) _this5.logger.log("".concat(prefix, "loaded namespace ").concat(ns, " for language ").concat(lng), data);
          _this5.loaded(name, err, data);
        });
      }
    }, {
      key: "saveMissing",
      value: function saveMissing(languages, namespace, key, fallbackValue, isUpdate) {
        var options = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};
        if (this.services.utils && this.services.utils.hasLoadedNamespace && !this.services.utils.hasLoadedNamespace(namespace)) {
          this.logger.warn("did not save key \"".concat(key, "\" as the namespace \"").concat(namespace, "\" was not yet loaded"), 'This means something IS WRONG in your setup. You access the t function before i18next.init / i18next.loadNamespace / i18next.changeLanguage was done. Wait for the callback or Promise to resolve before accessing it!!!');
          return;
        }
        if (key === undefined || key === null || key === '') return;
        if (this.backend && this.backend.create) {
          this.backend.create(languages, namespace, key, fallbackValue, null, _objectSpread$5(_objectSpread$5({}, options), {}, {
            isUpdate: isUpdate
          }));
        }
        if (!languages || !languages[0]) return;
        this.store.addResource(languages[0], namespace, key, fallbackValue);
      }
    }]);
    return Connector;
  }(EventEmitter);
  function get$1() {
    return {
      debug: false,
      initImmediate: true,
      ns: ['translation'],
      defaultNS: ['translation'],
      fallbackLng: ['dev'],
      fallbackNS: false,
      supportedLngs: false,
      nonExplicitSupportedLngs: false,
      load: 'all',
      preload: false,
      simplifyPluralSuffix: true,
      keySeparator: '.',
      nsSeparator: ':',
      pluralSeparator: '_',
      contextSeparator: '_',
      partialBundledLanguages: false,
      saveMissing: false,
      updateMissing: false,
      saveMissingTo: 'fallback',
      saveMissingPlurals: true,
      missingKeyHandler: false,
      missingInterpolationHandler: false,
      postProcess: false,
      postProcessPassResolved: false,
      returnNull: true,
      returnEmptyString: true,
      returnObjects: false,
      joinArrays: false,
      returnedObjectHandler: false,
      parseMissingKeyHandler: false,
      appendNamespaceToMissingKey: false,
      appendNamespaceToCIMode: false,
      overloadTranslationOptionHandler: function handle(args) {
        var ret = {};
        if (_typeof$2(args[1]) === 'object') ret = args[1];
        if (typeof args[1] === 'string') ret.defaultValue = args[1];
        if (typeof args[2] === 'string') ret.tDescription = args[2];
        if (_typeof$2(args[2]) === 'object' || _typeof$2(args[3]) === 'object') {
          var options = args[3] || args[2];
          Object.keys(options).forEach(function (key) {
            ret[key] = options[key];
          });
        }
        return ret;
      },
      interpolation: {
        escapeValue: true,
        format: function format(value, _format, lng, options) {
          return value;
        },
        prefix: '{{',
        suffix: '}}',
        formatSeparator: ',',
        unescapePrefix: '-',
        nestingPrefix: '$t(',
        nestingSuffix: ')',
        nestingOptionsSeparator: ',',
        maxReplaces: 1000,
        skipOnVariables: true
      }
    };
  }
  function transformOptions(options) {
    if (typeof options.ns === 'string') options.ns = [options.ns];
    if (typeof options.fallbackLng === 'string') options.fallbackLng = [options.fallbackLng];
    if (typeof options.fallbackNS === 'string') options.fallbackNS = [options.fallbackNS];
    if (options.supportedLngs && options.supportedLngs.indexOf('cimode') < 0) {
      options.supportedLngs = options.supportedLngs.concat(['cimode']);
    }
    return options;
  }
  function ownKeys$6(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }
      keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread$6(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      if (i % 2) {
        ownKeys$6(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$6(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _createSuper$3(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$3();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
        result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _isNativeReflectConstruct$3() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function noop$2() {}
  function bindMemberFunctions(inst) {
    var mems = Object.getOwnPropertyNames(Object.getPrototypeOf(inst));
    mems.forEach(function (mem) {
      if (typeof inst[mem] === 'function') {
        inst[mem] = inst[mem].bind(inst);
      }
    });
  }
  var I18n = function (_EventEmitter) {
    _inherits(I18n, _EventEmitter);
    var _super = _createSuper$3(I18n);
    function I18n() {
      var _this;
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var callback = arguments.length > 1 ? arguments[1] : undefined;
      _classCallCheck$1(this, I18n);
      _this = _super.call(this);
      if (isIE10) {
        EventEmitter.call(_assertThisInitialized(_this));
      }
      _this.options = transformOptions(options);
      _this.services = {};
      _this.logger = baseLogger;
      _this.modules = {
        external: []
      };
      bindMemberFunctions(_assertThisInitialized(_this));
      if (callback && !_this.isInitialized && !options.isClone) {
        if (!_this.options.initImmediate) {
          _this.init(options, callback);
          return _possibleConstructorReturn(_this, _assertThisInitialized(_this));
        }
        setTimeout(function () {
          _this.init(options, callback);
        }, 0);
      }
      return _this;
    }
    _createClass(I18n, [{
      key: "init",
      value: function init() {
        var _this2 = this;
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var callback = arguments.length > 1 ? arguments[1] : undefined;
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        if (!options.defaultNS && options.defaultNS !== false && options.ns) {
          if (typeof options.ns === 'string') {
            options.defaultNS = options.ns;
          } else if (options.ns.indexOf('translation') < 0) {
            options.defaultNS = options.ns[0];
          }
        }
        var defOpts = get$1();
        this.options = _objectSpread$6(_objectSpread$6(_objectSpread$6({}, defOpts), this.options), transformOptions(options));
        if (this.options.compatibilityAPI !== 'v1') {
          this.options.interpolation = _objectSpread$6(_objectSpread$6({}, defOpts.interpolation), this.options.interpolation);
        }
        if (options.keySeparator !== undefined) {
          this.options.userDefinedKeySeparator = options.keySeparator;
        }
        if (options.nsSeparator !== undefined) {
          this.options.userDefinedNsSeparator = options.nsSeparator;
        }
        function createClassOnDemand(ClassOrObject) {
          if (!ClassOrObject) return null;
          if (typeof ClassOrObject === 'function') return new ClassOrObject();
          return ClassOrObject;
        }
        if (!this.options.isClone) {
          if (this.modules.logger) {
            baseLogger.init(createClassOnDemand(this.modules.logger), this.options);
          } else {
            baseLogger.init(null, this.options);
          }
          var formatter;
          if (this.modules.formatter) {
            formatter = this.modules.formatter;
          } else if (typeof Intl !== 'undefined') {
            formatter = Formatter;
          }
          var lu = new LanguageUtil(this.options);
          this.store = new ResourceStore(this.options.resources, this.options);
          var s = this.services;
          s.logger = baseLogger;
          s.resourceStore = this.store;
          s.languageUtils = lu;
          s.pluralResolver = new PluralResolver(lu, {
            prepend: this.options.pluralSeparator,
            compatibilityJSON: this.options.compatibilityJSON,
            simplifyPluralSuffix: this.options.simplifyPluralSuffix
          });
          if (formatter && (!this.options.interpolation.format || this.options.interpolation.format === defOpts.interpolation.format)) {
            s.formatter = createClassOnDemand(formatter);
            s.formatter.init(s, this.options);
            this.options.interpolation.format = s.formatter.format.bind(s.formatter);
          }
          s.interpolator = new Interpolator(this.options);
          s.utils = {
            hasLoadedNamespace: this.hasLoadedNamespace.bind(this)
          };
          s.backendConnector = new Connector(createClassOnDemand(this.modules.backend), s.resourceStore, s, this.options);
          s.backendConnector.on('*', function (event) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }
            _this2.emit.apply(_this2, [event].concat(args));
          });
          if (this.modules.languageDetector) {
            s.languageDetector = createClassOnDemand(this.modules.languageDetector);
            s.languageDetector.init(s, this.options.detection, this.options);
          }
          if (this.modules.i18nFormat) {
            s.i18nFormat = createClassOnDemand(this.modules.i18nFormat);
            if (s.i18nFormat.init) s.i18nFormat.init(this);
          }
          this.translator = new Translator(this.services, this.options);
          this.translator.on('*', function (event) {
            for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
              args[_key2 - 1] = arguments[_key2];
            }
            _this2.emit.apply(_this2, [event].concat(args));
          });
          this.modules.external.forEach(function (m) {
            if (m.init) m.init(_this2);
          });
        }
        this.format = this.options.interpolation.format;
        if (!callback) callback = noop$2;
        if (this.options.fallbackLng && !this.services.languageDetector && !this.options.lng) {
          var codes = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
          if (codes.length > 0 && codes[0] !== 'dev') this.options.lng = codes[0];
        }
        if (!this.services.languageDetector && !this.options.lng) {
          this.logger.warn('init: no languageDetector is used and no lng is defined');
        }
        var storeApi = ['getResource', 'hasResourceBundle', 'getResourceBundle', 'getDataByLanguage'];
        storeApi.forEach(function (fcName) {
          _this2[fcName] = function () {
            var _this2$store;
            return (_this2$store = _this2.store)[fcName].apply(_this2$store, arguments);
          };
        });
        var storeApiChained = ['addResource', 'addResources', 'addResourceBundle', 'removeResourceBundle'];
        storeApiChained.forEach(function (fcName) {
          _this2[fcName] = function () {
            var _this2$store2;
            (_this2$store2 = _this2.store)[fcName].apply(_this2$store2, arguments);
            return _this2;
          };
        });
        var deferred = defer$1();
        var load = function load() {
          var finish = function finish(err, t) {
            if (_this2.isInitialized && !_this2.initializedStoreOnce) _this2.logger.warn('init: i18next is already initialized. You should call init just once!');
            _this2.isInitialized = true;
            if (!_this2.options.isClone) _this2.logger.log('initialized', _this2.options);
            _this2.emit('initialized', _this2.options);
            deferred.resolve(t);
            callback(err, t);
          };
          if (_this2.languages && _this2.options.compatibilityAPI !== 'v1' && !_this2.isInitialized) return finish(null, _this2.t.bind(_this2));
          _this2.changeLanguage(_this2.options.lng, finish);
        };
        if (this.options.resources || !this.options.initImmediate) {
          load();
        } else {
          setTimeout(load, 0);
        }
        return deferred;
      }
    }, {
      key: "loadResources",
      value: function loadResources(language) {
        var _this3 = this;
        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop$2;
        var usedCallback = callback;
        var usedLng = typeof language === 'string' ? language : this.language;
        if (typeof language === 'function') usedCallback = language;
        if (!this.options.resources || this.options.partialBundledLanguages) {
          if (usedLng && usedLng.toLowerCase() === 'cimode') return usedCallback();
          var toLoad = [];
          var append = function append(lng) {
            if (!lng) return;
            var lngs = _this3.services.languageUtils.toResolveHierarchy(lng);
            lngs.forEach(function (l) {
              if (toLoad.indexOf(l) < 0) toLoad.push(l);
            });
          };
          if (!usedLng) {
            var fallbacks = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
            fallbacks.forEach(function (l) {
              return append(l);
            });
          } else {
            append(usedLng);
          }
          if (this.options.preload) {
            this.options.preload.forEach(function (l) {
              return append(l);
            });
          }
          this.services.backendConnector.load(toLoad, this.options.ns, function (e) {
            if (!e && !_this3.resolvedLanguage && _this3.language) _this3.setResolvedLanguage(_this3.language);
            usedCallback(e);
          });
        } else {
          usedCallback(null);
        }
      }
    }, {
      key: "reloadResources",
      value: function reloadResources(lngs, ns, callback) {
        var deferred = defer$1();
        if (!lngs) lngs = this.languages;
        if (!ns) ns = this.options.ns;
        if (!callback) callback = noop$2;
        this.services.backendConnector.reload(lngs, ns, function (err) {
          deferred.resolve();
          callback(err);
        });
        return deferred;
      }
    }, {
      key: "use",
      value: function use(module) {
        if (!module) throw new Error('You are passing an undefined module! Please check the object you are passing to i18next.use()');
        if (!module.type) throw new Error('You are passing a wrong module! Please check the object you are passing to i18next.use()');
        if (module.type === 'backend') {
          this.modules.backend = module;
        }
        if (module.type === 'logger' || module.log && module.warn && module.error) {
          this.modules.logger = module;
        }
        if (module.type === 'languageDetector') {
          this.modules.languageDetector = module;
        }
        if (module.type === 'i18nFormat') {
          this.modules.i18nFormat = module;
        }
        if (module.type === 'postProcessor') {
          postProcessor.addPostProcessor(module);
        }
        if (module.type === 'formatter') {
          this.modules.formatter = module;
        }
        if (module.type === '3rdParty') {
          this.modules.external.push(module);
        }
        return this;
      }
    }, {
      key: "setResolvedLanguage",
      value: function setResolvedLanguage(l) {
        if (!l || !this.languages) return;
        if (['cimode', 'dev'].indexOf(l) > -1) return;
        for (var li = 0; li < this.languages.length; li++) {
          var lngInLngs = this.languages[li];
          if (['cimode', 'dev'].indexOf(lngInLngs) > -1) continue;
          if (this.store.hasLanguageSomeTranslations(lngInLngs)) {
            this.resolvedLanguage = lngInLngs;
            break;
          }
        }
      }
    }, {
      key: "changeLanguage",
      value: function changeLanguage(lng, callback) {
        var _this4 = this;
        this.isLanguageChangingTo = lng;
        var deferred = defer$1();
        this.emit('languageChanging', lng);
        var setLngProps = function setLngProps(l) {
          _this4.language = l;
          _this4.languages = _this4.services.languageUtils.toResolveHierarchy(l);
          _this4.resolvedLanguage = undefined;
          _this4.setResolvedLanguage(l);
        };
        var done = function done(err, l) {
          if (l) {
            setLngProps(l);
            _this4.translator.changeLanguage(l);
            _this4.isLanguageChangingTo = undefined;
            _this4.emit('languageChanged', l);
            _this4.logger.log('languageChanged', l);
          } else {
            _this4.isLanguageChangingTo = undefined;
          }
          deferred.resolve(function () {
            return _this4.t.apply(_this4, arguments);
          });
          if (callback) callback(err, function () {
            return _this4.t.apply(_this4, arguments);
          });
        };
        var setLng = function setLng(lngs) {
          if (!lng && !lngs && _this4.services.languageDetector) lngs = [];
          var l = typeof lngs === 'string' ? lngs : _this4.services.languageUtils.getBestMatchFromCodes(lngs);
          if (l) {
            if (!_this4.language) {
              setLngProps(l);
            }
            if (!_this4.translator.language) _this4.translator.changeLanguage(l);
            if (_this4.services.languageDetector) _this4.services.languageDetector.cacheUserLanguage(l);
          }
          _this4.loadResources(l, function (err) {
            done(err, l);
          });
        };
        if (!lng && this.services.languageDetector && !this.services.languageDetector.async) {
          setLng(this.services.languageDetector.detect());
        } else if (!lng && this.services.languageDetector && this.services.languageDetector.async) {
          this.services.languageDetector.detect(setLng);
        } else {
          setLng(lng);
        }
        return deferred;
      }
    }, {
      key: "getFixedT",
      value: function getFixedT(lng, ns, keyPrefix) {
        var _this5 = this;
        var fixedT = function fixedT(key, opts) {
          var options;
          if (_typeof$2(opts) !== 'object') {
            for (var _len3 = arguments.length, rest = new Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
              rest[_key3 - 2] = arguments[_key3];
            }
            options = _this5.options.overloadTranslationOptionHandler([key, opts].concat(rest));
          } else {
            options = _objectSpread$6({}, opts);
          }
          options.lng = options.lng || fixedT.lng;
          options.lngs = options.lngs || fixedT.lngs;
          options.ns = options.ns || fixedT.ns;
          options.keyPrefix = options.keyPrefix || keyPrefix || fixedT.keyPrefix;
          var keySeparator = _this5.options.keySeparator || '.';
          var resultKey = options.keyPrefix ? "".concat(options.keyPrefix).concat(keySeparator).concat(key) : key;
          return _this5.t(resultKey, options);
        };
        if (typeof lng === 'string') {
          fixedT.lng = lng;
        } else {
          fixedT.lngs = lng;
        }
        fixedT.ns = ns;
        fixedT.keyPrefix = keyPrefix;
        return fixedT;
      }
    }, {
      key: "t",
      value: function t() {
        var _this$translator;
        return this.translator && (_this$translator = this.translator).translate.apply(_this$translator, arguments);
      }
    }, {
      key: "exists",
      value: function exists() {
        var _this$translator2;
        return this.translator && (_this$translator2 = this.translator).exists.apply(_this$translator2, arguments);
      }
    }, {
      key: "setDefaultNamespace",
      value: function setDefaultNamespace(ns) {
        this.options.defaultNS = ns;
      }
    }, {
      key: "hasLoadedNamespace",
      value: function hasLoadedNamespace(ns) {
        var _this6 = this;
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (!this.isInitialized) {
          this.logger.warn('hasLoadedNamespace: i18next was not initialized', this.languages);
          return false;
        }
        if (!this.languages || !this.languages.length) {
          this.logger.warn('hasLoadedNamespace: i18n.languages were undefined or empty', this.languages);
          return false;
        }
        var lng = this.resolvedLanguage || this.languages[0];
        var fallbackLng = this.options ? this.options.fallbackLng : false;
        var lastLng = this.languages[this.languages.length - 1];
        if (lng.toLowerCase() === 'cimode') return true;
        var loadNotPending = function loadNotPending(l, n) {
          var loadState = _this6.services.backendConnector.state["".concat(l, "|").concat(n)];
          return loadState === -1 || loadState === 2;
        };
        if (options.precheck) {
          var preResult = options.precheck(this, loadNotPending);
          if (preResult !== undefined) return preResult;
        }
        if (this.hasResourceBundle(lng, ns)) return true;
        if (!this.services.backendConnector.backend || this.options.resources && !this.options.partialBundledLanguages) return true;
        if (loadNotPending(lng, ns) && (!fallbackLng || loadNotPending(lastLng, ns))) return true;
        return false;
      }
    }, {
      key: "loadNamespaces",
      value: function loadNamespaces(ns, callback) {
        var _this7 = this;
        var deferred = defer$1();
        if (!this.options.ns) {
          callback && callback();
          return Promise.resolve();
        }
        if (typeof ns === 'string') ns = [ns];
        ns.forEach(function (n) {
          if (_this7.options.ns.indexOf(n) < 0) _this7.options.ns.push(n);
        });
        this.loadResources(function (err) {
          deferred.resolve();
          if (callback) callback(err);
        });
        return deferred;
      }
    }, {
      key: "loadLanguages",
      value: function loadLanguages(lngs, callback) {
        var deferred = defer$1();
        if (typeof lngs === 'string') lngs = [lngs];
        var preloaded = this.options.preload || [];
        var newLngs = lngs.filter(function (lng) {
          return preloaded.indexOf(lng) < 0;
        });
        if (!newLngs.length) {
          if (callback) callback();
          return Promise.resolve();
        }
        this.options.preload = preloaded.concat(newLngs);
        this.loadResources(function (err) {
          deferred.resolve();
          if (callback) callback(err);
        });
        return deferred;
      }
    }, {
      key: "dir",
      value: function dir(lng) {
        if (!lng) lng = this.resolvedLanguage || (this.languages && this.languages.length > 0 ? this.languages[0] : this.language);
        if (!lng) return 'rtl';
        var rtlLngs = ['ar', 'shu', 'sqr', 'ssh', 'xaa', 'yhd', 'yud', 'aao', 'abh', 'abv', 'acm', 'acq', 'acw', 'acx', 'acy', 'adf', 'ads', 'aeb', 'aec', 'afb', 'ajp', 'apc', 'apd', 'arb', 'arq', 'ars', 'ary', 'arz', 'auz', 'avl', 'ayh', 'ayl', 'ayn', 'ayp', 'bbz', 'pga', 'he', 'iw', 'ps', 'pbt', 'pbu', 'pst', 'prp', 'prd', 'ug', 'ur', 'ydd', 'yds', 'yih', 'ji', 'yi', 'hbo', 'men', 'xmn', 'fa', 'jpr', 'peo', 'pes', 'prs', 'dv', 'sam', 'ckb'];
        return rtlLngs.indexOf(this.services.languageUtils.getLanguagePartFromCode(lng)) > -1 || lng.toLowerCase().indexOf('-arab') > 1 ? 'rtl' : 'ltr';
      }
    }, {
      key: "cloneInstance",
      value: function cloneInstance() {
        var _this8 = this;
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop$2;
        var mergedOptions = _objectSpread$6(_objectSpread$6(_objectSpread$6({}, this.options), options), {
          isClone: true
        });
        var clone = new I18n(mergedOptions);
        if (options.debug !== undefined || options.prefix !== undefined) {
          clone.logger = clone.logger.clone(options);
        }
        var membersToCopy = ['store', 'services', 'language'];
        membersToCopy.forEach(function (m) {
          clone[m] = _this8[m];
        });
        clone.services = _objectSpread$6({}, this.services);
        clone.services.utils = {
          hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
        };
        clone.translator = new Translator(clone.services, clone.options);
        clone.translator.on('*', function (event) {
          for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
            args[_key4 - 1] = arguments[_key4];
          }
          clone.emit.apply(clone, [event].concat(args));
        });
        clone.init(mergedOptions, callback);
        clone.translator.options = clone.options;
        clone.translator.backendConnector.services.utils = {
          hasLoadedNamespace: clone.hasLoadedNamespace.bind(clone)
        };
        return clone;
      }
    }, {
      key: "toJSON",
      value: function toJSON() {
        return {
          options: this.options,
          store: this.store,
          language: this.language,
          languages: this.languages,
          resolvedLanguage: this.resolvedLanguage
        };
      }
    }]);
    return I18n;
  }(EventEmitter);
  _defineProperty$2(I18n, "createInstance", function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var callback = arguments.length > 1 ? arguments[1] : undefined;
    return new I18n(options, callback);
  });
  var instance = I18n.createInstance();
  instance.createInstance = I18n.createInstance;
  instance.createInstance;
  instance.init;
  instance.loadResources;
  instance.reloadResources;
  instance.use;
  instance.changeLanguage;
  instance.getFixedT;
  instance.t;
  instance.exists;
  instance.setDefaultNamespace;
  instance.hasLoadedNamespace;
  instance.loadNamespaces;
  instance.loadLanguages;

  function __variableDynamicImportRuntime0__(path) {
    switch (path) {
      case './locale/lang.af.js':
        return Promise.resolve().then(function () { return lang_af$1; });
      case './locale/lang.ar.js':
        return Promise.resolve().then(function () { return lang_ar$1; });
      case './locale/lang.az.js':
        return Promise.resolve().then(function () { return lang_az$1; });
      case './locale/lang.be.js':
        return Promise.resolve().then(function () { return lang_be$1; });
      case './locale/lang.bg.js':
        return Promise.resolve().then(function () { return lang_bg$1; });
      case './locale/lang.ca.js':
        return Promise.resolve().then(function () { return lang_ca$1; });
      case './locale/lang.cs.js':
        return Promise.resolve().then(function () { return lang_cs$1; });
      case './locale/lang.cy.js':
        return Promise.resolve().then(function () { return lang_cy$1; });
      case './locale/lang.da.js':
        return Promise.resolve().then(function () { return lang_da$1; });
      case './locale/lang.de.js':
        return Promise.resolve().then(function () { return lang_de$1; });
      case './locale/lang.el.js':
        return Promise.resolve().then(function () { return lang_el$1; });
      case './locale/lang.en.js':
        return Promise.resolve().then(function () { return lang_en$1; });
      case './locale/lang.es.js':
        return Promise.resolve().then(function () { return lang_es$1; });
      case './locale/lang.et.js':
        return Promise.resolve().then(function () { return lang_et$1; });
      case './locale/lang.fa.js':
        return Promise.resolve().then(function () { return lang_fa$1; });
      case './locale/lang.fi.js':
        return Promise.resolve().then(function () { return lang_fi$1; });
      case './locale/lang.fr.js':
        return Promise.resolve().then(function () { return lang_fr$1; });
      case './locale/lang.fy.js':
        return Promise.resolve().then(function () { return lang_fy$1; });
      case './locale/lang.ga.js':
        return Promise.resolve().then(function () { return lang_ga$1; });
      case './locale/lang.gl.js':
        return Promise.resolve().then(function () { return lang_gl$1; });
      case './locale/lang.he.js':
        return Promise.resolve().then(function () { return lang_he$1; });
      case './locale/lang.hi.js':
        return Promise.resolve().then(function () { return lang_hi$1; });
      case './locale/lang.hr.js':
        return Promise.resolve().then(function () { return lang_hr$1; });
      case './locale/lang.hu.js':
        return Promise.resolve().then(function () { return lang_hu$1; });
      case './locale/lang.hy.js':
        return Promise.resolve().then(function () { return lang_hy$1; });
      case './locale/lang.id.js':
        return Promise.resolve().then(function () { return lang_id$1; });
      case './locale/lang.is.js':
        return Promise.resolve().then(function () { return lang_is$1; });
      case './locale/lang.it.js':
        return Promise.resolve().then(function () { return lang_it$1; });
      case './locale/lang.ja.js':
        return Promise.resolve().then(function () { return lang_ja$1; });
      case './locale/lang.ko.js':
        return Promise.resolve().then(function () { return lang_ko$1; });
      case './locale/lang.lt.js':
        return Promise.resolve().then(function () { return lang_lt$1; });
      case './locale/lang.lv.js':
        return Promise.resolve().then(function () { return lang_lv$1; });
      case './locale/lang.mk.js':
        return Promise.resolve().then(function () { return lang_mk$1; });
      case './locale/lang.ms.js':
        return Promise.resolve().then(function () { return lang_ms$1; });
      case './locale/lang.mt.js':
        return Promise.resolve().then(function () { return lang_mt$1; });
      case './locale/lang.nl.js':
        return Promise.resolve().then(function () { return lang_nl$1; });
      case './locale/lang.no.js':
        return Promise.resolve().then(function () { return lang_no$1; });
      case './locale/lang.pl.js':
        return Promise.resolve().then(function () { return lang_pl$1; });
      case './locale/lang.pt-BR.js':
        return Promise.resolve().then(function () { return lang_ptBR$1; });
      case './locale/lang.pt-PT.js':
        return Promise.resolve().then(function () { return lang_ptPT$1; });
      case './locale/lang.ro.js':
        return Promise.resolve().then(function () { return lang_ro$1; });
      case './locale/lang.ru.js':
        return Promise.resolve().then(function () { return lang_ru$1; });
      case './locale/lang.sk.js':
        return Promise.resolve().then(function () { return lang_sk$1; });
      case './locale/lang.sl.js':
        return Promise.resolve().then(function () { return lang_sl$1; });
      case './locale/lang.sq.js':
        return Promise.resolve().then(function () { return lang_sq$1; });
      case './locale/lang.sr.js':
        return Promise.resolve().then(function () { return lang_sr$1; });
      case './locale/lang.sv.js':
        return Promise.resolve().then(function () { return lang_sv$1; });
      case './locale/lang.sw.js':
        return Promise.resolve().then(function () { return lang_sw$1; });
      case './locale/lang.test.js':
        return Promise.resolve().then(function () { return lang_test$1; });
      case './locale/lang.th.js':
        return Promise.resolve().then(function () { return lang_th$1; });
      case './locale/lang.tl.js':
        return Promise.resolve().then(function () { return lang_tl$1; });
      case './locale/lang.tr.js':
        return Promise.resolve().then(function () { return lang_tr$1; });
      case './locale/lang.uk.js':
        return Promise.resolve().then(function () { return lang_uk$1; });
      case './locale/lang.vi.js':
        return Promise.resolve().then(function () { return lang_vi$1; });
      case './locale/lang.yi.js':
        return Promise.resolve().then(function () { return lang_yi$1; });
      case './locale/lang.zh-CN.js':
        return Promise.resolve().then(function () { return lang_zhCN$1; });
      case './locale/lang.zh-HK.js':
        return Promise.resolve().then(function () { return lang_zhHK$1; });
      case './locale/lang.zh-TW.js':
        return Promise.resolve().then(function () { return lang_zhTW$1; });
      default:
        return new Promise(function (resolve, reject) {
          (typeof queueMicrotask === 'function' ? queueMicrotask : setTimeout)(reject.bind(null, new Error("Unknown variable dynamic import: " + path)));
        });
    }
  }

  /**
   * The string keys of the object are two-letter language codes.
   * @tutorial LocaleDocs
   * @typedef {PlainObject<string, string|module:locale.LocaleStrings|module:locale.LocaleArray>} module:locale.LocaleStrings
   */
  // keyed to an array of objects with "id" and "title" or "textContent" properties
  /**
   * @typedef {PlainObject<string, string>} module:locale.LocaleSelectorValue
   */

  let langParam;

  /**
  * The "data" property is generally set to an an array of objects with
  *   "id" and "title" or "textContent" properties.
  * @typedef {PlainObject} module:locale.AddLangExtensionLocaleData
  * @property {module:locale.LocaleStrings[]} data See {@tutorial LocaleDocs}
  */

  /**
  * @interface module:locale.LocaleEditorInit
  */
  /**
   * @function module:locale.LocaleEditorInit#addLangData
   * @param {string} langParam
   * @returns {module:locale.AddLangExtensionLocaleData}
  */
  /**
  * @typedef {PlainObject} module:locale.LangAndData
  * @property {string} langParam
  * @property {module:locale.LocaleStrings} langData
  */

  /**
   *
   * @function module:locale.putLocale
   * @param {string} givenParam
   * @param {string[]} goodLangs
   * @fires module:svgcanvas.SvgCanvas#event:ext_addLangData
   * @fires module:svgcanvas.SvgCanvas#event:ext_langReady
   * @fires module:svgcanvas.SvgCanvas#event:ext_langChanged
   * @returns {Promise<module:locale.LangAndData>} Resolves to result of {@link module:locale.readLang}
  */

  const putLocale = async function (givenParam, goodLangs) {
    if (givenParam) {
      langParam = givenParam;
    } else if (navigator.userLanguage) {
      // Explorer
      langParam = navigator.userLanguage;
    } else if (navigator.language) {
      // FF, Opera, ...
      langParam = navigator.language;
    }

    // Set to English if language is not in list of good langs
    if (!goodLangs.includes(langParam) && langParam !== 'test') {
      langParam = 'en';
    }
    const module = await __variableDynamicImportRuntime0__(`./locale/lang.${encodeURIComponent(langParam)}.js`);
    instance.init({
      lng: langParam,
      debug: false,
      resources: {
        [langParam]: {
          translation: module.default
        }
      }
    });
    return {
      langParam,
      i18next: instance
    };
  };
  const t$1 = function (key) {
    return instance.t(key);
  };

  /* globals svgEditor */
  const template$j = document.createElement('template');
  template$j.innerHTML = `
  <style>
  :host(:hover) :not(.disabled)
  {
    background-color: var(--icon-bg-color-hover);
  }
  div
  {
    height: 24px;
    width: 24px;
    margin: 4px 1px 4px;
    padding: 3px;
    background-color: var(--icon-bg-color);
    cursor: pointer;
    border-radius: 3px;
  }
  .small {
    width: 14px;
    height: 14px;
    padding: 1px;
    border-radius: 1px;
  }
  img {
    border: none;
    width: 100%;
    height: 100%;
  }
  .pressed {
    background-color: var(--icon-bg-color-hover);
  }
  .disabled {
    opacity: 0.3;
    cursor: default;
  }
  </style>
  <div title="title">
    <img alt="icon">
  </div>
`;
  /**
   * @class ToolButton
   */
  class ToolButton extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$j.content.cloneNode(true));
      // locate the component
      this.$div = this._shadowRoot.querySelector('div');
      this.$img = this._shadowRoot.querySelector('img');
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['title', 'src', 'pressed', 'disabled', 'size', 'style'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          {
            const shortcut = this.getAttribute('shortcut');
            this.$div.setAttribute('title', `${t$1(newValue)} ${shortcut ? `[${t$1(shortcut)}]` : ''}`);
          }
          break;
        case 'style':
          this.$div.style = newValue;
          break;
        case 'src':
          if (newValue.indexOf('data:') !== -1) {
            this.$img.setAttribute('src', newValue);
          } else {
            this.$img.setAttribute('src', this.imgPath + '/' + newValue);
          }
          break;
        case 'pressed':
          if (newValue === null) {
            this.$div.classList.remove('pressed');
          } else {
            this.$div.classList.add('pressed');
          }
          break;
        case 'size':
          if (newValue === 'small') {
            this.$div.classList.add('small');
          } else {
            this.$div.classList.remove('small');
          }
          break;
        case 'disabled':
          if (newValue) {
            this.$div.classList.add('disabled');
          } else {
            this.$div.classList.remove('disabled');
          }
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get pressed() {
      return this.hasAttribute('pressed');
    }

    /**
     * @function set
     * @returns {void}
     */
    set pressed(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('pressed', 'true');
      } else {
        this.removeAttribute('pressed');
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get disabled() {
      return this.hasAttribute('disabled');
    }

    /**
     * @function set
     * @returns {void}
     */
    set disabled(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('disabled', 'true');
      } else {
        this.removeAttribute('disabled');
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get size() {
      return this.getAttribute('size');
    }

    /**
     * @function set
     * @returns {void}
     */
    set size(value) {
      this.setAttribute('size', value);
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      // capture shortcuts
      const shortcut = this.getAttribute('shortcut');
      if (shortcut) {
        // register the keydown event
        document.addEventListener('keydown', e => {
          // only track keyboard shortcuts for the body containing the SVG-Editor
          if (e.target.nodeName !== 'BODY') return;
          // normalize key
          const key = `${e.metaKey ? 'meta+' : ''}${e.ctrlKey ? 'ctrl+' : ''}${e.key.toUpperCase()}`;
          if (shortcut !== key) return;
          // launch the click event
          this.click();
          e.preventDefault();
        });
      }
    }
  }

  // Register
  customElements.define('se-button', ToolButton);

  /* globals svgEditor */

  /**
   * @class FlyingButton
   */
  class FlyingButton extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
      this.template = this.createTemplate(this.imgPath);
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(this.template.content.cloneNode(true));
      // locate the component
      this.$button = this._shadowRoot.querySelector('.menu-button');
      this.$handle = this._shadowRoot.querySelector('.handle');
      this.$overall = this._shadowRoot.querySelector('.overall');
      this.$img = this._shadowRoot.querySelector('img');
      this.$menu = this._shadowRoot.querySelector('.menu');
      // the last element of the div is the slot
      // we retrieve all elements added in the slot (i.e. se-buttons)
      this.$elements = this.$menu.lastElementChild.assignedElements();
    }

    /**
     * @function createTemplate
     * @param {string} imgPath
     * @returns {any} template
     */

    createTemplate(imgPath) {
      const template = document.createElement('template');
      template.innerHTML = `
      <style>
        :host {
          position:relative;
        }
        .overall:hover *
        {
          background-color: var(--icon-bg-color-hover);
        }
        img {
          border: none;
          width: 24px;
          height: 24px;
        }
        .overall.pressed .button-icon,
        .overall.pressed .handle {
          background-color: var(--icon-bg-color-hover) !important;
        }
        .overall.pressed .menu-button {
          background-color: var(--icon-bg-color-hover) !important;
        }
        .disabled {
          opacity: 0.3;
          cursor: default;
        }
        .menu-button {
          height: 24px;
          width: 24px;
          margin: 2px 1px 4px;
          padding: 3px;
          background-color: var(--icon-bg-color);
          cursor: pointer;
          position: relative;
          border-radius: 3px;
          overflow: hidden;
        }
        .handle {
          height: 8px;
          width: 8px;
          background-image: url(${imgPath}/handle.svg);
          position:absolute;
          bottom: 0px;
          right: 0px;
        }
        .button-icon {
        }
        .menu {
          position: fixed;
          background: none !important;
          display:none;
          margin-left: 34px;
        }
        .open {
          display: flex;
        }
        .menu-item {
          align-content: flex-start;
          height: 24px;
          width: 24px;
          top:0px;
          left:0px;
        }
        .overall {
          background: none !important;
        }
      </style>

      <div class="overall">
        <div class="menu">
          <slot></slot>
        </div>
        <div class="menu-button">
          <img class="button-icon" src="logo.svg" alt="icon">
          <div class="handle"></div>
        </div>
      </div>`;
      return template;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['title', 'pressed', 'disabled', 'opened'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          {
            const shortcut = this.getAttribute('shortcut');
            this.$button.setAttribute('title', `${t$1(newValue)} ${shortcut ? `[${t$1(shortcut)}]` : ''}`);
          }
          break;
        case 'pressed':
          if (newValue) {
            this.$overall.classList.add('pressed');
          } else {
            this.$overall.classList.remove('pressed');
          }
          break;
        case 'opened':
          if (newValue) {
            this.$menu.classList.add('open');
          } else {
            this.$menu.classList.remove('open');
          }
          break;
        case 'disabled':
          if (newValue) {
            this.$overall.classList.add('disabled');
          } else {
            this.$overall.classList.remove('disabled');
          }
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get pressed() {
      return this.hasAttribute('pressed');
    }

    /**
     * @function set
     * @returns {void}
     */
    set pressed(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('pressed', 'true');
      } else {
        this.removeAttribute('pressed', '');
        // close also the menu if open
        this.removeAttribute('opened');
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get opened() {
      return this.hasAttribute('opened');
    }

    /**
     * @function set
     * @returns {void}
     */
    set opened(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('opened', 'opened');
      } else {
        this.removeAttribute('opened');
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get disabled() {
      return this.hasAttribute('disabled');
    }

    /**
     * @function set
     * @returns {void}
     */
    set disabled(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('disabled', 'true');
      } else {
        this.removeAttribute('disabled', '');
      }
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      this.activeSlot = this.shadowRoot.querySelector('slot').assignedElements()[0];
      this.$img.setAttribute('src', this.imgPath + '/' + this.activeSlot.getAttribute('src'));
      // capture click event on the button to manage the logic
      const onClickHandler = ev => {
        ev.stopPropagation();
        switch (ev.target.nodeName) {
          case 'SE-FLYINGBUTTON':
            if (this.pressed) {
              this.setAttribute('opened', 'opened');
            } else {
              // launch current action
              this.activeSlot.click();
              this.setAttribute('pressed', 'pressed');
            }
            break;
          case 'SE-BUTTON':
            // change to the current action
            this.$img.setAttribute('src', this.imgPath + '/' + ev.target.getAttribute('src'));
            this.activeSlot = ev.target;
            this.setAttribute('pressed', 'pressed');
            // and close the menu
            this.$menu.classList.remove('open');
            break;
          case 'DIV':
            // this is a click on the handle so let's open/close the menu.
            if (this.opened) {
              this.removeAttribute('opened');
            } else {
              this.setAttribute('opened', 'opened');
              // In case menu scroll on top or bottom position based popup position set
              const rect = this.getBoundingClientRect();
              this.$menu.style.top = rect.top + 'px';
            }
            break;
          default:
            console.error('unkonw nodeName for:', ev.target, ev.target.className);
        }
      };
      // capture event from slots
      svgEditor.$click(this, onClickHandler);
      svgEditor.$click(this.$handle, onClickHandler);
    }
  }

  // Register
  customElements.define('se-flyingbutton', FlyingButton);

  /* globals svgEditor */

  /**
   * @class ExplorerButton
   */
  class ExplorerButton extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      // create the shadowDom and insert the template
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
      this.template = this.createTemplate(this.imgPath);
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(this.template.content.cloneNode(true));
      // locate the component
      this.$button = this._shadowRoot.querySelector('.menu-button');
      this.$overall = this._shadowRoot.querySelector('.overall');
      this.$img = this._shadowRoot.querySelector('.menu-button img');
      this.$menu = this._shadowRoot.querySelector('.menu');
      this.$handle = this._shadowRoot.querySelector('.handle');
      this.$lib = this._shadowRoot.querySelector('.image-lib');
      this.files = [];
      this.request = new XMLHttpRequest();
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
    }

    /**
     * @function createTemplate
     * @param {string} imgPath
     * @returns {any} template
     */

    createTemplate(imgPath) {
      const template = document.createElement('template');
      template.innerHTML = `
    <style>
    :host {
      position:relative;
    }
    .menu-button:hover, se-button:hover, .menu-item:hover
    {
      background-color: var(--icon-bg-color-hover);
    }
    img {
      border: none;
      width: 24px;
      height: 24px;
    }
    .overall.pressed .button-icon,
    .overall.pressed,
    .menu-item.pressed {
      background-color: var(--icon-bg-color-hover) !important;
    }
    .overall.pressed .menu-button {
      background-color: var(--icon-bg-color-hover) !important;
    }
    .disabled {
      opacity: 0.3;
      cursor: default;
    }
    .menu-button {
      height: 24px;
      width: 24px;
      margin: 2px 1px 4px;
      padding: 3px;
      background-color: var(--icon-bg-color);
      cursor: pointer;
      position: relative;
      border-radius: 3px;
      overflow: hidden;
    }
    .handle {
      height: 8px;
      width: 8px;
      background-image: url(${imgPath}/handle.svg);
      position:absolute;
      bottom: 0px;
      right: 0px;
    }
    .button-icon {
    }
    .menu {
      position: fixed;
      margin-left: 34px;
      background: none !important;
      display:none;
      top: 30%;
      left: 171px;
    }
    .image-lib {
      position: fixed;
      left: 34px;
      top: 30%;
      background: #E8E8E8;
      display: none;
      flex-wrap: wrap;
      flex-direction: row;
      width: 170px;
    }
    .menu-item {
      line-height: 1em;
      padding: 0.5em;
      border: 1px solid #5a6162;
      background: #E8E8E8;
      margin-bottom: -1px;
      white-space: nowrap;
    }
    .open-lib {
      display: inline-flex;
    }
    .open {
      display: block;
    }
    .overall {
      background: none !important;
    }
    </style>
  
    <div class="overall">
      <div class="menu-button">
        <img class="button-icon" src="explorer.svg" alt="icon">
        <div class="handle"></div>
      </div>
      <div class="image-lib"">
        <se-button></se-button>
     </div>
      <div class="menu">
        <div class="menu-item">menu</div>
     </div>
    </div>`;
      return template;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['title', 'pressed', 'disabled', 'lib', 'src'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    async attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          {
            const shortcut = this.getAttribute('shortcut');
            this.$button.setAttribute('title', `${newValue} [${shortcut}]`);
          }
          break;
        case 'pressed':
          if (newValue) {
            this.$overall.classList.add('pressed');
          } else {
            this.$overall.classList.remove('pressed');
          }
          break;
        case 'disabled':
          if (newValue) {
            this.$overall.classList.add('disabled');
          } else {
            this.$overall.classList.remove('disabled');
          }
          break;
        case 'lib':
          try {
            const response = await fetch(`${newValue}index.json`);
            const json = await response.json();
            const {
              lib
            } = json;
            this.$menu.innerHTML = lib.map((menu, i) => `<div data-menu="${menu}" class="menu-item ${i === 0 ? 'pressed' : ''} ">${menu}</div>`).join('');
            await this.updateLib(lib[0]);
          } catch (error) {
            console.error(error);
          }
          break;
        case 'src':
          this.$img.setAttribute('src', this.imgPath + '/' + newValue);
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get pressed() {
      return this.hasAttribute('pressed');
    }

    /**
     * @function set
     * @returns {void}
     */
    set pressed(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('pressed', 'true');
      } else {
        this.removeAttribute('pressed', '');
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get disabled() {
      return this.hasAttribute('disabled');
    }

    /**
     * @function set
     * @returns {void}
     */
    set disabled(value) {
      // boolean value => existence = true
      if (value) {
        this.setAttribute('disabled', 'true');
      } else {
        this.removeAttribute('disabled', '');
      }
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      // capture click event on the button to manage the logic
      const onClickHandler = ev => {
        ev.stopPropagation();
        switch (ev.target.nodeName) {
          case 'SE-EXPLORERBUTTON':
            this.$menu.classList.add('open');
            this.$lib.classList.add('open-lib');
            break;
          case 'SE-BUTTON':
            // change to the current action
            this.currentAction = ev.target;
            this.$img.setAttribute('src', this.currentAction.getAttribute('src'));
            this.dataset.draw = this.data[this.currentAction.dataset.shape];
            this._shadowRoot.querySelectorAll('.image-lib [pressed]').forEach(b => {
              b.pressed = false;
            });
            this.currentAction.setAttribute('pressed', 'pressed');
            // and close the menu
            this.$menu.classList.remove('open');
            this.$lib.classList.remove('open-lib');
            break;
          case 'DIV':
            if (ev.target.classList[0] === 'handle') {
              // this is a click on the handle so let's open/close the menu.
              this.$menu.classList.toggle('open');
              this.$lib.classList.toggle('open-lib');
            } else {
              this._shadowRoot.querySelectorAll('.menu > .pressed').forEach(b => {
                b.classList.remove('pressed');
              });
              ev.target.classList.add('pressed');
              this.updateLib(ev.target.dataset.menu);
            }
            break;
          default:
            console.error('unknown nodeName for:', ev.target, ev.target.className);
        }
      };
      // capture event from slots
      svgEditor.$click(this, onClickHandler);
      svgEditor.$click(this.$menu, onClickHandler);
      svgEditor.$click(this.$lib, onClickHandler);
      svgEditor.$click(this.$handle, onClickHandler);
    }

    /**
     * @function updateLib
     * @param {string} lib
     * @returns {void}
     */
    async updateLib(lib) {
      const libDir = this.getAttribute('lib');
      try {
        // initialize buttons for all shapes defined for this library
        const response = await fetch(`${libDir}${lib}.json`);
        const json = await response.json();
        this.data = json.data;
        const size = json.size ?? 300;
        const fill = json.fill ? '#333' : 'none';
        const off = size * 0.05;
        const vb = [-off, -off, size + off * 2, size + off * 2].join(' ');
        const stroke = json.fill ? 0 : size / 30;
        this.$lib.innerHTML = Object.entries(this.data).map(_ref => {
          let [key, path] = _ref;
          const encoded = btoa(`
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24">
          <svg viewBox="${vb}"><path fill="${fill}" stroke="#f8bb00" stroke-width="${stroke}" d="${path}"></path></svg>
        </svg>`);
          return `<se-button data-shape="${key}"src="data:image/svg+xml;base64,${encoded}"></se-button>`;
        }).join('');
      } catch (error) {
        console.error(`could not read file:${libDir}${lib}.json`, error);
      }
    }
  }

  // Register
  customElements.define('se-explorerbutton', ExplorerButton);

  /* globals svgEditor */
  const template$i = document.createElement('template');
  template$i.innerHTML = `
  <style>
  input{
    border:unset;
    background-color:var(--input-color);
    min-width:unset;
    width:40px;
    height:23px;
    padding:1px 2px;
    border:2px;
    font: inherit;
    margin: 2px 1px 0px 2px;
    box-sizing:border-box;
    text-align: center;
    border-radius: 3px 0px 0px 3px;
  }
  #tool-wrapper{
    height:20px;
    display:flex;
    align-items:center;
  }
  #icon{
    margin-bottom:1px
  }
  #spinner{
    display:flex;
    flex-direction:column;
  }
  #spinner > div {
    height: 11px;
    width: 7px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 7px;
    border-left:solid 1px transparent;
    border-right:solid 1px transparent;
    background-color:var(--input-color);
  }
  #arrow-up{
    height:9px;
    margin-top: 2px;
    margin-bottom: 1px;
  }
  #down{
    width:18px;
    height:23px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color:var(--input-color);
    border-radius: 0px 3px 3px 0px;
    margin: 2px 5px 0px 1px;
  }
  #down > img {
    margin-top: 2px;
  }
  #options-container {
    position:fixed
    display:flex;
    flex-direction:column;
    background-color:var(--icon-bg-color);
    border:solid 1px white;
    box-shadow:0 0px 10px rgb(0 0 0 / 50%);
  }
  ::slotted(*) {
    margin:2px;
    padding:3px;
    color:white;
  }
  ::slotted(*:hover) {
    background-color: rgb(43, 60, 69);
  }
  </style>
  <div id="tool-wrapper">
    <img id="icon" alt="icon" width="18" height="18"/>
    <input/>
    <div id="spinner">
      <div id="arrow-up">▲</div>
      <div id="arrow-down">▼</div>
    </div>
    <div id="down">
      <img width="16" height="8" src="${entryData.mainUrl}/images/arrow_down.svg"/>
    </div>
  </div>
  <div id="options-container" style="display:none">
    <slot></slot>
  </div>
`;
  class SeZoom extends HTMLElement {
    constructor() {
      super();
      this.handleMouseDown = this.handleMouseDown.bind(this);
      this.handleMouseUp = this.handleMouseUp.bind(this);
      this.handleKeyDown = this.handleKeyDown.bind(this);
      this.initPopup = this.initPopup.bind(this);
      this.handleInput = this.handleInput.bind(this);

      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      // locate the component
      this._shadowRoot.append(template$i.content.cloneNode(true));

      // prepare the slot element
      this.slotElement = this._shadowRoot.querySelector('slot');
      this.slotElement.addEventListener('slotchange', this.handleOptionsChange.bind(this));

      // hookup events for the input box
      this.inputElement = this._shadowRoot.querySelector('input');
      this.inputElement.addEventListener('click', this.handleClick.bind(this));
      this.inputElement.addEventListener('change', this.handleInput);
      this.inputElement.addEventListener('keydown', this.handleKeyDown);
      this.clickArea = this._shadowRoot.querySelector('#down');
      this.clickArea.addEventListener('click', this.handleClick.bind(this));

      // set src for imageElement
      this.imageElement = this._shadowRoot.querySelector('img');
      this.imageElement.setAttribute('src', this.imgPath = svgEditor.configObj.curConfig.imgPath + '/' + this.getAttribute('src'));

      // hookup events for arrow buttons
      this.arrowUp = this._shadowRoot.querySelector('#arrow-up');
      this.arrowUp.addEventListener('click', this.increment.bind(this));
      this.arrowUp.addEventListener('mousedown', e => this.handleMouseDown('up', true));
      this.arrowUp.addEventListener('mouseleave', e => this.handleMouseUp('up'));
      this.arrowUp.addEventListener('mouseup', e => this.handleMouseUp('up'));
      this.arrowDown = this._shadowRoot.querySelector('#arrow-down');
      this.arrowDown.addEventListener('click', this.decrement.bind(this));
      this.arrowDown.addEventListener('mousedown', e => this.handleMouseDown('down', true));
      this.arrowDown.addEventListener('mouseleave', e => this.handleMouseUp('down'));
      this.arrowDown.addEventListener('mouseup', e => this.handleMouseUp('down'));
      this.optionsContainer = this._shadowRoot.querySelector('#options-container');

      // add an event listener to close the popup
      document.addEventListener('click', e => this.handleClose(e));
      this.changedTimeout = null;
    }
    static get observedAttributes() {
      return ['value'];
    }

    /**
     * @function get
     * @returns {any}
     */
    get value() {
      return this.getAttribute('value');
    }

    /**
     * @function set
     * @returns {void}
     */
    set value(value) {
      this.setAttribute('value', value);
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) {
        switch (name) {
          case 'value':
            if (parseInt(this.inputElement.value) !== newValue) {
              this.inputElement.value = newValue;
            }
            break;
        }
        return;
      }
      switch (name) {
        case 'value':
          this.inputElement.value = newValue;
          this.dispatchEvent(new CustomEvent('change', {
            detail: {
              value: newValue
            }
          }));
          break;
      }
    }

    /**
     * @function handleOptionsChange
     * @returns {void}
     */
    handleOptionsChange() {
      if (this.slotElement.assignedElements().length > 0) {
        this.options = this.slotElement.assignedElements();
        this.selectedValue = this.options[0].textContent;
        this.initPopup();
        this.options.forEach(option => {
          option.addEventListener('click', e => this.handleSelect(e));
        });
      }
    }

    /**
     * @function handleClick
     * @returns {void}
     */
    handleClick() {
      this.optionsContainer.style.display = 'flex';
      this.inputElement.select();
      this.initPopup();
    }

    /**
     * @function handleSelect
     * @param {Event} e
     * @returns {void}
     */
    handleSelect(e) {
      this.value = e.target.getAttribute('value');
      this.title = e.target.getAttribute('text');
    }

    /**
     * @function handleShow
     * @returns {void}
     * initialises the popup menu position
     */
    initPopup() {
      const zoomPos = this.getBoundingClientRect();
      const popupPos = this.optionsContainer.getBoundingClientRect();
      const top = zoomPos.top - popupPos.height;
      const left = zoomPos.left;
      this.optionsContainer.style.position = 'fixed';
      this.optionsContainer.style.top = `${top}px`;
      this.optionsContainer.style.left = `${left}px`;
    }

    /**
     * @function handleClose
     * @param {Event} e
     * @returns {void}
     * Close the popup menu
     */
    handleClose(e) {
      if (e.target !== this) {
        this.optionsContainer.style.display = 'none';
        this.inputElement.blur();
      }
    }

    /**
     * @function handleInput
     * @returns {void}
     */
    handleInput() {
      if (this.changedTimeout) {
        clearTimeout(this.changedTimeout);
      }
      this.changedTimeout = setTimeout(this.triggerInputChanged.bind(this), 500);
    }

    /**
     * @function triggerInputChanged
     * @returns {void}
     */
    triggerInputChanged() {
      const newValue = this.inputElement.value;
      this.value = newValue;
    }

    /**
     * @function increment
     * @returns {void}
     */
    increment() {
      this.value = parseInt(this.value) + 10;
    }

    /**
     * @function decrement
     * @returns {void}
     */
    decrement() {
      if (this.value - 10 <= 0) {
        this.value = 10;
      } else {
        this.value = parseInt(this.value) - 10;
      }
    }

    /**
     * @function handleMouseDown
     * @param {string} dir
     * @param {boolean} isFirst
     * @returns {void}
     * Increment/Decrement on mouse held down, if its the first call add a delay before starting
     */
    handleMouseDown(dir, isFirst) {
      if (dir === 'up') {
        this.incrementHold = true;
        !isFirst && this.increment();
        setTimeout(() => {
          if (this.incrementHold) {
            this.handleMouseDown(dir, false);
          }
        }, isFirst ? 500 : 50);
      } else if (dir === 'down') {
        this.decrementHold = true;
        !isFirst && this.decrement();
        setTimeout(() => {
          if (this.decrementHold) {
            this.handleMouseDown(dir, false);
          }
        }, isFirst ? 500 : 50);
      }
    }

    /**
     * @function handleMouseUp
     * @param {string} dir
     * @returns {void}
     */
    handleMouseUp(dir) {
      if (dir === 'up') {
        this.incrementHold = false;
      } else {
        this.decrementHold = false;
      }
    }

    /**
     * @function handleKeyDown
     * @param {Event} e
     * @returns {void}
     */
    handleKeyDown(e) {
      if (e.key === 'ArrowUp') {
        this.increment();
      } else if (e.key === 'ArrowDown') {
        this.decrement();
      }
    }
  }

  // Register
  customElements.define('se-zoom', SeZoom);

  /**
   * JavaScript template literals for constructing DOM nodes from HTML
   *
   * @module html
   */

  /**
   * A JavaScript template string literal that returns an HTML document fragment.
   *
   * Example:
   *
   *     const fragment = fragmentFrom.html`Hello, <em>world</em>.`
   *
   * returns a `DocumentFragment` whose `innerHTML` is `Hello, <em>world</em>.`
   *
   * This function is called `html` so that it can be easily used with HTML
   * syntax-highlighting extensions for various popular code editors.
   *
   * See also [templateFrom.html](template#html), which returns a similar result but
   * as an HTMLTemplateElement.
   *
   * @param {TemplateStringsArray} strings - the strings passed to the JavaScript template
   * literal
   * @param {string[]} substitutions - the variable values passed to the
   * JavaScript template literal
   * @returns {DocumentFragment}
   */
  const fragmentFrom = {
    html(strings) {
      for (var _len = arguments.length, substitutions = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        substitutions[_key - 1] = arguments[_key];
      }
      return templateFrom.html(strings, ...substitutions).content;
    }
  };

  /**
   * A JavaScript template string literal that returns an HTML template.
   *
   * Example:
   *
   *     const myTemplate = templateFrom.html`Hello, <em>world</em>.`
   *
   * returns an `HTMLTemplateElement` whose `innerHTML` is `Hello, <em>world</em>.`
   *
   * This function is called `html` so that it can be easily used with HTML
   * syntax-highlighting extensions for various popular code editors.
   *
   * See also [html](html), a helper which returns a similar result but as an
   * DocumentFragment.
   *
   * @param {TemplateStringsArray} strings - the strings passed to the JavaScript template
   * literal
   * @param {string[]} substitutions - the variable values passed to the
   * JavaScript template literal
   * @returns {HTMLTemplateElement}
   */
  const templateFrom = {
    html(strings) {
      const template = document.createElement("template");
      for (var _len2 = arguments.length, substitutions = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        substitutions[_key2 - 1] = arguments[_key2];
      }
      template.innerHTML = String.raw(strings, ...substitutions);
      return template;
    }
  };

  /**
   * Collection of shared Symbol objects for internal component communication.
   *
   * The shared `Symbol` objects in this module let mixins and a component
   * internally communicate without exposing these internal properties and methods
   * in the component's public API. They also help avoid unintentional name
   * collisions, as a component developer must specifically import the `internal`
   * module and reference one of its symbols.
   *
   * To use these `Symbol` objects in your own component, include this module and
   * then create a property or method whose key is the desired Symbol. E.g.,
   * [ShadowTemplateMixin](ShadowTemplateMixin) expects a component to define
   * a property called [template](#template):
   *
   *     import { template } from 'elix/src/core/internal.js';
   *     import { templateFrom } from 'elix/src/core/htmlLiterals.js'
   *     import ShadowTemplateMixin from 'elix/src/core/ShadowTemplateMixin.js';
   *
   *     class MyElement extends ShadowTemplateMixin(HTMLElement) {
   *       [template]() {
   *         return templateFrom.html`Hello, <em>world</em>.`;
   *       }
   *     }
   *
   * The above use of the internal `template` member lets the mixin find the
   * component's template in a way that will not pollute the component's public
   * API or interfere with other component logic. For example, if for some reason
   * the component wants to define a separate property with the plain string name,
   * "template", it can do so without affecting the above property setter.
   *
   * @module internal
   */

  /**
   * Symbol for the default state for this element.
   */
  const defaultState$1 = Symbol("defaultState");

  /**
   * Symbol for the `delegatesFocus` property.
   *
   * [DelegatesFocusMixin](DelegatesFocusMixin) defines this property, returning
   * true to indicate that the focus is being delegated, even in browsers that
   * don't support that natively. Mixins like [KeyboardMixin](KeyboardMixin) use
   * this to accommodate focus delegation.
   */
  const delegatesFocus$1 = Symbol("delegatesFocus");

  /**
   * Symbol for the `firstRender` property.
   *
   * [ReactiveMixin](ReactiveMixin) sets the property to `true` during the
   * element's first `render` and `rendered` callback, then `false` in subsequent
   * callbacks.
   *
   * You can inspect this property in your own `rendered` callback handler to do
   * work like wiring up events that should only happen once.
   */
  const firstRender$1 = Symbol("firstRender");

  /**
   * Symbol for the `focusTarget` property.
   *
   * [DelegatesFocusMixin](DelegatesFocusMixin) defines this property as either:
   * 1) the element itself, in browsers that support native focus delegation or,
   * 2) the shadow root's first focusable element.
   */
  const focusTarget$1 = Symbol("focusTarget");

  /**
   * Symbol for the `hasDynamicTemplate` property.
   *
   * If your component class does not always use the same template, define a
   * static class property getter with this symbol and have it return `true`.
   * This will disable template caching for your component.
   */
  const hasDynamicTemplate$1 = Symbol("hasDynamicTemplate");

  /**
   * Symbol for the `ids` property.
   *
   * [ShadowTemplateMixin](ShadowTemplateMixin) defines a shorthand function
   * `internal.ids` that can be used to obtain a reference to a shadow element with
   * a given ID.
   *
   * Example: if component's template contains a shadow element
   * `<button id="foo">`, you can use the reference `this[ids].foo` to obtain
   * the corresponding button in the component instance's shadow tree.
   * The `ids` function is simply a shorthand for `getElementById`, so
   * `this[ids].foo` is the same as `this.shadowRoot.getElementById('foo')`.
   */
  const ids$1 = Symbol("ids");

  /**
   * Symbol for access to native HTML element internals.
   */
  const nativeInternals$1 = Symbol("nativeInternals");

  /**
   * Symbol for the `raiseChangeEvents` property.
   *
   * This property is used by mixins to determine whether they should raise
   * property change events. The standard HTML pattern is to only raise such
   * events in response to direct user interactions. For a detailed discussion
   * of this point, see the Gold Standard checklist item for
   * [Propery Change Events](https://github.com/webcomponents/gold-standard/wiki/Property%20Change%20Events).
   *
   * The above article describes a pattern for using a flag to track whether
   * work is being performed in response to internal component activity, and
   * whether the component should therefore raise property change events.
   * This `raiseChangeEvents` symbol is a shared flag used for that purpose by
   * all Elix mixins and components. Sharing this flag ensures that internal
   * activity (e.g., a UI event listener) in one mixin can signal other mixins
   * handling affected properties to raise change events.
   *
   * All UI event listeners (and other forms of internal handlers, such as
   * timeouts and async network handlers) should set `raiseChangeEvents` to
   * `true` at the start of the event handler, then `false` at the end:
   *
   *     this.addEventListener('click', event => {
   *       this[raiseChangeEvents] = true;
   *       // Do work here, possibly setting properties, like:
   *       this.foo = 'Hello';
   *       this[raiseChangeEvents] = false;
   *     });
   *
   * Elsewhere, property setters that raise change events should only do so it
   * this property is `true`:
   *
   *     set foo(value) {
   *       // Save foo value here, do any other work.
   *       if (this[raiseChangeEvents]) {
   *         export const event = new CustomEvent('foochange');
   *         this.dispatchEvent(event);
   *       }
   *     }
   *
   * In this way, programmatic attempts to set the `foo` property will not trigger
   * the `foochange` event, but UI interactions that update that property will
   * cause those events to be raised.
   */
  const raiseChangeEvents$1 = Symbol("raiseChangeEvents");

  /**
   * Symbol for the `render` method.
   *
   * [ReactiveMixin](ReactiveMixin) invokes this `internal.render` method to give
   * the component a chance to render recent changes in component state.
   */
  const render$1 = Symbol("render");

  /**
   * Symbol for the `renderChanges` method.
   *
   * [ReactiveMixin](ReactiveMixin) invokes this method in response to a
   * `setState` call; you should generally not invoke this method yourself.
   */
  const renderChanges$1 = Symbol("renderChanges");

  /**
   * Symbol for the `rendered` method.
   *
   * [ReactiveMixin](ReactiveMixin) will invoke this method after your
   * element has completely finished rendering.
   *
   * If you only want to do work the first time rendering happens (for example, if
   * you want to wire up event handlers), your `internal.rendered` implementation
   * can inspect the `internal.firstRender` flag.
   */
  const rendered$1 = Symbol("rendered");

  /**
   * Symbol for the `rendering` property.
   *
   * [ReactiveMixin](ReactiveMixin) sets this property to true during rendering,
   * at other times it will be false.
   */
  const rendering$1 = Symbol("rendering");

  /**
   * Symbol for the `setState` method.
   *
   * A component using [ReactiveMixin](ReactiveMixin) can invoke this method to
   * apply changes to the element's current state.
   */
  const setState$1 = Symbol("setState");

  /**
   * Symbol for the `shadowRoot` property.
   *
   * This property holds a reference to an element's shadow root, like
   * `this.shadowRoot`. This propery exists because `this.shadowRoot` is not
   * available for components with closed shadow roots.
   * [ShadowTemplateMixin](ShadowTemplateMixin) creates open shadow roots by
   * default, but you can opt into creating closed shadow roots; see
   * [shadowRootMode](internal#internal.shadowRootMode).
   */
  const shadowRoot$1 = Symbol("shadowRoot");

  /**
   * Symbol for the `shadowRootMode` property.
   *
   * If true (the default), then [ShadowTemplateMixin](ShadowTemplateMixin) will
   * create an open shadow root when the component is instantiated. Set this to
   * false if you want to programmatically hide component internals in a closed
   * shadow root.
   */
  const shadowRootMode$1 = Symbol("shadowRootMode");

  /**
   * Symbol for the element's current state.
   *
   * This is managed by [ReactiveMixin](ReactiveMixin).
   */
  const state$1 = Symbol("state");

  /**
   * Symbol for the `stateEffects` method.
   *
   * See [stateEffects](ReactiveMixin#stateEffects).
   */
  const stateEffects$1 = Symbol("stateEffects");

  /**
   * Symbol for the `template` method.
   *
   * [ShadowTemplateMixin](ShadowTemplateMixin) uses this property to obtain a
   * component's template, which it will clone into a component's shadow root.
   */
  const template$h = Symbol("template");

  // Memoized maps of attribute to property names and vice versa.
  // We initialize this with the special case of the tabindex (lowercase "i")
  // attribute, which is mapped to the tabIndex (capital "I") property.
  /** @type {IndexedObject<string>} */
  const attributeToPropertyNames = {
    tabindex: "tabIndex"
  };
  /** @type {IndexedObject<string>} */
  const propertyNamesToAttributes = {
    tabIndex: "tabindex"
  };

  /**
   * Sets properties when the corresponding attributes change
   *
   * If your component exposes a setter for a property, it's generally a good
   * idea to let devs using your component be able to set that property in HTML
   * via an element attribute. You can code that yourself by writing an
   * `attributeChangedCallback`, or you can use this mixin to get a degree of
   * automatic support.
   *
   * This mixin implements an `attributeChangedCallback` that will attempt to
   * convert a change in an element attribute into a call to the corresponding
   * property setter. Attributes typically follow hyphenated names ("foo-bar"),
   * whereas properties typically use camelCase names ("fooBar"). This mixin
   * respects that convention, automatically mapping the hyphenated attribute
   * name to the corresponding camelCase property name.
   *
   * Example: You define a component using this mixin:
   *
   *     class MyElement extends AttributeMarshallingMixin(HTMLElement) {
   *       get fooBar() { return this._fooBar; }
   *       set fooBar(value) { this._fooBar = value; }
   *     }
   *
   * If someone then instantiates your component in HTML:
   *
   *     <my-element foo-bar="Hello"></my-element>
   *
   * Then, after the element has been upgraded, the `fooBar` setter will
   * automatically be invoked with the initial value "Hello".
   *
   * Attributes can only have string values. If you'd like to convert string
   * attributes to other types (numbers, booleans), you must implement parsing
   * yourself.
   *
   * @module AttributeMarshallingMixin
   * @param {Constructor<CustomElement>} Base
   */
  function AttributeMarshallingMixin(Base) {
    // The class prototype added by the mixin.
    class AttributeMarshalling extends Base {
      /**
       * Handle a change to the attribute with the given name.
       *
       * @ignore
       * @param {string} attributeName
       * @param {string} oldValue
       * @param {string} newValue
       */
      attributeChangedCallback(attributeName, oldValue, newValue) {
        if (super.attributeChangedCallback) {
          super.attributeChangedCallback(attributeName, oldValue, newValue);
        }

        // Sometimes this callback is invoked when there's not actually any
        // change, in which we skip invoking the property setter.
        //
        // We also skip setting properties if we're rendering. A component may
        // want to reflect property values to attributes during rendering, but
        // such attribute changes shouldn't trigger property updates.
        if (newValue !== oldValue && !this[rendering$1]) {
          const propertyName = attributeToPropertyName(attributeName);
          // If the attribute name corresponds to a property name, set the property.
          if (propertyName in this) {
            // Parse standard boolean attributes.
            const parsed = standardBooleanAttributes[attributeName] ? booleanAttributeValue(attributeName, newValue) : newValue;
            this[propertyName] = parsed;
          }
        }
      }

      // Because maintaining the mapping of attributes to properties is tedious,
      // this provides a default implementation for `observedAttributes` that
      // assumes that your component will want to expose all public properties in
      // your component's API as properties.
      //
      // You can override this default implementation of `observedAttributes`. For
      // example, if you have a system that can statically analyze which
      // properties are available to your component, you could hand-author or
      // programmatically generate a definition for `observedAttributes` that
      // avoids the minor run-time performance cost of inspecting the component
      // prototype to determine your component's public properties.
      static get observedAttributes() {
        return attributesForClass(this);
      }
    }
    return AttributeMarshalling;
  }

  /**
   * Return the custom attributes for the given class.
   *
   * E.g., if the supplied class defines a `fooBar` property, then the resulting
   * array of attribute names will include the "foo-bar" attribute.
   *
   * @private
   * @param {Constructor<HTMLElement>} classFn
   * @returns {string[]}
   */
  function attributesForClass(classFn) {
    // We treat the HTMLElement base class as if it has no attributes, since we
    // don't want to receive attributeChangedCallback for it (or anything further
    // up the protoype chain).
    if (classFn === HTMLElement) {
      return [];
    }

    // Get attributes for parent class.
    const baseClass = Object.getPrototypeOf(classFn.prototype).constructor;

    // See if parent class defines observedAttributes manually.
    let baseAttributes = baseClass.observedAttributes;
    if (!baseAttributes) {
      // Calculate parent class attributes ourselves.
      baseAttributes = attributesForClass(baseClass);
    }

    // Get the properties for this particular class.
    const propertyNames = Object.getOwnPropertyNames(classFn.prototype);
    const setterNames = propertyNames.filter(propertyName => {
      const descriptor = Object.getOwnPropertyDescriptor(classFn.prototype, propertyName);
      return descriptor && typeof descriptor.set === "function";
    });

    // Map the property names to attribute names.
    const attributes = setterNames.map(setterName => propertyNameToAttribute(setterName));

    // Merge the attribute for this class and its base class.
    const diff = attributes.filter(attribute => baseAttributes.indexOf(attribute) < 0);
    const result = baseAttributes.concat(diff);
    return result;
  }

  /**
   * Convert hyphenated foo-bar attribute name to camel case fooBar property name.
   *
   * @private
   * @param {string} attributeName
   */
  function attributeToPropertyName(attributeName) {
    let propertyName = attributeToPropertyNames[attributeName];
    if (!propertyName) {
      // Convert and memoize.
      const hyphenRegEx = /-([a-z])/g;
      propertyName = attributeName.replace(hyphenRegEx, match => match[1].toUpperCase());
      attributeToPropertyNames[attributeName] = propertyName;
    }
    return propertyName;
  }

  /**
   * Given a string value for a named boolean attribute, return `true` if the
   * value is either: a) the empty string, or b) a case-insensitive match for the
   * name.
   *
   * This is native HTML behavior; see the MDN documentation on [boolean
   * attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes#Boolean_Attributes)
   * for the reasoning.
   *
   * Given a null value, this return `false`.
   * Given a boolean value, this return the value as is.
   *
   * @param {string} name
   * @param {string|boolean|null} value
   */
  function booleanAttributeValue(name, value) {
    return typeof value === "boolean" ? value : typeof value === "string" ? value === "" || name.toLowerCase() === value.toLowerCase() : false;
  }

  /**
   * Convert a camel case fooBar property name to a hyphenated foo-bar attribute.
   *
   * @private
   * @param {string} propertyName
   */
  function propertyNameToAttribute(propertyName) {
    let attribute = propertyNamesToAttributes[propertyName];
    if (!attribute) {
      // Convert and memoize.
      const uppercaseRegEx = /([A-Z])/g;
      attribute = propertyName.replace(uppercaseRegEx, "-$1").toLowerCase();
      propertyNamesToAttributes[propertyName] = attribute;
    }
    return attribute;
  }

  /** @type {IndexedObject<boolean>} */
  const standardBooleanAttributes = {
    checked: true,
    defer: true,
    disabled: true,
    hidden: true,
    ismap: true,
    multiple: true,
    noresize: true,
    readonly: true,
    selected: true
  };

  /** @type {any} */
  const stateKey = Symbol("state");
  /** @type {any} */
  const raiseChangeEventsInNextRenderKey = Symbol("raiseChangeEventsInNextRender");
  // Tracks total set of changes made to elements since their last render.
  /** @type {any} */
  const changedSinceLastRenderKey = Symbol("changedSinceLastRender");

  /**
   * Manages component state and renders changes in state
   *
   * This is modeled after React/Preact's state management, and is adapted for
   * use with web components. Applying this mixin to a component will give it
   * FRP behavior comparable to React's.
   *
   * This model is very basic. It's key aspects are:
   * * an immutable `state` property updated via `setState` calls.
   * * a `render` method that will be invoked asynchronously when state changes.
   *
   * @module ReactiveMixin
   * @param {Constructor<CustomElement>} Base
   */
  function ReactiveMixin(Base) {
    class Reactive extends Base {
      constructor() {
        super();

        // Components can inspect `firstRender` during rendering to do special
        // work the first time (like wire up event handlers). Until the first
        // render actually happens, we set that flag to be undefined so we have a
        // way of distinguishing between a component that has never rendered and
        // one that is being rendered for the nth time.
        this[firstRender$1] = undefined;

        // We want to support the standard HTML pattern of only raising events in
        // response to direct user interactions. For a detailed discussion of this
        // point, see the Gold Standard checklist item for [Propery Change
        // Events](https://github.com/webcomponents/gold-standard/wiki/Property%20Change%20Events).
        //
        // To support this pattern, we define a flag indicating whether change
        // events should be raised. By default, we want the flag to be false. In
        // UI event handlers, a component can temporarily set the flag to true. If
        // a setState call is made while the flag is true, then that fact will be
        // remembered and passed the subsequent render/rendered methods. That will
        // let the methods know whether they should raise property change events.
        this[raiseChangeEvents$1] = false;

        // Maintain a change log of all fields which have changed since the
        // component was last rendered.
        this[changedSinceLastRenderKey] = null;

        // Set the initial state from the default state defined by the component
        // and its mixins/base classes.
        this[setState$1](this[defaultState$1]);
      }

      // When the component is attached to the document (or upgraded), we will
      // generally render the component for the first time. That operation will
      // include rendering of the default state and any state changes that
      // happened between constructor time and this connectedCallback.
      connectedCallback() {
        if (super.connectedCallback) {
          super.connectedCallback();
        }

        // Render the component.
        //
        // If the component was forced to render before this point, and the state
        // hasn't changed, this call will be a no-op.
        this[renderChanges$1]();
      }

      /**
       * The default state for the component. This can be extended by mixins and
       * classes to provide additional default state.
       *
       * @type {PlainObject}
       */
      // @ts-ignore
      get [defaultState$1]() {
        // Defer to base implementation if defined.
        return super[defaultState$1] || {};
      }

      /**
       * Render the indicated changes in state to the DOM.
       *
       * The default implementation of this method does nothing. Override this
       * method in your component to update your component's host element and
       * any shadow elements to reflect the component's new state. See the
       * [rendering example](ReactiveMixin#rendering).
       *
       * Be sure to call `super` in your method implementation so that your
       * component's base classes and mixins have a chance to perform their own
       * render work.
       *
       * @param {ChangedFlags} changed - dictionary of flags indicating which state
       * members have changed since the last render
       */
      [render$1](changed) {
        if (super[render$1]) {
          super[render$1](changed);
        }
      }

      /**
       * Render any pending component changes to the DOM.
       *
       * This method does nothing if the state has not changed since the last
       * render call.
       *
       * ReactiveMixin will invoke this method following a `setState` call;
       * you should not need to invoke this method yourself.
       *
       * This method invokes the internal `render` method, then invokes the
       * `rendered` method.
       */
      [renderChanges$1]() {
        if (this[firstRender$1] === undefined) {
          // First render.
          this[firstRender$1] = true;
        }

        // Get the log of which fields have changed since the last render.
        const changed = this[changedSinceLastRenderKey];

        // We only render if this is the first render, or state has changed since
        // the last render.
        if (this[firstRender$1] || changed) {
          // If at least one of the[setState] calls was made in response
          // to user interaction or some other component-internal event, set the
          // raiseChangeEvents flag so that render/rendered methods know whether
          // to raise property change events. See the comments in the component
          // constructor where we initialize this flag for details.
          const saveRaiseChangeEvents = this[raiseChangeEvents$1];
          this[raiseChangeEvents$1] = this[raiseChangeEventsInNextRenderKey];

          // From this point on, we'll assume we won't need to raise events in the
          // next render. If raiseChangeEvents is true right now, however, and the
          // rendered method calls setState, then this flag will be set to true
          // for the next render. That's apporopriate because the second-order
          // setState call in rendered still counts as a user-initiated effect
          // that should raise change events.
          this[raiseChangeEventsInNextRenderKey] = false;

          // We set a flag to indicate that rendering is happening. The component
          // may use this to avoid triggering other updates during the render.
          this[rendering$1] = true;

          // Invoke any internal render implementations.
          this[render$1](changed);
          this[rendering$1] = false;

          // Since we've now rendered all changes, clear the change log. If other
          // async render calls are queued up behind this call, they'll see an
          // empty change log, and so skip unnecessary render work.
          this[changedSinceLastRenderKey] = null;

          // Let the component know it was rendered.
          this[rendered$1](changed);

          // We've now rendered for the first time.
          this[firstRender$1] = false;

          // Restore state of event flag.
          this[raiseChangeEvents$1] = saveRaiseChangeEvents;
        }
      }

      /**
       * Perform any work that must happen after state changes have been rendered
       * to the DOM.
       *
       * The default implementation of this method does nothing. Override this
       * method in your component to perform work that requires the component to
       * be fully rendered, such as setting focus on a shadow element or
       * inspecting the computed style of an element. If such work should result
       * in a change in component state, you can safely call `setState` during the
       * `rendered` method.
       *
       * Be sure to call `super` in your method implementation so that your
       * component's base classes and mixins have a chance to perform their own
       * post-render work.
       *
       * @param {ChangedFlags} changed
       */
      [rendered$1](changed) {
        if (super[rendered$1]) {
          super[rendered$1](changed);
        }
      }

      /**
       * Update the component's state by merging the specified changes on
       * top of the existing state. If the component is connected to the document,
       * and the new state has changed, this returns a promise to asynchronously
       * render the component. Otherwise, this returns a resolved promise.
       *
       * @param {PlainObject} changes - the changes to apply to the element's state
       * @returns {Promise} - resolves when the new state has been rendered
       */
      async [setState$1](changes) {
        // There's no good reason to have a render method update state.
        if (this[rendering$1]) {
          /* eslint-disable no-console */
          console.warn(`${this.constructor.name} called [setState] during rendering, which you should avoid.\nSee https://elix.org/documentation/ReactiveMixin.`);
        }

        // Apply the changes to a copy of the component's current state to produce
        // a new, updated state and a dictionary of flags indicating which fields
        // actually changed.
        const {
          state,
          changed
        } = copyStateWithChanges(this, changes);

        // We only need to apply the changes to the component state if: a) the
        // current state is undefined (this is the first time setState has been
        // called), or b) the supplied changes parameter actually contains
        // substantive changes.
        if (this[stateKey] && Object.keys(changed).length === 0) {
          // No need to update state.
          return;
        }

        // Freeze the new state so it's immutable. This prevents accidental
        // attempts to set state without going through setState.
        Object.freeze(state);

        // Set this as the component's new state.
        this[stateKey] = state;

        // If setState was called with the raiseChangeEvents flag set, record that
        // fact for use in rendering. See the comments in the component
        // constructor for details.
        if (this[raiseChangeEvents$1]) {
          this[raiseChangeEventsInNextRenderKey] = true;
        }

        // Look to see whether the component is already set up to render.
        const willRender = this[firstRender$1] === undefined || this[changedSinceLastRenderKey] !== null;

        // Add this round of changed fields to the complete log of fields that
        // have changed since the component was last rendered.
        this[changedSinceLastRenderKey] = Object.assign(this[changedSinceLastRenderKey] || {}, changed);

        // We only need to queue a render if we're in the document and a render
        // operation hasn't already been queued for this component. If we're not
        // in the document yet, when the component is eventually added to the
        // document, the connectedCallback will ensure we render at that point.
        const needsRender = this.isConnected && !willRender;
        if (needsRender) {
          // Yield with promise timing. This lets any *synchronous* setState calls
          // that happen after this current setState call complete first. Their
          // effects on the state will be batched up, and accumulate in the change
          // log stored under this[changedSinceLastRenderKey].
          await Promise.resolve();

          // Now that the above promise has resolved, render the component. By the
          // time this line is reached, the complete log of batched changes can be
          // applied in a single render call.
          this[renderChanges$1]();
        }
      }

      /**
       * The component's current state.
       *
       * The returned state object is immutable. To update it, invoke
       * `internal.setState`.
       *
       * It's extremely useful to be able to inspect component state while
       * debugging. If you append `?elixdebug=true` to a page's URL, then
       * ReactiveMixin will conditionally expose a public `state` property that
       * returns the component's state. You can then access the state in your
       * browser's debug console.
       *
       * @type {PlainObject}
       */
      get [state$1]() {
        return this[stateKey];
      }

      /**
       * Ask the component whether a state with a set of recently-changed fields
       * implies that additional second-order changes should be applied to that
       * state to make it consistent.
       *
       * This method is invoked during a call to `internal.setState` to give all
       * of a component's mixins and classes a chance to respond to changes in
       * state. If one mixin/class updates state that it controls, another
       * mixin/class may want to respond by updating some other state member that
       * *it* controls.
       *
       * This method should return a dictionary of changes that should be applied
       * to the state. If the dictionary object is not empty, the
       * `internal.setState` method will apply the changes to the state, and
       * invoke this `stateEffects` method again to determine whether there are
       * any third-order effects that should be applied. This process repeats
       * until all mixins/classes report that they have no additional changes to
       * make.
       *
       * See an example of how `ReactiveMixin` invokes the `stateEffects` to
       * [ensure state consistency](ReactiveMixin#ensuring-state-consistency).
       *
       * @param {PlainObject} state - a proposal for a new state
       * @param {ChangedFlags} changed - the set of fields changed in this
       * latest proposal for the new state
       * @returns {PlainObject}
       */
      [stateEffects$1](state, changed) {
        return super[stateEffects$1] ? super[stateEffects$1](state, changed) : {};
      }
    }

    // Expose state when debugging; see note for `[state]` getter.
    const elixdebug = new URLSearchParams(location.search).get("elixdebug");
    if (elixdebug === "true") {
      Object.defineProperty(Reactive.prototype, "state", {
        get() {
          return this[state$1];
        }
      });
    }
    return Reactive;
  }

  /**
   * Create a copy of the component's state with the indicated changes applied.
   * Ask the component whether the new state implies any second-order effects. If
   * so, apply those and loop again until the state has stabilized. Return the new
   * state and a dictionary of flags indicating which fields were actually
   * changed.
   *
   * @private
   * @param {Element} element
   * @param {PlainObject} changes
   */
  function copyStateWithChanges(element, changes) {
    // Start with a copy of the current state.
    /** @type {PlainObject} */
    const state = Object.assign({}, element[stateKey]);
    /** @type {ChangedFlags} */
    const changed = {};
    // Take the supplied changes as the first round of effects.
    let effects = changes;
    // Loop until there are no effects to apply.
    /* eslint-disable no-constant-condition */
    while (true) {
      // See whether the effects actually changed anything in state.
      const changedByEffects = fieldsChanged(state, effects);
      if (Object.keys(changedByEffects).length === 0) {
        // No more effects to apply; we're done.
        break;
      }
      // Apply the effects.
      Object.assign(state, effects);
      Object.assign(changed, changedByEffects);
      // Ask the component if there are any second- (or third-, etc.) order
      // effects that should be applied.
      effects = element[stateEffects$1](state, changedByEffects);
    }
    return {
      state,
      changed
    };
  }

  /**
   * Return true if the two values are equal.
   *
   * @private
   * @param {any} value1
   * @param {any} value2
   * @returns {boolean}
   */
  function equal(value1, value2) {
    if (value1 instanceof Date && value2 instanceof Date) {
      return value1.getTime() === value2.getTime();
    }
    return value1 === value2;
  }

  /**
   * Return a dictionary of flags indicating which of the indicated changes to the
   * state are actually substantive changes.
   *
   * @private
   * @param {PlainObject} state
   * @param {PlainObject} changes
   */
  function fieldsChanged(state, changes) {
    /** @type {ChangedFlags} */
    const changed = {};
    for (const field in changes) {
      if (!equal(changes[field], state[field])) {
        changed[field] = true;
      }
    }
    return changed;
  }

  // A cache of processed templates, indexed by element class.
  const classTemplateMap = new Map();

  // A Proxy that maps shadow element IDs to shadow elements.
  // This will be return as the element's `this[ids]` property;
  // see comments in that property below.
  /** @type {any} */
  const shadowIdProxyKey = Symbol("shadowIdProxy");

  // A reference stored on the shadow element proxy target to get to the actual
  // element. We use a Symbol here instead of a string name to avoid naming
  // conflicts with the element's internal shadow element IDs.
  const proxyElementKey = Symbol("proxyElement");

  // A handler used for the shadow element ID proxy.
  const shadowIdProxyHandler = {
    get(target, id) {
      // From this proxy, obtain a reference to the original component.
      const element = target[proxyElementKey];

      // Get a reference to the component's open or closed shadow root.
      const root = element[shadowRoot$1];

      // Look for a shadow element with the indicated ID.
      return root && typeof id === "string" ? root.getElementById(id) : null;
    }
  };

  /**
   * Stamps a template into a component's Shadow DOM when instantiated
   *
   * To use this mixin, define a `template` method that returns a string or HTML
   * `<template>` element:
   *
   *     import { createElement, replace, transmute } from 'elix/src/template.js';
   *
   *     class MyElement extends ShadowTemplateMixin(HTMLElement) {
   *       get [template]() {
   *         return templateFrom.html`Hello, <em>world</em>.`;
   *       }
   *     }
   *
   * When your component class is instantiated, a shadow root will be created on
   * the instance, and the contents of the template will be cloned into the
   * shadow root. If your component does not define a `template` method, this
   * mixin has no effect.
   *
   * This adds a member on the component called `this[ids]` that can be used to
   * reference shadow elements with IDs. E.g., if component's shadow contains an
   * element `<button id="foo">`, then this mixin will create a member
   * `this[ids].foo` that points to that button.
   *
   * @module ShadowTemplateMixin
   * @param {Constructor<HTMLElement>} Base
   */
  function ShadowTemplateMixin(Base) {
    // The class prototype added by the mixin.
    class ShadowTemplate extends Base {
      /**
       * A convenient shortcut for looking up an element by ID in the component's
       * Shadow DOM subtree.
       *
       * Example: if component's template contains a shadow element `<button
       * id="foo">`, you can use the reference `this[ids].foo` to obtain
       * the corresponding button in the component instance's shadow tree. The
       * `ids` property is simply a shorthand for `getElementById`, so
       * `this[ids].foo` is the same as
       * `this[shadowRoot].getElementById('foo')`.
       *
       * @type {object} - a dictionary mapping shadow element IDs to elements
       */
      get [ids$1]() {
        if (!this[shadowIdProxyKey]) {
          // Construct a proxy that maps to getElementById.
          const target = {
            // Give the proxy a means of refering to this element via the target.
            [proxyElementKey]: this
          };
          this[shadowIdProxyKey] = new Proxy(target, shadowIdProxyHandler);
        }
        return this[shadowIdProxyKey];
      }

      /*
       * If the component defines a template, a shadow root will be created on the
       * component instance, and the template stamped into it.
       */
      [render$1]( /** @type {ChangedFlags} */changed) {
        if (super[render$1]) {
          super[render$1](changed);
        }

        // We populate the shadow root if the component doesn't have a shadow;
        // i.e., the first time the component is rendered. For this check, we use
        // an internal reference we maintain for the shadow root; see below.
        if (this[shadowRoot$1] === undefined) {
          // If this type of element defines a template, prepare it for use.
          const template = getTemplate(this);
          if (template) {
            // Stamp the template into a new shadow root.
            const root = this.attachShadow({
              delegatesFocus: this[delegatesFocus$1],
              mode: this[shadowRootMode$1]
            });
            const clone = document.importNode(template.content, true);
            root.append(clone);

            // After this call, we won't be able to rely on being able to access
            // the shadow root via `this.shadowRoot`, because the component may
            // have asked for a closed shadow root. We save a reference to the
            // shadow root now so that the component always has a consistent means
            // to reference its own shadow root.
            this[shadowRoot$1] = root;
          } else {
            // No template. Set shadow root to null (instead of undefined) so we
            // won't try to render shadow on next render.
            // @ts-ignore Not sure why/how TS has type info on this[shadowRoot].
            this[shadowRoot$1] = null;
          }
        }
      }

      /**
       * @type {ShadowRootMode}
       * @default "open"
       */
      get [shadowRootMode$1]() {
        return "open";
      }
    }
    return ShadowTemplate;
  }

  /**
   * Return the template for the element being instantiated.
   *
   * If this is the first time we're creating this type of element, or the
   * component has indicated that its template is dynamic (and should be retrieved
   * each time), ask the component class for the template and cache the result.
   * Otherwise, immediately return the cached template.
   *
   * @private
   * @param {HTMLElement} element
   * @returns {HTMLTemplateElement}
   */
  function getTemplate(element) {
    let t = element[hasDynamicTemplate$1] ? undefined // Always retrieve template
    : classTemplateMap.get(element.constructor); // See if we've cached it
    if (t === undefined) {
      // Ask the component for its template.
      t = element[template$h];
      // A component using this mixin isn't required to supply a template --
      // if they don't, they simply won't end up with a shadow root.
      if (t) {
        // But if the component does supply a template, it needs to be an
        // HTMLTemplateElement instance.
        if (!(t instanceof HTMLTemplateElement)) {
          throw `Warning: the [template] property for ${element.constructor.name} must return an HTMLTemplateElement.`;
        }
      }
      if (!element[hasDynamicTemplate$1]) {
        // Store prepared template for next creation of same type of element.
        // If the component didn't define a template, store null so that we skip
        // the template retrieval next time.
        classTemplateMap.set(element.constructor, t || null);
      }
    }
    return t;
  }

  /**
   * General-purpose base for writing components in functional-reactive style
   *
   * This base class lets you create web components in a functional-reactive
   * programming (FRP) style. It simply bundles a small set of mixins:
   *
   *     const ReactiveElement =
   *       AttributeMarshallingMixin(
   *       ReactiveMixin(
   *       ShadowTemplateMixin(
   *         HTMLElement
   *       )))));
   *
   * `ReactiveElement` is provided as a convenience. You can achieve the same
   * result by applying the mixins yourself to `HTMLElement`.
   *
   * @inherits HTMLElement
   * @mixes AttributeMarshallingMixin
   * @mixes ReactiveMixin
   * @mixes ShadowTemplateMixin
   */
  const ReactiveElement = AttributeMarshallingMixin(ReactiveMixin(ShadowTemplateMixin(HTMLElement)));

  /**
   * Collection of shared Symbol objects for internal component communication.
   *
   * The shared `Symbol` objects in this module let mixins and a component
   * internally communicate without exposing these internal properties and methods
   * in the component's public API. They also help avoid unintentional name
   * collisions, as a component developer must specifically import the `internal`
   * module and reference one of its symbols.
   *
   * To use these `Symbol` objects in your own component, include this module and
   * then create a property or method whose key is the desired Symbol. E.g.,
   * [ShadowTemplateMixin](ShadowTemplateMixin) expects a component to define
   * a property called [template](#template):
   *
   *     import { template } from 'elix/src/core/internal.js';
   *     import { templateFrom } from 'elix/src/core/htmlLiterals.js'
   *     import ShadowTemplateMixin from 'elix/src/core/ShadowTemplateMixin.js';
   *
   *     class MyElement extends ShadowTemplateMixin(HTMLElement) {
   *       [template]() {
   *         return templateFrom.html`Hello, <em>world</em>.`;
   *       }
   *     }
   *
   * The above use of the internal `template` member lets the mixin find the
   * component's template in a way that will not pollute the component's public
   * API or interfere with other component logic. For example, if for some reason
   * the component wants to define a separate property with the plain string name,
   * "template", it can do so without affecting the above property setter.
   *
   * @module internal
   */

  /**
   * Symbol for the `checkSize` method.
   *
   * If defined, this method will be invoked by [ResizeMixin](ResizeMixin)
   * when an element's size may have changed. The default implementation of
   * this method compares the element's current `clientHeight` and `clientWidth`
   * properties against the last known values of those properties (saved in
   * `state.clienHeight` and `state.clientWidth`).
   *
   * Components should override this method if they contain elements that may need
   * to know about size changes as well. For example, when an [Overlay](Overlay)
   * mixin opens, it invokes this method on any content elements that define it.
   * This gives the contents a chance to resize in response to being displayed.
   */
  const checkSize = Symbol("checkSize");

  /**
   * Symbol for the `closestAvailableItemIndex` method.
   *
   * This method is defined by [ItemsCursorMixin](ItemsCursorMixin). You can call
   * this if you want to find an item at a particular location, but may need to
   * account for the fact that the item at that position is not available, and
   * would like to find the closest item that is available.
   */
  const closestAvailableItemIndex = Symbol("closestAvailableItemIndex");

  /**
   * Symbol for the `contentSlot` property.
   *
   * [SlotContentMixin](SlotContentMixin) uses this to identify which slot
   * element in the component's shadow tree that holds the component's content.
   * By default, this is the first slot element with no "name" attribute. You
   * can override this to return a different slot.
   */
  const contentSlot = Symbol("contentSlot");

  /**
   * The default state for this element.
   */
  const defaultState = defaultState$1;

  /**
   * Symbol for the `defaultTabIndex` property.
   *
   * [KeyboardMixin](KeyboardMixin) uses this if it is unable to successfully
   * parse a string tabindex attribute.
   */
  const defaultTabIndex = Symbol("defaultTabIndex");

  /**
   * Symbol for the `delegatesFocus` property.
   *
   * [DelegatesFocusMixin](DelegatesFocusMixin) defines this property, returning
   * true to indicate that the focus is being delegated, even in browsers that
   * don't support that natively. Mixins like [KeyboardMixin](KeyboardMixin) use
   * this to accommodate focus delegation.
   */
  const delegatesFocus = delegatesFocus$1;

  /**
   * Symbol for the `effectEndTarget` property.
   *
   * [TransitionEffectMixin](TransitionEffectMixin) inspects this property to
   * determine which element's `transitionend` event will signal the end of a
   * transition effect.
   */
  const effectEndTarget = Symbol("effectEndTarget");

  /**
   * Symbol for the `firstRender` property.
   *
   * [ReactiveMixin](ReactiveMixin) sets the property to `true` during the
   * element's first `connectedCallback`, then `false` in subsequent callbacks.
   *
   * You can inspect this property in your own `connectedCallback` handler
   * to do work like wiring up events that should only happen once.
   */
  const firstRender = firstRender$1;

  /**
   * Symbol for the `focusTarget` property.
   *
   * [DelegatesFocusMixin](DelegatesFocusMixin) defines this property as either:
   * 1) the element itself, in browsers that support native focus delegation or,
   * 2) the shadow root's first focusable element.
   */
  const focusTarget = focusTarget$1;

  /**
   * Symbol for the `getItemText` method.
   *
   * This method can be applied to an item to return its text.
   * [KeyboardPrefixCursorMixin](KeyboardPrefixCursorMixin) uses this to
   * obtain the text for each item in a list, then matches keypresses again that
   * text.
   *
   * This method takes a single parameter: the `HTMLElement` of the item from
   * which text should be extracted.
   */
  const getItemText = Symbol("getItemText");

  /**
   * Symbol for the `goDown` method.
   *
   * This method is invoked when the user wants to go/navigate down.
   */
  const goDown = Symbol("goDown");

  /**
   * Symbol for the `goEnd` method.
   *
   * This method is invoked when the user wants to go/navigate to the end (e.g.,
   * of a list).
   */
  const goEnd = Symbol("goEnd");

  /**
   * Symbol for the `goFirst` method.
   *
   * This method is invoked when the user wants to go to the first item in a list.
   */
  const goFirst = Symbol("goFirst");

  /**
   * Symbol for the `goLast` method.
   *
   * This method is invoked when the user wants to go to the last item in a list.
   */
  const goLast = Symbol("goLast");

  /**
   * Symbol for the `goLeft` method.
   *
   * This method is invoked when the user wants to go/navigate left. Mixins that
   * make use of this method include
   * [KeyboardDirectionMixin](KeyboardDirectionMixin) and
   * [SwipeDirectionMixin](SwipeDirectionMixin).
   */
  const goLeft = Symbol("goLeft");

  /**
   * Symbol for the `goNext` method.
   *
   * This method is invoked when the user wants to go/navigate to the next item.
   */
  const goNext = Symbol("goNext");

  /**
   * Symbol for the `goPrevious` method.
   *
   * This method is invoked when the user wants to go/navigate to the previous item.
   */
  const goPrevious = Symbol("goPrevious");

  /**
   * Symbol for the `goRight` method.
   *
   * This method is invoked when the user wants to go/navigate right. Mixins
   * that make use of this method include
   * [KeyboardDirectionMixin](KeyboardDirectionMixin) and
   * [SwipeDirectionMixin](SwipeDirectionMixin).
   */
  const goRight = Symbol("goRight");

  /**
   * Symbol for the `goStart` method.
   *
   * This method is invoked when the user wants to go/navigate to the start
   * (e.g., of a list).
   */
  const goStart = Symbol("goStart");

  /**
   * Symbol for the `goToItemWithPrefix` method.
   *
   * This method is invoked by
   * [KeyboardPrefixCursorMixin](KeyboardPrefixCursorMixin) when the user types
   * text characters.
   */
  const goToItemWithPrefix = Symbol("goToItemWithPrefix");

  /**
   * Symbol for the `goUp` method.
   *
   * This method is invoked when the user wants to go/navigate up.
   */
  const goUp = Symbol("goUp");

  /**
   * Symbol for the `hasDynamicTemplate` property.
   *
   * If your component class does not always use the same template, define a
   * static class property getter with this symbol and have it return `true`.
   * This will disable template caching for your component.
   */
  const hasDynamicTemplate = hasDynamicTemplate$1;

  /**
   * Symbol for the `ids` property.
   *
   * [ShadowTemplateMixin](ShadowTemplateMixin) defines a shorthand function
   * `internal.ids` that can be used to obtain a reference to a shadow element with
   * a given ID.
   *
   * Example: if component's template contains a shadow element
   * `<button id="foo">`, you can use the reference `this[ids].foo` to obtain
   * the corresponding button in the component instance's shadow tree.
   * The `ids` function is simply a shorthand for `getElementById`, so
   * `this[ids].foo` is the same as `this.shadowRoot.getElementById('foo')`.
   */
  const ids = ids$1;

  /**
   * Symbol for the `inputDelegate` property.
   *
   * [DelegateInputSelectionMixin](DelegateInputSelectionMixin) uses this property
   * to indicate which shadow element is the input-type element to which text
   * selection methods and properties should be delegated.
   */
  const inputDelegate = Symbol("inputDelegate");

  /**
   * Symbol for the `itemsDelegate` property.
   *
   * A component using [DelegateItemsMixin](DelegateItemsMixin) uses this property
   * to indicate which one of its shadow elements is the one whose `items`
   * property will be treated as the component's own `items`.
   */
  const itemsDelegate = Symbol("itemsDelegate");

  /**
   * Symbol for the `keydown` method.
   *
   * This method is invoked when an element receives a `keydown` event.
   *
   * An implementation of `internal.keydown` should return `true` if it handled
   * the event, and `false` otherwise. If `true` is returned (the event was
   * handled), `KeyboardMixin` invokes the event's `preventDefault` and
   * `stopPropagation` methods to let the browser know the event was handled.
   *
   * The convention for handling `internal.keydown` is that the last mixin
   * applied wins. That is, if an implementation of `internal.keydown` *did*
   * handle the event, it can return immediately. If it did not, it should
   * invoke `super` to let implementations further up the prototype chain have
   * their chance.
   *
   * This method takes a `KeyboardEvent` parameter that contains the event being
   * processed.
   */
  const keydown = Symbol("keydown");

  /**
   * Symbol for the `mouseenter` method.
   *
   * [HoverMixin](HoverMixin) invokes this method when the user moves the
   * mouse over a component. That mixin provides a base implementation of this
   * method, but you can extend it to do additional work on `mouseenter`.
   *
   * This method takes a `MouseEvent` parameter that contains the event being
   * processed.
   */
  const mouseenter = Symbol("mouseenter");

  /**
   * Symbol for the `mouseleave` method.
   *
   * [HoverMixin](HoverMixin) invokes this method when the user moves off a
   * component. That mixin provides a base implementation of this method, but
   * you can extend it to do additional work on `mouseleave`.
   *
   * This method takes a `MouseEvent` parameter that contains the event being
   * processed.
   */
  const mouseleave = Symbol("mouseleave");

  /**
   * Symbol for access to native HTML element internals.
   */
  const nativeInternals = nativeInternals$1;

  /**
   * Symbol for the `raiseChangeEvents` property.
   *
   * This property is used by mixins to determine whether they should raise
   * property change events. The standard HTML pattern is to only raise such
   * events in response to direct user interactions. For a detailed discussion
   * of this point, see the Gold Standard checklist item for
   * [Propery Change Events](https://github.com/webcomponents/gold-standard/wiki/Property%20Change%20Events).
   *
   * The above article describes a pattern for using a flag to track whether
   * work is being performed in response to internal component activity, and
   * whether the component should therefore raise property change events.
   * This `raiseChangeEvents` symbol is a shared flag used for that purpose by
   * all Elix mixins and components. Sharing this flag ensures that internal
   * activity (e.g., a UI event listener) in one mixin can signal other mixins
   * handling affected properties to raise change events.
   *
   * All UI event listeners (and other forms of internal handlers, such as
   * timeouts and async network handlers) should set `raiseChangeEvents` to
   * `true` at the start of the event handler, then `false` at the end:
   *
   *     this.addEventListener('click', event => {
   *       this[raiseChangeEvents] = true;
   *       // Do work here, possibly setting properties, like:
   *       this.foo = 'Hello';
   *       this[raiseChangeEvents] = false;
   *     });
   *
   * Elsewhere, property setters that raise change events should only do so it
   * this property is `true`:
   *
   *     set foo(value) {
   *       // Save foo value here, do any other work.
   *       if (this[raiseChangeEvents]) {
   *         export const event = new CustomEvent('foochange');
   *         this.dispatchEvent(event);
   *       }
   *     }
   *
   * In this way, programmatic attempts to set the `foo` property will not trigger
   * the `foochange` event, but UI interactions that update that property will
   * cause those events to be raised.
   */
  const raiseChangeEvents = raiseChangeEvents$1;

  /**
   * Symbol for the `render` method.
   *
   * [ReactiveMixin](ReactiveMixin) invokes this `internal.render` method to give
   * the component a chance to render recent changes in component state.
   */
  const render = render$1;

  /**
   * Symbol for the `renderChanges` method.
   *
   * [ReactiveMixin](ReactiveMixin) invokes this method in response to a
   * `setState` call; you should generally not invoke this method yourself.
   */
  const renderChanges = renderChanges$1;

  /**
   * Symbol for the `renderDataToElement` method.
   *
   * [DataItemsMixin](DataItemsMixin) invokes this method to render data to an
   * element being used as an item in a list.
   */
  const renderDataToElement = Symbol("renderDataToElement");

  /**
   * Symbol for the `rendered` method.
   *
   * [ReactiveMixin](ReactiveMixin) will invoke this method after your
   * element has completely finished rendering.
   */
  const rendered = rendered$1;

  /**
   * Symbol for the `rendering` property.
   *
   * [ReactiveMixin](ReactiveMixin) sets this property to true during rendering,
   * at other times it will be false.
   */
  const rendering = rendering$1;

  /**
   * Symbol for the `scrollTarget` property.
   *
   * This property indicates which element in a component's shadow subtree
   * should be scrolled. [CursorInViewMixin](CursorInViewMixin) can use
   * this property to determine which element should be scrolled to keep the
   * selected item in view.
   */
  const scrollTarget = Symbol("scrollTarget");

  /**
   * Symbol for the `setState` method.
   *
   * A component using [ReactiveMixin](ReactiveMixin) can invoke this method to
   * apply changes to the element's current state.
   */
  const setState = setState$1;

  /**
   * Symbol for the `shadowRoot` property.
   *
   * This property holds a reference to an element's shadow root, like
   * `this.shadowRoot`. This propery exists because `this.shadowRoot` is not
   * available for components with closed shadow roots.
   * [ShadowTemplateMixin](ShadowTemplateMixin) creates open shadow roots by
   * default, but you can opt into creating closed shadow roots; see
   * [shadowRootMode](internal#internal.shadowRootMode).
   */
  const shadowRoot = shadowRoot$1;

  /**
   * Symbol for the `shadowRootMode` property.
   *
   * If true (the default), then [ShadowTemplateMixin](ShadowTemplateMixin) will
   * create an open shadow root when the component is instantiated. Set this to
   * false if you want to programmatically hide component internals in a closed
   * shadow root.
   */
  const shadowRootMode = shadowRootMode$1;

  /**
   * Symbol for the `startEffect` method.
   *
   * A component using [TransitionEffectMixin](TransitionEffectMixin) can invoke
   * this method to trigger the application of a named, asynchronous CSS
   * transition effect.
   *
   * This method takes a single `string` parameter giving the name of the effect
   * to start.
   */
  const startEffect = Symbol("startEffect");

  /**
   * The element's current state.
   *
   * This is managed by [ReactiveMixin](ReactiveMixin).
   */
  const state = state$1;
  const stateEffects = stateEffects$1;

  /**
   * Symbol for the `swipeDown` method.
   *
   * The swipe mixin [TouchSwipeMixin](TouchSwipeMixin) invokes this method when
   * the user finishes a gesture to swipe down.
   */
  const swipeDown = Symbol("swipeDown");

  /**
   * Symbol for the `swipeDownComplete` method.
   *
   * [SwipeCommandsMixin](SwipeCommandsMixin) invokes this method after any
   * animated transition associated with a swipe down has completed.
   */
  const swipeDownComplete = Symbol("swipeDownComplete");

  /**
   * Symbol for the `swipeLeft` method.
   *
   * The swipe mixins [TouchSwipeMixin](TouchSwipeMixin) and
   * [TrackpadSwipeMixin](TrackpadSwipeMixin) invoke this method when the user
   * finishes a gesture to swipe left.
   */
  const swipeLeft = Symbol("swipeLeft");

  /**
   * Symbol for the `swipeLeftTransitionEnd` method.
   *
   * [SwipeCommandsMixin](SwipeCommandsMixin) invokes this method after any
   * animated transition associated with a swipe left has completed.
   */
  const swipeLeftTransitionEnd = Symbol("swipeLeftTransitionEnd");

  /**
   * Symbol for the `swipeRight` method.
   *
   * The swipe mixins [TouchSwipeMixin](TouchSwipeMixin) and
   * [TrackpadSwipeMixin](TrackpadSwipeMixin) invoke this method when the user
   * finishes a gesture to swipe right.
   */
  const swipeRight = Symbol("swipeRight");

  /**
   * Symbol for the `swipeRightTransitionEnd` method.
   *
   * [SwipeCommandsMixin](SwipeCommandsMixin) invokes this method after any
   * animated transition associated with a swipe right has completed.
   */
  const swipeRightTransitionEnd = Symbol("swipeRightTransitionEnd");

  /**
   * Symbol for the `swipeUp` method.
   *
   * The swipe mixin [TouchSwipeMixin](TouchSwipeMixin) invokes this method when
   * the user finishes a gesture to swipe up.
   */
  const swipeUp = Symbol("swipeUp");

  /**
   * Symbol for the `swipeUpComplete` method.
   *
   * [SwipeCommandsMixin](SwipeCommandsMixin) invokes this method after any
   * animated transition associated with a swipe up has completed.
   */
  const swipeUpComplete = Symbol("swipeUpComplete");

  /**
   * Symbol for the `swipeStart` method.
   *
   * [TouchSwipeMixin](TouchSwipeMixin) and
   * [TrackpadSwipeMixin](TrackpadSwipeMixin) invoke this method when a swipe
   * is starting, passing in the starting (x, y) client coordinate.
   */
  const swipeStart = Symbol("swipeStart");

  /**
   * Symbol for the `swipeTarget` property.
   *
   * By default, the swipe mixins [TouchSwipeMixin](TouchSwipeMixin) and
   * [TrackpadSwipeMixin](TrackpadSwipeMixin) assume that the element the user
   * is swiping the top-level element. In some cases (e.g., [Drawer](Drawer)),
   * the component wants to let the user swipe a shadow element. In such cases,
   * this property should return the element that should be swiped.
   *
   * The swipe target's `offsetWidth` is used by the mixin to calculate the
   * `state.swipeFraction` member when the user drags their finger. The
   * `swipeFraction` is the distance the user has dragged in the current drag
   * operation over that `offsetWidth`.
   */
  const swipeTarget = Symbol("swipeTarget");

  /**
   * Symbol for the `tap` method.
   *
   * This method is invoked when an element receives an operation that should
   * be interpreted as a tap. [TapCursorMixin](TapCursorMixin)
   * invokes this when the element receives a `mousedown` event, for example.
   */
  const tap = Symbol("tap");

  /**
   * Symbol for the `template` method.
   *
   * [ShadowTemplateMixin](ShadowTemplateMixin) uses this property to obtain a
   * component's template, which it will clone into a component's shadow root.
   */
  const template$g = template$h;

  /**
   * Symbol for the `toggleSelectedFlag` method.
   *
   * [ItemsMultiSelectMixin](ItemsMultiSelectMixin) exposes this method to let
   * other mixins like [MultiSelectAPIMixin](MultiSelectAPIMixin) toggle the
   * selected state of an individual item.
   */
  const toggleSelectedFlag = Symbol("toggleSelectedFlag");

  // Expose internals as a global when debugging.
  const elixdebug = new URLSearchParams(location.search).get("elixdebug");
  if (elixdebug === "true") {
    /** @type {any} */window.elix = {
      internal: {
        checkSize,
        closestAvailableItemIndex,
        contentSlot,
        defaultState,
        defaultTabIndex,
        delegatesFocus,
        effectEndTarget,
        firstRender,
        focusTarget,
        getItemText,
        goDown,
        goEnd,
        goFirst,
        goLast,
        goLeft,
        goNext,
        goPrevious,
        goRight,
        goStart,
        goToItemWithPrefix,
        goUp,
        hasDynamicTemplate,
        ids,
        inputDelegate,
        itemsDelegate,
        keydown,
        mouseenter,
        mouseleave,
        nativeInternals,
        event,
        raiseChangeEvents,
        render,
        renderChanges,
        renderDataToElement,
        rendered,
        rendering,
        scrollTarget,
        setState,
        shadowRoot,
        shadowRootMode,
        startEffect,
        state,
        stateEffects,
        swipeDown,
        swipeDownComplete,
        swipeLeft,
        swipeLeftTransitionEnd,
        swipeRight,
        swipeRightTransitionEnd,
        swipeUp,
        swipeUpComplete,
        swipeStart,
        swipeTarget,
        tap,
        template: template$g,
        toggleSelectedFlag
      }
    };
  }

  /**
   * Delegates its ARIA label property to an inner input-type element.
   *
   * This helps ensure that elements built around an inner input element provide a
   * proper accessible label for assistive technologies like screen readers.
   *
   * You can identify which inner input element selection should be delegated to
   * by defining an `internal.inputDelegate` property and returning the desired
   * inner input.
   *
   * @module DelegateInputLabelMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function DelegateInputLabelMixin(Base) {
    // The class prototype added by the mixin.
    class DelegateInputLabel extends Base {
      // Forward any ARIA label to the input element.
      get ariaLabel() {
        return this[state].ariaLabel;
      }
      set ariaLabel(ariaLabel) {
        if (!this[state].removingAriaAttribute) {
          this[setState]({
            ariaLabel: String(ariaLabel)
          });
        }
      }

      // Forward ARIA labelledby as an aria-label to the input element.
      // Note the lowercase "b" in the name, necessary to support the actual
      // attribute name "aria-labelledby", which has no hyphen before the "by".
      get ariaLabelledby() {
        return this[state].ariaLabelledby;
      }
      set ariaLabelledby(ariaLabelledby) {
        if (!this[state].removingAriaAttribute) {
          this[setState]({
            ariaLabelledby: String(ariaLabelledby)
          });
        }
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          ariaLabel: null,
          ariaLabelledby: null,
          inputLabel: null,
          removingAriaAttribute: false
        });
      }
      [render](changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          // Refresh the input label on focus. This refresh appears to happen fast
          // enough that the screen reader will announce the refreshed label.
          this.addEventListener("focus", () => {
            this[raiseChangeEvents] = true;
            const inputLabel = refreshInputLabel(this, this[state]);
            this[setState]({
              inputLabel
            });
            this[raiseChangeEvents] = false;
          });
        }

        // Apply the latest input label to the input delegate.
        if (changed.inputLabel) {
          const {
            inputLabel
          } = this[state];
          if (inputLabel) {
            this[inputDelegate].setAttribute("aria-label", inputLabel);
          } else {
            this[inputDelegate].removeAttribute("aria-label");
          }
        }
      }
      [rendered](changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (this[firstRender]) {
          // Refresh the label on first render. This is not guaranteed to pick up
          // labels defined by another element, as that element (or elements) may
          // not be in the DOM yet. For that reason, we'll also refresh the label
          // on focus. The reason to do it now is to handle the common cases where
          // the element defining the label does exist so that accessibility
          // testing tools can confirm that the input delegate does have a label.
          // Because this refresh can entail multiple searches of the tree, we
          // defer the refresh to idle time.
          // @ts-ignore
          const idleCallback = window.requestIdleCallback || setTimeout;
          idleCallback(() => {
            const inputLabel = refreshInputLabel(this, this[state]);
            this[setState]({
              inputLabel
            });
          });
        }

        // Once we've obtained an aria-label or aria-labelledby from the host, we
        // remove those attirbutes so that the labels don't get announced twice.
        // We use a flag to distinguish between us removing our own ARIA
        // attributes (which should not update state), and someone removing
        // those attributes from the outside (which should update state).
        const {
          ariaLabel,
          ariaLabelledby
        } = this[state];
        if (changed.ariaLabel && !this[state].removingAriaAttribute) {
          if (this.getAttribute("aria-label")) {
            this.setAttribute("delegated-label", ariaLabel);
            this[setState]({
              removingAriaAttribute: true
            });
            this.removeAttribute("aria-label");
          }
        }
        if (changed.ariaLabelledby && !this[state].removingAriaAttribute) {
          if (this.getAttribute("aria-labelledby")) {
            this.setAttribute("delegated-labelledby", ariaLabelledby);
            this[setState]({
              removingAriaAttribute: true
            });
            this.removeAttribute("aria-labelledby");
          }
        }
        if (changed.removingAriaAttribute && this[state].removingAriaAttribute) {
          // We've done whatever removal we needed, and can now reset our flag.
          this[setState]({
            removingAriaAttribute: false
          });
        }
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // If the ariaLabel changes, we can update our inputLabel state
        // immediately. Among other things, this facilitates scenarios where we
        // have nested elements using DelegateInputLabelMixin: the outermost
        // element can use whatever label approach it wants, the inner elements
        // will all use ariaLabel.
        //
        // We also update the label if we're focused, using ariaLabelledby, and
        // the selectedText changes. One pattern with select-like elements is to
        // have them include their own ID in the IDs specified by aria-labelledby.
        // This can incorporate the element's own `selectedText` in the announced
        // label. That `selectedText` can change while the element has focus, in
        // which case we'll refresh.
        if (changed.ariaLabel && state.ariaLabel || changed.selectedText && state.ariaLabelledby && this.matches(":focus-within")) {
          const inputLabel = refreshInputLabel(this, state);
          Object.assign(effects, {
            inputLabel
          });
        }
        return effects;
      }
    }
    return DelegateInputLabel;
  }

  // Given an element that is being used as a label, extract its label text.
  function getLabelFromElement(element) {
    // We use innerText here instead of textContent because we want the rendered
    // text. If, e.g., a text node includes a span with `display: none`,
    // textContent would include that hidden text, but innerText would leave it
    // out -- which is what we want here.
    if ("selectedText" in element) {
      // Element (most likely Elix) with selectedText property
      return element.selectedText;
    } else if ("value" in element && "options" in element) {
      // select or select-like element
      const value = element.value;
      const option = element.options.find(option => option.value === value);
      return option ? option.innerText : "";
    } else if ("value" in element) {
      // Other input element
      return element.value;
    } else {
      // Other
      return element.innerText;
    }
  }

  /**
   * Calculate an appropriate label for the component's delegated input element.
   * When the element gets the focus, we refresh its label. This is done because
   * three of the labeling strategies (`aria-labelledby` attribute, `for`
   * attribute, and wrapping `label`) reference other elements in the tree -- and
   * the contents of those elements can change dynamically.
   *
   * @private
   * @param {HTMLElement} element
   * @param {PlainObject} state
   */
  function refreshInputLabel(element, state) {
    const {
      ariaLabel,
      ariaLabelledby
    } = state;
    /** @type {any} */
    const rootNode = element.isConnected ? element.getRootNode() : null;
    let inputLabel = null;

    // Prefer aria-labelledby over aria-label, per
    // https://developers.google.com/web/fundamentals/accessibility/semantics-aria/aria-labels-and-relationships.
    // After that, we prefer a `label` element with a `for` attribute, and finally
    // a wrapping `label` element.
    //
    // There do not appear to be consistent cross-browser rules for handling
    // multiple forms of label assignment on the same component. E.g., if you
    // place an element in a wrapping label *and* point a `label` element at that
    // element with a `for` attribute, as of August 2020 Chrome and Firefox will
    // announce both, but Safari will only announce the `for` label.
    //
    // Since people are probably not relying upon specific results for multiple
    // forms of label assignment, we don't attempt to construct a combined label
    // in those cases.
    if (ariaLabelledby && rootNode) {
      // Collect labels from elements with the indicated IDs.
      const ids = ariaLabelledby.split(" ");
      const labels = ids.map(id => {
        const elementWithId = rootNode.getElementById(id);
        // Get a label from the indicated element.
        // Special case: if the element is providing its own label, we return its
        // current `selectedText` state.
        const label = !elementWithId ? "" : elementWithId === element && state.value !== null ? state.selectedText : getLabelFromElement(elementWithId);
        return label;
      });
      inputLabel = labels.join(" ");
    } else if (ariaLabel) {
      // Use ariaLabel property as input label.
      inputLabel = ariaLabel;
    } else if (rootNode) {
      const id = element.id;
      if (id) {
        // Look for labelling element with `for` attribute.
        const elementWithFor = rootNode.querySelector(`[for="${id}"]`);
        if (elementWithFor instanceof HTMLElement) {
          // Obtain label from wrapping label element.
          inputLabel = getLabelFromElement(elementWithFor);
        }
      }
      if (inputLabel === null) {
        // Last option is to look for closest wrapping label element.
        const labelElement = element.closest("label");
        if (labelElement) {
          inputLabel = getLabelFromElement(labelElement);
        }
      }
    }
    if (inputLabel) {
      inputLabel = inputLabel.trim();
    }
    return inputLabel;
  }

  /**
   * Miscellaneous DOM helpers for web components
   *
   * @module dom
   */

  const mousedownListenerKey = Symbol("mousedownListener");

  /**
   * Return the closest focusable node that's either the node itself (if it's
   * focusable), or the closest focusable ancestor in the *composed* tree.
   *
   * If no focusable node is found, this returns null.
   *
   * @param {Node} node
   * @returns {HTMLElement|null}
   */
  function closestFocusableNode(node) {
    for (const current of selfAndComposedAncestors(node)) {
      // If the current element defines a focusTarget (e.g., via
      // DelegateFocusMixin), use that, otherwise use the element itself.
      const target = current[focusTarget$1] || current;
      // We want an element that has a tabIndex of 0 or more. We ignore disabled
      // elements, and slot elements (which oddly have a tabIndex of 0).
      /** @type {any} */
      const cast = target;
      const focusable = target instanceof HTMLElement && target.tabIndex >= 0 && !cast.disabled && !(target instanceof HTMLSlotElement);
      if (focusable) {
        return target;
      }
    }
    return null;
  }

  /**
   * Return the ancestors of the given node in the composed tree.
   *
   * In the composed tree, the ancestor of a node assigned to a slot is that slot,
   * not the node's DOM ancestor. The ancestor of a shadow root is its host.
   *
   * @param {Node} node
   * @returns {Iterable<Node>}
   */
  function* composedAncestors(node) {
    /** @type {Node|null} */
    let current = node;
    while (true) {
      current = current instanceof HTMLElement && current.assignedSlot ? current.assignedSlot : current instanceof ShadowRoot ? current.host : current.parentNode;
      if (current) {
        yield current;
      } else {
        break;
      }
    }
  }

  /**
   * Returns true if the first node contains the second, even if the second node
   * is in a shadow tree.
   *
   * The standard Node.contains() function does not account for Shadow DOM, and
   * returns false if the supplied target node is sitting inside a shadow tree
   * within the container.
   *
   * @param {Node} container - The container to search within.
   * @param {Node} target - The node that may be inside the container.
   * @returns {boolean} - True if the container contains the target node.
   */
  function deepContains(container, target) {
    /** @type {any} */
    let current = target;
    while (current) {
      const parent = current.assignedSlot || current.parentNode || current.host;
      if (parent === container) {
        return true;
      }
      current = parent;
    }
    return false;
  }

  /**
   * Return the first focusable element in the composed tree below the given root.
   * The composed tree includes nodes assigned to slots.
   *
   * This heuristic considers only the document order of the elements below the
   * root and whether a given element is focusable. It currently does not respect
   * the tab sort order defined by tabindex values greater than zero.
   *
   * @param {Node} root - the root of the tree in which to search
   * @returns {HTMLElement|null} - the first focusable element, or null if none
   * was found
   */
  function firstFocusableElement(root) {
    // CSS selectors for focusable elements from
    // https://stackoverflow.com/a/30753870/76472
    const focusableQuery = 'a[href],area[href],button:not([disabled]),details,iframe,input:not([disabled]),select:not([disabled]),textarea:not([disabled]),[contentEditable="true"],[tabindex]';
    // Walk the tree looking for nodes that match the above selectors.
    const walker = walkComposedTree(root, ( /** @type {Node} */node) => node instanceof HTMLElement && node.matches(focusableQuery) && node.tabIndex >= 0);
    // We only actually need the first matching value.
    const {
      value
    } = walker.next();
    // value, if defined, will always be an HTMLElement, but we do the following
    // check to pass static type checking.
    return value instanceof HTMLElement ? value : null;
  }

  /**
   * Trap any `mousedown` events on the `origin` element and prevent the default
   * behavior from setting the focus on that element. Instead, put the focus on
   * the `target` element (or, if the `target` is not focusable, on the target's
   * closest focusable ancestor).
   *
   * If this method is called again with the same `origin` element, the old
   * forwarding is overridden, and focus will now go to the new `target` element.
   *
   * If the `target` parameter is `null`, focus handling will be removed from the
   * indicated `origin`.
   *
   * @param {HTMLElement} origin
   * @param {HTMLElement|null} target
   */
  function forwardFocus(origin, target) {
    if (origin[mousedownListenerKey]) {
      // Origin was previously forwarding focus, probably to a different target.
      // Remove the previous event listener.
      origin.removeEventListener("mousedown", origin[mousedownListenerKey]);
    }
    if (target) {
      origin[mousedownListenerKey] = ( /** @type {MouseEvent} */event) => {
        // Only process events for the main (usually left) button.
        if (event.button !== 0) {
          return;
        }
        // What element wants the focus?
        const desiredTarget = target[focusTarget$1] || target;
        // What ancestor can actually take the focus?
        const focusableTarget = closestFocusableNode(desiredTarget);
        if (focusableTarget) {
          focusableTarget.focus();
          event.preventDefault();
        }
      };
      origin.addEventListener("mousedown", origin[mousedownListenerKey]);
    }
  }

  /**
   * Search a list element for the item that contains the specified target.
   *
   * When dealing with UI events (e.g., mouse clicks) that may occur in
   * subelements inside a list item, you can use this routine to obtain the
   * containing list item.
   *
   * @param {NodeList|Node[]} items - A list element containing a set of items
   * @param {Node} target - A target element that may or may not be an item in the
   * list.
   * @returns {number} - The index of the list child that is or contains the
   * indicated target node. Returns -1 if not found.
   */
  function indexOfItemContainingTarget(items, target) {
    return Array.prototype.findIndex.call(items, ( /** @type Node */item) => item === target || deepContains(item, target));
  }

  /**
   * Return true if the event came from within the node (or from the node itself);
   * false otherwise.
   *
   * @param {Node} node - The node to consider in relation to the event
   * @param {Event} event - The event which may have been raised within/by the
   * node
   * @returns {boolean} - True if the event was raised within or by the node
   */
  function ownEvent(node, event) {
    /** @type {any} */
    const cast = event;
    const eventSource = cast.composedPath()[0];
    return node === eventSource || deepContains(node, eventSource);
  }

  /**
   * Returns the set that includes the given node and all of its ancestors in the
   * composed tree. See [composedAncestors](#composedAncestors) for details on the
   * latter.
   *
   * @param {Node} node
   * @returns {Iterable<Node>}
   */
  function* selfAndComposedAncestors(node) {
    if (node) {
      yield node;
      yield* composedAncestors(node);
    }
  }

  /**
   * Set an internal state for browsers that support custom state pseudo classes,
   * as well as an attribute of the same name to permit state-based styling on
   * older browsers.
   *
   * When all browsers support custom state pseudo classes, we'd like to deprecate
   * use of attributes.
   *
   * @param {Element} element
   * @param {string} name
   * @param {boolean} value
   */
  function setInternalState$2(element, name, value) {
    element.toggleAttribute(name, value);
    if (element[nativeInternals$1] && element[nativeInternals$1].states) {
      const states = element[nativeInternals$1].states;
      const stateName = `--${name}`;
      if (value) {
        states.add(stateName);
      } else {
        states.delete(stateName);
      }
    }
  }

  /**
   * Adds or removes the element's `childNodes` as necessary to match the nodes
   * indicated in the `childNodes` parameter.
   *
   * This operation is useful in cases where you maintain your own set of nodes
   * which should be rendered as the children of some element. When you insert or
   * remove nodes in that set, you can invoke this function to efficiently apply
   * the new set as a delta to the existing children. Only the items in the set
   * that have actually changed will be added or removed.
   *
   * @param {Element} element - the element to update
   * @param {(NodeList|Node[])} childNodes - the set of nodes to apply
   */
  function updateChildNodes(element, childNodes) {
    // If the childNodes parameter is the actual childNodes of an element, then as
    // we append those nodes to the indicated target element, they'll get removed
    // from the original set. To keep the list stable, we make a copy.
    const copy = [...childNodes];
    const oldLength = element.childNodes.length;
    const newLength = copy.length;
    const length = Math.max(oldLength, newLength);
    for (let i = 0; i < length; i++) {
      const oldChild = element.childNodes[i];
      const newChild = copy[i];
      if (i >= oldLength) {
        // Add new item not in old set.
        element.append(newChild);
      } else if (i >= newLength) {
        // Remove old item past end of new set.
        element.removeChild(element.childNodes[newLength]);
      } else if (oldChild !== newChild) {
        if (copy.indexOf(oldChild, i) >= i) {
          // Old node comes later in final set. Insert the new node rather than
          // replacing it so that we don't detach the old node only to have to
          // reattach it later.
          element.insertBefore(newChild, oldChild);
        } else {
          // Replace old item with new item.
          element.replaceChild(newChild, oldChild);
        }
      }
    }
  }

  /**
   * Walk the composed tree at the root for elements that pass the given filter.
   *
   * Note: the jsDoc types required for the filter function are too complex for
   * the current jsDoc parser to support strong type-checking.
   *
   * @private
   * @param {Node} node
   * @param {function} filter
   * @returns {IterableIterator<Node>}
   */
  function* walkComposedTree(node, filter) {
    if (filter(node)) {
      yield node;
    }
    let children;
    if (node instanceof HTMLElement && node.shadowRoot) {
      // Walk the shadow instead of the light DOM.
      children = node.shadowRoot.children;
    } else {
      const assignedNodes = node instanceof HTMLSlotElement ? node.assignedNodes({
        flatten: true
      }) : [];
      children = assignedNodes.length > 0 ?
      // Walk light DOM nodes assigned to this slot.
      assignedNodes :
      // Walk light DOM children.
      node.childNodes;
    }
    if (children) {
      for (let i = 0; i < children.length; i++) {
        yield* walkComposedTree(children[i], filter);
      }
    }
  }

  // We consider the keyboard to be active if the window has received a keydown
  // event since the last mousedown event.
  let keyboardActive = false;

  /** @type {any} */
  const focusVisibleChangedListenerKey = Symbol("focusVisibleChangedListener");

  /**
   * Shows a focus indication if and only if the keyboard is active.
   *
   * The keyboard is considered to be active if a keyboard event has occurred
   * since the last mousedown event.
   *
   * This is loosely modeled after the proposed
   * [focus-visible](https://github.com/WICG/focus-visible) feature for CSS.
   *
   * @module FocusVisibleMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function FocusVisibleMixin(Base) {
    // The class prototype added by the mixin.
    return class FocusVisible extends Base {
      constructor() {
        // @ts-ignore
        super();

        // We listen to focusin/focusout instead of focus/blur because components
        // like Menu want to handle focus visiblity for the items they contain,
        // and those contained items can get the focus. Using focusin/focusout
        // lets us know whether this element *or any element it contains* has the
        // focus.
        //
        // Focus events are problematic in that they can occur during rendering:
        // if an element with the focus is updated so that its tabindex is
        // removed, it will lose focus. Since these focus handlers need to set
        // state, this could lead to setting state during rendering, which is bad.
        // To avoid this problem, we use promise timing to defer the setting of
        // state.
        this.addEventListener("focusout", event => {
          Promise.resolve().then(() => {
            // What has the focus now?
            /** @type {any} */
            const cast = event;
            const newFocusedElement = cast.relatedTarget || document.activeElement;
            const isFocusedElement = this === newFocusedElement;
            const containsFocus = deepContains(this, newFocusedElement);
            const lostFocus = !isFocusedElement && !containsFocus;
            if (lostFocus) {
              this[setState]({
                focusVisible: false
              });
              // No longer need to listen for changes in focus visibility.
              document.removeEventListener("focusvisiblechange", this[focusVisibleChangedListenerKey]);
              this[focusVisibleChangedListenerKey] = null;
            }
          });
        });
        this.addEventListener("focusin", () => {
          Promise.resolve().then(() => {
            if (this[state].focusVisible !== keyboardActive) {
              // Show the element as focused if the keyboard has been used.
              this[setState]({
                focusVisible: keyboardActive
              });
            }
            if (!this[focusVisibleChangedListenerKey]) {
              // Listen to subsequent changes in focus visibility.
              this[focusVisibleChangedListenerKey] = () => refreshFocus(this);
              document.addEventListener("focusvisiblechange", this[focusVisibleChangedListenerKey]);
            }
          });
        });
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          focusVisible: false
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }

        // Suppress the component's normal `outline` style unless we know the
        // focus should be visible.
        if (changed.focusVisible) {
          const {
            focusVisible
          } = this[state];
          this.toggleAttribute("focus-visible", focusVisible);
        }
      }
      get [template$g]() {
        const result = super[template$g] || templateFrom.html``;
        result.content.append(fragmentFrom.html`
        <style>
          :host {
            outline: none;
          }

          :host([focus-visible]:focus-within) {
            outline-color: Highlight; /* Firefox */
            outline-color: -webkit-focus-ring-color; /* All other browsers */
            outline-style: auto;
          }
        </style>
      `);
        return result;
      }
    };
  }
  function refreshFocus( /** @type {ReactiveElement} */element) {
    element[setState]({
      focusVisible: keyboardActive
    });
  }
  function updateKeyboardActive( /** @type {boolean} */newKeyboardActive) {
    if (keyboardActive !== newKeyboardActive) {
      keyboardActive = newKeyboardActive;
      const event = new CustomEvent("focusvisiblechange", {
        detail: {
          focusVisible: keyboardActive
        }
      });
      document.dispatchEvent(event);
    }
  }

  // Listen for top-level keydown and mousedown events.
  // Use capture phase so we detect events even if they're handled.
  window.addEventListener("keydown", () => {
    updateKeyboardActive(true);
  }, {
    capture: true
  });
  window.addEventListener("mousedown", () => {
    updateKeyboardActive(false);
  }, {
    capture: true
  });

  /**
   * Allows a component to participate in HTML form submission.
   *
   * The mixin expects the component to define a `value` property of type
   * `string`.
   *
   * @module FormElementMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function FormElementMixin(Base) {
    // The class prototype added by the mixin.
    class FormElement extends Base {
      constructor() {
        super();
        /** @type {any} */
        const cast = this;
        if (!this[nativeInternals] && cast.attachInternals) {
          this[nativeInternals] = cast.attachInternals();
        }
      }
      checkValidity() {
        return this[nativeInternals].checkValidity();
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          name: "",
          validationMessage: "",
          valid: true
        });
      }

      // Uncomment for debugging only
      get internals() {
        return this[nativeInternals];
      }
      static get formAssociated() {
        return true;
      }

      /**
       * The ID of the `form` element with which this element is associated,
       * or `null` if the element is not associated with any form. This is provided
       * for consistency with the native HTML
       * [form](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#form)
       * property.
       *
       * @type {string}
       */
      get form() {
        return this[nativeInternals].form;
      }

      /**
       * The name of the form field that will be filled with this element's
       * `value`. This is an analogue of the standard HTML
       * [name](https://developer.mozilla.org/en-US/docs/Web/API/Element/name)
       * property.
       *
       * @type {string}
       */
      get name() {
        return this[state] ? this[state].name : "";
      }
      set name(name) {
        const s = String(name);
        if ("name" in Base.prototype) {
          super.name = s;
        }
        this[setState]({
          name: s
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }

        // Reflect name property to attribute so form will pick it up.
        if (changed.name) {
          const {
            name
          } = this[state];
          if (name) {
            this.setAttribute("name", name);
          } else {
            this.removeAttribute("name");
          }
        }
        if (this[nativeInternals] && this[nativeInternals].setValidity) {
          // Reflect validity state to internals.
          if (changed.valid || changed.validationMessage) {
            const {
              valid,
              validationMessage
            } = this[state];
            if (valid) {
              this[nativeInternals].setValidity({});
            } else {
              this[nativeInternals].setValidity({
                customError: true
              }, validationMessage);
            }
          }
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.value) {
          if (this[nativeInternals] && this[nativeInternals].setFormValue) {
            this[nativeInternals].setFormValue(this[state].value, this[state]);
          }
        }
      }
      reportValidity() {
        return this[nativeInternals].reportValidity();
      }

      /**
       * The "type" of the form field, provided for consistency with the
       * native HTML
       * [type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#type)
       * property.
       *
       * If a base class provides a `type` property, that will be returned. (If
       * this mixin is applied to a class defined by WrappedStandardElement, this
       * will return the `type` of the inner standard element.) Otherwise, the
       * default value of this property will be the same as the HTML tag name
       * registered for the custom element.
       *
       * @type {string}
       */
      get type() {
        // Defer to base class value.
        return super.type || this.localName;
      }
      get validationMessage() {
        return this[state].validationMessage;
      }
      get validity() {
        return this[nativeInternals].validity;
      }
      get willValidate() {
        return this[nativeInternals].willValidate;
      }
    }
    return FormElement;
  }

  /**
   * Track the selection state of an inner input-like element
   *
   * This mixin is an adjunct to [WrappedStandardElement](WrappedStandardElement),
   * intended to be used with a wrapped input or textarea. The inner input or
   * textarea will have selection properties `selectionStart` and `selectionEnd`
   * that we would like to track as state members. Doing so is challenging,
   * because the browser provides no standard event for tracking a change in
   * selection.
   *
   * To compensate, this mixin listens to keyboard or mouse activity within the
   * inner element that might affect selection, then refreshes the host
   * component's selection state as appropriate.
   *
   * @module TrackTextSelectionMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function TrackTextSelectionMixin(Base) {
    // The class prototype added by the mixin.
    class TrackTextSelection extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          selectionEnd: 0,
          selectionStart: 0
        });
      }
      [render](changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          // The user can manually update the selection with the keyboard or
          // mouse. We listen to keydown and mousedown events, wait for the
          // browser to perform its default action, and then refresh the selection
          // state in case it changed.
          const refreshListener = (() => {
            // HACK: If we check too quickly, the default action won't have
            // happened. We wait for an arbitrary amount of time that seems to
            // work, although this feels gross.
            const delay = 10; // milliseconds
            setTimeout(() => {
              this[raiseChangeEvents] = true;
              refreshSelectionState(this);
              this[raiseChangeEvents] = false;
            }, delay);
          }).bind(this);
          this.addEventListener("keydown", refreshListener);
          this.addEventListener("mousedown", refreshListener);
          this.addEventListener("touchend", refreshListener);
        }
      }
      [rendered](changed) {
        super[rendered](changed);

        // Setting value implies updating selection state as well.
        if (changed.value) {
          refreshSelectionState(this);
        }
      }
    }
    return TrackTextSelection;
  }

  // Refresh our selection state values from the inner component's current
  // selection properties.
  function refreshSelectionState(element) {
    const inner = element.inner;
    const {
      selectionEnd,
      selectionStart
    } = inner;
    element[setState]({
      selectionEnd,
      selectionStart
    });
  }

  /**
   * Delegates a component's focus to its first focusable shadow element.
   *
   * This mixin serves as a polyfill for the standard `delegatesFocus` shadow root
   * property. As of June 2020, that property is still only natively supported in
   * Chrome. The Chrome delegatesFocus implementation has some subtle issues;
   * until additional implementations are available, it's hard to know whether the
   * issues are with the definition of delegatesFocus, with Chrome's
   * implementation, or with Elix component code. Accordingly, for the time being
   * this polyfill is used even on Chrome.
   *
   * @module DelegateFocusMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function DelegateFocusMixin(Base) {
    // The class prototype added by the mixin.
    class DelegateFocus extends Base {
      /**
       * Returns true if the component is delegating its focus.
       *
       * A component using `DelegateFocusMixin` will always have this property be
       * true unless a class takes measures to override it.
       *
       * @type {boolean}
       * @default true
       */
      get [delegatesFocus]() {
        return true;
      }

      /**
       * If someone tries to put the focus on us, delegate the focus to the first
       * focusable element in the composed tree below our shadow root.
       *
       * @ignore
       * @param {FocusOptions=} focusOptions
       */
      focus(focusOptions) {
        // On browsers that support delegatesFocus natively, we should just be
        // able to let the browser handle the focus method. However, we hit a bug
        // in June 2020 where the native focus method in Chrome did not always
        // produce the expected results if delegatesFocus is set.
        //
        // Specific bug: a PopupButton would like to delegates focus to its source
        // button. Tabbing to a PopupButton focused on the source button as
        // expected. Moreover, programmatically setting focus on the button also
        // worked. However, when a PopupButton's popup was closed with the Escape
        // key, OverlayMixin attemped to set programmatically focus to the
        // PopupButton. This did *not* work as expecte, and focus ended up on the
        // body. Until we have a second native implementation to compare against,
        // it's difficult to determine whether this is a bug in the definition of
        // delegatesFocus, Chrome's implementation, or our code.

        // /** @type {any} */ const cast = this[shadowRoot];
        // if (cast.delegatesFocus) {
        //   // Native support for delegatesFocus, so don't need to do anything.
        //   super.focus(focusOptions);
        //   return;
        // }
        const focusElement = this[focusTarget];
        if (focusElement) {
          focusElement.focus(focusOptions);
        }
      }
      get [focusTarget]() {
        // HACK: The commented-out code lets us rely on the browser to indicate
        // which element should be focused on in browsers that don't support
        // native delegatesFocus. However, this code creates subtle focus problems
        // in components like AutoCompleteListBox: if the user clicks the toggle
        // button, the focus won't be placed on the top-level AutoCompleteComboBox
        // as expected; that element will be returned as the focus target, but if
        // it doesn't have a non-negative tabindex, forwardFocus won't think it's
        // focusable. A more correct solution would be for all components that are
        // focusable to give themselves a tabIndex of 0 by default or define a new
        // public `focusable` that components could use to indicate that they're
        // focusable. Until we have time to fully explore that, we workaround the
        // bug by providing the polyfill behavior even in browsers that have
        // delegatesFocus.

        // /** @type {any} */ const cast = this[shadowRoot];
        // return cast.delegatesFocus
        //   ? this
        //   : firstFocusableElement(this[shadowRoot]);
        return firstFocusableElement(this[shadowRoot]);
      }
    }
    return DelegateFocus;
  }

  const extendsKey = Symbol("extends");
  const delegatedPropertySettersKey = Symbol("delegatedPropertySetters");

  /* True if a standard element is focusable by default. */
  /** @type {IndexedObject<boolean>} */
  const focusableByDefault = {
    a: true,
    area: true,
    button: true,
    details: true,
    iframe: true,
    input: true,
    select: true,
    textarea: true
  };

  /*
   * A set of events which, if fired by the inner standard element, should be
   * re-raised by the custom element.
   *
   * These are events which are spec'ed to NOT get retargetted across a Shadow DOM
   * boundary, organized by which element(s) raise the events. To properly
   * simulate these, we will need to listen for the real events, then re-raise a
   * simulation of the original event. For more information, see
   * https://www.w3.org/TR/shadow-dom/#h-events-that-are-not-leaked-into-ancestor-trees.
   *
   * It appears that we do *not* need to re-raise the non-bubbling "focus" and
   * "blur" events. These appear to be automatically re-raised as expected -- but
   * it's not clear why that happens.
   *
   * The list below is reasonably complete. It omits elements that cannot be
   * wrapped (see class notes above). Also, we haven't actually tried wrapping
   * every element in this list; some of the more obscure ones might not actually
   * work as expected, but it was easier to include them for completeness than
   * to actually verify whether or not the element can be wrapped.
   */
  /** @type {IndexedObject<string[]>} */
  const reraiseEvents = {
    address: ["scroll"],
    blockquote: ["scroll"],
    caption: ["scroll"],
    center: ["scroll"],
    dd: ["scroll"],
    dir: ["scroll"],
    div: ["scroll"],
    dl: ["scroll"],
    dt: ["scroll"],
    fieldset: ["scroll"],
    form: ["reset", "scroll"],
    frame: ["load"],
    h1: ["scroll"],
    h2: ["scroll"],
    h3: ["scroll"],
    h4: ["scroll"],
    h5: ["scroll"],
    h6: ["scroll"],
    iframe: ["load"],
    img: ["abort", "error", "load"],
    input: ["abort", "change", "error", "select", "load"],
    li: ["scroll"],
    link: ["load"],
    menu: ["scroll"],
    object: ["error", "scroll"],
    ol: ["scroll"],
    p: ["scroll"],
    script: ["error", "load"],
    select: ["change", "scroll"],
    tbody: ["scroll"],
    tfoot: ["scroll"],
    thead: ["scroll"],
    textarea: ["change", "select", "scroll"]
  };

  /*
   * Mouse events that should be disabled if the inner component is disabled.
   */
  const mouseEventNames = ["click", "dblclick", "mousedown", "mouseenter", "mouseleave", "mousemove", "mouseout", "mouseover", "mouseup", "wheel"];

  // Keep track of which re-raised events should bubble.
  /** @type {IndexedObject<boolean>} */
  const eventBubbles = {
    abort: true,
    change: true,
    reset: true
  };

  // Elements which are display: block by default.
  // Source: https://developer.mozilla.org/en-US/docs/Web/HTML/Block-level_elements
  const blockElements = ["address", "article", "aside", "blockquote", "canvas", "dd", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "main", "nav", "noscript", "ol", "output", "p", "pre", "section", "table", "tfoot", "ul", "video"];

  // Standard attributes that don't have corresponding properties.
  // These need to be delegated from the wrapper to the inner element.
  const attributesWithoutProperties = ["accept-charset", "autoplay", "buffered", "challenge", "codebase", "colspan", "contenteditable", "controls", "crossorigin", "datetime", "dirname", "for", "formaction", "http-equiv", "icon", "ismap", "itemprop", "keytype", "language", "loop", "manifest", "maxlength", "minlength", "muted", "novalidate", "preload", "radiogroup", "readonly", "referrerpolicy", "rowspan", "scoped", "usemap"];
  const Base$c = DelegateFocusMixin(ReactiveElement);

  /**
   * Wraps a standard HTML element so it can be extended
   *
   * The typical way to use this class is via its static `wrap` method.
   *
   * @inherits ReactiveElement
   * @mixes DelegateFocusMixin
   * @part inner - the inner standard HTML element
   */
  class WrappedStandardElement extends Base$c {
    constructor() {
      super();
      /** @type {any} */
      const cast = this;
      if (!this[nativeInternals] && cast.attachInternals) {
        this[nativeInternals] = cast.attachInternals();
      }
    }

    /**
     *
     * Wrapped standard elements need to forward some attributes to the inner
     * element in cases where the attribute does not have a corresponding
     * property. These attributes include those prefixed with "aria-", and some
     * unusual standard attributes like contenteditable. To handle those, this
     * class defines its own attributeChangedCallback.
     *
     * @ignore
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     */
    attributeChangedCallback(name, oldValue, newValue) {
      const forwardAttribute = attributesWithoutProperties.indexOf(name) >= 0;
      if (forwardAttribute) {
        const innerAttributes = Object.assign({}, this[state].innerAttributes, {
          [name]: newValue
        });
        this[setState]({
          innerAttributes
        });
      } else {
        // Rely on the base attributeChangedCallback provided by
        // AttributeMarshallingMixin.
        super.attributeChangedCallback(name, oldValue, newValue);
      }
    }

    // Delegate method defined by HTMLElement.
    blur() {
      this.inner.blur();
    }

    // One HTMLElement we *don't* delegate is `click`. Generally speaking, a click
    // on the outer wrapper should behave the same as a click on the inner
    // element. Also, we want to ensure outside event listeners get a click event
    // when the click method is invoked. But a click on the inner element will
    // raise a click event that won't be re-raised by default across the shadow
    // boundary. The precise behavior seems to be slightly different in Safari
    // than other browsers, but it seems safer to not delegate click.
    //
    // click() {}

    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        innerAttributes: {}
      });
    }
    get [defaultTabIndex]() {
      return focusableByDefault[this.extends] ? 0 : -1;
    }

    /**
     * The tag name of the standard HTML element extended by this class.
     *
     * @returns {string}
     */
    get extends() {
      return this.constructor[extendsKey];
    }

    /**
     * Returns a reference to the inner standard HTML element.
     *
     * @type {HTMLElement}
     */
    get inner() {
      /** @type {any} */
      const result = this[ids] && this[ids].inner;
      if (!result) {
        /* eslint-disable no-console */
        console.warn("Attempted to get an inner standard element before it was instantiated.");
      }
      return result;
    }
    static get observedAttributes() {
      // For our custom attributeChangedCallback to work, we need to observe
      // the attributes we want to forward.
      // @ts-ignore
      return [...super.observedAttributes, ...attributesWithoutProperties];
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      const inner = this.inner;
      if (this[firstRender]) {
        // Listen for any events raised by the inner element which will not
        // automatically be retargetted across the Shadow DOM boundary, and
        // re-raise those events when they happen.
        const eventNames = reraiseEvents[this.extends] || [];
        eventNames.forEach(eventName => {
          inner.addEventListener(eventName, () => {
            const event = new Event(eventName, {
              bubbles: eventBubbles[eventName] || false
            });
            this.dispatchEvent(event);
          });
        });

        // If inner element can be disabled, then listen to mouse events on the
        // *outer* element and absorb them if the inner element is disabled.
        // Without this, a mouse event like a click on the inner disabled element
        // would be treated as a click on the outer element. Someone listening to
        // clicks on the outer element would get a click event, even though the
        // overall element is supposed to be disabled.
        if ("disabled" in inner) {
          mouseEventNames.forEach(eventName => {
            this.addEventListener(eventName, event => {
              if ( /** @type {any} */inner.disabled) {
                event.stopImmediatePropagation();
              }
            });
          });
        }
      }
      if (changed.tabIndex) {
        inner.tabIndex = this[state].tabIndex;
      }
      if (changed.innerAttributes) {
        // Forward attributes to the inner element.
        // See notes at attributeChangedCallback.
        const {
          innerAttributes
        } = this[state];
        for (const name in innerAttributes) {
          applyAttribute(inner, name, innerAttributes[name]);
        }
      }

      // Forward delegated properties to the inner element.
      this.constructor[delegatedPropertySettersKey].forEach(property => {
        if (changed[property]) {
          const value = this[state][property];

          // Inner selection properties needed to be handled specially.
          // See TrackTextSelectionMixin.
          const specialCase = (property === "selectionEnd" || property === "selectionStart") && value === null;
          if (!specialCase) {
            inner[property] = value;
          }
        }
      });
    }
    [rendered]( /** @type {ChangedFlags} */changed) {
      super[rendered](changed);

      // Apply disabled state.
      if (changed.disabled) {
        const {
          disabled
        } = this[state];
        if (disabled !== undefined) {
          setInternalState$2(this, "disabled", disabled);
        }
      }
    }

    /**
     * The template copied into the shadow tree of new instances of this element.
     *
     * The default value of this property is a template that includes an instance
     * the standard element being wrapped, with a `<slot>` element inside that
     * to pick up the element's light DOM content. For example, if you wrap an
     * `<a>` element, then the default template will look like:
     *
     *     <template>
     *       <style>
     *       :host {
     *         display: inline-block;
     *       }
     *       </style>
     *       <a id="inner">
     *         <slot></slot>
     *       </a>
     *     </template>
     *
     * The `display` styling applied to the host will be `block` for elements that
     * are block elements by default, and `inline-block` (not `inline`) for other
     * elements.
     *
     * If you'd like the template to include other elements, then override this
     * property and return a template of your own. The template should include an
     * instance of the standard HTML element you are wrapping, and the ID of that
     * element should be "inner".
     *
     * @type {(string|HTMLTemplateElement)}
     */
    get [template$g]() {
      const display = blockElements.includes(this.extends) ? "block" : "inline-block";
      const tag = this.extends;
      return templateFrom.html`
      <style>
        :host {
          display: ${display}
        }
        
        [part~="inner"] {
          box-sizing: border-box;
          height: 100%;
          width: 100%;
        }
      </style>
      <${tag} id="inner" part="inner ${tag}">
        <slot></slot>
      </${tag}>
    `;
    }

    /**
     * Creates a class that wraps a standard HTML element.
     *
     * Note that the resulting class is a subclass of WrappedStandardElement, not
     * the standard class being wrapped. E.g., if you call
     * `WrappedStandardElement.wrap('a')`, you will get a class whose shadow tree
     * will include an anchor element, but the class will *not* inherit from
     * HTMLAnchorElement.
     *
     * @static
     * @param {string} extendsTag - the standard HTML element tag to extend
     */
    static wrap(extendsTag) {
      // Create the new class.
      /** @type {Constructor<WrappedStandardElement>} */
      class Wrapped extends WrappedStandardElement {}

      // Indicate which tag it wraps.
      /** @type {any} */
      Wrapped[extendsKey] = extendsTag;

      // Create getter/setters that delegate to the wrapped element.
      const element = document.createElement(extendsTag);
      defineDelegates(Wrapped, Object.getPrototypeOf(element));
      return Wrapped;
    }
  }

  /**
   * Update the given attribute on an element.
   *
   * Passing a non-null `value` acts like a call to `setAttribute(name, value)`.
   * If the supplied `value` is nullish, this acts like a call to
   * `removeAttribute(name)`.
   *
   * @private
   * @param {HTMLElement} element
   * @param {string} name
   * @param {string} value
   */
  function applyAttribute(element, name, value) {
    if (standardBooleanAttributes[name]) {
      // Boolean attribute
      if (typeof value === "string") {
        element.setAttribute(name, "");
      } else if (value === null) {
        element.removeAttribute(name);
      }
    } else {
      // Regular string-valued attribute
      if (value != null) {
        element.setAttribute(name, value.toString());
      } else {
        element.removeAttribute(name);
      }
    }
  }

  /**
   * Create a delegate for the method or property identified by the descriptor.
   *
   * @private
   * @param {string} name
   * @param {PropertyDescriptor} descriptor
   */
  function createDelegate(name, descriptor) {
    if (typeof descriptor.value === "function") {
      if (name !== "constructor") {
        return createMethodDelegate(name, descriptor);
      }
    } else if (typeof descriptor.get === "function" || typeof descriptor.set === "function") {
      return createPropertyDelegate(name, descriptor);
    }
    return null;
  }

  /**
   * Create a delegate for the method identified by the descriptor.
   *
   * @private
   * @param {string} name
   * @param {PropertyDescriptor} descriptor
   */
  function createMethodDelegate(name, descriptor) {
    const value = function () {
      // @ts-ignore
      this.inner[name](...arguments);
    };
    const delegate = {
      configurable: descriptor.configurable,
      enumerable: descriptor.enumerable,
      value,
      writable: descriptor.writable
    };
    return delegate;
  }

  /**
   * Create a delegate for the property identified by the descriptor.
   *
   * @private
   * @param {string} name
   * @param {PropertyDescriptor} descriptor
   */
  function createPropertyDelegate(name, descriptor) {
    /** @type {PlainObject} */
    const delegate = {
      configurable: descriptor.configurable,
      enumerable: descriptor.enumerable
    };
    if (descriptor.get) {
      delegate.get = function () {
        return getInnerProperty( /** @type {any} */this, name);
      };
    }
    if (descriptor.set) {
      delegate.set = function ( /** @type {any} */value) {
        setInnerProperty( /** @type {any} */this, name, value);
      };
    }
    if (descriptor.writable) {
      delegate.writable = descriptor.writable;
    }
    return delegate;
  }

  /**
   * Define delegates for the given class for each property/method on the
   * indicated prototype.
   *
   * @private
   * @param {Constructor<Object>} cls
   * @param {Object} prototype
   */
  function defineDelegates(cls, prototype) {
    const names = Object.getOwnPropertyNames(prototype);
    cls[delegatedPropertySettersKey] = [];
    names.forEach(name => {
      const descriptor = Object.getOwnPropertyDescriptor(prototype, name);
      if (!descriptor) {
        return;
      }
      const delegate = createDelegate(name, descriptor);
      if (delegate) {
        Object.defineProperty(cls.prototype, name, delegate);
        if (delegate.set) {
          cls[delegatedPropertySettersKey].push(name);
        }
      }
    });
  }

  /**
   * Return the value of the named property on the inner standard element.
   *
   * @private
   * @param {ReactiveElement} element
   * @param {string} name
   */
  function getInnerProperty(element, name) {
    // If we haven't rendered yet, use internal state value. Once we've
    // rendered, we get the value from the wrapped element itself. Return our
    // concept of the current property value from state. If the property hasn't
    // been defined, however, get the current value of the property from the
    // inner element.
    //
    // This is intended to support cases like an anchor element. If someone sets
    // `href` on a wrapped anchor, we'll know the value of `href` from state,
    // but we won't know the value of href-dependent calculated properties like
    // `protocol`. Using two sources of truth (state and the inner element)
    // seems fragile, but it's unclear how else to handle this without
    // reimplementing all HTML property interactions ourselves.
    //
    // This arrangement also means that, if an inner element property can change
    // in response to user interaction (e.g., an input element's value changes
    // as the user types), the component must listen to suitable events on the
    // inner element and update its state accordingly.
    const value = element[state][name];
    return value || element[shadowRoot] && element.inner[name];
  }

  /**
   * Set the named property on the inner standard element.
   *
   * @private
   * @param {ReactiveElement} element
   * @param {string} name
   * @param {any} value
   */
  function setInnerProperty(element, name, value) {
    // We normally don't check an existing state value before calling[setState],
    // relying instead on[setState] to do that check for us. However, we have
    // dangers in this particular component of creating infinite loops.
    //
    // E.g., setting the tabindex attibute will call attributeChangedCallback,
    // which will set the tabIndex property, which will want to set state, which
    // will cause a render, which will try to reflect the current value of the
    // tabIndex property to the tabindex attribute, causing a loop.
    //
    // To avoid this, we check the existing value before updating our state.
    if (element[state][name] !== value) {
      element[setState]({
        [name]: value
      });
    }
  }

  const Base$b = DelegateInputLabelMixin(FocusVisibleMixin(FormElementMixin(TrackTextSelectionMixin(WrappedStandardElement.wrap("input")))));

  /**
   * Base class for custom input elements
   *
   * `Input` wraps a standard HTML `input` element, allowing for custom styling
   * and behavior while ensuring standard keyboard and focus behavior.
   *
   * @inherits WrappedStandardElement
   * @mixes DelegateInputLabelMixin
   * @mixes FocusVisibleMixin
   * @mixes FormElementMixin
   * @mixes TrackTextSelectionMixin
   * @part input - the inner standard HTML input
   */
  class Input extends Base$b {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        value: ""
      });
    }
    get [inputDelegate]() {
      return this.inner;
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      if (this[firstRender]) {
        // The following jsDoc comment doesn't directly apply to the statement which
        // follows, but is placed there because the comment has to go somewhere to
        // be visible to jsDoc, and the statement is at tangentially related.
        /**
         * Raised when the user changes the element's text content.
         *
         * This is the standard `input` event; the component does not do any work to
         * raise it. It is documented here to let people know it is available to
         * detect when the user edits the content.
         *
         * @event input
         */
        this[ids].inner.addEventListener("input", () => {
          this[raiseChangeEvents] = true;
          /** @type {any} */
          const inner = this[ids].inner;
          this[setState]({
            value: inner.value
          });
          this[raiseChangeEvents] = false;
        });
      }
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
      <style>
        [part~="input"] {
          font: inherit;
          outline: none;
          text-align: inherit;
        }
      </style>
    `);
      return result;
    }
    get value() {
      return this[state].value;
    }
    set value(value) {
      this[setState]({
        value: String(value)
      });
    }
  }

  /**
   * Input styles in the Plain reference design system
   *
   * @module PlainInputMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function PlainInputMixin(Base) {
    return class PlainInput extends Base {
      get [template$g]() {
        const result = super[template$g];
        result.content.append(fragmentFrom.html`
        <style>
          :host {
            background: white;
            border: 1px solid gray;
            box-sizing: border-box;
          }

          [part~="input"] {
            background: transparent;
            border-color: transparent;
          }
        </style>
      `);
        return result;
      }
    };
  }

  /**
   * ListBox component in the Plain reference design system
   *
   * @inherits Input
   * @mixes PlainInputMixin
   */
  class PlainInput extends PlainInputMixin(Input) {}

  class ElixInput extends PlainInput {}
  customElements.define("elix-input", ElixInput);

  const template$f = document.createElement('template');
  template$f.innerHTML = `
  <style>
  div {
    height: 24px;
    margin: 5px 1px;
    padding: 3px;
  }
  img {
    top: 2px;
    left: 4px;
    position: relative;
  }
  span {
    bottom: 1px;
    right: -4px;
    position: relative;
    margin-right: 4px;
    color: #fff;
  }
  elix-input {
    background-color: var(--input-color);
    border-radius: 3px;
    height: 24px;
  }
  </style>
  <div>
  <img alt="icon" width="12" height="12" />
  <span id="label">label</span>
  <elix-input></elix-input>
  </div>
`;

  /**
   * @class SEInput
   */
  class SEInput extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$f.content.cloneNode(true));
      // locate the component
      this.$div = this._shadowRoot.querySelector('div');
      this.$img = this._shadowRoot.querySelector('img');
      this.$label = this.shadowRoot.getElementById('label');
      this.$event = new CustomEvent('change');
      this.$input = this._shadowRoot.querySelector('elix-input');
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['value', 'label', 'src', 'size', 'title'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          this.$div.setAttribute('title', `${t$1(newValue)}`);
          break;
        case 'src':
          this.$img.setAttribute('src', newValue);
          this.$label.remove();
          break;
        case 'size':
          this.$input.setAttribute('size', newValue);
          break;
        case 'label':
          this.$label.textContent = t$1(newValue);
          this.$img.remove();
          break;
        case 'value':
          this.$input.value = newValue;
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get label() {
      return this.getAttribute('label');
    }

    /**
     * @function set
     * @returns {void}
     */
    set label(value) {
      this.setAttribute('label', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get value() {
      return this.$input.value;
    }

    /**
     * @function set
     * @returns {void}
     */
    set value(value) {
      this.$input.value = value;
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get size() {
      return this.getAttribute('size');
    }

    /**
     * @function set
     * @returns {void}
     */
    set size(value) {
      this.setAttribute('size', value);
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      this.$input.addEventListener('change', e => {
        e.preventDefault();
        this.value = e.target.value;
        this.dispatchEvent(this.$event);
      });
      this.$input.addEventListener('keyup', e => {
        e.preventDefault();
        this.value = e.target.value;
        this.dispatchEvent(this.$event);
      });
    }
  }
  // Register
  customElements.define('se-input', SEInput);

  // Quick detection of whether we'll need to handle focus.
  // As of February 2019, we don't need to handle this in Chrome, perhaps because
  // they already support delegatesFocus (which handles related focus issues).
  const focusTest = document.createElement("div");
  focusTest.attachShadow({
    mode: "open",
    delegatesFocus: true
  });
  /** @type {any} */
  const focusTestShadowRoot = focusTest.shadowRoot;
  const nativeDelegatesFocus = focusTestShadowRoot.delegatesFocus;

  /**
   * Normalizes focus treatment for custom elements with Shadow DOM
   *
   * This mixin exists because the default behavior for mousedown should set the
   * focus to the closest ancestor of the clicked element that can take the focus.
   * As of Nov 2018, Chrome and Safari don't handle this as expected when the
   * clicked element is reassigned across more than one slot to end up inside a
   * focusable element. In such cases, the focus will end up on the body. Firefox
   * exhibits the behavior we want. See
   * https://github.com/w3c/webcomponents/issues/773.
   *
   * This mixin normalizes behavior to provide what Firefox does. When the user
   * mouses down inside anywhere inside the component's light DOM or Shadow DOM,
   * we walk up the composed tree to find the first element that can take the
   * focus and put the focus on it.
   *
   * @module ComposedFocusMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function ComposedFocusMixin(Base) {
    // The class prototype added by the mixin.
    class ComposedFocus extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          composeFocus: !nativeDelegatesFocus
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          this.addEventListener("mousedown", event => {
            if (!this[state].composeFocus) {
              return;
            }
            // Only process events for the main (usually left) button.
            if (event.button !== 0) {
              return;
            }
            if (event.target instanceof Element) {
              const target = closestFocusableNode(event.target);
              if (target) {
                target.focus();
                event.preventDefault();
              }
            }
          });
        }
      }
    }
    return ComposedFocus;
  }

  const Base$a = ComposedFocusMixin(DelegateInputLabelMixin(FocusVisibleMixin(WrappedStandardElement.wrap("button"))));

  /**
   * Base class for custom buttons.
   *
   * `Button` wraps a standard HTML `button` element, allowing for custom styling
   * and behavior while ensuring standard keyboard and focus behavior.
   *
   * @inherits WrappedStandardElement
   * @mixes ComposedFocusMixin
   * @mixes DelegateInputLabelMixin
   * @mixes KeyboardMixin
   * @part button - the inner standard HTML button
   */
  class Button extends Base$a {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        role: "button"
      });
    }
    get [inputDelegate]() {
      return this[ids].inner;
    }

    // Respond to a simulated click.
    [tap]() {
      const clickEvent = new MouseEvent("click", {
        bubbles: true,
        cancelable: true
      });
      this.dispatchEvent(clickEvent);
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          :host {
            display: inline-flex;
            outline: none;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
          }

          [part~="button"] {
            align-items: center;
            background: none;
            border: none;
            color: inherit;
            flex: 1;
            font: inherit;
            outline: none;
            padding: 0;
          }
        </style>
      `);
      return result;
    }
  }

  // Used to distinguish our synthetic events from a real one.
  class SyntheticMouseEvent extends MouseEvent {}

  /**
   * Generates mousedown events at intervals for as long as the mouse is down
   *
   * This is useful for buttons or other elements that should perform an
   * action repeatedly if the user holds down the mouse.
   *
   * @module RepeatMousedownMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function RepeatMousedownMixin(Base) {
    return class RepeatMousedown extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          repeatDelayDuration: 500,
          // In ms. Wait a bit before starting repeats.
          repeatInterval: null,
          repeatIntervalDuration: 50,
          // In ms. Once repeats start, they go fast.
          repeatTimeout: null
        });
      }
      [render](changed) {
        if (super[render]) {
          super[render](changed);
        }

        // Wire up event handlers.
        if (this[firstRender]) {
          // Only listen to mouse events with the primary (usually left) button.
          this.addEventListener("mousedown", event => {
            if (!(event instanceof SyntheticMouseEvent) && event.button === 0) {
              this[raiseChangeEvents] = true;
              repeatStart(this);
              this[raiseChangeEvents] = false;
            }
          });
          this.addEventListener("mouseup", event => {
            if (event.button === 0) {
              this[raiseChangeEvents] = true;
              repeatStop(this);
              this[raiseChangeEvents] = false;
            }
          });
          this.addEventListener("mouseleave", event => {
            if (event.button === 0) {
              this[raiseChangeEvents] = true;
              repeatStop(this);
              this[raiseChangeEvents] = false;
            }
          });

          // Treat touch events like mouse events.
          this.addEventListener("touchstart", () => {
            this[raiseChangeEvents] = true;
            repeatStart(this);
            this[raiseChangeEvents] = false;
          });
          this.addEventListener("touchend", () => {
            this[raiseChangeEvents] = true;
            repeatStop(this);
            this[raiseChangeEvents] = false;
          });
        }
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};
        if (changed.disabled) {
          if (state.disabled) {
            clearRepeat(this);
            Object.assign(effects, {
              repeatInterval: null,
              repeatTimeout: null
            });
          }
        }
        return effects;
      }
    };
  }
  function clearRepeat(element) {
    if (element[state].repeatTimeout) {
      clearTimeout(element[state].repeatTimeout);
    }
    if (element[state].repeatInterval) {
      clearInterval(element[state].repeatInterval);
    }
  }
  function repeatStart(element) {
    // Start initial wait.
    const {
      repeatIntervalDuration,
      repeatDelayDuration
    } = element[state];
    const repeatTimeout = setTimeout(() => {
      // Initial wait complete; start repeat interval.
      const repeatInterval = setInterval(() => {
        // Repeat interval passed; raise a mousedown event.
        raiseMousedown(element);
      }, repeatIntervalDuration);
      element[setState]({
        repeatInterval
      });
    }, repeatDelayDuration - repeatIntervalDuration);
    element[setState]({
      repeatTimeout
    });
  }

  // Stop timeout and/or interval in progress.
  function repeatStop(element) {
    clearRepeat(element);
    element[setState]({
      repeatTimeout: null,
      repeatInterval: null
    });
  }

  // Raise a synthetic mousedown event.
  function raiseMousedown(element) {
    const event = new SyntheticMouseEvent("mousedown", {
      bubbles: true,
      button: 0,
      cancelable: true,
      clientX: 0,
      clientY: 0
    });
    element.dispatchEvent(event);
  }

  /**
   * A button that raises mousedown events as long as the mouse is down
   *
   * @inherits Button
   * @mixes RepeatMousedownMixin
   */
  class RepeatButton extends RepeatMousedownMixin(Button) {}

  /**
   * Button styles in the Plain reference design system
   *
   * @module PlainButtonMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function PlainButtonMixin(Base) {
    return class PlainButton extends Base {
      get [template$g]() {
        const result = super[template$g];
        result.content.append(fragmentFrom.html`
        <style>
          :host([disabled]) ::slotted(*) {
            opacity: 0.5;
          }

          [part~="button"] {
            display: inline-flex;
            justify-content: center;
            margin: 0;
            position: relative;
          }
        </style>
      `);
        return result;
      }
    };
  }

  /**
   * Button component in the Plain reference design system
   *
   * @inherits RepeatButton
   * @mixes PlainButtonMixin
   */
  class PlainRepeatButton extends PlainButtonMixin(RepeatButton) {}

  /**
   * SpinBox design in the Plain reference design system
   *
   * @module PlainSpinBoxMixin
   * @param {Constructor<ReactiveElement>} Base
   * @part {PlainRepeatButton} button
   * @part {PlainInput} input
   */
  function PlainSpinBoxMixin(Base) {
    return class PlainSpinBox extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          buttonPartType: PlainRepeatButton,
          inputPartType: PlainInput
        });
      }
      get [template$g]() {
        const result = super[template$g];
        const upButton = result.content.getElementById("upButton");
        upButton.textContent = "▲";
        const downButton = result.content.getElementById("downButton");
        downButton.textContent = "▼";
        result.content.append(fragmentFrom.html`
        <style>
          :host {
            background: white;
            border: 1px solid gray;
            box-sizing: border-box;
          }

          [part~="input"] {
            background: transparent;
            border: none;
            width: 4em;
          }

          [part~="spin-button"] {
            background: transparent;
            border: 1px solid gray;
            box-sizing: border-box;
            font-size: 0.6em;
            padding: 2px;
          }

          [part~="up-button"] {
            border-right: none;
            border-top: none;
          }

          [part~="down-button"] {
            border-bottom: none;
            border-right: none;
            border-top: none;
          }
        </style>
      `);
        return result;
      }
    };
  }

  /**
   * Helpers for dynamically creating and patching component templates.
   *
   * The [ShadowTemplateMixin](ShadowTemplateMixin) lets you define a component
   * template that will be used to popuplate the shadow subtree of new component
   * instances. These helpers, especially the [html](#html) function, are intended
   * to simplify the creation of such templates.
   *
   * In particular, these helpers can be useful in [patching
   * templates](customizing#template-patching) inherited from a base class.
   *
   * Some of these functions take _descriptors_ that can either be a class, a tag
   * name, or an HTML template. These are generally used to fill specific roles in
   * an element's template; see [element roles](customizing#element-part-types).
   *
   * @module template
   */

  // Used by registerCustomElement.
  const mapBaseTagToCount = new Map();

  /**
   * Create an element from a role descriptor (a component class constructor or
   * an HTML tag name).
   *
   * If the descriptor is an HTML template, and the resulting document fragment
   * contains a single top-level node, that node is returned directly (instead of
   * the fragment).
   *
   * @param {PartDescriptor} descriptor - the descriptor that will be used to
   * create the element
   * @returns {Element} the new element
   */
  function createElement$2(descriptor) {
    if (typeof descriptor === "function") {
      // Instantiable component class constructor
      let element;
      try {
        element = new descriptor();
      } catch ( /** @type {any} */e) {
        if (e.name === "TypeError") {
          // Most likely this error results from the fact that the indicated
          // component class hasn't been registered. Register it now with a random
          // name and try again.
          registerCustomElement(descriptor);
          element = new descriptor();
        } else {
          // The exception was for some other reason.
          throw e;
        }
      }
      return element;
      // @ts-ignore
    } else {
      // String tag name: e.g., 'div'
      return document.createElement(descriptor);
    }
  }

  /**
   * Register the indicated constructor as a custom element class.
   *
   * This function generates a suitable string tag for the class. If the
   * constructor is a named function (which is typical for hand-authored code),
   * the function's `name` will be used as the base for the tag. If the
   * constructor is an anonymous function (which often happens in
   * generated/minified code), the tag base will be "custom-element".
   *
   * In either case, this function adds a uniquifying number to the end of the
   * base to produce a complete tag.
   *
   * @private
   * @param {Constructor<HTMLElement>} classFn
   */
  function registerCustomElement(classFn) {
    let baseTag;
    // HTML places more restrictions on the first character in a tag than
    // JavaScript places on the first character of a class name. We apply this
    // more restrictive condition to the class names we'll convert to tags. Class
    // names that fail this check -- often generated class names -- will result in
    // a base tag name of "custom-element".
    const classNameRegex = /^[A-Za-z][A-Za-z0-9_$]*$/;
    const classNameMatch = classFn.name && classFn.name.match(classNameRegex);
    if (classNameMatch) {
      // Given the class name `FooBar`, calculate the base tag name `foo-bar`.
      const className = classNameMatch[0];
      const uppercaseRegEx = /([A-Z])/g;
      const hyphenated = className.replace(uppercaseRegEx, (match, letter, offset) => offset > 0 ? `-${letter}` : letter);
      baseTag = hyphenated.toLowerCase();
    } else {
      baseTag = "custom-element";
    }
    // Add a uniquifying number to the end of the tag until we find a tag
    // that hasn't been registered yet.
    let count = mapBaseTagToCount.get(baseTag) || 0;
    let tag;
    for (;; count++) {
      tag = `${baseTag}-${count}`;
      if (!customElements.get(tag)) {
        // Not in use.
        break;
      }
    }
    // Register with the generated tag.
    customElements.define(tag, /** @type {any} */classFn);
    // Bump number and remember it. If we see the same base tag again later, we'll
    // start counting at that number in our search for a uniquifying number.
    mapBaseTagToCount.set(baseTag, count + 1);
  }

  /**
   * Replace an original node in a tree or document fragment with the indicated
   * replacement node. The attributes, classes, styles, and child nodes of the
   * original node will be moved to the replacement.
   *
   * @param {Node} original - an existing node to be replaced
   * @param {Node} replacement - the node to replace the existing node with
   * @returns {Node} the updated replacement node
   */
  function replace$3(original, replacement) {
    const parent = original.parentNode;
    if (!parent) {
      throw "An element must have a parent before it can be substituted.";
    }
    if ((original instanceof HTMLElement || original instanceof SVGElement) && (replacement instanceof HTMLElement || replacement instanceof SVGElement)) {
      // Merge attributes from original to replacement, letting replacement win
      // conflicts. Handle classes and styles separately (below).
      Array.prototype.forEach.call(original.attributes, ( /** @type {Attr} */attribute) => {
        if (!replacement.getAttribute(attribute.name) && attribute.name !== "class" && attribute.name !== "style") {
          replacement.setAttribute(attribute.name, attribute.value);
        }
      });
      // Copy classes/styles from original to replacement, letting replacement win
      // conflicts.
      Array.prototype.forEach.call(original.classList, ( /** @type {string} */className) => {
        replacement.classList.add(className);
      });
      Array.prototype.forEach.call(original.style, ( /** @type {number} */key) => {
        if (!replacement.style[key]) {
          replacement.style[key] = original.style[key];
        }
      });
    }
    // Copy over children.
    // @ts-ignore
    replacement.append(...original.childNodes);
    parent.replaceChild(replacement, original);
    return replacement;
  }

  /**
   * Replace a node with a new element, transferring all attributes, classes,
   * styles, and child nodes from the original(s) to the replacement(s).
   *
   * The descriptor used for the replacements can be a 1) component class
   * constructor, 2) an HTML tag name, or 3) an HTML template. For #1 and #2, if
   * the existing elements that match the selector are already of the desired
   * class/tag name, the replacement operation is skipped.
   *
   * @param {Element} original - the node to replace
   * @param {PartDescriptor} descriptor - the descriptor used to generate the
   * replacement element
   * @returns {Element} the replacement node(s)
   */
  function transmute(original, descriptor) {
    if (typeof descriptor === "function" && original.constructor === descriptor || typeof descriptor === "string" && original instanceof Element && original.localName === descriptor) {
      // Already correct type of element, no transmutation necessary.
      return original;
    } else {
      // Transmute the single node.
      const replacement = createElement$2(descriptor);
      replace$3(original, replacement);
      return replacement;
    }
  }

  /**
   * Delegates text selection methods and properties to an inner input-type element
   *
   * This mixin makes it easy for you to support the complete set standard DOM
   * APIs for selecting text by delegating those methods to an inner input-type
   * element.
   *
   * You can identify which inner input element selection should be delegated to
   * by defining an `internal.inputDelegate` property and returning the desired
   * inner input.
   *
   * @module DelegateInputSelectionMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function DelegateInputSelectionMixin(Base) {
    // The class prototype added by the mixin.
    class DelegateInputSelection extends Base {
      /**
       * Selects all the text.
       *
       * See the standard [select](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/select)
       * documentation for details.
       */
      select() {
        this[inputDelegate].select();
      }

      /**
       * The end index of the selected text.
       *
       * See the standard [input](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement)
       * element documentation for details.
       */
      get selectionEnd() {
        return this[inputDelegate].selectionEnd;
      }
      set selectionEnd(selectionEnd) {
        this[inputDelegate].selectionEnd = selectionEnd;
      }

      /**
       * The beginning index of the selected text.
       *
       * See the standard [input](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement)
       * element documentation for details.
       */
      get selectionStart() {
        return this[inputDelegate].selectionStart;
      }
      set selectionStart(selectionStart) {
        this[inputDelegate].selectionStart = selectionStart;
      }

      /**
       * Replaces a range of text.
       *
       * See the standard [setRangeText](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/setRangeText)
       * documentation for details.
       */
      setRangeText() {
        this[inputDelegate].setRangeText(...arguments);
      }

      /**
       * Sets the start and end positions of the current text selection.
       *
       * See the standard [setSelectionRange](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/setSelectionRange)
       * documentation for details.
       */
      setSelectionRange() {
        this[inputDelegate].setSelectionRange(...arguments);
        /** @type {HTMLInputElement} */
        const e = document.createElement("input");
        e.select;
      }
    }
    return DelegateInputSelection;
  }

  /**
   * Tracks the disabled state of a component that can be disabled
   *
   * @module DisabledMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function DisabledMixin(Base) {
    // The class prototype added by the mixin.
    class Disabled extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          disabled: false
        });
      }

      /**
       * True if the component is disabled, false (the default) if not.
       *
       * The value of this property will be reflected to the `disabled` attribute
       * so that it can be referenced in CSS. Note that this non-native
       * implementation of the `disabled` attribute will *not* trigger the
       * `:disabled` CSS pseudo-class, so your style rules will have to reference
       * the presence or absence of the `disabled` attribute. That is, instead
       * of writing
       *
       *     my-component:disabled { ... }
       *
       * write this instead
       *
       *     my-component[disabled] { ... }
       *
       * Like the native `disabled` attribute, this attribute is boolean. That
       * means that it's *existence* in markup sets the attribute, even if set to
       * an empty string or a string like "false".
       *
       * @type {boolean}
       * @default false
       */
      get disabled() {
        return this[state].disabled;
      }
      // AttributeMarshallingMixin should parse this as a boolean attribute for us.
      set disabled(disabled) {
        this[setState]({
          disabled
        });
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.disabled) {
          // Reflect value of disabled property to the corresponding attribute.
          this.toggleAttribute("disabled", this.disabled);
          if (this[raiseChangeEvents]) {
            /**
             * Raised when the `disabled` property changes.
             *
             * @event disabledchange
             */
            const event = new CustomEvent("disabledchange", {
              bubbles: true
            });
            this.dispatchEvent(event);
          }
        }
      }
    }
    return Disabled;
  }

  /**
   * Maps direction keys to direction semantics.
   *
   * This mixin is useful for components that want to map direction keys (Left,
   * Right, etc.) to movement in the indicated direction (go left, go right,
   * etc.).
   *
   * This mixin expects the component to invoke a `keydown` method when a key is
   * pressed. You can use [KeyboardMixin](KeyboardMixin) for that
   * purpose, or wire up your own keyboard handling and call `keydown` yourself.
   *
   * This mixin calls methods such as `goLeft` and `goRight`. You can define
   * what that means by implementing those methods yourself. If you want to use
   * direction keys to navigate a selection, use this mixin with
   * [DirectionCursorMixin](DirectionCursorMixin).
   *
   * If the component defines a property called `orientation`, the value of that
   * property will constrain navigation to the horizontal or vertical axis.
   *
   * @module KeyboardDirectionMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function KeyboardDirectionMixin(Base) {
    // The class prototype added by the mixin.
    class KeyboardDirection extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState], {
          handleBubblingDirectionKeys: false
        });
      }

      /**
       * Invoked when the user wants to go/navigate down.
       * The default implementation of this method does nothing.
       */
      [goDown]() {
        if (super[goDown]) {
          return super[goDown]();
        }
      }

      /**
       * Invoked when the user wants to go/navigate to the end (e.g., of a list).
       * The default implementation of this method does nothing.
       */
      [goEnd]() {
        if (super[goEnd]) {
          return super[goEnd]();
        }
      }

      /**
       * Invoked when the user wants to go/navigate left.
       * The default implementation of this method does nothing.
       */
      [goLeft]() {
        if (super[goLeft]) {
          return super[goLeft]();
        }
      }

      /**
       * Invoked when the user wants to go/navigate right.
       * The default implementation of this method does nothing.
       */
      [goRight]() {
        if (super[goRight]) {
          return super[goRight]();
        }
      }

      /**
       * Invoked when the user wants to go/navigate to the start (e.g., of a
       * list). The default implementation of this method does nothing.
       */
      [goStart]() {
        if (super[goStart]) {
          return super[goStart]();
        }
      }

      /**
       * Invoked when the user wants to go/navigate up.
       * The default implementation of this method does nothing.
       */
      [goUp]() {
        if (super[goUp]) {
          return super[goUp]();
        }
      }
      [keydown]( /** @type {KeyboardEvent} */event) {
        let handled = false;

        // Direction keys generally are low-priority keys: if a shadow element
        // like an input has focus, we want to let that focused element handle
        // direction keys. So we only handle the event if we're the target.
        //
        // (We'd really like to be able to provide direction key handling as a
        // default — i.e., if the focused element doesn't handle a key, then we
        // would handle it here. Unfortunately, there doesn't seem to be any
        // general way for us to do that.)
        if (this[state].handleBubblingDirectionKeys || event.target === this) {
          // Respect orientation state if defined, otherwise assume "both".
          const orientation = this[state].orientation || "both";
          const horizontal = orientation === "horizontal" || orientation === "both";
          const vertical = orientation === "vertical" || orientation === "both";

          // Ignore Left/Right keys when metaKey or altKey modifier is also pressed,
          // as the user may be trying to navigate back or forward in the browser.
          switch (event.key) {
            case "ArrowDown":
              if (vertical) {
                handled = event.altKey ? this[goEnd]() : this[goDown]();
              }
              break;
            case "ArrowLeft":
              if (horizontal && !event.metaKey && !event.altKey) {
                handled = this[goLeft]();
              }
              break;
            case "ArrowRight":
              if (horizontal && !event.metaKey && !event.altKey) {
                handled = this[goRight]();
              }
              break;
            case "ArrowUp":
              if (vertical) {
                handled = event.altKey ? this[goStart]() : this[goUp]();
              }
              break;
            case "End":
              handled = this[goEnd]();
              break;
            case "Home":
              handled = this[goStart]();
              break;
          }
        }

        // Prefer mixin result if it's defined, otherwise use base result.
        return handled || super[keydown] && super[keydown](event) || false;
      }
    }
    return KeyboardDirection;
  }

  /**
   * Manages keyboard handling for a component.
   *
   * This mixin handles several keyboard-related features.
   *
   * First, it wires up a single keydown event handler that can be shared by
   * multiple mixins on a component. The event handler will invoke a `keydown`
   * method with the event object, and any mixin along the prototype chain that
   * wants to handle that method can do so.
   *
   * If a mixin wants to indicate that keyboard event has been handled, and that
   * other mixins should *not* handle it, the mixin's `keydown` handler should
   * return a value of true. The convention that seems to work well is that a
   * mixin should see if it wants to handle the event and, if not, then ask the
   * superclass to see if it wants to handle the event. This has the effect of
   * giving the mixin that was applied last the first chance at handling a
   * keyboard event.
   *
   * Example:
   *
   *     [keydown](event) {
   *       let handled;
   *       switch (event.key) {
   *         // Handle the keys you want, setting handled = true if appropriate.
   *       }
   *       // Prefer mixin result if it's defined, otherwise use base result.
   *       return handled || (super[keydown] && super[keydown](event));
   *     }
   *
   * A second feature provided by this mixin is that it implicitly makes the
   * component a tab stop if it isn't already, by setting `tabindex` to 0. This
   * has the effect of adding the component to the tab order in document order.
   *
   * @module KeyboardMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function KeyboardMixin(Base) {
    // The class prototype added by the mixin.
    class Keyboard extends Base {
      constructor() {
        // @ts-ignore
        super();
        this.addEventListener("keydown", async event => {
          this[raiseChangeEvents] = true;
          // For use with FocusVisibleMixin.
          if (!this[state].focusVisible) {
            // The user may have begun interacting with this element using the
            // mouse/touch, but has now begun using the keyboard, so show focus.
            this[setState]({
              focusVisible: true
            });
          }
          const handled = this[keydown](event);
          if (handled) {
            event.preventDefault();
            event.stopImmediatePropagation();
          }
          await Promise.resolve();
          this[raiseChangeEvents] = false;
        });
      }
      attributeChangedCallback(name, oldValue, newValue) {
        if (name === "tabindex") {
          // Parse the passed value, which could be a string or null.
          let parsed;
          if (newValue === null) {
            // tabindex attribute was removed.
            parsed = -1;
          } else {
            parsed = Number(newValue);
            if (isNaN(parsed)) {
              // Non-numeric tabindex falls back to default value (if defined).
              parsed = this[defaultTabIndex] ? this[defaultTabIndex] : 0;
            }
          }
          this.tabIndex = parsed;
        } else {
          super.attributeChangedCallback(name, oldValue, newValue);
        }
      }

      // @ts-ignore
      get [defaultState]() {
        // If we're using DelegateFocusMixin, we don't need or want to set a
        // tabindex on the host; we'll rely on the inner shadow elements to take
        // the focus and raise keyboard events. Otherwise, we do set a tabindex on
        // the host, so that we can get keyboard events.
        const tabIndex = this[delegatesFocus] ? -1 : 0;
        const state = Object.assign(super[defaultState] || {}, {
          tabIndex
        });
        return state;
      }

      /**
       * See the [symbols](internal#internal.keydown) documentation for details.
       */
      [keydown]( /** @type {KeyboardEvent} */event) {
        if (super[keydown]) {
          return super[keydown](event);
        }
        return false;
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (changed.tabIndex) {
          this.tabIndex = this[state].tabIndex;
        }
      }

      // Record our own notion of the state of the tabIndex property so we can
      // rerender if necessary.
      get tabIndex() {
        return super.tabIndex;
      }
      set tabIndex(tabIndex) {
        // If value has changed, invoke the super setter.
        if (super.tabIndex !== tabIndex) {
          super.tabIndex = tabIndex;
        }

        // The tabIndex setter can get called during rendering when we render our
        // own notion of the tabIndex state, in which case we don't need or want
        // to set state again.
        if (!this[rendering]) {
          // Record the new tabIndex in our state.
          this[setState]({
            tabIndex
          });
        }
      }
    }
    return Keyboard;
  }

  const Base$9 = DelegateFocusMixin(DelegateInputLabelMixin(DelegateInputSelectionMixin(DisabledMixin(FocusVisibleMixin(FormElementMixin(KeyboardDirectionMixin(KeyboardMixin(ReactiveElement))))))));

  /**
   * Input with buttons to increase or decrease a value
   *
   * @inherits ReactiveElement
   * @mixes DelegateFocusMixin
   * @mixes DelegateInputLabelMixin
   * @mixes DelegateInputSelectionMixin
   * @mixes DisabledMixin
   * @mixes FocusVisibleMixin
   * @mixes FormElementMixin
   * @mixes KeyboardDirectionMixin
   * @mixes KeyboardMixin
   * @part {input} input - the text input portion of the spin box
   * @part {button} button - the up and down buttons
   * @part up-button - the up button
   * @part down-button - the down button
   */
  class SpinBox extends Base$9 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        buttonPartType: "button",
        canGoDown: true,
        canGoUp: true,
        inputPartType: "input",
        orientation: "vertical",
        step: 1,
        stepSelect: false,
        value: ""
      });
    }
    [goDown]() {
      if (super[goDown]) {
        super[goDown]();
      }
      this.stepDown();
      return true; // Handled
    }

    [goUp]() {
      if (super[goUp]) {
        super[goUp]();
      }
      this.stepUp();
      return true; // Handled
    }

    get [inputDelegate]() {
      return this[ids].input;
    }
    [render](changed) {
      super[render](changed);
      renderParts$4(this[shadowRoot], this[state], changed);

      // Wire up handlers on new buttons.
      if (changed.buttonPartType) {
        this[ids].downButton.addEventListener("mousedown", () => {
          this[raiseChangeEvents] = true;
          this.stepDown();
          this[raiseChangeEvents] = false;
        });
        this[ids].upButton.addEventListener("mousedown", () => {
          this[raiseChangeEvents] = true;
          this.stepUp();
          this[raiseChangeEvents] = false;
        });
      }

      // Wire up event handler on new input.
      if (changed.inputPartType) {
        // Wire up handler on new input.
        this[ids].input.addEventListener("input", () => {
          this[raiseChangeEvents] = true;
          this.value = /** @type {any} */this[ids].input.value;
          this[raiseChangeEvents] = false;
        });
      }

      // When buttons are clicked, keep focus on input.
      if (changed.buttonPartType || changed.inputPartType) {
        const input = this[ids].input;
        const downButton = this[ids].downButton;
        if (downButton instanceof HTMLElement && input instanceof HTMLElement) {
          forwardFocus(downButton, input);
        }
        const upButton = this[ids].upButton;
        if (upButton instanceof HTMLElement && input instanceof HTMLElement) {
          forwardFocus(upButton, input);
        }
      }
      const {
        disabled,
        value
      } = this[state];

      // When disabled, disable inner elements.
      // Also, disable up or down button if we're at max or min.
      if (changed.canGoUp || changed.canGoDown || changed.disabled) {
        const {
          canGoUp,
          canGoDown
        } = this[state];
        if ("disabled" in this[ids].input) {
          /** @type {any} */this[ids].input.disabled = disabled;
        }
        if ("disabled" in this[ids].downButton) {
          const upDisabled = disabled || !canGoUp;
          /** @type {any} */
          this[ids].upButton.disabled = upDisabled;
        }
        if ("disabled" in this[ids].upButton) {
          const downDisabled = disabled || !canGoDown;
          /** @type {any} */
          this[ids].downButton.disabled = downDisabled;
        }
      }

      // Render value state to input.
      if (changed.value) {
        /** @type {any} */this[ids].input.value = value;
      }
    }
    [rendered](changed) {
      super[rendered](changed);

      // If we changed the value as a result of stepDown/stepUp, put the cursor
      // at the end of the new text.
      const {
        stepSelect,
        value
      } = this[state];
      if (changed.value && stepSelect) {
        /** @type {any} */const input = this[ids].input;
        const length = value.length;
        input.selectionStart = length;
        input.selectionEnd = length;
        this[setState]({
          stepSelect: false
        });
      }
      if (changed.value && this[raiseChangeEvents]) {
        /**
         * Raised when the `value` property changes.
         *
         * @event change
         */
        const event = new CustomEvent("change", {
          bubbles: true,
          detail: {
            value
          }
        });
        this.dispatchEvent(event);
      }
    }
    stepDown() {
      // Set selection after we've rendered.
      this[setState]({
        stepSelect: true
      });
    }
    stepUp() {
      // Set selection after we've rendered.
      this[setState]({
        stepSelect: true
      });
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
      <style>
        :host {
          display: inline-grid;
        }

        [part~="input"] {
          grid-row-end: 3;
          grid-row-start: 1;
          outline: none;
          text-align: right;
        }

        [part~="spin-button"] {
          grid-column: 2;
          user-select: none;
        }
      </style>
      <div id="input" part="input"></div>
      <div id="upButton" part="spin-button up-button" tabindex="-1"></div>
      <div id="downButton" part="spin-button down-button" tabindex="-1"></div>
    `);
      return result;
    }

    /**
     * The text entered in the spin box.
     *
     * @type {string}
     * @default ""
     */
    get value() {
      return this[state].value;
    }
    set value(value) {
      this[setState]({
        value: String(value)
      });
    }
  }

  /**
   * Render parts for the template or an instance.
   *
   * @private
   * @param {DocumentFragment} root
   * @param {PlainObject} state
   * @param {ChangedFlags} [changed]
   */
  function renderParts$4(root, state, changed) {
    if (!changed || changed.inputPartType) {
      const {
        buttonPartType
      } = state;
      const buttons = root.querySelectorAll('[part~="spin-button"]');
      buttons.forEach(button => {
        transmute(button, buttonPartType);
      });
    }
    if (!changed || changed.inputPartType) {
      const {
        inputPartType
      } = state;
      const input = root.getElementById("input");
      if (input) {
        transmute(input, inputPartType);
      }
    }
  }

  /**
   * @class NumberSpinBox
   */
  class NumberSpinBox extends SpinBox {
    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (name === 'max') {
        this.max = parseFloat(newValue);
      } else if (name === 'min') {
        this.min = parseFloat(newValue);
      } else if (name === 'step') {
        this.step = parseFloat(newValue);
      } else {
        super.attributeChangedCallback(name, oldValue, newValue);
      }
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        max: null,
        min: null,
        step: 1
      });
    }

    /**
     * @function formatValue
     * Format the numeric value as a string.
     *
     * This is used after incrementing/decrementing the value to reformat the
     * value as a string.
     *
     * @param {number} value
     * @param {number} precision
     * @returns {number}
     */
    formatValue(value, precision) {
      return Number(value).toFixed(precision);
    }

    /**
     * The maximum allowable value of the `value` property.
     *
     * @type {number|null}
     * @default 1
     */
    get max() {
      return this[state].max;
    }

    /**
     * The maximum allowable value of the `value` property.
     *
     * @type {number|null}
     * @default 1
     */
    set max(max) {
      this[setState]({
        max
      });
    }

    /**
     * The minimum allowable value of the `value` property.
     *
     * @type {number|null}
     * @default 1
     */
    get min() {
      return this[state].min;
    }

    /**
     * @function set
     * @returns {void}
     */
    set min(min) {
      this[setState]({
        min
      });
    }

    /**
     * @function parseValue
     * @param {number} value
     * @param {number} precision
     * @returns {int}
     */
    parseValue(value, precision) {
      const parsed = precision === 0 ? parseInt(value) : parseFloat(value);
      return isNaN(parsed) ? 0 : parsed;
    }

    /**
     * @function stateEffects
     * @param {any} state
     * @param {any} changed
     * @returns {any}
     */
    [stateEffects](state, changed) {
      const effects = super[stateEffects];
      // If step changed, calculate its precision (number of digits after
      // the decimal).
      if (changed.step) {
        const {
          step
        } = state;
        const decimalRegex = /\.(\d)+$/;
        const match = decimalRegex.exec(String(step));
        const precision = match && match[1] ? match[1].length : 0;
        Object.assign(effects, {
          precision
        });
      }
      if (changed.max || changed.min || changed.value) {
        // The value is valid if it falls between the min and max.
        // TODO: We need a way to let other classes/mixins on the prototype chain
        // contribute to validity -- if someone else thinks the value is invalid,
        // we should respect that, even if the value falls within the min/max
        // bounds.
        const {
          max,
          min,
          precision,
          value
        } = state;
        const parsed = parseInt(value, precision);
        if (value !== '' && isNaN(parsed)) {
          Object.assign(effects, {
            valid: false,
            validationMessage: 'Value must be a number'
          });
        } else if (!(max === null || parsed <= max)) {
          Object.assign(effects, {
            valid: false,
            validationMessage: `Value must be less than or equal to ${max}.`
          });
        } else if (!(min === null || parsed >= min)) {
          Object.assign(effects, {
            valid: false,
            validationMessage: `Value must be greater than or equal to ${min}.`
          });
        } else {
          Object.assign(effects, {
            valid: true,
            validationMessage: ''
          });
        }
        // We can only go up if we're below max.
        Object.assign(effects, {
          canGoUp: isNaN(parsed) || state.max === null || parsed <= state.max
        });

        // We can only go down if we're above min.
        Object.assign(effects, {
          canGoDown: isNaN(parsed) || state.min === null || parsed >= state.min
        });
      }
      return effects;
    }

    /**
     * @function get
     * @returns {any}
     */
    get step() {
      return this[state].step;
    }

    /**
     * @function set
     * @returns {void}
     */
    set step(step) {
      if (!isNaN(step)) {
        this[setState]({
          step
        });
      }
    }

    /**
     * @function stepDown
     * @returns {void}
     */
    stepDown() {
      super.stepDown();
      const {
        max,
        precision,
        value
      } = this[state];
      let result = this.parseValue(value, precision) - this.step;
      if (max !== null) {
        result = Math.min(result, max);
      }
      const {
        min
      } = this[state];
      if (min === null || result >= min) {
        this.value = this.formatValue(result, precision);
      }
    }

    /**
     * @function stepUp
     * @returns {void}
     */
    stepUp() {
      super.stepUp();
      const {
        min,
        precision,
        value
      } = this[state];
      let result = this.parseValue(value, precision) + this.step;
      if (min !== null) {
        result = Math.max(result, min);
      }
      const {
        max
      } = this[state];
      if (max === null || result <= max) {
        this.value = this.formatValue(result, precision);
      }
    }
  }

  /**
   * @class PlainNumberSpinBox
   */
  class PlainNumberSpinBox extends PlainSpinBoxMixin(NumberSpinBox) {}

  /**
   * @class ElixNumberSpinBox
   */
  class ElixNumberSpinBox extends PlainNumberSpinBox {}
  customElements.define('elix-number-spin-box', ElixNumberSpinBox);

  /* globals svgEditor */
  const template$e = document.createElement('template');
  template$e.innerHTML = `
  <style>
  div {
    height: 24px;
    margin: 5px 1px;
    padding: 3px;
  }
  div.imginside {
    width: var(--global-se-spin-input-width);
  }
  img {
    position: relative;
    right: -4px;
    top: 2px;
  }
  span {
    bottom: -0.5em;
    right: -4px;
    position: relative;
    margin-left: -4px;
    margin-right: 1px;
    color: #fff;
  }
  elix-number-spin-box {
    background-color: var(--input-color);
    border-radius: 3px;
    height: 20px;
    margin-top: 1px;
    vertical-align: top;
  }
  elix-number-spin-box::part(spin-button) {
    padding: 0px;
  }
  elix-number-spin-box::part(input) {
    width: 3em;
  }
  elix-number-spin-box{
    width: 54px;
    height: 24px;
  }
  </style>
  <div>
  <img alt="icon" width="24" height="24" aria-labelledby="label" />
  <span id="label">label</span>
  <elix-number-spin-box min="1" step="1"></elix-number-spin-box>
  </div>
`;

  /**
   * @class SESpinInput
   */
  class SESpinInput extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$e.content.cloneNode(true));
      // locate the component
      this.$div = this._shadowRoot.querySelector('div');
      this.$img = this._shadowRoot.querySelector('img');
      this.$label = this.shadowRoot.getElementById('label');
      this.$event = new CustomEvent('change');
      this.$input = this._shadowRoot.querySelector('elix-number-spin-box');
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['value', 'label', 'src', 'size', 'min', 'max', 'step', 'title'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          {
            const shortcut = this.getAttribute('shortcut');
            this.$div.setAttribute('title', `${t$1(newValue)} ${shortcut ? `[${t$1(shortcut)}]` : ''}`);
          }
          break;
        case 'src':
          this.$img.setAttribute('src', this.imgPath + '/' + newValue);
          this.$label.remove();
          this.$div.classList.add('imginside');
          break;
        case 'size':
          // access to the underlying input box
          this.$input.shadowRoot.getElementById('input').size = newValue;
          // below seems mandatory to override the default width style that takes precedence on size
          this.$input.shadowRoot.getElementById('input').style.width = 'unset';
          break;
        case 'step':
          this.$input.setAttribute('step', newValue);
          break;
        case 'min':
          this.$input.setAttribute('min', newValue);
          break;
        case 'max':
          this.$input.setAttribute('max', newValue);
          break;
        case 'label':
          this.$label.textContent = t$1(newValue);
          this.$img.remove();
          break;
        case 'value':
          this.$input.value = newValue;
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get label() {
      return this.getAttribute('label');
    }

    /**
     * @function set
     * @returns {void}
     */
    set label(value) {
      this.setAttribute('label', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get value() {
      return this.$input.value;
    }

    /**
     * @function set
     * @returns {void}
     */
    set value(value) {
      this.$input.value = value;
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get size() {
      return this.getAttribute('size');
    }

    /**
     * @function set
     * @returns {void}
     */
    set size(value) {
      this.setAttribute('size', value);
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      const shadow = this.$input.shadowRoot;
      const childNodes = Array.from(shadow.childNodes);
      childNodes.forEach(childNode => {
        if ((childNode === null || childNode === void 0 ? void 0 : childNode.id) === 'input') {
          childNode.addEventListener('keyup', e => {
            e.preventDefault();
            if (!isNaN(e.target.value)) {
              this.value = e.target.value;
              this.dispatchEvent(this.$event);
            }
          });
        }
      });
      this.$input.addEventListener('change', e => {
        e.preventDefault();
        this.value = e.target.value;
        this.dispatchEvent(this.$event);
      });
      svgEditor.$click(this.$input, e => {
        e.preventDefault();
        this.value = e.target.value;
        this.dispatchEvent(this.$event);
      });
    }
  }

  // Register
  customElements.define('se-spin-input', SESpinInput);

  /* globals svgEditor */
  /* eslint-disable max-len */
  const palette = [
  // Todo: Make into configuration item?
  'none', '#000000', '#3f3f3f', '#7f7f7f', '#bfbfbf', '#ffffff', '#ff0000', '#ff7f00', '#ffff00', '#7fff00', '#00ff00', '#00ff7f', '#00ffff', '#007fff', '#0000ff', '#7f00ff', '#ff00ff', '#ff007f', '#7f0000', '#7f3f00', '#7f7f00', '#3f7f00', '#007f00', '#007f3f', '#007f7f', '#003f7f', '#00007f', '#3f007f', '#7f007f', '#7f003f', '#ffaaaa', '#ffd4aa', '#ffffaa', '#d4ffaa', '#aaffaa', '#aaffd4', '#aaffff', '#aad4ff', '#aaaaff', '#d4aaff', '#ffaaff', '#ffaad4'];
  const template$d = document.createElement('template');
  template$d.innerHTML = `
  <style>
  .square {
    height: 15px;
    width: 15px;
    float: left;
  }
  #palette_holder {
    overflow: hidden;
    padding: 4px;
    background: #f0f0f0;
    border-radius: 3px;
    z-index: 2;
  }
  
  #js-se-palette {
    float: left;
    width: 632px;
    height: 16px;
  }
  
  div.palette_item {
    height: 15px;
    width: 15px;
    float: left;
  }
  
  div.palette_item:first-child {
    background: white;
  }
  
  </style>
  <div id="palette_holder" title="">
    <div id="js-se-palette">
    </div>
  </div>
`;

  /**
   * @class SEPalette
   */
  class SEPalette extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$d.content.cloneNode(true));
      this.$strip = this._shadowRoot.querySelector('#js-se-palette');
      palette.forEach(rgb => {
        const newDiv = document.createElement('div');
        newDiv.classList.add('square');
        if (rgb === 'none') {
          const img = document.createElement('img');
          img.src = 'data:image/svg+xml;charset=utf-8;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjI0IiBoZWlnaHQ9IjI0IiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgY2xhc3M9InN2Z19pY29uIj48c3ZnIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+CiAgICA8bGluZSBmaWxsPSJub25lIiBzdHJva2U9IiNkNDAwMDAiIGlkPSJzdmdfOTAiIHkyPSIyNCIgeDI9IjI0IiB5MT0iMCIgeDE9IjAiLz4KICAgIDxsaW5lIGlkPSJzdmdfOTIiIGZpbGw9Im5vbmUiIHN0cm9rZT0iI2Q0MDAwMCIgeTI9IjI0IiB4Mj0iMCIgeTE9IjAiIHgxPSIyNCIvPgogIDwvc3ZnPjwvc3ZnPg==';
          img.style.width = '15px';
          img.style.height = '15px';
          newDiv.append(img);
        } else {
          newDiv.style.backgroundColor = rgb;
        }
        newDiv.dataset.rgb = rgb;
        svgEditor.$click(newDiv, evt => {
          evt.preventDefault();
          // shift key or right click for stroke
          const picker = evt.shiftKey || evt.button === 2 ? 'stroke' : 'fill';
          let color = newDiv.dataset.rgb;
          // Webkit-based browsers returned 'initial' here for no stroke
          if (color === 'none' || color === 'transparent' || color === 'initial') {
            color = 'none';
          }
          const paletteEvent = new CustomEvent('change', {
            detail: {
              picker,
              color
            },
            bubbles: false
          });
          this.dispatchEvent(paletteEvent);
        });
        this.$strip.append(newDiv);
      });
    }

    /**
     * @function init
     * @param {any} name
     * @returns {void}
     */
    init(i18next) {
      this.setAttribute('ui-palette_info', i18next.t('ui.palette_info'));
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['ui-palette_info'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      let node;
      if (name === 'ui-palette_info') {
        node = this._shadowRoot.querySelector('#palette_holder');
        node.setAttribute('title', newValue);
      }
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {}
  }

  // Register
  customElements.define('se-palette', SEPalette);

  /**
   * Tracks whether an item is the current item.
   *
   * @module CurrentMixin
   * @state current
   * @param {Constructor<ReactiveElement>} Base
   */
  function CurrentMixin(Base) {
    // The class prototype added by the mixin.
    return class Current extends Base {
      constructor() {
        super();
        /** @type {any} */
        const cast = this;
        if (!this[nativeInternals] && cast.attachInternals) {
          this[nativeInternals] = cast.attachInternals();
        }
      }
      attributeChangedCallback(name, oldValue, newValue) {
        if (name === "current") {
          const value = booleanAttributeValue(name, newValue);
          if (this.current !== value) {
            this.current = value;
          }
        } else {
          super.attributeChangedCallback(name, oldValue, newValue);
        }
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          current: false
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        super[render](changed);
        if (changed.current) {
          const {
            current
          } = this[state];
          setInternalState$2(this, "current", current);
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }

        // TODO: How do we know whether to raise this if selection is set by Menu? */
        if (changed.current /* && this[raiseChangeEvents] */) {
          const {
            current
          } = this[state];
          /**
           * Raised when the `current` property changes.
           *
           * @event currentchange
           */
          const event = new CustomEvent("currentchange", {
            bubbles: true,
            detail: {
              current
            }
          });
          this.dispatchEvent(event);
        }
      }

      /**
       * True if the element is currently current.
       *
       * @type {boolean}
       * @default false
       */
      get current() {
        return this[state].current;
      }
      set current(current) {
        // Note: AttributeMarshallingMixin will recognize `current` as the name of
        // attribute that should be parsed as a boolean attribute, and so will
        // handling parsing it for us.
        this[setState]({
          current
        });
      }
    };
  }

  /**
   * Tracks whether the element is currently selected.
   *
   * @module SelectableMixin
   * @state selected
   * @param {Constructor<ReactiveElement>} Base
   */
  function SelectableMixin(Base) {
    // The class prototype added by the mixin.
    return class Selectable extends Base {
      constructor() {
        super();
        /** @type {any} */
        const cast = this;
        if (!this[nativeInternals] && cast.attachInternals) {
          this[nativeInternals] = cast.attachInternals();
        }
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          selected: false
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        super[render](changed);
        if (changed.selected) {
          const {
            selected
          } = this[state];
          setInternalState$2(this, "selected", selected);
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }

        // TODO: How do we know whether to raise this if selection is set by Menu? */
        if (changed.selected /* && this[raiseChangeEvents] */) {
          const {
            selected
          } = this[state];
          /**
           * Raised when the `selected` property changes.
           *
           * @event selectedchange
           */
          const event = new CustomEvent("selectedchange", {
            bubbles: true,
            detail: {
              selected
            }
          });
          this.dispatchEvent(event);
        }
      }

      /**
       * True if the element is currently selected.
       *
       * @type {boolean}
       * @default false
       */
      get selected() {
        return this[state].selected;
      }
      set selected(selected) {
        // Note: AttributeMarshallingMixin will recognize `selected` as the name of
        // attribute that should be parsed as a boolean attribute, and so will
        // handling parsing it for us.
        this[setState]({
          selected
        });
      }
    };
  }

  /**
   * A choice in a menu
   *
   * This class is a convenient way to popuplate a [Menu](Menu) with items that
   * exhibit an appearance roughly consistent with operating system menu items.
   * Use of this class is not required, however -- a `Menu` can contain any type
   * of item you want.
   *
   * @inherits ReactiveElement
   * @mixes CurrentMixin
   * @mixes DisabledMixin
   * @mixes SelectableMixin
   */
  class MenuItem extends CurrentMixin(DisabledMixin(SelectableMixin(ReactiveElement))) {}

  /**
   * MenuItem component in the Plain reference design system
   *
   * @inherits MenuItem
   */
  class PlainMenuItem extends MenuItem {
    get [template$g]() {
      // Apply variety of system fonts.
      // Checkmark icon from Material Design.
      return templateFrom.html`
      <style>
        :host {
          font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
          font-size: 10pt;
          white-space: nowrap;
        }

        :host([disabled]) {
          opacity: 0.5;
        }

        #checkmark {
          height: 1em;
          visibility: hidden;
          width: 1em;
        }

        :host([selected]) #checkmark {
          visibility: visible;
        }
      </style>
      <svg id="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="4 6 18 12">
        <path d="M0 0h24v24H0V0z" fill="none"/>
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/>
      </svg>
      <slot></slot>
    `;
    }
  }

  class ElixMenuItem extends PlainMenuItem {}
  customElements.define("elix-menu-item", ElixMenuItem);

  /**
   * Helpers related to universal accessibility
   *
   * Universal accessibility is a core goal of the Elix project. These helpers are
   * used by mixins like [AriaListMixin](AriaListMixin) and
   * [AriaMenuMixin](AriaMenuMixin) to support accessibility via ARIA.
   *
   * @module accessibility
   */

  /**
   * A dictionary mapping built-in HTML elements to their default ARIA role.
   *
   * Example: `defaultAriaRole.ol` returns "list", since the default ARIA role
   * for an `ol` (ordered list) element is "list".
   */
  const defaultAriaRole = {
    a: "link",
    article: "region",
    button: "button",
    h1: "sectionhead",
    h2: "sectionhead",
    h3: "sectionhead",
    h4: "sectionhead",
    h5: "sectionhead",
    h6: "sectionhead",
    hr: "sectionhead",
    iframe: "region",
    link: "link",
    menu: "menu",
    ol: "list",
    option: "option",
    output: "liveregion",
    progress: "progressbar",
    select: "select",
    table: "table",
    td: "td",
    textarea: "textbox",
    th: "th",
    ul: "list"
  };

  /**
   * Tells assistive technologies to describe a list's items as a menu of choices.
   *
   * @module AriaMenuMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function AriaMenuMixin(Base) {
    // The class prototype added by the mixin.
    class AriaMenu extends Base {
      // @ts-ignore
      get [defaultState]() {
        const base = super[defaultState];
        return Object.assign(base, {
          itemRole: base.itemRole || "menuitem",
          role: base.role || "menu"
        });
      }
      get itemRole() {
        return this[state].itemRole;
      }
      set itemRole(itemRole) {
        this[setState]({
          itemRole
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }

        /** @type {ListItemElement[]} */
        const items = this[state].items;
        if ((changed.items || changed.itemRole) && items) {
          // Give each item a role.
          const {
            itemRole
          } = this[state];
          items.forEach(item => {
            if (itemRole === defaultAriaRole[item.localName]) {
              item.removeAttribute("role");
            } else {
              item.setAttribute("role", itemRole);
            }
          });
        }
        if (changed.role) {
          // Apply top-level role.
          const {
            role
          } = this[state];
          this.setAttribute("role", role);
        }
      }

      // Setting the standard role attribute will invoke this property setter,
      // which will allow us to update our state.
      get role() {
        return super.role;
      }
      set role(role) {
        super.role = role;
        if (!this[rendering]) {
          this[setState]({
            role
          });
        }
      }
    }
    return AriaMenu;
  }

  /**
   * Exposes a public API for navigating a cursor over a set of items
   *
   * This mixin expects a component to provide an `items` Array of all elements in
   * the list. This mixin also expects the component to apply
   * [ItemsCursorMixin](ItemsCursorMixin) or otherwise define a compatible
   * `currentIndex` state and other state members for navigating the current item.
   *
   * Given the above, this mixin exposes a consistent public API for reading and
   * manipulating the cursor.
   *
   * @module CursorAPIMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function CursorAPIMixin(Base) {
    // The class prototype added by the mixin.
    class CursorAPI extends Base {
      attributeChangedCallback(name, oldValue, newValue) {
        if (name === "current-index") {
          this.currentIndex = Number(newValue);
        } else if (name === "current-item-required") {
          const value = booleanAttributeValue(name, newValue);
          if (this.currentItemRequired !== value) {
            this.currentItemRequired = value;
          }
        } else if (name === "cursor-operations-wrap") {
          const value = booleanAttributeValue(name, newValue);
          if (this.cursorOperationsWrap !== value) {
            this.cursorOperationsWrap = value;
          }
        } else {
          super.attributeChangedCallback(name, oldValue, newValue);
        }
      }

      /**
       * The index of the current item, or -1 if no item is current.
       *
       * @type {number}
       */
      get currentIndex() {
        const {
          items,
          currentIndex
        } = this[state];
        return items && items.length > 0 ? currentIndex : -1;
      }
      set currentIndex(currentIndex) {
        if (!isNaN(currentIndex)) {
          this[setState]({
            currentIndex
          });
        }
      }

      /**
       * The current item, or null if no item is current.
       *
       * @type {Element}
       */
      get currentItem() {
        const {
          items,
          currentIndex
        } = this[state];
        return items && items[currentIndex];
      }
      set currentItem(currentItem) {
        const {
          items
        } = this[state];
        if (!items) {
          return;
        }
        const currentIndex = items.indexOf(currentItem);
        this[setState]({
          currentIndex
        });
      }

      /**
       * True if the list should always have a current item (if it has items).
       *
       * @type {boolean}
       * @default false
       */
      get currentItemRequired() {
        return this[state].currentItemRequired;
      }
      set currentItemRequired(currentItemRequired) {
        this[setState]({
          currentItemRequired
        });
      }

      /**
       * True if cursor operations wrap from last to first, and vice versa.
       *
       * @type {boolean}
       * @default false
       */
      get cursorOperationsWrap() {
        return this[state].cursorOperationsWrap;
      }
      set cursorOperationsWrap(cursorOperationsWrap) {
        this[setState]({
          cursorOperationsWrap
        });
      }

      /**
       * Moves to the first item in the list.
       *
       * @returns {Boolean} True if the current item changed, false if not.
       */
      goFirst() {
        if (super.goFirst) {
          super.goFirst();
        }
        return this[goFirst]();
      }

      /**
       * Move to the last item in the list.
       *
       * @returns {Boolean} True if the current item changed
       */
      goLast() {
        if (super.goLast) {
          super.goLast();
        }
        return this[goLast]();
      }

      /**
       * Move to the next item in the list.
       *
       * If the list has no current item, the first item will become current.
       *
       * @returns {Boolean} True if the current item changed
       */
      goNext() {
        if (super.goNext) {
          super.goNext();
        }
        return this[goNext]();
      }

      /**
       * Moves to the previous item in the list.
       *
       * If the list has no current item, the last item will become current.
       *
       * @returns {Boolean} True if the current item changed
       */
      goPrevious() {
        if (super.goPrevious) {
          super.goPrevious();
        }
        return this[goPrevious]();
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.currentIndex && this[raiseChangeEvents]) {
          const {
            currentIndex
          } = this[state];
          /**
           * Raised when the `currentIndex` property changes.
           *
           * @event currentindexchange
           */
          const event = new CustomEvent("currentindexchange", {
            bubbles: true,
            detail: {
              currentIndex
            }
          });
          this.dispatchEvent(event);
        }
      }
    }
    return CursorAPI;
  }

  /**
   * This helper returns a guess as to what portion of the given element can be
   * scrolled. This is used by [CursorInViewMixin](CursorInViewMixin) to
   * provide a default implementation of [scrollTarget].
   *
   * If the element has a shadow root containing a default (unnamed) slot, this
   * returns the first ancestor of that slot that has either `overflow-x` or
   * `overflow-y` styled as `auto` or `scroll`. If the element has no default
   * slot, or no scrolling ancestor is found, the element itself is returned.
   *
   * @param {Element} element – the component to examine for a scrolling
   * element
   * @returns {Element}
   */
  function defaultScrollTarget(element) {
    const root = element[shadowRoot];
    const slot = root && root.querySelector("slot:not([name])");
    const scrollingParent = slot && slot.parentNode instanceof Element && getScrollableElement(slot.parentNode);
    return scrollingParent || element;
  }

  /**
   * Return true if the given element can be scrolled.
   *
   * @private
   * @param {HTMLElement} element
   */
  function isElementScrollable(element) {
    const style = getComputedStyle(element);
    const overflowX = style.overflowX;
    const overflowY = style.overflowY;
    return overflowX === "scroll" || overflowX === "auto" || overflowY === "scroll" || overflowY === "auto";
  }

  /**
   * If the given element can be scrolled, return that. If not, return the closest
   * ancestor that can be scrolled. If no such ancestor is found, return null.
   *
   * @param {Element} node
   * @returns {Element|null}
   */
  function getScrollableElement(node) {
    for (const ancestor of selfAndComposedAncestors(node)) {
      if (ancestor instanceof HTMLElement && isElementScrollable(ancestor)) {
        return ancestor;
      }
    }
    return null;
  }

  /**
   * Scrolls to ensure the current item is visible
   *
   * When the current item in a list-like component changes, the current item
   * should be brought into view so that the user can confirm their selection.
   *
   * This mixin expects an `items` collection, such as that provided by
   * [ContentItemsMixin](ContentItemsMixin). It also expects a
   * `state.currentItem` member indicating which item is current. You
   * can supply that yourself, or use
   * [ItemsCursorMixin](ItemsCursorMixin).
   *
   * @module CursorInViewMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function CursorInViewMixin(Base) {
    // The class prototype added by the mixin.
    class CursorInView extends Base {
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.currentItem) {
          this.scrollCurrentItemIntoView();
        }
      }

      /**
       * Scroll the current item completely into view, minimizing the degree of
       * scrolling performed.
       *
       * Blink has a `scrollIntoViewIfNeeded()` function that does something
       * similar, but unfortunately it's non-standard, and in any event often ends
       * up scrolling more than is absolutely necessary.
       *
       * This scrolls the containing element defined by the `scrollTarget`
       * property. By default, it will scroll the element itself.
       */
      scrollCurrentItemIntoView() {
        if (super.scrollCurrentItemIntoView) {
          super.scrollCurrentItemIntoView();
        }
        const {
          currentItem,
          items
        } = this[state];
        if (!currentItem || !items) {
          return;
        }

        // Determine the bounds of the scroll target and item. We use
        // getBoundingClientRect instead of .offsetTop, etc., because the latter
        // round values, and we want to handle fractional values.
        const scrollTargetRect = this[scrollTarget].getBoundingClientRect();
        const itemRect = currentItem.getBoundingClientRect();

        // Determine how far the item is outside the viewport.
        const bottomDelta = itemRect.bottom - scrollTargetRect.bottom;
        const leftDelta = itemRect.left - scrollTargetRect.left;
        const rightDelta = itemRect.right - scrollTargetRect.right;
        const topDelta = itemRect.top - scrollTargetRect.top;

        // Scroll the target as necessary to bring the item into view.
        // If an `orientation` state member is defined, only scroll along that
        // axis. Otherwise, assume the orientation is "both".
        const orientation = this[state].orientation || "both";
        if (orientation === "horizontal" || orientation === "both") {
          if (rightDelta > 0) {
            this[scrollTarget].scrollLeft += rightDelta; // Scroll right
          } else if (leftDelta < 0) {
            this[scrollTarget].scrollLeft += Math.ceil(leftDelta); // Scroll left
          }
        }

        if (orientation === "vertical" || orientation === "both") {
          if (bottomDelta > 0) {
            this[scrollTarget].scrollTop += bottomDelta; // Scroll down
          } else if (topDelta < 0) {
            this[scrollTarget].scrollTop += Math.ceil(topDelta); // Scroll up
          }
        }
      }

      /**
       * The element that should be scrolled to get the selected item into view.
       *
       * By default, this uses the [defaultScrollTarget](defaultScrollTarget)
       * helper to find the most likely candidate for scrolling. You can override
       * this property to directly identify which element should be scrolled.
       *
       * See also [scrollTarget](internal#internal.scrollTarget).
       */
      get [scrollTarget]() {
        const base = super[scrollTarget];
        /** @type {any} */
        const element = this;
        return base || defaultScrollTarget(element);
      }
    }
    return CursorInView;
  }

  /**
   * Maps direction semantics to cursor semantics.
   *
   * This turns a movement in a direction (go left, go right) into a cursor
   * operation (go previous, go next).
   *
   * This mixin can be used in conjunction with
   * [KeyboardDirectionMixin](KeyboardDirectionMixin) (which maps keyboard events
   * to directions) and a mixin that handles cursor operations like
   * [ItemsCursorMixin](ItemsCursorMixin).
   *
   * @module DirectionCursorMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function DirectionCursorMixin(Base) {
    // The class prototype added by the mixin.
    class DirectionCursor extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          canGoDown: null,
          canGoLeft: null,
          canGoRight: null,
          canGoUp: null
        });
      }

      /**
       * Interprets `goDown` to mean "move to the next item".
       */
      [goDown]() {
        if (super[goDown]) {
          super[goDown]();
        }
        return this[goNext]();
      }

      /**
       * Interprets `goEnd` to mean "move to the last item".
       */
      [goEnd]() {
        if (super[goEnd]) {
          super[goEnd]();
        }
        return this[goLast]();
      }

      /**
       * Interprets `goLeft` to mean "move to the previous item".
       *
       * If the element has a `rightToLeft` property and it is true, then this
       * moves to the _next_ item.
       */
      [goLeft]() {
        if (super[goLeft]) {
          super[goLeft]();
        }
        return this[state] && this[state].rightToLeft ? this[goNext]() : this[goPrevious]();
      }

      /**
       * Interprets `goRight` to mean "move to the next item".
       *
       * If the element has a `rightToLeft` property and it is true, then this
       * moves to the _previous_ item.
       */
      [goRight]() {
        if (super[goRight]) {
          super[goRight]();
        }
        return this[state] && this[state].rightToLeft ? this[goPrevious]() : this[goNext]();
      }

      /**
       * Interprets `goStart` to mean "move to the first item".
       */
      [goStart]() {
        if (super[goStart]) {
          super[goStart]();
        }
        return this[goFirst]();
      }

      /**
       * Interprets `goUp` to mean "move to the previous item".
       */
      [goUp]() {
        if (super[goUp]) {
          super[goUp]();
        }
        return this[goPrevious]();
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // Update computed state members to track whether we can go
        // down/left/right/up.
        if (changed.canGoNext || changed.canGoPrevious || changed.languageDirection || changed.orientation || changed.rightToLeft) {
          const {
            canGoNext,
            canGoPrevious,
            orientation,
            rightToLeft
          } = state;
          const horizontal = orientation === "horizontal" || orientation === "both";
          const vertical = orientation === "vertical" || orientation === "both";
          const canGoDown = vertical && canGoNext;
          const canGoLeft = !horizontal ? false : rightToLeft ? canGoNext : canGoPrevious;
          const canGoRight = !horizontal ? false : rightToLeft ? canGoPrevious : canGoNext;
          const canGoUp = vertical && canGoPrevious;
          Object.assign(effects, {
            canGoDown,
            canGoLeft,
            canGoRight,
            canGoUp
          });
        }
        return effects;
      }
    }
    return DirectionCursor;
  }

  /**
   * Exposes a public API for the set of items in a list-like element
   *
   * @module ItemsAPIMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function ItemsAPIMixin(Base) {
    // The class prototype added by the mixin.
    class ItemsAPI extends Base {
      /**
       * The current set of items drawn from the element's current state.
       *
       * @type {ListItemElement[]} the element's current items
       */
      get items() {
        return this[state] ? this[state].items : null;
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }

        // Raise items-changed if items changed after the initial render. We'll
        // see changed.items on initial render, and raiseChangeEvents will be true
        // if we're using SlotContentMixin, but we don't want to actually raise
        // the event then because the items didn't change in response to user
        // activity.
        if (!this[firstRender] && changed.items && this[raiseChangeEvents]) {
          /**
           * Raised when the `items` property changes.
           *
           * @event itemschange
           */
          const event = new CustomEvent("itemschange", {
            bubbles: true
          });
          this.dispatchEvent(event);
        }
      }
    }
    return ItemsAPI;
  }

  /**
   * Tracks and navigates the current item in a set of items
   *
   * @module ItemsCursorMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function ItemsCursorMixin(Base) {
    // The class prototype added by the mixin.
    class ItemsCursor extends Base {
      /**
       * Look for an item which is available in the given state..
       *
       * The `options` parameter can accept options for:
       *
       * * `direction`: 1 to move forward, -1 to move backward
       * * `index`: the index to start at, defaults to `state.currentIndex`
       * * `wrap`: whether to wrap around the ends of the `items` array, defaults
       *   to `state.cursorOperationsWrap`.
       *
       * If an available item was found, this returns its index. If no item was
       * found, this returns -1.
       *
       * @param {PlainObject} state
       * @param {PlainObject} options
       * @returns {number}
       */
      [closestAvailableItemIndex](state) {
        let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        const direction = options.direction !== undefined ? options.direction : 1;
        const index = options.index !== undefined ? options.index : state.currentIndex;
        const wrap = options.wrap !== undefined ? options.wrap : state.cursorOperationsWrap;
        const {
          items
        } = state;
        const count = items ? items.length : 0;
        if (count === 0) {
          // No items
          return -1;
        }
        if (wrap) {
          // Search with wrapping.

          // Modulus taking into account negative numbers.
          let i = (index % count + count) % count;
          const end = ((i - direction) % count + count) % count;
          while (i !== end) {
            const available = state.availableItemFlags ? state.availableItemFlags[i] : true;
            if (available) {
              return i;
            }
            // See modulus note above.
            i = ((i + direction) % count + count) % count;
          }
        } else {
          // Search without wrapping.
          for (let i = index; i >= 0 && i < count; i += direction) {
            const available = state.availableItemFlags ? state.availableItemFlags[i] : true;
            if (available) {
              return i;
            }
          }
        }
        return -1; // No item found
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          currentIndex: -1,
          desiredCurrentIndex: null,
          currentItem: null,
          currentItemRequired: false,
          cursorOperationsWrap: false
        });
      }

      /**
       * Move to the first item in the set.
       *
       * @protected
       * @returns {Boolean} True if the current item changed, false if not.
       */
      [goFirst]() {
        if (super[goFirst]) {
          super[goFirst]();
        }
        return moveToIndex(this, 0, 1);
      }

      /**
       * Move to the last item in the set.
       *
       * @protected
       * @returns {Boolean} True if the current item changed, false if not.
       */
      [goLast]() {
        if (super[goLast]) {
          super[goLast]();
        }
        return moveToIndex(this, this[state].items.length - 1, -1);
      }

      /**
       * Move to the next item in the set.
       *
       * If no item is current, move to the first item.
       *
       * @protected
       * @returns {Boolean} True if the current item changed, false if not.
       */
      [goNext]() {
        if (super[goNext]) {
          super[goNext]();
        }
        const {
          currentIndex,
          items
        } = this[state];
        const start = currentIndex < 0 && items ? 0 : currentIndex + 1;
        return moveToIndex(this, start, 1);
      }

      /**
       * Move to the previous item in the set.
       *
       * If no item is current, move to the last item.
       *
       * @protected
       * @returns {Boolean} True if the current item changed, false if not.
       */
      [goPrevious]() {
        if (super[goPrevious]) {
          super[goPrevious]();
        }
        const {
          currentIndex,
          items
        } = this[state];
        const start = currentIndex < 0 && items ? items.length - 1 : currentIndex - 1;
        return moveToIndex(this, start, -1);
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // Ensure currentIndex is valid.
        if (changed.availableItemFlags || changed.items || changed.currentIndex || changed.currentItemRequired) {
          const {
            currentIndex,
            desiredCurrentIndex,
            currentItem,
            currentItemRequired,
            items
          } = state;
          const count = items ? items.length : 0;

          // Determine the desired index: the one we want irrespective of whether
          // we have items or their availability.
          // Assume we'll stick with the same desired index we already have.
          let newDesiredIndex = desiredCurrentIndex;
          if (changed.items && !changed.currentIndex && currentItem && count > 0 && items[currentIndex] !== currentItem) {
            // The items changed, and the item at the cursor is no longer the
            // same. See if we can find that item again in the list of items.
            const newItemIndex = items.indexOf(currentItem);
            if (newItemIndex >= 0) {
              // Found the item again; try to use its index.
              newDesiredIndex = newItemIndex;
            }
          } else if (changed.currentIndex && (currentIndex < 0 && currentItem !== null || currentIndex >= 0 && (count === 0 || items[currentIndex] !== currentItem) || desiredCurrentIndex === null)) {
            // Someone explicitly moved the cursor, which trumps any previously
            // desired index.
            newDesiredIndex = currentIndex;
          }

          // If an item is required and there's no selection, we'll implicitly try
          // to get the first available item.
          if (currentItemRequired && newDesiredIndex < 0) {
            newDesiredIndex = 0;
          }

          // Now that we know what index we want, see how close we can get to it.
          let newIndex;
          if (newDesiredIndex < 0) {
            // All negative indices are equivalent to -1.
            newDesiredIndex = -1;
            newIndex = -1;
          } else if (count === 0) {
            // No items yet.
            newIndex = -1;
          } else {
            // See how close we can get to the desired index.
            // First clamp index to existing array bounds.
            newIndex = Math.max(Math.min(count - 1, newDesiredIndex), 0);
            // Look for an available item going forward.
            newIndex = this[closestAvailableItemIndex](state, {
              direction: 1,
              index: newIndex,
              wrap: false
            });
            if (newIndex < 0) {
              // Next best: look for an available item going backward.
              newIndex = this[closestAvailableItemIndex](state, {
                direction: -1,
                index: newIndex - 1,
                wrap: false
              });
            }
          }
          const newItem = items && items[newIndex] || null;
          Object.assign(effects, {
            currentIndex: newIndex,
            desiredCurrentIndex: newDesiredIndex,
            currentItem: newItem
          });
        }
        return effects;
      }
    }
    return ItemsCursor;
  }

  /**
   * Update currentIndex and return true if it changed.
   *
   * @private
   * @param {Element} element
   * @param {number} index
   * @param {number} direction
   */
  function moveToIndex(element, index, direction) {
    const newIndex = element[closestAvailableItemIndex](element[state], {
      direction,
      index
    });
    if (newIndex < 0) {
      // Couldn't find an item to move to.
      return false;
    }
    // Normally we don't check to see if state is going to change before setting
    // state, but the methods defined by this mixin want to be able to return true
    // if the index is actually going to change.
    const changed = element[state].currentIndex !== newIndex;
    if (changed) {
      element[setState]({
        currentIndex: newIndex
      });
    }
    return changed;
  }

  /**
   * Helpers for working with element content.
   *
   * @module content
   */

  // These are tags for elements that can appear in the document body, but do not
  // seem to have any user-visible manifestation.
  // See https://developer.mozilla.org/en-US/docs/Web/HTML/Element
  const auxiliarycustomTags = ["applet",
  // deprecated
  "basefont",
  // deprecated
  "embed", "font",
  // deprecated
  "frame",
  // deprecated
  "frameset",
  // deprecated
  "isindex",
  // deprecated
  "keygen",
  // deprecated
  "link", "multicol",
  // deprecated
  "nextid",
  // deprecated
  "noscript", "object", "param", "script", "style", "template", "noembed" // deprecated
  ];

  /**
   * Use a heuristic to extract text from the given item.
   *
   * This looks, in order, at: the `aria-label` attribute, the `alt` attribute,
   * `innerText`, or `textContent`.
   *
   * This function is used as the default implementation of the
   * [getItemText](internal#getItemText) function in several mixins.
   *
   * @param {Element} element
   * @returns {string}
   */
  function getDefaultText(element) {
    return element.getAttribute("aria-label") || element.getAttribute("alt") || /** @type {any} */element.innerText || element.textContent || "";
  }

  /**
   * Return true if the given node is likely to be useful as component content.
   *
   * This will be `true` for nodes that are: a) instances of `Element`
   * (`HTMLElement` or `SVGElement`), and b) not on a blacklist of normally
   * invisible elements (such as `style` or `script`). Among other things, this
   * returns `false` for Text nodes.
   *
   * This is used by [ContentItemsMixin](ContentItemsMixin) to filter out nodes
   * which are unlikely to be interesting as list items. This is intended to
   * satisfy the Gold Standard checklist criteria [Auxiliary
   * Content](https://github.com/webcomponents/gold-standard/wiki/Auxiliary-Content),
   * so that a component does not inadvertently treat `<style>` and other invisible
   * items as element content.
   *
   * @param {Node} node
   * @returns {boolean}
   */
  function isSubstantiveElement(node) {
    return node instanceof Element && (!node.localName || auxiliarycustomTags.indexOf(node.localName) < 0);
  }

  /**
   * Exposes the text content of a list's items as an array of strings.
   *
   * @module ItemsTextMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function ItemsTextMixin(Base) {
    // The class prototype added by the mixin.
    class ItemsText extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          texts: null
        });
      }

      /**
       * Extract the text from the given item.
       *
       * The default implementation returns an item's `aria-label`, `alt`
       * attribute, `innerText`, or `textContent`, in that order. You can override
       * this to return the text that should be used.
       *
       * @param {Element} item
       * @returns {string}
       */
      [getItemText](item) {
        return super[getItemText] ? super[getItemText](item) : getDefaultText(item);
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // Regenerate texts when items change.
        if (changed.items) {
          const {
            items
          } = state;
          const texts = getTextsFromItems(items, this[getItemText]);
          if (texts) {
            Object.freeze(texts);
            Object.assign(effects, {
              texts
            });
          }
        }
        return effects;
      }
    }
    return ItemsText;
  }

  /**
   * Extract the text from the given items.
   *
   * @private
   * @param {Element[]} items
   */
  function getTextsFromItems(items, getText) {
    return items ? Array.from(items, item => getText(item)) : null;
  }

  /**
   * Maps the Page Up and Page Down keys to item cursor operations.
   *
   * The keyboard interaction model generally follows that of Microsoft Windows'
   * list boxes instead of those in OS X:
   *
   * * The Page Up/Down and Home/End keys actually move the item cursor, rather
   *   than just scrolling. The former behavior seems more generally useful for
   *   keyboard users.
   *
   * * Pressing Page Up/Down will first move the cursor to the topmost/bottommost
   *   visible item if the cursor is not already there. Thereafter, the key
   *   will move the cursor up/down by a page, and (per the above point) make
   *   the current item visible.
   *
   * To ensure the current item is in view following use of Page Up/Down, use
   * the related [CursorInViewMixin](CursorInViewMixin).
   *
   * This mixin expects the component to provide:
   *
   * * A `[keydown]` method invoked when a key is pressed. You can use
   *   [KeyboardMixin](KeyboardMixin) for that purpose, or wire up your own
   *   keyboard handling and call `[keydown]` yourself.
   * * A `currentIndex` state member updatable via [setState]`.
   *
   * @module KeyboardPagedCursorMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function KeyboardPagedCursorMixin(Base) {
    // The class prototype added by the mixin.
    class KeyboardPagedCursor extends Base {
      [keydown]( /** @type {KeyboardEvent} */event) {
        let handled = false;
        const orientation = this.orientation;
        if (orientation !== "horizontal") {
          switch (event.key) {
            case "PageDown":
              handled = this.pageDown();
              break;
            case "PageUp":
              handled = this.pageUp();
              break;
          }
        }

        // Prefer mixin result if it's defined, otherwise use base result.
        return handled || super[keydown] && super[keydown](event);
      }

      // Default orientation implementation defers to super,
      // but if not found, looks in state.
      get orientation() {
        return super.orientation || this[state] && this[state].orientation || "both";
      }

      /**
       * Scroll down one page.
       */
      pageDown() {
        if (super.pageDown) {
          super.pageDown();
        }
        return scrollOnePage(this, true);
      }

      /**
       * Scroll up one page.
       */
      pageUp() {
        if (super.pageUp) {
          super.pageUp();
        }
        return scrollOnePage(this, false);
      }

      /**
       * The element that will be scrolled when the user presses Page Up or
       * Page Down. The default value is calculated by
       * [defaultScrollTarget](defaultScrollTarget#defaultScrollTarget).
       *
       * See [scrollTarget](internal#internal.scrollTarget).
       *
       * @type {HTMLElement}
       */
      get [scrollTarget]() {
        /** @type {any} */
        const element = this;
        return super[scrollTarget] || defaultScrollTarget(element);
      }
    }
    return KeyboardPagedCursor;
  }

  /**
   * Return the item whose content spans the given y position (relative to the
   * top of the list's scrolling client area), or null if not found.
   *
   * If downward is true, move down the list of items to find the first item
   * found at the given y position; if downward is false, move up the list of
   * items to find the last item at that position.
   *
   * @private
   * @param {ReactiveElement} element
   * @param {number} y
   * @param {boolean} downward
   */
  function getIndexOfItemAtY(element, y, downward) {
    const items = element[state].items;
    const start = downward ? 0 : items.length - 1;
    const end = downward ? items.length : 0;
    const step = downward ? 1 : -1;

    // Find the item spanning the indicated y coordinate.
    let index;
    /** @type {HTMLElement|SVGElement|null} */
    let item = null;
    let itemRect;
    const {
      availableItemFlags
    } = element[state];
    for (index = start; index !== end; index += step) {
      // Only consider items available in the element's current state.
      const available = availableItemFlags ? availableItemFlags[index] : true;
      if (available) {
        itemRect = items[index].getBoundingClientRect();
        if (itemRect.top <= y && y <= itemRect.bottom) {
          // Item spans the indicated y coordinate.
          item = items[index];
          break;
        }
      }
    }
    if (!item || !itemRect) {
      return null;
    }

    // We may have found an item whose padding spans the given y coordinate,
    // but whose content is actually above/below that point.
    // TODO: If the item has a border, then padding should be included in
    // considering a hit.
    const itemStyle = getComputedStyle(item);
    const itemPaddingTop = itemStyle.paddingTop ? parseFloat(itemStyle.paddingTop) : 0;
    const itemPaddingBottom = itemStyle.paddingBottom ? parseFloat(itemStyle.paddingBottom) : 0;
    const contentTop = itemRect.top + itemPaddingTop;
    const contentBottom = contentTop + item.clientHeight - itemPaddingTop - itemPaddingBottom;
    if (downward && contentTop <= y || !downward && contentBottom >= y) {
      // The indicated coordinate hits the actual item content.
      return index;
    } else {
      // The indicated coordinate falls within the item's padding. Back up to
      // the item below/above the item we found and return that.
      return index - step;
    }
  }

  /**
   * Move by one page downward (if downward is true), or upward (if false).
   * Return true if we ended up moving the cursor, false if not.
   *
   * @private
   * @param {ReactiveElement} element
   * @param {boolean} downward
   */
  function scrollOnePage(element, downward) {
    const items = element[state].items;
    const currentIndex = element[state].currentIndex;

    // Determine the item visible just at the edge of direction we're heading.
    // We'll move to that item if it's not already current.
    const targetRect = element[scrollTarget].getBoundingClientRect();
    const edge = downward ? targetRect.bottom : targetRect.top;
    const indexOfItemAtEdge = getIndexOfItemAtY(element, edge, downward);
    let newIndex;
    if (indexOfItemAtEdge && currentIndex === indexOfItemAtEdge) {
      // The item at the edge was already current, so scroll in the indicated
      // direction by one page, measuring from the bounds of the current item.
      // Leave the new item at that edge current.
      const currentItem = items[currentIndex];
      const currentRect = currentItem.getBoundingClientRect();
      const pageHeight = element[scrollTarget].clientHeight;
      const y = downward ? currentRect.bottom + pageHeight : currentRect.top - pageHeight;
      newIndex = getIndexOfItemAtY(element, y, downward);
    } else {
      // The item at the edge wasn't current yet. Instead of scrolling, we'll just
      // move to that item. That is, the first attempt to page up/down usually
      // just moves the cursor to the edge in that direction.
      newIndex = indexOfItemAtEdge;
    }
    if (!newIndex) {
      // We went past the first/last item without finding an item. Move to the
      // last item (if moving downward) or first item (if moving upward).
      const index = downward ? items.length - 1 : 0;
      newIndex = element[closestAvailableItemIndex] ? element[closestAvailableItemIndex](element[state], {
        direction: downward ? -1 /* Work up */ : 1 /* Work down */,
        index
      }) : index;
    }
    const changed = newIndex !== currentIndex;
    if (changed) {
      // If external code causes an operation that scrolls the page, it's
      // impossible for it to predict where the currentIndex is going to end up.
      // Accordingly, we raise change events.
      const saveRaiseChangesEvents = element[raiseChangeEvents];
      element[raiseChangeEvents] = true;
      element[setState]({
        currentIndex: newIndex
      });
      element[raiseChangeEvents] = saveRaiseChangesEvents;
    }
    return changed;
  }

  /**
   * Constants used by Elix mixins and components
   *
   * Sharing these constants allows for greater consistency in things such as user
   * interface timings.
   *
   * @module constants
   */

  /**
   * Time in milliseconds after which the user is considered to have stopped
   * typing.
   *
   * This is used by
   * [KeyboardPrefixCursorMixin](KeyboardPrefixCursorMixin).
   *
   * @const {number} TYPING_TIMEOUT_DURATION
   */
  const TYPING_TIMEOUT_DURATION = 1000;

  // Symbols for private data members on an element.
  const typedPrefixKey = Symbol("typedPrefix");
  const prefixTimeoutKey = Symbol("prefixTimeout");

  /**
   * Lets a user navigate an item cursor by typing the beginning of items
   *
   * Example: suppose a component using this mixin has the following items:
   *
   *     <sample-list-component>
   *       <div>Apple</div>
   *       <div>Apricot</div>
   *       <div>Banana</div>
   *       <div>Blackberry</div>
   *       <div>Blueberry</div>
   *       <div>Cantaloupe</div>
   *       <div>Cherry</div>
   *       <div>Lemon</div>
   *       <div>Lime</div>
   *     </sample-list-component>
   *
   * If this component receives the focus, and the user presses the "b" or "B"
   * key, the item cursor will move to "Banana", because it's the first item that
   * matches the prefix "b". (Matching is case-insensitive.) If the user now
   * presses the "l" or "L" key quickly, the prefix to match becomes "bl", so the
   * cursor will move to "Blackberry".
   *
   * The prefix typing feature has a one second timeout — the prefix to match will
   * be reset after a second has passed since the user last typed a key. If, in
   * the above example, the user waits a second between typing "b" and "l", the
   * prefix will become "l", so the cursor would move to "Lemon".
   *
   * This mixin expects the component to invoke a `keydown` method when a key is
   * pressed. You can use [KeyboardMixin](KeyboardMixin) for that purpose, or wire
   * up your own keyboard handling and call `keydown` yourself.
   *
   * This mixin also expects the component to provide an `items` property. The
   * `textContent` of those items will be used for purposes of prefix matching.
   *
   * @module KeyboardPrefixCursorMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function KeyboardPrefixCursorMixin(Base) {
    // The class prototype added by the mixin.
    class KeyboardPrefixCursor extends Base {
      constructor() {
        // @ts-ignore
        super();
        resetTypedPrefix(this);
      }

      /**
       * Go to the first item whose text content begins with the given prefix.
       *
       * @param {string} prefix - The prefix string to search for
       * @returns {boolean}
       */
      [goToItemWithPrefix](prefix) {
        if (super[goToItemWithPrefix]) {
          super[goToItemWithPrefix](prefix);
        }
        if (prefix == null || prefix.length === 0) {
          return false;
        }
        // Find item that begins with the prefix. Ignore case.
        const searchText = prefix.toLowerCase();
        /** @type {string[]} */
        const texts = this[state].texts;
        const index = texts.findIndex(text => text.substr(0, prefix.length).toLowerCase() === searchText);
        if (index >= 0) {
          const previousIndex = this[state].currentIndex;
          this[setState]({
            currentIndex: index
          });
          return this[state].currentIndex !== previousIndex;
        } else {
          return false;
        }
      }
      [keydown]( /** @type {KeyboardEvent} */event) {
        let handled;
        switch (event.key) {
          case "Backspace":
            handleBackspace(this);
            handled = true;
            break;
          case "Escape":
            // Pressing Escape lets user quickly start typing a new prefix.
            resetTypedPrefix(this);
            break;
          default:
            if (!event.ctrlKey && !event.metaKey && !event.altKey && event.key.length === 1) {
              handlePlainCharacter(this, event.key);
            }
        }

        // Prefer mixin result if it's defined, otherwise use base result.
        return handled || super[keydown] && super[keydown](event);
      }
    }
    return KeyboardPrefixCursor;
  }

  /**
   * Handle the Backspace key: remove the last character from the prefix.
   *
   * @private
   * @param {ReactiveElement} element
   */
  function handleBackspace(element) {
    /** @type {any} */const cast = element;
    const length = cast[typedPrefixKey] ? cast[typedPrefixKey].length : 0;
    if (length > 0) {
      cast[typedPrefixKey] = cast[typedPrefixKey].substr(0, length - 1);
    }
    element[goToItemWithPrefix](cast[typedPrefixKey]);
    setPrefixTimeout(element);
  }

  /**
   * Add a plain character to the prefix.
   *
   * @private
   * @param {ReactiveElement} element
   * @param {string} char
   */
  function handlePlainCharacter(element, char) {
    /** @type {any} */const cast = element;
    const prefix = cast[typedPrefixKey] || "";
    cast[typedPrefixKey] = prefix + char;
    element[goToItemWithPrefix](cast[typedPrefixKey]);
    setPrefixTimeout(element);
  }

  /**
   * Stop listening for typing.
   *
   * @private
   * @param {ReactiveElement} element
   */
  function resetPrefixTimeout(element) {
    /** @type {any} */const cast = element;
    if (cast[prefixTimeoutKey]) {
      clearTimeout(cast[prefixTimeoutKey]);
      cast[prefixTimeoutKey] = false;
    }
  }

  /**
   * Clear the prefix under construction.
   *
   * @private
   * @param {ReactiveElement} element
   */
  function resetTypedPrefix(element) {
    /** @type {any} */element[typedPrefixKey] = "";
    resetPrefixTimeout(element);
  }

  /**
   * Wait for the user to stop typing.
   *
   * @private
   * @param {ReactiveElement} element
   */
  function setPrefixTimeout(element) {
    resetPrefixTimeout(element);
    /** @type {any} */
    element[prefixTimeoutKey] = setTimeout(() => {
      resetTypedPrefix(element);
    }, TYPING_TIMEOUT_DURATION);
  }

  /**
   * Lets an element determine whether it resides in right-to-left text.
   *
   * @module LanguageDirectionMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function LanguageDirectionMixin(Base) {
    // The class prototype added by the mixin.
    return class LanguageDirection extends Base {
      // The only way to get text direction is to wait for the component to
      // connect and then inspect the computed style on its root element. We set
      // state before calling super so the new state will be included when
      // ReactiveMixin calls render.
      connectedCallback() {
        /** @type {any} */const element = this;
        const languageDirection = getComputedStyle(element).direction;
        const rightToLeft = languageDirection === "rtl";
        this[setState]({
          rightToLeft
        });
        super.connectedCallback();
      }
    };
  }

  /**
   * Treats an element's content nodes as list items.
   *
   * Items differ from nodes contents in several ways:
   *
   * * They are often referenced via index.
   * * They may have a selection state.
   * * It's common to do work to initialize the appearance or state of a new
   *   item.
   * * Text nodes are filtered out.
   * * Auxiliary invisible child elements are filtered out and not counted as
   *   items. Auxiliary elements include link, script, style, and template
   *   elements. This filtering ensures that those auxiliary elements can be
   *   used in markup inside of a list without being treated as list items.
   *
   * This mixin expects a component to provide a `content` state member returning
   * a raw set of elements. You can provide that yourself, or use
   * [SlotContentMixin](SlotContentMixin).
   *
   * Most Elix [elements](elements) use `ContentItemsMixin`, including
   * [ListBox](ListBox), [Modes](Modes), and [Tabs](Tabs).
   *
   * @module ContentItemsMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function ContentItemsMixin(Base) {
    return class ContentItems extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          items: null
        });
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // Regenerate items when content changes.
        if (changed.content) {
          /** @type {Node[]} */const content = state.content;
          const items = content ? Array.prototype.filter.call(content, ( /** @type {Node} */item) => isSubstantiveElement(item)) : null;
          if (items) {
            Object.freeze(items);
          }
          Object.assign(effects, {
            items
          });
        }
        return effects;
      }
    };
  }

  /**
   * Defines a component's content as the flattened set of nodes assigned to a
   * slot.
   *
   * This mixin defines a component's `content` state member as the flattened
   * set of nodes assigned to a slot, typically the default slot.
   *
   * If the set of assigned nodes changes, the `content` state will be updated.
   * This helps a component satisfy the Gold Standard checklist item for
   * monitoring
   * [Content Changes](https://github.com/webcomponents/gold-standard/wiki/Content-Changes).
   *
   * By default, the mixin looks in the component's shadow subtree for a default
   * (unnamed) `slot` element. You can specify that a different slot should be
   * used by overriding the `internal.contentSlot` property.
   *
   * Most Elix [elements](elements) use `SlotContentMixin`, including
   * [ListBox](ListBox), [Modes](Modes), and [Tabs](Tabs).
   *
   * @module SlotContentMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function SlotContentMixin(Base) {
    // The class prototype added by the mixin.
    class SlotContent extends Base {
      /**
       * See [contentSlot](internal#internal.contentSlot).
       */
      get [contentSlot]() {
        /** @type {HTMLSlotElement|null} */const slot = this[shadowRoot] && this[shadowRoot].querySelector("slot:not([name])");
        if (!this[shadowRoot] || !slot) {
          /* eslint-disable no-console */
          console.warn(`SlotContentMixin expects ${this.constructor.name} to define a shadow tree that includes a default (unnamed) slot.\nSee https://elix.org/documentation/SlotContentMixin.`);
        }
        return slot;
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          content: null
        });
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (this[firstRender]) {
          // Listen to changes on the default slot.
          const slot = this[contentSlot];
          if (slot) {
            slot.addEventListener("slotchange", async () => {
              // Although slotchange isn't generally a user-driven event, it's
              // impossible for us to know whether a change in slot content is going
              // to result in effects that the host of this element can predict.
              // To be on the safe side, we raise any change events that come up
              // during the processing of this event.
              this[raiseChangeEvents] = true;

              // The nodes assigned to the given component have changed.
              // Update the component's state to reflect the new content.
              const content = slot.assignedNodes({
                flatten: true
              });
              Object.freeze(content);
              this[setState]({
                content
              });
              await Promise.resolve();
              this[raiseChangeEvents] = false;
            });
          }
        }
      }
    }
    return SlotContent;
  }

  /**
   * Treats the elements assigned to the default slot as list items
   *
   * This is simply a combination of
   * [ContentItemsMixin](ContentItemsMixin) and
   * [SlotContentMixin](SlotContentMixin).
   *
   * @module SlotItemsMixin
   * @mixes ContentItemsMixin
   * @mixes SlotContentMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function SlotItemsMixin(Base) {
    return ContentItemsMixin(SlotContentMixin(Base));
  }

  /**
   * A tap/mousedown on a list item makes that item current.
   *
   * This simple mixin is useful in list-like elements like [ListBox](ListBox),
   * where a tap/mousedown on a list item implicitly selects it.
   *
   * The standard use for this mixin is in list-like elements. Native list
   * boxes don't appear to be consistent with regard to whether they select
   * on mousedown or click/mouseup. This mixin assumes the use of mousedown.
   * On touch devices, that event appears to trigger when the touch is *released*.
   *
   * This mixin only listens to mousedown events for the primary mouse button
   * (typically the left button). Right clicks are ignored so that the browser may
   * display a context menu.
   *
   * This mixin expects the component to provide an `state.items` member. It also
   * expects the component to define a `state.currentIndex` member; you can
   * provide that yourself, or use [ItemsCursorMixin](ItemsCursorMixin).
   *
   * If the component receives an event that doesn't correspond to an item (e.g.,
   * the user taps on the element background visible between items), the cursor
   * will be removed. However, if the component sets `state.currentItemRequired` to
   * true, a background tap will *not* remove the cursor.
   *
   * @module TapCursorMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function TapCursorMixin(Base) {
    // The class prototype added by the mixin.
    return class TapCursor extends Base {
      constructor() {
        // @ts-ignore
        super();
        this.addEventListener("mousedown", event => {
          // Only process events for the main (usually left) button.
          if (event.button !== 0) {
            return;
          }
          this[raiseChangeEvents] = true;
          this[tap](event);
          this[raiseChangeEvents] = false;
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          Object.assign(this.style, {
            touchAction: "manipulation",
            // for iOS Safari
            mozUserSelect: "none",
            msUserSelect: "none",
            webkitUserSelect: "none",
            userSelect: "none"
          });
        }
      }
      [tap]( /** @type {MouseEvent} */event) {
        // In some situations, the event target will not be the child which was
        // originally clicked on. E.g., if the item clicked on is a button, the
        // event seems to be raised in phase 2 (AT_TARGET) — but the event target
        // will be the component, not the item that was clicked on. Instead of
        // using the event target, we get the first node in the event's composed
        // path.
        // @ts-ignore
        const target = event.composedPath ? event.composedPath()[0] : event.target;

        // Find which item was clicked on and, if found, make it current. Ignore
        // clicks on disabled items.
        //
        // For elements which don't require a cursor, a background click will
        // determine the item was null, in which we case we'll remove the cursor.
        const {
          items,
          currentItemRequired
        } = this[state];
        if (items && target instanceof Node) {
          const targetIndex = indexOfItemContainingTarget(items, target);
          const item = targetIndex >= 0 ? items[targetIndex] : null;
          if (item && !item.disabled || !item && !currentItemRequired) {
            this[setState]({
              currentIndex: targetIndex
            });
            event.stopPropagation();
          }
        }
      }
    };
  }

  const Base$8 = AriaMenuMixin(CursorAPIMixin(CursorInViewMixin(DelegateFocusMixin(DirectionCursorMixin(ItemsAPIMixin(ItemsCursorMixin(ItemsTextMixin(KeyboardDirectionMixin(KeyboardMixin(KeyboardPagedCursorMixin(KeyboardPrefixCursorMixin(LanguageDirectionMixin(SlotItemsMixin(TapCursorMixin(ReactiveElement)))))))))))))));

  /**
   * A menu of choices or commands
   *
   * This holds the contents of the menu, not the top-level UI element that invokes
   * a menu. For that, see [MenuButton](MenuButton) or [PopupSource](PopupSource).
   *
   * @inherits ReactiveElement
   * @mixes AriaMenuMixin
   * @mixes CursorInViewMixin
   * @mixes CursorAPIMixin
   * @mixes DelegateFocusMixin
   * @mixes DirectionCursorMixin
   * @mixes ItemsAPIMixin
   * @mixes ItemsCursorMixin
   * @mixes ItemsTextMixin
   * @mixes KeyboardDirectionMixin
   * @mixes KeyboardMixin
   * @mixes KeyboardPagedCursorMixin
   * @mixes KeyboardPrefixCursorMixin
   * @mixes LanguageDirectionMixin
   * @mixes SingleSelectAPIMixin
   * @mixes SlotItemsMixin
   * @mixes TapCursorMixin
   */
  class Menu extends Base$8 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        availableItemFlags: null,
        handleBubblingDirectionKeys: true,
        highlightCurrentItem: true,
        orientation: "vertical",
        currentItemFocused: false
      });
    }

    /**
     * Flash the current item.
     *
     * By default, this uses a heuristic to guess whether the menu was closed by a
     * keyboard or mouse (on desktop). If so, the menu flashes the current item
     * off then back on, emulating the menu item selection effect in macOS.
     * Otherwise, it does nothing.
     */
    async flashCurrentItem() {
      const keyboardActive = this[state].focusVisible;
      const probablyDesktop = matchMedia("(pointer: fine)").matches;
      if (keyboardActive || probablyDesktop) {
        const flashDuration = 75; // milliseconds
        this[setState]({
          highlightCurrentItem: false
        });
        await new Promise(resolve => setTimeout(resolve, flashDuration));
        this[setState]({
          highlightCurrentItem: true
        });
        await new Promise(resolve => setTimeout(resolve, flashDuration));
      }
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      if (this[firstRender]) {
        // Listen to changes in disabled state.
        this.addEventListener("disabledchange", event => {
          this[raiseChangeEvents] = true;
          /** @type {any} */
          const target = event.target;
          const {
            items
          } = this[state];
          const index = items === null ? -1 : items.indexOf(target);
          if (index >= 0) {
            // Update item availability.
            const availableItemFlags = this[state].availableItemFlags.slice();
            availableItemFlags[index] = !target.disabled;
            this[setState]({
              availableItemFlags
            });
          }
          this[raiseChangeEvents] = false;
        });

        // Treat a pointerdown event as a tap.
        if ("PointerEvent" in window) {
          // Prefer listening to standard pointer events.
          this.addEventListener("pointerdown", event => this[tap](event));
        } else {
          this.addEventListener("touchstart", event => this[tap](event));
        }
        this.removeAttribute("tabindex");
      }
      const {
        currentIndex,
        items
      } = this[state];

      // Highlight the current item.
      if ((changed.items || changed.currentIndex || changed.highlightCurrentItem) && items) {
        const {
          highlightCurrentItem
        } = this[state];
        items.forEach((item, index) => {
          item.toggleAttribute("current", highlightCurrentItem && index === currentIndex);
        });
      }
      if ((changed.items || changed.currentIndex || changed.currentItemFocused || changed.focusVisible) && items) {
        // A menu has a complicated focus arrangement in which the current item has
        // focus, which means it needs a tabindex. However, we don't want any other
        // item in the menu to have a tabindex, so that if the user presses Tab or
        // Shift+Tab, they move away from the menu entirely (rather than just moving
        // to the next or previous item).
        //
        // That's already complex, but to make things worse, if we remove the
        // tabindex from an item that has the focus, the focus gets moved to the
        // document. In popup menus, the popup will conclude it's lost the focus,
        // and implicitly close. So we want to move the focus in two phases: 1)
        // set tabindex on a newly-current item so we can focus on it, 2) after
        // the new item has been focused, remove the tabindex from any
        // previous item.
        items.forEach((item, index) => {
          const current = index === currentIndex;
          const isDefaultFocusableItem = currentIndex < 0 && index === 0;
          if (!this[state].currentItemFocused) {
            // Phase 1: Add tabindex to newly-current item.
            if (current || isDefaultFocusableItem) {
              item.tabIndex = 0;
            }
          } else {
            // Phase 2: Remove tabindex from any previous item.
            if (!(current || isDefaultFocusableItem)) {
              item.removeAttribute("tabindex");
            }
          }
        });
      }
    }
    [rendered]( /** @type {ChangedFlags} */changed) {
      super[rendered](changed);
      if (!this[firstRender] && changed.currentIndex && !this[state].currentItemFocused) {
        // The current item needs the focus, but this is complicated. See notes
        // in render.
        const {
          currentItem
        } = this[state];
        const focusElement = currentItem instanceof HTMLElement ? currentItem : this;
        focusElement.focus();

        // Now that the current item has been focused, we can remove/reset the
        // tabindex on any item that had previously been current.
        this[setState]({
          currentItemFocused: true
        });
      }
    }

    // @ts-ignore
    get [scrollTarget]() {
      return this[ids].content;
    }
    [stateEffects](state, changed) {
      const effects = super[stateEffects](state, changed);

      // When current item changes, we'll need to focus on it in rendered.
      if (changed.currentIndex) {
        Object.assign(effects, {
          currentItemFocused: false
        });
      }

      // Mark disabled items as unavailable.
      if (changed.items) {
        const {
          items
        } = state;
        const availableItemFlags = items === null ? null : items.map(item => !item.disabled);
        Object.assign(effects, {
          availableItemFlags
        });
      }
      return effects;
    }
    get [template$g]() {
      return templateFrom.html`
      <style>
        :host {
          box-sizing: border-box;
          cursor: default;
          display: inline-flex;
          -webkit-tap-highlight-color: transparent;
          touch-action: manipulation;
        }

        #content {
          display: flex;
          flex: 1;
          flex-direction: column;
          max-height: 100%;
          overflow-x: hidden;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch; /* for momentum scrolling */
        }
        
        ::slotted(*) {
          flex-shrink: 0;
          outline: none;
          touch-action: manipulation;
        }

        ::slotted(option) {
          font: inherit;
          min-height: inherit;
        }
      </style>
      <div id="content" role="none">
        <slot></slot>
      </div>
    `;
    }
  }

  const documentMouseupListenerKey = Symbol("documentMouseupListener");

  /**
   * Add drag-select behavior to an element with a popup.
   *
   * This allows a user to mouse down on a popup source, drag into the resulting
   * popup, and release the mouse to select something in the popup. This can be
   * used in conjunction with [PopupListMixin](PopupListMixin).
   *
   * @module PopupDragSelectMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function PopupDragSelectMixin(Base) {
    // The class prototype added by the mixin.
    class PopupDragSelect extends Base {
      connectedCallback() {
        super.connectedCallback();
        // Handle edge case where component is opened, removed, then added back.
        listenIfOpenAndConnected$1(this);
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          dragSelect: true
        });
      }
      disconnectedCallback() {
        if (super.disconnectedCallback) {
          super.disconnectedCallback();
        }
        listenIfOpenAndConnected$1(this);
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        super[rendered](changed);
        if (changed.opened) {
          listenIfOpenAndConnected$1(this);
        }
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects](state, changed);

        // Set things when opening, or reset things when closing.
        if (changed.opened) {
          if (state.opened) {
            // Opening
            Object.assign(effects, {
              // Until we get a mouseup, we're doing a drag-select.
              dragSelect: true
            });
          }
        }
        return effects;
      }
    }
    return PopupDragSelect;
  }
  async function handleMouseup( /** @type {MouseEvent} */event) {
    // @ts-ignore
    const element = this;
    const hitTargets = element[shadowRoot].elementsFromPoint(event.clientX, event.clientY);
    if (element.opened) {
      // Was mouseup over source part?
      const overSource = hitTargets.indexOf(element[ids].source) >= 0;

      // Was mouseup over the popup or popup frame?
      const popup = element[ids].popup;
      const overPopup = hitTargets.indexOf(popup) >= 0;
      const overPopupFrame = popup.frame && hitTargets.indexOf(popup.frame) >= 0;
      if (overSource) {
        // User released the mouse over the source button (behind the
        // backdrop), so we're no longer doing a drag-select.
        if (element[state].dragSelect) {
          element[raiseChangeEvents] = true;
          element[setState]({
            dragSelect: false
          });
          element[raiseChangeEvents] = false;
        }
      } else if (!(overPopup || overPopupFrame)) {
        // If we get to this point, the user released over the backdrop with
        // the popup open, so close.
        element[raiseChangeEvents] = true;
        await element.close();
        element[raiseChangeEvents] = false;
      }
    }
  }
  function listenIfOpenAndConnected$1(element) {
    if (element[state].opened && element.isConnected) {
      // If the popup is open and user releases the mouse over the backdrop, we
      // want to close the popup. We need to listen to mouseup on the document,
      // not this element. If the user mouses down on the source, then moves the
      // mouse off the document before releasing the mouse, the element itself
      // won't get the mouseup. The document will, however, so it's a more
      // reliable source of mouse state.
      //
      // Coincidentally, we *also* need to listen to mouseup on the document to
      // tell whether the user released the mouse over the source button. When the
      // user mouses down, the backdrop will appear and cover the source, so from
      // that point on the source won't receive a mouseup event. Again, we can
      // listen to mouseup on the document and do our own hit-testing to see if
      // the user released the mouse over the source.
      if (!element[documentMouseupListenerKey]) {
        // Not listening yet; start.
        element[documentMouseupListenerKey] = handleMouseup.bind(element);
        document.addEventListener("mouseup", element[documentMouseupListenerKey]);
      }
    } else if (element[documentMouseupListenerKey]) {
      // Currently listening; stop.
      document.removeEventListener("mouseup", element[documentMouseupListenerKey]);
      element[documentMouseupListenerKey] = null;
    }
  }

  /**
   * Function for positioning a popup relative to a source element.
   *
   * @module positionPopup
   */

  /**
   * Given an (x, y) origin point, a bounding rectangle, and a layout, return the
   * height and width of the available space in the quadrant used by that layout.
   *
   * @private
   * @param {DOMRect} sourceRect
   * @param {DOMRect} boundsRect
   */
  function availableSpace(sourceRect, boundsRect, direction, align) {
    const sourceOrigin = getSourceOrigin(sourceRect, direction, align);
    let height = 0;
    let width = 0;
    const vertical = direction === "above" || direction === "below";
    switch (direction) {
      case "above":
        height = sourceOrigin.y - boundsRect.top;
        break;
      case "below":
        height = boundsRect.bottom - sourceOrigin.y;
        break;
      case "left":
        width = sourceOrigin.x - boundsRect.left;
        break;
      case "right":
        width = boundsRect.right - sourceOrigin.x;
        break;
    }
    switch (align) {
      case "bottom":
        height = sourceOrigin.y - boundsRect.top;
        break;
      case "center":
        if (vertical) {
          width = boundsRect.width;
        } else {
          height = boundsRect.height;
        }
        break;
      case "stretch":
        if (vertical) {
          width = sourceRect.width;
        } else {
          height = sourceRect.height;
        }
        break;
      case "left":
        width = boundsRect.right - sourceOrigin.x;
        break;
      case "right":
        width = sourceOrigin.x - boundsRect.left;
        break;
      case "top":
        height = boundsRect.bottom - sourceOrigin.y;
        break;
    }
    height = Math.max(0, height);
    width = Math.max(0, width);
    return {
      height,
      width
    };
  }

  /**
   * Given two layouts, return -1 if the first is better, 1 if the second is
   * better, and 0 if they're equally good.
   *
   * Our comparison uses a heuristic that looks to see whether a layout can fit
   * the popup in height, width, or both. A layout is best if it fits both height
   * and width. If each layout only fits one dimension, then the layout that gives
   * the popup more space is preferred.
   *
   * @private
   * @param {DOMRect} sourceRect
   * @param {DOMRect} popupRect
   * @param {DOMRect} boundsRect
   */
  function compareLayouts(layout1, layout2, sourceRect, popupRect, boundsRect) {
    const space1 = availableSpace(sourceRect, boundsRect, layout1.direction, layout1.align);
    const space2 = availableSpace(sourceRect, boundsRect, layout2.direction, layout2.align);
    const fitsWidth1 = popupRect.width <= space1.width;
    const fitsHeight1 = popupRect.height <= space1.height;
    const fitsEither1 = fitsWidth1 || fitsHeight1;
    const fitsBoth1 = fitsWidth1 && fitsHeight1;
    const fitsWidth2 = popupRect.width <= space2.width;
    const fitsHeight2 = popupRect.height <= space2.height;
    const fitsEither2 = fitsWidth2 || fitsHeight2;
    const fitsBoth2 = fitsWidth2 && fitsHeight2;
    const area1 = space1.width * space1.height;
    const area2 = space2.width * space2.height;
    if (fitsBoth1 && fitsBoth2) {
      // Both layouts can fit in both dimensions; they're equally good.
      return 0;
    } else if (fitsBoth1) {
      // Layout 1 has space for popup in both dimensions.
      return -1;
    } else if (fitsBoth2) {
      // Layout 2 has space for popup in both dimensions.
      return 1;
    } else if (fitsEither1 && !fitsEither2) {
      // Layout 1 fits in one dimension, layout 2 doesn't fit either.
      return -1;
    } else if (fitsEither2 && !fitsEither1) {
      // Layout 2 fits in one dimensions, layout 1 doesn't fit either.
      return 1;
    } else if (fitsEither1 && area1 > area2) {
      // Layout 1 fits in one dimension and gives popup more space.
      return -1;
    } else if (fitsEither2 && area2 > area1) {
      // Layout 2 fits in one dimension and gives popup more space.
      return 1;
    } else if (area1 > area2) {
      // Layout 1 gives popup more space.
      return -1;
    } else if (area2 > area1) {
      // Layout 2 gives popup more space.
      return 1;
    } else {
      // Layouts equally good or bad.
      return 0;
    }
  }

  /**
   * Determine the (x, y) location at which the popup should be positioned to
   * touch the indicated source origin point.
   *
   * @private
   * @param {DOMRect} sourceRect
   * @param {DOMRect} popupRect
   * @param {DOMRect} boundsRect
   */
  function getPositionedRect(sourceRect, popupRect, boundsRect, direction, align) {
    // With respect to which point on the source will we position the popup?
    const sourceOrigin = getSourceOrigin(sourceRect, direction, align);

    // We'll adjust our bounds depending upon the layout.
    let {
      x: boundsLeft,
      y: boundsTop,
      bottom: boundsBottom,
      right: boundsRight
    } = boundsRect;
    let x = 0;
    let y = 0;
    let height = popupRect.height;
    let width = popupRect.width;
    const vertical = direction === "above" || direction === "below";
    switch (direction) {
      case "above":
        y = sourceOrigin.y - popupRect.height;
        boundsBottom = sourceOrigin.y;
        break;
      case "below":
        y = sourceOrigin.y;
        boundsTop = sourceOrigin.y;
        break;
      case "left":
        x = sourceOrigin.x - popupRect.width;
        boundsRight = sourceOrigin.x;
        break;
      case "right":
        x = sourceOrigin.x;
        boundsLeft = sourceOrigin.x;
        break;
    }
    switch (align) {
      case "bottom":
        y = sourceOrigin.y - popupRect.height;
        boundsBottom = sourceOrigin.y;
        break;
      case "left":
        x = sourceOrigin.x;
        boundsLeft = sourceOrigin.x;
        break;
      case "center":
        if (vertical) {
          x = sourceOrigin.x - popupRect.width / 2;
        } else {
          y = sourceOrigin.y - popupRect.height / 2;
        }
        break;
      case "right":
        x = sourceOrigin.x - popupRect.width;
        boundsRight = sourceOrigin.x;
        break;
      case "stretch":
        if (vertical) {
          x = sourceOrigin.x;
          width = sourceRect.width;
        } else {
          y = sourceOrigin.y;
          height = sourceRect.height;
        }
        break;
      case "top":
        y = sourceOrigin.y;
        boundsTop = sourceOrigin.y;
        break;
    }

    // Force the desired rectangle to fit within the bounds.
    x = Math.max(x, boundsLeft);
    y = Math.max(y, boundsTop);
    width = Math.min(width, boundsRight - x);
    height = Math.min(height, boundsBottom - y);
    return new DOMRect(x, y, width, height);
  }

  /**
   * For a given layout, we will use a different point on the source element as a
   * reference point to position the popup. Return that (x, y) point.
   *
   * @private
   * @param {DOMRect} sourceRect
   */
  function getSourceOrigin(sourceRect, direction, align) {
    let x = 0;
    let y = 0;
    const vertical = direction === "above" || direction === "below";
    switch (direction) {
      case "above":
        y = sourceRect.top;
        break;
      case "below":
        y = sourceRect.bottom;
        break;
      case "left":
      case "right":
        x = sourceRect[direction];
        break;
    }
    switch (align) {
      case "bottom":
      case "top":
        y = sourceRect[align];
        break;
      case "left":
      case "right":
        x = sourceRect[align];
        break;
      case "center":
        if (vertical) {
          x = sourceRect.left + sourceRect.width / 2;
        } else {
          y = sourceRect.top + sourceRect.height / 2;
        }
        break;
      case "stretch":
        if (vertical) {
          x = sourceRect.left;
        } else {
          y = sourceRect.top;
        }
        break;
    }
    return {
      x,
      y
    };
  }

  /**
   * Return the optimum layout for the popup element with respect to a source
   * element that fits in the given bounds.
   *
   * @param {DOMRect} sourceRect
   * @param {DOMRect} popupRect
   * @param {DOMRect} boundsRect
   * @param {any} options
   */
  function layoutPopup(sourceRect, popupRect, boundsRect, options) {
    const normalized = normalizeOptions(options);

    // Given the direction and alignment, which layouts do we want to consider?
    const layouts = prioritizedLayouts(normalized.direction, normalized.align);

    // Sort layouts by our heuristic.
    layouts.sort((layout1, layout2) => compareLayouts(layout1, layout2, sourceRect, popupRect, boundsRect));

    // Take the best layout.
    const layout = layouts[0];

    // Find the positioned rect with respect to the source origin.
    layout.rect = getPositionedRect(sourceRect, popupRect, boundsRect, layout.direction, layout.align);
    return layout;
  }

  // Normalize the popup options. Convert any logical layout options (start, end)
  // to physical options (e.g., left, right). Replace any unknown option values
  // with defaults.
  function normalizeOptions(options) {
    const {
      align: logicalAlign,
      direction: logicalDirection,
      rightToLeft
    } = options;
    const defaultDirection = "below";
    const physicalDirection = {
      above: "above",
      below: "below",
      column: "below",
      "column-reverse": "above",
      left: "left",
      right: "right",
      row: rightToLeft ? "left" : "right",
      "row-reverse": rightToLeft ? "right" : "left"
    }[logicalDirection] || defaultDirection;
    const crossAxis = {
      above: "horizontal",
      below: "horizontal",
      left: "vertical",
      right: "vertical"
    }[physicalDirection];
    const defaultAlign = {
      horizontal: "left",
      vertical: "top"
    }[crossAxis];
    const physicalAlign = {
      horizontal: {
        center: "center",
        end: rightToLeft ? "left" : "right",
        left: "left",
        right: "right",
        start: rightToLeft ? "right" : "left",
        stretch: "stretch"
      },
      vertical: {
        bottom: "bottom",
        center: "center",
        end: "bottom",
        start: "top",
        stretch: "stretch",
        top: "top"
      }
    }[crossAxis][logicalAlign] || defaultAlign;
    return {
      align: physicalAlign,
      direction: physicalDirection,
      rightToLeft
    };
  }

  // Given a preferred direction and alignment, determine the set of 2 or 4 layout
  // alternatives that should be considered, in priority order.
  function prioritizedLayouts(preferredDirection, preferredAlign) {
    const flipDirection = {
      above: "below",
      below: "above",
      left: "right",
      right: "left"
    };
    const flipAlign = {
      top: "bottom",
      bottom: "top",
      left: "right",
      right: "left"
    };

    // Our first choice of layout will be the preferred options.
    const possibilties = [{
      align: preferredAlign,
      direction: preferredDirection
    }];
    if (preferredAlign === "center" || preferredAlign === "stretch") {
      // Center/stretch align only needs to consider flipping over main axis.
      possibilties.push({
        align: preferredAlign,
        direction: flipDirection[preferredDirection]
      });
    } else {
      // Consider possibilities of flipping on either axis or both.
      possibilties.push({
        align: flipAlign[preferredAlign],
        direction: preferredDirection
      });
      possibilties.push({
        align: preferredAlign,
        direction: flipDirection[preferredDirection]
      });
      possibilties.push({
        align: flipAlign[preferredAlign],
        direction: flipDirection[preferredDirection]
      });
    }
    return possibilties;
  }

  /** @type {any} */
  const closePromiseKey = Symbol("closePromise");
  /** @type {any} */
  const closeResolveKey = Symbol("closeResolve");

  /**
   * Tracks the open/close state of a component.
   *
   * @module OpenCloseMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function OpenCloseMixin(Base) {
    // The class prototype added by the mixin.
    class OpenClose extends Base {
      attributeChangedCallback(name, oldValue, newValue) {
        if (name === "opened") {
          const value = booleanAttributeValue(name, newValue);
          if (this.opened !== value) {
            this.opened = value;
          }
        } else {
          super.attributeChangedCallback(name, oldValue, newValue);
        }
      }

      /**
       * Close the component (if not already closed).
       *
       * Some components like [AlertDialog](AlertDialog) want to indicate why or
       * how they were closed. To support such scenarios, you can supply a value
       * to the optional `closeResult` parameter. This closeResult will be made
       * available in the `whenClosed` promise and the `state.closeResult` member.
       *
       * @param {object} [closeResult] - an indication of how or why the element closed
       */
      async close(closeResult) {
        if (super.close) {
          await super.close();
        }
        this[setState]({
          closeResult
        });
        await this.toggle(false);
      }

      /**
       * True if the element is currently closed.
       *
       * This read-only property is provided as a convenient inverse of `opened`.
       *
       * @type {boolean}
       */
      get closed() {
        return this[state] && !this[state].opened;
      }

      /**
       * True if the element has completely closed.
       *
       * For components not using asynchronous open/close effects, this property
       * returns the same value as the `closed` property. For elements that have a
       * true value of `state.openCloseEffects` (e.g., elements using
       * [TransitionEffectMixin](TransitionEffectMixin)), this property returns
       * true only if `state.effect` is "close" and `state.effectPhase` is
       * "after".
       *
       * @type {boolean}
       */
      get closeFinished() {
        return this[state].closeFinished;
      }
      get closeResult() {
        return this[state].closeResult;
      }

      // @ts-ignore
      get [defaultState]() {
        const defaults = {
          closeResult: undefined,
          opened: false
        };
        // If this component defines a `startEffect` method (e.g., by using
        // TransitionEffectMixin), include default state for open/close effects.
        // Since the component is closed by default, the default effect state is
        // after the close effect has completed.
        if (this[startEffect]) {
          Object.assign(defaults, {
            closeFinished: true,
            effect: "close",
            effectPhase: "after",
            openCloseEffects: true
          });
        }
        return Object.assign(super[defaultState] || {}, defaults);
      }

      /**
       * Open the element (if not already opened).
       */
      async open() {
        if (super.open) {
          await super.open();
        }
        await this.toggle(true);
      }

      /**
       * True if the element is currently opened.
       *
       * This property can be set as a boolean attribute
       *
       * @type {boolean}
       * @default false
       */
      get opened() {
        return this[state] && this[state].opened;
      }
      set opened(opened) {
        this[setState]({
          closeResult: undefined
        });
        this.toggle(opened);
      }
      [render](changed) {
        super[render](changed);

        // Reflect opened state.
        if (changed.opened) {
          const {
            opened
          } = this[state];
          setInternalState$2(this, "opened", opened);
        }

        // Reflect closed state. To handle asynchronous close effects, we reflect
        // the inverse of closeFinished instead of reflecting closed.
        if (changed.closeFinished) {
          const {
            closeFinished
          } = this[state];
          setInternalState$2(this, "closed", closeFinished);
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.opened && this[raiseChangeEvents]) {
          /**
           * Raised when the opened/closed state of the component changes.
           *
           * @event openedchange
           */
          const openedChangeEvent = new CustomEvent("openedchange", {
            bubbles: true,
            detail: {
              closeResult: this[state].closeResult,
              opened: this[state].opened
            }
          });
          this.dispatchEvent(openedChangeEvent);
          if (this[state].opened) {
            const oldOpenedEvent = new CustomEvent("opened", {
              bubbles: true
            });
            this.dispatchEvent(oldOpenedEvent);
            /**
             * Raised when the component opens.
             *
             * @event open
             */
            const openEvent = new CustomEvent("open", {
              bubbles: true
            });
            this.dispatchEvent(openEvent);
          } else {
            const oldClosedEvent = new CustomEvent("closed", {
              bubbles: true,
              detail: {
                closeResult: this[state].closeResult
              }
            });
            this.dispatchEvent(oldClosedEvent);
            /**
             * Raised when the component closes.
             *
             * @event close
             */
            const closeEvent = new CustomEvent("close", {
              bubbles: true,
              detail: {
                closeResult: this[state].closeResult
              }
            });
            this.dispatchEvent(closeEvent);
          }
        }

        // If someone's waiting for the component to close, and it's completely
        // finished closing, then resolve the close promise.
        const closeResolve = this[closeResolveKey];
        if (this.closeFinished && closeResolve) {
          this[closeResolveKey] = null;
          this[closePromiseKey] = null;
          closeResolve(this[state].closeResult);
        }
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // If the component is being opened, then clear any previous closeResult.
        if (changed.opened && state.opened) {
          Object.assign(effects, {
            closeResult: undefined
          });
        }

        // Update our notion of closeFinished to track the closed state for
        // components with synchronous open/close effects and components with
        // asynchronous open/close effects.
        if (changed.openCloseEffects || changed.effect || changed.effectPhase || changed.opened) {
          const {
            effect,
            effectPhase,
            openCloseEffects,
            opened
          } = state;
          const closeFinished = openCloseEffects ? effect === "close" && effectPhase === "after" : !opened;
          Object.assign(effects, {
            closeFinished
          });
        }
        return effects;
      }

      /**
       * Toggle the open/close state of the element.
       *
       * @param {boolean} [opened] - true if the element should be opened, false
       * if closed.
       */
      async toggle() {
        let opened = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : !this.opened;
        if (super.toggle) {
          await super.toggle(opened);
        }
        const changed = opened !== this[state].opened;
        if (changed) {
          /** @type {PlainObject} */const changes = {
            opened
          };
          if (this[state].openCloseEffects) {
            changes.effect = opened ? "open" : "close";
            if (this[state].effectPhase === "after") {
              changes.effectPhase = "before";
            }
          }
          await this[setState](changes);
        }
      }

      /**
       * This method can be used as an alternative to listening to the
       * "openedchange" event, particularly in situations where you want to only
       * handle the next time the component is closed.
       *
       * @returns {Promise} A promise that resolves when the element has
       * completely closed, including the completion of any asynchronous opening
       * effect.
       */
      whenClosed() {
        if (!this[closePromiseKey]) {
          this[closePromiseKey] = new Promise(resolve => {
            this[closeResolveKey] = resolve;
          });
        }
        return this[closePromiseKey];
      }
    }
    return OpenClose;
  }

  /**
   * Lets a component define its ARIA role through a `role` state member
   *
   * Among other things, this allows a class or mixin to define a default
   * role through the component's `defaultState`.
   *
   * Some mixins come with identicial support for managing an ARIA role. Those
   * mixins include [AriaListMixin](AriaListMixin),
   * [AriaMenuMixin](AriaMenuMixin), [DialogModalityMixin](DialogModalityMixin),
   * and [PopupModalityMixin](PopupModalityMixin). If you're using one of those
   * mixins, you do *not* need to use this mixin.
   *
   * @module AriaRoleMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function AriaRoleMixin(Base) {
    // The class prototype added by the mixin.
    class AriaRole extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          role: null
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (changed.role) {
          // Apply top-level role.
          const {
            role
          } = this[state];
          if (role) {
            this.setAttribute("role", role);
          } else {
            this.removeAttribute("role");
          }
        }
      }

      // Setting the standard role attribute will invoke this property setter,
      // which will allow us to update our state.
      get role() {
        return super.role;
      }
      set role(role) {
        const s = String(role);
        super.role = s;
        if (!this[rendering]) {
          this[setState]({
            s
          });
        }
      }
    }
    return AriaRole;
  }

  const Base$7 = AriaRoleMixin(ReactiveElement);

  /**
   * Background element shown behind an overlay's primary content
   *
   * The backdrop is transparent by default, suggesting to the user that the
   * overlay is modeless, and they can click through it to reach the background
   * elements. For a modal variant, see [ModalBackdrop](ModalBackdrop).
   *
   * @inherits ReactiveElement
   * @mixes AriaRoleMixin
   */
  class Backdrop extends Base$7 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        role: "none"
      });
    }
    get [template$g]() {
      return templateFrom.html`
      <style>
        :host {
          display: inline-block;
          height: 100%;
          left: 0;
          position: fixed;
          top: 0;
          touch-action: manipulation;
          width: 100%;
        }
      </style>
      <slot></slot>
    `;
    }
  }

  /**
   * A simple frame for overlay content.
   *
   * The default appearance of `OverlayFrame` uses a simple drop-shadow to let the
   * user see the framed content as being on top of the background page content.
   *
   * @inherits ReactiveElement
   */
  class OverlayFrame extends ReactiveElement {
    get [template$g]() {
      return templateFrom.html`
      <style>
        :host {
          display: inline-block;
          position: relative;
        }
      </style>
      <slot></slot>
    `;
    }
  }

  /** @type {any} */
  const appendedToDocumentKey = Symbol("appendedToDocument");
  /** @type {any} */
  const defaultZIndexKey = Symbol("assignedZIndex");
  /** @type {any} */
  const restoreFocusToElementKey = Symbol("restoreFocusToElement");

  /**
   * Displays an opened element on top of other page elements.
   *
   * This mixin handles showing and hiding an overlay element. It, together with
   * [OpenCloseMixin](OpenCloseMixin), form the core behavior for [Overlay](Overlay),
   * which in turn forms the basis of Elix's overlay components.
   *
   * @module OverlayMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function OverlayMixin(Base) {
    // The class prototype added by the mixin.
    class Overlay extends Base {
      // TODO: Document
      get autoFocus() {
        return this[state].autoFocus;
      }
      set autoFocus(autoFocus) {
        this[setState]({
          autoFocus
        });
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          autoFocus: true,
          persistent: false
        });
      }
      async open() {
        if (!this[state].persistent && !this.isConnected) {
          // Overlay isn't in document yet.
          this[appendedToDocumentKey] = true;
          document.body.append(this);
        }
        if (super.open) {
          await super.open();
        }
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          this.addEventListener("blur", event => {
            // What has the focus now?
            const newFocusedElement = event.relatedTarget || document.activeElement;
            /** @type {any} */
            const node = this;
            if (newFocusedElement instanceof HTMLElement) {
              const focusInside = deepContains(node, newFocusedElement);
              if (!focusInside) {
                if (this.opened) {
                  // The user has most likely clicked on something in the background
                  // of a modeless overlay. Remember that element, and restore focus
                  // to it when the overlay finishes closing.
                  this[restoreFocusToElementKey] = newFocusedElement;
                } else {
                  // A blur event fired, but the overlay closed itself before the blur
                  // event could be processed. In closing, we may have already
                  // restored the focus to the element that originally invoked the
                  // overlay. Since the user has clicked somewhere else to close the
                  // overlay, put the focus where they wanted it.
                  newFocusedElement.focus();
                  this[restoreFocusToElementKey] = null;
                }
              }
            }
          });
        }
        if (changed.effectPhase || changed.opened || changed.persistent) {
          if (!this[state].persistent) {
            // Temporary overlay
            const closed = typeof this.closeFinished === "undefined" ? this.closed : this.closeFinished;
            if (closed) {
              if (this[defaultZIndexKey]) {
                // Remove default z-index.
                this.style.zIndex = "";
                this[defaultZIndexKey] = null;
              }
            } else if (this[defaultZIndexKey]) {
              this.style.zIndex = this[defaultZIndexKey];
            } else {
              if (!hasZIndex(this)) {
                bringToFront(this);
              }
            }
          }
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (this[firstRender]) {
          // Perform one-time check to see if component needs a default z-index.
          if (this[state].persistent && !hasZIndex(this)) {
            bringToFront(this);
          }
        }
        if (changed.opened) {
          if (this[state].autoFocus) {
            if (this[state].opened) {
              // Opened
              if (!this[restoreFocusToElementKey] && document.activeElement !== document.body) {
                // Remember which element had the focus before we were opened.
                this[restoreFocusToElementKey] = document.activeElement;
              }
              // Focus on the element itself (if it's focusable), or the first focusable
              // element inside it.
              // TODO: We'd prefer to require that overlays (like the Overlay base
              // class) make use of delegatesFocus via DelegateFocusMixin, which would
              // let us drop the need for this mixin here to do anything special with
              // focus. However, an initial trial of this revealed an issue in
              // MenuButton, where invoking the menu did not put the focus on the first
              // menu item as expected. Needs more investigation.
              const focusElement = firstFocusableElement(this);
              if (focusElement) {
                focusElement.focus();
              }
            } else {
              // Closed
              if (this[restoreFocusToElementKey]) {
                // Restore focus to the element that had the focus before the overlay was
                // opened.
                this[restoreFocusToElementKey].focus();
                this[restoreFocusToElementKey] = null;
              }
            }
          }
        }

        // If we're finished closing an overlay that was automatically added to the
        // document, remove it now. Note: we only do this when the component
        // updates, not when it mounts, because we don't want an automatically-added
        // element to be immediately removed during its connectedCallback.
        if (!this[firstRender] && !this[state].persistent && this.closeFinished && this[appendedToDocumentKey]) {
          this[appendedToDocumentKey] = false;
          if (this.parentNode) {
            this.parentNode.removeChild(this);
          }
        }
      }
      get [template$g]() {
        const result = super[template$g] || templateFrom.html``;

        // We'd like to just use the `hidden` attribute, but a side-effect of
        // styling with the hidden attribute is that naive styling of the
        // component from the outside (to change to display: flex, say) will
        // override the display: none implied by hidden. To work around this
        // problem, we use display: none when the overlay is closed.
        result.content.append(fragmentFrom.html`
        <style>
          :host([closed]) {
            display: none;
          }
        </style>
      `);
        return result;
      }
    }
    return Overlay;
  }

  // Pick a default z-index, remember it, and apply it.
  function bringToFront(element) {
    const defaultZIndex = maxZIndexInUse() + 1;
    element[defaultZIndexKey] = defaultZIndex;
    element.style.zIndex = defaultZIndex.toString();
  }

  /**
   * If the element has or inherits an explicit numeric z-index, return true.
   * Otherwise, return false.
   *
   * @private
   * @param {HTMLElement} element
   * @returns {boolean}
   */
  function hasZIndex(element) {
    const computedZIndex = getComputedStyle(element).zIndex;
    const explicitZIndex = element.style.zIndex;
    const isExplicitZIndexNumeric = !isNaN(parseInt(explicitZIndex));
    if (computedZIndex === "auto") {
      return isExplicitZIndexNumeric;
    }
    if (computedZIndex === "0" && !isExplicitZIndexNumeric) {
      // Might be on Safari, which reports a computed z-index of zero even in
      // cases where no z-index has been inherited but the element creates a
      // stacking context. Inspect the composed tree parent to infer whether the
      // element is really inheriting a z-index.
      const parent = element.assignedSlot || (element instanceof ShadowRoot ? element.host : element.parentNode);
      if (!(parent instanceof HTMLElement)) {
        // Theoretical edge case, assume zero z-index is real.
        return true;
      }
      if (!hasZIndex(parent)) {
        // The parent doesn't have a numeric z-index, and the element itself
        // doesn't have a numeric z-index, so the "0" value for the computed
        // z-index is simulated, not a real assigned numeric z-index.
        return false;
      }
    }
    // Element has a non-zero numeric z-index.
    return true;
  }

  /*
   * Return the highest z-index currently in use in the document's light DOM.
   *
   * This calculation looks at all light DOM elements, so is theoretically
   * expensive. That said, it only runs when an overlay is opening, and is only used
   * if an overlay doesn't have a z-index already. In cases where performance is
   * an issue, this calculation can be completely circumvented by manually
   * applying a z-index to an overlay.
   */
  function maxZIndexInUse() {
    const elements = document.body.querySelectorAll("*");
    const zIndices = Array.from(elements, element => {
      const style = getComputedStyle(element);
      let zIndex = 0;
      if (style.position !== "static" && style.zIndex !== "auto") {
        const parsed = style.zIndex ? parseInt(style.zIndex) : 0;
        zIndex = !isNaN(parsed) ? parsed : 0;
      }
      return zIndex;
    });
    return Math.max(...zIndices);
  }

  // TODO: We'd like to use DelegateFocusMixin in this component, but see the note
  // at OverlayMixin's openedChanged function.
  const Base$6 = OpenCloseMixin(OverlayMixin(SlotContentMixin(ReactiveElement)));

  /**
   * An element that appears over other page elements
   *
   * The main overlay content is presented within a frame on top of an optional
   * backdrop.
   *
   * The overlay logic is provided by [OverlayMixin](OverlayMixin). `Overlay` adds
   * the definition of customizable element tags: [frameTag](#frameTag) for the
   * frame around the overlay content, and [backdropTag](#backdropTag) (if
   * defined) for the optional element covering the page elements behind the
   * overlay.
   *
   * As a convenience, the `open` method of `Overlay` will automatically add the
   * overlay to the end of the document body if the overlay isn't already in the
   * document. If the overlay is automatically attached in this way, then when it
   * closes, it will automatically be removed.
   *
   * See [Dialog](Dialog) and [Popup](Popup) for modal and modeless subclasses,
   * respectively.
   *
   * @inherits ReactiveElement
   * @mixes OpenCloseMixin
   * @mixes OverlayMixin
   * @mixes SlotContentMixin
   * @part {Backdrop} backdrop - the backdrop behind the overlay
   * @part {OverlayFrame} frame - the frame around the overlay
   */
  class Overlay extends Base$6 {
    get backdrop() {
      return this[ids] && this[ids].backdrop;
    }

    /**
     * The class or tag used for the `backdrop` part - the optional
     * element shown behind the overlay.
     *
     * This can help focus the user's attention on the overlay content.
     * Additionally, a backdrop can be used to absorb clicks on background page
     * elements. For example, [Dialog](Dialog) uses [ModalBackdrop](ModalBackdrop)
     * as an overlay backdrop in such a way.
     *
     * @type {PartDescriptor}
     * @default Backdrop
     */
    get backdropPartType() {
      return this[state].backdropPartType;
    }
    set backdropPartType(backdropPartType) {
      this[setState]({
        backdropPartType
      });
    }

    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        backdropPartType: Backdrop,
        framePartType: OverlayFrame
      });
    }
    get frame() {
      return this[ids].frame;
    }

    /**
     * The class or tag used to create the `frame` part – the overlay's
     * primary content.
     *
     * The frame element can be used to provide a border around the overlay
     * content, and to provide visual effects such as a drop-shadow to help
     * distinguish overlay content from background page elements.
     *
     * @type {PartDescriptor}
     * @default OverlayFrame
     */
    get framePartType() {
      return this[state].framePartType;
    }
    set framePartType(framePartType) {
      this[setState]({
        framePartType
      });
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      renderParts$3(this[shadowRoot], this[state], changed);
    }
    [rendered]( /** @type {ChangedFlags} */changed) {
      super[rendered](changed);
      if (changed.opened && this[state].content) {
        // If contents know how to size themselves, ask them to check their size.
        this[state].content.forEach(element => {
          if (element[checkSize]) {
            element[checkSize]();
          }
        });
      }
    }
    get [template$g]() {
      const result = super[template$g];

      // Using a grid here is tricky, because we want to deliver size-to-content
      // and expand-to-container sizing here. We also want to apply `overflow:
      // hidden` to the frame for use in a popup source like ListComboBox with a
      // popup that needs to scroll. However, tHe presence of `overflow` will
      // cause a grid at the viewport's right edge to *not* size to content as
      // expected, which will throw off our popup layout heuristics because they
      // can't get the real intrinsic size of the popup by looking at the popup
      // itself.
      //
      // To work around that, PopupSource must have special logic to inspect the
      // frame's intrinsic size directly. We'd prefer to avoid such entanglements
      // when we can, but after much experimentation with both grid and block
      // styling, grid seemed to minimize the amount of trickery needed.
      result.content.append(fragmentFrom.html`
      <style>
        :host {
          max-height: 100vh;
          max-width: 100vw;
          outline: none;
          position: fixed;
          -webkit-tap-highlight-color: transparent;
        }

        [part~="frame"] {
          box-sizing: border-box;
          display: grid;
          overflow: hidden;
          overscroll-behavior: contain;
          pointer-events: initial;
          position: relative;
        }
      </style>
      <div id="backdrop" part="backdrop" tabindex="-1"></div>
      <div id="frame" part="frame" role="none">
        <slot></slot>
      </div>
    `);
      renderParts$3(result.content, this[state]);
      return result;
    }
  }

  /**
   * Render parts for the template or an instance.
   *
   * @private
   * @param {DocumentFragment} root
   * @param {PlainObject} state
   * @param {ChangedFlags} [changed]
   */
  function renderParts$3(root, state, changed) {
    if (!changed || changed.backdropPartType) {
      const {
        backdropPartType
      } = state;
      const backdrop = root.getElementById("backdrop");
      if (backdrop) {
        transmute(backdrop, backdropPartType);
      }
    }
    if (!changed || changed.framePartType) {
      const {
        framePartType
      } = state;
      const frame = root.getElementById("frame");
      if (frame) {
        transmute(frame, framePartType);
      }
    }
  }

  /** @type {any} */
  const implicitCloseListenerKey = Symbol("implicitCloseListener");
  const elixdebugpopup$1 = new URLSearchParams(location.search).get("elixdebugpopup") === "true";

  /**
   * Gives an overlay lightweight popup-style behavior.
   *
   * This mixin expects the component to provide:
   *
   * * An open/close API compatible with `OpenCloseMixin`.
   *
   * The mixin provides these features to the component:
   *
   * * Event handlers that close the element presses the Esc key, moves the focus
   *   outside the element, scrolls the document, resizes the document, or
   *   switches focus away from the document.
   * * A default ARIA role of `alert`.
   *
   * For modal overlays, use `DialogModalityMixin` instead. See the documentation
   * of that mixin for a comparison of modality behaviors.
   *
   * @module PopupModalityMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function PopupModalityMixin(Base) {
    // The class prototype added by the mixin.
    class PopupModality extends Base {
      /**
       * True if the popup should close if the user resizes the window.
       *
       * @type {boolean}
       * @default true
       */
      get closeOnWindowResize() {
        return this[state].closeOnWindowResize;
      }
      set closeOnWindowResize(closeOnWindowResize) {
        this[setState]({
          closeOnWindowResize
        });
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          closeOnWindowResize: true,
          role: "alert"
        });
      }

      // Close on Esc key.
      [keydown]( /** @type {KeyboardEvent} */event) {
        let handled = false;
        switch (event.key) {
          case "Escape":
            this.close({
              canceled: "Escape"
            });
            handled = true;
            break;
        }

        // Prefer mixin result if it's defined, otherwise use base result.
        return handled || super.keydown && super.keydown(event) || false;
      }
      [render]( /** @type {ChangedFlags} */changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (this[firstRender]) {
          // Don't wire up popup blur handling if we're debugging popups.
          if (!elixdebugpopup$1) {
            // If we lose focus, and the new focus isn't inside us, then close.
            this.addEventListener("blur", blurHandler$1.bind(this));
          }
        }
        if (changed.role) {
          // Apply top-level role.
          const {
            role
          } = this[state];
          this.setAttribute("role", role);
        }
      }
      [rendered]( /** @type {ChangedFlags} */changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.opened) {
          if (this.opened) {
            // Wait before wiring up events – if the popup was opened because the
            // user clicked something, that opening click event may still be
            // bubbling up, and we only want to start listening after it's been
            // processed. Alternatively, if the popup caused the page to scroll, we
            // don't want to immediately close because the page scrolled (only if
            // the user scrolls).
            const callback = "requestIdleCallback" in window ? window["requestIdleCallback"] : setTimeout;
            callback(() => {
              // It's conceivable the popup was closed before the timeout completed,
              // so double-check that it's still opened before listening to events.
              if (this.opened) {
                addEventListeners$1(this);
              }
            });
          } else {
            removeEventListeners$1(this);
          }
        }
      }

      // Setting the standard role attribute will invoke this property setter,
      // which will allow us to update our state.
      get role() {
        return super.role;
      }
      set role(role) {
        super.role = role;
        if (!this[rendering]) {
          this[setState]({
            role
          });
        }
      }
    }
    return PopupModality;
  }
  function addEventListeners$1( /** @type {ReactiveElement} */element) {
    // Close handlers for window events.
    element[implicitCloseListenerKey] = closeHandler.bind(element);
    if (!elixdebugpopup$1) {
      // Window blur event tracks loss of focus of *window*, not just element.
      window.addEventListener("blur", element[implicitCloseListenerKey]);
    }
    window.addEventListener("resize", element[implicitCloseListenerKey]);
    window.addEventListener("scroll", element[implicitCloseListenerKey]);
  }
  function removeEventListeners$1( /** @type {ReactiveElement} */element) {
    if (element[implicitCloseListenerKey]) {
      if (!elixdebugpopup$1) {
        window.removeEventListener("blur", element[implicitCloseListenerKey]);
      }
      window.removeEventListener("resize", element[implicitCloseListenerKey]);
      window.removeEventListener("scroll", element[implicitCloseListenerKey]);
      element[implicitCloseListenerKey] = null;
    }
  }

  // Note: This routine also exists in PopupButton, may want to eventually
  // share that. Note that PopupButton handles blur on the *button*; here
  // we're dealing with the popup.
  async function blurHandler$1( /** @type {Event} */event) {
    // @ts-ignore
    /** @type {any} */
    const element = this;
    // What has the focus now?
    const newFocusedElement = /** @type {any} */event.relatedTarget || document.activeElement;
    /** @type {any} */
    if (newFocusedElement instanceof Element && !deepContains(element, newFocusedElement)) {
      element[raiseChangeEvents] = true;
      await element.close({
        canceled: "window blur"
      });
      element[raiseChangeEvents] = false;
    }
  }
  async function closeHandler( /** @type {Event} */event) {
    // @ts-ignore
    /** @type {any} */
    const element = this;
    const handleEvent = event.type !== "resize" || element[state].closeOnWindowResize;
    if (!ownEvent(element, event) && handleEvent) {
      element[raiseChangeEvents] = true;
      await element.close({
        canceled: `window ${event.type}`
      });
      element[raiseChangeEvents] = false;
    }
  }

  const Base$5 = KeyboardMixin(PopupModalityMixin(Overlay));

  /**
   * Lightweight form of modeless overlay that can be easily dismissed
   *
   * When opened, the popup displays its children on top of other page elements.
   *
   * @inherits Overlay
   * @mixes KeyboardMixin
   * @mixes PopupModalityMixin
   */
  class Popup extends Base$5 {
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      if (changed.backdropPartType) {
        this[ids].backdrop.addEventListener("mousedown", mousedownHandler.bind(this));

        // Mobile Safari doesn't seem to generate a mousedown handler on the
        // backdrop in some cases that Mobile Chrome handles. For completeness, we
        // also listen to touchend.
        if (!("PointerEvent" in window)) {
          this[ids].backdrop.addEventListener("touchend", mousedownHandler);
        }
      }
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          :host {
            display: grid;
            grid-template: minmax(0, max-content) / minmax(0, max-content);
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * @private
   * @param {Event} event
   */
  async function mousedownHandler(event) {
    // @ts-ignore
    /** @type {Popup} */
    const element = this;
    element[raiseChangeEvents] = true;
    await element.close({
      canceled: "mousedown outside"
    });
    element[raiseChangeEvents] = false;
    event.preventDefault();
    event.stopPropagation();
  }

  const resizeListenerKey = Symbol("resizeListener");
  const Base$4 = DisabledMixin(FocusVisibleMixin(LanguageDirectionMixin(OpenCloseMixin(ReactiveElement))));

  /**
   * Positions a popup with respect to a source element
   *
   * @inherits ReactiveElement
   * @mixes DisabledMixin
   * @mixes FocusVisibleMixin
   * @mixes OpenCloseMixin
   * @part {Popup} popup - the popup element
   * @part {button} source - the element used as the reference point for positioning the popup, generally the element that invokes the popup
   */
  class PopupSource extends Base$4 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        ariaHasPopup: "true",
        popupAlign: "start",
        popupDirection: "column",
        popupLayout: null,
        popupPartType: Popup,
        sourcePartType: "div"
      });
    }

    // By default, assume that the source part is an input-like element that will
    // get the foucs.
    get [inputDelegate]() {
      return this[ids].source;
    }
    get frame() {
      return (/** @type {any} */this[ids].popup.frame
      );
    }

    /**
     * The alignment of the popup with respect to the source button.
     *
     * * `bottom`: popup and source are bottom-aligned
     * * `end`: popup and source are aligned on the trailing edge according to the
     *   text direction
     * * `left`: popup and source are left-aligned
     * * `right`: popup and source are right-aligned
     * * `start`: popup and source are aligned on the leading edge according to
     *   the text direction
     * * `stretch`: both left and right edges are aligned
     * * `top`: popup and source are top-aligned
     *
     * @type {('bottom'|'end'|'left'|'right'|'start'|'stretch'|'top')}
     * @default 'start'
     */
    get popupAlign() {
      return this[state].popupAlign;
    }
    set popupAlign(popupAlign) {
      this[setState]({
        popupAlign
      });
    }

    /**
     * The preferred direction for the popup.
     *
     * * `above`: popup appears above the source
     * * `below`: popup appears below the source
     * * `column-reverse`: popup appears before the source in the block axis
     * * `column`: popup appears after the source in the block axis
     * * `left`: popup appears to the left of the source
     * * `right`: popup appears to the right of the source
     * * `row-reverse`: popup appears before the source in the inline axis
     * * `row`: popup appears after the source in the inline axis
     *
     * @type {('above'|'below'|'column-reverse'|'column'|'left'|'right'|'row-reverse'|'row')}
     * @default 'column'
     */
    get popupDirection() {
      return this[state].popupDirection;
    }
    set popupDirection(popupDirection) {
      this[setState]({
        popupDirection
      });
    }

    /**
     * The class or tag used to create the `popup` part – the element
     * responsible for displaying the popup and handling overlay behavior.
     *
     * @type {PartDescriptor}
     * @default Popup
     */
    get popupPartType() {
      return this[state].popupPartType;
    }
    set popupPartType(popupPartType) {
      this[setState]({
        popupPartType
      });
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      renderParts$2(this[shadowRoot], this[state], changed);
      if (this[firstRender] || changed.ariaHasPopup) {
        const {
          ariaHasPopup
        } = this[state];
        if (ariaHasPopup === null) {
          this[inputDelegate].removeAttribute("aria-haspopup");
        } else {
          this[inputDelegate].setAttribute("aria-haspopup", this[state].ariaHasPopup);
        }
      }
      if (changed.popupPartType) {
        // Popup's opened state becomes our own opened state.
        this[ids].popup.addEventListener("open", () => {
          if (!this.opened) {
            this[raiseChangeEvents] = true;
            this.open();
            this[raiseChangeEvents] = false;
          }
        });

        // Popup's closed state becomes our own closed state.
        this[ids].popup.addEventListener("close", event => {
          if (!this.closed) {
            this[raiseChangeEvents] = true;
            /** @type {any} */

            const cast = event;
            const closeResult = cast.detail.closeResult;
            this.close(closeResult);
            this[raiseChangeEvents] = false;
          }
        });
      }
      if (changed.opened || changed.popupLayout) {
        const {
          opened,
          popupLayout
        } = this[state];

        // By default, we reset the styles used to position the popup.
        /** @type {any} */
        const styling = {
          height: "",
          left: "",
          opacity: "",
          top: "",
          width: ""
        };
        if (!opened) ; else if (!popupLayout) {
          // Popup opened but not yet laid out.
          //
          // Render the component invisibly so we can measure it before showing
          // it. We hide it by giving it zero opacity. If we use `visibility:
          // hidden` for this purpose, the popup won't be able to receive the
          // focus, which would complicate our overlay focus handling.
          //
          // In case the popup is being relayed out because a layout-affecting
          // property changed while the popup is open, we reset the positiong
          // styles too.
          styling.opacity = 0;
        } else {
          // Popup opened and laid out. Position the popup using only the edges
          // implicated in the layout.
          const {
            align,
            direction,
            rect
          } = popupLayout;
          const stretch = align === "stretch";
          const vertical = direction === "above" || direction === "below";
          const gridTemplateRows = !vertical && stretch ? "minmax(0, 1fr)" : "";
          const gridTemplateColumns = vertical && stretch ? "minmax(0, 1fr)" : "";
          Object.assign(styling, {
            gridTemplateColumns,
            gridTemplateRows,
            height: `${rect.height}px`,
            left: `${rect.left}px`,
            top: `${rect.top}px`,
            width: `${rect.width}px`
          });
        }
        Object.assign(this[ids].popup.style, styling);
      }
      if (changed.opened) {
        const {
          opened
        } = this[state];
        /** @type {any} */
        this[ids].popup.opened = opened;
      }
      if (changed.disabled) {
        if ("disabled" in this[ids].source) {
          const {
            disabled
          } = this[state];
          /** @type {any} */
          this[ids].source.disabled = disabled;
        }
      }

      // Let the popup know its position relative to the source.
      if (changed.popupLayout) {
        const {
          popupLayout
        } = this[state];
        if (popupLayout) {
          const {
            align,
            direction
          } = popupLayout;
          /** @type {any} */
          const popup = this[ids].popup;
          if ("position" in popup) {
            popup.position = direction;
          }
          if ("align" in popup) {
            popup.align = align;
          }
        }
      }
    }
    [rendered]( /** @type {ChangedFlags} */changed) {
      super[rendered](changed);
      const {
        opened
      } = this[state];
      if (changed.opened) {
        if (opened) {
          // Worth noting that's possible (but unusual) for a popup to render
          // opened on first render.
          waitThenRenderOpened(this);
        } else {
          removeEventListeners(this);
        }
      } else if (changed.popupLayout && this[state].opened && !this[state].popupLayout) {
        // A layout-affecting property changed while the popup is open; do layout
        // again.
        choosePopupLayout(this);
      }
    }

    /**
     * The class or tag used to create the `source` part - the button
     * (or other element) the user can tap/click to invoke the popup.
     *
     * @type {PartDescriptor}
     * @default 'button'
     */
    get sourcePartType() {
      return this[state].sourcePartType;
    }
    set sourcePartType(sourcePartType) {
      this[setState]({
        sourcePartType
      });
    }
    [stateEffects](state, changed) {
      const effects = super[stateEffects](state, changed);

      // We reset our popup calculations when the popup closes, or if it's open
      // and state that affects positioning has changed.
      if (changed.opened && !state.opened || state.opened && (changed.popupAlign || changed.popupDirection || changed.rightToLeft)) {
        Object.assign(effects, {
          popupLayout: null
        });
      }
      return effects;
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
      <style>
        :host {
          display: inline-block;
          position: relative;
        }

        [part~="source"] {
          height: 100%;
          -webkit-tap-highlight-color: transparent;
          touch-action: manipulation;
          width: 100%;
        }

        [part~="popup"] {
          outline: none;
          position: fixed;
        }
      </style>
      <div id="source" part="source">
        <slot name="source"></slot>
      </div>
      <div id="popup" part="popup" exportparts="backdrop, frame" role="none">
        <slot></slot>
      </div>
    `);
      renderParts$2(result.content, this[state]);
      return result;
    }
  }
  function addEventListeners( /** @type {PopupSource} */element) {
    /** @type {any} */const cast = element;
    cast[resizeListenerKey] = () => {
      // If viewport resizes while the popup is open, we may want to change which
      // layout we're using for the popup.
      choosePopupLayout(element);
    };
    const viewport = window.visualViewport || window;
    viewport.addEventListener("resize", cast[resizeListenerKey]);
  }

  /**
   * Based on the current size of the source, popup, and viewport, determine which
   * layout we'll use for the popup.
   *
   * @private
   * @param {PopupSource} element
   */
  function choosePopupLayout(element) {
    const {
      popupAlign,
      popupDirection,
      rightToLeft
    } = element[state];
    const sourceRect = element[ids].source.getBoundingClientRect();
    const popupRect = element[ids].popup.getBoundingClientRect();

    // If the popup defines a frame, ask the frame for its intrinsic size by
    // inspecting the scrollHeight/Width properties. These will report the correct
    // size even if the popup is currently constraining the frame.
    const frame = /** @type {any} */element[ids].popup.frame;
    if (frame) {
      popupRect.height = element[ids].popup[ids].frame.scrollHeight;
      popupRect.width = element[ids].popup[ids].frame.scrollWidth;
    }
    const boundsRect = viewportBounds();
    const popupLayout = layoutPopup(sourceRect, popupRect, boundsRect, {
      align: popupAlign,
      direction: popupDirection,
      rightToLeft
    });
    element[setState]({
      popupLayout
    });
  }
  function removeEventListeners( /** @type {PopupSource} */element) {
    /** @type {any} */const cast = element;
    if (cast[resizeListenerKey]) {
      const viewport = window.visualViewport || window;
      viewport.removeEventListener("resize", cast[resizeListenerKey]);
      cast[resizeListenerKey] = null;
    }
  }

  /**
   * Render parts for the template or an instance.
   *
   * @private
   * @param {DocumentFragment} root
   * @param {PlainObject} state
   * @param {ChangedFlags} [changed]
   */
  function renderParts$2(root, state, changed) {
    if (!changed || changed.popupPartType) {
      const {
        popupPartType
      } = state;
      const popup = root.getElementById("popup");
      if (popup) {
        transmute(popup, popupPartType);
      }
    }
    if (!changed || changed.sourcePartType) {
      const {
        sourcePartType
      } = state;
      const source = root.getElementById("source");
      if (source) {
        transmute(source, sourcePartType);
      }
    }
  }

  // Determine the bounding rectangle of the viewport. We prefer the
  // VisualViewport API where that's available, as that handles a pinch-zoomed
  // viewport on mobile. If not availble (as of October 2020, Firefox), we fall
  // back to using the window as the viewport.
  function viewportBounds() {
    // @ts-ignore
    const viewport = window.visualViewport;
    const boundsRect = viewport ? new DOMRect(viewport.offsetLeft, viewport.offsetTop, viewport.width, viewport.height) : new DOMRect(0, 0, window.innerWidth, window.innerHeight);
    return boundsRect;
  }

  /**
   *
   * When a popup is first rendered, we let it render invisibly so that it doesn't
   * affect the page layout.
   *
   * We then wait, for two reasons:
   *
   * 1) We need to give the popup time to render invisibly. That lets us get the
   *    true size of the popup content.
   *
   * 2) Wire up events that can dismiss the popup. If the popup was opened because
   *    the user clicked something, that opening click event may still be bubbling
   *    up, and we only want to start listening after it's been processed.
   *    Along the same lines, if the popup caused the page to scroll, we don't
   *    want to immediately close because the page scrolled (only if the user
   *    scrolls).
   *
   * After waiting, we can take care of both of the above tasks.
   *
   * @private
   * @param {PopupSource} element
   */
  function waitThenRenderOpened(element) {
    // Wait a tick to let the newly-opened component actually render.
    setTimeout(() => {
      // It's conceivable the popup was closed before the timeout completed,
      // so double-check that it's still opened before listening to events.
      if (element[state].opened) {
        choosePopupLayout(element);
        addEventListeners(element);
      }
    });
  }

  const elixdebugpopup = new URLSearchParams(location.search).get("elixdebugpopup") === "true";
  const Base$3 = DelegateFocusMixin(KeyboardMixin(PopupDragSelectMixin(PopupSource)));

  /**
   * A button that invokes an attached popup
   *
   * @inherits PopupSource
   * @mixes DelegateFocusMixin
   * @mixes KeyboardMixin
   * @mixes PopupDragSelectMixin
   */
  class PopupButton extends Base$3 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        sourcePartType: "button"
      });
    }
    [keydown]( /** @type {KeyboardEvent} */event) {
      let handled;
      switch (event.key) {
        // Space or Up/Down arrow keys open the popup.
        case " ":
        case "ArrowDown":
        case "ArrowUp":
          if (this.closed) {
            this.open();
            handled = true;
          }
          break;

        // Enter opens popup.
        case "Enter":
          if (!this.opened) {
            this.open();
            handled = true;
          }
          break;

        // If popup is open, pressing Esc should close popup.
        // This code exists to handle cases where the popup does not take the
        // focus (autoFocus is false). In cases where the popup takes focus, it
        // will be up to the popup to handle closing when Esc is pressed.
        case "Escape":
          if (this.opened) {
            this.close({
              canceled: "Escape"
            });
            handled = true;
          }
          break;
      }

      // Give superclass a chance to handle.
      handled = super[keydown] && super[keydown](event);
      if (!handled && this.opened && !event.metaKey && !event.altKey) {
        // If they haven't already been handled, absorb keys that might cause the
        // page to scroll in the background, which would in turn cause the popup to
        // inadvertently close.
        switch (event.key) {
          case "ArrowDown":
          case "ArrowLeft":
          case "ArrowRight":
          case "ArrowUp":
          case "End":
          case "Home":
          case "PageDown":
          case "PageUp":
          case " ":
            handled = true;
        }
      }
      return handled;
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      if (this[firstRender]) {
        // Close the popup if we're opened and lose focus. A typical popup using
        // PopupModalityMixin will have its own logic to close on blur -- but in
        // cases where the popup itself doesn't get focus (e.g., TooltipButton),
        // that logic won't apply.
        // Don't close on blur if we're debugging popups.
        if (!elixdebugpopup) {
          this.addEventListener("blur", blurHandler.bind(this));
        }

        // If the source element gets the focus while the popup is open, the
        // most likely expanation is that the user hit Shift+Tab to back up out of
        // the popup. In that case, we should close.
        this[ids].source.addEventListener("focus", async event => {
          const popupFocused = ownEvent(this[ids].popup, event);
          // It's possible to get a focus event in the initial mousedown on the
          // source button before the popup is even rendered. We don't want to
          // close in that case, so we check to see if we've already measured the
          // popup dimensions (which will be true if the popup fully completed
          // rendering).
          const measured = this[state].popupHeight !== null;
          if (!popupFocused && this.opened && measured) {
            this[raiseChangeEvents] = true;
            await this.close();
            this[raiseChangeEvents] = false;
          }
        });
      }
      if (changed.opened) {
        // Reflect opened state to attribute for styling.
        const {
          opened
        } = this[state];
        this.toggleAttribute("opened", opened);
      }
      if (changed.sourcePartType) {
        // Desktop popups generally open on mousedown, not click/mouseup. On mobile,
        // mousedown won't fire until the user releases their finger, so it behaves
        // like a click.
        const source = this[ids].source;
        source.addEventListener("mousedown", event => {
          // mousedown events fire even if button is disabled, so we need
          // to explicitly ignore those.
          if (this.disabled) {
            event.preventDefault();
            return;
          }
          // Only handle primary button mouse down to avoid interfering with
          // right-click behavior.
          /** @type {any} */
          const cast = event;
          if (cast.button && cast.button !== 0) {
            return;
          }
          // We give the default focus behavior time to run before opening the
          // popup. See note below.
          setTimeout(() => {
            if (!this.opened) {
              this[raiseChangeEvents] = true;
              this.open();
              this[raiseChangeEvents] = false;
            }
          });
          event.stopPropagation();
          // We don't prevent the default behavior for mousedown. Among other
          // things, it sets the focus to the element the user moused down on.
          // That's important for us, because OverlayMixin will remember that
          // focused element (i.e., this element) when opening, and restore focus to
          // it when the popup closes.
        });
      }

      if (changed.popupPartType) {
        this[ids].popup.removeAttribute("tabindex");
      }
    }
    get [template$g]() {
      const result = super[template$g];
      // When popup is open, it will have focus; don't show focus ring on host.
      result.content.append(fragmentFrom.html`
        <style>
          [part~="source"] {
            cursor: default;
            outline: none;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
            -moz-user-select: none;
            -ms-user-select: none;
            -webkit-user-select: none;
            user-select: none;
          }

          :host([opened][focus-visible]) {
            outline: none;
          }
        </style>
      `);
      return result;
    }
  }

  // Note: This routine also exists in PopupModalityMixin, may want to eventually
  // share that. Note that PopupModalityMixin handles blur on the *popup*; here
  // we're dealing with the source button.
  async function blurHandler( /** @type {Event} */event) {
    // @ts-ignore
    /** @type {any} */
    const element = this;
    // What has the focus now?
    const newFocusedElement = /** @type {any} */event.relatedTarget || document.activeElement;
    /** @type {any} */
    if (newFocusedElement instanceof Element && !deepContains(element, newFocusedElement)) {
      element[raiseChangeEvents] = true;
      await element.close({
        canceled: "blur"
      });
      element[raiseChangeEvents] = false;
    }
  }

  const documentMousemoveListenerKey = Symbol("documentMousemoveListener");

  /**
   * Syncs the cursor a popup source and a list-like element inside the popup.
   *
   * This includes support for drag-select operations: the user can mouse down on
   * the source to produce the popup, drag into the popup to highlight an item,
   * then release the mouse to select that item.
   *
   * @module PopupListMixin
   * @param {Constructor<ReactiveElement>} Base
   */
  function PopupListMixin(Base) {
    // The class prototype added by the mixin.
    class PopupList extends Base {
      connectedCallback() {
        super.connectedCallback();
        // Handle edge case where component is opened, removed, then added back.
        listenIfOpenAndConnected(this);
      }

      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          currentIndex: -1,
          hasHoveredOverItemSinceOpened: false,
          popupList: null
        });
      }
      disconnectedCallback() {
        if (super.disconnectedCallback) {
          super.disconnectedCallback();
        }
        listenIfOpenAndConnected(this);
      }
      [keydown]( /** @type {KeyboardEvent} */event) {
        let handled = false;
        switch (event.key) {
          // Enter closes popup.
          case "Enter":
            if (this.opened) {
              selectCurrentItemAndClose(this);
              handled = true;
            }
        }

        // Prefer our result if it's defined, otherwise use base result.
        return handled || super[keydown] && super[keydown](event) || false;
      }
      [render](changed) {
        if (super[render]) {
          super[render](changed);
        }
        if (changed.popupList) {
          const {
            popupList
          } = this[state];
          if (popupList) {
            // If the user mouses up on a list item, close the list with that item as
            // the close result.
            popupList.addEventListener("mouseup", async event => {
              // If we're doing a drag-select (user moused down on button, dragged
              // mouse into list, and released), we close. If we're not doing a
              // drag-select (the user opened the list with a complete click), and
              // there's a selection, they clicked on an item, so also close.
              // Otherwise, the user clicked the list open, then clicked on a list
              // separator or list padding; stay open.
              const currentIndex = this[state].currentIndex;
              if (this[state].dragSelect || currentIndex >= 0) {
                // We don't want the document mouseup handler in
                // PopupDragSelectMixin to close the popup before we've asked the
                // list to highlight the selection. We stop event propagation
                // here, before we enter any async code, to actually stop
                // propagation.
                event.stopPropagation();
                this[raiseChangeEvents] = true;
                await selectCurrentItemAndClose(this);
                this[raiseChangeEvents] = false;
              } else {
                event.stopPropagation();
              }
            });

            // Track changes in the list's cursor.
            popupList.addEventListener("currentindexchange", event => {
              this[raiseChangeEvents] = true;
              /** @type {any} */
              const cast = event;
              this[setState]({
                currentIndex: cast.detail.currentIndex
              });
              this[raiseChangeEvents] = false;
            });
          }
        }

        // The popup's current item is represented in the visible list.
        if (changed.currentIndex || changed.popupList) {
          const {
            currentIndex,
            popupList
          } = this[state];
          if (popupList && "currentIndex" in popupList) {
            popupList.currentIndex = currentIndex;
          }
        }
      }
      [rendered](changed) {
        if (super[rendered]) {
          super[rendered](changed);
        }
        if (changed.opened) {
          if (this[state].opened) {
            // Ensure the list's cursor is visible. If the cursor moved while the
            // list was closed, the cursor may not be in view yet.
            const {
              popupList
            } = this[state];
            if (popupList.scrollCurrentItemIntoView) {
              // Give popup time to render.
              setTimeout(() => {
                popupList.scrollCurrentItemIntoView();
              });
            }
          }
          listenIfOpenAndConnected(this);
        }
      }
      [stateEffects](state, changed) {
        const effects = super[stateEffects] ? super[stateEffects](state, changed) : {};

        // When opening, reset out notion of whether the user has hovered over an
        // item since the list was opened.
        if (changed.opened && state.opened) {
          Object.assign(effects, {
            hasHoveredOverItemSinceOpened: false
          });
        }
        return effects;
      }
    }
    return PopupList;
  }

  // Handle a mouse hover select operation.
  function handleMousemove( /** @type {MouseEvent} */event) {
    // @ts-ignore
    const element = this;
    const {
      hasHoveredOverItemSinceOpened,
      opened
    } = element[state];
    if (opened) {
      // Treat the deepest element in the composed event path as the target.
      const target = event.composedPath ? event.composedPath()[0] : event.target;
      const items = element.items;
      if (target && target instanceof Node && items) {
        const hoverIndex = indexOfItemContainingTarget(items, target);
        const item = items[hoverIndex];

        // If the user is hovering over an enabled item, make it current.
        // If the user is not hovering over an enabled item, but has
        // hovered over such an item at least once since the list was
        // opened, then clear cursor.
        const currentIndex = item && !item.disabled ? hoverIndex : -1;
        if ((hasHoveredOverItemSinceOpened || currentIndex >= 0) && currentIndex !== element[state].currentIndex) {
          element[raiseChangeEvents] = true;
          element[setState]({
            currentIndex
          });
          if (currentIndex >= 0 && !hasHoveredOverItemSinceOpened) {
            element[setState]({
              hasHoveredOverItemSinceOpened: true
            });
          }
          element[raiseChangeEvents] = false;
        }
      }
    }
  }
  function listenIfOpenAndConnected(element) {
    if (element[state].opened && element.isConnected) {
      if (!element[documentMousemoveListenerKey]) {
        // Not listening yet; start.
        element[documentMousemoveListenerKey] = handleMousemove.bind(element);
        document.addEventListener("mousemove", element[documentMousemoveListenerKey]);
      }
    } else if (element[documentMousemoveListenerKey]) {
      // Currently listening; stop.
      document.removeEventListener("mousemove", element[documentMousemoveListenerKey]);
      element[documentMousemoveListenerKey] = null;
    }
  }

  /**
   * Highlight the current item (if one exists), then close the menu.
   */
  async function selectCurrentItemAndClose(element) {
    const originalRaiseChangeEvents = element[raiseChangeEvents];
    const cursorDefined = element[state].currentIndex >= 0;
    const items = element.items;
    if (items) {
      const closeResult = cursorDefined ? items[element[state].currentIndex] : undefined;
      const list = element[state].popupList;
      if (cursorDefined && "flashCurrentItem" in list) {
        await list.flashCurrentItem();
      }
      const saveRaiseChangeEvents = element[raiseChangeEvents];
      element[raiseChangeEvents] = originalRaiseChangeEvents;
      await element.close(closeResult);
      element[raiseChangeEvents] = saveRaiseChangeEvents;
    }
  }

  const Base$2 = PopupListMixin(PopupButton);

  /**
   * A button that invokes a menu.
   *
   * @inherits PopupButton
   * @mixes PopupListMixin
   * @part {Menu} menu - the menu shown in the popup
   */
  class MenuButton extends Base$2 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        menuPartType: Menu
      });
    }
    get items() {
      /** @type {any} */
      const menu = this[ids] && this[ids].menu;
      return menu ? menu.items : null;
    }

    /**
     * The class or tag used to define the `menu` part – the element
     * presenting the menu items and handling navigation between them.
     *
     * @type {PartDescriptor}
     * @default Menu
     */
    get menuPartType() {
      return this[state].menuPartType;
    }
    set menuPartType(menuPartType) {
      this[setState]({
        menuPartType
      });
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      renderParts$1(this[shadowRoot], this[state], changed);
      if (changed.menuPartType) {
        // Close the popup if menu loses focus.
        this[ids].menu.addEventListener("blur", async event => {
          /** @type {any} */
          const cast = event;
          const newFocusedElement = cast.relatedTarget || document.activeElement;
          if (this.opened && !deepContains(this[ids].menu, newFocusedElement)) {
            this[raiseChangeEvents] = true;
            await this.close();
            this[raiseChangeEvents] = false;
          }
        });

        // mousedown events on the menu will propagate up to the top-level element,
        // which will then steal the focus. We want to keep the focus on the menu,
        // both to permit keyboard use, and to avoid closing the menu on blur (see
        // separate blur handler). To keep the focus on the menu, we prevent the
        // default event behavior.
        this[ids].menu.addEventListener("mousedown", event => {
          // Only process events for the main (usually left) button.
          if ( /** @type {MouseEvent} */event.button !== 0) {
            return;
          }
          if (this.opened) {
            event.stopPropagation();
            event.preventDefault();
          }
        });
      }
      if (changed.opened) {
        // Reflect opened state to source for ARIA.
        const {
          opened
        } = this[state];
        this[ids].source.setAttribute("aria-expanded", opened.toString());
      }
    }
    [rendered](changed) {
      super[rendered](changed);
      if (changed.menuPartType) {
        this[setState]({
          popupList: this[ids].menu
        });
      }
    }
    [stateEffects](state, changed) {
      const effects = super[stateEffects](state, changed);

      // When closing, clear menu selection.
      if (changed.opened && !state.opened) {
        Object.assign(effects, {
          currentIndex: -1
        });
      }
      return effects;
    }
    get [template$g]() {
      const result = super[template$g];

      // Wrap default slot with a menu.
      const defaultSlot = result.content.querySelector("slot:not([name])");
      if (defaultSlot) {
        defaultSlot.replaceWith(fragmentFrom.html`
        <div id="menu" part="menu">
          <slot></slot>
        </div>
      `);
      }
      renderParts$1(result.content, this[state]);
      result.content.append(fragmentFrom.html`
      <style>
        [part~="menu"] {
          max-height: 100%;
        }
      </style>
    `);
      return result;
    }
  }

  /**
   * Render parts for the template or an instance.
   *
   * @private
   * @param {DocumentFragment} root
   * @param {PlainObject} state
   * @param {ChangedFlags} [changed]
   */
  function renderParts$1(root, state, changed) {
    if (!changed || changed.menuPartType) {
      const {
        menuPartType
      } = state;
      const menu = root.getElementById("menu");
      if (menu) {
        transmute(menu, menuPartType);
      }
    }
  }

  const Base$1 = DisabledMixin(ReactiveElement);

  /**
   * An element that can point up or down.
   *
   * @inherits ReactiveElement
   * @mixes DisabledMixin
   * @part down-icon - the icon shown in the toggle if the popup will open or close in the down direction
   * @part toggle-icon - both the up and down icons
   * @part up-icon - the icon shown in the toggle if the popup will open or close in the up direction
   */
  class UpDownToggle extends Base$1 {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        direction: "down"
      });
    }

    /**
     * Indicates which direction the element should point to.
     *
     * @type {'down'|'up'}
     * @default 'down'
     */
    get direction() {
      return this[state].direction;
    }
    set direction(direction) {
      this[setState]({
        direction
      });
    }
    [render]( /** @type {ChangedFlags} */changed) {
      super[render](changed);
      if (changed.direction) {
        const {
          direction
        } = this[state];
        this[ids].downIcon.style.display = direction === "down" ? "block" : "none";
        this[ids].upIcon.style.display = direction === "up" ? "block" : "none";
      }
    }
    get [template$g]() {
      return templateFrom.html`
      <style>
        :host {
          display: inline-block;
        }
      </style>
      <div id="downIcon" part="toggle-icon down-icon">
        <slot name="down-icon"></slot>
      </div>
      <div id="upIcon" part="toggle-icon up-icon">
        <slot name="up-icon"></slot>
      </div>
    `;
    }
  }

  /**
   * Manages a popup toggle part for a popup source.
   *
   * @module PopupToggleMixin
   * @part {UpDownToggle} popup-toggle - the element that lets the user know they can open the popup
   * @part down-icon - the icon shown in the toggle if the popup will open or close in the down direction
   * @part up-icon - the icon shown in the toggle if the popup will open or close in the up direction
   * @param {Constructor<ReactiveElement>} Base
   */
  function PopupToggleMixin(Base) {
    // The class prototype added by the mixin.
    class PopupToggle extends Base {
      // @ts-ignore
      get [defaultState]() {
        return Object.assign(super[defaultState] || {}, {
          popupTogglePartType: UpDownToggle
        });
      }

      /**
       * The class or tag used to create the `popup-toggle` part – the
       * element that lets the user know they can open the popup.
       *
       * @type {PartDescriptor}
       * @default UpDownToggle
       */
      get popupTogglePartType() {
        return this[state].popupTogglePartType;
      }
      set popupTogglePartType(popupTogglePartType) {
        this[setState]({
          popupTogglePartType
        });
      }
      [render]( /** @type {ChangedFlags} */changed) {
        super[render](changed);
        renderParts(this[shadowRoot], this[state], changed);

        // Tell the toggle which direction it should point to depending on which
        // direction the popup will open. Since we assume this is used for up/down
        // popup directions, we don't handle left/right directions.
        if (changed.popupDirection || changed.popupTogglePartType) {
          const {
            popupDirection
          } = this[state];
          const toggleDirection = popupDirection === "above" || popupDirection === "column-reverse" ? "up" : "down";
          /** @type {any} */
          const popupToggle = this[ids].popupToggle;
          if ("direction" in popupToggle) {
            popupToggle.direction = toggleDirection;
          }
        }
        if (changed.disabled) {
          const {
            disabled
          } = this[state];
          /** @type {any} */
          this[ids].popupToggle.disabled = disabled;
        }
      }
      get [template$g]() {
        const result = super[template$g];

        // Append a toggle button to the source.
        const source = result.content.querySelector('[part~="source"]');
        if (source) {
          source.append(fragmentFrom.html`
          <div
            id="popupToggle"
            part="popup-toggle"
            exportparts="toggle-icon, down-icon, up-icon"
            tabindex="-1"
          ></div>
      `);
        }
        renderParts(result.content, this[state]);
        result.content.append(fragmentFrom.html`
      <style>
        [part~="popup-toggle"] {
          outline: none;
        }

        [part~="source"] {
          align-items: center;
          display: flex;
        }
      </style>
    `);
        return result;
      }
    }
    return PopupToggle;
  }

  /**
   * Render parts for the template or an instance.
   *
   * @private
   * @param {DocumentFragment} root
   * @param {PlainObject} state
   * @param {ChangedFlags} [changed]
   */
  function renderParts(root, state, changed) {
    if (!changed || changed.popupTogglePartType) {
      const {
        popupTogglePartType
      } = state;
      const popupToggle = root.getElementById("popupToggle");
      if (popupToggle) {
        transmute(popupToggle, popupTogglePartType);
      }
    }
  }

  /**
   * Button component in the Plain reference design system
   *
   * @inherits Button
   */
  class PlainButton extends PlainButtonMixin(Button) {}

  /**
   * Button with a border in the Plain reference design system
   *
   * @inherits PlainButton
   */
  class PlainBorderButton extends PlainButton {
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          [part~="button"] {
            background: #eee;
            border: 1px solid #ccc;
            padding: 0.25em 0.5em;
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * Menu component in the Plain reference design system
   *
   * @inherits Menu
   */
  class PlainMenu extends Menu {
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          :host ::slotted(*) {
            padding: 0.25em 1em;
          }
          
          :host ::slotted([current]) {
            background: highlight;
            color: highlighttext;
          }

          @media (pointer: coarse) {
            ::slotted(*) {
              padding: 1em;
            }
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * OpenCloseToggle component in the Plain reference design system
   *
   * @inherits OpenCloseToggle
   */
  class PlainOpenCloseToggle extends UpDownToggle {
    get [template$g]() {
      const result = super[template$g];

      // Replace the icons with our up/down glyphs.
      const downIcon = result.content.getElementById("downIcon");
      const downIconGlyph = fragmentFrom.html`
      <svg
        id="downIcon"
        part="toggle-icon down-icon"
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 10 5"
      >
        <path d="M 0 0 l5 5 5 -5 z" />
      </svg>
    `.firstElementChild;
      if (downIcon && downIconGlyph) {
        replace$3(downIcon, downIconGlyph);
      }
      const upIcon = result.content.getElementById("upIcon");
      const upIconGlyph = fragmentFrom.html`
      <svg
        id="upIcon"
        part="toggle-icon up-icon"
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 10 5"
      >
        <path d="M 0 5 l5 -5 5 5 z" />
      </svg>
    `.firstElementChild;
      if (upIcon && upIconGlyph) {
        replace$3(upIcon, upIconGlyph);
      }
      result.content.append(fragmentFrom.html`
        <style>
          :host {
            align-items: center;
            display: inline-flex;
            padding: 2px;
          }

          :host(:not([disabled])):hover {
            background: #eee;
          }

          [part~="toggle-icon"] {
            fill: currentColor;
            height: 10px;
            margin: 0.25em;
            width: 10px;
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * Backdrop component in the Plain reference design system
   *
   * @inherits Backdrop
   */
  class PlainBackdrop extends Backdrop {}

  /**
   * OverlayFrame component in the Plain reference design system
   *
   * The default appearance of `OverlayFrame` uses a simple drop-shadow to let the
   * user see the framed content as being on top of the background page content.
   *
   * @inherits OverlayFrame
   */
  class PlainOverlayFrame extends OverlayFrame {
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          :host {
            background: white;
            border: 1px solid rgba(0, 0, 0, 0.2);
            box-shadow: 0 0px 10px rgba(0, 0, 0, 0.5);
            box-sizing: border-box;
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * Popup component in the Plain reference design system
   *
   * @inherits Popup
   * @part {PlainBackdrop} backdrop
   * @part {PlainOverlayFrame} frame
   */
  class PlainPopup extends Popup {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        backdropPartType: PlainBackdrop,
        framePartType: PlainOverlayFrame
      });
    }
  }

  /**
   * MenuButton component in the Plain reference design system
   *
   * @inherits MenuButton
   * @part {PlainMenu} menu
   * @part {PlainPopup} popup
   * @part {PlainOpenCloseToggle} popup-toggle
   * @part {PlainBorderButton} source
   * @mixes PopupToggleMixin
   */
  class PlainMenuButton extends PopupToggleMixin(MenuButton) {
    // @ts-ignore
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        menuPartType: PlainMenu,
        popupPartType: PlainPopup,
        popupTogglePartType: PlainOpenCloseToggle,
        sourcePartType: PlainBorderButton
      });
    }
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          [part~="menu"] {
            background: window;
            border: none;
            padding: 0.5em 0;
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * @class SePlainBorderButton
   * Button with a border in the Plain reference design system
   *
   */
  class SePlainBorderButton extends PlainButton {
    /**
      * @function get
      * @returns {PlainObject}
    */
    get [template$g]() {
      const result = super[template$g];
      result.content.append(fragmentFrom.html`
        <style>
          [part~="button"] {
            background: var(--main-bg-color);
            border: 1px solid #ccc;
          }
        </style>
      `);
      return result;
    }
  }

  /**
   * @class ElixMenuButton
   */
  class ElixMenuButton extends PlainMenuButton {
    /**
      * @function get
      * @returns {PlainObject}
    */
    get [defaultState]() {
      return Object.assign(super[defaultState], {
        sourcePartType: SePlainBorderButton
      });
    }
  }
  customElements.define('elix-menu-button', ElixMenuButton);

  /* globals svgEditor */
  const template$c = document.createElement('template');
  template$c.innerHTML = `
  <style>
  :host {
    padding: 0px;
  }
  elix-menu-button::part(menu) {
    background-color: var(--icon-bg-color) !important;
    color: #fff;
  }
  elix-menu-button::part(popup-toggle) {
    padding: 0.25em 0.30em !important
  }
  :host ::slotted([current]){
    background-color: var(--icon-bg-color-hover) !important;
    color: #fff;
  }
  :host ::slotted(*){
    padding: 0.25em 1.25em 0.25em 0.25em !important;
    margin: 2px;
  }
  </style>

  <elix-menu-button id="MenuButton" aria-label="Main Menu">
    <slot></slot>
  </elix-menu-button>

`;
  /**
   * @class SeMenu
   */
  class SeMenu extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$c.content.cloneNode(true));
      this.$menu = this._shadowRoot.querySelector('elix-menu-button');
      this.$label = this.$menu.shadowRoot.querySelector('#popupToggle').shadowRoot;
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['label', 'src'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      const image = new Image();
      if (oldValue === newValue) return;
      switch (name) {
        case 'src':
          image.src = this.imgPath + '/' + newValue;
          image.width = 24;
          image.height = 24;
          this.$label.prepend(image);
          break;
        case 'label':
          this.$label.prepend(newValue);
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get label() {
      return this.getAttribute('label');
    }

    /**
     * @function set
     * @returns {void}
     */
    set label(value) {
      this.setAttribute('label', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }
  }

  // Register
  customElements.define('se-menu', SeMenu);

  class ElixMenu extends PlainMenu {}
  customElements.define("elix-menu", ElixMenu);

  /* globals svgEditor */
  const template$b = document.createElement('template');
  template$b.innerHTML = `
  <style>
  </style>
  <elix-menu-item>
    <div style="display:flex; align-items: center;">
      <img src="logo.svg" alt="icon" style="display:none;" width="24"/>
      <span style="margin-left: 7px;"></span>
    </div>
  </elix-menu-item>
`;
  /**
   * @class SeMenuItem
   */
  class SeMenuItem extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$b.content.cloneNode(true));
      this.$img = this._shadowRoot.querySelector('img');
      this.$label = this._shadowRoot.querySelector('span');
      this.$menuitem = this._shadowRoot.querySelector('elix-menu-item');
      this.$svg = this.$menuitem.shadowRoot.querySelector('#checkmark');
      this.$svg.setAttribute('style', 'display: none;');
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['label', 'src'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      let shortcut = '';
      if (oldValue === newValue) return;
      switch (name) {
        case 'src':
          this.$img.style.display = 'inline-block';
          this.$img.setAttribute('src', this.imgPath + '/' + newValue);
          break;
        case 'label':
          shortcut = this.getAttribute('shortcut');
          this.$label.textContent = `${t$1(newValue)} ${shortcut ? `(${shortcut})` : ''}`;
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get label() {
      return this.getAttribute('label');
    }

    /**
     * @function set
     * @returns {void}
     */
    set label(value) {
      this.setAttribute('label', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }

    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      // capture shortcuts
      const shortcut = this.getAttribute('shortcut');
      if (shortcut) {
        // register the keydown event
        document.addEventListener('keydown', e => {
          // only track keyboard shortcuts for the body containing the SVG-Editor
          if (e.target.nodeName !== 'BODY') return;
          // normalize key
          const key = `${e.metaKey ? 'meta+' : ''}${e.ctrlKey ? 'ctrl+' : ''}${e.key.toUpperCase()}`;
          if (shortcut !== key) return;
          // launch the click event
          if (this.id) {
            document.getElementById(this.id).click();
          }
          e.preventDefault();
        });
      }
    }
  }

  // Register
  customElements.define('se-menu-item', SeMenuItem);

  function _defineProperty$1(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }

  const template$a = document.createElement('template');
  template$a.innerHTML = `
<style>
#select-container {
  margin-top: 10px;
  display: inline-block;
}

#select-container:hover {
  background-color: var(--icon-bg-color-hover);
}

#select-container::part(value) {
  background-color: var(--main-bg-color);
}

#select-container::part(popup-toggle) {
  display: none;
}
::slotted(*) {
  padding:0;
  width:100%;
}

.closed {
  display: none;
}

#options-container {
  position: fixed;
}

</style>
  <label>Label</label>
  <div id="select-container" tabindex="0">
    <div id="selected-value"></div>
    <div id="options-container">
      <slot></slot>
    </div>
  </div>

`;
  /**
   * @class SeList
   */
  class SeList extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      _defineProperty$1(this, "toggleList", e => {
        if (!this.isDropdownOpen) {
          this.openDropdown();
          this.setDropdownListPosition();
        } else {
          this.closeDropdown();
        }
      });
      _defineProperty$1(this, "updateSelectedValue", newValue => {
        Array.from(this.items).forEach(element => {
          if (element.getAttribute('value') === newValue) {
            element.setAttribute('selected', true);
            if (element.hasAttribute('src')) {
              // empty current selection children
              while (this.$selection.firstChild) {
                this.$selection.removeChild(this.$selection.firstChild);
              }
              // replace selection child with image of new value
              const img = document.createElement('img');
              img.src = this.imgPath + '/' + element.getAttribute('src');
              img.style.height = element.getAttribute('img-height');
              img.setAttribute('title', t$1(element.getAttribute('title')));
              this.$selection.append(img);
            } else {
              this.$selection.textContent = t$1(element.getAttribute('option'));
            }
          } else {
            element.setAttribute('selected', false);
          }
        });
      });
      _defineProperty$1(this, "openDropdown", () => {
        this.isDropdownOpen = true;
        this.$optionsContainer.classList.remove('closed');
      });
      _defineProperty$1(this, "closeDropdown", () => {
        this.isDropdownOpen = false;
        this.$optionsContainer.classList.add('closed');
      });
      _defineProperty$1(this, "setDropdownListPosition", () => {
        const windowHeight = window.innerHeight;
        const selectedContainerPosition = this.$selection.getBoundingClientRect();
        const optionsContainerPosition = this.$optionsContainer.getBoundingClientRect();
        // list is bottom of frame - needs to open from above
        if (selectedContainerPosition.bottom + optionsContainerPosition.height > windowHeight) {
          this.$optionsContainer.style.top = selectedContainerPosition.top - optionsContainerPosition.height + 'px';
          this.$optionsContainer.style.left = selectedContainerPosition.left + 'px';
        } else {
          this.$optionsContainer.style.top = selectedContainerPosition.bottom + 'px';
          this.$optionsContainer.style.left = selectedContainerPosition.left + 'px';
        }
      });
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$a.content.cloneNode(true));
      this.$dropdown = this._shadowRoot.querySelector('#select-container');
      this.$label = this._shadowRoot.querySelector('label');
      this.$selection = this.$dropdown.querySelector('#selected-value');
      this.items = this.querySelectorAll('se-list-item');
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
      this.$optionsContainer = this._shadowRoot.querySelector('#options-container');
      this.$optionsContainer.classList.add('closed');
      this.$selection.addEventListener('click', this.toggleList);
      this.updateSelectedValue(this.items[0].getAttribute('value'));
      this.isDropdownOpen = false;
    }
    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['label', 'width', 'height', 'title', 'value'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'title':
          this.$dropdown.setAttribute('title', t$1(newValue));
          break;
        case 'label':
          this.$label.textContent = t$1(newValue);
          break;
        case 'height':
          this.$dropdown.style.height = newValue;
          break;
        case 'width':
          this.$dropdown.style.width = newValue;
          break;
        case 'value':
          this.updateSelectedValue(newValue);
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get label() {
      return this.getAttribute('label');
    }

    /**
     * @function set
     * @returns {void}
     */
    set label(value) {
      this.setAttribute('label', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get width() {
      return this.getAttribute('width');
    }

    /**
     * @function set
     * @returns {void}
     */
    set width(value) {
      this.setAttribute('width', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get height() {
      return this.getAttribute('height');
    }

    /**
     * @function set
     * @returns {void}
     */
    set height(value) {
      this.setAttribute('height', value);
    }
    /**
     * @function connectedCallback
     * @returns {void}
     */
    connectedCallback() {
      const currentObj = this;
      this.$dropdown.addEventListener('selectedindexchange', e => {
        var _e$detail;
        if ((e === null || e === void 0 ? void 0 : (_e$detail = e.detail) === null || _e$detail === void 0 ? void 0 : _e$detail.selectedItem) !== undefined) {
          const value = e.detail.selectedItem;
          const closeEvent = new CustomEvent('change', {
            detail: {
              value
            }
          });
          currentObj.dispatchEvent(closeEvent);
          currentObj.value = value;
          currentObj.setAttribute('value', value);
        }
      });
      this.$dropdown.addEventListener('focusout', e => {
        this.closeDropdown();
      });
      window.addEventListener('mousedown', e => {
        // When we click on the canvas and if the dropdown is open, then just close the dropdown and stop the event
        if (this.isDropdownOpen) {
          if (!e.target.closest('se-list')) {
            e.stopPropagation();
            this.closeDropdown();
          }
        }
      }, {
        capture: true
      });
    }
  }

  // Register
  customElements.define('se-list', SeList);

  /* globals svgEditor */
  const template$9 = document.createElement('template');
  template$9.innerHTML = `
  <style>
  [aria-label="option"]{
    padding:0.25rem 0.125rem !important;
    background-color: var(--icon-bg-color);
  }
  [aria-label="option"]:hover{
    background-color: var(--icon-bg-color-hover);
  }

  .selected {
    background-color: var(--icon-bg-color-hover);
  }

  </style>
  <div aria-label="option">
    <img alt="icon" />
    <slot></slot>
  </div>
`;
  /**
   * @class SeMenu
   */
  class SeListItem extends HTMLElement {
    /**
      * @function constructor
      */
    constructor() {
      super();
      // create the shadowDom and insert the template
      this._shadowRoot = this.attachShadow({
        mode: 'open'
      });
      this._shadowRoot.append(template$9.content.cloneNode(true));
      this.$menuitem = this._shadowRoot.querySelector('[aria-label=option]');
      // this.$svg = this.$menuitem.shadowRoot.querySelector('#checkmark')
      // this.$svg.setAttribute('style', 'display: none;')
      this.$img = this._shadowRoot.querySelector('img');
      this.$img.setAttribute('style', 'display: none;');
      this.imgPath = svgEditor.configObj.curConfig.imgPath;
      this.$menuitem.addEventListener('mousedown', e => {
        this.$menuitem.dispatchEvent(new CustomEvent('selectedindexchange', {
          bubbles: true,
          composed: true,
          detail: {
            selectedItem: this.getAttribute('value')
          }
        }));
      });
    }

    /**
     * @function observedAttributes
     * @returns {any} observed
     */
    static get observedAttributes() {
      return ['option', 'src', 'title', 'img-height', 'selected'];
    }

    /**
     * @function attributeChangedCallback
     * @param {string} name
     * @param {string} oldValue
     * @param {string} newValue
     * @returns {void}
     */
    attributeChangedCallback(name, oldValue, newValue) {
      if (oldValue === newValue) return;
      switch (name) {
        case 'option':
          this.$menuitem.setAttribute('option', newValue);
          this.$menuitem.textContent = t$1(newValue);
          break;
        case 'src':
          this.$img.setAttribute('style', 'display: block;');
          this.$img.setAttribute('src', this.imgPath + '/' + newValue);
          break;
        case 'title':
          this.$img.setAttribute('title', t$1(newValue));
          break;
        case 'img-height':
          this.$img.setAttribute('height', newValue);
          break;
        case 'selected':
          if (newValue === 'true') {
            this.$menuitem.classList.add('selected');
          } else {
            this.$menuitem.classList.remove('selected');
          }
          break;
        default:
          console.error(`unknown attribute: ${name}`);
          break;
      }
    }

    /**
     * @function get
     * @returns {any}
     */
    get option() {
      return this.getAttribute('option');
    }

    /**
     * @function set
     * @returns {void}
     */
    set option(value) {
      this.setAttribute('option', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get title() {
      return this.getAttribute('title');
    }

    /**
     * @function set
     * @returns {void}
     */
    set title(value) {
      this.setAttribute('title', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get imgHeight() {
      return this.getAttribute('img-height');
    }

    /**
     * @function set
     * @returns {void}
     */
    set imgHeight(value) {
      this.setAttribute('img-height', value);
    }

    /**
     * @function get
     * @returns {any}
     */
    get src() {
      return this.getAttribute('src');
    }

    /**
     * @function set
     * @returns {void}
     */
    set src(value) {
      this.setAttribute('src', value);
    }
  }

  // Register
  customElements.define('se-list-item', SeListItem);

  function _mergeNamespaces$1(n,m){m.forEach(function(e){e&&typeof e!=='string'&&!Array.isArray(e)&&Object.keys(e).forEach(function(k){if(k!=='default'&&!(k in n)){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k];}});}});});return Object.freeze(n);}// SVGPathSeg API polyfill
  // https://github.com/progers/pathseg
  //
  // This is a drop-in replacement for the SVGPathSeg and SVGPathSegList APIs that were removed from
  // SVG2 (https://lists.w3.org/Archives/Public/www-svg/2015Jun/0044.html), including the latest spec
  // changes which were implemented in Firefox 43 and Chrome 46.
  (function(){// The polyfill only applies to browser environments with a `window` object 
  // (i.e. not node.js, workers, etc.). If included in one of these 
  // environments (such as when using 'react-dom/server'), simply return out
  if(typeof window==='undefined')return;if(!("SVGPathSeg"in window)){// Spec: http://www.w3.org/TR/SVG11/single-page.html#paths-InterfaceSVGPathSeg
  window.SVGPathSeg=function(type,typeAsLetter,owningPathSegList){this.pathSegType=type;this.pathSegTypeAsLetter=typeAsLetter;this._owningPathSegList=owningPathSegList;};window.SVGPathSeg.prototype.classname="SVGPathSeg";window.SVGPathSeg.PATHSEG_UNKNOWN=0;window.SVGPathSeg.PATHSEG_CLOSEPATH=1;window.SVGPathSeg.PATHSEG_MOVETO_ABS=2;window.SVGPathSeg.PATHSEG_MOVETO_REL=3;window.SVGPathSeg.PATHSEG_LINETO_ABS=4;window.SVGPathSeg.PATHSEG_LINETO_REL=5;window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS=6;window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL=7;window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS=8;window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL=9;window.SVGPathSeg.PATHSEG_ARC_ABS=10;window.SVGPathSeg.PATHSEG_ARC_REL=11;window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS=12;window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL=13;window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS=14;window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL=15;window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS=16;window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL=17;window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS=18;window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL=19;// Notify owning PathSegList on any changes so they can be synchronized back to the path element.
  window.SVGPathSeg.prototype._segmentChanged=function(){if(this._owningPathSegList)this._owningPathSegList.segmentChanged(this);};window.SVGPathSegClosePath=function(owningPathSegList){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CLOSEPATH,"z",owningPathSegList);};window.SVGPathSegClosePath.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegClosePath.prototype.toString=function(){return "[object SVGPathSegClosePath]";};window.SVGPathSegClosePath.prototype._asPathString=function(){return this.pathSegTypeAsLetter;};window.SVGPathSegClosePath.prototype.clone=function(){return new window.SVGPathSegClosePath(undefined);};window.SVGPathSegMovetoAbs=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_MOVETO_ABS,"M",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegMovetoAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegMovetoAbs.prototype.toString=function(){return "[object SVGPathSegMovetoAbs]";};window.SVGPathSegMovetoAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegMovetoAbs.prototype.clone=function(){return new window.SVGPathSegMovetoAbs(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegMovetoAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegMovetoAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegMovetoRel=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_MOVETO_REL,"m",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegMovetoRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegMovetoRel.prototype.toString=function(){return "[object SVGPathSegMovetoRel]";};window.SVGPathSegMovetoRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegMovetoRel.prototype.clone=function(){return new window.SVGPathSegMovetoRel(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegMovetoRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegMovetoRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoAbs=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_ABS,"L",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegLinetoAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoAbs.prototype.toString=function(){return "[object SVGPathSegLinetoAbs]";};window.SVGPathSegLinetoAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegLinetoAbs.prototype.clone=function(){return new window.SVGPathSegLinetoAbs(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegLinetoAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegLinetoAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoRel=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_REL,"l",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegLinetoRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoRel.prototype.toString=function(){return "[object SVGPathSegLinetoRel]";};window.SVGPathSegLinetoRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegLinetoRel.prototype.clone=function(){return new window.SVGPathSegLinetoRel(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegLinetoRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegLinetoRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoCubicAbs=function(owningPathSegList,x,y,x1,y1,x2,y2){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS,"C",owningPathSegList);this._x=x;this._y=y;this._x1=x1;this._y1=y1;this._x2=x2;this._y2=y2;};window.SVGPathSegCurvetoCubicAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoCubicAbs.prototype.toString=function(){return "[object SVGPathSegCurvetoCubicAbs]";};window.SVGPathSegCurvetoCubicAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x1+" "+this._y1+" "+this._x2+" "+this._y2+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoCubicAbs.prototype.clone=function(){return new window.SVGPathSegCurvetoCubicAbs(undefined,this._x,this._y,this._x1,this._y1,this._x2,this._y2);};Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"x1",{get:function(){return this._x1;},set:function(x1){this._x1=x1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"y1",{get:function(){return this._y1;},set:function(y1){this._y1=y1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"x2",{get:function(){return this._x2;},set:function(x2){this._x2=x2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicAbs.prototype,"y2",{get:function(){return this._y2;},set:function(y2){this._y2=y2;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoCubicRel=function(owningPathSegList,x,y,x1,y1,x2,y2){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL,"c",owningPathSegList);this._x=x;this._y=y;this._x1=x1;this._y1=y1;this._x2=x2;this._y2=y2;};window.SVGPathSegCurvetoCubicRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoCubicRel.prototype.toString=function(){return "[object SVGPathSegCurvetoCubicRel]";};window.SVGPathSegCurvetoCubicRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x1+" "+this._y1+" "+this._x2+" "+this._y2+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoCubicRel.prototype.clone=function(){return new window.SVGPathSegCurvetoCubicRel(undefined,this._x,this._y,this._x1,this._y1,this._x2,this._y2);};Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"x1",{get:function(){return this._x1;},set:function(x1){this._x1=x1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"y1",{get:function(){return this._y1;},set:function(y1){this._y1=y1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"x2",{get:function(){return this._x2;},set:function(x2){this._x2=x2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicRel.prototype,"y2",{get:function(){return this._y2;},set:function(y2){this._y2=y2;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoQuadraticAbs=function(owningPathSegList,x,y,x1,y1){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS,"Q",owningPathSegList);this._x=x;this._y=y;this._x1=x1;this._y1=y1;};window.SVGPathSegCurvetoQuadraticAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoQuadraticAbs.prototype.toString=function(){return "[object SVGPathSegCurvetoQuadraticAbs]";};window.SVGPathSegCurvetoQuadraticAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x1+" "+this._y1+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoQuadraticAbs.prototype.clone=function(){return new window.SVGPathSegCurvetoQuadraticAbs(undefined,this._x,this._y,this._x1,this._y1);};Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype,"x1",{get:function(){return this._x1;},set:function(x1){this._x1=x1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticAbs.prototype,"y1",{get:function(){return this._y1;},set:function(y1){this._y1=y1;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoQuadraticRel=function(owningPathSegList,x,y,x1,y1){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL,"q",owningPathSegList);this._x=x;this._y=y;this._x1=x1;this._y1=y1;};window.SVGPathSegCurvetoQuadraticRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoQuadraticRel.prototype.toString=function(){return "[object SVGPathSegCurvetoQuadraticRel]";};window.SVGPathSegCurvetoQuadraticRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x1+" "+this._y1+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoQuadraticRel.prototype.clone=function(){return new window.SVGPathSegCurvetoQuadraticRel(undefined,this._x,this._y,this._x1,this._y1);};Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype,"x1",{get:function(){return this._x1;},set:function(x1){this._x1=x1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticRel.prototype,"y1",{get:function(){return this._y1;},set:function(y1){this._y1=y1;this._segmentChanged();},enumerable:true});window.SVGPathSegArcAbs=function(owningPathSegList,x,y,r1,r2,angle,largeArcFlag,sweepFlag){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_ARC_ABS,"A",owningPathSegList);this._x=x;this._y=y;this._r1=r1;this._r2=r2;this._angle=angle;this._largeArcFlag=largeArcFlag;this._sweepFlag=sweepFlag;};window.SVGPathSegArcAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegArcAbs.prototype.toString=function(){return "[object SVGPathSegArcAbs]";};window.SVGPathSegArcAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._r1+" "+this._r2+" "+this._angle+" "+(this._largeArcFlag?"1":"0")+" "+(this._sweepFlag?"1":"0")+" "+this._x+" "+this._y;};window.SVGPathSegArcAbs.prototype.clone=function(){return new window.SVGPathSegArcAbs(undefined,this._x,this._y,this._r1,this._r2,this._angle,this._largeArcFlag,this._sweepFlag);};Object.defineProperty(window.SVGPathSegArcAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"r1",{get:function(){return this._r1;},set:function(r1){this._r1=r1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"r2",{get:function(){return this._r2;},set:function(r2){this._r2=r2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"angle",{get:function(){return this._angle;},set:function(angle){this._angle=angle;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"largeArcFlag",{get:function(){return this._largeArcFlag;},set:function(largeArcFlag){this._largeArcFlag=largeArcFlag;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcAbs.prototype,"sweepFlag",{get:function(){return this._sweepFlag;},set:function(sweepFlag){this._sweepFlag=sweepFlag;this._segmentChanged();},enumerable:true});window.SVGPathSegArcRel=function(owningPathSegList,x,y,r1,r2,angle,largeArcFlag,sweepFlag){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_ARC_REL,"a",owningPathSegList);this._x=x;this._y=y;this._r1=r1;this._r2=r2;this._angle=angle;this._largeArcFlag=largeArcFlag;this._sweepFlag=sweepFlag;};window.SVGPathSegArcRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegArcRel.prototype.toString=function(){return "[object SVGPathSegArcRel]";};window.SVGPathSegArcRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._r1+" "+this._r2+" "+this._angle+" "+(this._largeArcFlag?"1":"0")+" "+(this._sweepFlag?"1":"0")+" "+this._x+" "+this._y;};window.SVGPathSegArcRel.prototype.clone=function(){return new window.SVGPathSegArcRel(undefined,this._x,this._y,this._r1,this._r2,this._angle,this._largeArcFlag,this._sweepFlag);};Object.defineProperty(window.SVGPathSegArcRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"r1",{get:function(){return this._r1;},set:function(r1){this._r1=r1;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"r2",{get:function(){return this._r2;},set:function(r2){this._r2=r2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"angle",{get:function(){return this._angle;},set:function(angle){this._angle=angle;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"largeArcFlag",{get:function(){return this._largeArcFlag;},set:function(largeArcFlag){this._largeArcFlag=largeArcFlag;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegArcRel.prototype,"sweepFlag",{get:function(){return this._sweepFlag;},set:function(sweepFlag){this._sweepFlag=sweepFlag;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoHorizontalAbs=function(owningPathSegList,x){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS,"H",owningPathSegList);this._x=x;};window.SVGPathSegLinetoHorizontalAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoHorizontalAbs.prototype.toString=function(){return "[object SVGPathSegLinetoHorizontalAbs]";};window.SVGPathSegLinetoHorizontalAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x;};window.SVGPathSegLinetoHorizontalAbs.prototype.clone=function(){return new window.SVGPathSegLinetoHorizontalAbs(undefined,this._x);};Object.defineProperty(window.SVGPathSegLinetoHorizontalAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoHorizontalRel=function(owningPathSegList,x){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL,"h",owningPathSegList);this._x=x;};window.SVGPathSegLinetoHorizontalRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoHorizontalRel.prototype.toString=function(){return "[object SVGPathSegLinetoHorizontalRel]";};window.SVGPathSegLinetoHorizontalRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x;};window.SVGPathSegLinetoHorizontalRel.prototype.clone=function(){return new window.SVGPathSegLinetoHorizontalRel(undefined,this._x);};Object.defineProperty(window.SVGPathSegLinetoHorizontalRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoVerticalAbs=function(owningPathSegList,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS,"V",owningPathSegList);this._y=y;};window.SVGPathSegLinetoVerticalAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoVerticalAbs.prototype.toString=function(){return "[object SVGPathSegLinetoVerticalAbs]";};window.SVGPathSegLinetoVerticalAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._y;};window.SVGPathSegLinetoVerticalAbs.prototype.clone=function(){return new window.SVGPathSegLinetoVerticalAbs(undefined,this._y);};Object.defineProperty(window.SVGPathSegLinetoVerticalAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegLinetoVerticalRel=function(owningPathSegList,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL,"v",owningPathSegList);this._y=y;};window.SVGPathSegLinetoVerticalRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegLinetoVerticalRel.prototype.toString=function(){return "[object SVGPathSegLinetoVerticalRel]";};window.SVGPathSegLinetoVerticalRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._y;};window.SVGPathSegLinetoVerticalRel.prototype.clone=function(){return new window.SVGPathSegLinetoVerticalRel(undefined,this._y);};Object.defineProperty(window.SVGPathSegLinetoVerticalRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoCubicSmoothAbs=function(owningPathSegList,x,y,x2,y2){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS,"S",owningPathSegList);this._x=x;this._y=y;this._x2=x2;this._y2=y2;};window.SVGPathSegCurvetoCubicSmoothAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoCubicSmoothAbs.prototype.toString=function(){return "[object SVGPathSegCurvetoCubicSmoothAbs]";};window.SVGPathSegCurvetoCubicSmoothAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x2+" "+this._y2+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoCubicSmoothAbs.prototype.clone=function(){return new window.SVGPathSegCurvetoCubicSmoothAbs(undefined,this._x,this._y,this._x2,this._y2);};Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype,"x2",{get:function(){return this._x2;},set:function(x2){this._x2=x2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothAbs.prototype,"y2",{get:function(){return this._y2;},set:function(y2){this._y2=y2;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoCubicSmoothRel=function(owningPathSegList,x,y,x2,y2){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL,"s",owningPathSegList);this._x=x;this._y=y;this._x2=x2;this._y2=y2;};window.SVGPathSegCurvetoCubicSmoothRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoCubicSmoothRel.prototype.toString=function(){return "[object SVGPathSegCurvetoCubicSmoothRel]";};window.SVGPathSegCurvetoCubicSmoothRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x2+" "+this._y2+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoCubicSmoothRel.prototype.clone=function(){return new window.SVGPathSegCurvetoCubicSmoothRel(undefined,this._x,this._y,this._x2,this._y2);};Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype,"x2",{get:function(){return this._x2;},set:function(x2){this._x2=x2;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoCubicSmoothRel.prototype,"y2",{get:function(){return this._y2;},set:function(y2){this._y2=y2;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoQuadraticSmoothAbs=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS,"T",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype.toString=function(){return "[object SVGPathSegCurvetoQuadraticSmoothAbs]";};window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype.clone=function(){return new window.SVGPathSegCurvetoQuadraticSmoothAbs(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothAbs.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});window.SVGPathSegCurvetoQuadraticSmoothRel=function(owningPathSegList,x,y){window.SVGPathSeg.call(this,window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL,"t",owningPathSegList);this._x=x;this._y=y;};window.SVGPathSegCurvetoQuadraticSmoothRel.prototype=Object.create(window.SVGPathSeg.prototype);window.SVGPathSegCurvetoQuadraticSmoothRel.prototype.toString=function(){return "[object SVGPathSegCurvetoQuadraticSmoothRel]";};window.SVGPathSegCurvetoQuadraticSmoothRel.prototype._asPathString=function(){return this.pathSegTypeAsLetter+" "+this._x+" "+this._y;};window.SVGPathSegCurvetoQuadraticSmoothRel.prototype.clone=function(){return new window.SVGPathSegCurvetoQuadraticSmoothRel(undefined,this._x,this._y);};Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothRel.prototype,"x",{get:function(){return this._x;},set:function(x){this._x=x;this._segmentChanged();},enumerable:true});Object.defineProperty(window.SVGPathSegCurvetoQuadraticSmoothRel.prototype,"y",{get:function(){return this._y;},set:function(y){this._y=y;this._segmentChanged();},enumerable:true});// Add createSVGPathSeg* functions to window.SVGPathElement.
  // Spec: http://www.w3.org/TR/SVG11/single-page.html#paths-Interfacewindow.SVGPathElement.
  window.SVGPathElement.prototype.createSVGPathSegClosePath=function(){return new window.SVGPathSegClosePath(undefined);};window.SVGPathElement.prototype.createSVGPathSegMovetoAbs=function(x,y){return new window.SVGPathSegMovetoAbs(undefined,x,y);};window.SVGPathElement.prototype.createSVGPathSegMovetoRel=function(x,y){return new window.SVGPathSegMovetoRel(undefined,x,y);};window.SVGPathElement.prototype.createSVGPathSegLinetoAbs=function(x,y){return new window.SVGPathSegLinetoAbs(undefined,x,y);};window.SVGPathElement.prototype.createSVGPathSegLinetoRel=function(x,y){return new window.SVGPathSegLinetoRel(undefined,x,y);};window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicAbs=function(x,y,x1,y1,x2,y2){return new window.SVGPathSegCurvetoCubicAbs(undefined,x,y,x1,y1,x2,y2);};window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicRel=function(x,y,x1,y1,x2,y2){return new window.SVGPathSegCurvetoCubicRel(undefined,x,y,x1,y1,x2,y2);};window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticAbs=function(x,y,x1,y1){return new window.SVGPathSegCurvetoQuadraticAbs(undefined,x,y,x1,y1);};window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticRel=function(x,y,x1,y1){return new window.SVGPathSegCurvetoQuadraticRel(undefined,x,y,x1,y1);};window.SVGPathElement.prototype.createSVGPathSegArcAbs=function(x,y,r1,r2,angle,largeArcFlag,sweepFlag){return new window.SVGPathSegArcAbs(undefined,x,y,r1,r2,angle,largeArcFlag,sweepFlag);};window.SVGPathElement.prototype.createSVGPathSegArcRel=function(x,y,r1,r2,angle,largeArcFlag,sweepFlag){return new window.SVGPathSegArcRel(undefined,x,y,r1,r2,angle,largeArcFlag,sweepFlag);};window.SVGPathElement.prototype.createSVGPathSegLinetoHorizontalAbs=function(x){return new window.SVGPathSegLinetoHorizontalAbs(undefined,x);};window.SVGPathElement.prototype.createSVGPathSegLinetoHorizontalRel=function(x){return new window.SVGPathSegLinetoHorizontalRel(undefined,x);};window.SVGPathElement.prototype.createSVGPathSegLinetoVerticalAbs=function(y){return new window.SVGPathSegLinetoVerticalAbs(undefined,y);};window.SVGPathElement.prototype.createSVGPathSegLinetoVerticalRel=function(y){return new window.SVGPathSegLinetoVerticalRel(undefined,y);};window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothAbs=function(x,y,x2,y2){return new window.SVGPathSegCurvetoCubicSmoothAbs(undefined,x,y,x2,y2);};window.SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothRel=function(x,y,x2,y2){return new window.SVGPathSegCurvetoCubicSmoothRel(undefined,x,y,x2,y2);};window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs=function(x,y){return new window.SVGPathSegCurvetoQuadraticSmoothAbs(undefined,x,y);};window.SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothRel=function(x,y){return new window.SVGPathSegCurvetoQuadraticSmoothRel(undefined,x,y);};if(!("getPathSegAtLength"in window.SVGPathElement.prototype)){// Add getPathSegAtLength to SVGPathElement.
  // Spec: https://www.w3.org/TR/SVG11/single-page.html#paths-__svg__SVGPathElement__getPathSegAtLength
  // This polyfill requires SVGPathElement.getTotalLength to implement the distance-along-a-path algorithm.
  window.SVGPathElement.prototype.getPathSegAtLength=function(distance){if(distance===undefined||!isFinite(distance))throw "Invalid arguments.";var measurementElement=document.createElementNS("http://www.w3.org/2000/svg","path");measurementElement.setAttribute("d",this.getAttribute("d"));var lastPathSegment=measurementElement.pathSegList.numberOfItems-1;// If the path is empty, return 0.
  if(lastPathSegment<=0)return 0;do{measurementElement.pathSegList.removeItem(lastPathSegment);if(distance>measurementElement.getTotalLength())break;lastPathSegment--;}while(lastPathSegment>0);return lastPathSegment;};}}// Checking for SVGPathSegList in window checks for the case of an implementation without the
  // SVGPathSegList API.
  // The second check for appendItem is specific to Firefox 59+ which removed only parts of the
  // SVGPathSegList API (e.g., appendItem). In this case we need to re-implement the entire API
  // so the polyfill data (i.e., _list) is used throughout.
  if(!("SVGPathSegList"in window)||!("appendItem"in window.SVGPathSegList.prototype)){// Spec: http://www.w3.org/TR/SVG11/single-page.html#paths-InterfaceSVGPathSegList
  window.SVGPathSegList=function(pathElement){this._pathElement=pathElement;this._list=this._parsePath(this._pathElement.getAttribute("d"));// Use a MutationObserver to catch changes to the path's "d" attribute.
  this._mutationObserverConfig={"attributes":true,"attributeFilter":["d"]};this._pathElementMutationObserver=new MutationObserver(this._updateListFromPathMutations.bind(this));this._pathElementMutationObserver.observe(this._pathElement,this._mutationObserverConfig);};window.SVGPathSegList.prototype.classname="SVGPathSegList";Object.defineProperty(window.SVGPathSegList.prototype,"numberOfItems",{get:function(){this._checkPathSynchronizedToList();return this._list.length;},enumerable:true});// The length property was not specified but was in Firefox 58.
  Object.defineProperty(window.SVGPathSegList.prototype,"length",{get:function(){this._checkPathSynchronizedToList();return this._list.length;},enumerable:true});// Add the pathSegList accessors to window.SVGPathElement.
  // Spec: http://www.w3.org/TR/SVG11/single-page.html#paths-InterfaceSVGAnimatedPathData
  Object.defineProperty(window.SVGPathElement.prototype,"pathSegList",{get:function(){if(!this._pathSegList)this._pathSegList=new window.SVGPathSegList(this);return this._pathSegList;},enumerable:true});// FIXME: The following are not implemented and simply return window.SVGPathElement.pathSegList.
  Object.defineProperty(window.SVGPathElement.prototype,"normalizedPathSegList",{get:function(){return this.pathSegList;},enumerable:true});Object.defineProperty(window.SVGPathElement.prototype,"animatedPathSegList",{get:function(){return this.pathSegList;},enumerable:true});Object.defineProperty(window.SVGPathElement.prototype,"animatedNormalizedPathSegList",{get:function(){return this.pathSegList;},enumerable:true});// Process any pending mutations to the path element and update the list as needed.
  // This should be the first call of all public functions and is needed because
  // MutationObservers are not synchronous so we can have pending asynchronous mutations.
  window.SVGPathSegList.prototype._checkPathSynchronizedToList=function(){this._updateListFromPathMutations(this._pathElementMutationObserver.takeRecords());};window.SVGPathSegList.prototype._updateListFromPathMutations=function(mutationRecords){if(!this._pathElement)return;var hasPathMutations=false;mutationRecords.forEach(function(record){if(record.attributeName=="d")hasPathMutations=true;});if(hasPathMutations)this._list=this._parsePath(this._pathElement.getAttribute("d"));};// Serialize the list and update the path's 'd' attribute.
  window.SVGPathSegList.prototype._writeListToPath=function(){this._pathElementMutationObserver.disconnect();this._pathElement.setAttribute("d",window.SVGPathSegList._pathSegArrayAsString(this._list));this._pathElementMutationObserver.observe(this._pathElement,this._mutationObserverConfig);};// When a path segment changes the list needs to be synchronized back to the path element.
  window.SVGPathSegList.prototype.segmentChanged=function(pathSeg){this._writeListToPath();};window.SVGPathSegList.prototype.clear=function(){this._checkPathSynchronizedToList();this._list.forEach(function(pathSeg){pathSeg._owningPathSegList=null;});this._list=[];this._writeListToPath();};window.SVGPathSegList.prototype.initialize=function(newItem){this._checkPathSynchronizedToList();this._list=[newItem];newItem._owningPathSegList=this;this._writeListToPath();return newItem;};window.SVGPathSegList.prototype._checkValidIndex=function(index){if(isNaN(index)||index<0||index>=this.numberOfItems)throw "INDEX_SIZE_ERR";};window.SVGPathSegList.prototype.getItem=function(index){this._checkPathSynchronizedToList();this._checkValidIndex(index);return this._list[index];};window.SVGPathSegList.prototype.insertItemBefore=function(newItem,index){this._checkPathSynchronizedToList();// Spec: If the index is greater than or equal to numberOfItems, then the new item is appended to the end of the list.
  if(index>this.numberOfItems)index=this.numberOfItems;if(newItem._owningPathSegList){// SVG2 spec says to make a copy.
  newItem=newItem.clone();}this._list.splice(index,0,newItem);newItem._owningPathSegList=this;this._writeListToPath();return newItem;};window.SVGPathSegList.prototype.replaceItem=function(newItem,index){this._checkPathSynchronizedToList();if(newItem._owningPathSegList){// SVG2 spec says to make a copy.
  newItem=newItem.clone();}this._checkValidIndex(index);this._list[index]=newItem;newItem._owningPathSegList=this;this._writeListToPath();return newItem;};window.SVGPathSegList.prototype.removeItem=function(index){this._checkPathSynchronizedToList();this._checkValidIndex(index);var item=this._list[index];this._list.splice(index,1);this._writeListToPath();return item;};window.SVGPathSegList.prototype.appendItem=function(newItem){this._checkPathSynchronizedToList();if(newItem._owningPathSegList){// SVG2 spec says to make a copy.
  newItem=newItem.clone();}this._list.push(newItem);newItem._owningPathSegList=this;// TODO: Optimize this to just append to the existing attribute.
  this._writeListToPath();return newItem;};window.SVGPathSegList._pathSegArrayAsString=function(pathSegArray){var string="";var first=true;pathSegArray.forEach(function(pathSeg){if(first){first=false;string+=pathSeg._asPathString();}else {string+=" "+pathSeg._asPathString();}});return string;};// This closely follows SVGPathParser::parsePath from Source/core/svg/SVGPathParser.cpp.
  window.SVGPathSegList.prototype._parsePath=function(string){if(!string||string.length==0)return [];var owningPathSegList=this;var Builder=function(){this.pathSegList=[];};Builder.prototype.appendSegment=function(pathSeg){this.pathSegList.push(pathSeg);};var Source=function(string){this._string=string;this._currentIndex=0;this._endIndex=this._string.length;this._previousCommand=window.SVGPathSeg.PATHSEG_UNKNOWN;this._skipOptionalSpaces();};Source.prototype._isCurrentSpace=function(){var character=this._string[this._currentIndex];return character<=" "&&(character==" "||character=="\n"||character=="\t"||character=="\r"||character=="\f");};Source.prototype._skipOptionalSpaces=function(){while(this._currentIndex<this._endIndex&&this._isCurrentSpace())this._currentIndex++;return this._currentIndex<this._endIndex;};Source.prototype._skipOptionalSpacesOrDelimiter=function(){if(this._currentIndex<this._endIndex&&!this._isCurrentSpace()&&this._string.charAt(this._currentIndex)!=",")return false;if(this._skipOptionalSpaces()){if(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)==","){this._currentIndex++;this._skipOptionalSpaces();}}return this._currentIndex<this._endIndex;};Source.prototype.hasMoreData=function(){return this._currentIndex<this._endIndex;};Source.prototype.peekSegmentType=function(){var lookahead=this._string[this._currentIndex];return this._pathSegTypeFromChar(lookahead);};Source.prototype._pathSegTypeFromChar=function(lookahead){switch(lookahead){case"Z":case"z":return window.SVGPathSeg.PATHSEG_CLOSEPATH;case"M":return window.SVGPathSeg.PATHSEG_MOVETO_ABS;case"m":return window.SVGPathSeg.PATHSEG_MOVETO_REL;case"L":return window.SVGPathSeg.PATHSEG_LINETO_ABS;case"l":return window.SVGPathSeg.PATHSEG_LINETO_REL;case"C":return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS;case"c":return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL;case"Q":return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;case"q":return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;case"A":return window.SVGPathSeg.PATHSEG_ARC_ABS;case"a":return window.SVGPathSeg.PATHSEG_ARC_REL;case"H":return window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;case"h":return window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;case"V":return window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;case"v":return window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;case"S":return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;case"s":return window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;case"T":return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;case"t":return window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;default:return window.SVGPathSeg.PATHSEG_UNKNOWN;}};Source.prototype._nextCommandHelper=function(lookahead,previousCommand){// Check for remaining coordinates in the current command.
  if((lookahead=="+"||lookahead=="-"||lookahead=="."||lookahead>="0"&&lookahead<="9")&&previousCommand!=window.SVGPathSeg.PATHSEG_CLOSEPATH){if(previousCommand==window.SVGPathSeg.PATHSEG_MOVETO_ABS)return window.SVGPathSeg.PATHSEG_LINETO_ABS;if(previousCommand==window.SVGPathSeg.PATHSEG_MOVETO_REL)return window.SVGPathSeg.PATHSEG_LINETO_REL;return previousCommand;}return window.SVGPathSeg.PATHSEG_UNKNOWN;};Source.prototype.initialCommandIsMoveTo=function(){// If the path is empty it is still valid, so return true.
  if(!this.hasMoreData())return true;var command=this.peekSegmentType();// Path must start with moveTo.
  return command==window.SVGPathSeg.PATHSEG_MOVETO_ABS||command==window.SVGPathSeg.PATHSEG_MOVETO_REL;};// Parse a number from an SVG path. This very closely follows genericParseNumber(...) from Source/core/svg/SVGParserUtilities.cpp.
  // Spec: http://www.w3.org/TR/SVG11/single-page.html#paths-PathDataBNF
  Source.prototype._parseNumber=function(){var exponent=0;var integer=0;var frac=1;var decimal=0;var sign=1;var expsign=1;var startIndex=this._currentIndex;this._skipOptionalSpaces();// Read the sign.
  if(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)=="+")this._currentIndex++;else if(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)=="-"){this._currentIndex++;sign=-1;}if(this._currentIndex==this._endIndex||(this._string.charAt(this._currentIndex)<"0"||this._string.charAt(this._currentIndex)>"9")&&this._string.charAt(this._currentIndex)!=".")// The first character of a number must be one of [0-9+-.].
  return undefined;// Read the integer part, build right-to-left.
  var startIntPartIndex=this._currentIndex;while(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)>="0"&&this._string.charAt(this._currentIndex)<="9")this._currentIndex++;// Advance to first non-digit.
  if(this._currentIndex!=startIntPartIndex){var scanIntPartIndex=this._currentIndex-1;var multiplier=1;while(scanIntPartIndex>=startIntPartIndex){integer+=multiplier*(this._string.charAt(scanIntPartIndex--)-"0");multiplier*=10;}}// Read the decimals.
  if(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)=="."){this._currentIndex++;// There must be a least one digit following the .
  if(this._currentIndex>=this._endIndex||this._string.charAt(this._currentIndex)<"0"||this._string.charAt(this._currentIndex)>"9")return undefined;while(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)>="0"&&this._string.charAt(this._currentIndex)<="9"){frac*=10;decimal+=(this._string.charAt(this._currentIndex)-"0")/frac;this._currentIndex+=1;}}// Read the exponent part.
  if(this._currentIndex!=startIndex&&this._currentIndex+1<this._endIndex&&(this._string.charAt(this._currentIndex)=="e"||this._string.charAt(this._currentIndex)=="E")&&this._string.charAt(this._currentIndex+1)!="x"&&this._string.charAt(this._currentIndex+1)!="m"){this._currentIndex++;// Read the sign of the exponent.
  if(this._string.charAt(this._currentIndex)=="+"){this._currentIndex++;}else if(this._string.charAt(this._currentIndex)=="-"){this._currentIndex++;expsign=-1;}// There must be an exponent.
  if(this._currentIndex>=this._endIndex||this._string.charAt(this._currentIndex)<"0"||this._string.charAt(this._currentIndex)>"9")return undefined;while(this._currentIndex<this._endIndex&&this._string.charAt(this._currentIndex)>="0"&&this._string.charAt(this._currentIndex)<="9"){exponent*=10;exponent+=this._string.charAt(this._currentIndex)-"0";this._currentIndex++;}}var number=integer+decimal;number*=sign;if(exponent)number*=Math.pow(10,expsign*exponent);if(startIndex==this._currentIndex)return undefined;this._skipOptionalSpacesOrDelimiter();return number;};Source.prototype._parseArcFlag=function(){if(this._currentIndex>=this._endIndex)return undefined;var flag=false;var flagChar=this._string.charAt(this._currentIndex++);if(flagChar=="0")flag=false;else if(flagChar=="1")flag=true;else return undefined;this._skipOptionalSpacesOrDelimiter();return flag;};Source.prototype.parseSegment=function(){var lookahead=this._string[this._currentIndex];var command=this._pathSegTypeFromChar(lookahead);if(command==window.SVGPathSeg.PATHSEG_UNKNOWN){// Possibly an implicit command. Not allowed if this is the first command.
  if(this._previousCommand==window.SVGPathSeg.PATHSEG_UNKNOWN)return null;command=this._nextCommandHelper(lookahead,this._previousCommand);if(command==window.SVGPathSeg.PATHSEG_UNKNOWN)return null;}else {this._currentIndex++;}this._previousCommand=command;switch(command){case window.SVGPathSeg.PATHSEG_MOVETO_REL:return new window.SVGPathSegMovetoRel(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_MOVETO_ABS:return new window.SVGPathSegMovetoAbs(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_REL:return new window.SVGPathSegLinetoRel(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_ABS:return new window.SVGPathSegLinetoAbs(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL:return new window.SVGPathSegLinetoHorizontalRel(owningPathSegList,this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS:return new window.SVGPathSegLinetoHorizontalAbs(owningPathSegList,this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL:return new window.SVGPathSegLinetoVerticalRel(owningPathSegList,this._parseNumber());case window.SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS:return new window.SVGPathSegLinetoVerticalAbs(owningPathSegList,this._parseNumber());case window.SVGPathSeg.PATHSEG_CLOSEPATH:this._skipOptionalSpaces();return new window.SVGPathSegClosePath(owningPathSegList);case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL:var points={x1:this._parseNumber(),y1:this._parseNumber(),x2:this._parseNumber(),y2:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoCubicRel(owningPathSegList,points.x,points.y,points.x1,points.y1,points.x2,points.y2);case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS:var points={x1:this._parseNumber(),y1:this._parseNumber(),x2:this._parseNumber(),y2:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoCubicAbs(owningPathSegList,points.x,points.y,points.x1,points.y1,points.x2,points.y2);case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL:var points={x2:this._parseNumber(),y2:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoCubicSmoothRel(owningPathSegList,points.x,points.y,points.x2,points.y2);case window.SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS:var points={x2:this._parseNumber(),y2:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoCubicSmoothAbs(owningPathSegList,points.x,points.y,points.x2,points.y2);case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL:var points={x1:this._parseNumber(),y1:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoQuadraticRel(owningPathSegList,points.x,points.y,points.x1,points.y1);case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS:var points={x1:this._parseNumber(),y1:this._parseNumber(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegCurvetoQuadraticAbs(owningPathSegList,points.x,points.y,points.x1,points.y1);case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL:return new window.SVGPathSegCurvetoQuadraticSmoothRel(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS:return new window.SVGPathSegCurvetoQuadraticSmoothAbs(owningPathSegList,this._parseNumber(),this._parseNumber());case window.SVGPathSeg.PATHSEG_ARC_REL:var points={x1:this._parseNumber(),y1:this._parseNumber(),arcAngle:this._parseNumber(),arcLarge:this._parseArcFlag(),arcSweep:this._parseArcFlag(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegArcRel(owningPathSegList,points.x,points.y,points.x1,points.y1,points.arcAngle,points.arcLarge,points.arcSweep);case window.SVGPathSeg.PATHSEG_ARC_ABS:var points={x1:this._parseNumber(),y1:this._parseNumber(),arcAngle:this._parseNumber(),arcLarge:this._parseArcFlag(),arcSweep:this._parseArcFlag(),x:this._parseNumber(),y:this._parseNumber()};return new window.SVGPathSegArcAbs(owningPathSegList,points.x,points.y,points.x1,points.y1,points.arcAngle,points.arcLarge,points.arcSweep);default:throw "Unknown path seg type.";}};var builder=new Builder();var source=new Source(string);if(!source.initialCommandIsMoveTo())return [];while(source.hasMoreData()){var pathSeg=source.parseSegment();if(!pathSeg)return [];builder.appendSegment(pathSeg);}return builder.pathSegList;};}})();/**
   *
   */class Paint{/**
     * @param {module:jGraduate.jGraduatePaintOptions} [opt]
    */constructor(opt){const options=opt||{};this.alpha=isNaN(options.alpha)?100:options.alpha;// copy paint object
  if(options.copy){/**
         * @name module:jGraduate~Paint#type
         * @type {"none"|"solidColor"|"linearGradient"|"radialGradient"}
         */this.type=options.copy.type;/**
         * Represents opacity (0-100).
         * @name module:jGraduate~Paint#alpha
         * @type {Float}
         */this.alpha=options.copy.alpha;/**
         * Represents #RRGGBB hex of color.
         * @name module:jGraduate~Paint#solidColor
         * @type {string}
         */this.solidColor=null;/**
         * @name module:jGraduate~Paint#linearGradient
         * @type {SVGLinearGradientElement}
         */this.linearGradient=null;/**
         * @name module:jGraduate~Paint#radialGradient
         * @type {SVGRadialGradientElement}
         */this.radialGradient=null;switch(this.type){case'none':break;case'solidColor':this.solidColor=options.copy.solidColor;break;case'linearGradient':this.linearGradient=options.copy.linearGradient.cloneNode(true);break;case'radialGradient':this.radialGradient=options.copy.radialGradient.cloneNode(true);break;}// create linear gradient paint
  }else if(options.linearGradient){this.type='linearGradient';this.solidColor=null;this.radialGradient=null;if(options.linearGradient.hasAttribute('xlink:href')){const xhref=document.getElementById(options.linearGradient.getAttribute('xlink:href').substr(1));this.linearGradient=xhref.cloneNode(true);}else {this.linearGradient=options.linearGradient.cloneNode(true);}// create linear gradient paint
  }else if(options.radialGradient){this.type='radialGradient';this.solidColor=null;this.linearGradient=null;if(options.radialGradient.hasAttribute('xlink:href')){const xhref=document.getElementById(options.radialGradient.getAttribute('xlink:href').substr(1));this.radialGradient=xhref.cloneNode(true);}else {this.radialGradient=options.radialGradient.cloneNode(true);}// create solid color paint
  }else if(options.solidColor){this.type='solidColor';this.solidColor=options.solidColor;// create empty paint
  }else {this.type='none';this.solidColor=null;this.linearGradient=null;this.radialGradient=null;}}}/**
   * Tools for working with units.
   * @module units
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */const NSSVG$1='http://www.w3.org/2000/svg';const wAttrs=['x','x1','cx','rx','width'];const hAttrs=['y','y1','cy','ry','height'];const unitAttrs=['r','radius',...wAttrs,...hAttrs];// Container of elements.
  let elementContainer_;// Stores mapping of unit type to user coordinates.
  let typeMap_={};/**
   * @interface module:units.ElementContainer
   */ /**
   * @function module:units.ElementContainer#getBaseUnit
   * @returns {string} The base unit type of the container ('em')
   */ /**
   * @function module:units.ElementContainer#getElement
   * @returns {?Element} An element in the container given an id
   */ /**
   * @function module:units.ElementContainer#getHeight
   * @returns {Float} The container's height
   */ /**
   * @function module:units.ElementContainer#getWidth
   * @returns {Float} The container's width
   */ /**
   * @function module:units.ElementContainer#getRoundDigits
   * @returns {Integer} The number of digits number should be rounded to
   */ /**
   * @typedef {PlainObject} module:units.TypeMap
   * @property {Float} em
   * @property {Float} ex
   * @property {Float} in
   * @property {Float} cm
   * @property {Float} mm
   * @property {Float} pt
   * @property {Float} pc
   * @property {Integer} px
   * @property {0} %
   */ /**
   * Initializes this module.
   *
   * @function module:units.init
   * @param {module:units.ElementContainer} elementContainer - An object implementing the ElementContainer interface.
   * @returns {void}
   */const init$k=function(elementContainer){elementContainer_=elementContainer;// Get correct em/ex values by creating a temporary SVG.
  const svg=document.createElementNS(NSSVG$1,'svg');document.body.append(svg);const rect=document.createElementNS(NSSVG$1,'rect');rect.setAttribute('width','1em');rect.setAttribute('height','1ex');rect.setAttribute('x','1in');svg.append(rect);const bb=rect.getBBox();svg.remove();const inch=bb.x;typeMap_={em:bb.width,ex:bb.height,in:inch,cm:inch/2.54,mm:inch/25.4,pt:inch/72,pc:inch/6,px:1,'%':0};};/**
  * Group: Unit conversion functions.
  */ /**
   * @function module:units.getTypeMap
   * @returns {module:units.TypeMap} The unit object with values for each unit
  */const getTypeMap$2=()=>{return typeMap_;};/**
  * @typedef {GenericArray} module:units.CompareNumbers
  * @property {Integer} length 2
  * @property {Float} 0
  * @property {Float} 1
  */ /**
  * Rounds a given value to a float with number of digits defined in
  * `round_digits` of `saveOptions`
  *
  * @function module:units.shortFloat
  * @param {string|Float|module:units.CompareNumbers} val - The value (or Array of two numbers) to be rounded
  * @returns {Float|string} If a string/number was given, returns a Float. If an array, return a string
  * with comma-separated floats
  */const shortFloat=val=>{const digits=elementContainer_.getRoundDigits();if(!isNaN(val)){return Number(Number(val).toFixed(digits));}if(Array.isArray(val)){return shortFloat(val[0])+','+shortFloat(val[1]);}return Number.parseFloat(val).toFixed(digits)-0;};/**
  * Converts the number to given unit or baseUnit.
  * @function module:units.convertUnit
  * @param {string|Float} val
  * @param {"em"|"ex"|"in"|"cm"|"mm"|"pt"|"pc"|"px"|"%"} [unit]
  * @returns {Float}
  */const convertUnit$3=(val,unit)=>{unit=unit||elementContainer_.getBaseUnit();// baseVal.convertToSpecifiedUnits(unitNumMap[unit]);
  // const val = baseVal.valueInSpecifiedUnits;
  // baseVal.convertToSpecifiedUnits(1);
  return shortFloat(val/typeMap_[unit]);};/**
  * Sets an element's attribute based on the unit in its current value.
  *
  * @function module:units.setUnitAttr
  * @param {Element} elem - DOM element to be changed
  * @param {string} attr - Name of the attribute associated with the value
  * @param {string} val - Attribute value to convert
  * @returns {void}
  */const setUnitAttr=(elem,attr,val)=>{elem.setAttribute(attr,val);};/**
  * Converts given values to numbers. Attributes must be supplied in
  * case a percentage is given.
  *
  * @function module:units.convertToNum
  * @param {string} attr - Name of the attribute associated with the value
  * @param {string} val - Attribute value to convert
  * @returns {Float} The converted number
  */const convertToNum=(attr,val)=>{// Return a number if that's what it already is
  if(!isNaN(val)){return val-0;}if(val.substr(-1)==='%'){// Deal with percentage, depends on attribute
  const num=val.substr(0,val.length-1)/100;const width=elementContainer_.getWidth();const height=elementContainer_.getHeight();if(wAttrs.includes(attr)){return num*width;}if(hAttrs.includes(attr)){return num*height;}return num*Math.sqrt(width*width+height*height)/Math.sqrt(2);}const unit=val.substr(-2);const num=val.substr(0,val.length-2);// Note that this multiplication turns the string into a number
  return num*typeMap_[unit];};/**
  * Check if an attribute's value is in a valid format.
  * @function module:units.isValidUnit
  * @param {string} attr - The name of the attribute associated with the value
  * @param {string} val - The attribute value to check
  * @param {Element} selectedElement
  * @returns {boolean} Whether the unit is valid
  */const isValidUnit$3=(attr,val,selectedElement)=>{if(unitAttrs.includes(attr)){// True if it's just a number
  if(!isNaN(val)){return true;}// Not a number, check if it has a valid unit
  val=val.toLowerCase();return Object.keys(typeMap_).some(unit=>{const re=new RegExp('^-?[\\d\\.]+'+unit+'$');return re.test(val);});}if(attr==='id'){// if we're trying to change the id, make sure it's not already present in the doc
  // and the id value is valid.
  let result=false;// because getElement() can throw an exception in the case of an invalid id
  // (according to https://www.w3.org/TR/xml-id/ IDs must be a NCName)
  // we wrap it in an exception and only return true if the ID was valid and
  // not already present
  try{const elem=elementContainer_.getElement(val);result=!elem||elem===selectedElement;}catch(e){console.error(e);}return result;}return true;};/**
   * Namespaces or tools therefor.
   * @module namespaces
   * @license MIT
  */ /**
  * Common namepaces constants in alpha order.
  * @enum {string}
  * @type {PlainObject}
  * @memberof module:namespaces
  */const NS={HTML:'http://www.w3.org/1999/xhtml',MATH:'http://www.w3.org/1998/Math/MathML',SE:'http://svg-edit.googlecode.com',SVG:'http://www.w3.org/2000/svg',XLINK:'http://www.w3.org/1999/xlink',OI:'http://www.optimistik.fr/namespace/svg/OIdata',XML:'http://www.w3.org/XML/1998/namespace',XMLNS:'http://www.w3.org/2000/xmlns/'// see http://www.w3.org/TR/REC-xml-names/#xmlReserved
  // SODIPODI: 'http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd',
  // INKSCAPE: 'http://www.inkscape.org/namespaces/inkscape',
  // RDF: 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
  // OSB: 'http://www.openswatchbook.org/uri/2009/osb',
  // CC: 'http://creativecommons.org/ns#',
  // DC: 'http://purl.org/dc/elements/1.1/'
  };/**
  * @function module:namespaces.getReverseNS
  * @returns {string} The NS with key values switched and lowercase
  */const getReverseNS=function(){const reverseNS={};Object.entries(NS).forEach(_ref4=>{let[name,URI]=_ref4;reverseNS[URI]=name.toLowerCase();});return reverseNS;};/**
   * Mathematical utilities.
   * @module math
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */ // Constants
  const NEAR_ZERO=1e-14;// Throw away SVGSVGElement used for creating matrices/transforms.
  const svg=document.createElementNS(NS.SVG,'svg');/**
   * A (hopefully) quicker function to transform a point by a matrix
   * (this function avoids any DOM calls and just does the math).
   * @function module:math.transformPoint
   * @param {Float} x - Float representing the x coordinate
   * @param {Float} y - Float representing the y coordinate
   * @param {SVGMatrix} m - Matrix object to transform the point with
   * @returns {module:math.XYObject} An x, y object representing the transformed point
  */const transformPoint=function(x,y,m){return {x:m.a*x+m.c*y+m.e,y:m.b*x+m.d*y+m.f};};/**
   * Helper function to check if the matrix performs no actual transform
   * (i.e. exists for identity purposes).
   * @function module:math.isIdentity
   * @param {SVGMatrix} m - The matrix object to check
   * @returns {boolean} Indicates whether or not the matrix is 1,0,0,1,0,0
  */const isIdentity=function(m){return m.a===1&&m.b===0&&m.c===0&&m.d===1&&m.e===0&&m.f===0;};/**
   * This function tries to return a `SVGMatrix` that is the multiplication `m1 * m2`.
   * We also round to zero when it's near zero.
   * @function module:math.matrixMultiply
   * @param {...SVGMatrix} args - Matrix objects to multiply
   * @returns {SVGMatrix} The matrix object resulting from the calculation
  */const matrixMultiply=function(){for(var _len3=arguments.length,args=new Array(_len3),_key3=0;_key3<_len3;_key3++){args[_key3]=arguments[_key3];}const m=args.reduceRight((prev,m1)=>{return m1.multiply(prev);});if(Math.abs(m.a)<NEAR_ZERO){m.a=0;}if(Math.abs(m.b)<NEAR_ZERO){m.b=0;}if(Math.abs(m.c)<NEAR_ZERO){m.c=0;}if(Math.abs(m.d)<NEAR_ZERO){m.d=0;}if(Math.abs(m.e)<NEAR_ZERO){m.e=0;}if(Math.abs(m.f)<NEAR_ZERO){m.f=0;}return m;};/**
   * See if the given transformlist includes a non-indentity matrix transform.
   * @function module:math.hasMatrixTransform
   * @param {SVGTransformList} [tlist] - The transformlist to check
   * @returns {boolean} Whether or not a matrix transform was found
  */const hasMatrixTransform=function(tlist){if(!tlist){return false;}let num=tlist.numberOfItems;while(num--){const xform=tlist.getItem(num);if(xform.type===1&&!isIdentity(xform.matrix)){return true;}}return false;};/**
  * @typedef {PlainObject} module:math.TransformedBox An object with the following values
  * @property {module:math.XYObject} tl - The top left coordinate
  * @property {module:math.XYObject} tr - The top right coordinate
  * @property {module:math.XYObject} bl - The bottom left coordinate
  * @property {module:math.XYObject} br - The bottom right coordinate
  * @property {PlainObject} aabox - Object with the following values:
  * @property {Float} aabox.x - Float with the axis-aligned x coordinate
  * @property {Float} aabox.y - Float with the axis-aligned y coordinate
  * @property {Float} aabox.width - Float with the axis-aligned width coordinate
  * @property {Float} aabox.height - Float with the axis-aligned height coordinate
  */ /**
   * Transforms a rectangle based on the given matrix.
   * @function module:math.transformBox
   * @param {Float} l - Float with the box's left coordinate
   * @param {Float} t - Float with the box's top coordinate
   * @param {Float} w - Float with the box width
   * @param {Float} h - Float with the box height
   * @param {SVGMatrix} m - Matrix object to transform the box by
   * @returns {module:math.TransformedBox}
  */const transformBox=function(l,t,w,h,m){const tl=transformPoint(l,t,m);const tr=transformPoint(l+w,t,m);const bl=transformPoint(l,t+h,m);const br=transformPoint(l+w,t+h,m);const minx=Math.min(tl.x,tr.x,bl.x,br.x);const maxx=Math.max(tl.x,tr.x,bl.x,br.x);const miny=Math.min(tl.y,tr.y,bl.y,br.y);const maxy=Math.max(tl.y,tr.y,bl.y,br.y);return {tl,tr,bl,br,aabox:{x:minx,y:miny,width:maxx-minx,height:maxy-miny}};};/**
   * This returns a single matrix Transform for a given Transform List
   * (this is the equivalent of `SVGTransformList.consolidate()` but unlike
   * that method, this one does not modify the actual `SVGTransformList`).
   * This function is very liberal with its `min`, `max` arguments.
   * @function module:math.transformListToTransform
   * @param {SVGTransformList} tlist - The transformlist object
   * @param {Integer} [min=0] - Optional integer indicating start transform position
   * @param {Integer} [max] - Optional integer indicating end transform position;
   *   defaults to one less than the tlist's `numberOfItems`
   * @returns {SVGTransform} A single matrix transform object
  */const transformListToTransform=function(tlist,min,max){if(!tlist){// Or should tlist = null have been prevented before this?
  return svg.createSVGTransformFromMatrix(svg.createSVGMatrix());}min=min||0;max=max||tlist.numberOfItems-1;min=Number.parseInt(min);max=Number.parseInt(max);if(min>max){const temp=max;max=min;min=temp;}let m=svg.createSVGMatrix();for(let i=min;i<=max;++i){// if our indices are out of range, just use a harmless identity matrix
  const mtom=i>=0&&i<tlist.numberOfItems?tlist.getItem(i).matrix:svg.createSVGMatrix();m=matrixMultiply(m,mtom);}return svg.createSVGTransformFromMatrix(m);};/**
   * Get the matrix object for a given element.
   * @function module:math.getMatrix
   * @param {Element} elem - The DOM element to check
   * @returns {SVGMatrix} The matrix object associated with the element's transformlist
  */const getMatrix=elem=>{const tlist=elem.transform.baseVal;return transformListToTransform(tlist).matrix;};/**
   * Returns a 45 degree angle coordinate associated with the two given
   * coordinates.
   * @function module:math.snapToAngle
   * @param {Integer} x1 - First coordinate's x value
   * @param {Integer} y1 - First coordinate's y value
   * @param {Integer} x2 - Second coordinate's x value
   * @param {Integer} y2 - Second coordinate's y value
   * @returns {module:math.AngleCoord45}
  */const snapToAngle=(x1,y1,x2,y2)=>{const snap=Math.PI/4;// 45 degrees
  const dx=x2-x1;const dy=y2-y1;const angle=Math.atan2(dy,dx);const dist=Math.sqrt(dx*dx+dy*dy);const snapangle=Math.round(angle/snap)*snap;return {x:x1+dist*Math.cos(snapangle),y:y1+dist*Math.sin(snapangle),a:snapangle};};/**
   * Check if two rectangles (BBoxes objects) intersect each other.
   * @function module:math.rectsIntersect
   * @param {SVGRect} r1 - The first BBox-like object
   * @param {SVGRect} r2 - The second BBox-like object
   * @returns {boolean} True if rectangles intersect
   */const rectsIntersect=(r1,r2)=>{return r2.x<r1.x+r1.width&&r2.x+r2.width>r1.x&&r2.y<r1.y+r1.height&&r2.y+r2.height>r1.y;};/**
   * @param {any} obj
   * @returns {any}
   */function findPos$1(obj){let curleft=0;let curtop=0;if(obj.offsetParent){do{curleft+=obj.offsetLeft;curtop+=obj.offsetTop;// eslint-disable-next-line no-cond-assign
  }while(obj=obj.offsetParent);return {left:curleft,top:curtop};}return {left:curleft,top:curtop};}function isObject$a(item){return item&&typeof item==='object'&&!Array.isArray(item);}function mergeDeep$1(target,source){const output=Object.assign({},target);if(isObject$a(target)&&isObject$a(source)){Object.keys(source).forEach(key=>{if(isObject$a(source[key])){if(!(key in target)){Object.assign(output,{[key]:source[key]});}else {output[key]=mergeDeep$1(target[key],source[key]);}}else {Object.assign(output,{[key]:source[key]});}});}return output;}/**
   * Get the closest matching element up the DOM tree.
   * @param  {Element} elem     Starting element
   * @param  {String}  selector Selector to match against (class, ID, data attribute, or tag)
   * @return {Boolean|Element}  Returns null if not match found
   */function getClosest(elem,selector){const firstChar=selector.charAt(0);const supports=('classList'in document.documentElement);let attribute;let value;// If selector is a data attribute, split attribute from value
  if(firstChar==='['){selector=selector.substr(1,selector.length-2);attribute=selector.split('=');if(attribute.length>1){value=true;attribute[1]=attribute[1].replace(/"/g,'').replace(/'/g,'');}}// Get closest match
  for(;elem&&elem!==document&&elem.nodeType===1;elem=elem.parentNode){// If selector is a class
  if(firstChar==='.'){if(supports){if(elem.classList.contains(selector.substr(1))){return elem;}}else {if(new RegExp('(^|\\s)'+selector.substr(1)+'(\\s|$)').test(elem.className)){return elem;}}}// If selector is an ID
  if(firstChar==='#'){if(elem.id===selector.substr(1)){return elem;}}// If selector is a data attribute
  if(firstChar==='['){if(elem.hasAttribute(attribute[0])){if(value){if(elem.getAttribute(attribute[0])===attribute[1]){return elem;}}else {return elem;}}}// If selector is a tag
  if(elem.tagName.toLowerCase()===selector){return elem;}}return null;}/**
   * Get all DOM element up the tree that contain a class, ID, or data attribute
   * @param  {Node} elem The base element
   * @param  {String} selector The class, id, data attribute, or tag to look for
   * @return {Array} Null if no match
   */function getParents(elem,selector){const parents=[];const firstChar=selector===null||selector===void 0?void 0:selector.charAt(0);// Get matches
  for(;elem&&elem!==document;elem=elem.parentNode){if(selector){// If selector is a class
  if(firstChar==='.'){if(elem.classList.contains(selector.substr(1))){parents.push(elem);}}// If selector is an ID
  if(firstChar==='#'){if(elem.id===selector.substr(1)){parents.push(elem);}}// If selector is a data attribute
  if(firstChar==='['){if(elem.hasAttribute(selector.substr(1,selector.length-1))){parents.push(elem);}}// If selector is a tag
  if(elem.tagName.toLowerCase()===selector){parents.push(elem);}}else {parents.push(elem);}}// Return parents if any exist
  return parents.length?parents:null;}function getParentsUntil$1(elem,parent,selector){const parents=[];const parentType=parent===null||parent===void 0?void 0:parent.charAt(0);const selectorType=selector===null||selector===void 0?void 0:selector.selector.charAt(0);// Get matches
  for(;elem&&elem!==document;elem=elem.parentNode){// Check if parent has been reached
  if(parent){// If parent is a class
  if(parentType==='.'){if(elem.classList.contains(parent.substr(1))){break;}}// If parent is an ID
  if(parentType==='#'){if(elem.id===parent.substr(1)){break;}}// If parent is a data attribute
  if(parentType==='['){if(elem.hasAttribute(parent.substr(1,parent.length-1))){break;}}// If parent is a tag
  if(elem.tagName.toLowerCase()===parent){break;}}if(selector){// If selector is a class
  if(selectorType==='.'){if(elem.classList.contains(selector.substr(1))){parents.push(elem);}}// If selector is an ID
  if(selectorType==='#'){if(elem.id===selector.substr(1)){parents.push(elem);}}// If selector is a data attribute
  if(selectorType==='['){if(elem.hasAttribute(selector.substr(1,selector.length-1))){parents.push(elem);}}// If selector is a tag
  if(elem.tagName.toLowerCase()===selector){parents.push(elem);}}else {parents.push(elem);}}// Return parents if any exist
  return parents.length?parents:null;}/**
   * Miscellaneous utilities.
   * @module utilities
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */ // Much faster than running getBBox() every time
  const visElems$2='a,circle,ellipse,foreignObject,g,image,line,path,polygon,polyline,rect,svg,text,tspan,use,clipPath';const visElemsArr=visElems$2.split(',');// const hidElems = 'defs,desc,feGaussianBlur,filter,linearGradient,marker,mask,metadata,pattern,radialGradient,stop,switch,symbol,title,textPath';
  let svgCanvas$i=null;let svgroot_=null;/**
  * Object with the following keys/values.
  * @typedef {PlainObject} module:utilities.SVGElementJSON
  * @property {string} element - Tag name of the SVG element to create
  * @property {PlainObject<string, string>} attr - Has key-value attributes to assign to the new element.
  *   An `id` should be set so that {@link module:utilities.EditorContext#addSVGElementsFromJson} can later re-identify the element for modification or replacement.
  * @property {boolean} [curStyles=false] - Indicates whether current style attributes should be applied first
  * @property {module:utilities.SVGElementJSON[]} [children] - Data objects to be added recursively as children
  * @property {string} [namespace="http://www.w3.org/2000/svg"] - Indicate a (non-SVG) namespace
  */ /**
   * An object that creates SVG elements for the canvas.
   *
   * @interface module:utilities.EditorContext
   * @property {module:path.pathActions} pathActions
   */ /**
   * @function module:utilities.EditorContext#getSvgContent
   * @returns {SVGSVGElement}
   */ /**
   * Create a new SVG element based on the given object keys/values and add it
   * to the current layer.
   * The element will be run through `cleanupElement` before being returned.
   * @function module:utilities.EditorContext#addSVGElementsFromJson
   * @param {module:utilities.SVGElementJSON} data
   * @returns {Element} The new element
  */ /**
   * @function module:utilities.EditorContext#getSelectedElements
   * @returns {Element[]} the array with selected DOM elements
  */ /**
   * @function module:utilities.EditorContext#getDOMDocument
   * @returns {HTMLDocument}
  */ /**
   * @function module:utilities.EditorContext#getDOMContainer
   * @returns {HTMLElement}
  */ /**
   * @function module:utilities.EditorContext#getSvgRoot
   * @returns {SVGSVGElement}
  */ /**
   * @function module:utilities.EditorContext#getBaseUnit
   * @returns {string}
  */ /**
   * @function module:utilities.EditorContext#getSnappingStep
   * @returns {Float|string}
  */ /**
  * @function module:utilities.init
  * @param {module:utilities.EditorContext} canvas
  * @returns {void}
  */const init$j=canvas=>{svgCanvas$i=canvas;svgroot_=canvas.getSvgRoot();};/**
  * Converts characters in a string to XML-friendly entities.
  * @function module:utilities.toXml
  * @example `&` becomes `&amp;`
  * @param {string} str - The string to be converted
  * @returns {string} The converted string
  */const toXml=str=>{// &apos; is ok in XML, but not HTML
  // &gt; does not normally need escaping, though it can if within a CDATA expression (and preceded by "]]")
  return str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#x27;');// Note: `&apos;` is XML only
  };// This code was written by Tyler Akins and has been placed in the
  // public domain.  It would be nice if you left this header intact.
  // Base64 code from Tyler Akins -- http://rumkin.com
  // schiller: Removed string concatenation in favour of Array.join() optimization,
  //        also precalculate the size of the array needed.
  /**
  * Converts a string to base64.
  * @function module:utilities.encode64
  * @param {string} input
  * @returns {string} Base64 output
  */function encode64(input){// base64 strings are 4/3 larger than the original string
  input=encodeUTF8(input);// convert non-ASCII characters
  return window.btoa(input);// Use native if available
  }/**
  * Converts a string from base64.
  * @function module:utilities.decode64
  * @param {string} input Base64-encoded input
  * @returns {string} Decoded output
  */function decode64$1(input){return decodeUTF8(window.atob(input));}/**
   * Compute a hashcode from a given string
   * @param word : the string, we want to compute the hashcode
   * @returns {number}: Hascode of the given string
   */function hashCode(word){let hash=0;let chr;if(word.length===0)return hash;for(let i=0;i<word.length;i++){chr=word.charCodeAt(i);hash=(hash<<5)-hash+chr;hash|=0;// Convert to 32bit integer
  }return hash;}/**
  * @function module:utilities.decodeUTF8
  * @param {string} argString
  * @returns {string}
  */function decodeUTF8(argString){return decodeURIComponent(escape(argString));}// codedread:does not seem to work with webkit-based browsers on OSX // Brettz9: please test again as function upgraded
  /**
  * @function module:utilities.encodeUTF8
  * @param {string} argString
  * @returns {string}
  */const encodeUTF8=argString=>{return unescape(encodeURIComponent(argString));};/**
   * Convert dataURL to object URL.
   * @function module:utilities.dataURLToObjectURL
   * @param {string} dataurl
   * @returns {string} object URL or empty string
   */const dataURLToObjectURL=dataurl=>{if(typeof Uint8Array==='undefined'||typeof Blob==='undefined'||typeof URL==='undefined'||!URL.createObjectURL){return '';}const arr=dataurl.split(',');const mime=arr[0].match(/:(.*?);/)[1];const bstr=atob(arr[1]);/*
    const [prefix, suffix] = dataurl.split(','),
      {groups: {mime}} = prefix.match(/:(?<mime>.*?);/),
      bstr = atob(suffix);
    */let n=bstr.length;const u8arr=new Uint8Array(n);while(n--){u8arr[n]=bstr.charCodeAt(n);}const blob=new Blob([u8arr],{type:mime});return URL.createObjectURL(blob);};/**
   * Get object URL for a blob object.
   * @function module:utilities.createObjectURL
   * @param {Blob} blob A Blob object or File object
   * @returns {string} object URL or empty string
   */const createObjectURL=blob=>{if(!blob||typeof URL==='undefined'||!URL.createObjectURL){return '';}return URL.createObjectURL(blob);};/**
   * @property {string} blankPageObjectURL
   */const blankPageObjectURL$1=(()=>{if(typeof Blob==='undefined'){return '';}const blob=new Blob(['<html><head><title>SVG-edit</title></head><body>&nbsp;</body></html>'],{type:'text/html'});return createObjectURL(blob);})();/**
  * Cross-browser compatible method of converting a string to an XML tree.
  * Found this function [here]{@link http://groups.google.com/group/jquery-dev/browse_thread/thread/c6d11387c580a77f}.
  * @function module:utilities.text2xml
  * @param {string} sXML
  * @throws {Error}
  * @returns {XMLDocument}
  */const text2xml=sXML=>{if(sXML.includes('<svg:svg')){sXML=sXML.replace(/<(\/?)svg:/g,'<$1').replace('xmlns:svg','xmlns');}let out;let dXML;try{dXML=new DOMParser();dXML.async=false;}catch(e){throw new Error('XML Parser could not be instantiated');}try{out=dXML.parseFromString(sXML,'text/xml');}catch(e2){throw new Error('Error parsing XML string');}return out;};/**
  * @typedef {PlainObject} module:utilities.BBoxObject (like `DOMRect`)
  * @property {Float} x
  * @property {Float} y
  * @property {Float} width
  * @property {Float} height
  */ /**
  * Converts a `SVGRect` into an object.
  * @function module:utilities.bboxToObj
  * @param {SVGRect} bbox - a SVGRect
  * @returns {module:utilities.BBoxObject} An object with properties names x, y, width, height.
  */const bboxToObj=_ref5=>{let{x,y,width,height}=_ref5;return {x,y,width,height};};/**
  * @callback module:utilities.TreeWalker
  * @param {Element} elem - DOM element being traversed
  * @returns {void}
  */ /**
  * Walks the tree and executes the callback on each element in a top-down fashion.
  * @function module:utilities.walkTree
  * @param {Element} elem - DOM element to traverse
  * @param {module:utilities.TreeWalker} cbFn - Callback function to run on each element
  * @returns {void}
  */const walkTree=(elem,cbFn)=>{if((elem===null||elem===void 0?void 0:elem.nodeType)===1){cbFn(elem);let i=elem.childNodes.length;while(i--){walkTree(elem.childNodes.item(i),cbFn);}}};/**
  * Walks the tree and executes the callback on each element in a depth-first fashion.
  * @function module:utilities.walkTreePost
  * @todo Shouldn't this be calling walkTreePost?
  * @param {Element} elem - DOM element to traverse
  * @param {module:utilities.TreeWalker} cbFn - Callback function to run on each element
  * @returns {void}
  */const walkTreePost=(elem,cbFn)=>{if((elem===null||elem===void 0?void 0:elem.nodeType)===1){let i=elem.childNodes.length;while(i--){walkTree(elem.childNodes.item(i),cbFn);}cbFn(elem);}};/**
  * Extracts the URL from the `url(...)` syntax of some attributes.
  * Three variants:
  *  - `<circle fill="url(someFile.svg#foo)" />`
  *  - `<circle fill="url('someFile.svg#foo')" />`
  *  - `<circle fill='url("someFile.svg#foo")' />`
  * @function module:utilities.getUrlFromAttr
  * @param {string} attrVal The attribute value as a string
  * @returns {string} String with just the URL, like "someFile.svg#foo"
  */const getUrlFromAttr=function(attrVal){if(attrVal){// url('#somegrad')
  if(attrVal.startsWith('url("')){return attrVal.substring(5,attrVal.indexOf('"',6));}// url('#somegrad')
  if(attrVal.startsWith("url('")){return attrVal.substring(5,attrVal.indexOf("'",6));}if(attrVal.startsWith('url(')){return attrVal.substring(4,attrVal.indexOf(')'));}}return null;};/**
  * @function module:utilities.getHref
  * @param {Element} elem
  * @returns {string} The given element's `xlink:href` value
  */let getHref=function(elem){return elem.getAttributeNS(NS.XLINK,'href');};/**
  * Sets the given element's `xlink:href` value.
  * @function module:utilities.setHref
  * @param {Element} elem
  * @param {string} val
  * @returns {void}
  */let setHref=function(elem,val){elem.setAttributeNS(NS.XLINK,'xlink:href',val);};/**
  * @function module:utilities.findDefs
  * @returns {SVGDefsElement} The document's `<defs>` element, creating it first if necessary
  */const findDefs=function(){const svgElement=svgCanvas$i.getSvgContent();let defs=svgElement.getElementsByTagNameNS(NS.SVG,'defs');if(defs.length>0){defs=defs[0];}else {defs=svgElement.ownerDocument.createElementNS(NS.SVG,'defs');if(svgElement.firstChild){// first child is a comment, so call nextSibling
  svgElement.insertBefore(defs,svgElement.firstChild.nextSibling);// svgElement.firstChild.nextSibling.before(defs); // Not safe
  }else {svgElement.append(defs);}}return defs;};/**
  * Get the given/selected element's bounding box object, convert it to be more
  * usable when necessary.
  * @function module:utilities.getBBox
  * @param {Element} elem - Optional DOM element to get the BBox for
  * @returns {module:utilities.BBoxObject} Bounding box object
  */const getBBox=function(elem){const selected=elem||svgCanvas$i.getSelectedElements()[0];if(elem.nodeType!==1){return null;}const elname=selected.nodeName;let ret=null;switch(elname){case'text':if(selected.textContent===''){selected.textContent='a';// Some character needed for the selector to use.
  ret=selected.getBBox();selected.textContent='';}else if(selected.getBBox){ret=selected.getBBox();}break;case'path':case'g':case'a':if(selected.getBBox){ret=selected.getBBox();}break;default:if(elname==='use'){ret=selected.getBBox();// , true);
  }else if(visElemsArr.includes(elname)){if(selected){try{ret=selected.getBBox();}catch(err){// tspan (and textPath apparently) have no `getBBox` in Firefox: https://bugzilla.mozilla.org/show_bug.cgi?id=937268
  // Re: Chrome returning bbox for containing text element, see: https://bugs.chromium.org/p/chromium/issues/detail?id=349835
  const extent=selected.getExtentOfChar(0);// pos+dimensions of the first glyph
  const width=selected.getComputedTextLength();// width of the tspan
  ret={x:extent.x,y:extent.y,width,height:extent.height};}}else {// Check if element is child of a foreignObject
  const fo=getClosest(selected.parentNode,'foreignObject');if(fo.length&&fo[0].getBBox){ret=fo[0].getBBox();}}}}if(ret){ret=bboxToObj(ret);}// get the bounding box from the DOM (which is in that element's coordinate system)
  return ret;};/**
  * @typedef {GenericArray} module:utilities.PathSegmentArray
  * @property {Integer} length 2
  * @property {"M"|"L"|"C"|"Z"} 0
  * @property {Float[]} 1
  */ /**
  * Create a path 'd' attribute from path segments.
  * Each segment is an array of the form: `[singleChar, [x,y, x,y, ...]]`
  * @function module:utilities.getPathDFromSegments
  * @param {module:utilities.PathSegmentArray[]} pathSegments - An array of path segments to be converted
  * @returns {string} The converted path d attribute.
  */const getPathDFromSegments=function(pathSegments){let d='';pathSegments.forEach(function(_ref6,_j){let[singleChar,pts]=_ref6;d+=singleChar;for(let i=0;i<pts.length;i+=2){d+=pts[i]+','+pts[i+1]+' ';}});return d;};/**
  * Make a path 'd' attribute from a simple SVG element shape.
  * @function module:utilities.getPathDFromElement
  * @param {Element} elem - The element to be converted
  * @returns {string} The path d attribute or `undefined` if the element type is unknown.
  */const getPathDFromElement=function(elem){// Possibly the cubed root of 6, but 1.81 works best
  let num=1.81;let d;let rx;let ry;switch(elem.tagName){case'ellipse':case'circle':{rx=Number(elem.getAttribute('rx'));ry=Number(elem.getAttribute('ry'));const cx=Number(elem.getAttribute('cx'));const cy=Number(elem.getAttribute('cy'));if(elem.tagName==='circle'&&elem.hasAttribute('r')){ry=Number(elem.getAttribute('r'));rx=ry;}d=getPathDFromSegments([['M',[cx-rx,cy]],['C',[cx-rx,cy-ry/num,cx-rx/num,cy-ry,cx,cy-ry]],['C',[cx+rx/num,cy-ry,cx+rx,cy-ry/num,cx+rx,cy]],['C',[cx+rx,cy+ry/num,cx+rx/num,cy+ry,cx,cy+ry]],['C',[cx-rx/num,cy+ry,cx-rx,cy+ry/num,cx-rx,cy]],['Z',[]]]);break;}case'path':d=elem.getAttribute('d');break;case'line':{const x1=elem.getAttribute('x1');const y1=elem.getAttribute('y1');const x2=elem.getAttribute('x2');const y2=elem.getAttribute('y2');d='M'+x1+','+y1+'L'+x2+','+y2;}break;case'polyline':d='M'+elem.getAttribute('points');break;case'polygon':d='M'+elem.getAttribute('points')+' Z';break;case'rect':{rx=Number(elem.getAttribute('rx'));ry=Number(elem.getAttribute('ry'));const b=elem.getBBox();const{x,y}=b;const w=b.width;const h=b.height;num=4-num;// Why? Because!
  d=!rx&&!ry// Regular rect
  ?getPathDFromSegments([['M',[x,y]],['L',[x+w,y]],['L',[x+w,y+h]],['L',[x,y+h]],['L',[x,y]],['Z',[]]]):getPathDFromSegments([['M',[x,y+ry]],['C',[x,y+ry/num,x+rx/num,y,x+rx,y]],['L',[x+w-rx,y]],['C',[x+w-rx/num,y,x+w,y+ry/num,x+w,y+ry]],['L',[x+w,y+h-ry]],['C',[x+w,y+h-ry/num,x+w-rx/num,y+h,x+w-rx,y+h]],['L',[x+rx,y+h]],['C',[x+rx/num,y+h,x,y+h-ry/num,x,y+h-ry]],['L',[x,y+ry]],['Z',[]]]);break;}}return d;};/**
  * Get a set of attributes from an element that is useful for convertToPath.
  * @function module:utilities.getExtraAttributesForConvertToPath
  * @param {Element} elem - The element to be probed
  * @returns {PlainObject<"marker-start"|"marker-end"|"marker-mid"|"filter"|"clip-path", string>} An object with attributes.
  */const getExtraAttributesForConvertToPath=function(elem){const attrs={};// TODO: make this list global so that we can properly maintain it
  // TODO: what about @transform, @clip-rule, @fill-rule, etc?
  ['marker-start','marker-end','marker-mid','filter','clip-path'].forEach(function(item){const a=elem.getAttribute(item);if(a){attrs[item]=a;}});return attrs;};/**
  * Get the BBox of an element-as-path.
  * @function module:utilities.getBBoxOfElementAsPath
  * @param {Element} elem - The DOM element to be probed
  * @param {module:utilities.EditorContext#addSVGElementsFromJson} addSVGElementsFromJson - Function to add the path element to the current layer. See canvas.addSVGElementsFromJson
  * @param {module:path.pathActions} pathActions - If a transform exists, `pathActions.resetOrientation()` is used. See: canvas.pathActions.
  * @returns {DOMRect|false} The resulting path's bounding box object.
  */const getBBoxOfElementAsPath=function(elem,addSVGElementsFromJson,pathActions){const path=addSVGElementsFromJson({element:'path',attr:getExtraAttributesForConvertToPath(elem)});const eltrans=elem.getAttribute('transform');if(eltrans){path.setAttribute('transform',eltrans);}const{parentNode}=elem;if(elem.nextSibling){elem.before(path);}else {parentNode.append(path);}const d=getPathDFromElement(elem);if(d){path.setAttribute('d',d);}else {path.remove();}// Get the correct BBox of the new path, then discard it
  pathActions.resetOrientation(path);let bb=false;try{bb=path.getBBox();}catch(e){// Firefox fails
  }path.remove();return bb;};/**
  * Convert selected element to a path.
  * @function module:utilities.convertToPath
  * @param {Element} elem - The DOM element to be converted
  * @param {module:utilities.SVGElementJSON} attrs - Apply attributes to new path. see canvas.convertToPath
  * @param {module:utilities.EditorContext#addSVGElementsFromJson} addSVGElementsFromJson - Function to add the path element to the current layer. See canvas.addSVGElementsFromJson
  * @param {module:path.pathActions} pathActions - If a transform exists, pathActions.resetOrientation() is used. See: canvas.pathActions.
  * @param {module:draw.DrawCanvasInit#clearSelection|module:path.EditorContext#clearSelection} clearSelection - see [canvas.clearSelection]{@link module:svgcanvas.SvgCanvas#clearSelection}
  * @param {module:path.EditorContext#addToSelection} addToSelection - see [canvas.addToSelection]{@link module:svgcanvas.SvgCanvas#addToSelection}
  * @param {module:history} hstry - see history module
  * @param {module:path.EditorContext#addCommandToHistory|module:draw.DrawCanvasInit#addCommandToHistory} addCommandToHistory - see [canvas.addCommandToHistory]{@link module:svgcanvas~addCommandToHistory}
  * @returns {SVGPathElement|null} The converted path element or null if the DOM element was not recognized.
  */const convertToPath=(elem,attrs,svgCanvas)=>{const batchCmd=new svgCanvas.history.BatchCommand('Convert element to Path');// Any attribute on the element not covered by the passed-in attributes
  attrs=mergeDeep$1(attrs,getExtraAttributesForConvertToPath(elem));const path=svgCanvas.addSVGElementsFromJson({element:'path',attr:attrs});const eltrans=elem.getAttribute('transform');if(eltrans){path.setAttribute('transform',eltrans);}const{id}=elem;const{parentNode}=elem;if(elem.nextSibling){elem.before(path);}else {parentNode.append(path);}const d=getPathDFromElement(elem);if(d){path.setAttribute('d',d);// Replace the current element with the converted one
  // Reorient if it has a matrix
  if(eltrans){const tlist=path.transform.baseVal;if(hasMatrixTransform(tlist)){svgCanvas.pathActions.resetOrientation(path);}}const{nextSibling}=elem;batchCmd.addSubCommand(new svgCanvas.history.RemoveElementCommand(elem,nextSibling,elem.parentNode));svgCanvas.clearSelection();elem.remove();// We need to remove this element otherwise the nextSibling of 'path' won't be null and an exception will be thrown after subsequent undo and redos.
  batchCmd.addSubCommand(new svgCanvas.history.InsertElementCommand(path));path.setAttribute('id',id);path.removeAttribute('visibility');svgCanvas.addToSelection([path],true);svgCanvas.addCommandToHistory(batchCmd);return path;}// the elem.tagName was not recognized, so no "d" attribute. Remove it, so we've haven't changed anything.
  path.remove();return null;};/**
  * Can the bbox be optimized over the native getBBox? The optimized bbox is the same as the native getBBox when
  * the rotation angle is a multiple of 90 degrees and there are no complex transforms.
  * Getting an optimized bbox can be dramatically slower, so we want to make sure it's worth it.
  *
  * The best example for this is a circle rotate 45 degrees. The circle doesn't get wider or taller when rotated
  * about it's center.
  *
  * The standard, unoptimized technique gets the native bbox of the circle, rotates the box 45 degrees, uses
  * that width and height, and applies any transforms to get the final bbox. This means the calculated bbox
  * is much wider than the original circle. If the angle had been 0, 90, 180, etc. both techniques render the
  * same bbox.
  *
  * The optimization is not needed if the rotation is a multiple 90 degrees. The default technique is to call
  * getBBox then apply the angle and any transforms.
  *
  * @param {Float} angle - The rotation angle in degrees
  * @param {boolean} hasAMatrixTransform - True if there is a matrix transform
  * @returns {boolean} True if the bbox can be optimized.
  */function bBoxCanBeOptimizedOverNativeGetBBox(angle,hasAMatrixTransform){const angleModulo90=angle%90;const closeTo90=angleModulo90<-89.99||angleModulo90>89.99;const closeTo0=angleModulo90>-0.001&&angleModulo90<0.001;return hasAMatrixTransform||!(closeTo0||closeTo90);}/**
  * Get bounding box that includes any transforms.
  * @function module:utilities.getBBoxWithTransform
  * @param {Element} elem - The DOM element to be converted
  * @param {module:utilities.EditorContext#addSVGElementsFromJson} addSVGElementsFromJson - Function to add the path element to the current layer. See canvas.addSVGElementsFromJson
  * @param {module:path.pathActions} pathActions - If a transform exists, pathActions.resetOrientation() is used. See: canvas.pathActions.
  * @returns {module:utilities.BBoxObject|module:math.TransformedBox|DOMRect} A single bounding box object
  */const getBBoxWithTransform=function(elem,addSVGElementsFromJson,pathActions){// TODO: Fix issue with rotated groups. Currently they work
  // fine in FF, but not in other browsers (same problem mentioned
  // in Issue 339 comment #2).
  let bb=getBBox(elem);if(!bb){return null;}const tlist=elem.transform.baseVal;const angle=getRotationAngleFromTransformList(tlist);const hasMatrixXForm=hasMatrixTransform(tlist);if(angle||hasMatrixXForm){let goodBb=false;if(bBoxCanBeOptimizedOverNativeGetBBox(angle,hasMatrixXForm)){// Get the BBox from the raw path for these elements
  // TODO: why ellipse and not circle
  const elemNames=['ellipse','path','line','polyline','polygon'];if(elemNames.includes(elem.tagName)){goodBb=getBBoxOfElementAsPath(elem,addSVGElementsFromJson,pathActions);bb=goodBb;}else if(elem.tagName==='rect'){// Look for radius
  const rx=Number(elem.getAttribute('rx'));const ry=Number(elem.getAttribute('ry'));if(rx||ry){goodBb=getBBoxOfElementAsPath(elem,addSVGElementsFromJson,pathActions);bb=goodBb;}}}if(!goodBb){const{matrix}=transformListToTransform(tlist);bb=transformBox(bb.x,bb.y,bb.width,bb.height,matrix).aabox;}}return bb;};/**
   * @param {Element} elem
   * @returns {Float}
   * @todo This is problematic with large stroke-width and, for example, a single
   * horizontal line. The calculated BBox extends way beyond left and right sides.
   */const getStrokeOffsetForBBox=elem=>{const sw=elem.getAttribute('stroke-width');return !isNaN(sw)&&elem.getAttribute('stroke')!=='none'?sw/2:0;};/**
   * @typedef {PlainObject} BBox
   * @property {Integer} x The x value
   * @property {Integer} y The y value
   * @property {Float} width
   * @property {Float} height
   */ /**
  * Get the bounding box for one or more stroked and/or transformed elements.
  * @function module:utilities.getStrokedBBox
  * @param {Element[]} elems - Array with DOM elements to check
  * @param {module:utilities.EditorContext#addSVGElementsFromJson} addSVGElementsFromJson - Function to add the path element to the current layer. See canvas.addSVGElementsFromJson
  * @param {module:path.pathActions} pathActions - If a transform exists, pathActions.resetOrientation() is used. See: canvas.pathActions.
  * @returns {module:utilities.BBoxObject|module:math.TransformedBox|DOMRect} A single bounding box object
  */const getStrokedBBox=(elems,addSVGElementsFromJson,pathActions)=>{if(!elems||!elems.length){return false;}let fullBb;elems.forEach(elem=>{if(fullBb){return;}if(!elem.parentNode){return;}fullBb=getBBoxWithTransform(elem,addSVGElementsFromJson,pathActions);});// This shouldn't ever happen...
  if(!fullBb){return null;}// fullBb doesn't include the stoke, so this does no good!
  // if (elems.length == 1) return fullBb;
  let maxX=fullBb.x+fullBb.width;let maxY=fullBb.y+fullBb.height;let minX=fullBb.x;let minY=fullBb.y;// If only one elem, don't call the potentially slow getBBoxWithTransform method again.
  if(elems.length===1){const offset=getStrokeOffsetForBBox(elems[0]);minX-=offset;minY-=offset;maxX+=offset;maxY+=offset;}else {elems.forEach(elem=>{const curBb=getBBoxWithTransform(elem,addSVGElementsFromJson,pathActions);if(curBb){const offset=getStrokeOffsetForBBox(elem);minX=Math.min(minX,curBb.x-offset);minY=Math.min(minY,curBb.y-offset);// TODO: The old code had this test for max, but not min. I suspect this test should be for both min and max
  if(elem.nodeType===1){maxX=Math.max(maxX,curBb.x+curBb.width+offset);maxY=Math.max(maxY,curBb.y+curBb.height+offset);}}});}fullBb.x=minX;fullBb.y=minY;fullBb.width=maxX-minX;fullBb.height=maxY-minY;return fullBb;};/**
  * Get all elements that have a BBox (excludes `<defs>`, `<title>`, etc).
  * Note that 0-opacity, off-screen etc elements are still considered "visible"
  * for this function.
  * @function module:utilities.getVisibleElements
  * @param {Element} parentElement - The parent DOM element to search within
  * @returns {Element[]} All "visible" elements.
  */const getVisibleElements=parentElement=>{if(!parentElement){const svgContent=svgCanvas$i.getSvgContent();for(let i=0;i<svgContent.children.length;i++){if(svgContent.children[i].getBBox){const bbox=svgContent.children[i].getBBox();if(bbox.width!==0&&bbox.height!==0&&bbox.width!==0&&bbox.height!==0){parentElement=svgContent.children[i];break;}}}}const contentElems=[];if(parentElement){const children=parentElement.children;// eslint-disable-next-line array-callback-return
  Array.from(children,elem=>{if(elem.getBBox){contentElems.push(elem);}});}return contentElems.reverse();};/**
  * Get the bounding box for one or more stroked and/or transformed elements.
  * @function module:utilities.getStrokedBBoxDefaultVisible
  * @param {Element[]} elems - Array with DOM elements to check
  * @returns {module:utilities.BBoxObject} A single bounding box object
  */const getStrokedBBoxDefaultVisible=elems=>{if(!elems){elems=getVisibleElements();}return getStrokedBBox(elems,svgCanvas$i.addSVGElementsFromJson,svgCanvas$i.pathActions);};/**
  * Get the rotation angle of the given transform list.
  * @function module:utilities.getRotationAngleFromTransformList
  * @param {SVGTransformList} tlist - List of transforms
  * @param {boolean} toRad - When true returns the value in radians rather than degrees
  * @returns {Float} The angle in degrees or radians
  */const getRotationAngleFromTransformList=(tlist,toRad)=>{if(!tlist){return 0;}// <svg> element have no tlist
  for(let i=0;i<tlist.numberOfItems;++i){const xform=tlist.getItem(i);if(xform.type===4){return toRad?xform.angle*Math.PI/180.0:xform.angle;}}return 0.0;};/**
  * Get the rotation angle of the given/selected DOM element.
  * @function module:utilities.getRotationAngle
  * @param {Element} [elem] - DOM element to get the angle for. Default to first of selected elements.
  * @param {boolean} [toRad=false] - When true returns the value in radians rather than degrees
  * @returns {Float} The angle in degrees or radians
  */let getRotationAngle=(elem,toRad)=>{var _selected$transform;const selected=elem||svgCanvas$i.getSelectedElements()[0];// find the rotation transform (if any) and set it
  const tlist=(_selected$transform=selected.transform)===null||_selected$transform===void 0?void 0:_selected$transform.baseVal;return getRotationAngleFromTransformList(tlist,toRad);};/**
  * Get the reference element associated with the given attribute value.
  * @function module:utilities.getRefElem
  * @param {string} attrVal - The attribute value as a string
  * @returns {Element} Reference element
  */const getRefElem=attrVal=>{return getElement(getUrlFromAttr(attrVal).substr(1));};/**
  * Get the reference element associated with the given attribute value.
  * @function module:utilities.getFeGaussianBlur
  * @param {any} Element
  * @returns {any} Reference element
  */const getFeGaussianBlur=ele=>{var _ele$firstChild;if((ele===null||ele===void 0?void 0:(_ele$firstChild=ele.firstChild)===null||_ele$firstChild===void 0?void 0:_ele$firstChild.tagName)==='feGaussianBlur'){return ele.firstChild;}else {const childrens=ele.children;// eslint-disable-next-line no-unused-vars
  for(const[_,value]of Object.entries(childrens)){if(value.tagName==='feGaussianBlur'){return value;}}}return null;};/**
  * Get a DOM element by ID within the SVG root element.
  * @function module:utilities.getElement
  * @param {string} id - String with the element's new ID
  * @returns {?Element}
  */const getElement=id=>{// querySelector lookup
  return svgroot_.querySelector('#'+id);};/**
  * Assigns multiple attributes to an element.
  * @function module:utilities.assignAttributes
  * @param {Element} elem - DOM element to apply new attribute values to
  * @param {PlainObject<string, string>} attrs - Object with attribute keys/values
  * @param {Integer} [suspendLength] - Milliseconds to suspend redraw
  * @param {boolean} [unitCheck=false] - Boolean to indicate the need to use units.setUnitAttr
  * @returns {void}
  */const assignAttributes=(elem,attrs,suspendLength,unitCheck)=>{for(const[key,value]of Object.entries(attrs)){const ns=key.substr(0,4)==='xml:'?NS.XML:key.substr(0,6)==='xlink:'?NS.XLINK:null;if(value===undefined){if(ns){elem.removeAttributeNS(ns,key);}else {elem.removeAttribute(key);}continue;}if(ns){elem.setAttributeNS(ns,key,value);}else if(!unitCheck){elem.setAttribute(key,value);}else {setUnitAttr(elem,key,value);}}};/**
  * Remove unneeded (default) attributes, making resulting SVG smaller.
  * @function module:utilities.cleanupElement
  * @param {Element} element - DOM element to clean up
  * @returns {void}
  */const cleanupElement=element=>{const defaults={'fill-opacity':1,'stop-opacity':1,opacity:1,stroke:'none','stroke-dasharray':'none','stroke-linejoin':'miter','stroke-linecap':'butt','stroke-opacity':1,'stroke-width':1,rx:0,ry:0};if(element.nodeName==='ellipse'){// Ellipse elements require rx and ry attributes
  delete defaults.rx;delete defaults.ry;}Object.entries(defaults).forEach(_ref7=>{let[attr,val]=_ref7;if(element.getAttribute(attr)===String(val)){element.removeAttribute(attr);}});};/**
  * Round value to for snapping.
  * @function module:utilities.snapToGrid
  * @param {Float} value
  * @returns {Integer}
  */const snapToGrid=value=>{const unit=svgCanvas$i.getBaseUnit();let stepSize=svgCanvas$i.getSnappingStep();if(unit!=='px'){stepSize*=getTypeMap$2()[unit];}value=Math.round(value/stepSize)*stepSize;return value;};/**
   * Prevents default browser click behaviour on the given element.
   * @function module:utilities.preventClickDefault
   * @param {Element} img - The DOM element to prevent the click on
   * @returns {void}
   */const preventClickDefault=img=>{$click$6(img,e=>{e.preventDefault();});};const stringToHTML=str=>{const parser=new DOMParser();const doc=parser.parseFromString(str,'text/html');return doc.body.firstChild;};const insertChildAtIndex=function(parent,child){let index=arguments.length>2&&arguments[2]!==undefined?arguments[2]:0;const doc=stringToHTML(child);if(index>=parent.children.length){parent.appendChild(doc);}else {parent.insertBefore(doc,parent.children[index]);}};// shortcuts to common DOM functions
  const $id$8=id=>document.getElementById(id);const $qq$1=sel=>document.querySelector(sel);const $qa$2=sel=>[...document.querySelectorAll(sel)];const $click$6=(element,handler)=>{element.addEventListener('click',handler);element.addEventListener('touchend',handler);};/* eslint-disable no-console */ /**
  * Group: Undo/Redo history management.
  */const HistoryEventTypes$1={BEFORE_APPLY:'before_apply',AFTER_APPLY:'after_apply',BEFORE_UNAPPLY:'before_unapply',AFTER_UNAPPLY:'after_unapply'};/**
  * Base class for commands.
  */class Command{/**
    * @returns {string}
    */getText(){return this.text;}/**
     * @param {module:history.HistoryEventHandler} handler
     * @param {callback} applyFunction
     * @returns {void}
    */apply(handler,applyFunction){handler&&handler.handleHistoryEvent(HistoryEventTypes$1.BEFORE_APPLY,this);applyFunction(handler);handler&&handler.handleHistoryEvent(HistoryEventTypes$1.AFTER_APPLY,this);}/**
     * @param {module:history.HistoryEventHandler} handler
     * @param {callback} unapplyFunction
     * @returns {void}
    */unapply(handler,unapplyFunction){handler&&handler.handleHistoryEvent(HistoryEventTypes$1.BEFORE_UNAPPLY,this);unapplyFunction();handler&&handler.handleHistoryEvent(HistoryEventTypes$1.AFTER_UNAPPLY,this);}/**
     * @returns {Element[]} Array with element associated with this command
     * This function needs to be surcharged if multiple elements are returned.
    */elements(){return [this.elem];}/**
      * @returns {string} String with element associated with this command
    */type(){return this.constructor.name;}}// Todo: Figure out why the interface members aren't showing
  //   up (with or without modules applied), despite our apparently following
  //   http://usejsdoc.org/tags-interface.html#virtual-comments
  /**
   * An interface that all command objects must implement.
   * @interface module:history.HistoryCommand
  */ /**
   * Applies.
   *
   * @function module:history.HistoryCommand#apply
   * @param {module:history.HistoryEventHandler} handler
   * @fires module:history~Command#event:history
   * @returns {void|true}
   */ /**
   *
   * Unapplies.
   * @function module:history.HistoryCommand#unapply
   * @param {module:history.HistoryEventHandler} handler
   * @fires module:history~Command#event:history
   * @returns {void|true}
   */ /**
   * Returns the elements.
   * @function module:history.HistoryCommand#elements
   * @returns {Element[]}
   */ /**
   * Gets the text.
   * @function module:history.HistoryCommand#getText
   * @returns {string}
   */ /**
   * Gives the type.
   * @function module:history.HistoryCommand.type
   * @returns {string}
   */ /**
   * @event module:history~Command#event:history
   * @type {module:history.HistoryCommand}
   */ /**
   * An interface for objects that will handle history events.
   * @interface module:history.HistoryEventHandler
   */ /**
   *
   * @function module:history.HistoryEventHandler#handleHistoryEvent
   * @param {string} eventType One of the HistoryEvent types
   * @param {module:history~Command#event:history} command
   * @listens module:history~Command#event:history
   * @returns {void}
   *
   */ /**
   * History command for an element that had its DOM position changed.
   * @implements {module:history.HistoryCommand}
  */let MoveElementCommand$1=class MoveElementCommand extends Command{/**
    * @param {Element} elem - The DOM element that was moved
    * @param {Element} oldNextSibling - The element's next sibling before it was moved
    * @param {Element} oldParent - The element's parent before it was moved
    * @param {string} [text] - An optional string visible to user related to this change
    */constructor(elem,oldNextSibling,oldParent,text){super();this.elem=elem;this.text=text?'Move '+elem.tagName+' to '+text:'Move '+elem.tagName;this.oldNextSibling=oldNextSibling;this.oldParent=oldParent;this.newNextSibling=elem.nextSibling;this.newParent=elem.parentNode;}/**
     * Re-positions the element.
     * @param {module:history.HistoryEventHandler} handler
     * @fires module:history~Command#event:history
     * @returns {void}
    */apply(handler){super.apply(handler,()=>{this.elem=this.newParent.insertBefore(this.elem,this.newNextSibling);});}/**
     * Positions the element back to its original location.
     * @param {module:history.HistoryEventHandler} handler
     * @fires module:history~Command#event:history
     * @returns {void}
    */unapply(handler){super.unapply(handler,()=>{this.elem=this.oldParent.insertBefore(this.elem,this.oldNextSibling);});}};/**
  * History command for an element that was added to the DOM.
  * @implements {module:history.HistoryCommand}
  */let InsertElementCommand$4=class InsertElementCommand extends Command{/**
     * @param {Element} elem - The newly added DOM element
     * @param {string} text - An optional string visible to user related to this change
    */constructor(elem,text){super();this.elem=elem;this.text=text||'Create '+elem.tagName;this.parent=elem.parentNode;this.nextSibling=this.elem.nextSibling;}/**
    * Re-inserts the new element.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */apply(handler){super.apply(handler,()=>{this.elem=this.parent.insertBefore(this.elem,this.nextSibling);});}/**
    * Removes the element.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */unapply(handler){super.unapply(handler,()=>{this.parent=this.elem.parentNode;this.elem.remove();});}};/**
  * History command for an element removed from the DOM.
  * @implements {module:history.HistoryCommand}
  */let RemoveElementCommand$2=class RemoveElementCommand extends Command{/**
    * @param {Element} elem - The removed DOM element
    * @param {Node} oldNextSibling - The DOM element's nextSibling when it was in the DOM
    * @param {Element} oldParent - The DOM element's parent
    * @param {string} [text] - An optional string visible to user related to this change
    */constructor(elem,oldNextSibling,oldParent,text){super();this.elem=elem;this.text=text||'Delete '+elem.tagName;this.nextSibling=oldNextSibling;this.parent=oldParent;}/**
    * Re-removes the new element.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */apply(handler){super.apply(handler,()=>{this.parent=this.elem.parentNode;this.elem.remove();});}/**
    * Re-adds the new element.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */unapply(handler){super.unapply(handler,()=>{if(!this.nextSibling){console.error('Reference element was lost');}this.parent.insertBefore(this.elem,this.nextSibling);// Don't use `before` or `prepend` as `this.nextSibling` may be `null`
  });}};/**
  * @typedef {"#text"|"#href"|string} module:history.CommandAttributeName
  */ /**
  * @typedef {PlainObject<module:history.CommandAttributeName, string>} module:history.CommandAttributes
  */ /**
  * History command to make a change to an element.
  * Usually an attribute change, but can also be textcontent.
  * @implements {module:history.HistoryCommand}
  */let ChangeElementCommand$2=class ChangeElementCommand extends Command{/**
    * @param {Element} elem - The DOM element that was changed
    * @param {module:history.CommandAttributes} attrs - Attributes to be changed with the values they had *before* the change
    * @param {string} text - An optional string visible to user related to this change
     */constructor(elem,attrs,text){super();this.elem=elem;this.text=text?'Change '+elem.tagName+' '+text:'Change '+elem.tagName;this.newValues={};this.oldValues=attrs;for(const attr in attrs){if(attr==='#text'){this.newValues[attr]=elem?elem.textContent:'';}else if(attr==='#href'){this.newValues[attr]=getHref(elem);}else {this.newValues[attr]=elem.getAttribute(attr);}}}/**
    * Performs the stored change action.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */apply(handler){super.apply(handler,()=>{let bChangedTransform=false;Object.entries(this.newValues).forEach(_ref8=>{let[attr,value]=_ref8;if(value){if(attr==='#text'){this.elem.textContent=value;}else if(attr==='#href'){setHref(this.elem,value);}else {this.elem.setAttribute(attr,value);}}else if(attr==='#text'){this.elem.textContent='';}else {this.elem.setAttribute(attr,'');this.elem.removeAttribute(attr);}if(attr==='transform'){bChangedTransform=true;}});// relocate rotational transform, if necessary
  if(!bChangedTransform){const angle=getRotationAngle(this.elem);if(angle){const bbox=getBBox(this.elem);const cx=bbox.x+bbox.width/2;const cy=bbox.y+bbox.height/2;const rotate=['rotate(',angle,' ',cx,',',cy,')'].join('');if(rotate!==this.elem.getAttribute('transform')){this.elem.setAttribute('transform',rotate);}}}});}/**
    * Reverses the stored change action.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */unapply(handler){super.unapply(handler,()=>{let bChangedTransform=false;Object.entries(this.oldValues).forEach(_ref9=>{let[attr,value]=_ref9;if(value){if(attr==='#text'){this.elem.textContent=value;}else if(attr==='#href'){setHref(this.elem,value);}else {this.elem.setAttribute(attr,value);}}else if(attr==='#text'){this.elem.textContent='';}else {this.elem.removeAttribute(attr);}if(attr==='transform'){bChangedTransform=true;}});// relocate rotational transform, if necessary
  if(!bChangedTransform){const angle=getRotationAngle(this.elem);if(angle){const bbox=getBBox(this.elem);const cx=bbox.x+bbox.width/2;const cy=bbox.y+bbox.height/2;const rotate=['rotate(',angle,' ',cx,',',cy,')'].join('');if(rotate!==this.elem.getAttribute('transform')){this.elem.setAttribute('transform',rotate);}}}});}};// TODO: create a 'typing' command object that tracks changes in text
  // if a new Typing command is created and the top command on the stack is also a Typing
  // and they both affect the same element, then collapse the two commands into one
  /**
  * History command that can contain/execute multiple other commands.
  * @implements {module:history.HistoryCommand}
  */let BatchCommand$4=class BatchCommand extends Command{/**
    * @param {string} [text] - An optional string visible to user related to this change
    */constructor(text){super();this.text=text||'Batch Command';this.stack=[];}/**
    * Runs "apply" on all subcommands.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */apply(handler){super.apply(handler,()=>{this.stack.forEach(stackItem=>{console.assert(stackItem,'stack item should not be null');stackItem&&stackItem.apply(handler);});});}/**
    * Runs "unapply" on all subcommands.
    * @param {module:history.HistoryEventHandler} handler
    * @fires module:history~Command#event:history
    * @returns {void}
    */unapply(handler){super.unapply(handler,()=>{this.stack.reverse().forEach(stackItem=>{console.assert(stackItem,'stack item should not be null');stackItem&&stackItem.unapply(handler);});});}/**
    * Iterate through all our subcommands.
    * @returns {Element[]} All the elements we are changing
    */elements(){const elems=[];let cmd=this.stack.length;while(cmd--){if(!this.stack[cmd])continue;const thisElems=this.stack[cmd].elements();let elem=thisElems.length;while(elem--){if(!elems.includes(thisElems[elem])){elems.push(thisElems[elem]);}}}return elems;}/**
    * Adds a given command to the history stack.
    * @param {Command} cmd - The undo command object to add
    * @returns {void}
    */addSubCommand(cmd){console.assert(cmd!==null,'cmd should not be null');this.stack.push(cmd);}/**
    * @returns {boolean} Indicates whether or not the batch command is empty
    */isEmpty(){return !this.stack.length;}};/**
  *
  */let UndoManager$1=class UndoManager{/**
    * @param {module:history.HistoryEventHandler} historyEventHandler
    */constructor(historyEventHandler){this.handler_=historyEventHandler||null;this.undoStackPointer=0;this.undoStack=[];// this is the stack that stores the original values, the elements and
  // the attribute name for begin/finish
  this.undoChangeStackPointer=-1;this.undoableChangeStack=[];}/**
    * Resets the undo stack, effectively clearing the undo/redo history.
    * @returns {void}
    */resetUndoStack(){this.undoStack=[];this.undoStackPointer=0;}/**
    * @returns {Integer} Current size of the undo history stack
    */getUndoStackSize(){return this.undoStackPointer;}/**
    * @returns {Integer} Current size of the redo history stack
    */getRedoStackSize(){return this.undoStack.length-this.undoStackPointer;}/**
    * @returns {string} String associated with the next undo command
    */getNextUndoCommandText(){return this.undoStackPointer>0?this.undoStack[this.undoStackPointer-1].getText():'';}/**
    * @returns {string} String associated with the next redo command
    */getNextRedoCommandText(){return this.undoStackPointer<this.undoStack.length?this.undoStack[this.undoStackPointer].getText():'';}/**
    * Performs an undo step.
    * @returns {void}
    */undo(){if(this.undoStackPointer>0){const cmd=this.undoStack[--this.undoStackPointer];cmd.unapply(this.handler_);}}/**
    * Performs a redo step.
    * @returns {void}
    */redo(){if(this.undoStackPointer<this.undoStack.length&&this.undoStack.length>0){const cmd=this.undoStack[this.undoStackPointer++];cmd.apply(this.handler_);}}/**
    * Adds a command object to the undo history stack.
    * @param {Command} cmd - The command object to add
    * @returns {void}
    */addCommandToHistory(cmd){// TODO: we MUST compress consecutive text changes to the same element
  // (right now each keystroke is saved as a separate command that includes the
  // entire text contents of the text element)
  // TODO: consider limiting the history that we store here (need to do some slicing)
  // if our stack pointer is not at the end, then we have to remove
  // all commands after the pointer and insert the new command
  if(this.undoStackPointer<this.undoStack.length&&this.undoStack.length>0){this.undoStack=this.undoStack.splice(0,this.undoStackPointer);}this.undoStack.push(cmd);this.undoStackPointer=this.undoStack.length;}/**
    * This function tells the canvas to remember the old values of the
    * `attrName` attribute for each element sent in.  The elements and values
    * are stored on a stack, so the next call to `finishUndoableChange()` will
    * pop the elements and old values off the stack, gets the current values
    * from the DOM and uses all of these to construct the undo-able command.
    * @param {string} attrName - The name of the attribute being changed
    * @param {Element[]} elems - Array of DOM elements being changed
    * @returns {void}
    */beginUndoableChange(attrName,elems){const p=++this.undoChangeStackPointer;let i=elems.length;const oldValues=new Array(i);const elements=new Array(i);while(i--){const elem=elems[i];if(!elem){continue;}elements[i]=elem;oldValues[i]=elem.getAttribute(attrName);}this.undoableChangeStack[p]={attrName,oldValues,elements};}/**
    * This function returns a `BatchCommand` object which summarizes the
    * change since `beginUndoableChange` was called.  The command can then
    * be added to the command history.
    * @returns {BatchCommand} Batch command object with resulting changes
    */finishUndoableChange(){const p=this.undoChangeStackPointer--;const changeset=this.undoableChangeStack[p];const{attrName}=changeset;const batchCmd=new BatchCommand$4('Change '+attrName);let i=changeset.elements.length;while(i--){const elem=changeset.elements[i];if(!elem){continue;}const changes={};changes[attrName]=changeset.oldValues[i];if(changes[attrName]!==elem.getAttribute(attrName)){batchCmd.addSubCommand(new ChangeElementCommand$2(elem,changes,attrName));}}this.undoableChangeStack[p]=null;return batchCmd;}};var history=/*#__PURE__*/Object.freeze({__proto__:null,HistoryEventTypes:HistoryEventTypes$1,Command:Command,MoveElementCommand:MoveElementCommand$1,InsertElementCommand:InsertElementCommand$4,RemoveElementCommand:RemoveElementCommand$2,ChangeElementCommand:ChangeElementCommand$2,BatchCommand:BatchCommand$4,UndoManager:UndoManager$1});/**
   * Path functionality.
   * @module path
   * @license MIT
   *
   * @copyright 2011 Alexis Deveria, 2011 Jeff Schiller
   */let svgCanvas$h=null;/**
  * @function module:path-actions.init
  * @param {module:path-actions.svgCanvas} pathMethodsContext
  * @returns {void}
  */const init$i=canvas=>{svgCanvas$h=canvas;};/* eslint-disable max-len */ /**
  * @function module:path.ptObjToArr
  * @todo See if this should just live in `replacePathSeg`
  * @param {string} type
  * @param {SVGPathSegMovetoAbs|SVGPathSegLinetoAbs|SVGPathSegCurvetoCubicAbs|SVGPathSegCurvetoQuadraticAbs|SVGPathSegArcAbs|SVGPathSegLinetoHorizontalAbs|SVGPathSegLinetoVerticalAbs|SVGPathSegCurvetoCubicSmoothAbs|SVGPathSegCurvetoQuadraticSmoothAbs} segItem
  * @returns {ArgumentsArray}
  */ /* eslint-enable max-len */const ptObjToArrMethod=function(type,segItem){const segData=svgCanvas$h.getSegData();const props=segData[type];return props.map(prop=>{return segItem[prop];});};/**
  * @function module:path.getGripPt
  * @param {Segment} seg
  * @param {module:math.XYObject} altPt
  * @returns {module:math.XYObject}
  */const getGripPtMethod=function(seg,altPt){const{path:pth}=seg;let out={x:altPt?altPt.x:seg.item.x,y:altPt?altPt.y:seg.item.y};if(pth.matrix){const pt=transformPoint(out.x,out.y,pth.matrix);out=pt;}const zoom=svgCanvas$h.getZoom();out.x*=zoom;out.y*=zoom;return out;};/**
  * @function module:path.getPointFromGrip
  * @param {module:math.XYObject} pt
  * @param {module:path.Path} pth
  * @returns {module:math.XYObject}
  */const getPointFromGripMethod=function(pt,pth){const out={x:pt.x,y:pt.y};if(pth.matrix){pt=transformPoint(out.x,out.y,pth.imatrix);out.x=pt.x;out.y=pt.y;}const zoom=svgCanvas$h.getZoom();out.x/=zoom;out.y/=zoom;return out;};/**
  * @function module:path.getGripContainer
  * @returns {Element}
  */const getGripContainerMethod=function(){let c=getElement('pathpointgrip_container');if(!c){const parentElement=getElement('selectorParentGroup');c=document.createElementNS(NS.SVG,'g');parentElement.append(c);c.id='pathpointgrip_container';}return c;};/**
  * Requires prior call to `setUiStrings` if `xlink:title`
  *    to be set on the grip.
  * @function module:path.addPointGrip
  * @param {Integer} index
  * @param {Integer} x
  * @param {Integer} y
  * @returns {SVGCircleElement}
  */const addPointGripMethod=function(index,x,y){// create the container of all the point grips
  const pointGripContainer=getGripContainerMethod();let pointGrip=getElement('pathpointgrip_'+index);// create it
  if(!pointGrip){pointGrip=document.createElementNS(NS.SVG,'circle');const atts={id:'pathpointgrip_'+index,display:'none',r:4,fill:'#0FF',stroke:'#00F','stroke-width':2,cursor:'move',style:'pointer-events:all'};const uiStrings=svgCanvas$h.getUIStrings();if('pathNodeTooltip'in uiStrings){// May be empty if running path.js without svg-editor
  atts['xlink:title']=uiStrings.pathNodeTooltip;}assignAttributes(pointGrip,atts);pointGripContainer.append(pointGrip);const grip=document.getElementById('pathpointgrip_'+index);grip===null||grip===void 0?void 0:grip.addEventListener('dblclick',()=>{const path=svgCanvas$h.getPathObj();if(path){path.setSegType();}});}if(x&&y){// set up the point grip element and display it
  assignAttributes(pointGrip,{cx:x,cy:y,display:'inline'});}return pointGrip;};/**
  * Requires prior call to `setUiStrings` if `xlink:title`
  *    to be set on the grip.
  * @function module:path.addCtrlGrip
  * @param {string} id
  * @returns {SVGCircleElement}
  */const addCtrlGripMethod=function(id){let pointGrip=getElement('ctrlpointgrip_'+id);if(pointGrip){return pointGrip;}pointGrip=document.createElementNS(NS.SVG,'circle');const atts={id:'ctrlpointgrip_'+id,display:'none',r:4,fill:'#0FF',stroke:'#55F','stroke-width':1,cursor:'move',style:'pointer-events:all'};const uiStrings=svgCanvas$h.getUIStrings();if('pathCtrlPtTooltip'in uiStrings){// May be empty if running path.js without svg-editor
  atts['xlink:title']=uiStrings.pathCtrlPtTooltip;}assignAttributes(pointGrip,atts);getGripContainerMethod().append(pointGrip);return pointGrip;};/**
  * @function module:path.getCtrlLine
  * @param {string} id
  * @returns {SVGLineElement}
  */const getCtrlLineMethod=function(id){let ctrlLine=getElement('ctrlLine_'+id);if(ctrlLine){return ctrlLine;}ctrlLine=document.createElementNS(NS.SVG,'line');assignAttributes(ctrlLine,{id:'ctrlLine_'+id,stroke:'#555','stroke-width':1,style:'pointer-events:none'});getGripContainerMethod().append(ctrlLine);return ctrlLine;};/**
  * @function module:path.getPointGrip
  * @param {Segment} seg
  * @param {boolean} update
  * @returns {SVGCircleElement}
  */const getPointGripMethod=function(seg,update){const{index}=seg;const pointGrip=addPointGripMethod(index);if(update){const pt=getGripPtMethod(seg);assignAttributes(pointGrip,{cx:pt.x,cy:pt.y,display:'inline'});}return pointGrip;};/**
  * @function module:path.getControlPoints
  * @param {Segment} seg
  * @returns {PlainObject<string, SVGLineElement|SVGCircleElement>}
  */const getControlPointsMethod=function(seg){const{item,index}=seg;if(!('x1'in item)||!('x2'in item)){return null;}const cpt={};/* const pointGripContainer = */getGripContainerMethod();// Note that this is intentionally not seg.prev.item
  const path=svgCanvas$h.getPathObj();const prev=path.segs[index-1].item;const segItems=[prev,item];for(let i=1;i<3;i++){const id=index+'c'+i;const ctrlLine=cpt['c'+i+'_line']=getCtrlLineMethod(id);const pt=getGripPtMethod(seg,{x:item['x'+i],y:item['y'+i]});const gpt=getGripPtMethod(seg,{x:segItems[i-1].x,y:segItems[i-1].y});assignAttributes(ctrlLine,{x1:pt.x,y1:pt.y,x2:gpt.x,y2:gpt.y,display:'inline'});cpt['c'+i+'_line']=ctrlLine;// create it
  const pointGrip=cpt['c'+i]=addCtrlGripMethod(id);assignAttributes(pointGrip,{cx:pt.x,cy:pt.y,display:'inline'});cpt['c'+i]=pointGrip;}return cpt;};/**
  * This replaces the segment at the given index. Type is given as number.
  * @function module:path.replacePathSeg
  * @param {Integer} type Possible values set during {@link module:path.init}
  * @param {Integer} index
  * @param {ArgumentsArray} pts
  * @param {SVGPathElement} elem
  * @returns {void}
  */const replacePathSegMethod=function(type,index,pts,elem){const path=svgCanvas$h.getPathObj();const pth=elem||path.elem;const pathFuncs=svgCanvas$h.getPathFuncs();const func='createSVGPathSeg'+pathFuncs[type];const seg=pth[func](...pts);pth.pathSegList.replaceItem(seg,index);};/**
  * @function module:path.getSegSelector
  * @param {Segment} seg
  * @param {boolean} update
  * @returns {SVGPathElement}
  */const getSegSelectorMethod=function(seg,update){const{index}=seg;let segLine=getElement('segline_'+index);if(!segLine){const pointGripContainer=getGripContainerMethod();// create segline
  segLine=document.createElementNS(NS.SVG,'path');assignAttributes(segLine,{id:'segline_'+index,display:'none',fill:'none',stroke:'#0FF','stroke-width':2,style:'pointer-events:none',d:'M0,0 0,0'});pointGripContainer.append(segLine);}if(update){const{prev}=seg;if(!prev){segLine.setAttribute('display','none');return segLine;}const pt=getGripPtMethod(prev);// Set start point
  replacePathSegMethod(2,0,[pt.x,pt.y],segLine);const pts=ptObjToArrMethod(seg.type,seg.item);// , true);
  for(let i=0;i<pts.length;i+=2){const point=getGripPtMethod(seg,{x:pts[i],y:pts[i+1]});pts[i]=point.x;pts[i+1]=point.y;}replacePathSegMethod(seg.type,1,pts,segLine);}return segLine;};/**
  *
  */class Segment{/**
    * @param {Integer} index
    * @param {SVGPathSeg} item
    * @todo Is `item` be more constrained here?
    */constructor(index,item){this.selected=false;this.index=index;this.item=item;this.type=item.pathSegType;this.ctrlpts=[];this.ptgrip=null;this.segsel=null;}/**
     * @param {boolean} y
     * @returns {void}
     */showCtrlPts(y){for(const i in this.ctrlpts){if({}.hasOwnProperty.call(this.ctrlpts,i)){this.ctrlpts[i].setAttribute('display',y?'inline':'none');}}}/**
     * @param {boolean} y
     * @returns {void}
     */selectCtrls(y){document.getElementById('ctrlpointgrip_'+this.index+'c1').setAttribute('fill',y?'#0FF':'#EEE');document.getElementById('ctrlpointgrip_'+this.index+'c2').setAttribute('fill',y?'#0FF':'#EEE');}/**
     * @param {boolean} y
     * @returns {void}
     */show(y){if(this.ptgrip){this.ptgrip.setAttribute('display',y?'inline':'none');this.segsel.setAttribute('display',y?'inline':'none');// Show/hide all control points if available
  this.showCtrlPts(y);}}/**
     * @param {boolean} y
     * @returns {void}
     */select(y){if(this.ptgrip){this.ptgrip.setAttribute('stroke',y?'#0FF':'#00F');this.segsel.setAttribute('display',y?'inline':'none');if(this.ctrlpts){this.selectCtrls(y);}this.selected=y;}}/**
     * @returns {void}
     */addGrip(){this.ptgrip=getPointGripMethod(this,true);this.ctrlpts=getControlPointsMethod(this);// , true);
  this.segsel=getSegSelectorMethod(this,true);}/**
     * @param {boolean} full
     * @returns {void}
     */update(full){if(this.ptgrip){const pt=getGripPtMethod(this);assignAttributes(this.ptgrip,{cx:pt.x,cy:pt.y});getSegSelectorMethod(this,true);if(this.ctrlpts){if(full){const path=svgCanvas$h.getPathObj();this.item=path.elem.pathSegList.getItem(this.index);this.type=this.item.pathSegType;}getControlPointsMethod(this);}// this.segsel.setAttribute('display', y ? 'inline' : 'none');
  }}/**
     * @param {Integer} dx
     * @param {Integer} dy
     * @returns {void}
     */move(dx,dy){var _this$next;const{item}=this;const curPts=this.ctrlpts?[item.x+=dx,item.y+=dy,item.x1,item.y1,item.x2+=dx,item.y2+=dy]:[item.x+=dx,item.y+=dy];replacePathSegMethod(this.type,this.index,// type 10 means ARC
  this.type===10?ptObjToArrMethod(this.type,item):curPts);if((_this$next=this.next)!==null&&_this$next!==void 0&&_this$next.ctrlpts){const next=this.next.item;const nextPts=[next.x,next.y,next.x1+=dx,next.y1+=dy,next.x2,next.y2];replacePathSegMethod(this.next.type,this.next.index,nextPts);}if(this.mate){// The last point of a closed subpath has a 'mate',
  // which is the 'M' segment of the subpath
  const{item:itm}=this.mate;const pts=[itm.x+=dx,itm.y+=dy];replacePathSegMethod(this.mate.type,this.mate.index,pts);// Has no grip, so does not need 'updating'?
  }this.update(true);if(this.next){this.next.update(true);}}/**
     * @param {Integer} num
     * @returns {void}
     */setLinked(num){let seg;let anum;let pt;if(num===2){anum=1;seg=this.next;if(!seg){return;}pt=this.item;}else {anum=2;seg=this.prev;if(!seg){return;}pt=seg.item;}const{item}=seg;item['x'+anum]=pt.x+(pt.x-this.item['x'+num]);item['y'+anum]=pt.y+(pt.y-this.item['y'+num]);const pts=[item.x,item.y,item.x1,item.y1,item.x2,item.y2];replacePathSegMethod(seg.type,seg.index,pts);seg.update(true);}/**
     * @param {Integer} num
     * @param {Integer} dx
     * @param {Integer} dy
     * @returns {void}
     */moveCtrl(num,dx,dy){const{item}=this;item['x'+num]+=dx;item['y'+num]+=dy;const pts=[item.x,item.y,item.x1,item.y1,item.x2,item.y2];replacePathSegMethod(this.type,this.index,pts);this.update(true);}/**
     * @param {Integer} newType Possible values set during {@link module:path.init}
     * @param {ArgumentsArray} pts
     * @returns {void}
     */setType(newType,pts){replacePathSegMethod(newType,this.index,pts);this.type=newType;const path=svgCanvas$h.getPathObj();this.item=path.elem.pathSegList.getItem(this.index);this.showCtrlPts(newType===6);this.ctrlpts=getControlPointsMethod(this);this.update(true);}}/**
  *
  */let Path$1=class Path{/**
    * @param {SVGPathElement} elem
    * @throws {Error} If constructed without a path element
    */constructor(elem){if(!elem||elem.tagName!=='path'){throw new Error('svgedit.path.Path constructed without a <path> element');}this.elem=elem;this.segs=[];this.selected_pts=[];svgCanvas$h.setPathObj(this);// path = this;
  this.init();}setPathContext(){svgCanvas$h.setPathObj(this);}/**
    * Reset path data.
    * @returns {module:path.Path}
    */init(){// Hide all grips, etc
  // fixed, needed to work on all found elements, not just first
  const pointGripContainer=getGripContainerMethod();const elements=pointGripContainer.querySelectorAll('*');Array.prototype.forEach.call(elements,function(el){el.setAttribute('display','none');});const segList=this.elem.pathSegList;const len=segList.numberOfItems;this.segs=[];this.selected_pts=[];this.first_seg=null;// Set up segs array
  for(let i=0;i<len;i++){const item=segList.getItem(i);const segment=new Segment(i,item);segment.path=this;this.segs.push(segment);}const{segs}=this;let startI=null;for(let i=0;i<len;i++){const seg=segs[i];const nextSeg=i+1>=len?null:segs[i+1];const prevSeg=i-1<0?null:segs[i-1];if(seg.type===2){if(prevSeg&&prevSeg.type!==1){// New sub-path, last one is open,
  // so add a grip to last sub-path's first point
  const startSeg=segs[startI];startSeg.next=segs[startI+1];startSeg.next.prev=startSeg;startSeg.addGrip();}// Remember that this is a starter seg
  startI=i;}else if((nextSeg===null||nextSeg===void 0?void 0:nextSeg.type)===1){// This is the last real segment of a closed sub-path
  // Next is first seg after "M"
  seg.next=segs[startI+1];// First seg after "M"'s prev is this
  seg.next.prev=seg;seg.mate=segs[startI];seg.addGrip();if(!this.first_seg){this.first_seg=seg;}}else if(!nextSeg){if(seg.type!==1){// Last seg, doesn't close so add a grip
  // to last sub-path's first point
  const startSeg=segs[startI];startSeg.next=segs[startI+1];startSeg.next.prev=startSeg;startSeg.addGrip();seg.addGrip();if(!this.first_seg){// Open path, so set first as real first and add grip
  this.first_seg=segs[startI];}}}else if(seg.type!==1){// Regular segment, so add grip and its "next"
  seg.addGrip();// Don't set its "next" if it's an "M"
  if(nextSeg&&nextSeg.type!==2){seg.next=nextSeg;seg.next.prev=seg;}}}return this;}/**
    * @callback module:path.PathEachSegCallback
    * @this module:path.Segment
    * @param {Integer} i The index of the seg being iterated
    * @returns {boolean|void} Will stop execution of `eachSeg` if returns `false`
    */ /**
    * @param {module:path.PathEachSegCallback} fn
    * @returns {void}
    */eachSeg(fn){const len=this.segs.length;for(let i=0;i<len;i++){const ret=fn.call(this.segs[i],i);if(ret===false){break;}}}/**
    * @param {Integer} index
    * @returns {void}
    */addSeg(index){// Adds a new segment
  const seg=this.segs[index];if(!seg.prev){return;}const{prev}=seg;let newseg;let newX;let newY;switch(seg.item.pathSegType){case 4:{newX=(seg.item.x+prev.item.x)/2;newY=(seg.item.y+prev.item.y)/2;newseg=this.elem.createSVGPathSegLinetoAbs(newX,newY);break;}case 6:{// make it a curved segment to preserve the shape (WRS)
  // https://en.wikipedia.org/wiki/De_Casteljau%27s_algorithm#Geometric_interpretation
  const p0x=(prev.item.x+seg.item.x1)/2;const p1x=(seg.item.x1+seg.item.x2)/2;const p2x=(seg.item.x2+seg.item.x)/2;const p01x=(p0x+p1x)/2;const p12x=(p1x+p2x)/2;newX=(p01x+p12x)/2;const p0y=(prev.item.y+seg.item.y1)/2;const p1y=(seg.item.y1+seg.item.y2)/2;const p2y=(seg.item.y2+seg.item.y)/2;const p01y=(p0y+p1y)/2;const p12y=(p1y+p2y)/2;newY=(p01y+p12y)/2;newseg=this.elem.createSVGPathSegCurvetoCubicAbs(newX,newY,p0x,p0y,p01x,p01y);const pts=[seg.item.x,seg.item.y,p12x,p12y,p2x,p2y];replacePathSegMethod(seg.type,index,pts);break;}}const list=this.elem.pathSegList;list.insertItemBefore(newseg,index);}/**
    * @param {Integer} index
    * @returns {void}
    */deleteSeg(index){const seg=this.segs[index];const list=this.elem.pathSegList;seg.show(false);const{next}=seg;if(seg.mate){// Make the next point be the "M" point
  const pt=[next.item.x,next.item.y];replacePathSegMethod(2,next.index,pt);// Reposition last node
  replacePathSegMethod(4,seg.index,pt);list.removeItem(seg.mate.index);}else if(!seg.prev){// First node of open path, make next point the M
  // const {item} = seg;
  const pt=[next.item.x,next.item.y];replacePathSegMethod(2,seg.next.index,pt);list.removeItem(index);}else {list.removeItem(index);}}/**
    * @param {Integer} index
    * @returns {void}
    */removePtFromSelection(index){const pos=this.selected_pts.indexOf(index);if(pos===-1){return;}this.segs[index].select(false);this.selected_pts.splice(pos,1);}/**
    * @returns {void}
    */clearSelection(){this.eachSeg(function(){// 'this' is the segment here
  this.select(false);});this.selected_pts=[];}/**
    * @returns {void}
    */storeD(){this.last_d=this.elem.getAttribute('d');}/**
    * @param {Integer} y
    * @returns {Path}
    */show(y){// Shows this path's segment grips
  this.eachSeg(function(){// 'this' is the segment here
  this.show(y);});if(y){this.selectPt(this.first_seg.index);}return this;}/**
    * Move selected points.
    * @param {Integer} dx
    * @param {Integer} dy
    * @returns {void}
    */movePts(dx,dy){let i=this.selected_pts.length;while(i--){const seg=this.segs[this.selected_pts[i]];seg.move(dx,dy);}}/**
    * @param {Integer} dx
    * @param {Integer} dy
    * @returns {void}
    */moveCtrl(dx,dy){const seg=this.segs[this.selected_pts[0]];seg.moveCtrl(this.dragctrl,dx,dy);if(svgCanvas$h.getLinkControlPts()){seg.setLinked(this.dragctrl);}}/**
    * @param {?Integer} newType See {@link https://www.w3.org/TR/SVG/single-page.html#paths-InterfaceSVGPathSeg}
    * @returns {void}
    */setSegType(newType){this.storeD();let i=this.selected_pts.length;let text;while(i--){const selPt=this.selected_pts[i];// Selected seg
  const cur=this.segs[selPt];const{prev}=cur;if(!prev){continue;}if(!newType){// double-click, so just toggle
  text='Toggle Path Segment Type';// Toggle segment to curve/straight line
  const oldType=cur.type;newType=oldType===6?4:6;}newType=Number(newType);const curX=cur.item.x;const curY=cur.item.y;const prevX=prev.item.x;const prevY=prev.item.y;let points;switch(newType){case 6:{if(cur.olditem){const old=cur.olditem;points=[curX,curY,old.x1,old.y1,old.x2,old.y2];}else {const diffX=curX-prevX;const diffY=curY-prevY;// get control points from straight line segment
  /*
                const ct1x = (prevX + (diffY/2));
                const ct1y = (prevY - (diffX/2));
                const ct2x = (curX + (diffY/2));
                const ct2y = (curY - (diffX/2));
                */ // create control points on the line to preserve the shape (WRS)
  const ct1x=prevX+diffX/3;const ct1y=prevY+diffY/3;const ct2x=curX-diffX/3;const ct2y=curY-diffY/3;points=[curX,curY,ct1x,ct1y,ct2x,ct2y];}break;}case 4:{points=[curX,curY];// Store original prevve segment nums
  cur.olditem=cur.item;break;}}cur.setType(newType,points);}const path=svgCanvas$h.getPathObj();path.endChanges(text);}/**
    * @param {Integer} pt
    * @param {Integer} ctrlNum
    * @returns {void}
    */selectPt(pt,ctrlNum){this.clearSelection();if(!pt){this.eachSeg(function(i){// 'this' is the segment here.
  if(this.prev){pt=i;}});}this.addPtsToSelection(pt);if(ctrlNum){this.dragctrl=ctrlNum;if(svgCanvas$h.getLinkControlPts()){this.segs[pt].setLinked(ctrlNum);}}}/**
    * Update position of all points.
    * @returns {Path}
    */update(){const{elem}=this;if(getRotationAngle(elem)){this.matrix=getMatrix(elem);this.imatrix=this.matrix.inverse();}else {this.matrix=null;this.imatrix=null;}this.eachSeg(function(i){this.item=elem.pathSegList.getItem(i);this.update();});return this;}/**
    * @param {string} text
    * @returns {void}
    */endChanges(text){const cmd=new ChangeElementCommand$2(this.elem,{d:this.last_d},text);svgCanvas$h.endChanges({cmd,elem:this.elem});}/**
    * @param {Integer|Integer[]} indexes
    * @returns {void}
    */addPtsToSelection(indexes){if(!Array.isArray(indexes)){indexes=[indexes];}indexes.forEach(index=>{const seg=this.segs[index];if(seg.ptgrip&&!this.selected_pts.includes(index)&&index>=0){this.selected_pts.push(index);}});this.selected_pts.sort();let i=this.selected_pts.length;const grips=[];grips.length=i;// Loop through points to be selected and highlight each
  while(i--){const pt=this.selected_pts[i];const seg=this.segs[pt];seg.select(true);grips[i]=seg.ptgrip;}const closedSubpath=Path$1.subpathIsClosed(this.selected_pts[0]);svgCanvas$h.addPtsToSelection({grips,closedSubpath});}// STATIC
  /**
    * @param {Integer} index
    * @returns {boolean}
    */static subpathIsClosed(index){let clsd=false;// Check if subpath is already open
  const path=svgCanvas$h.getPathObj();path.eachSeg(function(i){if(i<=index){return true;}if(this.type===2){// Found M first, so open
  return false;}if(this.type===1){// Found Z first, so closed
  clsd=true;return false;}return true;});return clsd;}};/**
   * Path functionality.
   * @module path
   * @license MIT
   *
   * @copyright 2011 Alexis Deveria, 2011 Jeff Schiller
   */let svgCanvas$g=null;let path$1=null;/**
  * @function module:path-actions.init
  * @param {module:path-actions.svgCanvas} pathActionsContext
  * @returns {void}
  */const init$h=canvas=>{svgCanvas$g=canvas;};/**
   * Convert a path to one with only absolute or relative values.
   * @todo move to pathActions.js
   * @function module:path.convertPath
   * @param {SVGPathElement} pth - the path to convert
   * @param {boolean} toRel - true of convert to relative
   * @returns {string}
   */const convertPath$1=function(pth,toRel){const{pathSegList}=pth;const len=pathSegList.numberOfItems;let curx=0;let cury=0;let d='';let lastM=null;for(let i=0;i<len;++i){const seg=pathSegList.getItem(i);// if these properties are not in the segment, set them to zero
  let x=seg.x||0;let y=seg.y||0;let x1=seg.x1||0;let y1=seg.y1||0;let x2=seg.x2||0;let y2=seg.y2||0;// const type = seg.pathSegType;
  // const pathMap = svgCanvas.getPathMap();
  // let letter = pathMap[type][toRel ? 'toLowerCase' : 'toUpperCase']();
  let letter=seg.pathSegTypeAsLetter;switch(letter){case'z':// z,Z closepath (Z/z)
  case'Z':d+='z';if(lastM&&!toRel){curx=lastM[0];cury=lastM[1];}break;case'H':// absolute horizontal line (H)
  x-=curx;// Fallthrough
  case'h':// relative horizontal line (h)
  if(toRel){y=0;curx+=x;letter='l';}else {y=cury;x+=curx;curx=x;letter='L';}// Convert to "line" for easier editing
  d+=pathDSegment$1(letter,[[x,y]]);break;case'V':// absolute vertical line (V)
  y-=cury;// Fallthrough
  case'v':// relative vertical line (v)
  if(toRel){x=0;cury+=y;letter='l';}else {x=curx;y+=cury;cury=y;letter='L';}// Convert to "line" for easier editing
  d+=pathDSegment$1(letter,[[x,y]]);break;case'M':// absolute move (M)
  case'L':// absolute line (L)
  case'T':// absolute smooth quad (T)
  x-=curx;y-=cury;// Fallthrough
  case'l':// relative line (l)
  case'm':// relative move (m)
  case't':// relative smooth quad (t)
  if(toRel){curx+=x;cury+=y;letter=letter.toLowerCase();}else {x+=curx;y+=cury;curx=x;cury=y;letter=letter.toUpperCase();}if(letter==='m'||letter==='M'){lastM=[curx,cury];}d+=pathDSegment$1(letter,[[x,y]]);break;case'C':// absolute cubic (C)
  x-=curx;x1-=curx;x2-=curx;y-=cury;y1-=cury;y2-=cury;// Fallthrough
  case'c':// relative cubic (c)
  if(toRel){curx+=x;cury+=y;letter='c';}else {x+=curx;x1+=curx;x2+=curx;y+=cury;y1+=cury;y2+=cury;curx=x;cury=y;letter='C';}d+=pathDSegment$1(letter,[[x1,y1],[x2,y2],[x,y]]);break;case'Q':// absolute quad (Q)
  x-=curx;x1-=curx;y-=cury;y1-=cury;// Fallthrough
  case'q':// relative quad (q)
  if(toRel){curx+=x;cury+=y;letter='q';}else {x+=curx;x1+=curx;y+=cury;y1+=cury;curx=x;cury=y;letter='Q';}d+=pathDSegment$1(letter,[[x1,y1],[x,y]]);break;case'A':x-=curx;y-=cury;// fallthrough
  case'a':// relative elliptical arc (a)
  if(toRel){curx+=x;cury+=y;letter='a';}else {x+=curx;y+=cury;curx=x;cury=y;letter='A';}d+=pathDSegment$1(letter,[[seg.r1,seg.r2]],[seg.angle,seg.largeArcFlag?1:0,seg.sweepFlag?1:0],[x,y]);break;case'S':// absolute smooth cubic (S)
  x-=curx;x2-=curx;y-=cury;y2-=cury;// Fallthrough
  case's':// relative smooth cubic (s)
  if(toRel){curx+=x;cury+=y;letter='s';}else {x+=curx;x2+=curx;y+=cury;y2+=cury;curx=x;cury=y;letter='S';}d+=pathDSegment$1(letter,[[x2,y2],[x,y]]);break;}// switch on path segment type
  }// for each segment
  return d;};/**
   * TODO: refactor callers in `convertPath` to use `getPathDFromSegments` instead of this function.
   * Legacy code refactored from `svgcanvas.pathActions.convertPath`.
   * @param {string} letter - path segment command (letter in potentially either case from {@link module:path.pathMap}; see [SVGPathSeg#pathSegTypeAsLetter]{@link https://www.w3.org/TR/SVG/single-page.html#paths-__svg__SVGPathSeg__pathSegTypeAsLetter})
   * @param {GenericArray<GenericArray<Integer>>} points - x,y points
   * @param {GenericArray<GenericArray<Integer>>} [morePoints] - x,y points
   * @param {Integer[]} [lastPoint] - x,y point
   * @returns {string}
   */function pathDSegment$1(letter,points,morePoints,lastPoint){points.forEach(function(pnt,i){points[i]=shortFloat(pnt);});let segment=letter+points.join(' ');if(morePoints){segment+=' '+morePoints.join(' ');}if(lastPoint){segment+=' '+shortFloat(lastPoint);}return segment;}/**
  * Group: Path edit functions.
  * Functions relating to editing path elements.
  * @namespace {PlainObject} pathActions
  * @memberof module:path
  */const pathActionsMethod=function(){let subpath=false;let newPoint;let firstCtrl;let currentPath=null;let hasMoved=false;// No `svgCanvas` yet but should be ok as is `null` by default
  // svgCanvas.setDrawnPath(null);
  /**
    * This function converts a polyline (created by the fh_path tool) into
    * a path element and coverts every three line segments into a single bezier
    * curve in an attempt to smooth out the free-hand.
    * @function smoothPolylineIntoPath
    * @param {Element} element
    * @returns {Element}
    */const smoothPolylineIntoPath=function(element){let i;const{points}=element;const N=points.numberOfItems;if(N>=4){// loop through every 3 points and convert to a cubic bezier curve segment
  //
  // NOTE: this is cheating, it means that every 3 points has the potential to
  // be a corner instead of treating each point in an equal manner. In general,
  // this technique does not look that good.
  //
  // I am open to better ideas!
  //
  // Reading:
  // - http://www.efg2.com/Lab/Graphics/Jean-YvesQueinecBezierCurves.htm
  // - https://www.codeproject.com/KB/graphics/BezierSpline.aspx?msg=2956963
  // - https://www.ian-ko.com/ET_GeoWizards/UserGuide/smooth.htm
  // - https://www.cs.mtu.edu/~shene/COURSES/cs3621/NOTES/spline/Bezier/bezier-der.html
  let curpos=points.getItem(0);let prevCtlPt=null;let d=[];d.push(['M',curpos.x,',',curpos.y,' C'].join(''));for(i=1;i<=N-4;i+=3){let ct1=points.getItem(i);const ct2=points.getItem(i+1);const end=points.getItem(i+2);// if the previous segment had a control point, we want to smooth out
  // the control points on both sides
  if(prevCtlPt){const newpts=svgCanvas$g.smoothControlPoints(prevCtlPt,ct1,curpos);if((newpts===null||newpts===void 0?void 0:newpts.length)===2){const prevArr=d[d.length-1].split(',');prevArr[2]=newpts[0].x;prevArr[3]=newpts[0].y;d[d.length-1]=prevArr.join(',');ct1=newpts[1];}}d.push([ct1.x,ct1.y,ct2.x,ct2.y,end.x,end.y].join(','));curpos=end;prevCtlPt=ct2;}// handle remaining line segments
  d.push('L');while(i<N){const pt=points.getItem(i);d.push([pt.x,pt.y].join(','));i++;}d=d.join(' ');element=svgCanvas$g.addSVGElementsFromJson({element:'path',curStyles:true,attr:{id:svgCanvas$g.getId(),d,fill:'none'}});// No need to call "changed", as this is already done under mouseUp
  }return element;};return(/** @lends module:path.pathActions */{/**
        * @param {MouseEvent} evt
        * @param {Element} mouseTarget
        * @param {Float} startX
        * @param {Float} startY
        * @returns {boolean|void}
        */mouseDown(evt,mouseTarget,startX,startY){let id;if(svgCanvas$g.getCurrentMode()==='path'){let mouseX=startX;// Was this meant to work with the other `mouseX`? (was defined globally so adding `let` to at least avoid a global)
  let mouseY=startY;// Was this meant to work with the other `mouseY`? (was defined globally so adding `let` to at least avoid a global)
  const zoom=svgCanvas$g.getZoom();let x=mouseX/zoom;let y=mouseY/zoom;let stretchy=getElement('path_stretch_line');newPoint=[x,y];if(svgCanvas$g.getGridSnapping()){x=snapToGrid(x);y=snapToGrid(y);mouseX=snapToGrid(mouseX);mouseY=snapToGrid(mouseY);}if(!stretchy){stretchy=document.createElementNS(NS.SVG,'path');assignAttributes(stretchy,{id:'path_stretch_line',stroke:'#22C','stroke-width':'0.5',fill:'none'});getElement('selectorParentGroup').append(stretchy);}stretchy.setAttribute('display','inline');let keep=null;let index;// if pts array is empty, create path element with M at current point
  const drawnPath=svgCanvas$g.getDrawnPath();if(!drawnPath){const dAttr='M'+x+','+y+' ';// Was this meant to work with the other `dAttr`? (was defined globally so adding `var` to at least avoid a global)
  /* drawnPath = */svgCanvas$g.setDrawnPath(svgCanvas$g.addSVGElementsFromJson({element:'path',curStyles:true,attr:{d:dAttr,id:svgCanvas$g.getNextId(),opacity:svgCanvas$g.getOpacity()/2}}));// set stretchy line to first point
  stretchy.setAttribute('d',['M',mouseX,mouseY,mouseX,mouseY].join(' '));index=subpath?path$1.segs.length:0;svgCanvas$g.addPointGrip(index,mouseX,mouseY);}else {// determine if we clicked on an existing point
  const seglist=drawnPath.pathSegList;let i=seglist.numberOfItems;const FUZZ=6/zoom;let clickOnPoint=false;while(i){i--;const item=seglist.getItem(i);const px=item.x;const py=item.y;// found a matching point
  if(x>=px-FUZZ&&x<=px+FUZZ&&y>=py-FUZZ&&y<=py+FUZZ){clickOnPoint=true;break;}}// get path element that we are in the process of creating
  id=svgCanvas$g.getId();// Remove previous path object if previously created
  svgCanvas$g.removePath_(id);const newpath=getElement(id);let newseg;let sSeg;const len=seglist.numberOfItems;// if we clicked on an existing point, then we are done this path, commit it
  // (i, i+1) are the x,y that were clicked on
  if(clickOnPoint){// if clicked on any other point but the first OR
  // the first point was clicked on and there are less than 3 points
  // then leave the path open
  // otherwise, close the path
  if(i<=1&&len>=2){// Create end segment
  const absX=seglist.getItem(0).x;const absY=seglist.getItem(0).y;sSeg=stretchy.pathSegList.getItem(1);newseg=sSeg.pathSegType===4?drawnPath.createSVGPathSegLinetoAbs(absX,absY):drawnPath.createSVGPathSegCurvetoCubicAbs(absX,absY,sSeg.x1/zoom,sSeg.y1/zoom,absX,absY);const endseg=drawnPath.createSVGPathSegClosePath();seglist.appendItem(newseg);seglist.appendItem(endseg);}else if(len<3){keep=false;return keep;}stretchy.remove();// This will signal to commit the path
  // const element = newpath; // Other event handlers define own `element`, so this was probably not meant to interact with them or one which shares state (as there were none); I therefore adding a missing `var` to avoid a global
  /* drawnPath = */svgCanvas$g.setDrawnPath(null);svgCanvas$g.setStarted(false);if(subpath){if(path$1.matrix){svgCanvas$g.remapElement(newpath,{},path$1.matrix.inverse());}const newD=newpath.getAttribute('d');const origD=path$1.elem.getAttribute('d');path$1.elem.setAttribute('d',origD+newD);newpath.parentNode.removeChild(newpath);if(path$1.matrix){svgCanvas$g.recalcRotatedPath();}pathActionsMethod.toEditMode(path$1.elem);path$1.selectPt();return false;}// else, create a new point, update path element
  }else {// Checks if current target or parents are #svgcontent
  if(!(svgCanvas$g.getContainer()!==svgCanvas$g.getMouseTarget(evt)&&svgCanvas$g.getContainer().contains(svgCanvas$g.getMouseTarget(evt)))){// Clicked outside canvas, so don't make point
  return false;}const num=drawnPath.pathSegList.numberOfItems;const last=drawnPath.pathSegList.getItem(num-1);const lastx=last.x;const lasty=last.y;if(evt.shiftKey){const xya=snapToAngle(lastx,lasty,x,y);({x,y}=xya);}// Use the segment defined by stretchy
  sSeg=stretchy.pathSegList.getItem(1);newseg=sSeg.pathSegType===4?drawnPath.createSVGPathSegLinetoAbs(svgCanvas$g.round(x),svgCanvas$g.round(y)):drawnPath.createSVGPathSegCurvetoCubicAbs(svgCanvas$g.round(x),svgCanvas$g.round(y),sSeg.x1/zoom,sSeg.y1/zoom,sSeg.x2/zoom,sSeg.y2/zoom);drawnPath.pathSegList.appendItem(newseg);x*=zoom;y*=zoom;// set stretchy line to latest point
  stretchy.setAttribute('d',['M',x,y,x,y].join(' '));index=num;if(subpath){index+=path$1.segs.length;}svgCanvas$g.addPointGrip(index,x,y);}// keep = true;
  }return undefined;}// TODO: Make sure currentPath isn't null at this point
  if(!path$1){return undefined;}path$1.storeD();({id}=evt.target);let curPt;if(id.substr(0,14)==='pathpointgrip_'){// Select this point
  curPt=path$1.cur_pt=Number.parseInt(id.substr(14));path$1.dragging=[startX,startY];const seg=path$1.segs[curPt];// only clear selection if shift is not pressed (otherwise, add
  // node to selection)
  if(!evt.shiftKey){if(path$1.selected_pts.length<=1||!seg.selected){path$1.clearSelection();}path$1.addPtsToSelection(curPt);}else if(seg.selected){path$1.removePtFromSelection(curPt);}else {path$1.addPtsToSelection(curPt);}}else if(id.startsWith('ctrlpointgrip_')){path$1.dragging=[startX,startY];const parts=id.split('_')[1].split('c');curPt=Number(parts[0]);const ctrlNum=Number(parts[1]);path$1.selectPt(curPt,ctrlNum);}// Start selection box
  if(!path$1.dragging){let rubberBox=svgCanvas$g.getRubberBox();if(!rubberBox){rubberBox=svgCanvas$g.setRubberBox(svgCanvas$g.selectorManager.getRubberBandBox());}const zoom=svgCanvas$g.getZoom();assignAttributes(rubberBox,{x:startX*zoom,y:startY*zoom,width:0,height:0,display:'inline'});}return undefined;},/**
        * @param {Float} mouseX
        * @param {Float} mouseY
        * @returns {void}
        */mouseMove(mouseX,mouseY){const zoom=svgCanvas$g.getZoom();hasMoved=true;const drawnPath=svgCanvas$g.getDrawnPath();if(svgCanvas$g.getCurrentMode()==='path'){if(!drawnPath){return;}const seglist=drawnPath.pathSegList;const index=seglist.numberOfItems-1;if(newPoint){// First point
  // if (!index) { return; }
  // Set control points
  const pointGrip1=svgCanvas$g.addCtrlGrip('1c1');const pointGrip2=svgCanvas$g.addCtrlGrip('0c2');// dragging pointGrip1
  pointGrip1.setAttribute('cx',mouseX);pointGrip1.setAttribute('cy',mouseY);pointGrip1.setAttribute('display','inline');const ptX=newPoint[0];const ptY=newPoint[1];// set curve
  // const seg = seglist.getItem(index);
  const curX=mouseX/zoom;const curY=mouseY/zoom;const altX=ptX+(ptX-curX);const altY=ptY+(ptY-curY);pointGrip2.setAttribute('cx',altX*zoom);pointGrip2.setAttribute('cy',altY*zoom);pointGrip2.setAttribute('display','inline');const ctrlLine=svgCanvas$g.getCtrlLine(1);assignAttributes(ctrlLine,{x1:mouseX,y1:mouseY,x2:altX*zoom,y2:altY*zoom,display:'inline'});if(index===0){firstCtrl=[mouseX,mouseY];}else {const last=seglist.getItem(index-1);let lastX=last.x;let lastY=last.y;if(last.pathSegType===6){lastX+=lastX-last.x2;lastY+=lastY-last.y2;}else if(firstCtrl){lastX=firstCtrl[0]/zoom;lastY=firstCtrl[1]/zoom;}svgCanvas$g.replacePathSeg(6,index,[ptX,ptY,lastX,lastY,altX,altY],drawnPath);}}else {const stretchy=getElement('path_stretch_line');if(stretchy){const prev=seglist.getItem(index);if(prev.pathSegType===6){const prevX=prev.x+(prev.x-prev.x2);const prevY=prev.y+(prev.y-prev.y2);svgCanvas$g.replacePathSeg(6,1,[mouseX,mouseY,prevX*zoom,prevY*zoom,mouseX,mouseY],stretchy);}else if(firstCtrl){svgCanvas$g.replacePathSeg(6,1,[mouseX,mouseY,firstCtrl[0],firstCtrl[1],mouseX,mouseY],stretchy);}else {svgCanvas$g.replacePathSeg(4,1,[mouseX,mouseY],stretchy);}}}return;}// if we are dragging a point, let's move it
  if(path$1.dragging){const pt=svgCanvas$g.getPointFromGrip({x:path$1.dragging[0],y:path$1.dragging[1]},path$1);const mpt=svgCanvas$g.getPointFromGrip({x:mouseX,y:mouseY},path$1);const diffX=mpt.x-pt.x;const diffY=mpt.y-pt.y;path$1.dragging=[mouseX,mouseY];if(path$1.dragctrl){path$1.moveCtrl(diffX,diffY);}else {path$1.movePts(diffX,diffY);}}else {path$1.selected_pts=[];path$1.eachSeg(function(_i){const seg=this;if(!seg.next&&!seg.prev){return;}// const {item} = seg;
  const rubberBox=svgCanvas$g.getRubberBox();const rbb=getBBox(rubberBox);const pt=svgCanvas$g.getGripPt(seg);const ptBb={x:pt.x,y:pt.y,width:0,height:0};const sel=rectsIntersect(rbb,ptBb);this.select(sel);// Note that addPtsToSelection is not being run
  if(sel){path$1.selected_pts.push(seg.index);}});}},/**
         * @typedef module:path.keepElement
         * @type {PlainObject}
         * @property {boolean} keep
         * @property {Element} element
         */ /**
        * @param {Event} evt
        * @param {Element} element
        * @param {Float} _mouseX
        * @param {Float} _mouseY
        * @returns {module:path.keepElement|void}
        */mouseUp(evt,element,_mouseX,_mouseY){const drawnPath=svgCanvas$g.getDrawnPath();// Create mode
  if(svgCanvas$g.getCurrentMode()==='path'){newPoint=null;if(!drawnPath){element=getElement(svgCanvas$g.getId());svgCanvas$g.setStarted(false);firstCtrl=null;}return {keep:true,element};}// Edit mode
  const rubberBox=svgCanvas$g.getRubberBox();if(path$1.dragging){const lastPt=path$1.cur_pt;path$1.dragging=false;path$1.dragctrl=false;path$1.update();if(hasMoved){path$1.endChanges('Move path point(s)');}if(!evt.shiftKey&&!hasMoved){path$1.selectPt(lastPt);}}else if((rubberBox===null||rubberBox===void 0?void 0:rubberBox.getAttribute('display'))!=='none'){// Done with multi-node-select
  rubberBox.setAttribute('display','none');if(rubberBox.getAttribute('width')<=2&&rubberBox.getAttribute('height')<=2){pathActionsMethod.toSelectMode(evt.target);}// else, move back to select mode
  }else {pathActionsMethod.toSelectMode(evt.target);}hasMoved=false;return undefined;},/**
        * @param {Element} element
        * @returns {void}
        */toEditMode(element){path$1=svgCanvas$g.getPath_(element);svgCanvas$g.setCurrentMode('pathedit');svgCanvas$g.clearSelection();path$1.setPathContext();path$1.show(true).update();path$1.oldbbox=getBBox(path$1.elem);subpath=false;},/**
        * @param {Element} elem
        * @fires module:svgcanvas.SvgCanvas#event:selected
        * @returns {void}
        */toSelectMode(elem){const selPath=elem===path$1.elem;svgCanvas$g.setCurrentMode('select');path$1.setPathContext();path$1.show(false);currentPath=false;svgCanvas$g.clearSelection();if(path$1.matrix){// Rotated, so may need to re-calculate the center
  svgCanvas$g.recalcRotatedPath();}if(selPath){svgCanvas$g.call('selected',[elem]);svgCanvas$g.addToSelection([elem],true);}},/**
        * @param {boolean} on
        * @returns {void}
        */addSubPath(on){if(on){// Internally we go into "path" mode, but in the UI it will
  // still appear as if in "pathedit" mode.
  svgCanvas$g.setCurrentMode('path');subpath=true;}else {pathActionsMethod.clear(true);pathActionsMethod.toEditMode(path$1.elem);}},/**
        * @param {Element} target
        * @returns {void}
        */select(target){if(currentPath===target){pathActionsMethod.toEditMode(target);svgCanvas$g.setCurrentMode('pathedit');// going into pathedit mode
  }else {currentPath=target;}},/**
        * @fires module:svgcanvas.SvgCanvas#event:changed
        * @returns {void}
        */reorient(){const elem=svgCanvas$g.getSelectedElements()[0];if(!elem){return;}const angl=getRotationAngle(elem);if(angl===0){return;}const batchCmd=new BatchCommand$4('Reorient path');const changes={d:elem.getAttribute('d'),transform:elem.getAttribute('transform')};batchCmd.addSubCommand(new ChangeElementCommand$2(elem,changes));svgCanvas$g.clearSelection();this.resetOrientation(elem);svgCanvas$g.addCommandToHistory(batchCmd);// Set matrix to null
  svgCanvas$g.getPath_(elem).show(false).matrix=null;this.clear();svgCanvas$g.addToSelection([elem],true);svgCanvas$g.call('changed',svgCanvas$g.getSelectedElements());},/**
        * @param {boolean} remove Not in use
        * @returns {void}
        */clear(){const drawnPath=svgCanvas$g.getDrawnPath();currentPath=null;if(drawnPath){const elem=getElement(svgCanvas$g.getId());const psl=getElement('path_stretch_line');psl.parentNode.removeChild(psl);elem.parentNode.removeChild(elem);const pathpointgripContainer=getElement('pathpointgrip_container');const elements=pathpointgripContainer.querySelectorAll('*');Array.prototype.forEach.call(elements,function(el){el.setAttribute('display','none');});firstCtrl=null;svgCanvas$g.setDrawnPath(null);svgCanvas$g.setStarted(false);}else if(svgCanvas$g.getCurrentMode()==='pathedit'){this.toSelectMode();}if(path$1){path$1.init().show(false);}},/**
        * @param {?(Element|SVGPathElement)} pth
        * @returns {false|void}
        */resetOrientation(pth){if((pth===null||pth===void 0?void 0:pth.nodeName)!=='path'){return false;}const tlist=pth.transform.baseVal;const m=transformListToTransform(tlist).matrix;tlist.clear();pth.removeAttribute('transform');const segList=pth.pathSegList;// Opera/win/non-EN throws an error here.
  // TODO: Find out why!
  // Presumed fixed in Opera 10.5, so commented out for now
  // try {
  const len=segList.numberOfItems;// } catch(err) {
  //   const fixed_d = pathActions.convertPath(pth);
  //   pth.setAttribute('d', fixed_d);
  //   segList = pth.pathSegList;
  //   const len = segList.numberOfItems;
  // }
  // let lastX, lastY;
  for(let i=0;i<len;++i){const seg=segList.getItem(i);const type=seg.pathSegType;if(type===1){continue;}const pts=[];['',1,2].forEach(function(n){const x=seg['x'+n];const y=seg['y'+n];if(x!==undefined&&y!==undefined){const pt=transformPoint(x,y,m);pts.splice(pts.length,0,pt.x,pt.y);}});svgCanvas$g.replacePathSeg(type,i,pts,pth);}svgCanvas$g.reorientGrads(pth,m);return undefined;},/**
        * @returns {void}
        */zoomChange(){if(svgCanvas$g.getCurrentMode()==='pathedit'){path$1.update();}},/**
        * @typedef {PlainObject} module:path.NodePoint
        * @property {Float} x
        * @property {Float} y
        * @property {Integer} type
        */ /**
        * @returns {module:path.NodePoint}
        */getNodePoint(){const selPt=path$1.selected_pts.length?path$1.selected_pts[0]:1;const seg=path$1.segs[selPt];return {x:seg.item.x,y:seg.item.y,type:seg.type};},/**
        * @param {boolean} linkPoints
        * @returns {void}
        */linkControlPoints(linkPoints){svgCanvas$g.setLinkControlPoints(linkPoints);},/**
        * @returns {void}
        */clonePathNode(){path$1.storeD();const selPts=path$1.selected_pts;// const {segs} = path;
  let i=selPts.length;const nums=[];while(i--){const pt=selPts[i];path$1.addSeg(pt);nums.push(pt+i);nums.push(pt+i+1);}path$1.init().addPtsToSelection(nums);path$1.endChanges('Clone path node(s)');},/**
        * @returns {void}
        */opencloseSubPath(){const selPts=path$1.selected_pts;// Only allow one selected node for now
  if(selPts.length!==1){return;}const{elem}=path$1;const list=elem.pathSegList;// const len = list.numberOfItems;
  const index=selPts[0];let openPt=null;let startItem=null;// Check if subpath is already open
  path$1.eachSeg(function(i){if(this.type===2&&i<=index){startItem=this.item;}if(i<=index){return true;}if(this.type===2){// Found M first, so open
  openPt=i;return false;}if(this.type===1){// Found Z first, so closed
  openPt=false;return false;}return true;});if(!openPt){// Single path, so close last seg
  openPt=path$1.segs.length-1;}if(openPt!==false){// Close this path
  // Create a line going to the previous "M"
  const newseg=elem.createSVGPathSegLinetoAbs(startItem.x,startItem.y);const closer=elem.createSVGPathSegClosePath();if(openPt===path$1.segs.length-1){list.appendItem(newseg);list.appendItem(closer);}else {list.insertItemBefore(closer,openPt);list.insertItemBefore(newseg,openPt);}path$1.init().selectPt(openPt+1);return;}// M 1,1 L 2,2 L 3,3 L 1,1 z // open at 2,2
  // M 2,2 L 3,3 L 1,1
  // M 1,1 L 2,2 L 1,1 z M 4,4 L 5,5 L6,6 L 5,5 z
  // M 1,1 L 2,2 L 1,1 z [M 4,4] L 5,5 L(M)6,6 L 5,5 z
  const seg=path$1.segs[index];if(seg.mate){list.removeItem(index);// Removes last "L"
  list.removeItem(index);// Removes the "Z"
  path$1.init().selectPt(index-1);return;}let lastM;let zSeg;// Find this sub-path's closing point and remove
  for(let i=0;i<list.numberOfItems;i++){const item=list.getItem(i);if(item.pathSegType===2){// Find the preceding M
  lastM=i;}else if(i===index){// Remove it
  list.removeItem(lastM);// index--;
  }else if(item.pathSegType===1&&index<i){// Remove the closing seg of this subpath
  zSeg=i-1;list.removeItem(i);break;}}let num=index-lastM-1;while(num--){list.insertItemBefore(list.getItem(lastM),zSeg);}const pt=list.getItem(lastM);// Make this point the new "M"
  svgCanvas$g.replacePathSeg(2,lastM,[pt.x,pt.y]);// i = index; // i is local here, so has no effect; what was the intent for this?
  path$1.init().selectPt(0);},/**
        * @returns {void}
        */deletePathNode(){if(!pathActionsMethod.canDeleteNodes){return;}path$1.storeD();const selPts=path$1.selected_pts;let i=selPts.length;while(i--){const pt=selPts[i];path$1.deleteSeg(pt);}// Cleanup
  const cleanup=function(){const segList=path$1.elem.pathSegList;let len=segList.numberOfItems;const remItems=function(pos,count){while(count--){segList.removeItem(pos);}};if(len<=1){return true;}while(len--){const item=segList.getItem(len);if(item.pathSegType===1){const prev=segList.getItem(len-1);const nprev=segList.getItem(len-2);if(prev.pathSegType===2){remItems(len-1,2);cleanup();break;}else if(nprev.pathSegType===2){remItems(len-2,3);cleanup();break;}}else if(item.pathSegType===2&&len>0){const prevType=segList.getItem(len-1).pathSegType;// Path has M M
  if(prevType===2){remItems(len-1,1);cleanup();break;// Entire path ends with Z M
  }else if(prevType===1&&segList.numberOfItems-1===len){remItems(len,1);cleanup();break;}}}return false;};cleanup();// Completely delete a path with 1 or 0 segments
  if(path$1.elem.pathSegList.numberOfItems<=1){pathActionsMethod.toSelectMode(path$1.elem);svgCanvas$g.canvas.deleteSelectedElements();return;}path$1.init();path$1.clearSelection();// TODO: Find right way to select point now
  // path.selectPt(selPt);
  if(window.opera){// Opera repaints incorrectly
  path$1.elem.setAttribute('d',path$1.elem.getAttribute('d'));}path$1.endChanges('Delete path node(s)');},// Can't seem to use `@borrows` here, so using `@see`
  /**
        * Smooth polyline into path.
        * @function module:path.pathActions.smoothPolylineIntoPath
        * @see module:path~smoothPolylineIntoPath
        */smoothPolylineIntoPath,/* eslint-enable  */ /**
        * @param {?Integer} v See {@link https://www.w3.org/TR/SVG/single-page.html#paths-InterfaceSVGPathSeg}
        * @returns {void}
        */setSegType(v){var _path$;(_path$=path$1)===null||_path$===void 0?void 0:_path$.setSegType(v);},/**
        * @param {string} attr
        * @param {Float} newValue
        * @returns {void}
        */moveNode(attr,newValue){const selPts=path$1.selected_pts;if(!selPts.length){return;}path$1.storeD();// Get first selected point
  const seg=path$1.segs[selPts[0]];const diff={x:0,y:0};diff[attr]=newValue-seg.item[attr];seg.move(diff.x,diff.y);path$1.endChanges('Move path point');},/**
        * @param {Element} elem
        * @returns {void}
        */fixEnd(elem){// Adds an extra segment if the last seg before a Z doesn't end
  // at its M point
  // M0,0 L0,100 L100,100 z
  const segList=elem.pathSegList;const len=segList.numberOfItems;let lastM;for(let i=0;i<len;++i){const item=segList.getItem(i);if(item.pathSegType===2){// 2 => M segment type (move to)
  lastM=item;}if(item.pathSegType===1){// 1 => Z segment type (close path)
  const prev=segList.getItem(i-1);if(prev.x!==lastM.x||prev.y!==lastM.y){// Add an L segment here
  const newseg=elem.createSVGPathSegLinetoAbs(lastM.x,lastM.y);segList.insertItemBefore(newseg,i);// Can this be done better?
  pathActionsMethod.fixEnd(elem);break;}}}},// Can't seem to use `@borrows` here, so using `@see`
  /**
        * Convert a path to one with only absolute or relative values.
        * @function module:path.pathActions.convertPath
        * @see module:path.convertPath
        */convertPath:convertPath$1});}();// end pathActions
  /**
   * Path functionality.
   * @module path
   * @license MIT
   *
   * @copyright 2011 Alexis Deveria, 2011 Jeff Schiller
   */const segData={2:['x','y'],// PATHSEG_MOVETO_ABS
  4:['x','y'],// PATHSEG_LINETO_ABS
  6:['x','y','x1','y1','x2','y2'],// PATHSEG_CURVETO_CUBIC_ABS
  8:['x','y','x1','y1'],// PATHSEG_CURVETO_QUADRATIC_ABS
  10:['x','y','r1','r2','angle','largeArcFlag','sweepFlag'],// PATHSEG_ARC_ABS
  12:['x'],// PATHSEG_LINETO_HORIZONTAL_ABS
  14:['y'],// PATHSEG_LINETO_VERTICAL_ABS
  16:['x','y','x2','y2'],// PATHSEG_CURVETO_CUBIC_SMOOTH_ABS
  18:['x','y']// PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS
  };let svgCanvas$f;/**
   * @tutorial LocaleDocs
   * @typedef {module:locale.LocaleStrings|PlainObject} module:path.uiStrings
   * @property {PlainObject<string, string>} ui
  */const uiStrings={};/**
  * @function module:path.setUiStrings
  * @param {module:path.uiStrings} strs
  * @returns {void}
  */const setUiStrings=strs=>{Object.assign(uiStrings,strs.ui);};let pathFuncs=[];let linkControlPts=true;// Stores references to paths via IDs.
  // TODO: Make this cross-document happy.
  let pathData={};/**
  * @function module:path.setLinkControlPoints
  * @param {boolean} lcp
  * @returns {void}
  */const setLinkControlPoints=lcp=>{linkControlPts=lcp;};/**
   * @name module:path.path
   * @type {null|module:path.Path}
   * @memberof module:path
  */let path=null;/**
  * @external MouseEvent
  */ /**
  * Object with the following keys/values.
  * @typedef {PlainObject} module:path.SVGElementJSON
  * @property {string} element - Tag name of the SVG element to create
  * @property {PlainObject<string, string>} attr - Has key-value attributes to assign to the new element.
  *   An `id` should be set so that {@link module:utilities.EditorContext#addSVGElementsFromJson} can later re-identify the element for modification or replacement.
  * @property {boolean} [curStyles=false] - Indicates whether current style attributes should be applied first
  * @property {module:path.SVGElementJSON[]} [children] - Data objects to be added recursively as children
  * @property {string} [namespace="http://www.w3.org/2000/svg"] - Indicate a (non-SVG) namespace
  */ /**
   * @interface module:path.EditorContext
   * @property {module:select.SelectorManager} selectorManager
   * @property {module:svgcanvas.SvgCanvas} canvas
   */ /**
   * @function module:path.EditorContext#call
   * @param {"selected"|"changed"} ev - String with the event name
   * @param {module:svgcanvas.SvgCanvas#event:selected|module:svgcanvas.SvgCanvas#event:changed} arg - Argument to pass through to the callback function.
   *  If the event is "changed", an array of `Element`s is passed; if "selected", a single-item array of `Element` is passed.
   * @returns {void}
   */ /**
   * Note: This doesn't round to an integer necessarily.
   * @function module:path.EditorContext#round
   * @param {Float} val
   * @returns {Float} Rounded value to nearest value based on `zoom`
   */ /**
   * @function module:path.EditorContext#clearSelection
   * @param {boolean} [noCall] - When `true`, does not call the "selected" handler
   * @returns {void}
  */ /**
   * @function module:path.EditorContext#addToSelection
   * @param {Element[]} elemsToAdd - An array of DOM elements to add to the selection
   * @param {boolean} showGrips - Indicates whether the resize grips should be shown
   * @returns {void}
  */ /**
   * @function module:path.EditorContext#addCommandToHistory
   * @param {Command} cmd
   * @returns {void}
   */ /**
   * @function module:path.EditorContext#remapElement
   * @param {Element} selected - DOM element to be changed
   * @param {PlainObject<string, string>} changes - Object with changes to be remapped
   * @param {SVGMatrix} m - Matrix object to use for remapping coordinates
   * @returns {void}
   */ /**
   * @function module:path.EditorContext#addSVGElementsFromJson
   * @param {module:path.SVGElementJSON} data
   * @returns {Element} The new element
  */ /**
   * @function module:path.EditorContext#getGridSnapping
   * @returns {boolean}
   */ /**
   * @function module:path.EditorContext#getOpacity
   * @returns {Float}
   */ /**
   * @function module:path.EditorContext#getSelectedElements
   * @returns {Element[]} the array with selected DOM elements
  */ /**
   * @function module:path.EditorContext#getContainer
   * @returns {Element}
   */ /**
   * @function module:path.EditorContext#setStarted
   * @param {boolean} s
   * @returns {void}
   */ /**
   * @function module:path.EditorContext#getRubberBox
   * @returns {SVGRectElement}
  */ /**
   * @function module:path.EditorContext#setRubberBox
   * @param {SVGRectElement} rb
   * @returns {SVGRectElement} Same as parameter passed in
   */ /**
   * @function module:path.EditorContext#addPtsToSelection
   * @param {PlainObject} cfg
   * @param {boolean} cfg.closedSubpath
   * @param {SVGCircleElement[]} cfg.grips
   * @returns {void}
   */ /**
   * @function module:path.EditorContext#endChanges
   * @param {PlainObject} cfg
   * @param {string} cfg.cmd
   * @param {Element} cfg.elem
   * @returns {void}
  */ /**
   * @function module:path.EditorContext#getZoom
   * @returns {Float} The current zoom level
   */ /**
   * Returns the last created DOM element ID string.
   * @function module:path.EditorContext#getId
   * @returns {string}
   */ /**
   * Creates and returns a unique ID string for a DOM element.
   * @function module:path.EditorContext#getNextId
   * @returns {string}
  */ /**
   * Gets the desired element from a mouse event.
   * @function module:path.EditorContext#getMouseTarget
   * @param {external:MouseEvent} evt - Event object from the mouse event
   * @returns {Element} DOM element we want
   */ /**
   * @function module:path.EditorContext#getCurrentMode
   * @returns {string}
   */ /**
   * @function module:path.EditorContext#setCurrentMode
   * @param {string} cm The mode
   * @returns {string} The same mode as passed in
  */ /**
   * @function module:path.EditorContext#setDrawnPath
   * @param {SVGPathElement|null} dp
   * @returns {SVGPathElement|null} The same value as passed in
   */ /**
   * @function module:path.EditorContext#getSvgRoot
   * @returns {SVGSVGElement}
  */ /**
  * @function module:path.init
  * @param {module:path.EditorContext} editorContext
  * @returns {void}
  */const init$g=canvas=>{svgCanvas$f=canvas;svgCanvas$f.replacePathSeg=replacePathSegMethod;svgCanvas$f.addPointGrip=addPointGripMethod;svgCanvas$f.removePath_=removePath_;svgCanvas$f.getPath_=getPath_;svgCanvas$f.addCtrlGrip=addCtrlGripMethod;svgCanvas$f.getCtrlLine=getCtrlLineMethod;svgCanvas$f.getGripPt=getGripPt;svgCanvas$f.getPointFromGrip=getPointFromGripMethod;svgCanvas$f.setLinkControlPoints=setLinkControlPoints;svgCanvas$f.reorientGrads=reorientGrads;svgCanvas$f.getSegData=()=>{return segData;};svgCanvas$f.getUIStrings=()=>{return uiStrings;};svgCanvas$f.getPathObj=()=>{return path;};svgCanvas$f.setPathObj=obj=>{path=obj;};svgCanvas$f.getPathFuncs=()=>{return pathFuncs;};svgCanvas$f.getLinkControlPts=()=>{return linkControlPts;};pathFuncs=[0,'ClosePath'];const pathFuncsStrs=['Moveto','Lineto','CurvetoCubic','CurvetoQuadratic','Arc','LinetoHorizontal','LinetoVertical','CurvetoCubicSmooth','CurvetoQuadraticSmooth'];pathFuncsStrs.forEach(s=>{pathFuncs.push(s+'Abs');pathFuncs.push(s+'Rel');});init$h(svgCanvas$f);init$i(svgCanvas$f);};/* eslint-disable max-len */ /**
  * @function module:path.ptObjToArr
  * @todo See if this should just live in `replacePathSeg`
  * @param {string} type
  * @param {SVGPathSegMovetoAbs|SVGPathSegLinetoAbs|SVGPathSegCurvetoCubicAbs|SVGPathSegCurvetoQuadraticAbs|SVGPathSegArcAbs|SVGPathSegLinetoHorizontalAbs|SVGPathSegLinetoVerticalAbs|SVGPathSegCurvetoCubicSmoothAbs|SVGPathSegCurvetoQuadraticSmoothAbs} segItem
  * @returns {ArgumentsArray}
  */ /* eslint-enable max-len */const ptObjToArr=ptObjToArrMethod;/**
  * @function module:path.getGripPt
  * @param {Segment} seg
  * @param {module:math.XYObject} altPt
  * @returns {module:math.XYObject}
  */const getGripPt=getGripPtMethod;/**
  * @function module:path.getPointFromGrip
  * @param {module:math.XYObject} pt
  * @param {module:path.Path} pth
  * @returns {module:math.XYObject}
  */const getPointFromGrip=getPointFromGripMethod;/**
  * Requires prior call to `setUiStrings` if `xlink:title`
  *    to be set on the grip.
  * @function module:path.addPointGrip
  * @param {Integer} index
  * @param {Integer} x
  * @param {Integer} y
  * @returns {SVGCircleElement}
  */const addPointGrip=addPointGripMethod;/**
  * @function module:path.getGripContainer
  * @returns {Element}
  */const getGripContainer=getGripContainerMethod;/**
  * Requires prior call to `setUiStrings` if `xlink:title`
  *    to be set on the grip.
  * @function module:path.addCtrlGrip
  * @param {string} id
  * @returns {SVGCircleElement}
  */const addCtrlGrip=addCtrlGripMethod;/**
  * @function module:path.getCtrlLine
  * @param {string} id
  * @returns {SVGLineElement}
  */const getCtrlLine=getCtrlLineMethod;/**
  * @function module:path.getPointGrip
  * @param {Segment} seg
  * @param {boolean} update
  * @returns {SVGCircleElement}
  */const getPointGrip=getPointGripMethod;/**
  * @function module:path.getControlPoints
  * @param {Segment} seg
  * @returns {PlainObject<string, SVGLineElement|SVGCircleElement>}
  */const getControlPoints=getControlPointsMethod;/**
  * This replaces the segment at the given index. Type is given as number.
  * @function module:path.replacePathSeg
  * @param {Integer} type Possible values set during {@link module:path.init}
  * @param {Integer} index
  * @param {ArgumentsArray} pts
  * @param {SVGPathElement} elem
  * @returns {void}
  */const replacePathSeg=replacePathSegMethod;/**
  * @function module:path.getSegSelector
  * @param {Segment} seg
  * @param {boolean} update
  * @returns {SVGPathElement}
  */const getSegSelector=getSegSelectorMethod;/**
   * @typedef {PlainObject} Point
   * @property {Integer} x The x value
   * @property {Integer} y The y value
   */ /**
  * Takes three points and creates a smoother line based on them.
  * @function module:path.smoothControlPoints
  * @param {Point} ct1 - Object with x and y values (first control point)
  * @param {Point} ct2 - Object with x and y values (second control point)
  * @param {Point} pt - Object with x and y values (third point)
  * @returns {Point[]} Array of two "smoothed" point objects
  */const smoothControlPoints=(ct1,ct2,pt)=>{// each point must not be the origin
  const x1=ct1.x-pt.x;const y1=ct1.y-pt.y;const x2=ct2.x-pt.x;const y2=ct2.y-pt.y;if((x1!==0||y1!==0)&&(x2!==0||y2!==0)){const r1=Math.sqrt(x1*x1+y1*y1);const r2=Math.sqrt(x2*x2+y2*y2);const nct1=svgCanvas$f.getSvgRoot().createSVGPoint();const nct2=svgCanvas$f.getSvgRoot().createSVGPoint();let anglea=Math.atan2(y1,x1);let angleb=Math.atan2(y2,x2);if(anglea<0){anglea+=2*Math.PI;}if(angleb<0){angleb+=2*Math.PI;}const angleBetween=Math.abs(anglea-angleb);const angleDiff=Math.abs(Math.PI-angleBetween)/2;let newAnglea;let newAngleb;if(anglea-angleb>0){newAnglea=angleBetween<Math.PI?anglea+angleDiff:anglea-angleDiff;newAngleb=angleBetween<Math.PI?angleb-angleDiff:angleb+angleDiff;}else {newAnglea=angleBetween<Math.PI?anglea-angleDiff:anglea+angleDiff;newAngleb=angleBetween<Math.PI?angleb+angleDiff:angleb-angleDiff;}// rotate the points
  nct1.x=r1*Math.cos(newAnglea)+pt.x;nct1.y=r1*Math.sin(newAnglea)+pt.y;nct2.x=r2*Math.cos(newAngleb)+pt.x;nct2.y=r2*Math.sin(newAngleb)+pt.y;return [nct1,nct2];}return undefined;};/**
  * @function module:path.getPath_
  * @param {SVGPathElement} elem
  * @returns {module:path.Path}
  */const getPath_=elem=>{let p=pathData[elem.id];if(!p){p=pathData[elem.id]=new Path$1(elem);}return p;};/**
  * @function module:path.removePath_
  * @param {string} id
  * @returns {void}
  */const removePath_=id=>{if(id in pathData){delete pathData[id];}};let newcx;let newcy;let oldcx;let oldcy;let angle;const getRotVals=(x,y)=>{let dx=x-oldcx;let dy=y-oldcy;// rotate the point around the old center
  let r=Math.sqrt(dx*dx+dy*dy);let theta=Math.atan2(dy,dx)+angle;dx=r*Math.cos(theta)+oldcx;dy=r*Math.sin(theta)+oldcy;// dx,dy should now hold the actual coordinates of each
  // point after being rotated
  // now we want to rotate them around the new center in the reverse direction
  dx-=newcx;dy-=newcy;r=Math.sqrt(dx*dx+dy*dy);theta=Math.atan2(dy,dx)-angle;return {x:r*Math.cos(theta)+newcx,y:r*Math.sin(theta)+newcy};};// If the path was rotated, we must now pay the piper:
  // Every path point must be rotated into the rotated coordinate system of
  // its old center, then determine the new center, then rotate it back
  // This is because we want the path to remember its rotation
  /**
  * @function module:path.recalcRotatedPath
  * @todo This is still using ye olde transform methods, can probably
  * be optimized or even taken care of by `recalculateDimensions`
  * @returns {void}
  */const recalcRotatedPath=()=>{const currentPath=path.elem;angle=getRotationAngle(currentPath,true);if(!angle){return;}// selectedBBoxes[0] = path.oldbbox;
  const oldbox=path.oldbbox;// selectedBBoxes[0],
  oldcx=oldbox.x+oldbox.width/2;oldcy=oldbox.y+oldbox.height/2;const box=getBBox(currentPath);newcx=box.x+box.width/2;newcy=box.y+box.height/2;// un-rotate the new center to the proper position
  const dx=newcx-oldcx;const dy=newcy-oldcy;const r=Math.sqrt(dx*dx+dy*dy);const theta=Math.atan2(dy,dx)+angle;newcx=r*Math.cos(theta)+oldcx;newcy=r*Math.sin(theta)+oldcy;const list=currentPath.pathSegList;let i=list.numberOfItems;while(i){i-=1;const seg=list.getItem(i);const type=seg.pathSegType;if(type===1){continue;}const rvals=getRotVals(seg.x,seg.y);const points=[rvals.x,rvals.y];if(seg.x1&&seg.x2){const cVals1=getRotVals(seg.x1,seg.y1);const cVals2=getRotVals(seg.x2,seg.y2);points.splice(points.length,0,cVals1.x,cVals1.y,cVals2.x,cVals2.y);}replacePathSeg(type,i,points);}// loop for each point
  /* box = */getBBox(currentPath);// selectedBBoxes[0].x = box.x; selectedBBoxes[0].y = box.y;
  // selectedBBoxes[0].width = box.width; selectedBBoxes[0].height = box.height;
  // now we must set the new transform to be rotated around the new center
  const Rnc=svgCanvas$f.getSvgRoot().createSVGTransform();const tlist=currentPath.transform.baseVal;Rnc.setRotate(angle*180.0/Math.PI,newcx,newcy);tlist.replaceItem(Rnc,0);};// ====================================
  // Public API starts here
  /**
  * @function module:path.clearData
  * @returns {void}
  */const clearData=()=>{pathData={};};// Making public for mocking
  /**
  * @function module:path.reorientGrads
  * @param {Element} elem
  * @param {SVGMatrix} m
  * @returns {void}
  */const reorientGrads=(elem,m)=>{const bb=getBBox(elem);for(let i=0;i<2;i++){const type=i===0?'fill':'stroke';const attrVal=elem.getAttribute(type);if(attrVal&&attrVal.startsWith('url(')){const grad=getRefElem(attrVal);if(grad.tagName==='linearGradient'){let x1=grad.getAttribute('x1')||0;let y1=grad.getAttribute('y1')||0;let x2=grad.getAttribute('x2')||1;let y2=grad.getAttribute('y2')||0;// Convert to USOU points
  x1=bb.width*x1+bb.x;y1=bb.height*y1+bb.y;x2=bb.width*x2+bb.x;y2=bb.height*y2+bb.y;// Transform those points
  const pt1=transformPoint(x1,y1,m);const pt2=transformPoint(x2,y2,m);// Convert back to BB points
  const gCoords={x1:(pt1.x-bb.x)/bb.width,y1:(pt1.y-bb.y)/bb.height,x2:(pt2.x-bb.x)/bb.width,y2:(pt2.y-bb.y)/bb.height};const newgrad=grad.cloneNode(true);for(const[key,value]of Object.entries(gCoords)){newgrad.setAttribute(key,value);}newgrad.id=svgCanvas$f.getNextId();findDefs().append(newgrad);elem.setAttribute(type,'url(#'+newgrad.id+')');}}}};/**
  * This is how we map paths to our preferred relative segment types.
  * @name module:path.pathMap
  * @type {GenericArray}
  */const pathMap$1=[0,'z','M','m','L','l','C','c','Q','q','A','a','H','h','V','v','S','s','T','t'];/**
   * Convert a path to one with only absolute or relative values.
   * @todo move to pathActions.js
   * @function module:path.convertPath
   * @param {SVGPathElement} pth - the path to convert
   * @param {boolean} toRel - true of convert to relative
   * @returns {string}
   */const convertPath=(pth,toRel)=>{const{pathSegList}=pth;const len=pathSegList.numberOfItems;let curx=0;let cury=0;let d='';let lastM=null;for(let i=0;i<len;++i){const seg=pathSegList.getItem(i);// if these properties are not in the segment, set them to zero
  let x=seg.x||0;let y=seg.y||0;let x1=seg.x1||0;let y1=seg.y1||0;let x2=seg.x2||0;let y2=seg.y2||0;const type=seg.pathSegType;let letter=pathMap$1[type][toRel?'toLowerCase':'toUpperCase']();switch(type){case 1:// z,Z closepath (Z/z)
  d+='z';if(lastM&&!toRel){curx=lastM[0];cury=lastM[1];}break;case 12:// absolute horizontal line (H)
  x-=curx;// Fallthrough
  case 13:// relative horizontal line (h)
  if(toRel){y=0;curx+=x;letter='l';}else {y=cury;x+=curx;curx=x;letter='L';}// Convert to "line" for easier editing
  d+=pathDSegment(letter,[[x,y]]);break;case 14:// absolute vertical line (V)
  y-=cury;// Fallthrough
  case 15:// relative vertical line (v)
  if(toRel){x=0;cury+=y;letter='l';}else {x=curx;y+=cury;cury=y;letter='L';}// Convert to "line" for easier editing
  d+=pathDSegment(letter,[[x,y]]);break;case 2:// absolute move (M)
  case 4:// absolute line (L)
  case 18:// absolute smooth quad (T)
  case 10:// absolute elliptical arc (A)
  x-=curx;y-=cury;// Fallthrough
  case 5:// relative line (l)
  case 3:// relative move (m)
  case 19:// relative smooth quad (t)
  if(toRel){curx+=x;cury+=y;}else {x+=curx;y+=cury;curx=x;cury=y;}if(type===2||type===3){lastM=[curx,cury];}d+=pathDSegment(letter,[[x,y]]);break;case 6:// absolute cubic (C)
  x-=curx;x1-=curx;x2-=curx;y-=cury;y1-=cury;y2-=cury;// Fallthrough
  case 7:// relative cubic (c)
  if(toRel){curx+=x;cury+=y;}else {x+=curx;x1+=curx;x2+=curx;y+=cury;y1+=cury;y2+=cury;curx=x;cury=y;}d+=pathDSegment(letter,[[x1,y1],[x2,y2],[x,y]]);break;case 8:// absolute quad (Q)
  x-=curx;x1-=curx;y-=cury;y1-=cury;// Fallthrough
  case 9:// relative quad (q)
  if(toRel){curx+=x;cury+=y;}else {x+=curx;x1+=curx;y+=cury;y1+=cury;curx=x;cury=y;}d+=pathDSegment(letter,[[x1,y1],[x,y]]);break;// Fallthrough
  case 11:// relative elliptical arc (a)
  if(toRel){curx+=x;cury+=y;}else {x+=curx;y+=cury;curx=x;cury=y;}d+=pathDSegment(letter,[[seg.r1,seg.r2]],[seg.angle,seg.largeArcFlag?1:0,seg.sweepFlag?1:0],[x,y]);break;case 16:// absolute smooth cubic (S)
  x-=curx;x2-=curx;y-=cury;y2-=cury;// Fallthrough
  case 17:// relative smooth cubic (s)
  if(toRel){curx+=x;cury+=y;}else {x+=curx;x2+=curx;y+=cury;y2+=cury;curx=x;cury=y;}d+=pathDSegment(letter,[[x2,y2],[x,y]]);break;}// switch on path segment type
  }// for each segment
  return d;};/**
   * TODO: refactor callers in `convertPath` to use `getPathDFromSegments` instead of this function.
   * Legacy code refactored from `svgcanvas.pathActions.convertPath`.
   * @param {string} letter - path segment command (letter in potentially either case from {@link module:path.pathMap}; see [SVGPathSeg#pathSegTypeAsLetter]{@link https://www.w3.org/TR/SVG/single-page.html#paths-__svg__SVGPathSeg__pathSegTypeAsLetter})
   * @param {GenericArray<GenericArray<Integer>>} points - x,y points
   * @param {GenericArray<GenericArray<Integer>>} [morePoints] - x,y points
   * @param {Integer[]} [lastPoint] - x,y point
   * @returns {string}
   */const pathDSegment=(letter,points,morePoints,lastPoint)=>{points.forEach((pnt,i)=>{points[i]=shortFloat(pnt);});let segment=letter+points.join(' ');if(morePoints){segment+=' '+morePoints.join(' ');}if(lastPoint){segment+=' '+shortFloat(lastPoint);}return segment;};/**
  * Group: Path edit functions.
  * Functions relating to editing path elements.
  */const pathActions=pathActionsMethod;// end pathActions
  var pathModule=/*#__PURE__*/Object.freeze({__proto__:null,setUiStrings:setUiStrings,setLinkControlPoints:setLinkControlPoints,get path(){return path;},init:init$g,ptObjToArr:ptObjToArr,getGripPt:getGripPt,getPointFromGrip:getPointFromGrip,addPointGrip:addPointGrip,getGripContainer:getGripContainer,addCtrlGrip:addCtrlGrip,getCtrlLine:getCtrlLine,getPointGrip:getPointGrip,getControlPoints:getControlPoints,replacePathSeg:replacePathSeg,getSegSelector:getSegSelector,smoothControlPoints:smoothControlPoints,getPath_:getPath_,removePath_:removePath_,recalcRotatedPath:recalcRotatedPath,clearData:clearData,reorientGrads:reorientGrads,convertPath:convertPath,pathActions:pathActions});/**
   * Provides tools for the layer concept.
   * @module layer
   * @license MIT
   *
   * @copyright 2011 Jeff Schiller, 2016 Flint O'Brien
   */ /**
   * This class encapsulates the concept of a layer in the drawing. It can be constructed with
   * an existing group element or, with three parameters, will create a new layer group element.
   *
   * @example
   * const l1 = new Layer('name', group); // Use the existing group for this layer.
   * const l2 = new Layer('name', group, svgElem); // Create a new group and add it to the DOM after group.
   * const l3 = new Layer('name', null, svgElem); // Create a new group and add it to the DOM as the last layer.
   * @memberof module:layer
   */class Layer{/**
    * @param {string} name - Layer name
    * @param {SVGGElement|null} group - An existing SVG group element or null.
    *     If group and no svgElem, use group for this layer.
    *     If group and svgElem, create a new group element and insert it in the DOM after group.
    *     If no group and svgElem, create a new group element and insert it in the DOM as the last layer.
    * @param {SVGGElement} [svgElem] - The SVG DOM element. If defined, use this to add
    *     a new layer to the document.
    */constructor(name,group,svgElem){this.name_=name;this.group_=svgElem?null:group;if(svgElem){// Create a group element with title and add it to the DOM.
  const svgdoc=svgElem.ownerDocument;this.group_=svgdoc.createElementNS(NS.SVG,'g');const layerTitle=svgdoc.createElementNS(NS.SVG,'title');layerTitle.textContent=name;this.group_.append(layerTitle);if(group){group.insertAdjacentElement('afterend',this.group_);}else {svgElem.append(this.group_);}}addLayerClass(this.group_);walkTree(this.group_,function(e){e.setAttribute('style','pointer-events:inherit');});this.group_.setAttribute('style',svgElem?'pointer-events:all':'pointer-events:none');}/**
     * Get the layer's name.
     * @returns {string} The layer name
     */getName(){return this.name_;}/**
     * Get the group element for this layer.
     * @returns {SVGGElement} The layer SVG group
     */getGroup(){return this.group_;}/**
     * Active this layer so it takes pointer events.
     * @returns {void}
     */activate(){this.group_.setAttribute('style','pointer-events:all');}/**
     * Deactive this layer so it does NOT take pointer events.
     * @returns {void}
     */deactivate(){this.group_.setAttribute('style','pointer-events:none');}/**
     * Set this layer visible or hidden based on 'visible' parameter.
     * @param {boolean} visible - If true, make visible; otherwise, hide it.
     * @returns {void}
     */setVisible(visible){const expected=visible===undefined||visible?'inline':'none';const oldDisplay=this.group_.getAttribute('display');if(oldDisplay!==expected){this.group_.setAttribute('display',expected);}}/**
     * Is this layer visible?
     * @returns {boolean} True if visible.
     */isVisible(){return this.group_.getAttribute('display')!=='none';}/**
     * Get layer opacity.
     * @returns {Float} Opacity value.
     */getOpacity(){const opacity=this.group_.getAttribute('opacity');if(!opacity){return 1;}return Number.parseFloat(opacity);}/**
     * Sets the opacity of this layer. If opacity is not a value between 0.0 and 1.0,
     * nothing happens.
     * @param {Float} opacity - A float value in the range 0.0-1.0
     * @returns {void}
     */setOpacity(opacity){if(typeof opacity==='number'&&opacity>=0.0&&opacity<=1.0){this.group_.setAttribute('opacity',opacity);}}/**
     * Append children to this layer.
     * @param {SVGGElement} children - The children to append to this layer.
     * @returns {void}
     */appendChildren(children){for(const child of children){this.group_.append(child);}}/**
    * @returns {SVGTitleElement|null}
    */getTitleElement(){const len=this.group_.childNodes.length;for(let i=0;i<len;++i){const child=this.group_.childNodes.item(i);if((child===null||child===void 0?void 0:child.tagName)==='title'){return child;}}return null;}/**
     * Set the name of this layer.
     * @param {string} name - The new name.
     * @param {module:history.HistoryRecordingService} hrService - History recording service
     * @returns {string|null} The new name if changed; otherwise, null.
     */setName(name,hrService){const previousName=this.name_;name=toXml(name);// now change the underlying title element contents
  const title=this.getTitleElement();if(title){while(title.firstChild){title.removeChild(title.firstChild);}title.textContent=name;this.name_=name;if(hrService){hrService.changeElement(title,{'#text':previousName});}return this.name_;}return null;}/**
     * Remove this layer's group from the DOM. No more functions on group can be called after this.
     * @returns {SVGGElement} The layer SVG group that was just removed.
     */removeGroup(){const group=this.group_;this.group_.remove();this.group_=undefined;return group;}/**
     * Test whether an element is a layer or not.
     * @param {SVGGElement} elem - The SVGGElement to test.
     * @returns {boolean} True if the element is a layer
     */static isLayer(elem){return elem&&elem.tagName==='g'&&Layer.CLASS_REGEX.test(elem.getAttribute('class'));}}/**
   * @property {string} CLASS_NAME - class attribute assigned to all layer groups.
   */Layer.CLASS_NAME='layer';/**
   * @property {RegExp} CLASS_REGEX - Used to test presence of class Layer.CLASS_NAME
   */Layer.CLASS_REGEX=new RegExp('(\\s|^)'+Layer.CLASS_NAME+'(\\s|$)');/**
   * Add class `Layer.CLASS_NAME` to the element (usually `class='layer'`).
   *
   * @param {SVGGElement} elem - The SVG element to update
   * @returns {void}
   */function addLayerClass(elem){const classes=elem.getAttribute('class');if(!classes||!classes.length){elem.setAttribute('class',Layer.CLASS_NAME);}else if(!Layer.CLASS_REGEX.test(classes)){elem.setAttribute('class',classes+' '+Layer.CLASS_NAME);}}/**
   * HistoryRecordingService component of history.
   * @module history
   * @license MIT
   * @copyright 2016 Flint O'Brien
   */ /**
   * History recording service.
   *
   * A self-contained service interface for recording history. Once injected, no other dependencies
   * or globals are required (example: UndoManager, command types, etc.). Easy to mock for unit tests.
   * Built on top of history classes in history.js.
   *
   * There is a simple start/end interface for batch commands.
   *
   * HistoryRecordingService.NO_HISTORY is a singleton that can be passed in to functions
   * that record history. This helps when the caller requires that no history be recorded.
   *
   * The following will record history: insert, batch, insert.
   * @example
   * hrService = new HistoryRecordingService(this.undoMgr);
   * hrService.insertElement(elem, text); // add simple command to history.
   * hrService.startBatchCommand('create two elements');
   * hrService.changeElement(elem, attrs, text); // add to batchCommand
   * hrService.changeElement(elem, attrs2, text); // add to batchCommand
   * hrService.endBatchCommand(); // add batch command with two change commands to history.
   * hrService.insertElement(elem, text); // add simple command to history.
   *
   * @example
   * // Note that all functions return this, so commands can be chained, like so:
   * hrService
   *   .startBatchCommand('create two elements')
   *   .insertElement(elem, text)
   *   .changeElement(elem, attrs, text)
   *   .endBatchCommand();
   *
   * @memberof module:history
   */class HistoryRecordingService{/**
    * @param {history.UndoManager|null} undoManager - The undo manager.
    *     A value of `null` is valid for cases where no history recording is required.
    *     See singleton: {@link module:history.HistoryRecordingService.HistoryRecordingService.NO_HISTORY}
    */constructor(undoManager){this.undoManager_=undoManager;this.currentBatchCommand_=null;this.batchCommandStack_=[];}/**
     * Start a batch command so multiple commands can recorded as a single history command.
     * Requires a corresponding call to endBatchCommand. Start and end commands can be nested.
     *
     * @param {string} text - Optional string describing the batch command.
     * @returns {module:history.HistoryRecordingService}
     */startBatchCommand(text){if(!this.undoManager_){return this;}this.currentBatchCommand_=new BatchCommand$4(text);this.batchCommandStack_.push(this.currentBatchCommand_);return this;}/**
     * End a batch command and add it to the history or a parent batch command.
     * @returns {module:history.HistoryRecordingService}
     */endBatchCommand(){if(!this.undoManager_){return this;}if(this.currentBatchCommand_){const batchCommand=this.currentBatchCommand_;this.batchCommandStack_.pop();const{length:len}=this.batchCommandStack_;this.currentBatchCommand_=len?this.batchCommandStack_[len-1]:null;this.addCommand_(batchCommand);}return this;}/**
     * Add a `MoveElementCommand` to the history or current batch command.
     * @param {Element} elem - The DOM element that was moved
     * @param {Element} oldNextSibling - The element's next sibling before it was moved
     * @param {Element} oldParent - The element's parent before it was moved
     * @param {string} [text] - An optional string visible to user related to this change
     * @returns {module:history.HistoryRecordingService}
     */moveElement(elem,oldNextSibling,oldParent,text){if(!this.undoManager_){return this;}this.addCommand_(new MoveElementCommand$1(elem,oldNextSibling,oldParent,text));return this;}/**
     * Add an `InsertElementCommand` to the history or current batch command.
     * @param {Element} elem - The DOM element that was added
     * @param {string} [text] - An optional string visible to user related to this change
     * @returns {module:history.HistoryRecordingService}
     */insertElement(elem,text){if(!this.undoManager_){return this;}this.addCommand_(new InsertElementCommand$4(elem,text));return this;}/**
     * Add a `RemoveElementCommand` to the history or current batch command.
     * @param {Element} elem - The DOM element that was removed
     * @param {Element} oldNextSibling - The element's next sibling before it was removed
     * @param {Element} oldParent - The element's parent before it was removed
     * @param {string} [text] - An optional string visible to user related to this change
     * @returns {module:history.HistoryRecordingService}
     */removeElement(elem,oldNextSibling,oldParent,text){if(!this.undoManager_){return this;}this.addCommand_(new RemoveElementCommand$2(elem,oldNextSibling,oldParent,text));return this;}/**
     * Add a `ChangeElementCommand` to the history or current batch command.
     * @param {Element} elem - The DOM element that was changed
     * @param {module:history.CommandAttributes} attrs - An object with the attributes to be changed and the values they had *before* the change
     * @param {string} [text] - An optional string visible to user related to this change
     * @returns {module:history.HistoryRecordingService}
     */changeElement(elem,attrs,text){if(!this.undoManager_){return this;}this.addCommand_(new ChangeElementCommand$2(elem,attrs,text));return this;}/**
     * Private function to add a command to the history or current batch command.
     * @private
     * @param {Command} cmd
     * @returns {module:history.HistoryRecordingService|void}
     */addCommand_(cmd){if(!this.undoManager_){return this;}if(this.currentBatchCommand_){this.currentBatchCommand_.addSubCommand(cmd);}else {this.undoManager_.addCommandToHistory(cmd);}return undefined;}}/**
   * @memberof module:history.HistoryRecordingService
   * @property {module:history.HistoryRecordingService} NO_HISTORY - Singleton that can be passed to functions that record history, but the caller requires that no history be recorded.
   */HistoryRecordingService.NO_HISTORY=new HistoryRecordingService();/**
   * Create a clone of an element, updating its ID and its children's IDs when needed.
   * @function module:utilities.copyElem
   * @param {Element} el - DOM element to clone
   * @param {module:utilities.GetNextID} getNextId - The getter of the next unique ID.
   * @returns {Element} The cloned element
   */const copyElem=function(el,getNextId){// manually create a copy of the element
  const newEl=document.createElementNS(el.namespaceURI,el.nodeName);Object.values(el.attributes).forEach(attr=>{newEl.setAttributeNS(attr.namespaceURI,attr.nodeName,attr.value);});// set the copied element's new id
  newEl.removeAttribute('id');newEl.id=getNextId();// now create copies of all children
  el.childNodes.forEach(function(child){switch(child.nodeType){case 1:// element node
  newEl.append(copyElem(child,getNextId));break;case 3:// text node
  newEl.textContent=child.nodeValue;break;}});if(el.dataset.gsvg){newEl.dataset.gsvg=newEl.firstChild;}else if(el.dataset.symbol){const ref=el.dataset.symbol;newEl.dataset.ref=ref;newEl.dataset.symbol=ref;}else if(newEl.tagName==='image'){preventClickDefault(newEl);}return newEl;};/**
   * Tools for drawing.
   * @module draw
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */const visElems$1='a,circle,ellipse,foreignObject,g,image,line,path,polygon,polyline,rect,svg,text,tspan,use'.split(',');const RandomizeModes={LET_DOCUMENT_DECIDE:0,ALWAYS_RANDOMIZE:1,NEVER_RANDOMIZE:2};let randIds=RandomizeModes.LET_DOCUMENT_DECIDE;// Array with current disabled elements (for in-group editing)
  let disabledElems=[];/**
   * Get a HistoryRecordingService.
   * @param {module:history.HistoryRecordingService} [hrService] - if exists, return it instead of creating a new service.
   * @returns {module:history.HistoryRecordingService}
   */function historyRecordingService(hrService){return hrService||new HistoryRecordingService(svgCanvas$e.undoMgr);}/**
   * Find the layer name in a group element.
   * @param {Element} group The group element to search in.
   * @returns {string} The layer name or empty string.
   */function findLayerNameInGroup(group){const sel=group.querySelector('title');return sel?sel.textContent:'';}/**
   * Given a set of names, return a new unique name.
   * @param {string[]} existingLayerNames - Existing layer names.
   * @returns {string} - The new name.
   */function getNewLayerName(existingLayerNames){let i=1;// TODO(codedread): What about internationalization of "Layer"?
  while(existingLayerNames.includes('Layer '+i)){i++;}return 'Layer '+i;}/**
   * This class encapsulates the concept of a SVG-edit drawing.
   */class Drawing{/**
    * @param {SVGSVGElement} svgElem - The SVG DOM Element that this JS object
    *     encapsulates.  If the svgElem has a se:nonce attribute on it, then
    *     IDs will use the nonce as they are generated.
    * @param {string} [optIdPrefix=svg_] - The ID prefix to use.
    * @throws {Error} If not initialized with an SVG element
    */constructor(svgElem,optIdPrefix){if(!svgElem||!svgElem.tagName||!svgElem.namespaceURI||svgElem.tagName!=='svg'||svgElem.namespaceURI!==NS.SVG){throw new Error('Error: svgedit.draw.Drawing instance initialized without a <svg> element');}/**
      * The SVG DOM Element that represents this drawing.
      * @type {SVGSVGElement}
      */this.svgElem_=svgElem;/**
      * The latest object number used in this drawing.
      * @type {Integer}
      */this.obj_num=0;/**
      * The prefix to prepend to each element id in the drawing.
      * @type {string}
      */this.idPrefix=optIdPrefix||'svg_';/**
      * An array of released element ids to immediately reuse.
      * @type {Integer[]}
      */this.releasedNums=[];/**
      * The z-ordered array of Layer objects. Each layer has a name
      * and group element.
      * The first layer is the one at the bottom of the rendering.
      * @type {Layer[]}
      */this.all_layers=[];/**
      * Map of all_layers by name.
      *
      * Note: Layers are ordered, but referenced externally by name; so, we need both container
      * types depending on which function is called (i.e. all_layers and layer_map).
      *
      * @type {PlainObject<string, Layer>}
      */this.layer_map={};/**
      * The current layer being used.
      * @type {Layer}
      */this.current_layer=null;/**
      * The nonce to use to uniquely identify elements across drawings.
      * @type {!string}
      */this.nonce_='';const n=this.svgElem_.getAttributeNS(NS.SE,'nonce');// If already set in the DOM, use the nonce throughout the document
  // else, if randomizeIds(true) has been called, create and set the nonce.
  if(n&&randIds!==RandomizeModes.NEVER_RANDOMIZE){this.nonce_=n;}else if(randIds===RandomizeModes.ALWAYS_RANDOMIZE){this.setNonce(Math.floor(Math.random()*100001));}}/**
     * @param {string} id Element ID to retrieve
     * @returns {Element} SVG element within the root SVGSVGElement
    */getElem_(id){if(this.svgElem_.querySelector){// querySelector lookup
  return this.svgElem_.querySelector('#'+id);}// jQuery lookup: twice as slow as xpath in FF
  return this.svgElem_.querySelector('[id='+id+']');}/**
     * @returns {SVGSVGElement}
     */getSvgElem(){return this.svgElem_;}/**
     * @returns {!(string|Integer)} The previously set nonce
     */getNonce(){return this.nonce_;}/**
     * @param {!(string|Integer)} n The nonce to set
     * @returns {void}
     */setNonce(n){this.svgElem_.setAttributeNS(NS.XMLNS,'xmlns:se',NS.SE);this.svgElem_.setAttributeNS(NS.SE,'se:nonce',n);this.nonce_=n;}/**
     * Clears any previously set nonce.
     * @returns {void}
     */clearNonce(){// We deliberately leave any se:nonce attributes alone,
  // we just don't use it to randomize ids.
  this.nonce_='';}/**
     * Returns the latest object id as a string.
     * @returns {string} The latest object Id.
     */getId(){return this.nonce_?this.idPrefix+this.nonce_+'_'+this.obj_num:this.idPrefix+this.obj_num;}/**
     * Returns the next object Id as a string.
     * @returns {string} The next object Id to use.
     */getNextId(){const oldObjNum=this.obj_num;let restoreOldObjNum=false;// If there are any released numbers in the release stack,
  // use the last one instead of the next obj_num.
  // We need to temporarily use obj_num as that is what getId() depends on.
  if(this.releasedNums.length>0){this.obj_num=this.releasedNums.pop();restoreOldObjNum=true;}else {// If we are not using a released id, then increment the obj_num.
  this.obj_num++;}// Ensure the ID does not exist.
  let id=this.getId();while(this.getElem_(id)){if(restoreOldObjNum){this.obj_num=oldObjNum;restoreOldObjNum=false;}this.obj_num++;id=this.getId();}// Restore the old object number if required.
  if(restoreOldObjNum){this.obj_num=oldObjNum;}return id;}/**
     * Releases the object Id, letting it be used as the next id in getNextId().
     * This method DOES NOT remove any elements from the DOM, it is expected
     * that client code will do this.
     * @param {string} id - The id to release.
     * @returns {boolean} True if the id was valid to be released, false otherwise.
    */releaseId(id){// confirm if this is a valid id for this Document, else return false
  const front=this.idPrefix+(this.nonce_?this.nonce_+'_':'');if(typeof id!=='string'||!id.startsWith(front)){return false;}// extract the obj_num of this id
  const num=Number.parseInt(id.substr(front.length));// if we didn't get a positive number or we already released this number
  // then return false.
  if(typeof num!=='number'||num<=0||this.releasedNums.includes(num)){return false;}// push the released number into the released queue
  this.releasedNums.push(num);return true;}/**
     * Returns the number of layers in the current drawing.
     * @returns {Integer} The number of layers in the current drawing.
    */getNumLayers(){return this.all_layers.length;}/**
     * Check if layer with given name already exists.
     * @param {string} name - The layer name to check
     * @returns {boolean}
    */hasLayer(name){return this.layer_map[name]!==undefined;}/**
     * Returns the name of the ith layer. If the index is out of range, an empty string is returned.
     * @param {Integer} i - The zero-based index of the layer you are querying.
     * @returns {string} The name of the ith layer (or the empty string if none found)
    */getLayerName(i){return i>=0&&i<this.getNumLayers()?this.all_layers[i].getName():'';}/**
     * @returns {SVGGElement|null} The SVGGElement representing the current layer.
     */getCurrentLayer(){return this.current_layer?this.current_layer.getGroup():null;}/**
     * Get a layer by name.
     * @param {string} name
     * @returns {SVGGElement} The SVGGElement representing the named layer or null.
     */getLayerByName(name){const layer=this.layer_map[name];return layer?layer.getGroup():null;}/**
     * Returns the name of the currently selected layer. If an error occurs, an empty string
     * is returned.
     * @returns {string} The name of the currently active layer (or the empty string if none found).
    */getCurrentLayerName(){return this.current_layer?this.current_layer.getName():'';}/**
     * Set the current layer's name.
     * @param {string} name - The new name.
     * @param {module:history.HistoryRecordingService} hrService - History recording service
     * @returns {string|null} The new name if changed; otherwise, null.
     */setCurrentLayerName(name,hrService){let finalName=null;if(this.current_layer){const oldName=this.current_layer.getName();finalName=this.current_layer.setName(name,hrService);if(finalName){delete this.layer_map[oldName];this.layer_map[finalName]=this.current_layer;}}return finalName;}/**
     * Set the current layer's position.
     * @param {Integer} newpos - The zero-based index of the new position of the layer. Range should be 0 to layers-1
     * @returns {{title: SVGGElement, previousName: string}|null} If the name was changed, returns {title:SVGGElement, previousName:string}; otherwise null.
     */setCurrentLayerPosition(newpos){const layerCount=this.getNumLayers();if(!this.current_layer||newpos<0||newpos>=layerCount){return null;}const oldpos=this.indexCurrentLayer();if(oldpos===-1||oldpos===newpos){return null;}// if our new position is below us, we need to insert before the node after newpos
  const currentGroup=this.current_layer.getGroup();const oldNextSibling=currentGroup.nextSibling;let refGroup=null;if(newpos>oldpos){if(newpos<layerCount-1){refGroup=this.all_layers[newpos+1].getGroup();}// if our new position is above us, we need to insert before the node at newpos
  }else {refGroup=this.all_layers[newpos].getGroup();}this.svgElem_.insertBefore(currentGroup,refGroup);// Ok to replace with `refGroup.before(currentGroup);`?
  this.identifyLayers();this.setCurrentLayer(this.getLayerName(newpos));return {currentGroup,oldNextSibling};}/**
    * @param {module:history.HistoryRecordingService} hrService
    * @returns {void}
    */mergeLayer(hrService){const currentGroup=this.current_layer.getGroup();const prevGroup=currentGroup.previousElementSibling;if(!prevGroup){return;}hrService.startBatchCommand('Merge Layer');const layerNextSibling=currentGroup.nextSibling;hrService.removeElement(currentGroup,layerNextSibling,this.svgElem_);while(currentGroup.firstChild){const child=currentGroup.firstChild;if(child.localName==='title'){hrService.removeElement(child,child.nextSibling,currentGroup);child.remove();continue;}const oldNextSibling=child.nextSibling;prevGroup.append(child);hrService.moveElement(child,oldNextSibling,currentGroup);}// Remove current layer's group
  this.current_layer.removeGroup();// Remove the current layer and set the previous layer as the new current layer
  const index=this.indexCurrentLayer();if(index>0){const name=this.current_layer.getName();this.current_layer=this.all_layers[index-1];this.all_layers.splice(index,1);delete this.layer_map[name];}hrService.endBatchCommand();}/**
    * @param {module:history.HistoryRecordingService} hrService
    * @returns {void}
    */mergeAllLayers(hrService){// Set the current layer to the last layer.
  this.current_layer=this.all_layers[this.all_layers.length-1];hrService.startBatchCommand('Merge all Layers');while(this.all_layers.length>1){this.mergeLayer(hrService);}hrService.endBatchCommand();}/**
     * Sets the current layer. If the name is not a valid layer name, then this
     * function returns `false`. Otherwise it returns `true`. This is not an
     * undo-able action.
     * @param {string} name - The name of the layer you want to switch to.
     * @returns {boolean} `true` if the current layer was switched, otherwise `false`
     */setCurrentLayer(name){const layer=this.layer_map[name];if(layer){if(this.current_layer){this.current_layer.deactivate();}this.current_layer=layer;this.current_layer.activate();return true;}return false;}/**
     * Sets the current layer. If the name is not a valid layer name, then this
     * function returns `false`. Otherwise it returns `true`. This is not an
     * undo-able action.
     * @param {string} name - The name of the layer you want to switch to.
     * @returns {boolean} `true` if the current layer was switched, otherwise `false`
     */indexCurrentLayer(){return this.all_layers.indexOf(this.current_layer);}/**
     * Deletes the current layer from the drawing and then clears the selection.
     * This function then calls the 'changed' handler.  This is an undoable action.
     * @todo Does this actually call the 'changed' handler?
     * @returns {SVGGElement} The SVGGElement of the layer removed or null.
     */deleteCurrentLayer(){if(this.current_layer&&this.getNumLayers()>1){const oldLayerGroup=this.current_layer.removeGroup();this.identifyLayers();return oldLayerGroup;}return null;}/**
     * Updates layer system and sets the current layer to the
     * top-most layer (last `<g>` child of this drawing).
     * @returns {void}
    */identifyLayers(){this.all_layers=[];this.layer_map={};const numchildren=this.svgElem_.childNodes.length;// loop through all children of SVG element
  const orphans=[];const layernames=[];let layer=null;let childgroups=false;for(let i=0;i<numchildren;++i){const child=this.svgElem_.childNodes.item(i);// for each g, find its layer name
  if((child===null||child===void 0?void 0:child.nodeType)===1){if(child.tagName==='g'){childgroups=true;const name=findLayerNameInGroup(child);if(name){layernames.push(name);layer=new Layer(name,child);this.all_layers.push(layer);this.layer_map[name]=layer;}else {// if group did not have a name, it is an orphan
  orphans.push(child);}}else if(visElems$1.includes(child.nodeName)){// Child is "visible" (i.e. not a <title> or <defs> element), so it is an orphan
  orphans.push(child);}}}// If orphans or no layers found, create a new layer and add all the orphans to it
  if(orphans.length>0||!childgroups){layer=new Layer(getNewLayerName(layernames),null,this.svgElem_);layer.appendChildren(orphans);this.all_layers.push(layer);this.layer_map[name]=layer;}else {layer.activate();}this.current_layer=layer;}/**
     * Creates a new top-level layer in the drawing with the given name and
     * makes it the current layer.
     * @param {string} name - The given name. If the layer name exists, a new name will be generated.
     * @param {module:history.HistoryRecordingService} hrService - History recording service
     * @returns {SVGGElement} The SVGGElement of the new layer, which is
     *     also the current layer of this drawing.
    */createLayer(name,hrService){if(this.current_layer){this.current_layer.deactivate();}// Check for duplicate name.
  if(name===undefined||name===null||name===''||this.layer_map[name]){name=getNewLayerName(Object.keys(this.layer_map));}// Crate new layer and add to DOM as last layer
  const layer=new Layer(name,null,this.svgElem_);// Like to assume hrService exists, but this is backwards compatible with old version of createLayer.
  if(hrService){hrService.startBatchCommand('Create Layer');hrService.insertElement(layer.getGroup());hrService.endBatchCommand();}this.all_layers.push(layer);this.layer_map[name]=layer;this.current_layer=layer;return layer.getGroup();}/**
     * Creates a copy of the current layer with the given name and makes it the current layer.
     * @param {string} name - The given name. If the layer name exists, a new name will be generated.
     * @param {module:history.HistoryRecordingService} hrService - History recording service
     * @returns {SVGGElement} The SVGGElement of the new layer, which is
     *     also the current layer of this drawing.
    */cloneLayer(name,hrService){if(!this.current_layer){return null;}this.current_layer.deactivate();// Check for duplicate name.
  if(name===undefined||name===null||name===''||this.layer_map[name]){name=getNewLayerName(Object.keys(this.layer_map));}// Create new group and add to DOM just after current_layer
  const currentGroup=this.current_layer.getGroup();const layer=new Layer(name,currentGroup,this.svgElem_);const group=layer.getGroup();// Clone children
  const children=[...currentGroup.childNodes];children.forEach(child=>{if(child.localName==='title'){return;}group.append(this.copyElem(child));});if(hrService){hrService.startBatchCommand('Duplicate Layer');hrService.insertElement(group);hrService.endBatchCommand();}// Update layer containers and current_layer.
  const index=this.indexCurrentLayer();if(index>=0){this.all_layers.splice(index+1,0,layer);}else {this.all_layers.push(layer);}this.layer_map[name]=layer;this.current_layer=layer;return group;}/**
     * Returns whether the layer is visible.  If the layer name is not valid,
     * then this function returns `false`.
     * @param {string} layerName - The name of the layer which you want to query.
     * @returns {boolean} The visibility state of the layer, or `false` if the layer name was invalid.
    */getLayerVisibility(layerName){const layer=this.layer_map[layerName];return layer?layer.isVisible():false;}/**
     * Sets the visibility of the layer. If the layer name is not valid, this
     * function returns `null`, otherwise it returns the `SVGElement` representing
     * the layer. This is an undo-able action.
     * @param {string} layerName - The name of the layer to change the visibility
     * @param {boolean} bVisible - Whether the layer should be visible
     * @returns {?SVGGElement} The SVGGElement representing the layer if the
     *   `layerName` was valid, otherwise `null`.
    */setLayerVisibility(layerName,bVisible){if(typeof bVisible!=='boolean'){return null;}const layer=this.layer_map[layerName];if(!layer){return null;}layer.setVisible(bVisible);return layer.getGroup();}/**
     * Returns the opacity of the given layer.  If the input name is not a layer, `null` is returned.
     * @param {string} layerName - name of the layer on which to get the opacity
     * @returns {?Float} The opacity value of the given layer.  This will be a value between 0.0 and 1.0, or `null`
     * if `layerName` is not a valid layer
    */getLayerOpacity(layerName){const layer=this.layer_map[layerName];if(!layer){return null;}return layer.getOpacity();}/**
     * Sets the opacity of the given layer.  If the input name is not a layer,
     * nothing happens. If opacity is not a value between 0.0 and 1.0, then
     * nothing happens.
     * NOTE: this function exists solely to apply a highlighting/de-emphasis
     * effect to a layer. When it is possible for a user to affect the opacity
     * of a layer, we will need to allow this function to produce an undo-able
     * action.
     * @param {string} layerName - Name of the layer on which to set the opacity
     * @param {Float} opacity - A float value in the range 0.0-1.0
     * @returns {void}
    */setLayerOpacity(layerName,opacity){if(typeof opacity!=='number'||opacity<0.0||opacity>1.0){return;}const layer=this.layer_map[layerName];if(layer){layer.setOpacity(opacity);}}/**
     * Create a clone of an element, updating its ID and its children's IDs when needed.
     * @param {Element} el - DOM element to clone
     * @returns {Element}
     */copyElem(el){const that=this;const getNextIdClosure=function(){return that.getNextId();};return copyElem(el,getNextIdClosure);}}/**
   * Called to ensure that drawings will or will not have randomized ids.
   * The currentDrawing will have its nonce set if it doesn't already.
   * @function module:draw.randomizeIds
   * @param {boolean} enableRandomization - flag indicating if documents should have randomized ids
   * @param {draw.Drawing} currentDrawing
   * @returns {void}
   */const randomizeIds=function(enableRandomization,currentDrawing){randIds=enableRandomization===false?RandomizeModes.NEVER_RANDOMIZE:RandomizeModes.ALWAYS_RANDOMIZE;if(randIds===RandomizeModes.ALWAYS_RANDOMIZE&&!currentDrawing.getNonce()){currentDrawing.setNonce(Math.floor(Math.random()*100001));}else if(randIds===RandomizeModes.NEVER_RANDOMIZE&&currentDrawing.getNonce()){currentDrawing.clearNonce();}};// Layer API Functions
  /**
  * Group: Layers.
  */ /**
   * @see {@link https://api.jquery.com/jQuery.data/}
   * @name external:jQuery.data
   */ /**
   * @interface module:draw.DrawCanvasInit
   * @property {module:path.pathActions} pathActions
   * @property {module:history.UndoManager} undoMgr
   */ /**
   * @function module:draw.DrawCanvasInit#getCurrentGroup
   * @returns {Element}
   */ /**
   * @function module:draw.DrawCanvasInit#setCurrentGroup
   * @param {Element} cg
   * @returns {void}
  */ /**
   * @function module:draw.DrawCanvasInit#getSelectedElements
   * @returns {Element[]} the array with selected DOM elements
  */ /**
   * @function module:draw.DrawCanvasInit#getSvgContent
   * @returns {SVGSVGElement}
   */ /**
   * @function module:draw.DrawCanvasInit#getCurrentDrawing
   * @returns {module:draw.Drawing}
   */ /**
   * @function module:draw.DrawCanvasInit#clearSelection
   * @param {boolean} [noCall] - When `true`, does not call the "selected" handler
   * @returns {void}
  */ /**
   * Run the callback function associated with the given event.
   * @function module:draw.DrawCanvasInit#call
   * @param {"changed"|"contextset"} ev - String with the event name
   * @param {module:svgcanvas.SvgCanvas#event:changed|module:svgcanvas.SvgCanvas#event:contextset} arg - Argument to pass through to the callback
   * function. If the event is "changed", a (single-item) array of `Element`s is
   * passed. If the event is "contextset", the arg is `null` or `Element`.
   * @returns {void}
   */ /**
   * @function module:draw.DrawCanvasInit#addCommandToHistory
   * @param {Command} cmd
   * @returns {void}
  */ /**
   * @function module:draw.DrawCanvasInit#changeSvgContent
   * @returns {void}
   */let svgCanvas$e;/**
  * @function module:draw.init
  * @param {module:draw.DrawCanvasInit} canvas
  * @returns {void}
  */const init$f=canvas=>{svgCanvas$e=canvas;};/**
  * Updates layer system.
  * @function module:draw.identifyLayers
  * @returns {void}
  */const identifyLayers=()=>{leaveContext();svgCanvas$e.getCurrentDrawing().identifyLayers();};/**
  * get current index
  * @function module:draw.identifyLayers
  * @returns {void}
  */const indexCurrentLayer=()=>{return svgCanvas$e.getCurrentDrawing().indexCurrentLayer();};/**
  * Creates a new top-level layer in the drawing with the given name, sets the current layer
  * to it, and then clears the selection. This function then calls the 'changed' handler.
  * This is an undoable action.
  * @function module:draw.createLayer
  * @param {string} name - The given name
  * @param {module:history.HistoryRecordingService} hrService
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @returns {void}
  */const createLayer=(name,hrService)=>{const newLayer=svgCanvas$e.getCurrentDrawing().createLayer(name,historyRecordingService(hrService));svgCanvas$e.clearSelection();svgCanvas$e.call('changed',[newLayer]);};/**
   * Creates a new top-level layer in the drawing with the given name, copies all the current layer's contents
   * to it, and then clears the selection. This function then calls the 'changed' handler.
   * This is an undoable action.
   * @function module:draw.cloneLayer
   * @param {string} name - The given name. If the layer name exists, a new name will be generated.
   * @param {module:history.HistoryRecordingService} hrService - History recording service
   * @fires module:svgcanvas.SvgCanvas#event:changed
   * @returns {void}
   */const cloneLayer=(name,hrService)=>{// Clone the current layer and make the cloned layer the new current layer
  const newLayer=svgCanvas$e.getCurrentDrawing().cloneLayer(name,historyRecordingService(hrService));svgCanvas$e.clearSelection();leaveContext();svgCanvas$e.call('changed',[newLayer]);};/**
  * Deletes the current layer from the drawing and then clears the selection. This function
  * then calls the 'changed' handler. This is an undoable action.
  * @function module:draw.deleteCurrentLayer
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @returns {boolean} `true` if an old layer group was found to delete
  */const deleteCurrentLayer=()=>{const{BatchCommand,RemoveElementCommand}=svgCanvas$e.history;let currentLayer=svgCanvas$e.getCurrentDrawing().getCurrentLayer();const{nextSibling}=currentLayer;const parent=currentLayer.parentNode;currentLayer=svgCanvas$e.getCurrentDrawing().deleteCurrentLayer();if(currentLayer){const batchCmd=new BatchCommand('Delete Layer');// store in our Undo History
  batchCmd.addSubCommand(new RemoveElementCommand(currentLayer,nextSibling,parent));svgCanvas$e.addCommandToHistory(batchCmd);svgCanvas$e.clearSelection();svgCanvas$e.call('changed',[parent]);return true;}return false;};/**
  * Sets the current layer. If the name is not a valid layer name, then this function returns
  * false. Otherwise it returns true. This is not an undo-able action.
  * @function module:draw.setCurrentLayer
  * @param {string} name - The name of the layer you want to switch to.
  * @returns {boolean} true if the current layer was switched, otherwise false
  */const setCurrentLayer=name=>{const result=svgCanvas$e.getCurrentDrawing().setCurrentLayer(toXml(name));if(result){svgCanvas$e.clearSelection();}return result;};/**
  * Renames the current layer. If the layer name is not valid (i.e. unique), then this function
  * does nothing and returns `false`, otherwise it returns `true`. This is an undo-able action.
  * @function module:draw.renameCurrentLayer
  * @param {string} newName - the new name you want to give the current layer. This name must
  * be unique among all layer names.
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @returns {boolean} Whether the rename succeeded
  */const renameCurrentLayer=newName=>{const drawing=svgCanvas$e.getCurrentDrawing();const layer=drawing.getCurrentLayer();if(layer){const result=drawing.setCurrentLayerName(newName,historyRecordingService());if(result){svgCanvas$e.call('changed',[layer]);return true;}}return false;};/**
  * Changes the position of the current layer to the new value. If the new index is not valid,
  * this function does nothing and returns false, otherwise it returns true. This is an
  * undo-able action.
  * @function module:draw.setCurrentLayerPosition
  * @param {Integer} newPos - The zero-based index of the new position of the layer. This should be between
  * 0 and (number of layers - 1)
  * @returns {boolean} `true` if the current layer position was changed, `false` otherwise.
  */const setCurrentLayerPosition=newPos=>{const{MoveElementCommand}=svgCanvas$e.history;const drawing=svgCanvas$e.getCurrentDrawing();const result=drawing.setCurrentLayerPosition(newPos);if(result){svgCanvas$e.addCommandToHistory(new MoveElementCommand(result.currentGroup,result.oldNextSibling,svgCanvas$e.getSvgContent()));return true;}return false;};/**
  * Sets the visibility of the layer. If the layer name is not valid, this function return
  * `false`, otherwise it returns `true`. This is an undo-able action.
  * @function module:draw.setLayerVisibility
  * @param {string} layerName - The name of the layer to change the visibility
  * @param {boolean} bVisible - Whether the layer should be visible
  * @returns {boolean} true if the layer's visibility was set, false otherwise
  */const setLayerVisibility=(layerName,bVisible)=>{const{ChangeElementCommand}=svgCanvas$e.history;const drawing=svgCanvas$e.getCurrentDrawing();const prevVisibility=drawing.getLayerVisibility(layerName);const layer=drawing.setLayerVisibility(layerName,bVisible);if(layer){const oldDisplay=prevVisibility?'inline':'none';svgCanvas$e.addCommandToHistory(new ChangeElementCommand(layer,{display:oldDisplay},'Layer Visibility'));}else {return false;}if(layer===drawing.getCurrentLayer()){svgCanvas$e.clearSelection();svgCanvas$e.pathActions.clear();}// call('changed', [selected]);
  return true;};/**
  * Moves the selected elements to layerName. If the name is not a valid layer name, then `false`
  * is returned. Otherwise it returns `true`. This is an undo-able action.
  * @function module:draw.moveSelectedToLayer
  * @param {string} layerName - The name of the layer you want to which you want to move the selected elements
  * @returns {boolean} Whether the selected elements were moved to the layer.
  */const moveSelectedToLayer=layerName=>{const{BatchCommand,MoveElementCommand}=svgCanvas$e.history;// find the layer
  const drawing=svgCanvas$e.getCurrentDrawing();const layer=drawing.getLayerByName(layerName);if(!layer){return false;}const batchCmd=new BatchCommand('Move Elements to Layer');// loop for each selected element and move it
  const selElems=svgCanvas$e.getSelectedElements();let i=selElems.length;while(i--){const elem=selElems[i];if(!elem){continue;}const oldNextSibling=elem.nextSibling;// TODO: this is pretty brittle!
  const oldLayer=elem.parentNode;layer.append(elem);batchCmd.addSubCommand(new MoveElementCommand(elem,oldNextSibling,oldLayer));}svgCanvas$e.addCommandToHistory(batchCmd);return true;};/**
  * @function module:draw.mergeLayer
  * @param {module:history.HistoryRecordingService} hrService
  * @returns {void}
  */const mergeLayer=hrService=>{svgCanvas$e.getCurrentDrawing().mergeLayer(historyRecordingService(hrService));svgCanvas$e.clearSelection();leaveContext();svgCanvas$e.changeSvgContent();};/**
  * @function module:draw.mergeAllLayers
  * @param {module:history.HistoryRecordingService} hrService
  * @returns {void}
  */const mergeAllLayers=hrService=>{svgCanvas$e.getCurrentDrawing().mergeAllLayers(historyRecordingService(hrService));svgCanvas$e.clearSelection();leaveContext();svgCanvas$e.changeSvgContent();};/**
  * Return from a group context to the regular kind, make any previously
  * disabled elements enabled again.
  * @function module:draw.leaveContext
  * @fires module:svgcanvas.SvgCanvas#event:contextset
  * @returns {void}
  */const leaveContext=()=>{const len=disabledElems.length;const dataStorage=svgCanvas$e.getDataStorage();if(len){for(let i=0;i<len;i++){const elem=disabledElems[i];const orig=dataStorage.get(elem,'orig_opac');if(orig!==1){elem.setAttribute('opacity',orig);}else {elem.removeAttribute('opacity');}elem.setAttribute('style','pointer-events: inherit');}disabledElems=[];svgCanvas$e.clearSelection(true);svgCanvas$e.call('contextset',null);}svgCanvas$e.setCurrentGroup(null);};/**
  * Set the current context (for in-group editing).
  * @function module:draw.setContext
  * @param {Element} elem
  * @fires module:svgcanvas.SvgCanvas#event:contextset
  * @returns {void}
  */const setContext=elem=>{const dataStorage=svgCanvas$e.getDataStorage();leaveContext();if(typeof elem==='string'){elem=getElement(elem);}// Edit inside this group
  svgCanvas$e.setCurrentGroup(elem);// Disable other elements
  const parentsUntil=getParentsUntil$1(elem,'#svgcontent');const siblings=[];parentsUntil.forEach(function(parent){const elements=Array.prototype.filter.call(parent.parentNode.children,function(child){return child!==parent;});elements.forEach(function(element){siblings.push(element);});});siblings.forEach(function(curthis){const opac=curthis.getAttribute('opacity')||1;// Store the original's opacity
  dataStorage.put(curthis,'orig_opac',opac);curthis.setAttribute('opacity',opac*0.33);curthis.setAttribute('style','pointer-events: none');disabledElems.push(curthis);});svgCanvas$e.clearSelection();svgCanvas$e.call('contextset',svgCanvas$e.getCurrentGroup());};const{InsertElementCommand:InsertElementCommand$3,BatchCommand:BatchCommand$3}=history;let svgCanvas$d=null;/**
  * @function module:paste-elem.init
  * @param {module:paste-elem.pasteContext} pasteContext
  * @returns {void}
  */const init$e=canvas=>{svgCanvas$d=canvas;};/**
  * @function module:svgcanvas.SvgCanvas#pasteElements
  * @param {"in_place"|"point"|void} type
  * @param {Integer|void} x Expected if type is "point"
  * @param {Integer|void} y Expected if type is "point"
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @fires module:svgcanvas.SvgCanvas#event:ext_IDsUpdated
  * @returns {void}
  */const pasteElementsMethod=function(type,x,y){let clipb=JSON.parse(sessionStorage.getItem(svgCanvas$d.getClipboardID()));if(!clipb)return;let len=clipb.length;if(!len)return;const pasted=[];const batchCmd=new BatchCommand$3('Paste elements');// const drawing = getCurrentDrawing();
  /**
    * @typedef {PlainObject<string, string>} module:svgcanvas.ChangedIDs
    */ /**
    * @type {module:svgcanvas.ChangedIDs}
    */const changedIDs={};// Recursively replace IDs and record the changes
  /**
    *
    * @param {module:svgcanvas.SVGAsJSON} elem
    * @returns {void}
    */function checkIDs(elem){var _elem$attr;if((_elem$attr=elem.attr)!==null&&_elem$attr!==void 0&&_elem$attr.id){changedIDs[elem.attr.id]=svgCanvas$d.getNextId();elem.attr.id=changedIDs[elem.attr.id];}if(elem.children)elem.children.forEach(child=>checkIDs(child));}clipb.forEach(elem=>checkIDs(elem));// Give extensions like the connector extension a chance to reflect new IDs and remove invalid elements
  /**
    * Triggered when `pasteElements` is called from a paste action (context menu or key).
    * @event module:svgcanvas.SvgCanvas#event:ext_IDsUpdated
    * @type {PlainObject}
    * @property {module:svgcanvas.SVGAsJSON[]} elems
    * @property {module:svgcanvas.ChangedIDs} changes Maps past ID (on attribute) to current ID
    */svgCanvas$d.runExtensions('IDsUpdated',/** @type {module:svgcanvas.SvgCanvas#event:ext_IDsUpdated} */{elems:clipb,changes:changedIDs},true).forEach(function(extChanges){if(!extChanges||!('remove'in extChanges))return;extChanges.remove.forEach(function(removeID){clipb=clipb.filter(function(clipBoardItem){return clipBoardItem.attr.id!==removeID;});});});// Move elements to lastClickPoint
  while(len--){const elem=clipb[len];if(!elem){continue;}const copy=svgCanvas$d.addSVGElementsFromJson(elem);pasted.push(copy);batchCmd.addSubCommand(new InsertElementCommand$3(copy));svgCanvas$d.restoreRefElements(copy);}svgCanvas$d.selectOnly(pasted);if(type!=='in_place'){let ctrX;let ctrY;if(!type){ctrX=svgCanvas$d.getLastClickPoint('x');ctrY=svgCanvas$d.getLastClickPoint('y');}else if(type==='point'){ctrX=x;ctrY=y;}const bbox=getStrokedBBoxDefaultVisible(pasted);const cx=ctrX-(bbox.x+bbox.width/2);const cy=ctrY-(bbox.y+bbox.height/2);const dx=[];const dy=[];pasted.forEach(function(_item){dx.push(cx);dy.push(cy);});const cmd=svgCanvas$d.moveSelectedElements(dx,dy,false);if(cmd)batchCmd.addSubCommand(cmd);}svgCanvas$d.addCommandToHistory(batchCmd);svgCanvas$d.call('changed',pasted);};// http://ross.posterous.com/2008/08/19/iphone-touch-events-in-javascript/
  /**
   *
   * @param {Event} ev
   * @returns {void}
   */const touchHandler=ev=>{ev.preventDefault();const{changedTouches}=ev;const first=changedTouches[0];let type='';switch(ev.type){case'touchstart':type='mousedown';break;case'touchmove':type='mousemove';break;case'touchend':type='mouseup';break;default:return;}const{screenX,screenY,clientX,clientY}=first;const simulatedEvent=new MouseEvent(type,{// Event interface
  bubbles:true,cancelable:true,// UIEvent interface
  view:window,detail:1,// click count
  // MouseEvent interface (customized)
  screenX,screenY,clientX,clientY,// MouseEvent interface (defaults) - these could be removed
  ctrlKey:false,altKey:false,shiftKey:false,metaKey:false,button:0,// main button (usually left)
  relatedTarget:null});if(changedTouches.length<2){first.target.dispatchEvent(simulatedEvent);}};const init$d=svgCanvas=>{svgCanvas.svgroot.addEventListener('touchstart',touchHandler);svgCanvas.svgroot.addEventListener('touchmove',touchHandler);svgCanvas.svgroot.addEventListener('touchend',touchHandler);svgCanvas.svgroot.addEventListener('touchcancel',touchHandler);};/**
   * Tools for SVG Root Element.
   * @module svgcanvas
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */ /**
  * @function module:svgcanvas.svgRootElement svgRootElement the svg node and its children.
  * @param {Element} svgdoc - window.document
  * @param {ArgumentsArray} dimensions - dimensions of width and height
  * @returns {svgRootElement}
  */const svgRootElement=function(svgdoc,dimensions){return svgdoc.importNode(text2xml(`<svg id="svgroot" xmlns="${NS.SVG}" xlinkns="${NS.XLINK}" width="${dimensions[0]}" 
        height="${dimensions[1]}" x="${dimensions[0]}" y="${dimensions[1]}" overflow="visible">
        <defs>
          <filter id="canvashadow" filterUnits="objectBoundingBox">
            <feGaussianBlur in="SourceAlpha" stdDeviation="4" result="blur"/>
            <feOffset in="blur" dx="5" dy="5" result="offsetBlur"/>
            <feMerge>
              <feMergeNode in="offsetBlur"/>
              <feMergeNode in="SourceGraphic"/>
            </feMerge>
          </filter>
        </defs>
      </svg>`).documentElement,true);};/**
   * Browser detection.
   * @module browser
   * @license MIT
   *
   * @copyright 2010 Jeff Schiller, 2010 Alexis Deveria
   */const NSSVG$2='http://www.w3.org/2000/svg';const{userAgent:userAgent$4}=navigator;// Note: Browser sniffing should only be used if no other detection method is possible
  const isWebkit_=userAgent$4.includes('AppleWebKit');const isGecko_=userAgent$4.includes('Gecko/');const isChrome_$1=userAgent$4.includes('Chrome/');userAgent$4.includes('Macintosh');// text character positioning (for IE9 and now Chrome)
  const supportsGoodTextCharPos_=function(){const svgroot=document.createElementNS(NSSVG$2,'svg');const svgContent=document.createElementNS(NSSVG$2,'svg');document.documentElement.append(svgroot);svgContent.setAttribute('x',5);svgroot.append(svgContent);const text=document.createElementNS(NSSVG$2,'text');text.textContent='a';svgContent.append(text);try{// Chrome now fails here
  const pos=text.getStartPositionOfChar(0).x;return pos===0;}catch(err){return false;}finally{svgroot.remove();}}();// Public API
  /**
   * @function module:browser.isWebkit
   * @returns {boolean}
  */const isWebkit=()=>isWebkit_;/**
   * @function module:browser.isGecko
   * @returns {boolean}
  */const isGecko$1=()=>isGecko_;/**
   * @function module:browser.isChrome
   * @returns {boolean}
  */const isChrome$1=()=>isChrome_$1;/**
   * @function module:browser.supportsGoodTextCharPos
   * @returns {boolean}
  */const supportsGoodTextCharPos=()=>supportsGoodTextCharPos_;/**
   * Tools for undo.
   * @module undo
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */const{UndoManager,HistoryEventTypes}=history;let svgCanvas$c=null;/**
  * @function module:undo.init
  * @param {module:undo.undoContext} undoContext
  * @returns {void}
  */const init$c=canvas=>{svgCanvas$c=canvas;canvas.undoMgr=getUndoManager();};const getUndoManager=()=>{return new UndoManager({/**
       * @param {string} eventType One of the HistoryEvent types
       * @param {module:history.HistoryCommand} cmd Fulfills the HistoryCommand interface
       * @fires module:undo.SvgCanvas#event:changed
       * @returns {void}
       */handleHistoryEvent(eventType,cmd){const EventTypes=HistoryEventTypes;// TODO: handle setBlurOffsets.
  if(eventType===EventTypes.BEFORE_UNAPPLY||eventType===EventTypes.BEFORE_APPLY){svgCanvas$c.clearSelection();}else if(eventType===EventTypes.AFTER_APPLY||eventType===EventTypes.AFTER_UNAPPLY){const elems=cmd.elements();svgCanvas$c.pathActions.clear();svgCanvas$c.call('changed',elems);const cmdType=cmd.type();const isApply=eventType===EventTypes.AFTER_APPLY;if(cmdType==='MoveElementCommand'){const parent=isApply?cmd.newParent:cmd.oldParent;if(parent===svgCanvas$c.getSvgContent()){identifyLayers();}}else if(cmdType==='InsertElementCommand'||cmdType==='RemoveElementCommand'){var _cmd$elem;if(cmd.parent===svgCanvas$c.getSvgContent()){identifyLayers();}if(cmdType==='InsertElementCommand'){if(isApply){svgCanvas$c.restoreRefElements(cmd.elem);}}else if(!isApply){svgCanvas$c.restoreRefElements(cmd.elem);}if(((_cmd$elem=cmd.elem)===null||_cmd$elem===void 0?void 0:_cmd$elem.tagName)==='use'){svgCanvas$c.setUseData(cmd.elem);}}else if(cmdType==='ChangeElementCommand'){// if we are changing layer names, re-identify all layers
  if(cmd.elem.tagName==='title'&&cmd.elem.parentNode.parentNode===svgCanvas$c.getSvgContent()){identifyLayers();}const values=isApply?cmd.newValues:cmd.oldValues;// If stdDeviation was changed, update the blur.
  if(values.stdDeviation){svgCanvas$c.setBlurOffsets(cmd.elem.parentNode,values.stdDeviation);}if(cmd.elem.tagName==='text'){const[dx,dy]=[cmd.newValues.x-cmd.oldValues.x,cmd.newValues.y-cmd.oldValues.y];const tspans=cmd.elem.children;for(let i=0;i<tspans.length;i++){let x=Number(tspans[i].getAttribute('x'));let y=Number(tspans[i].getAttribute('y'));const unapply=eventType===EventTypes.AFTER_UNAPPLY;x=unapply?x-dx:x+dx;y=unapply?y-dy:y+dy;tspans[i].setAttribute('x',x);tspans[i].setAttribute('y',y);}}}}}});};/**
  * Hack for Firefox bugs where text element features aren't updated or get
  * messed up. See issue 136 and issue 137.
  * This function clones the element and re-selects it.
  * @function module:svgcanvas~ffClone
  * @todo Test for this bug on load and add it to "support" object instead of
  * browser sniffing
  * @param {Element} elem - The (text) DOM element to clone
  * @returns {Element} Cloned element
  */const ffClone=function(elem){if(!isGecko$1()){return elem;}const clone=elem.cloneNode(true);elem.before(clone);elem.remove();svgCanvas$c.selectorManager.releaseSelector(elem);svgCanvas$c.setSelectedElements(0,clone);svgCanvas$c.selectorManager.requestSelector(clone).showGrips(true);return clone;};/**
  * This function makes the changes to the elements. It does not add the change
  * to the history stack.
  * @param {string} attr - Attribute name
  * @param {string|Float} newValue - String or number with the new attribute value
  * @param {Element[]} elems - The DOM elements to apply the change to
  * @returns {void}
  */const changeSelectedAttributeNoUndoMethod=(attr,newValue,elems)=>{if(attr==='id'){// if the user is changing the id, then de-select the element first
  // change the ID, then re-select it with the new ID
  // as this change can impact other extensions, a 'renamedElement' event is thrown
  const elem=elems[0];const oldId=elem.id;if(oldId!==newValue){svgCanvas$c.clearSelection();elem.id=newValue;svgCanvas$c.addToSelection([elem],true);svgCanvas$c.call('elementRenamed',{elem,oldId,newId:newValue});}return;}const selectedElements=svgCanvas$c.getSelectedElements();const zoom=svgCanvas$c.getZoom();if(svgCanvas$c.getCurrentMode()==='pathedit'){// Editing node
  svgCanvas$c.pathActions.moveNode(attr,newValue);}elems=elems??selectedElements;let i=elems.length;const noXYElems=['g','polyline','path'];while(i--){let elem=elems[i];if(!elem){continue;}// Set x,y vals on elements that don't have them
  if((attr==='x'||attr==='y')&&noXYElems.includes(elem.tagName)){const bbox=getStrokedBBoxDefaultVisible([elem]);const diffX=attr==='x'?newValue-bbox.x:0;const diffY=attr==='y'?newValue-bbox.y:0;svgCanvas$c.moveSelectedElements(diffX*zoom,diffY*zoom,true);continue;}let oldval=attr==='#text'?elem.textContent:elem.getAttribute(attr);if(!oldval){oldval='';}if(oldval!==String(newValue)){if(attr==='#text'){// const oldW = utilsGetBBox(elem).width;
  elem.textContent=newValue;// FF bug occurs on on rotated elements
  if(/rotate/.test(elem.getAttribute('transform'))){elem=ffClone(elem);}// Hoped to solve the issue of moving text with text-anchor="start",
  // but this doesn't actually fix it. Hopefully on the right track, though. -Fyrd
  }else if(attr==='#href'){setHref(elem,newValue);}else if(newValue){elem.setAttribute(attr,newValue);}else if(typeof newValue==='number'){elem.setAttribute(attr,newValue);}else {elem.removeAttribute(attr);}// Go into "select" mode for text changes
  // NOTE: Important that this happens AFTER elem.setAttribute() or else attributes like
  // font-size can get reset to their old value, ultimately by svgEditor.updateContextPanel(),
  // after calling textActions.toSelectMode() below
  if(svgCanvas$c.getCurrentMode()==='textedit'&&attr!=='#text'&&elem.textContent.length){svgCanvas$c.textActions.toSelectMode(elem);}// Use the Firefox ffClone hack for text elements with gradients or
  // where other text attributes are changed.
  if(isGecko$1()&&elem.nodeName==='text'&&/rotate/.test(elem.getAttribute('transform'))&&(String(newValue).startsWith('url')||['font-size','font-family','x','y'].includes(attr)&&elem.textContent)){elem=ffClone(elem);}// Timeout needed for Opera & Firefox
  // codedread: it is now possible for this function to be called with elements
  // that are not in the selectedElements array, we need to only request a
  // selector if the element is in that array
  if(selectedElements.includes(elem)){setTimeout(function(){// Due to element replacement, this element may no longer
  // be part of the DOM
  if(!elem.parentNode){return;}svgCanvas$c.selectorManager.requestSelector(elem).resize();},0);}// if this element was rotated, and we changed the position of this element
  // we need to update the rotational transform attribute
  const angle=getRotationAngle(elem);if(angle!==0&&attr!=='transform'){var _elem$transform;const tlist=(_elem$transform=elem.transform)===null||_elem$transform===void 0?void 0:_elem$transform.baseVal;let n=tlist.numberOfItems;while(n--){const xform=tlist.getItem(n);if(xform.type===4){// remove old rotate
  tlist.removeItem(n);const box=getBBox(elem);const center=transformPoint(box.x+box.width/2,box.y+box.height/2,transformListToTransform(tlist).matrix);const cx=center.x;const cy=center.y;const newrot=svgCanvas$c.getSvgRoot().createSVGTransform();newrot.setRotate(angle,cx,cy);tlist.insertItemBefore(newrot,n);break;}}}}// if oldValue != newValue
  }// for each elem
  };/**
  * Change the given/selected element and add the original value to the history stack.
  * If you want to change all `selectedElements`, ignore the `elems` argument.
  * If you want to change only a subset of `selectedElements`, then send the
  * subset to this function in the `elems` argument.
  * @function module:svgcanvas.SvgCanvas#changeSelectedAttribute
  * @param {string} attr - String with the attribute name
  * @param {string|Float} val - String or number with the new attribute value
  * @param {Element[]} elems - The DOM elements to apply the change to
  * @returns {void}
  */const changeSelectedAttributeMethod=function(attr,val,elems){const selectedElements=svgCanvas$c.getSelectedElements();elems=elems||selectedElements;svgCanvas$c.undoMgr.beginUndoableChange(attr,elems);changeSelectedAttributeNoUndoMethod(attr,val,elems);const batchCmd=svgCanvas$c.undoMgr.finishUndoableChange();if(!batchCmd.isEmpty()){// svgCanvas.addCommandToHistory(batchCmd);
  svgCanvas$c.undoMgr.addCommandToHistory(batchCmd);}};/**
   * Tools for selection.
   * @module selection
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */const{BatchCommand:BatchCommand$2}=history;let svgCanvas$b=null;/**
   * @function module:selection.init
   * @param {module:selection.selectionContext} selectionContext
   * @returns {void}
   */const init$b=canvas=>{svgCanvas$b=canvas;svgCanvas$b.getMouseTarget=getMouseTargetMethod;svgCanvas$b.clearSelection=clearSelectionMethod;svgCanvas$b.addToSelection=addToSelectionMethod;svgCanvas$b.getIntersectionList=getIntersectionListMethod;svgCanvas$b.runExtensions=runExtensionsMethod;svgCanvas$b.groupSvgElem=groupSvgElem;svgCanvas$b.prepareSvg=prepareSvg;svgCanvas$b.recalculateAllSelectedDimensions=recalculateAllSelectedDimensions;svgCanvas$b.setRotationAngle=setRotationAngle;};/**
   * Clears the selection. The 'selected' handler is then optionally called.
   * This should really be an intersection applying to all types rather than a union.
   * @name module:selection.SvgCanvas#clearSelection
   * @type {module:draw.DrawCanvasInit#clearSelection|module:path.EditorContext#clearSelection}
   * @fires module:selection.SvgCanvas#event:selected
   */const clearSelectionMethod=noCall=>{var _svgCanvas$b;const selectedElements=svgCanvas$b.getSelectedElements();selectedElements.forEach(elem=>{if(!elem){return;}svgCanvas$b.selectorManager.releaseSelector(elem);});(_svgCanvas$b=svgCanvas$b)===null||_svgCanvas$b===void 0?void 0:_svgCanvas$b.setEmptySelectedElements();if(!noCall){svgCanvas$b.call('selected',svgCanvas$b.getSelectedElements());}};/**
   * Adds a list of elements to the selection. The 'selected' handler is then called.
   * @name module:selection.SvgCanvas#addToSelection
   * @type {module:path.EditorContext#addToSelection}
   * @fires module:selection.SvgCanvas#event:selected
   */const addToSelectionMethod=(elemsToAdd,showGrips)=>{const selectedElements=svgCanvas$b.getSelectedElements();if(!elemsToAdd.length){return;}// find the first null in our selectedElements array
  let firstNull=0;while(firstNull<selectedElements.length){if(selectedElements[firstNull]===null){break;}++firstNull;}// now add each element consecutively
  let i=elemsToAdd.length;while(i--){let elem=elemsToAdd[i];if(!elem||!elem.getBBox){continue;}if(elem.tagName==='a'&&elem.childNodes.length===1){// Make "a" element's child be the selected element
  elem=elem.firstChild;}// if it's not already there, add it
  if(!selectedElements.includes(elem)){selectedElements[firstNull]=elem;// only the first selectedBBoxes element is ever used in the codebase these days
  // if (j === 0) selectedBBoxes[0] = utilsGetBBox(elem);
  firstNull++;const sel=svgCanvas$b.selectorManager.requestSelector(elem);if(selectedElements.length>1){sel.showGrips(false);}}}if(!selectedElements.length){return;}svgCanvas$b.call('selected',selectedElements);if(selectedElements.length===1){svgCanvas$b.selectorManager.requestSelector(selectedElements[0]).showGrips(showGrips);}// make sure the elements are in the correct order
  // See: https://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-compareDocumentPosition
  selectedElements.sort((a,b)=>{if(a&&b&&a.compareDocumentPosition){return 3-(b.compareDocumentPosition(a)&6);}if(!a){return 1;}return 0;});// Make sure first elements are not null
  while(!selectedElements[0]){selectedElements.shift(0);}};/**
   * @name module:svgcanvas.SvgCanvas#getMouseTarget
   * @type {module:path.EditorContext#getMouseTarget}
   */const getMouseTargetMethod=evt=>{if(!evt){return null;}let mouseTarget=evt.target;// if it was a <use>, Opera and WebKit return the SVGElementInstance
  if(mouseTarget.correspondingUseElement){mouseTarget=mouseTarget.correspondingUseElement;}// for foreign content, go up until we find the foreignObject
  // WebKit browsers set the mouse target to the svgcanvas div
  if([NS.MATH,NS.HTML].includes(mouseTarget.namespaceURI)&&mouseTarget.id!=='svgcanvas'){while(mouseTarget.nodeName!=='foreignObject'){mouseTarget=mouseTarget.parentNode;if(!mouseTarget){return svgCanvas$b.getSvgRoot();}}}// Get the desired mouseTarget with jQuery selector-fu
  // If it's root-like, select the root
  const currentLayer=svgCanvas$b.getCurrentDrawing().getCurrentLayer();const svgRoot=svgCanvas$b.getSvgRoot();const container=svgCanvas$b.getDOMContainer();const content=svgCanvas$b.getSvgContent();if([svgRoot,container,content,currentLayer].includes(mouseTarget)){return svgCanvas$b.getSvgRoot();}// If it's a selection grip, return the grip parent
  if(getClosest(mouseTarget.parentNode,'#selectorParentGroup')){// While we could instead have just returned mouseTarget,
  // this makes it easier to indentify as being a selector grip
  return svgCanvas$b.selectorManager.selectorParentGroup;}while(!((_mouseTarget=mouseTarget)!==null&&_mouseTarget!==void 0&&(_mouseTarget$parentNo=_mouseTarget.parentNode)!==null&&_mouseTarget$parentNo!==void 0&&_mouseTarget$parentNo.isSameNode(svgCanvas$b.getCurrentGroup()||currentLayer))){var _mouseTarget,_mouseTarget$parentNo;mouseTarget=mouseTarget.parentNode;}return mouseTarget;};/**
   * @typedef {module:svgcanvas.ExtensionMouseDownStatus|module:svgcanvas.ExtensionMouseUpStatus|module:svgcanvas.ExtensionIDsUpdatedStatus|module:locale.ExtensionLocaleData[]|void} module:svgcanvas.ExtensionStatus
   * @tutorial ExtensionDocs
   */ /**
   * @callback module:svgcanvas.ExtensionVarBuilder
   * @param {string} name The name of the extension
   * @returns {module:svgcanvas.SvgCanvas#event:ext_addLangData}
   */ /**
   * @callback module:svgcanvas.ExtensionNameFilter
   * @param {string} name
   * @returns {boolean}
   */ /* eslint-disable max-len */ /**
   * @todo Consider: Should this return an array by default, so extension results aren't overwritten?
   * @todo Would be easier to document if passing in object with key of action and vars as value; could then define an interface which tied both together
   * @function module:svgcanvas.SvgCanvas#runExtensions
   * @param {"mouseDown"|"mouseMove"|"mouseUp"|"zoomChanged"|"IDsUpdated"|"canvasUpdated"|"toolButtonStateUpdate"|"selectedChanged"|"elementTransition"|"elementChanged"|"langReady"|"langChanged"|"addLangData"|"workareaResized"} action
   * @param {module:svgcanvas.SvgCanvas#event:ext_mouseDown|module:svgcanvas.SvgCanvas#event:ext_mouseMove|module:svgcanvas.SvgCanvas#event:ext_mouseUp|module:svgcanvas.SvgCanvas#event:ext_zoomChanged|module:svgcanvas.SvgCanvas#event:ext_IDsUpdated|module:svgcanvas.SvgCanvas#event:ext_canvasUpdated|module:svgcanvas.SvgCanvas#event:ext_toolButtonStateUpdate|module:svgcanvas.SvgCanvas#event:ext_selectedChanged|module:svgcanvas.SvgCanvas#event:ext_elementTransition|module:svgcanvas.SvgCanvas#event:ext_elementChanged|module:svgcanvas.SvgCanvas#event:ext_langReady|module:svgcanvas.SvgCanvas#event:ext_langChanged|module:svgcanvas.SvgCanvas#event:ext_addLangData|module:svgcanvas.SvgCanvas#event:ext_workareaResized|module:svgcanvas.ExtensionVarBuilder} [vars]
   * @param {boolean} [returnArray]
   * @returns {GenericArray<module:svgcanvas.ExtensionStatus>|module:svgcanvas.ExtensionStatus|false} See {@tutorial ExtensionDocs} on the ExtensionStatus.
   */ /* eslint-enable max-len */const runExtensionsMethod=(action,vars,returnArray)=>{let result=returnArray?[]:false;for(const[name,ext]of Object.entries(svgCanvas$b.getExtensions())){if(typeof vars==='function'){vars=vars(name);// ext, action
  }if(ext.eventBased){const event=new CustomEvent('svgedit',{detail:{action,vars}});document.dispatchEvent(event);}else if(ext[action]){if(returnArray){result.push(ext[action](vars));}else {result=ext[action](vars);}}}return result;};/**
   * Get all elements that have a BBox (excludes `<defs>`, `<title>`, etc).
   * Note that 0-opacity, off-screen etc elements are still considered "visible"
   * for this function.
   * @function module:svgcanvas.SvgCanvas#getVisibleElementsAndBBoxes
   * @param {Element} parent - The parent DOM element to search within
   * @returns {ElementAndBBox[]} An array with objects that include:
   */const getVisibleElementsAndBBoxes=parent=>{if(!parent){const svgContent=svgCanvas$b.getSvgContent();parent=svgContent.children;// Prevent layers from being included
  }const contentElems=[];const elements=parent.children;Array.from(elements).forEach(elem=>{if(elem.getBBox){contentElems.push({elem,bbox:getStrokedBBoxDefaultVisible([elem])});}});return contentElems.reverse();};/**
   * This method sends back an array or a NodeList full of elements that
   * intersect the multi-select rubber-band-box on the currentLayer only.
   *
   * We brute-force `getIntersectionList` for browsers that do not support it (Firefox).
   *
   * Reference:
   * Firefox does not implement `getIntersectionList()`, see {@link https://bugzilla.mozilla.org/show_bug.cgi?id=501421}.
   * @function module:svgcanvas.SvgCanvas#getIntersectionList
   * @param {SVGRect} rect
   * @returns {Element[]|NodeList} Bbox elements
   */const getIntersectionListMethod=rect=>{const zoom=svgCanvas$b.getZoom();if(!svgCanvas$b.getRubberBox()){return null;}const parent=svgCanvas$b.getCurrentGroup()||svgCanvas$b.getCurrentDrawing().getCurrentLayer();let rubberBBox;if(!rect){rubberBBox=getBBox(svgCanvas$b.getRubberBox());const bb=svgCanvas$b.getSvgContent().createSVGRect();['x','y','width','height','top','right','bottom','left'].forEach(o=>{bb[o]=rubberBBox[o]/zoom;});rubberBBox=bb;}else {rubberBBox=svgCanvas$b.getSvgContent().createSVGRect();rubberBBox.x=rect.x;rubberBBox.y=rect.y;rubberBBox.width=rect.width;rubberBBox.height=rect.height;}const resultList=[];if(svgCanvas$b.getCurBBoxes().length===0){// Cache all bboxes
  svgCanvas$b.setCurBBoxes(getVisibleElementsAndBBoxes(parent));}let i=svgCanvas$b.getCurBBoxes().length;while(i--){const curBBoxes=svgCanvas$b.getCurBBoxes();if(!rubberBBox.width){continue;}if(curBBoxes[i].bbox&&rectsIntersect(rubberBBox,curBBoxes[i].bbox)){resultList.push(curBBoxes[i].elem);}}// addToSelection expects an array, but it's ok to pass a NodeList
  // because using square-bracket notation is allowed:
  // https://www.w3.org/TR/DOM-Level-2-Core/ecma-script-binding.html
  return resultList;};/**
   * @typedef {PlainObject} ElementAndBBox
   * @property {Element} elem - The element
   * @property {module:utilities.BBoxObject} bbox - The element's BBox as retrieved from `getStrokedBBoxDefaultVisible`
   */ /**
   * Wrap an SVG element into a group element, mark the group as 'gsvg'.
   * @function module:svgcanvas.SvgCanvas#groupSvgElem
   * @param {Element} elem - SVG element to wrap
   * @returns {void}
   */const groupSvgElem=elem=>{const dataStorage=svgCanvas$b.getDataStorage();const g=document.createElementNS(NS.SVG,'g');elem.replaceWith(g);g.appendChild(elem);dataStorage.put(g,'gsvg',elem);g.id=svgCanvas$b.getNextId();};/**
   * Runs the SVG Document through the sanitizer and then updates its paths.
   * @function module:svgcanvas.SvgCanvas#prepareSvg
   * @param {XMLDocument} newDoc - The SVG DOM document
   * @returns {void}
   */const prepareSvg=newDoc=>{svgCanvas$b.sanitizeSvg(newDoc.documentElement);// convert paths into absolute commands
  const paths=[...newDoc.getElementsByTagNameNS(NS.SVG,'path')];paths.forEach(path=>{const convertedPath=svgCanvas$b.pathActions.convertPath(path);path.setAttribute('d',convertedPath);svgCanvas$b.pathActions.fixEnd(path);});};/**
   * Removes any old rotations if present, prepends a new rotation at the
   * transformed center.
   * @function module:svgcanvas.SvgCanvas#setRotationAngle
   * @param {string|Float} val - The new rotation angle in degrees
   * @param {boolean} preventUndo - Indicates whether the action should be undoable or not
   * @fires module:svgcanvas.SvgCanvas#event:changed
   * @returns {void}
   */const setRotationAngle=(val,preventUndo)=>{const selectedElements=svgCanvas$b.getSelectedElements();// ensure val is the proper type
  val=Number.parseFloat(val);const elem=selectedElements[0];const oldTransform=elem.getAttribute('transform');const bbox=getBBox(elem);const cx=bbox.x+bbox.width/2;const cy=bbox.y+bbox.height/2;const tlist=elem.transform.baseVal;// only remove the real rotational transform if present (i.e. at index=0)
  if(tlist.numberOfItems>0){const xform=tlist.getItem(0);if(xform.type===4){tlist.removeItem(0);}}// find Rnc and insert it
  if(val!==0){const center=transformPoint(cx,cy,transformListToTransform(tlist).matrix);const Rnc=svgCanvas$b.getSvgRoot().createSVGTransform();Rnc.setRotate(val,center.x,center.y);if(tlist.numberOfItems){tlist.insertItemBefore(Rnc,0);}else {tlist.appendItem(Rnc);}}else if(tlist.numberOfItems===0){elem.removeAttribute('transform');}if(!preventUndo){// we need to undo it, then redo it so it can be undo-able! :)
  // TODO: figure out how to make changes to transform list undo-able cross-browser?
  let newTransform=elem.getAttribute('transform');// new transform is something like: 'rotate(5 1.39625e-8 -11)'
  // we round the x so it becomes 'rotate(5 0 -11)'
  if(newTransform){const newTransformArray=newTransform.split(' ');const round=num=>Math.round(Number(num)+Number.EPSILON);const x=round(newTransformArray[1]);newTransform=`${newTransformArray[0]} ${x} ${newTransformArray[2]}`;}if(oldTransform){elem.setAttribute('transform',oldTransform);}else {elem.removeAttribute('transform');}svgCanvas$b.changeSelectedAttribute('transform',newTransform,selectedElements);svgCanvas$b.call('changed',selectedElements);}// const pointGripContainer = getElement('pathpointgrip_container');
  // if (elem.nodeName === 'path' && pointGripContainer) {
  //   pathActions.setPointContainerTransform(elem.getAttribute('transform'));
  // }
  const selector=svgCanvas$b.selectorManager.requestSelector(selectedElements[0]);selector.resize();svgCanvas$b.getSelector().updateGripCursors(val);};/**
   * Runs `recalculateDimensions` on the selected elements,
   * adding the changes to a single batch command.
   * @function module:svgcanvas.SvgCanvas#recalculateAllSelectedDimensions
   * @fires module:svgcanvas.SvgCanvas#event:changed
   * @returns {void}
   */const recalculateAllSelectedDimensions=()=>{const text=svgCanvas$b.getCurrentResizeMode()==='none'?'position':'size';const batchCmd=new BatchCommand$2(text);const selectedElements=svgCanvas$b.getSelectedElements();selectedElements.forEach(elem=>{const cmd=svgCanvas$b.recalculateDimensions(elem);if(cmd){batchCmd.addSubCommand(cmd);}});if(!batchCmd.isEmpty()){svgCanvas$b.addCommandToHistory(batchCmd);svgCanvas$b.call('changed',selectedElements);}};/**
   * @module text-actions Tools for Text edit functions
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */let svgCanvas$a=null;/**
  * @function module:text-actions.init
  * @param {module:text-actions.svgCanvas} textActionsContext
  * @returns {void}
  */const init$a=canvas=>{svgCanvas$a=canvas;};/**
  * Group: Text edit functions
  * Functions relating to editing text elements.
  * @namespace {PlainObject} textActions
  * @memberof module:svgcanvas.SvgCanvas#
  */const textActionsMethod=function(){let curtext;let textinput;let cursor;let selblock;let blinker;let chardata=[];let textbb;// , transbb;
  let matrix;let lastX;let lastY;let allowDbl;/**
    *
    * @param {Integer} index
    * @returns {void}
    */function setCursor(index){const empty=textinput.value==='';textinput.focus();if(!arguments.length){if(empty){index=0;}else {if(textinput.selectionEnd!==textinput.selectionStart){return;}index=textinput.selectionEnd;}}const charbb=chardata[index];if(!empty){textinput.setSelectionRange(index,index);}cursor=getElement('text_cursor');if(!cursor){cursor=document.createElementNS(NS.SVG,'line');assignAttributes(cursor,{id:'text_cursor',stroke:'#333','stroke-width':1});getElement('selectorParentGroup').append(cursor);}if(!blinker){blinker=setInterval(function(){const show=cursor.getAttribute('display')==='none';cursor.setAttribute('display',show?'inline':'none');},600);}const startPt=ptToScreen(charbb.x,textbb.y);const endPt=ptToScreen(charbb.x,textbb.y+textbb.height);assignAttributes(cursor,{x1:startPt.x,y1:startPt.y,x2:endPt.x,y2:endPt.y,visibility:'visible',display:'inline'});if(selblock){selblock.setAttribute('d','');}}/**
    *
    * @param {Integer} start
    * @param {Integer} end
    * @param {boolean} skipInput
    * @returns {void}
    */function setSelection(start,end,skipInput){if(start===end){setCursor(end);return;}if(!skipInput){textinput.setSelectionRange(start,end);}selblock=getElement('text_selectblock');if(!selblock){selblock=document.createElementNS(NS.SVG,'path');assignAttributes(selblock,{id:'text_selectblock',fill:'green',opacity:0.5,style:'pointer-events:none'});getElement('selectorParentGroup').append(selblock);}const startbb=chardata[start];const endbb=chardata[end];cursor.setAttribute('visibility','hidden');const tl=ptToScreen(startbb.x,textbb.y);const tr=ptToScreen(startbb.x+(endbb.x-startbb.x),textbb.y);const bl=ptToScreen(startbb.x,textbb.y+textbb.height);const br=ptToScreen(startbb.x+(endbb.x-startbb.x),textbb.y+textbb.height);const dstr='M'+tl.x+','+tl.y+' L'+tr.x+','+tr.y+' '+br.x+','+br.y+' '+bl.x+','+bl.y+'z';assignAttributes(selblock,{d:dstr,display:'inline'});}/**
    *
    * @param {Float} mouseX
    * @param {Float} mouseY
    * @returns {Integer}
    */function getIndexFromPoint(mouseX,mouseY){// Position cursor here
  const pt=svgCanvas$a.getSvgRoot().createSVGPoint();pt.x=mouseX;pt.y=mouseY;// No content, so return 0
  if(chardata.length===1){return 0;}// Determine if cursor should be on left or right of character
  let charpos=curtext.getCharNumAtPosition(pt);if(charpos<0){// Out of text range, look at mouse coords
  charpos=chardata.length-2;if(mouseX<=chardata[0].x){charpos=0;}}else if(charpos>=chardata.length-2){charpos=chardata.length-2;}const charbb=chardata[charpos];const mid=charbb.x+charbb.width/2;if(mouseX>mid){charpos++;}return charpos;}/**
    *
    * @param {Float} mouseX
    * @param {Float} mouseY
    * @returns {void}
    */function setCursorFromPoint(mouseX,mouseY){setCursor(getIndexFromPoint(mouseX,mouseY));}/**
    *
    * @param {Float} x
    * @param {Float} y
    * @param {boolean} apply
    * @returns {void}
    */function setEndSelectionFromPoint(x,y,apply){const i1=textinput.selectionStart;const i2=getIndexFromPoint(x,y);const start=Math.min(i1,i2);const end=Math.max(i1,i2);setSelection(start,end,!apply);}/**
    *
    * @param {Float} xIn
    * @param {Float} yIn
    * @returns {module:math.XYObject}
    */function screenToPt(xIn,yIn){const out={x:xIn,y:yIn};const zoom=svgCanvas$a.getZoom();out.x/=zoom;out.y/=zoom;if(matrix){const pt=transformPoint(out.x,out.y,matrix.inverse());out.x=pt.x;out.y=pt.y;}return out;}/**
    *
    * @param {Float} xIn
    * @param {Float} yIn
    * @returns {module:math.XYObject}
    */function ptToScreen(xIn,yIn){const out={x:xIn,y:yIn};if(matrix){const pt=transformPoint(out.x,out.y,matrix);out.x=pt.x;out.y=pt.y;}const zoom=svgCanvas$a.getZoom();out.x*=zoom;out.y*=zoom;return out;}/**
    *
    * @param {Event} evt
    * @returns {void}
    */function selectAll(evt){setSelection(0,curtext.textContent.length);evt.target.removeEventListener('click',selectAll);}/**
    *
    * @param {Event} evt
    * @returns {void}
    */function selectWord(evt){if(!allowDbl||!curtext){return;}const zoom=svgCanvas$a.getZoom();const ept=transformPoint(evt.pageX,evt.pageY,svgCanvas$a.getrootSctm());const mouseX=ept.x*zoom;const mouseY=ept.y*zoom;const pt=screenToPt(mouseX,mouseY);const index=getIndexFromPoint(pt.x,pt.y);const str=curtext.textContent;const first=str.substr(0,index).replace(/[a-z\d]+$/i,'').length;const m=str.substr(index).match(/^[a-z\d]+/i);const last=(m?m[0].length:0)+index;setSelection(first,last);// Set tripleclick
  svgCanvas$a.$click(evt.target,selectAll);setTimeout(function(){evt.target.removeEventListener('click',selectAll);},300);}return(/** @lends module:svgcanvas.SvgCanvas#textActions */{/**
        * @param {Element} target
        * @param {Float} x
        * @param {Float} y
        * @returns {void}
        */select(target,x,y){curtext=target;svgCanvas$a.textActions.toEditMode(x,y);},/**
        * @param {Element} elem
        * @returns {void}
        */start(elem){curtext=elem;svgCanvas$a.textActions.toEditMode();},/**
        * @param {external:MouseEvent} evt
        * @param {Element} mouseTarget
        * @param {Float} startX
        * @param {Float} startY
        * @returns {void}
        */mouseDown(evt,mouseTarget,startX,startY){const pt=screenToPt(startX,startY);textinput.focus();setCursorFromPoint(pt.x,pt.y);lastX=startX;lastY=startY;// TODO: Find way to block native selection
  },/**
        * @param {Float} mouseX
        * @param {Float} mouseY
        * @returns {void}
        */mouseMove(mouseX,mouseY){const pt=screenToPt(mouseX,mouseY);setEndSelectionFromPoint(pt.x,pt.y);},/**
        * @param {external:MouseEvent} evt
        * @param {Float} mouseX
        * @param {Float} mouseY
        * @returns {void}
        */mouseUp(evt,mouseX,mouseY){const pt=screenToPt(mouseX,mouseY);setEndSelectionFromPoint(pt.x,pt.y,true);// TODO: Find a way to make this work: Use transformed BBox instead of evt.target
  // if (lastX === mouseX && lastY === mouseY
  //   && !rectsIntersect(transbb, {x: pt.x, y: pt.y, width: 0, height: 0})) {
  //   svgCanvas.textActions.toSelectMode(true);
  // }
  if(evt.target!==curtext&&mouseX<lastX+2&&mouseX>lastX-2&&mouseY<lastY+2&&mouseY>lastY-2){svgCanvas$a.textActions.toSelectMode(true);}},/**
        * @function
        * @param {Integer} index
        * @returns {void}
        */setCursor,/**
        * @param {Float} x
        * @param {Float} y
        * @returns {void}
        */toEditMode(x,y){allowDbl=false;svgCanvas$a.setCurrentMode('textedit');svgCanvas$a.selectorManager.requestSelector(curtext).showGrips(false);// Make selector group accept clicks
  /* const selector = */svgCanvas$a.selectorManager.requestSelector(curtext);// Do we need this? Has side effect of setting lock, so keeping for now, but next line wasn't being used
  // const sel = selector.selectorRect;
  svgCanvas$a.textActions.init();curtext.style.cursor='text';// if (supportsEditableText()) {
  //   curtext.setAttribute('editable', 'simple');
  //   return;
  // }
  if(!arguments.length){setCursor();}else {const pt=screenToPt(x,y);setCursorFromPoint(pt.x,pt.y);}setTimeout(function(){allowDbl=true;},300);},/**
        * @param {boolean|Element} selectElem
        * @fires module:svgcanvas.SvgCanvas#event:selected
        * @returns {void}
        */toSelectMode(selectElem){var _curtext;svgCanvas$a.setCurrentMode('select');clearInterval(blinker);blinker=null;if(selblock){selblock.setAttribute('display','none');}if(cursor){cursor.setAttribute('visibility','hidden');}curtext.style.cursor='move';if(selectElem){svgCanvas$a.clearSelection();curtext.style.cursor='move';svgCanvas$a.call('selected',[curtext]);svgCanvas$a.addToSelection([curtext],true);}if(!((_curtext=curtext)!==null&&_curtext!==void 0&&_curtext.textContent.length)){// No content, so delete
  svgCanvas$a.deleteSelectedElements();}textinput.blur();curtext=false;// if (supportsEditableText()) {
  //   curtext.removeAttribute('editable');
  // }
  },/**
        * @param {Element} elem
        * @returns {void}
        */setInputElem(elem){textinput=elem;},/**
        * @returns {void}
        */clear(){if(svgCanvas$a.getCurrentMode()==='textedit'){svgCanvas$a.textActions.toSelectMode();}},/**
        * @param {Element} _inputElem Not in use
        * @returns {void}
        */init(_inputElem){if(!curtext){return;}let i;let end;// if (supportsEditableText()) {
  //   curtext.select();
  //   return;
  // }
  if(!curtext.parentNode){// Result of the ffClone, need to get correct element
  const selectedElements=svgCanvas$a.getSelectedElements();curtext=selectedElements[0];svgCanvas$a.selectorManager.requestSelector(curtext).showGrips(false);}const str=curtext.textContent;const len=str.length;const xform=curtext.getAttribute('transform');textbb=getBBox(curtext);matrix=xform?getMatrix(curtext):null;chardata=[];chardata.length=len;textinput.focus();curtext.removeEventListener('dblclick',selectWord);curtext.addEventListener('dblclick',selectWord);if(!len){end={x:textbb.x+textbb.width/2,width:0};}for(i=0;i<len;i++){const start=curtext.getStartPositionOfChar(i);end=curtext.getEndPositionOfChar(i);if(!supportsGoodTextCharPos()){const zoom=svgCanvas$a.getZoom();const offset=svgCanvas$a.contentW*zoom;start.x-=offset;end.x-=offset;start.x/=zoom;end.x/=zoom;}// Get a "bbox" equivalent for each character. Uses the
  // bbox data of the actual text for y, height purposes
  // TODO: Decide if y, width and height are actually necessary
  chardata[i]={x:start.x,y:textbb.y,// start.y?
  width:end.x-start.x,height:textbb.height};}// Add a last bbox for cursor at end of text
  chardata.push({x:end.x,width:0});setSelection(textinput.selectionStart,textinput.selectionEnd,true);}});}();/**
   * Tools for event.
   * @module event
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */const{InsertElementCommand:InsertElementCommand$2}=history;let svgCanvas$9=null;let moveSelectionThresholdReached=false;/**
  * @function module:undo.init
  * @param {module:undo.eventContext} eventContext
  * @returns {void}
  */const init$9=canvas=>{svgCanvas$9=canvas;svgCanvas$9.mouseDownEvent=mouseDownEvent;svgCanvas$9.mouseMoveEvent=mouseMoveEvent;svgCanvas$9.dblClickEvent=dblClickEvent;svgCanvas$9.mouseUpEvent=mouseUpEvent;svgCanvas$9.mouseOutEvent=mouseOutEvent;svgCanvas$9.DOMMouseScrollEvent=DOMMouseScrollEvent;};const getBsplinePoint=t=>{const spline={x:0,y:0};const p0={x:svgCanvas$9.getControllPoint2('x'),y:svgCanvas$9.getControllPoint2('y')};const p1={x:svgCanvas$9.getControllPoint1('x'),y:svgCanvas$9.getControllPoint1('y')};const p2={x:svgCanvas$9.getStart('x'),y:svgCanvas$9.getStart('y')};const p3={x:svgCanvas$9.getEnd('x'),y:svgCanvas$9.getEnd('y')};const S=1.0/6.0;const t2=t*t;const t3=t2*t;const m=[[-1,3,-3,1],[3,-6,3,0],[-3,0,3,0],[1,4,1,0]];spline.x=S*((p0.x*m[0][0]+p1.x*m[0][1]+p2.x*m[0][2]+p3.x*m[0][3])*t3+(p0.x*m[1][0]+p1.x*m[1][1]+p2.x*m[1][2]+p3.x*m[1][3])*t2+(p0.x*m[2][0]+p1.x*m[2][1]+p2.x*m[2][2]+p3.x*m[2][3])*t+(p0.x*m[3][0]+p1.x*m[3][1]+p2.x*m[3][2]+p3.x*m[3][3]));spline.y=S*((p0.y*m[0][0]+p1.y*m[0][1]+p2.y*m[0][2]+p3.y*m[0][3])*t3+(p0.y*m[1][0]+p1.y*m[1][1]+p2.y*m[1][2]+p3.y*m[1][3])*t2+(p0.y*m[2][0]+p1.y*m[2][1]+p2.y*m[2][2]+p3.y*m[2][3])*t+(p0.y*m[3][0]+p1.y*m[3][1]+p2.y*m[3][2]+p3.y*m[3][3]));return {x:spline.x,y:spline.y};};// update the dummy transform in our transform list
  // to be a translate. We need to check if there was a transformation
  // to avoid loosing it
  const updateTransformList=(svgRoot,element,dx,dy)=>{var _element$transform;const xform=svgRoot.createSVGTransform();xform.setTranslate(dx,dy);const tlist=(_element$transform=element.transform)===null||_element$transform===void 0?void 0:_element$transform.baseVal;if(tlist.numberOfItems){const firstItem=tlist.getItem(0);if(firstItem.type===2){// SVG_TRANSFORM_TRANSLATE = 2
  tlist.replaceItem(xform,0);}else {tlist.insertItemBefore(xform,0);}}else {tlist.appendItem(xform);}};/**
   *
   * @param {MouseEvent} evt
   * @fires module:svgcanvas.SvgCanvas#event:transition
   * @fires module:svgcanvas.SvgCanvas#event:ext_mouseMove
   * @returns {void}
   */const mouseMoveEvent=evt=>{// if the mouse is move without dragging an element, just return.
  if(!svgCanvas$9.getStarted()){return;}if(evt.button===1||svgCanvas$9.spaceKey){return;}svgCanvas$9.textActions.init();evt.preventDefault();const selectedElements=svgCanvas$9.getSelectedElements();const zoom=svgCanvas$9.getZoom();const svgRoot=svgCanvas$9.getSvgRoot();const selected=selectedElements[0];let i;let xya;let cx;let cy;let dx;let dy;let len;let angle;let box;const pt=transformPoint(evt.clientX,evt.clientY,svgCanvas$9.getrootSctm());const mouseX=pt.x*zoom;const mouseY=pt.y*zoom;const shape=getElement(svgCanvas$9.getId());let realX=mouseX/zoom;let x=realX;let realY=mouseY/zoom;let y=realY;if(svgCanvas$9.getCurConfig().gridSnapping){x=snapToGrid(x);y=snapToGrid(y);}let tlist;switch(svgCanvas$9.getCurrentMode()){case'select':{// we temporarily use a translate on the element(s) being dragged
  // this transform is removed upon mousing up and the element is
  // relocated to the new location
  if(selected){dx=x-svgCanvas$9.getStartX();dy=y-svgCanvas$9.getStartY();if(svgCanvas$9.getCurConfig().gridSnapping){dx=snapToGrid(dx);dy=snapToGrid(dy);}// Enable moving selection only if mouse has been moved at least 4 px in any direction
  // This prevents objects from being accidentally moved when (initially) selected
  const deltaThreshold=4;const deltaThresholdReached=Math.abs(dx)>deltaThreshold||Math.abs(dy)>deltaThreshold;moveSelectionThresholdReached=moveSelectionThresholdReached||deltaThresholdReached;if(moveSelectionThresholdReached){selectedElements.forEach(el=>{if(el){updateTransformList(svgRoot,el,dx,dy);// update our internal bbox that we're tracking while dragging
  svgCanvas$9.selectorManager.requestSelector(el).resize();}});svgCanvas$9.call('transition',selectedElements);}}break;}case'multiselect':{realX*=zoom;realY*=zoom;assignAttributes(svgCanvas$9.getRubberBox(),{x:Math.min(svgCanvas$9.getRStartX(),realX),y:Math.min(svgCanvas$9.getRStartY(),realY),width:Math.abs(realX-svgCanvas$9.getRStartX()),height:Math.abs(realY-svgCanvas$9.getRStartY())});// for each selected:
  // - if newList contains selected, do nothing
  // - if newList doesn't contain selected, remove it from selected
  // - for any newList that was not in selectedElements, add it to selected
  const elemsToRemove=selectedElements.slice();const elemsToAdd=[];const newList=svgCanvas$9.getIntersectionList();// For every element in the intersection, add if not present in selectedElements.
  len=newList.length;for(i=0;i<len;++i){const intElem=newList[i];// Found an element that was not selected before, so we should add it.
  if(!selectedElements.includes(intElem)){elemsToAdd.push(intElem);}// Found an element that was already selected, so we shouldn't remove it.
  const foundInd=elemsToRemove.indexOf(intElem);if(foundInd!==-1){elemsToRemove.splice(foundInd,1);}}if(elemsToRemove.length>0){svgCanvas$9.removeFromSelection(elemsToRemove);}if(elemsToAdd.length>0){svgCanvas$9.addToSelection(elemsToAdd);}break;}case'resize':{// we track the resize bounding box and translate/scale the selected element
  // while the mouse is down, when mouse goes up, we use this to recalculate
  // the shape's coordinates
  tlist=selected.transform.baseVal;const hasMatrix=hasMatrixTransform(tlist);box=hasMatrix?svgCanvas$9.getInitBbox():getBBox(selected);let left=box.x;let top=box.y;let{width,height}=box;dx=x-svgCanvas$9.getStartX();dy=y-svgCanvas$9.getStartY();if(svgCanvas$9.getCurConfig().gridSnapping){dx=snapToGrid(dx);dy=snapToGrid(dy);height=snapToGrid(height);width=snapToGrid(width);}// if rotated, adjust the dx,dy values
  angle=getRotationAngle(selected);if(angle){const r=Math.sqrt(dx*dx+dy*dy);const theta=Math.atan2(dy,dx)-angle*Math.PI/180.0;dx=r*Math.cos(theta);dy=r*Math.sin(theta);}// if not stretching in y direction, set dy to 0
  // if not stretching in x direction, set dx to 0
  if(!svgCanvas$9.getCurrentResizeMode().includes('n')&&!svgCanvas$9.getCurrentResizeMode().includes('s')){dy=0;}if(!svgCanvas$9.getCurrentResizeMode().includes('e')&&!svgCanvas$9.getCurrentResizeMode().includes('w')){dx=0;}let// ts = null,
  tx=0;let ty=0;let sy=height?(height+dy)/height:1;let sx=width?(width+dx)/width:1;// if we are dragging on the north side, then adjust the scale factor and ty
  if(svgCanvas$9.getCurrentResizeMode().includes('n')){sy=height?(height-dy)/height:1;ty=height;}// if we dragging on the east side, then adjust the scale factor and tx
  if(svgCanvas$9.getCurrentResizeMode().includes('w')){sx=width?(width-dx)/width:1;tx=width;}// update the transform list with translate,scale,translate
  const translateOrigin=svgRoot.createSVGTransform();const scale=svgRoot.createSVGTransform();const translateBack=svgRoot.createSVGTransform();if(svgCanvas$9.getCurConfig().gridSnapping){left=snapToGrid(left);tx=snapToGrid(tx);top=snapToGrid(top);ty=snapToGrid(ty);}translateOrigin.setTranslate(-(left+tx),-(top+ty));// For images, we maintain aspect ratio by default and relax when shift pressed
  const maintainAspectRatio=selected.tagName!=='image'&&evt.shiftKey||selected.tagName==='image'&&!evt.shiftKey;if(maintainAspectRatio){if(sx===1){sx=sy;}else {sy=sx;}}scale.setScale(sx,sy);translateBack.setTranslate(left+tx,top+ty);if(hasMatrix){const diff=angle?1:0;tlist.replaceItem(translateOrigin,2+diff);tlist.replaceItem(scale,1+diff);tlist.replaceItem(translateBack,Number(diff));}else {const N=tlist.numberOfItems;tlist.replaceItem(translateBack,N-3);tlist.replaceItem(scale,N-2);tlist.replaceItem(translateOrigin,N-1);}svgCanvas$9.selectorManager.requestSelector(selected).resize();svgCanvas$9.call('transition',selectedElements);break;}case'zoom':{realX*=zoom;realY*=zoom;assignAttributes(svgCanvas$9.getRubberBox(),{x:Math.min(svgCanvas$9.getRStartX()*zoom,realX),y:Math.min(svgCanvas$9.getRStartY()*zoom,realY),width:Math.abs(realX-svgCanvas$9.getRStartX()*zoom),height:Math.abs(realY-svgCanvas$9.getRStartY()*zoom)});break;}case'text':{assignAttributes(shape,{x,y});break;}case'line':{if(svgCanvas$9.getCurConfig().gridSnapping){x=snapToGrid(x);y=snapToGrid(y);}let x2=x;let y2=y;if(evt.shiftKey){xya=snapToAngle(svgCanvas$9.getStartX(),svgCanvas$9.getStartY(),x2,y2);x2=xya.x;y2=xya.y;}shape.setAttribute('x2',x2);shape.setAttribute('y2',y2);break;}case'foreignObject':// fall through
  case'square':case'rect':case'image':{// For images, we maintain aspect ratio by default and relax when shift pressed
  const maintainAspectRatio=svgCanvas$9.getCurrentMode()==='square'||svgCanvas$9.getCurrentMode()==='image'&&!evt.shiftKey||svgCanvas$9.getCurrentMode()!=='image'&&evt.shiftKey;let w=Math.abs(x-svgCanvas$9.getStartX());let h=Math.abs(y-svgCanvas$9.getStartY());let newX;let newY;if(maintainAspectRatio){w=h=Math.max(w,h);newX=svgCanvas$9.getStartX()<x?svgCanvas$9.getStartX():svgCanvas$9.getStartX()-w;newY=svgCanvas$9.getStartY()<y?svgCanvas$9.getStartY():svgCanvas$9.getStartY()-h;}else {newX=Math.min(svgCanvas$9.getStartX(),x);newY=Math.min(svgCanvas$9.getStartY(),y);}if(svgCanvas$9.getCurConfig().gridSnapping){w=snapToGrid(w);h=snapToGrid(h);newX=snapToGrid(newX);newY=snapToGrid(newY);}assignAttributes(shape,{width:w,height:h,x:newX,y:newY});break;}case'circle':{cx=Number(shape.getAttribute('cx'));cy=Number(shape.getAttribute('cy'));let rad=Math.sqrt((x-cx)*(x-cx)+(y-cy)*(y-cy));if(svgCanvas$9.getCurConfig().gridSnapping){rad=snapToGrid(rad);}shape.setAttribute('r',rad);break;}case'ellipse':{cx=Number(shape.getAttribute('cx'));cy=Number(shape.getAttribute('cy'));if(svgCanvas$9.getCurConfig().gridSnapping){x=snapToGrid(x);cx=snapToGrid(cx);y=snapToGrid(y);cy=snapToGrid(cy);}shape.setAttribute('rx',Math.abs(x-cx));const ry=Math.abs(evt.shiftKey?x-cx:y-cy);shape.setAttribute('ry',ry);break;}case'fhellipse':case'fhrect':{svgCanvas$9.setFreehand('minx',Math.min(realX,svgCanvas$9.getFreehand('minx')));svgCanvas$9.setFreehand('maxx',Math.max(realX,svgCanvas$9.getFreehand('maxx')));svgCanvas$9.setFreehand('miny',Math.min(realY,svgCanvas$9.getFreehand('miny')));svgCanvas$9.setFreehand('maxy',Math.max(realY,svgCanvas$9.getFreehand('maxy')));}// Fallthrough
  case'fhpath':{// dAttr += + realX + ',' + realY + ' ';
  // shape.setAttribute('points', dAttr);
  svgCanvas$9.setEnd('x',realX);svgCanvas$9.setEnd('y',realY);if(svgCanvas$9.getControllPoint2('x')&&svgCanvas$9.getControllPoint2('y')){for(i=0;i<svgCanvas$9.getStepCount()-1;i++){svgCanvas$9.setParameter(i/svgCanvas$9.getStepCount());svgCanvas$9.setNextParameter((i+1)/svgCanvas$9.getStepCount());svgCanvas$9.setbSpline(getBsplinePoint(svgCanvas$9.getNextParameter()));svgCanvas$9.setNextPos({x:svgCanvas$9.getbSpline('x'),y:svgCanvas$9.getbSpline('y')});svgCanvas$9.setbSpline(getBsplinePoint(svgCanvas$9.getParameter()));svgCanvas$9.setSumDistance(svgCanvas$9.getSumDistance()+Math.sqrt((svgCanvas$9.getNextPos('x')-svgCanvas$9.getbSpline('x'))*(svgCanvas$9.getNextPos('x')-svgCanvas$9.getbSpline('x'))+(svgCanvas$9.getNextPos('y')-svgCanvas$9.getbSpline('y'))*(svgCanvas$9.getNextPos('y')-svgCanvas$9.getbSpline('y'))));if(svgCanvas$9.getSumDistance()>svgCanvas$9.getThreSholdDist()){svgCanvas$9.setSumDistance(svgCanvas$9.getSumDistance()-svgCanvas$9.getThreSholdDist());// Faster than completely re-writing the points attribute.
  const point=svgCanvas$9.getSvgContent().createSVGPoint();point.x=svgCanvas$9.getbSpline('x');point.y=svgCanvas$9.getbSpline('y');shape.points.appendItem(point);}}}svgCanvas$9.setControllPoint2('x',svgCanvas$9.getControllPoint1('x'));svgCanvas$9.setControllPoint2('y',svgCanvas$9.getControllPoint1('y'));svgCanvas$9.setControllPoint1('x',svgCanvas$9.getStart('x'));svgCanvas$9.setControllPoint1('y',svgCanvas$9.getStart('y'));svgCanvas$9.setStart({x:svgCanvas$9.getEnd('x'),y:svgCanvas$9.getEnd('y')});break;// update path stretch line coordinates
  }case'path':// fall through
  case'pathedit':{var _svgCanvas$9$getRubbe;x*=zoom;y*=zoom;if(svgCanvas$9.getCurConfig().gridSnapping){x=snapToGrid(x);y=snapToGrid(y);svgCanvas$9.setStartX(snapToGrid(svgCanvas$9.getStartX()));svgCanvas$9.setStartY(snapToGrid(svgCanvas$9.getStartY()));}if(evt.shiftKey){const{path}=pathModule;let x1;let y1;if(path){x1=path.dragging?path.dragging[0]:svgCanvas$9.getStartX();y1=path.dragging?path.dragging[1]:svgCanvas$9.getStartY();}else {x1=svgCanvas$9.getStartX();y1=svgCanvas$9.getStartY();}xya=snapToAngle(x1,y1,x,y);({x,y}=xya);}if(((_svgCanvas$9$getRubbe=svgCanvas$9.getRubberBox())===null||_svgCanvas$9$getRubbe===void 0?void 0:_svgCanvas$9$getRubbe.getAttribute('display'))!=='none'){realX*=zoom;realY*=zoom;assignAttributes(svgCanvas$9.getRubberBox(),{x:Math.min(svgCanvas$9.getRStartX()*zoom,realX),y:Math.min(svgCanvas$9.getRStartY()*zoom,realY),width:Math.abs(realX-svgCanvas$9.getRStartX()*zoom),height:Math.abs(realY-svgCanvas$9.getRStartY()*zoom)});}svgCanvas$9.pathActions.mouseMove(x,y);break;}case'textedit':{x*=zoom;y*=zoom;svgCanvas$9.textActions.mouseMove(mouseX,mouseY);break;}case'rotate':{box=getBBox(selected);cx=box.x+box.width/2;cy=box.y+box.height/2;const m=getMatrix(selected);const center=transformPoint(cx,cy,m);cx=center.x;cy=center.y;angle=(Math.atan2(cy-y,cx-x)*(180/Math.PI)-90)%360;if(svgCanvas$9.getCurConfig().gridSnapping){angle=snapToGrid(angle);}if(evt.shiftKey){// restrict rotations to nice angles (WRS)
  const snap=45;angle=Math.round(angle/snap)*snap;}svgCanvas$9.setRotationAngle(angle<-180?360+angle:angle,true);svgCanvas$9.call('transition',selectedElements);break;}}/**
    * The mouse has moved on the canvas area.
    * @event module:svgcanvas.SvgCanvas#event:ext_mouseMove
    * @type {PlainObject}
    * @property {MouseEvent} event The event object
    * @property {Float} mouse_x x coordinate on canvas
    * @property {Float} mouse_y y coordinate on canvas
    * @property {Element} selected Refers to the first selected element
    */svgCanvas$9.runExtensions('mouseMove',/** @type {module:svgcanvas.SvgCanvas#event:ext_mouseMove} */{event:evt,mouse_x:mouseX,mouse_y:mouseY,selected});};// mouseMove()
  /**
  *
  * @returns {void}
  */const mouseOutEvent=()=>{const{$id}=svgCanvas$9;if(svgCanvas$9.getCurrentMode()!=='select'&&svgCanvas$9.getStarted()){const event=new Event('mouseup');$id('svgcanvas').dispatchEvent(event);}};// - in create mode, the element's opacity is set properly, we create an InsertElementCommand
  // and store it on the Undo stack
  // - in move/resize mode, the element's attributes which were affected by the move/resize are
  // identified, a ChangeElementCommand is created and stored on the stack for those attrs
  // this is done in when we recalculate the selected dimensions()
  /**
  *
  * @param {MouseEvent} evt
  * @fires module:svgcanvas.SvgCanvas#event:zoomed
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @fires module:svgcanvas.SvgCanvas#event:ext_mouseUp
  * @returns {void}
  */const mouseUpEvent=evt=>{moveSelectionThresholdReached=false;if(evt.button===2){return;}if(!svgCanvas$9.getStarted()){return;}svgCanvas$9.textActions.init();const selectedElements=svgCanvas$9.getSelectedElements();const zoom=svgCanvas$9.getZoom();const tempJustSelected=svgCanvas$9.getJustSelected();svgCanvas$9.setJustSelected(null);const pt=transformPoint(evt.clientX,evt.clientY,svgCanvas$9.getrootSctm());const mouseX=pt.x*zoom;const mouseY=pt.y*zoom;const x=mouseX/zoom;const y=mouseY/zoom;let element=getElement(svgCanvas$9.getId());let keep=false;const realX=x;const realY=y;svgCanvas$9.setStarted(false);let t;switch(svgCanvas$9.getCurrentMode()){// intentionally fall-through to select here
  case'resize':case'multiselect':if(svgCanvas$9.getRubberBox()){svgCanvas$9.getRubberBox().setAttribute('display','none');svgCanvas$9.setCurBBoxes([]);}svgCanvas$9.setCurrentMode('select');// Fallthrough
  case'select':if(selectedElements[0]){// if we only have one selected element
  if(!selectedElements[1]){// set our current stroke/fill properties to the element's
  const selected=selectedElements[0];switch(selected.tagName){case'g':case'use':case'image':case'foreignObject':break;case'text':svgCanvas$9.setCurText('font_size',selected.getAttribute('font-size'));svgCanvas$9.setCurText('font_family',selected.getAttribute('font-family'));// fallthrough
  default:svgCanvas$9.setCurProperties('fill',selected.getAttribute('fill'));svgCanvas$9.setCurProperties('fill_opacity',selected.getAttribute('fill-opacity'));svgCanvas$9.setCurProperties('stroke',selected.getAttribute('stroke'));svgCanvas$9.setCurProperties('stroke_opacity',selected.getAttribute('stroke-opacity'));svgCanvas$9.setCurProperties('stroke_width',selected.getAttribute('stroke-width'));svgCanvas$9.setCurProperties('stroke_dasharray',selected.getAttribute('stroke-dasharray'));svgCanvas$9.setCurProperties('stroke_linejoin',selected.getAttribute('stroke-linejoin'));svgCanvas$9.setCurProperties('stroke_linecap',selected.getAttribute('stroke-linecap'));}svgCanvas$9.selectorManager.requestSelector(selected).showGrips(true);}// always recalculate dimensions to strip off stray identity transforms
  svgCanvas$9.recalculateAllSelectedDimensions();// if it was being dragged/resized
  if(realX!==svgCanvas$9.getRStartX()||realY!==svgCanvas$9.getRStartY()){const len=selectedElements.length;for(let i=0;i<len;++i){if(!selectedElements[i]){break;}svgCanvas$9.selectorManager.requestSelector(selectedElements[i]).resize();}// no change in position/size, so maybe we should move to pathedit
  }else {t=evt.target;if(selectedElements[0].nodeName==='path'&&!selectedElements[1]){svgCanvas$9.pathActions.select(selectedElements[0]);// if it was a path
  // else, if it was selected and this is a shift-click, remove it from selection
  }else if(evt.shiftKey&&tempJustSelected!==t){svgCanvas$9.removeFromSelection([t]);}}// no change in mouse position
  // Remove non-scaling stroke
  const elem=selectedElements[0];if(elem){elem.removeAttribute('style');walkTree(elem,el=>{el.removeAttribute('style');});}}return;case'zoom':{var _svgCanvas$9$getRubbe2;(_svgCanvas$9$getRubbe2=svgCanvas$9.getRubberBox())===null||_svgCanvas$9$getRubbe2===void 0?void 0:_svgCanvas$9$getRubbe2.setAttribute('display','none');const factor=evt.shiftKey?0.5:2;svgCanvas$9.call('zoomed',{x:Math.min(svgCanvas$9.getRStartX(),realX),y:Math.min(svgCanvas$9.getRStartY(),realY),width:Math.abs(realX-svgCanvas$9.getRStartX()),height:Math.abs(realY-svgCanvas$9.getRStartY()),factor});return;}case'fhpath':{// Check that the path contains at least 2 points; a degenerate one-point path
  // causes problems.
  // Webkit ignores how we set the points attribute with commas and uses space
  // to separate all coordinates, see https://bugs.webkit.org/show_bug.cgi?id=29870
  svgCanvas$9.setSumDistance(0);svgCanvas$9.setControllPoint2('x',0);svgCanvas$9.setControllPoint2('y',0);svgCanvas$9.setControllPoint1('x',0);svgCanvas$9.setControllPoint1('y',0);svgCanvas$9.setStart({x:0,y:0});svgCanvas$9.setEnd('x',0);svgCanvas$9.setEnd('y',0);const coords=element.getAttribute('points');const commaIndex=coords.indexOf(',');keep=commaIndex>=0?coords.includes(',',commaIndex+1):coords.includes(' ',coords.indexOf(' ')+1);if(keep){element=svgCanvas$9.pathActions.smoothPolylineIntoPath(element);}break;}case'line':{const x1=element.getAttribute('x1');const y1=element.getAttribute('y1');const x2=element.getAttribute('x2');const y2=element.getAttribute('y2');keep=x1!==x2||y1!==y2;}break;case'foreignObject':case'square':case'rect':case'image':{const width=element.getAttribute('width');const height=element.getAttribute('height');// Image should be kept regardless of size (use inherit dimensions later)
  keep=width||height||svgCanvas$9.getCurrentMode()==='image';}break;case'circle':keep=element.getAttribute('r')!=='0';break;case'ellipse':{const rx=Number(element.getAttribute('rx'));const ry=Number(element.getAttribute('ry'));keep=rx||ry;}break;case'fhellipse':if(svgCanvas$9.getFreehand('maxx')-svgCanvas$9.getFreehand('minx')>0&&svgCanvas$9.getFreehand('maxy')-svgCanvas$9.getFreehand('miny')>0){element=svgCanvas$9.addSVGElementsFromJson({element:'ellipse',curStyles:true,attr:{cx:(svgCanvas$9.getFreehand('minx')+svgCanvas$9.getFreehand('maxx'))/2,cy:(svgCanvas$9.getFreehand('miny')+svgCanvas$9.getFreehand('maxy'))/2,rx:(svgCanvas$9.getFreehand('maxx')-svgCanvas$9.getFreehand('minx'))/2,ry:(svgCanvas$9.getFreehand('maxy')-svgCanvas$9.getFreehand('miny'))/2,id:svgCanvas$9.getId()}});svgCanvas$9.call('changed',[element]);keep=true;}break;case'fhrect':if(svgCanvas$9.getFreehand('maxx')-svgCanvas$9.getFreehand('minx')>0&&svgCanvas$9.getFreehand('maxy')-svgCanvas$9.getFreehand('miny')>0){element=svgCanvas$9.addSVGElementsFromJson({element:'rect',curStyles:true,attr:{x:svgCanvas$9.getFreehand('minx'),y:svgCanvas$9.getFreehand('miny'),width:svgCanvas$9.getFreehand('maxx')-svgCanvas$9.getFreehand('minx'),height:svgCanvas$9.getFreehand('maxy')-svgCanvas$9.getFreehand('miny'),id:svgCanvas$9.getId()}});svgCanvas$9.call('changed',[element]);keep=true;}break;case'text':keep=true;svgCanvas$9.selectOnly([element]);svgCanvas$9.textActions.start(element);break;case'path':{// set element to null here so that it is not removed nor finalized
  element=null;// continue to be set to true so that mouseMove happens
  svgCanvas$9.setStarted(true);const res=svgCanvas$9.pathActions.mouseUp(evt,element,mouseX,mouseY);({element}=res);({keep}=res);break;}case'pathedit':keep=true;element=null;svgCanvas$9.pathActions.mouseUp(evt);break;case'textedit':keep=false;element=null;svgCanvas$9.textActions.mouseUp(evt,mouseX,mouseY);break;case'rotate':{keep=true;element=null;svgCanvas$9.setCurrentMode('select');const batchCmd=svgCanvas$9.undoMgr.finishUndoableChange();if(!batchCmd.isEmpty()){svgCanvas$9.addCommandToHistory(batchCmd);}// perform recalculation to weed out any stray identity transforms that might get stuck
  svgCanvas$9.recalculateAllSelectedDimensions();svgCanvas$9.call('changed',selectedElements);break;}}/**
    * The main (left) mouse button is released (anywhere).
    * @event module:svgcanvas.SvgCanvas#event:ext_mouseUp
    * @type {PlainObject}
    * @property {MouseEvent} event The event object
    * @property {Float} mouse_x x coordinate on canvas
    * @property {Float} mouse_y y coordinate on canvas
    */const extResult=svgCanvas$9.runExtensions('mouseUp',{event:evt,mouse_x:mouseX,mouse_y:mouseY},true);extResult.forEach(r=>{if(r){keep=r.keep||keep;({element}=r);svgCanvas$9.setStarted(r.started||svgCanvas$9.getStarted());}});if(!keep&&element){var _t$parentNode;svgCanvas$9.getCurrentDrawing().releaseId(svgCanvas$9.getId());element.remove();element=null;t=evt.target;// if this element is in a group, go up until we reach the top-level group
  // just below the layer groups
  // TODO: once we implement links, we also would have to check for <a> elements
  while(((_t2=t)===null||_t2===void 0?void 0:(_t2$parentNode=_t2.parentNode)===null||_t2$parentNode===void 0?void 0:(_t2$parentNode$parent=_t2$parentNode.parentNode)===null||_t2$parentNode$parent===void 0?void 0:_t2$parentNode$parent.tagName)==='g'){var _t2,_t2$parentNode,_t2$parentNode$parent;t=t.parentNode;}// if we are not in the middle of creating a path, and we've clicked on some shape,
  // then go to Select mode.
  // WebKit returns <div> when the canvas is clicked, Firefox/Opera return <svg>
  if((svgCanvas$9.getCurrentMode()!=='path'||!svgCanvas$9.getDrawnPath())&&t&&((_t$parentNode=t.parentNode)===null||_t$parentNode===void 0?void 0:_t$parentNode.id)!=='selectorParentGroup'&&t.id!=='svgcanvas'&&t.id!=='svgroot'){// switch into "select" mode if we've clicked on an element
  svgCanvas$9.setMode('select');svgCanvas$9.selectOnly([t],true);}}else if(element){/**
      * @name module:svgcanvas.SvgCanvas#addedNew
      * @type {boolean}
      */svgCanvas$9.addedNew=true;let aniDur=0.2;let cAni;const curShape=svgCanvas$9.getStyle();const opacAni=svgCanvas$9.getOpacAni();if(opacAni.beginElement&&Number.parseFloat(element.getAttribute('opacity'))!==curShape.opacity){cAni=opacAni.cloneNode(true);cAni.setAttribute('to',curShape.opacity);cAni.setAttribute('dur',aniDur);element.appendChild(cAni);try{// Fails in FF4 on foreignObject
  cAni.beginElement();}catch(e){/* empty fn */}}else {aniDur=0;}// Ideally this would be done on the endEvent of the animation,
  // but that doesn't seem to be supported in Webkit
  setTimeout(()=>{if(cAni){cAni.remove();}element.setAttribute('opacity',curShape.opacity);element.setAttribute('style','pointer-events:inherit');cleanupElement(element);if(svgCanvas$9.getCurrentMode()==='path'){svgCanvas$9.pathActions.toEditMode(element);}else if(svgCanvas$9.getCurConfig().selectNew){const modes=['circle','ellipse','square','rect','fhpath','line','fhellipse','fhrect','star','polygon'];if(modes.indexOf(svgCanvas$9.getCurrentMode())!==-1){svgCanvas$9.setMode('select');}svgCanvas$9.selectOnly([element],true);}// we create the insert command that is stored on the stack
  // undo means to call cmd.unapply(), redo means to call cmd.apply()
  svgCanvas$9.addCommandToHistory(new InsertElementCommand$2(element));svgCanvas$9.call('changed',[element]);},aniDur*1000);}svgCanvas$9.setStartTransform(null);};const dblClickEvent=evt=>{const selectedElements=svgCanvas$9.getSelectedElements();const evtTarget=evt.target;const parent=evtTarget.parentNode;let mouseTarget=svgCanvas$9.getMouseTarget(evt);const{tagName}=mouseTarget;if(tagName==='text'&&svgCanvas$9.getCurrentMode()!=='textedit'){const pt=transformPoint(evt.clientX,evt.clientY,svgCanvas$9.getrootSctm());svgCanvas$9.textActions.select(mouseTarget,pt.x,pt.y);}// Do nothing if already in current group
  if(parent===svgCanvas$9.getCurrentGroup()){return;}if((tagName==='g'||tagName==='a')&&getRotationAngle(mouseTarget)){// TODO: Allow method of in-group editing without having to do
  // this (similar to editing rotated paths)
  // Ungroup and regroup
  svgCanvas$9.pushGroupProperties(mouseTarget);mouseTarget=selectedElements[0];svgCanvas$9.clearSelection(true);}// Reset context
  if(svgCanvas$9.getCurrentGroup()){leaveContext();}if(parent.tagName!=='g'&&parent.tagName!=='a'||parent===svgCanvas$9.getCurrentDrawing().getCurrentLayer()||mouseTarget===svgCanvas$9.selectorManager.selectorParentGroup){// Escape from in-group edit
  return;}setContext(mouseTarget);};/**
   * Follows these conditions:
   * - When we are in a create mode, the element is added to the canvas but the
   *   action is not recorded until mousing up.
   * - When we are in select mode, select the element, remember the position
   *   and do nothing else.
   * @param {MouseEvent} evt
   * @fires module:svgcanvas.SvgCanvas#event:ext_mouseDown
   * @returns {void}
   */const mouseDownEvent=evt=>{const dataStorage=svgCanvas$9.getDataStorage();const selectedElements=svgCanvas$9.getSelectedElements();const zoom=svgCanvas$9.getZoom();const curShape=svgCanvas$9.getStyle();const svgRoot=svgCanvas$9.getSvgRoot();const{$id}=svgCanvas$9;if(svgCanvas$9.spaceKey||evt.button===1){return;}const rightClick=evt.button===2;if(evt.altKey){// duplicate when dragging
  svgCanvas$9.cloneSelectedElements(0,0);}svgCanvas$9.setRootSctm($id('svgcontent').querySelector('g').getScreenCTM().inverse());const pt=transformPoint(evt.clientX,evt.clientY,svgCanvas$9.getrootSctm());const mouseX=pt.x*zoom;const mouseY=pt.y*zoom;evt.preventDefault();if(rightClick){if(svgCanvas$9.getCurrentMode()==='path'){return;}svgCanvas$9.setCurrentMode('select');svgCanvas$9.setLastClickPoint(pt);}let x=mouseX/zoom;let y=mouseY/zoom;let mouseTarget=svgCanvas$9.getMouseTarget(evt);if(mouseTarget.tagName==='a'&&mouseTarget.childNodes.length===1){mouseTarget=mouseTarget.firstChild;}// realX/y ignores grid-snap value
  const realX=x;svgCanvas$9.setStartX(x);svgCanvas$9.setRStartX(x);const realY=y;svgCanvas$9.setStartY(y);svgCanvas$9.setRStartY(y);if(svgCanvas$9.getCurConfig().gridSnapping){x=snapToGrid(x);y=snapToGrid(y);svgCanvas$9.setStartX(snapToGrid(svgCanvas$9.getStartX()));svgCanvas$9.setStartY(snapToGrid(svgCanvas$9.getStartY()));}// if it is a selector grip, then it must be a single element selected,
  // set the mouseTarget to that and update the mode to rotate/resize
  if(mouseTarget===svgCanvas$9.selectorManager.selectorParentGroup&&selectedElements[0]){const grip=evt.target;const griptype=dataStorage.get(grip,'type');// rotating
  if(griptype==='rotate'){svgCanvas$9.setCurrentMode('rotate');// svgCanvas.setCurrentRotateMode(dataStorage.get(grip, 'dir'));
  // resizing
  }else if(griptype==='resize'){svgCanvas$9.setCurrentMode('resize');svgCanvas$9.setCurrentResizeMode(dataStorage.get(grip,'dir'));}mouseTarget=selectedElements[0];}svgCanvas$9.setStartTransform(mouseTarget.getAttribute('transform'));const tlist=mouseTarget.transform.baseVal;// consolidate transforms using standard SVG but keep the transformation used for the move/scale
  if(tlist.numberOfItems>1){const firstTransform=tlist.getItem(0);tlist.removeItem(0);tlist.consolidate();tlist.insertItemBefore(firstTransform,0);}switch(svgCanvas$9.getCurrentMode()){case'select':svgCanvas$9.setStarted(true);svgCanvas$9.setCurrentResizeMode('none');if(rightClick){svgCanvas$9.setStarted(false);}if(mouseTarget!==svgRoot){// if this element is not yet selected, clear selection and select it
  if(!selectedElements.includes(mouseTarget)){// only clear selection if shift is not pressed (otherwise, add
  // element to selection)
  if(!evt.shiftKey){// No need to do the call here as it will be done on addToSelection
  svgCanvas$9.clearSelection(true);}svgCanvas$9.addToSelection([mouseTarget]);svgCanvas$9.setJustSelected(mouseTarget);svgCanvas$9.pathActions.clear();}// else if it's a path, go into pathedit mode in mouseup
  if(!rightClick){// insert a dummy transform so if the element(s) are moved it will have
  // a transform to use for its translate
  for(const selectedElement of selectedElements){var _selectedElement$tran;if(!selectedElement){continue;}const slist=(_selectedElement$tran=selectedElement.transform)===null||_selectedElement$tran===void 0?void 0:_selectedElement$tran.baseVal;if(slist.numberOfItems){slist.insertItemBefore(svgRoot.createSVGTransform(),0);}else {slist.appendItem(svgRoot.createSVGTransform());}}}}else if(!rightClick){svgCanvas$9.clearSelection();svgCanvas$9.setCurrentMode('multiselect');if(!svgCanvas$9.getRubberBox()){svgCanvas$9.setRubberBox(svgCanvas$9.selectorManager.getRubberBandBox());}svgCanvas$9.setRStartX(svgCanvas$9.getRStartX()*zoom);svgCanvas$9.setRStartY(svgCanvas$9.getRStartY()*zoom);assignAttributes(svgCanvas$9.getRubberBox(),{x:svgCanvas$9.getRStartX(),y:svgCanvas$9.getRStartY(),width:0,height:0,display:'inline'});}break;case'zoom':svgCanvas$9.setStarted(true);if(!svgCanvas$9.getRubberBox()){svgCanvas$9.setRubberBox(svgCanvas$9.selectorManager.getRubberBandBox());}assignAttributes(svgCanvas$9.getRubberBox(),{x:realX*zoom,y:realX*zoom,width:0,height:0,display:'inline'});break;case'resize':{svgCanvas$9.setStarted(true);svgCanvas$9.setStartX(x);svgCanvas$9.setStartY(y);// Getting the BBox from the selection box, since we know we
  // want to orient around it
  svgCanvas$9.setInitBbox(getBBox($id('selectedBox0')));const bb={};for(const[key,val]of Object.entries(svgCanvas$9.getInitBbox())){bb[key]=val/zoom;}svgCanvas$9.setInitBbox(bb);// append three dummy transforms to the tlist so that
  // we can translate,scale,translate in mousemove
  const pos=getRotationAngle(mouseTarget)?1:0;if(hasMatrixTransform(tlist)){tlist.insertItemBefore(svgRoot.createSVGTransform(),pos);tlist.insertItemBefore(svgRoot.createSVGTransform(),pos);tlist.insertItemBefore(svgRoot.createSVGTransform(),pos);}else {tlist.appendItem(svgRoot.createSVGTransform());tlist.appendItem(svgRoot.createSVGTransform());tlist.appendItem(svgRoot.createSVGTransform());}break;}case'fhellipse':case'fhrect':case'fhpath':svgCanvas$9.setStart({x:realX,y:realY});svgCanvas$9.setControllPoint1('x',0);svgCanvas$9.setControllPoint1('y',0);svgCanvas$9.setControllPoint2('x',0);svgCanvas$9.setControllPoint2('y',0);svgCanvas$9.setStarted(true);svgCanvas$9.setDAttr(realX+','+realY+' ');// Commented out as doing nothing now:
  // strokeW = parseFloat(curShape.stroke_width) === 0 ? 1 : curShape.stroke_width;
  svgCanvas$9.addSVGElementsFromJson({element:'polyline',curStyles:true,attr:{points:svgCanvas$9.getDAttr(),id:svgCanvas$9.getNextId(),fill:'none',opacity:curShape.opacity/2,'stroke-linecap':'round',style:'pointer-events:none'}});svgCanvas$9.setFreehand('minx',realX);svgCanvas$9.setFreehand('maxx',realX);svgCanvas$9.setFreehand('miny',realY);svgCanvas$9.setFreehand('maxy',realY);break;case'image':{svgCanvas$9.setStarted(true);const newImage=svgCanvas$9.addSVGElementsFromJson({element:'image',attr:{x,y,width:0,height:0,id:svgCanvas$9.getNextId(),opacity:curShape.opacity/2,style:'pointer-events:inherit'}});setHref(newImage,svgCanvas$9.getLastGoodImgUrl());preventClickDefault(newImage);break;}case'square':// TODO: once we create the rect, we lose information that this was a square
  // (for resizing purposes this could be important)
  // Fallthrough
  case'rect':svgCanvas$9.setStarted(true);svgCanvas$9.setStartX(x);svgCanvas$9.setStartY(y);svgCanvas$9.addSVGElementsFromJson({element:'rect',curStyles:true,attr:{x,y,width:0,height:0,id:svgCanvas$9.getNextId(),opacity:curShape.opacity/2}});break;case'line':{svgCanvas$9.setStarted(true);const strokeW=Number(curShape.stroke_width)===0?1:curShape.stroke_width;svgCanvas$9.addSVGElementsFromJson({element:'line',curStyles:true,attr:{x1:x,y1:y,x2:x,y2:y,id:svgCanvas$9.getNextId(),stroke:curShape.stroke,'stroke-width':strokeW,'stroke-dasharray':curShape.stroke_dasharray,'stroke-linejoin':curShape.stroke_linejoin,'stroke-linecap':curShape.stroke_linecap,'stroke-opacity':curShape.stroke_opacity,fill:'none',opacity:curShape.opacity/2,style:'pointer-events:none'}});break;}case'circle':svgCanvas$9.setStarted(true);svgCanvas$9.addSVGElementsFromJson({element:'circle',curStyles:true,attr:{cx:x,cy:y,r:0,id:svgCanvas$9.getNextId(),opacity:curShape.opacity/2}});break;case'ellipse':svgCanvas$9.setStarted(true);svgCanvas$9.addSVGElementsFromJson({element:'ellipse',curStyles:true,attr:{cx:x,cy:y,rx:0,ry:0,id:svgCanvas$9.getNextId(),opacity:curShape.opacity/2}});break;case'text':svgCanvas$9.setStarted(true);/* const newText = */svgCanvas$9.addSVGElementsFromJson({element:'text',curStyles:true,attr:{x,y,id:svgCanvas$9.getNextId(),fill:svgCanvas$9.getCurText('fill'),'stroke-width':svgCanvas$9.getCurText('stroke_width'),'font-size':svgCanvas$9.getCurText('font_size'),'font-family':svgCanvas$9.getCurText('font_family'),'text-anchor':'middle','xml:space':'preserve',opacity:curShape.opacity}});// newText.textContent = 'text';
  break;case'path':// Fall through
  case'pathedit':svgCanvas$9.setStartX(svgCanvas$9.getStartX()*zoom);svgCanvas$9.setStartY(svgCanvas$9.getStartY()*zoom);svgCanvas$9.pathActions.mouseDown(evt,mouseTarget,svgCanvas$9.getStartX(),svgCanvas$9.getStartY());svgCanvas$9.setStarted(true);break;case'textedit':svgCanvas$9.setStartX(svgCanvas$9.getStartX()*zoom);svgCanvas$9.setStartY(svgCanvas$9.getStartY()*zoom);svgCanvas$9.textActions.mouseDown(evt,mouseTarget,svgCanvas$9.getStartX(),svgCanvas$9.getStartY());svgCanvas$9.setStarted(true);break;case'rotate':svgCanvas$9.setStarted(true);// we are starting an undoable change (a drag-rotation)
  svgCanvas$9.undoMgr.beginUndoableChange('transform',selectedElements);break;}/**
    * The main (left) mouse button is held down on the canvas area.
    * @event module:svgcanvas.SvgCanvas#event:ext_mouseDown
    * @type {PlainObject}
    * @property {MouseEvent} event The event object
    * @property {Float} start_x x coordinate on canvas
    * @property {Float} start_y y coordinate on canvas
    * @property {Element[]} selectedElements An array of the selected Elements
    */const extResult=svgCanvas$9.runExtensions('mouseDown',{event:evt,start_x:svgCanvas$9.getStartX(),start_y:svgCanvas$9.getStartY(),selectedElements},true);extResult.forEach(r=>{if(r!==null&&r!==void 0&&r.started){svgCanvas$9.setStarted(true);}});};/**
   * @param {Event} e
   * @fires module:event.SvgCanvas#event:updateCanvas
   * @fires module:event.SvgCanvas#event:zoomDone
   * @returns {void}
   */const DOMMouseScrollEvent=e=>{const zoom=svgCanvas$9.getZoom();const{$id}=svgCanvas$9;if(!e.shiftKey){return;}e.preventDefault();svgCanvas$9.setRootSctm($id('svgcontent').querySelector('g').getScreenCTM().inverse());const workarea=document.getElementById('workarea');const scrbar=15;const rulerwidth=svgCanvas$9.getCurConfig().showRulers?16:0;// mouse relative to content area in content pixels
  const pt=transformPoint(e.clientX,e.clientY,svgCanvas$9.getrootSctm());// full work area width in screen pixels
  const editorFullW=parseFloat(getComputedStyle(workarea,null).width.replace('px',''));const editorFullH=parseFloat(getComputedStyle(workarea,null).height.replace('px',''));// work area width minus scroll and ruler in screen pixels
  const editorW=editorFullW-scrbar-rulerwidth;const editorH=editorFullH-scrbar-rulerwidth;// work area width in content pixels
  const workareaViewW=editorW*svgCanvas$9.getrootSctm().a;const workareaViewH=editorH*svgCanvas$9.getrootSctm().d;// content offset from canvas in screen pixels
  const wOffset=findPos$1(workarea);const wOffsetLeft=wOffset.left+rulerwidth;const wOffsetTop=wOffset.top+rulerwidth;const delta=e.wheelDelta?e.wheelDelta:e.detail?-e.detail:0;if(!delta){return;}let factor=Math.max(3/4,Math.min(4/3,delta));let wZoom;let hZoom;if(factor>1){wZoom=Math.ceil(editorW/workareaViewW*factor*100)/100;hZoom=Math.ceil(editorH/workareaViewH*factor*100)/100;}else {wZoom=Math.floor(editorW/workareaViewW*factor*100)/100;hZoom=Math.floor(editorH/workareaViewH*factor*100)/100;}let zoomlevel=Math.min(wZoom,hZoom);zoomlevel=Math.min(10,Math.max(0.01,zoomlevel));if(zoomlevel===zoom){return;}factor=zoomlevel/zoom;// top left of workarea in content pixels before zoom
  const topLeftOld=transformPoint(wOffsetLeft,wOffsetTop,svgCanvas$9.getrootSctm());// top left of workarea in content pixels after zoom
  const topLeftNew={x:pt.x-(pt.x-topLeftOld.x)/factor,y:pt.y-(pt.y-topLeftOld.y)/factor};// top left of workarea in canvas pixels relative to content after zoom
  const topLeftNewCanvas={x:topLeftNew.x*zoomlevel,y:topLeftNew.y*zoomlevel};// new center in canvas pixels
  const newCtr={x:topLeftNewCanvas.x-rulerwidth+editorFullW/2,y:topLeftNewCanvas.y-rulerwidth+editorFullH/2};svgCanvas$9.setZoom(zoomlevel);document.getElementById('zoom').value=(zoomlevel*100).toFixed(1);svgCanvas$9.call('updateCanvas',{center:false,newCtr});svgCanvas$9.call('zoomDone');};/**
   * Tools for SVG handle on JSON format.
   * @module svgcanvas
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */let svgCanvas$8=null;let svgdoc_=null;/**
   * @function module:json.jsonContext#getSelectedElements
   * @returns {Element[]} the array with selected DOM elements
  */ /**
   * @function module:json.jsonContext#getDOMDocument
   * @returns {HTMLDocument}
  */ /**
  * @function module:json.init
  * @param {module:json.jsonContext} jsonContext
  * @returns {void}
  */const init$8=canvas=>{svgCanvas$8=canvas;svgdoc_=canvas.getDOMDocument();};/**
  * @function module:json.getJsonFromSvgElements Iterate element and return json format
  * @param {ArgumentsArray} data - element
  * @returns {svgRootElement}
  */const getJsonFromSvgElements=data=>{// Text node
  if(data.nodeType===3)return data.nodeValue;const retval={element:data.tagName,// namespace: nsMap[data.namespaceURI],
  attr:{},children:[]};// Iterate attributes
  for(let i=0,attr;attr=data.attributes[i];i++){retval.attr[attr.name]=attr.value;}// Iterate children
  for(let i=0,node;node=data.childNodes[i];i++){retval.children[i]=getJsonFromSvgElements(node);}return retval;};/**
  * This should really be an intersection implementing all rather than a union.
  * @name module:json.addSVGElementsFromJson
  * @type {module:utilities.EditorContext#addSVGElementsFromJson|module:path.EditorContext#addSVGElementsFromJson}
  */const addSVGElementsFromJson=data=>{if(typeof data==='string')return svgdoc_.createTextNode(data);let shape=getElement(data.attr.id);// if shape is a path but we need to create a rect/ellipse, then remove the path
  const currentLayer=svgCanvas$8.getDrawing().getCurrentLayer();if(shape&&data.element!==shape.tagName){shape.remove();shape=null;}if(!shape){const ns=data.namespace||NS.SVG;shape=svgdoc_.createElementNS(ns,data.element);if(currentLayer){(svgCanvas$8.getCurrentGroup()||currentLayer).append(shape);}}const curShape=svgCanvas$8.getCurShape();if(data.curStyles){assignAttributes(shape,{fill:curShape.fill,stroke:curShape.stroke,'stroke-width':curShape.strokeWidth,'stroke-dasharray':curShape.stroke_dasharray,'stroke-linejoin':curShape.stroke_linejoin,'stroke-linecap':curShape.stroke_linecap,'stroke-opacity':curShape.stroke_opacity,'fill-opacity':curShape.fill_opacity,opacity:curShape.opacity/2,style:'pointer-events:inherit'});}assignAttributes(shape,data.attr);cleanupElement(shape);// Children
  if(data.children){data.children.forEach(child=>{shape.append(addSVGElementsFromJson(child));});}return shape;};/**
   * @module elem-get-set get and set methods.
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */let svgCanvas$7=null;/**
  * @function module:elem-get-set.init
  * @param {module:elem-get-set.elemContext} elemContext
  * @returns {void}
  */const init$7=canvas=>{svgCanvas$7=canvas;svgCanvas$7.getBold=getBoldMethod;// Check whether selected element is bold or not.
  svgCanvas$7.setBold=setBoldMethod;// Make the selected element bold or normal.
  svgCanvas$7.getItalic=getItalicMethod;// Check whether selected element is in italics or not.
  svgCanvas$7.setItalic=setItalicMethod;// Make the selected element italic or normal.
  svgCanvas$7.hasTextDecoration=hasTextDecorationMethod;// Check whether the selected element has the given text decoration or not.
  svgCanvas$7.addTextDecoration=addTextDecorationMethod;// Adds the given value to the text decoration
  svgCanvas$7.removeTextDecoration=removeTextDecorationMethod;// Removes the given value from the text decoration
  svgCanvas$7.setTextAnchor=setTextAnchorMethod;// Set the new text anchor.
  svgCanvas$7.setLetterSpacing=setLetterSpacingMethod;// Set the new letter spacing.
  svgCanvas$7.setWordSpacing=setWordSpacingMethod;// Set the new word spacing.
  svgCanvas$7.setTextLength=setTextLengthMethod;// Set the new text length.
  svgCanvas$7.setLengthAdjust=setLengthAdjustMethod;// Set the new length adjust.
  svgCanvas$7.getFontFamily=getFontFamilyMethod;// The current font family
  svgCanvas$7.setFontFamily=setFontFamilyMethod;// Set the new font family.
  svgCanvas$7.setFontColor=setFontColorMethod;// Set the new font color.
  svgCanvas$7.getFontColor=getFontColorMethod;// The current font color
  svgCanvas$7.getFontSize=getFontSizeMethod;// The current font size
  svgCanvas$7.setFontSize=setFontSizeMethod;// Applies the given font size to the selected element.
  svgCanvas$7.getText=getTextMethod;// current text (`textContent`) of the selected element
  svgCanvas$7.setTextContent=setTextContentMethod;// Updates the text element with the given string.
  svgCanvas$7.setImageURL=setImageURLMethod;// Sets the new image URL for the selected image element
  svgCanvas$7.setLinkURL=setLinkURLMethod;// Sets the new link URL for the selected anchor element.
  svgCanvas$7.setRectRadius=setRectRadiusMethod;// Sets the `rx` and `ry` values to the selected `rect` element
  svgCanvas$7.makeHyperlink=makeHyperlinkMethod;// Wraps the selected element(s) in an anchor element or converts group to one.
  svgCanvas$7.removeHyperlink=removeHyperlinkMethod;svgCanvas$7.setSegType=setSegTypeMethod;// Sets the new segment type to the selected segment(s).
  svgCanvas$7.setStrokeWidth=setStrokeWidthMethod;// Sets the stroke width for the current selected elements.
  svgCanvas$7.getResolution=getResolutionMethod;// The current dimensions and zoom level in an object
  svgCanvas$7.getTitle=getTitleMethod;// the current group/SVG's title contents or `undefined` if no element
  svgCanvas$7.setGroupTitle=setGroupTitleMethod;// Sets the group/SVG's title content.
  svgCanvas$7.setStrokeAttr=setStrokeAttrMethod;// Set the given stroke-related attribute the given value for selected elements.
  svgCanvas$7.setBackground=setBackgroundMethod;// Set the background of the editor (NOT the actual document).
  svgCanvas$7.setDocumentTitle=setDocumentTitleMethod;// Adds/updates a title element for the document with the given name.
  svgCanvas$7.getEditorNS=getEditorNSMethod;// Returns the editor's namespace URL, optionally adding it to the root element.
  svgCanvas$7.setResolution=setResolutionMethod;// Changes the document's dimensions to the given size.
  svgCanvas$7.setBBoxZoom=setBBoxZoomMethod;// Sets the zoom level on the canvas-side based on the given value.
  svgCanvas$7.setCurrentZoom=setZoomMethod;// Sets the zoom to the given level.
  svgCanvas$7.setColor=setColorMethod;// Change the current stroke/fill color/gradien
  svgCanvas$7.setGradient=setGradientMethod;// Apply the current gradient to selected element's fill or stroke.
  svgCanvas$7.setPaint=setPaintMethod;// Set a color/gradient to a fill/stroke.
  };/**
  * @function module:elem-get-set.SvgCanvas#getResolution
  * @returns {DimensionsAndZoom} The current dimensions and zoom level in an object
  */const getResolutionMethod=()=>{const zoom=svgCanvas$7.getZoom();const w=svgCanvas$7.getSvgContent().getAttribute('width')/zoom;const h=svgCanvas$7.getSvgContent().getAttribute('height')/zoom;return {w,h,zoom};};/**
  * @function module:elem-get-set.SvgCanvas#getTitle
  * @param {Element} [elem]
  * @returns {string|void} the current group/SVG's title contents or
  * `undefined` if no element is passed nd there are no selected elements.
  */const getTitleMethod=elem=>{const selectedElements=svgCanvas$7.getSelectedElements();const dataStorage=svgCanvas$7.getDataStorage();elem=elem||selectedElements[0];if(!elem){return undefined;}if(dataStorage.has(elem,'gsvg')){elem=dataStorage.get(elem,'gsvg');}else if(dataStorage.has(elem,'symbol')){elem=dataStorage.get(elem,'symbol');}const childs=elem.childNodes;for(const child of childs){if(child.nodeName==='title'){return child.textContent;}}return '';};/**
  * Sets the group/SVG's title content.
  * @function module:elem-get-set.SvgCanvas#setGroupTitle
  * @param {string} val
  * @todo Combine this with `setDocumentTitle`
  * @returns {void}
  */const setGroupTitleMethod=val=>{const{InsertElementCommand,RemoveElementCommand,ChangeElementCommand,BatchCommand}=svgCanvas$7.history;const selectedElements=svgCanvas$7.getSelectedElements();const dataStorage=svgCanvas$7.getDataStorage();let elem=selectedElements[0];if(dataStorage.has(elem,'gsvg')){elem=dataStorage.get(elem,'gsvg');}const ts=elem.querySelectorAll('title');const batchCmd=new BatchCommand('Set Label');let title;if(val.length===0){// Remove title element
  const tsNextSibling=ts.nextSibling;batchCmd.addSubCommand(new RemoveElementCommand(ts[0],tsNextSibling,elem));ts.remove();}else if(ts.length){// Change title contents
  title=ts[0];batchCmd.addSubCommand(new ChangeElementCommand(title,{'#text':title.textContent}));title.textContent=val;}else {// Add title element
  title=svgCanvas$7.getDOMDocument().createElementNS(NS.SVG,'title');title.textContent=val;elem.insertBefore(title,elem.firstChild);batchCmd.addSubCommand(new InsertElementCommand(title));}svgCanvas$7.addCommandToHistory(batchCmd);};/**
  * Adds/updates a title element for the document with the given name.
  * This is an undoable action.
  * @function module:elem-get-set.SvgCanvas#setDocumentTitle
  * @param {string} newTitle - String with the new title
  * @returns {void}
  */const setDocumentTitleMethod=newTitle=>{const{ChangeElementCommand,BatchCommand}=svgCanvas$7.history;const childs=svgCanvas$7.getSvgContent().childNodes;let docTitle=false;let oldTitle='';const batchCmd=new BatchCommand('Change Image Title');for(const child of childs){if(child.nodeName==='title'){docTitle=child;oldTitle=docTitle.textContent;break;}}if(!docTitle){docTitle=svgCanvas$7.getDOMDocument().createElementNS(NS.SVG,'title');svgCanvas$7.getSvgContent().insertBefore(docTitle,svgCanvas$7.getSvgContent().firstChild);// svgContent.firstChild.before(docTitle); // Ok to replace above with this?
  }if(newTitle.length){docTitle.textContent=newTitle;}else {// No title given, so element is not necessary
  docTitle.remove();}batchCmd.addSubCommand(new ChangeElementCommand(docTitle,{'#text':oldTitle}));svgCanvas$7.addCommandToHistory(batchCmd);};/**
  * Changes the document's dimensions to the given size.
  * @function module:elem-get-set.SvgCanvas#setResolution
  * @param {Float|"fit"} x - Number with the width of the new dimensions in user units.
  * Can also be the string "fit" to indicate "fit to content".
  * @param {Float} y - Number with the height of the new dimensions in user units.
  * @fires module:elem-get-set.SvgCanvas#event:changed
  * @returns {boolean} Indicates if resolution change was successful.
  * It will fail on "fit to content" option with no content to fit to.
  */const setResolutionMethod=(x,y)=>{const{ChangeElementCommand,BatchCommand}=svgCanvas$7.history;const zoom=svgCanvas$7.getZoom();const res=svgCanvas$7.getResolution();const{w,h}=res;let batchCmd;if(x==='fit'){// Get bounding box
  const bbox=getStrokedBBoxDefaultVisible();if(bbox){batchCmd=new BatchCommand('Fit Canvas to Content');const visEls=getVisibleElements();svgCanvas$7.addToSelection(visEls);const dx=[];const dy=[];visEls.forEach((_item,_i)=>{dx.push(bbox.x*-1);dy.push(bbox.y*-1);});const cmd=svgCanvas$7.moveSelectedElements(dx,dy,true);batchCmd.addSubCommand(cmd);svgCanvas$7.clearSelection();x=Math.round(bbox.width);y=Math.round(bbox.height);}else {return false;}}if(x!==w||y!==h){if(!batchCmd){batchCmd=new BatchCommand('Change Image Dimensions');}x=convertToNum('width',x);y=convertToNum('height',y);svgCanvas$7.getSvgContent().setAttribute('width',x);svgCanvas$7.getSvgContent().setAttribute('height',y);svgCanvas$7.contentW=x;svgCanvas$7.contentH=y;batchCmd.addSubCommand(new ChangeElementCommand(svgCanvas$7.getSvgContent(),{width:w,height:h}));svgCanvas$7.getSvgContent().setAttribute('viewBox',[0,0,x/zoom,y/zoom].join(' '));batchCmd.addSubCommand(new ChangeElementCommand(svgCanvas$7.getSvgContent(),{viewBox:['0 0',w,h].join(' ')}));svgCanvas$7.addCommandToHistory(batchCmd);svgCanvas$7.call('changed',[svgCanvas$7.getSvgContent()]);}return true;};/**
  * Returns the editor's namespace URL, optionally adding it to the root element.
  * @function module:elem-get-set.SvgCanvas#getEditorNS
  * @param {boolean} [add] - Indicates whether or not to add the namespace value
  * @returns {string} The editor's namespace URL
  */const getEditorNSMethod=add=>{if(add){svgCanvas$7.getSvgContent().setAttribute('xmlns:se',NS.SE);}return NS.SE;};/**
   * @typedef {PlainObject} module:elem-get-set.ZoomAndBBox
   * @property {Float} zoom
   * @property {module:utilities.BBoxObject} bbox
   */ /**
  * Sets the zoom level on the canvas-side based on the given value.
  * @function module:elem-get-set.SvgCanvas#setBBoxZoom
  * @param {"selection"|"canvas"|"content"|"layer"|module:SVGEditor.BBoxObjectWithFactor} val - Bounding box object to zoom to or string indicating zoom option. Note: the object value type is defined in `svg-editor.js`
  * @param {Integer} editorW - The editor's workarea box's width
  * @param {Integer} editorH - The editor's workarea box's height
  * @returns {module:elem-get-set.ZoomAndBBox|void}
  */const setBBoxZoomMethod=(val,editorW,editorH)=>{const zoom=svgCanvas$7.getZoom();const selectedElements=svgCanvas$7.getSelectedElements();let spacer=0.85;let bb;const calcZoom=bb=>{if(!bb){return false;}const wZoom=Math.round(editorW/bb.width*100*spacer)/100;const hZoom=Math.round(editorH/bb.height*100*spacer)/100;const zoom=Math.min(wZoom,hZoom);svgCanvas$7.setZoom(zoom);return {zoom,bbox:bb};};if(typeof val==='object'){bb=val;if(bb.width===0||bb.height===0){const newzoom=bb.zoom?bb.zoom:zoom*bb.factor;svgCanvas$7.setZoom(newzoom);return {zoom,bbox:bb};}return calcZoom(bb);}switch(val){case'selection':{if(!selectedElements[0]){return undefined;}const selectedElems=selectedElements.map((n,_)=>{if(n){return n;}return undefined;});bb=getStrokedBBoxDefaultVisible(selectedElems);break;}case'canvas':{const res=svgCanvas$7.getResolution();spacer=0.95;bb={width:res.w,height:res.h,x:0,y:0};break;}case'content':bb=getStrokedBBoxDefaultVisible();break;case'layer':bb=getStrokedBBoxDefaultVisible(getVisibleElements(svgCanvas$7.getCurrentDrawing().getCurrentLayer()));break;default:return undefined;}return calcZoom(bb);};/**
  * Sets the zoom to the given level.
  * @function module:elem-get-set.SvgCanvas#setZoom
  * @param {Float} zoomLevel - Float indicating the zoom level to change to
  * @fires module:elem-get-set.SvgCanvas#event:ext_zoomChanged
  * @returns {void}
  */const setZoomMethod=zoomLevel=>{const selectedElements=svgCanvas$7.getSelectedElements();const res=svgCanvas$7.getResolution();svgCanvas$7.getSvgContent().setAttribute('viewBox','0 0 '+res.w/zoomLevel+' '+res.h/zoomLevel);svgCanvas$7.setZoom(zoomLevel);selectedElements.forEach(elem=>{if(!elem){return;}svgCanvas$7.selectorManager.requestSelector(elem).resize();});svgCanvas$7.pathActions.zoomChange();svgCanvas$7.runExtensions('zoomChanged',zoomLevel);};/**
  * Change the current stroke/fill color/gradient value.
  * @function module:elem-get-set.SvgCanvas#setColor
  * @param {string} type - String indicating fill or stroke
  * @param {string} val - The value to set the stroke attribute to
  * @param {boolean} preventUndo - Boolean indicating whether or not svgCanvas should be an undoable option
  * @fires module:elem-get-set.SvgCanvas#event:changed
  * @returns {void}
  */const setColorMethod=(type,val,preventUndo)=>{const selectedElements=svgCanvas$7.getSelectedElements();svgCanvas$7.setCurShape(type,val);svgCanvas$7.setCurProperties(type+'_paint',{type:'solidColor'});const elems=[];/**
    *
    * @param {Element} e
    * @returns {void}
    */const addNonG=e=>{if(e.nodeName!=='g'){elems.push(e);}};let i=selectedElements.length;while(i--){const elem=selectedElements[i];if(elem){if(elem.tagName==='g'){walkTree(elem,addNonG);}else if(type==='fill'){if(elem.tagName!=='polyline'&&elem.tagName!=='line'){elems.push(elem);}}else {elems.push(elem);}}}if(elems.length>0){if(!preventUndo){svgCanvas$7.changeSelectedAttribute(type,val,elems);svgCanvas$7.call('changed',elems);}else {svgCanvas$7.changeSelectedAttributeNoUndo(type,val,elems);}}};/**
  * Apply the current gradient to selected element's fill or stroke.
  * @function module:elem-get-set.SvgCanvas#setGradient
  * @param {"fill"|"stroke"} type - String indicating "fill" or "stroke" to apply to an element
  * @returns {void}
  */const setGradientMethod=type=>{if(!svgCanvas$7.getCurProperties(type+'_paint')||svgCanvas$7.getCurProperties(type+'_paint').type==='solidColor'){return;}const canvas=svgCanvas$7;let grad=canvas[type+'Grad'];// find out if there is a duplicate gradient already in the defs
  const duplicateGrad=findDuplicateGradient(grad);const defs=findDefs();// no duplicate found, so import gradient into defs
  if(!duplicateGrad){// const origGrad = grad;
  grad=svgCanvas$7.getDOMDocument().importNode(grad,true);defs.append(grad);// get next id and set it on the grad
  grad.id=svgCanvas$7.getNextId();}else {// use existing gradient
  grad=duplicateGrad;}svgCanvas$7.setColor(type,'url(#'+grad.id+')');};/**
  * Check if exact gradient already exists.
  * @function module:svgcanvas~findDuplicateGradient
  * @param {SVGGradientElement} grad - The gradient DOM element to compare to others
  * @returns {SVGGradientElement} The existing gradient if found, `null` if not
  */const findDuplicateGradient=grad=>{const defs=findDefs();const existingGrads=defs.querySelectorAll('linearGradient, radialGradient');let i=existingGrads.length;const radAttrs=['r','cx','cy','fx','fy'];while(i--){const og=existingGrads[i];if(grad.tagName==='linearGradient'){if(grad.getAttribute('x1')!==og.getAttribute('x1')||grad.getAttribute('y1')!==og.getAttribute('y1')||grad.getAttribute('x2')!==og.getAttribute('x2')||grad.getAttribute('y2')!==og.getAttribute('y2')){continue;}}else {const gradAttrs={r:Number(grad.getAttribute('r')),cx:Number(grad.getAttribute('cx')),cy:Number(grad.getAttribute('cy')),fx:Number(grad.getAttribute('fx')),fy:Number(grad.getAttribute('fy'))};const ogAttrs={r:Number(og.getAttribute('r')),cx:Number(og.getAttribute('cx')),cy:Number(og.getAttribute('cy')),fx:Number(og.getAttribute('fx')),fy:Number(og.getAttribute('fy'))};let diff=false;radAttrs.forEach(attr=>{if(gradAttrs[attr]!==ogAttrs[attr]){diff=true;}});if(diff){continue;}}// else could be a duplicate, iterate through stops
  const stops=grad.getElementsByTagNameNS(NS.SVG,'stop');const ostops=og.getElementsByTagNameNS(NS.SVG,'stop');if(stops.length!==ostops.length){continue;}let j=stops.length;while(j--){const stop=stops[j];const ostop=ostops[j];if(stop.getAttribute('offset')!==ostop.getAttribute('offset')||stop.getAttribute('stop-opacity')!==ostop.getAttribute('stop-opacity')||stop.getAttribute('stop-color')!==ostop.getAttribute('stop-color')){break;}}if(j===-1){return og;}}// for each gradient in defs
  return null;};/**
  * Set a color/gradient to a fill/stroke.
  * @function module:elem-get-set.SvgCanvas#setPaint
  * @param {"fill"|"stroke"} type - String with "fill" or "stroke"
  * @param {} paint - The paint object to apply
  * @returns {void}
  */const setPaintMethod=(type,paint)=>{// make a copy
  const p=new Paint(paint);svgCanvas$7.setPaintOpacity(type,p.alpha/100,true);// now set the current paint object
  svgCanvas$7.setCurProperties(type+'_paint',p);switch(p.type){case'solidColor':svgCanvas$7.setColor(type,p.solidColor!=='none'?'#'+p.solidColor:'none');break;case'linearGradient':case'radialGradient':svgCanvas$7.setCanvas(type+'Grad',p[p.type]);svgCanvas$7.setGradient(type);break;}};/**
  * Sets the stroke width for the current selected elements.
  * When attempting to set a line's width to 0, this changes it to 1 instead.
  * @function module:elem-get-set.SvgCanvas#setStrokeWidth
  * @param {Float} val - A Float indicating the new stroke width value
  * @fires module:elem-get-set.SvgCanvas#event:changed
  * @returns {void}
  */const setStrokeWidthMethod=val=>{const selectedElements=svgCanvas$7.getSelectedElements();if(val===0&&['line','path'].includes(svgCanvas$7.getMode())){svgCanvas$7.setStrokeWidth(1);return;}svgCanvas$7.setCurProperties('stroke_width',val);const elems=[];/**
    *
    * @param {Element} e
    * @returns {void}
    */const addNonG=e=>{if(e.nodeName!=='g'){elems.push(e);}};let i=selectedElements.length;while(i--){const elem=selectedElements[i];if(elem){if(elem.tagName==='g'){walkTree(elem,addNonG);}else {elems.push(elem);}}}if(elems.length>0){svgCanvas$7.changeSelectedAttribute('stroke-width',val,elems);svgCanvas$7.call('changed',selectedElements);}};/**
  * Set the given stroke-related attribute the given value for selected elements.
  * @function module:elem-get-set.SvgCanvas#setStrokeAttr
  * @param {string} attr - String with the attribute name
  * @param {string|Float} val - String or number with the attribute value
  * @fires module:elem-get-set.SvgCanvas#event:changed
  * @returns {void}
  */const setStrokeAttrMethod=(attr,val)=>{const selectedElements=svgCanvas$7.getSelectedElements();svgCanvas$7.setCurShape(attr.replace('-','_'),val);const elems=[];let i=selectedElements.length;while(i--){const elem=selectedElements[i];if(elem){if(elem.tagName==='g'){walkTree(elem,e=>{if(e.nodeName!=='g'){elems.push(e);}});}else {elems.push(elem);}}}if(elems.length>0){svgCanvas$7.changeSelectedAttribute(attr,val,elems);svgCanvas$7.call('changed',selectedElements);}};/**
  * Check whether selected element is bold or not.
  * @function module:svgcanvas.SvgCanvas#getBold
  * @returns {boolean} Indicates whether or not element is bold
  */const getBoldMethod=()=>{const selectedElements=svgCanvas$7.getSelectedElements();// should only have one element selected
  const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){return selected.getAttribute('font-weight')==='bold';}return false;};/**
  * Make the selected element bold or normal.
  * @function module:svgcanvas.SvgCanvas#setBold
  * @param {boolean} b - Indicates bold (`true`) or normal (`false`)
  * @returns {void}
  */const setBoldMethod=b=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('font-weight',b?'bold':'normal');}if(!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * Check whether selected element has the given text decoration value or not.
   * @returns {boolean} Indicates whether or not element has the text decoration value
   */const hasTextDecorationMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){const attribute=selected.getAttribute('text-decoration')||'';return attribute.includes(value);}return false;};/**
   * Adds the given text decoration value
   * @param value The text decoration value
   * @returns {void}
   */const addTextDecorationMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){const oldValue=selected.getAttribute('text-decoration')||'';svgCanvas$7.changeSelectedAttribute('text-decoration',(oldValue+' '+value).trim());}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * Removes the given text decoration value
   * @param value The text decoration value
   * @returns {void}
   */const removeTextDecorationMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){const actualValues=selected.getAttribute('text-decoration')||'';svgCanvas$7.changeSelectedAttribute('text-decoration',actualValues.replace(value,'').trim());}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
  * Check whether selected element is in italics or not.
  * @function module:svgcanvas.SvgCanvas#getItalic
  * @returns {boolean} Indicates whether or not element is italic
  */const getItalicMethod=()=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){return selected.getAttribute('font-style')==='italic';}return false;};/**
  * Make the selected element italic or normal.
  * @function module:svgcanvas.SvgCanvas#setItalic
  * @param {boolean} i - Indicates italic (`true`) or normal (`false`)
  * @returns {void}
  */const setItalicMethod=i=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('font-style',i?'italic':'normal');}if(!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * @function module:svgcanvas.SvgCanvas#setTextAnchorMethod Set the new text anchor
   * @param {string} value - The text anchor value (start, middle or end)
   * @returns {void}
   */const setTextAnchorMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('text-anchor',value);}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * @function module:svgcanvas.SvgCanvas#setLetterSpacingMethod Set the new letter spacing
   * @param {string} value - The letter spacing value
   * @returns {void}
   */const setLetterSpacingMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('letter-spacing',value);}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * @function module:svgcanvas.SvgCanvas#setWordSpacingMethod Set the new word spacing
   * @param {string} value - The word spacing value
   * @returns {void}
   */const setWordSpacingMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('word-spacing',value);}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * @function module:svgcanvas.SvgCanvas#setTextLengthMethod Set the new text length
   * @param {string} value - The text length value
   * @returns {void}
   */const setTextLengthMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('textLength',value);}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
   * @function module:svgcanvas.SvgCanvas#setLengthAdjustMethod Set the new length adjust
   * @param {string} value - The length adjust value
   * @returns {void}
   */const setLengthAdjustMethod=value=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='text'&&!selectedElements[1]){svgCanvas$7.changeSelectedAttribute('lengthAdjust',value);}if(selectedElements.length>0&&!selectedElements[0].textContent){svgCanvas$7.textActions.setCursor();}};/**
  * @function module:svgcanvas.SvgCanvas#getFontFamily
  * @returns {string} The current font family
  */const getFontFamilyMethod=()=>{return svgCanvas$7.getCurText('font_family');};/**
  * Set the new font family.
  * @function module:svgcanvas.SvgCanvas#setFontFamily
  * @param {string} val - String with the new font family
  * @returns {void}
  */const setFontFamilyMethod=val=>{var _selectedElements$;const selectedElements=svgCanvas$7.getSelectedElements();svgCanvas$7.setCurText('font_family',val);svgCanvas$7.changeSelectedAttribute('font-family',val);if(!((_selectedElements$=selectedElements[0])!==null&&_selectedElements$!==void 0&&_selectedElements$.textContent)){svgCanvas$7.textActions.setCursor();}};/**
  * Set the new font color.
  * @function module:svgcanvas.SvgCanvas#setFontColor
  * @param {string} val - String with the new font color
  * @returns {void}
  */const setFontColorMethod=val=>{svgCanvas$7.setCurText('fill',val);svgCanvas$7.changeSelectedAttribute('fill',val);};/**
  * @function module:svgcanvas.SvgCanvas#getFontColor
  * @returns {string} The current font color
  */const getFontColorMethod=()=>{return svgCanvas$7.getCurText('fill');};/**
  * @function module:svgcanvas.SvgCanvas#getFontSize
  * @returns {Float} The current font size
  */const getFontSizeMethod=()=>{return svgCanvas$7.getCurText('font_size');};/**
  * Applies the given font size to the selected element.
  * @function module:svgcanvas.SvgCanvas#setFontSize
  * @param {Float} val - Float with the new font size
  * @returns {void}
  */const setFontSizeMethod=val=>{var _selectedElements$2;const selectedElements=svgCanvas$7.getSelectedElements();svgCanvas$7.setCurText('font_size',val);svgCanvas$7.changeSelectedAttribute('font-size',val);if(!((_selectedElements$2=selectedElements[0])!==null&&_selectedElements$2!==void 0&&_selectedElements$2.textContent)){svgCanvas$7.textActions.setCursor();}};/**
  * @function module:svgcanvas.SvgCanvas#getText
  * @returns {string} The current text (`textContent`) of the selected element
  */const getTextMethod=()=>{const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];return selected?selected.textContent:'';};/**
  * Updates the text element with the given string.
  * @function module:svgcanvas.SvgCanvas#setTextContent
  * @param {string} val - String with the new text
  * @returns {void}
  */const setTextContentMethod=val=>{svgCanvas$7.changeSelectedAttribute('#text',val);svgCanvas$7.textActions.init(val);svgCanvas$7.textActions.setCursor();};/**
  * Sets the new image URL for the selected image element. Updates its size if
  * a new URL is given.
  * @function module:svgcanvas.SvgCanvas#setImageURL
  * @param {string} val - String with the image URL/path
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @returns {void}
  */const setImageURLMethod=val=>{const{ChangeElementCommand,BatchCommand}=svgCanvas$7.history;const selectedElements=svgCanvas$7.getSelectedElements();const elem=selectedElements[0];if(!elem){return;}const attrs={width:elem.getAttribute('width'),height:elem.getAttribute('height')};const setsize=!attrs.width||!attrs.height;const curHref=getHref(elem);// Do nothing if no URL change or size change
  if(curHref===val&&!setsize){return;}const batchCmd=new BatchCommand('Change Image URL');setHref(elem,val);batchCmd.addSubCommand(new ChangeElementCommand(elem,{'#href':curHref}));const img=new Image();img.onload=function(){const changes={width:elem.getAttribute('width'),height:elem.getAttribute('height')};elem.setAttribute('width',this.width);elem.setAttribute('height',this.height);svgCanvas$7.selectorManager.requestSelector(elem).resize();batchCmd.addSubCommand(new ChangeElementCommand(elem,changes));svgCanvas$7.addCommandToHistory(batchCmd);svgCanvas$7.call('changed',[elem]);};img.src=val;};/**
  * Sets the new link URL for the selected anchor element.
  * @function module:svgcanvas.SvgCanvas#setLinkURL
  * @param {string} val - String with the link URL/path
  * @returns {void}
  */const setLinkURLMethod=val=>{const{ChangeElementCommand,BatchCommand}=svgCanvas$7.history;const selectedElements=svgCanvas$7.getSelectedElements();let elem=selectedElements[0];if(!elem){return;}if(elem.tagName!=='a'){// See if parent is an anchor
  const parentsA=getParents(elem.parentNode,'a');if(parentsA!==null&&parentsA!==void 0&&parentsA.length){elem=parentsA[0];}else {return;}}const curHref=getHref(elem);if(curHref===val){return;}const batchCmd=new BatchCommand('Change Link URL');setHref(elem,val);batchCmd.addSubCommand(new ChangeElementCommand(elem,{'#href':curHref}));svgCanvas$7.addCommandToHistory(batchCmd);};/**
  * Sets the `rx` and `ry` values to the selected `rect` element
  * to change its corner radius.
  * @function module:svgcanvas.SvgCanvas#setRectRadius
  * @param {string|Float} val - The new radius
  * @fires module:svgcanvas.SvgCanvas#event:changed
  * @returns {void}
  */const setRectRadiusMethod=val=>{const{ChangeElementCommand}=svgCanvas$7.history;const selectedElements=svgCanvas$7.getSelectedElements();const selected=selectedElements[0];if((selected===null||selected===void 0?void 0:selected.tagName)==='rect'){const r=Number(selected.getAttribute('rx'));if(r!==val){selected.setAttribute('rx',val);selected.setAttribute('ry',val);svgCanvas$7.addCommandToHistory(new ChangeElementCommand(selected,{rx:r,ry:r},'Radius'));svgCanvas$7.call('changed',[selected]);}}};/**
  * Wraps the selected element(s) in an anchor element or converts group to one.
  * @function module:svgcanvas.SvgCanvas#makeHyperlink
  * @param {string} url
  * @returns {void}
  */const makeHyperlinkMethod=url=>{svgCanvas$7.groupSelectedElements('a',url);};/**
  * @function module:svgcanvas.SvgCanvas#removeHyperlink
  * @returns {void}
  */const removeHyperlinkMethod=()=>{svgCanvas$7.ungroupSelectedElement();};/**
  * Group: Element manipulation.
  */ /**
  * Sets the new segment type to the selected segment(s).
  * @function module:svgcanvas.SvgCanvas#setSegType
  * @param {Integer} newType - New segment type. See {@link https://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSeg} for list
  * @returns {void}
  */const setSegTypeMethod=newType=>{svgCanvas$7.pathActions.setSegType(newType);};/**
  * Set the background of the editor (NOT the actual document).
  * @function module:svgcanvas.SvgCanvas#setBackground
  * @param {string} color - String with fill color to apply
  * @param {string} url - URL or path to image to use
  * @returns {void}
  */const setBackgroundMethod=(color,url)=>{const bg=getElement('canvasBackground');const border=bg.querySelector('rect');let bgImg=getElement('background_image');let bgPattern=getElement('background_pattern');border.setAttribute('fill',color==='chessboard'?'#fff':color);if(color==='chessboard'){if(!bgPattern){bgPattern=svgCanvas$7.getDOMDocument().createElementNS(NS.SVG,'foreignObject');svgCanvas$7.assignAttributes(bgPattern,{id:'background_pattern',width:'100%',height:'100%',preserveAspectRatio:'xMinYMin',style:'pointer-events:none'});const div=document.createElement('div');svgCanvas$7.assignAttributes(div,{style:'pointer-events:none;width:100%;height:100%;'+'background-image:url(data:image/gif;base64,'+'R0lGODlhEAAQAIAAAP///9bW1iH5BAAAAAAALAAAAAAQABAAAAIfjG+'+'gq4jM3IFLJgpswNly/XkcBpIiVaInlLJr9FZWAQA7);'});bgPattern.append(div);bg.append(bgPattern);}}else if(bgPattern){bgPattern.remove();}if(url){if(!bgImg){bgImg=svgCanvas$7.getDOMDocument().createElementNS(NS.SVG,'image');svgCanvas$7.assignAttributes(bgImg,{id:'background_image',width:'100%',height:'100%',preserveAspectRatio:'xMinYMin',style:'pointer-events:none'});}setHref(bgImg,url);bg.append(bgImg);}else if(bgImg){bgImg.remove();}};/**
   * Manipulating coordinates.
   * @module coords
   * @license MIT
   */ // this is how we map paths to our preferred relative segment types
  const pathMap=[0,'z','M','m','L','l','C','c','Q','q','A','a','H','h','V','v','S','s','T','t'];/**
   * @interface module:coords.EditorContext
   */ /**
   * @function module:coords.EditorContext#getGridSnapping
   * @returns {boolean}
   */ /**
   * @function module:coords.EditorContext#getSvgRoot
   * @returns {SVGSVGElement}
  */let svgCanvas$6=null;/**
  * @function module:coords.init
  * @param {module:svgcanvas.SvgCanvas#event:pointsAdded} editorContext
  * @returns {void}
  */const init$6=canvas=>{svgCanvas$6=canvas;};/**
   * Applies coordinate changes to an element based on the given matrix.
   * @name module:coords.remapElement
   * @type {module:path.EditorContext#remapElement}
  */const remapElement=(selected,changes,m)=>{const remap=(x,y)=>transformPoint(x,y,m);const scalew=w=>m.a*w;const scaleh=h=>m.d*h;const doSnapping=svgCanvas$6.getGridSnapping()&&selected.parentNode.parentNode.localName==='svg';const finishUp=()=>{if(doSnapping){Object.entries(changes).forEach(_ref10=>{let[o,value]=_ref10;changes[o]=snapToGrid(value);});}assignAttributes(selected,changes,1000,true);};const box=getBBox(selected);['fill','stroke'].forEach(type=>{const attrVal=selected.getAttribute(type);if(attrVal!==null&&attrVal!==void 0&&attrVal.startsWith('url(')&&(m.a<0||m.d<0)){const grad=getRefElem(attrVal);const newgrad=grad.cloneNode(true);if(m.a<0){// flip x
  const x1=newgrad.getAttribute('x1');const x2=newgrad.getAttribute('x2');newgrad.setAttribute('x1',-(x1-1));newgrad.setAttribute('x2',-(x2-1));}if(m.d<0){// flip y
  const y1=newgrad.getAttribute('y1');const y2=newgrad.getAttribute('y2');newgrad.setAttribute('y1',-(y1-1));newgrad.setAttribute('y2',-(y2-1));}newgrad.id=svgCanvas$6.getCurrentDrawing().getNextId();findDefs().append(newgrad);selected.setAttribute(type,'url(#'+newgrad.id+')');}});const elName=selected.tagName;if(elName==='g'||elName==='text'||elName==='tspan'||elName==='use'){// if it was a translate, then just update x,y
  if(m.a===1&&m.b===0&&m.c===0&&m.d===1&&(m.e!==0||m.f!==0)){// [T][M] = [M][T']
  // therefore [T'] = [M_inv][T][M]
  const existing=transformListToTransform(selected).matrix;const tNew=matrixMultiply(existing.inverse(),m,existing);changes.x=Number.parseFloat(changes.x)+tNew.e;changes.y=Number.parseFloat(changes.y)+tNew.f;}else {// we just absorb all matrices into the element and don't do any remapping
  const chlist=selected.transform.baseVal;const mt=svgCanvas$6.getSvgRoot().createSVGTransform();mt.setMatrix(matrixMultiply(transformListToTransform(chlist).matrix,m));chlist.clear();chlist.appendItem(mt);}}// now we have a set of changes and an applied reduced transform list
  // we apply the changes directly to the DOM
  switch(elName){case'foreignObject':case'rect':case'image':{// Allow images to be inverted (give them matrix when flipped)
  if(elName==='image'&&(m.a<0||m.d<0)){// Convert to matrix
  const chlist=selected.transform.baseVal;const mt=svgCanvas$6.getSvgRoot().createSVGTransform();mt.setMatrix(matrixMultiply(transformListToTransform(chlist).matrix,m));chlist.clear();chlist.appendItem(mt);}else {const pt1=remap(changes.x,changes.y);changes.width=scalew(changes.width);changes.height=scaleh(changes.height);changes.x=pt1.x+Math.min(0,changes.width);changes.y=pt1.y+Math.min(0,changes.height);changes.width=Math.abs(changes.width);changes.height=Math.abs(changes.height);}finishUp();break;}case'ellipse':{const c=remap(changes.cx,changes.cy);changes.cx=c.x;changes.cy=c.y;changes.rx=scalew(changes.rx);changes.ry=scaleh(changes.ry);changes.rx=Math.abs(changes.rx);changes.ry=Math.abs(changes.ry);finishUp();break;}case'circle':{const c=remap(changes.cx,changes.cy);changes.cx=c.x;changes.cy=c.y;// take the minimum of the new selected box's dimensions for the new circle radius
  const tbox=transformBox(box.x,box.y,box.width,box.height,m);const w=tbox.tr.x-tbox.tl.x;const h=tbox.bl.y-tbox.tl.y;changes.r=Math.min(w/2,h/2);if(changes.r){changes.r=Math.abs(changes.r);}finishUp();break;}case'line':{const pt1=remap(changes.x1,changes.y1);const pt2=remap(changes.x2,changes.y2);changes.x1=pt1.x;changes.y1=pt1.y;changes.x2=pt2.x;changes.y2=pt2.y;}// Fallthrough
  case'text':case'tspan':case'use':{finishUp();break;}case'g':{const dataStorage=svgCanvas$6.getDataStorage();const gsvg=dataStorage.get(selected,'gsvg');if(gsvg){assignAttributes(gsvg,changes,1000,true);}break;}case'polyline':case'polygon':{changes.points.forEach(pt=>{const{x,y}=remap(pt.x,pt.y);pt.x=x;pt.y=y;});// const len = changes.points.length;
  let pstr='';changes.points.forEach(pt=>{pstr+=pt.x+','+pt.y+' ';});selected.setAttribute('points',pstr);break;}case'path':{const segList=selected.pathSegList;let len=segList.numberOfItems;changes.d=[];for(let i=0;i<len;++i){const seg=segList.getItem(i);changes.d[i]={type:seg.pathSegType,x:seg.x,y:seg.y,x1:seg.x1,y1:seg.y1,x2:seg.x2,y2:seg.y2,r1:seg.r1,r2:seg.r2,angle:seg.angle,largeArcFlag:seg.largeArcFlag,sweepFlag:seg.sweepFlag};}len=changes.d.length;const firstseg=changes.d[0];let currentpt;if(len>0){currentpt=remap(firstseg.x,firstseg.y);changes.d[0].x=currentpt.x;changes.d[0].y=currentpt.y;}for(let i=1;i<len;++i){const seg=changes.d[i];const{type}=seg;// if absolute or first segment, we want to remap x, y, x1, y1, x2, y2
  // if relative, we want to scalew, scaleh
  if(type%2===0){// absolute
  const thisx=seg.x!==undefined?seg.x:currentpt.x;// for V commands
  const thisy=seg.y!==undefined?seg.y:currentpt.y;// for H commands
  const pt=remap(thisx,thisy);const pt1=remap(seg.x1,seg.y1);const pt2=remap(seg.x2,seg.y2);seg.x=pt.x;seg.y=pt.y;seg.x1=pt1.x;seg.y1=pt1.y;seg.x2=pt2.x;seg.y2=pt2.y;seg.r1=scalew(seg.r1);seg.r2=scaleh(seg.r2);}else {// relative
  seg.x=scalew(seg.x);seg.y=scaleh(seg.y);seg.x1=scalew(seg.x1);seg.y1=scaleh(seg.y1);seg.x2=scalew(seg.x2);seg.y2=scaleh(seg.y2);seg.r1=scalew(seg.r1);seg.r2=scaleh(seg.r2);}}// for each segment
  let dstr='';changes.d.forEach(seg=>{const{type}=seg;dstr+=pathMap[type];switch(type){case 13:// relative horizontal line (h)
  case 12:// absolute horizontal line (H)
  dstr+=seg.x+' ';break;case 15:// relative vertical line (v)
  case 14:// absolute vertical line (V)
  dstr+=seg.y+' ';break;case 3:// relative move (m)
  case 5:// relative line (l)
  case 19:// relative smooth quad (t)
  case 2:// absolute move (M)
  case 4:// absolute line (L)
  case 18:// absolute smooth quad (T)
  dstr+=seg.x+','+seg.y+' ';break;case 7:// relative cubic (c)
  case 6:// absolute cubic (C)
  dstr+=seg.x1+','+seg.y1+' '+seg.x2+','+seg.y2+' '+seg.x+','+seg.y+' ';break;case 9:// relative quad (q)
  case 8:// absolute quad (Q)
  dstr+=seg.x1+','+seg.y1+' '+seg.x+','+seg.y+' ';break;case 11:// relative elliptical arc (a)
  case 10:// absolute elliptical arc (A)
  dstr+=seg.r1+','+seg.r2+' '+seg.angle+' '+Number(seg.largeArcFlag)+' '+Number(seg.sweepFlag)+' '+seg.x+','+seg.y+' ';break;case 17:// relative smooth cubic (s)
  case 16:// absolute smooth cubic (S)
  dstr+=seg.x2+','+seg.y2+' '+seg.x+','+seg.y+' ';break;}});selected.setAttribute('d',dstr);break;}}};/**
   * Recalculate.
   * @module recalculate
   * @license MIT
   */let svgCanvas$5;/**
  * @interface module:recalculate.EditorContext
  */ /**
   * @function module:recalculate.EditorContext#getSvgRoot
   * @returns {SVGSVGElement} The root DOM element
   */ /**
   * @function module:recalculate.EditorContext#getStartTransform
   * @returns {string}
  */ /**
   * @function module:recalculate.EditorContext#setStartTransform
   * @param {string} transform
   * @returns {void}
   */ /**
  * @function module:recalculate.init
  * @param {module:recalculate.EditorContext} editorContext
  * @returns {void}
  */const init$5=canvas=>{svgCanvas$5=canvas;};/**
  * Updates a `<clipPath>`s values based on the given translation of an element.
  * @function module:recalculate.updateClipPath
  * @param {string} attr - The clip-path attribute value with the clipPath's ID
  * @param {Float} tx - The translation's x value
  * @param {Float} ty - The translation's y value
  * @returns {void}
  */const updateClipPath=(attr,tx,ty)=>{const path=getRefElem(attr).firstChild;const cpXform=path.transform.baseVal;const newxlate=svgCanvas$5.getSvgRoot().createSVGTransform();newxlate.setTranslate(tx,ty);cpXform.appendItem(newxlate);// Update clipPath's dimensions
  recalculateDimensions(path);};/**
  * Decides the course of action based on the element's transform list.
  * @function module:recalculate.recalculateDimensions
  * @param {Element} selected - The DOM element to recalculate
  * @returns {Command} Undo command object with the resulting change
  */const recalculateDimensions=selected=>{var _selected$transform2;if(!selected)return null;const svgroot=svgCanvas$5.getSvgRoot();const dataStorage=svgCanvas$5.getDataStorage();const tlist=(_selected$transform2=selected.transform)===null||_selected$transform2===void 0?void 0:_selected$transform2.baseVal;// remove any unnecessary transforms
  if((tlist===null||tlist===void 0?void 0:tlist.numberOfItems)>0){let k=tlist.numberOfItems;const noi=k;while(k--){const xform=tlist.getItem(k);if(xform.type===0){tlist.removeItem(k);// remove identity matrices
  }else if(xform.type===1){if(isIdentity(xform.matrix)){if(noi===1){// Overcome Chrome bug (though only when noi is 1) with
  //    `removeItem` preventing `removeAttribute` from
  //    subsequently working
  // See https://bugs.chromium.org/p/chromium/issues/detail?id=843901
  selected.removeAttribute('transform');return null;}tlist.removeItem(k);}// remove zero-degree rotations
  }else if(xform.type===4&&xform.angle===0){tlist.removeItem(k);}}// End here if all it has is a rotation
  if(tlist.numberOfItems===1&&getRotationAngle(selected)){return null;}}// if this element had no transforms, we are done
  if(!tlist||tlist.numberOfItems===0){// Chrome apparently had a bug that requires clearing the attribute first.
  selected.setAttribute('transform','');// However, this still next line currently doesn't work at all in Chrome
  selected.removeAttribute('transform');// selected.transform.baseVal.clear(); // Didn't help for Chrome bug
  return null;}// TODO: Make this work for more than 2
  if(tlist){let mxs=[];let k=tlist.numberOfItems;while(k--){const xform=tlist.getItem(k);if(xform.type===1){mxs.push([xform.matrix,k]);}else if(mxs.length){mxs=[];}}if(mxs.length===2){const mNew=svgroot.createSVGTransformFromMatrix(matrixMultiply(mxs[1][0],mxs[0][0]));tlist.removeItem(mxs[0][1]);tlist.removeItem(mxs[1][1]);tlist.insertItemBefore(mNew,mxs[1][1]);}// combine matrix + translate
  k=tlist.numberOfItems;if(k>=2&&tlist.getItem(k-2).type===1&&tlist.getItem(k-1).type===2){const mt=svgroot.createSVGTransform();const m=matrixMultiply(tlist.getItem(k-2).matrix,tlist.getItem(k-1).matrix);mt.setMatrix(m);tlist.removeItem(k-2);tlist.removeItem(k-2);tlist.appendItem(mt);}}// If it still has a single [M] or [R][M], return null too (prevents BatchCommand from being returned).
  switch(selected.tagName){// Ignore these elements, as they can absorb the [M]
  case'line':case'polyline':case'polygon':case'path':break;default:if(tlist.numberOfItems===1&&tlist.getItem(0).type===1||tlist.numberOfItems===2&&tlist.getItem(0).type===1&&tlist.getItem(0).type===4){return null;}}// Grouped SVG element
  const gsvg=dataStorage.has(selected,'gsvg')?dataStorage.get(selected,'gsvg'):undefined;// we know we have some transforms, so set up return variable
  const batchCmd=new BatchCommand$4('Transform');// store initial values that will be affected by reducing the transform list
  let changes={};let initial=null;let attrs=[];switch(selected.tagName){case'line':attrs=['x1','y1','x2','y2'];break;case'circle':attrs=['cx','cy','r'];break;case'ellipse':attrs=['cx','cy','rx','ry'];break;case'foreignObject':case'rect':case'image':attrs=['width','height','x','y'];break;case'use':case'text':case'tspan':attrs=['x','y'];break;case'polygon':case'polyline':{initial={};initial.points=selected.getAttribute('points');const list=selected.points;const len=list.numberOfItems;changes.points=new Array(len);for(let i=0;i<len;++i){const pt=list.getItem(i);changes.points[i]={x:pt.x,y:pt.y};}break;}case'path':initial={};initial.d=selected.getAttribute('d');changes.d=selected.getAttribute('d');break;}// switch on element type to get initial values
  if(attrs.length){attrs.forEach(attr=>{changes[attr]=convertToNum(attr,selected.getAttribute(attr));});}else if(gsvg){// GSVG exception
  changes={x:Number(gsvg.getAttribute('x'))||0,y:Number(gsvg.getAttribute('y'))||0};}// if we haven't created an initial array in polygon/polyline/path, then
  // make a copy of initial values and include the transform
  if(!initial){initial=mergeDeep$1({},changes);for(const[attr,val]of Object.entries(initial)){initial[attr]=convertToNum(attr,val);}}// save the start transform value too
  initial.transform=svgCanvas$5.getStartTransform()||'';let oldcenter;let newcenter;// if it's a regular group, we have special processing to flatten transforms
  if(selected.tagName==='g'&&!gsvg||selected.tagName==='a'){const box=getBBox(selected);oldcenter={x:box.x+box.width/2,y:box.y+box.height/2};newcenter=transformPoint(box.x+box.width/2,box.y+box.height/2,transformListToTransform(tlist).matrix);// let m = svgroot.createSVGMatrix();
  // temporarily strip off the rotate and save the old center
  const gangle=getRotationAngle(selected);if(gangle){const a=gangle*Math.PI/180;const s=Math.abs(a)>1.0e-10?Math.sin(a)/(1-Math.cos(a)):2/a;for(let i=0;i<tlist.numberOfItems;++i){const xform=tlist.getItem(i);if(xform.type===4){// extract old center through mystical arts
  const rm=xform.matrix;oldcenter.y=(s*rm.e+rm.f)/2;oldcenter.x=(rm.e-s*rm.f)/2;tlist.removeItem(i);break;}}}const N=tlist.numberOfItems;let tx=0;let ty=0;let operation=0;let firstM;if(N){firstM=tlist.getItem(0).matrix;}let oldStartTransform;// first, if it was a scale then the second-last transform will be it
  if(N>=3&&tlist.getItem(N-2).type===3&&tlist.getItem(N-3).type===2&&tlist.getItem(N-1).type===2){operation=3;// scale
  // if the children are unrotated, pass the scale down directly
  // otherwise pass the equivalent matrix() down directly
  const tm=tlist.getItem(N-3).matrix;const sm=tlist.getItem(N-2).matrix;const tmn=tlist.getItem(N-1).matrix;const children=selected.childNodes;let c=children.length;while(c--){const child=children.item(c);tx=0;ty=0;if(child.nodeType===1){const childTlist=child.transform.baseVal;// some children might not have a transform (<metadata>, <defs>, etc)
  if(!childTlist){continue;}const m=transformListToTransform(childTlist).matrix;// Convert a matrix to a scale if applicable
  // if (hasMatrixTransform(childTlist) && childTlist.numberOfItems == 1) {
  //   if (m.b==0 && m.c==0 && m.e==0 && m.f==0) {
  //     childTlist.removeItem(0);
  //     const translateOrigin = svgroot.createSVGTransform(),
  //       scale = svgroot.createSVGTransform(),
  //       translateBack = svgroot.createSVGTransform();
  //     translateOrigin.setTranslate(0, 0);
  //     scale.setScale(m.a, m.d);
  //     translateBack.setTranslate(0, 0);
  //     childTlist.appendItem(translateBack);
  //     childTlist.appendItem(scale);
  //     childTlist.appendItem(translateOrigin);
  //   }
  // }
  const angle=getRotationAngle(child);oldStartTransform=svgCanvas$5.getStartTransform();// const childxforms = [];
  svgCanvas$5.setStartTransform(child.getAttribute('transform'));if(angle||hasMatrixTransform(childTlist)){const e2t=svgroot.createSVGTransform();e2t.setMatrix(matrixMultiply(tm,sm,tmn,m));childTlist.clear();childTlist.appendItem(e2t);// childxforms.push(e2t);
  // if not rotated or skewed, push the [T][S][-T] down to the child
  }else {// update the transform list with translate,scale,translate
  // slide the [T][S][-T] from the front to the back
  // [T][S][-T][M] = [M][T2][S2][-T2]
  // (only bringing [-T] to the right of [M])
  // [T][S][-T][M] = [T][S][M][-T2]
  // [-T2] = [M_inv][-T][M]
  const t2n=matrixMultiply(m.inverse(),tmn,m);// [T2] is always negative translation of [-T2]
  const t2=svgroot.createSVGMatrix();t2.e=-t2n.e;t2.f=-t2n.f;// [T][S][-T][M] = [M][T2][S2][-T2]
  // [S2] = [T2_inv][M_inv][T][S][-T][M][-T2_inv]
  const s2=matrixMultiply(t2.inverse(),m.inverse(),tm,sm,tmn,m,t2n.inverse());const translateOrigin=svgroot.createSVGTransform();const scale=svgroot.createSVGTransform();const translateBack=svgroot.createSVGTransform();translateOrigin.setTranslate(t2n.e,t2n.f);scale.setScale(s2.a,s2.d);translateBack.setTranslate(t2.e,t2.f);childTlist.appendItem(translateBack);childTlist.appendItem(scale);childTlist.appendItem(translateOrigin);}// not rotated
  const recalculatedDimensions=recalculateDimensions(child);if(recalculatedDimensions){batchCmd.addSubCommand(recalculatedDimensions);}svgCanvas$5.setStartTransform(oldStartTransform);}// element
  }// for each child
  // Remove these transforms from group
  tlist.removeItem(N-1);tlist.removeItem(N-2);tlist.removeItem(N-3);}else if(N>=3&&tlist.getItem(N-1).type===1){operation=3;// scale
  const m=transformListToTransform(tlist).matrix;const e2t=svgroot.createSVGTransform();e2t.setMatrix(m);tlist.clear();tlist.appendItem(e2t);// next, check if the first transform was a translate
  // if we had [ T1 ] [ M ] we want to transform this into [ M ] [ T2 ]
  // therefore [ T2 ] = [ M_inv ] [ T1 ] [ M ]
  }else if((N===1||N>1&&tlist.getItem(1).type!==3)&&tlist.getItem(0).type===2){operation=2;// translate
  const T_M=transformListToTransform(tlist).matrix;tlist.removeItem(0);const mInv=transformListToTransform(tlist).matrix.inverse();const M2=matrixMultiply(mInv,T_M);tx=M2.e;ty=M2.f;if(tx!==0||ty!==0){// we pass the translates down to the individual children
  const children=selected.childNodes;let c=children.length;const clipPathsDone=[];while(c--){const child=children.item(c);if(child.nodeType===1){var _child$transform;// Check if child has clip-path
  if(child.getAttribute('clip-path')){// tx, ty
  const attr=child.getAttribute('clip-path');if(!clipPathsDone.includes(attr)){updateClipPath(attr,tx,ty);clipPathsDone.push(attr);}}oldStartTransform=svgCanvas$5.getStartTransform();svgCanvas$5.setStartTransform(child.getAttribute('transform'));const childTlist=(_child$transform=child.transform)===null||_child$transform===void 0?void 0:_child$transform.baseVal;// some children might not have a transform (<metadata>, <defs>, etc)
  if(childTlist){const newxlate=svgroot.createSVGTransform();newxlate.setTranslate(tx,ty);if(childTlist.numberOfItems){childTlist.insertItemBefore(newxlate,0);}else {childTlist.appendItem(newxlate);}const recalculatedDimensions=recalculateDimensions(child);if(recalculatedDimensions){batchCmd.addSubCommand(recalculatedDimensions);}// If any <use> have this group as a parent and are
  // referencing this child, then impose a reverse translate on it
  // so that when it won't get double-translated
  const uses=selected.getElementsByTagNameNS(NS.SVG,'use');const href='#'+child.id;let u=uses.length;while(u--){const useElem=uses.item(u);if(href===getHref(useElem)){const usexlate=svgroot.createSVGTransform();usexlate.setTranslate(-tx,-ty);useElem.transform.baseVal.insertItemBefore(usexlate,0);batchCmd.addSubCommand(recalculateDimensions(useElem));}}svgCanvas$5.setStartTransform(oldStartTransform);}}}svgCanvas$5.setStartTransform(oldStartTransform);}// else, a matrix imposition from a parent group
  // keep pushing it down to the children
  }else if(N===1&&tlist.getItem(0).type===1&&!gangle){operation=1;const m=tlist.getItem(0).matrix;const children=selected.childNodes;let c=children.length;while(c--){const child=children.item(c);if(child.nodeType===1){var _child$transform2;oldStartTransform=svgCanvas$5.getStartTransform();svgCanvas$5.setStartTransform(child.getAttribute('transform'));const childTlist=(_child$transform2=child.transform)===null||_child$transform2===void 0?void 0:_child$transform2.baseVal;if(!childTlist){continue;}const em=matrixMultiply(m,transformListToTransform(childTlist).matrix);const e2m=svgroot.createSVGTransform();e2m.setMatrix(em);childTlist.clear();childTlist.appendItem(e2m,0);const recalculatedDimensions=recalculateDimensions(child);if(recalculatedDimensions){batchCmd.addSubCommand(recalculatedDimensions);}svgCanvas$5.setStartTransform(oldStartTransform);// Convert stroke
  // TODO: Find out if this should actually happen somewhere else
  const sw=child.getAttribute('stroke-width');if(child.getAttribute('stroke')!=='none'&&!isNaN(sw)){const avg=(Math.abs(em.a)+Math.abs(em.d))/2;child.setAttribute('stroke-width',sw*avg);}}}tlist.clear();// else it was just a rotate
  }else {if(gangle){const newRot=svgroot.createSVGTransform();newRot.setRotate(gangle,newcenter.x,newcenter.y);if(tlist.numberOfItems){tlist.insertItemBefore(newRot,0);}else {tlist.appendItem(newRot);}}if(tlist.numberOfItems===0){selected.removeAttribute('transform');}return null;}// if it was a translate, put back the rotate at the new center
  if(operation===2){if(gangle){newcenter={x:oldcenter.x+firstM.e,y:oldcenter.y+firstM.f};const newRot=svgroot.createSVGTransform();newRot.setRotate(gangle,newcenter.x,newcenter.y);if(tlist.numberOfItems){tlist.insertItemBefore(newRot,0);}else {tlist.appendItem(newRot);}}// if it was a resize
  }else if(operation===3){const m=transformListToTransform(tlist).matrix;const roldt=svgroot.createSVGTransform();roldt.setRotate(gangle,oldcenter.x,oldcenter.y);const rold=roldt.matrix;const rnew=svgroot.createSVGTransform();rnew.setRotate(gangle,newcenter.x,newcenter.y);const rnewInv=rnew.matrix.inverse();const mInv=m.inverse();const extrat=matrixMultiply(mInv,rnewInv,rold,m);tx=extrat.e;ty=extrat.f;if(tx!==0||ty!==0){// now push this transform down to the children
  // we pass the translates down to the individual children
  const children=selected.childNodes;let c=children.length;while(c--){const child=children.item(c);if(child.nodeType===1){var _child$transform3;oldStartTransform=svgCanvas$5.getStartTransform();svgCanvas$5.setStartTransform(child.getAttribute('transform'));const childTlist=(_child$transform3=child.transform)===null||_child$transform3===void 0?void 0:_child$transform3.baseVal;const newxlate=svgroot.createSVGTransform();newxlate.setTranslate(tx,ty);if(childTlist.numberOfItems){childTlist.insertItemBefore(newxlate,0);}else {childTlist.appendItem(newxlate);}const recalculatedDimensions=recalculateDimensions(child);if(recalculatedDimensions){batchCmd.addSubCommand(recalculatedDimensions);}svgCanvas$5.setStartTransform(oldStartTransform);}}}if(gangle){if(tlist.numberOfItems){tlist.insertItemBefore(rnew,0);}else {tlist.appendItem(rnew);}}}// else, it's a non-group
  }else {// TODO: box might be null for some elements (<metadata> etc), need to handle this
  const box=getBBox(selected);// Paths (and possbly other shapes) will have no BBox while still in <defs>,
  // but we still may need to recalculate them (see issue 595).
  // TODO: Figure out how to get BBox from these elements in case they
  // have a rotation transform
  if(!box&&selected.tagName!=='path')return null;let m;// = svgroot.createSVGMatrix();
  // temporarily strip off the rotate and save the old center
  const angle=getRotationAngle(selected);if(angle){oldcenter={x:box.x+box.width/2,y:box.y+box.height/2};newcenter=transformPoint(box.x+box.width/2,box.y+box.height/2,transformListToTransform(tlist).matrix);const a=angle*Math.PI/180;const s=Math.abs(a)>1.0e-10?Math.sin(a)/(1-Math.cos(a))// TODO: This blows up if the angle is exactly 0!
  :2/a;for(let i=0;i<tlist.numberOfItems;++i){const xform=tlist.getItem(i);if(xform.type===4){// extract old center through mystical arts
  const rm=xform.matrix;oldcenter.y=(s*rm.e+rm.f)/2;oldcenter.x=(rm.e-s*rm.f)/2;tlist.removeItem(i);break;}}}// 2 = translate, 3 = scale, 4 = rotate, 1 = matrix imposition
  let operation=0;const N=tlist.numberOfItems;// Check if it has a gradient with userSpaceOnUse, in which case
  // adjust it by recalculating the matrix transform.
  const fill=selected.getAttribute('fill');if(fill!==null&&fill!==void 0&&fill.startsWith('url(')){const paint=getRefElem(fill);if(paint){let type='pattern';if((paint===null||paint===void 0?void 0:paint.tagName)!==type)type='gradient';const attrVal=paint.getAttribute(type+'Units');if(attrVal==='userSpaceOnUse'){// Update the userSpaceOnUse element
  m=transformListToTransform(tlist).matrix;const gtlist=paint.transform.baseVal;const gmatrix=transformListToTransform(gtlist).matrix;m=matrixMultiply(m,gmatrix);const mStr='matrix('+[m.a,m.b,m.c,m.d,m.e,m.f].join(',')+')';paint.setAttribute(type+'Transform',mStr);}}}// first, if it was a scale of a non-skewed element, then the second-last
  // transform will be the [S]
  // if we had [M][T][S][T] we want to extract the matrix equivalent of
  // [T][S][T] and push it down to the element
  if(N>=3&&tlist.getItem(N-2).type===3&&tlist.getItem(N-3).type===2&&tlist.getItem(N-1).type===2){// Removed this so a <use> with a given [T][S][T] would convert to a matrix.
  // Is that bad?
  //  && selected.nodeName != 'use'
  operation=3;// scale
  m=transformListToTransform(tlist,N-3,N-1).matrix;tlist.removeItem(N-1);tlist.removeItem(N-2);tlist.removeItem(N-3);// if we had [T][S][-T][M], then this was a skewed element being resized
  // Thus, we simply combine it all into one matrix
  }else if(N===4&&tlist.getItem(N-1).type===1){operation=3;// scale
  m=transformListToTransform(tlist).matrix;const e2t=svgroot.createSVGTransform();e2t.setMatrix(m);tlist.clear();tlist.appendItem(e2t);// reset the matrix so that the element is not re-mapped
  m=svgroot.createSVGMatrix();// if we had [R][T][S][-T][M], then this was a rotated matrix-element
  // if we had [T1][M] we want to transform this into [M][T2]
  // therefore [ T2 ] = [ M_inv ] [ T1 ] [ M ] and we can push [T2]
  // down to the element
  }else if((N===1||N>1&&tlist.getItem(1).type!==3)&&tlist.getItem(0).type===2){operation=2;// translate
  const oldxlate=tlist.getItem(0).matrix;const meq=transformListToTransform(tlist,1).matrix;const meqInv=meq.inverse();m=matrixMultiply(meqInv,oldxlate,meq);tlist.removeItem(0);// else if this child now has a matrix imposition (from a parent group)
  // we might be able to simplify
  }else if(N===1&&tlist.getItem(0).type===1&&!angle){// Remap all point-based elements
  m=transformListToTransform(tlist).matrix;switch(selected.tagName){case'line':changes={x1:selected.getAttribute('x1'),y1:selected.getAttribute('y1'),x2:selected.getAttribute('x2'),y2:selected.getAttribute('y2')};// Fallthrough
  case'polyline':case'polygon':changes.points=selected.getAttribute('points');if(changes.points){const list=selected.points;const len=list.numberOfItems;changes.points=new Array(len);for(let i=0;i<len;++i){const pt=list.getItem(i);changes.points[i]={x:pt.x,y:pt.y};}}// Fallthrough
  case'path':changes.d=selected.getAttribute('d');operation=1;tlist.clear();break;}// if it was a rotation, put the rotate back and return without a command
  // (this function has zero work to do for a rotate())
  }else {// operation = 4; // rotation
  if(angle){const newRot=svgroot.createSVGTransform();newRot.setRotate(angle,newcenter.x,newcenter.y);if(tlist.numberOfItems){tlist.insertItemBefore(newRot,0);}else {tlist.appendItem(newRot);}}if(tlist.numberOfItems===0){selected.removeAttribute('transform');}return null;}// if it was a translate or resize, we need to remap the element and absorb the xform
  if(operation===1||operation===2||operation===3){remapElement(selected,changes,m);}// if we are remapping
  // if it was a translate, put back the rotate at the new center
  if(operation===2){if(angle){if(!hasMatrixTransform(tlist)){newcenter={x:oldcenter.x+m.e,y:oldcenter.y+m.f};}const newRot=svgroot.createSVGTransform();newRot.setRotate(angle,newcenter.x,newcenter.y);if(tlist.numberOfItems){tlist.insertItemBefore(newRot,0);}else {tlist.appendItem(newRot);}}// We have special processing for tspans:  Tspans are not transformable
  // but they can have x,y coordinates (sigh).  Thus, if this was a translate,
  // on a text element, also translate any tspan children.
  if(selected.tagName==='text'){const children=selected.childNodes;let c=children.length;while(c--){const child=children.item(c);if(child.tagName==='tspan'){const tspanChanges={x:Number(child.getAttribute('x'))||0,y:Number(child.getAttribute('y'))||0};remapElement(child,tspanChanges,m);}}}// [Rold][M][T][S][-T] became [Rold][M]
  // we want it to be [Rnew][M][Tr] where Tr is the
  // translation required to re-center it
  // Therefore, [Tr] = [M_inv][Rnew_inv][Rold][M]
  }else if(operation===3&&angle){const{matrix}=transformListToTransform(tlist);const roldt=svgroot.createSVGTransform();roldt.setRotate(angle,oldcenter.x,oldcenter.y);const rold=roldt.matrix;const rnew=svgroot.createSVGTransform();rnew.setRotate(angle,newcenter.x,newcenter.y);const rnewInv=rnew.matrix.inverse();const mInv=matrix.inverse();const extrat=matrixMultiply(mInv,rnewInv,rold,matrix);remapElement(selected,changes,extrat);if(angle){if(tlist.numberOfItems){tlist.insertItemBefore(rnew,0);}else {tlist.appendItem(rnew);}}}}// a non-group
  // if the transform list has been emptied, remove it
  if(tlist.numberOfItems===0){selected.removeAttribute('transform');}batchCmd.addSubCommand(new ChangeElementCommand$2(selected,initial));return batchCmd;};/**
   * Tools for SVG selected element operation.
   * @module selected-elem
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */const{MoveElementCommand,BatchCommand:BatchCommand$1,InsertElementCommand:InsertElementCommand$1,RemoveElementCommand:RemoveElementCommand$1,ChangeElementCommand:ChangeElementCommand$1}=history;let svgCanvas$4=null;/**
   * @function module:selected-elem.init
   * @param {module:selected-elem.elementContext} elementContext
   * @returns {void}
   */const init$4=canvas=>{svgCanvas$4=canvas;svgCanvas$4.copySelectedElements=copySelectedElements;svgCanvas$4.groupSelectedElements=groupSelectedElements;// Wraps all the selected elements in a group (`g`) element.
  svgCanvas$4.pushGroupProperties=pushGroupProperty;// Pushes all appropriate parent group properties down to its children
  svgCanvas$4.ungroupSelectedElement=ungroupSelectedElement;// Unwraps all the elements in a selected group (`g`) element
  svgCanvas$4.moveToTopSelectedElement=moveToTopSelectedElem;// Repositions the selected element to the bottom in the DOM to appear on top
  svgCanvas$4.moveToBottomSelectedElement=moveToBottomSelectedElem;// Repositions the selected element to the top in the DOM to appear under other elements
  svgCanvas$4.moveUpDownSelected=moveUpDownSelected;// Moves the select element up or down the stack, based on the visibly
  svgCanvas$4.moveSelectedElements=moveSelectedElements;// Moves selected elements on the X/Y axis.
  svgCanvas$4.cloneSelectedElements=cloneSelectedElements;// Create deep DOM copies (clones) of all selected elements and move them slightly
  svgCanvas$4.alignSelectedElements=alignSelectedElements;// Aligns selected elements.
  svgCanvas$4.updateCanvas=updateCanvas;// Updates the editor canvas width/height/position after a zoom has occurred.
  svgCanvas$4.cycleElement=cycleElement;// Select the next/previous element within the current layer.
  svgCanvas$4.deleteSelectedElements=deleteSelectedElements;// Removes all selected elements from the DOM and adds the change to the history
  };/**
   * Repositions the selected element to the bottom in the DOM to appear on top of
   * other elements.
   * @function module:selected-elem.SvgCanvas#moveToTopSelectedElem
   * @fires module:selected-elem.SvgCanvas#event:changed
   * @returns {void}
   */const moveToTopSelectedElem=()=>{const[selected]=svgCanvas$4.getSelectedElements();if(selected){const t=selected;const oldParent=t.parentNode;const oldNextSibling=t.nextSibling;t.parentNode.append(t);// If the element actually moved position, add the command and fire the changed
  // event handler.
  if(oldNextSibling!==t.nextSibling){svgCanvas$4.addCommandToHistory(new MoveElementCommand(t,oldNextSibling,oldParent,'top'));svgCanvas$4.call('changed',[t]);}}};/**
   * Repositions the selected element to the top in the DOM to appear under
   * other elements.
   * @function module:selected-elem.SvgCanvas#moveToBottomSelectedElement
   * @fires module:selected-elem.SvgCanvas#event:changed
   * @returns {void}
   */const moveToBottomSelectedElem=()=>{const[selected]=svgCanvas$4.getSelectedElements();if(selected){let t=selected;const oldParent=t.parentNode;const oldNextSibling=t.nextSibling;let{firstChild}=t.parentNode;if(firstChild.tagName==='title'){firstChild=firstChild.nextSibling;}// This can probably be removed, as the defs should not ever apppear
  // inside a layer group
  if(firstChild.tagName==='defs'){firstChild=firstChild.nextSibling;}t=t.parentNode.insertBefore(t,firstChild);// If the element actually moved position, add the command and fire the changed
  // event handler.
  if(oldNextSibling!==t.nextSibling){svgCanvas$4.addCommandToHistory(new MoveElementCommand(t,oldNextSibling,oldParent,'bottom'));svgCanvas$4.call('changed',[t]);}}};/**
   * Moves the select element up or down the stack, based on the visibly
   * intersecting elements.
   * @function module:selected-elem.SvgCanvas#moveUpDownSelected
   * @param {"Up"|"Down"} dir - String that's either 'Up' or 'Down'
   * @fires module:selected-elem.SvgCanvas#event:changed
   * @returns {void}
   */const moveUpDownSelected=dir=>{const selectedElements=svgCanvas$4.getSelectedElements();const selected=selectedElements[0];if(!selected){return;}svgCanvas$4.setCurBBoxes([]);let closest;let foundCur;// jQuery sorts this list
  const list=svgCanvas$4.getIntersectionList(getStrokedBBoxDefaultVisible([selected]));if(dir==='Down'){list.reverse();}Array.prototype.forEach.call(list,el=>{if(!foundCur){if(el===selected){foundCur=true;}return true;}if(closest===undefined){closest=el;}return false;});if(!closest){return;}const t=selected;const oldParent=t.parentNode;const oldNextSibling=t.nextSibling;if(dir==='Down'){closest.insertAdjacentElement('beforebegin',t);}else {closest.insertAdjacentElement('afterend',t);}// If the element actually moved position, add the command and fire the changed
  // event handler.
  if(oldNextSibling!==t.nextSibling){svgCanvas$4.addCommandToHistory(new MoveElementCommand(t,oldNextSibling,oldParent,'Move '+dir));svgCanvas$4.call('changed',[t]);}};/**
   * Moves selected elements on the X/Y axis.
   * @function module:selected-elem.SvgCanvas#moveSelectedElements
   * @param {Float} dx - Float with the distance to move on the x-axis
   * @param {Float} dy - Float with the distance to move on the y-axis
   * @param {boolean} undoable - Boolean indicating whether or not the action should be undoable
   * @fires module:selected-elem.SvgCanvas#event:changed
   * @returns {BatchCommand|void} Batch command for the move
   */const moveSelectedElements=function(dx,dy){let undoable=arguments.length>2&&arguments[2]!==undefined?arguments[2]:true;const selectedElements=svgCanvas$4.getSelectedElements();const zoom=svgCanvas$4.getZoom();// if undoable is not sent, default to true
  // if single values, scale them to the zoom
  if(!Array.isArray(dx)){dx/=zoom;dy/=zoom;}const batchCmd=new BatchCommand$1('position');selectedElements.forEach((selected,i)=>{if(selected){var _selected$transform3;const xform=svgCanvas$4.getSvgRoot().createSVGTransform();const tlist=(_selected$transform3=selected.transform)===null||_selected$transform3===void 0?void 0:_selected$transform3.baseVal;// dx and dy could be arrays
  if(Array.isArray(dx)){xform.setTranslate(dx[i],dy[i]);}else {xform.setTranslate(dx,dy);}if(tlist.numberOfItems){tlist.insertItemBefore(xform,0);}else {tlist.appendItem(xform);}const cmd=recalculateDimensions(selected);if(cmd){batchCmd.addSubCommand(cmd);}svgCanvas$4.gettingSelectorManager().requestSelector(selected).resize();}});if(!batchCmd.isEmpty()){if(undoable){svgCanvas$4.addCommandToHistory(batchCmd);}svgCanvas$4.call('changed',selectedElements);return batchCmd;}return undefined;};/**
   * Create deep DOM copies (clones) of all selected elements and move them slightly
   * from their originals.
   * @function module:selected-elem.SvgCanvas#cloneSelectedElements
   * @param {Float} x Float with the distance to move on the x-axis
   * @param {Float} y Float with the distance to move on the y-axis
   * @returns {void}
   */const cloneSelectedElements=(x,y)=>{const selectedElements=svgCanvas$4.getSelectedElements();const currentGroup=svgCanvas$4.getCurrentGroup();let i;let elem;const batchCmd=new BatchCommand$1('Clone Elements');// find all the elements selected (stop at first null)
  const len=selectedElements.length;const index=el=>{if(!el)return -1;let i=0;do{i++;}while(el===el.previousElementSibling);return i;};/**
     * Sorts an array numerically and ascending.
     * @param {Element} a
     * @param {Element} b
     * @returns {Integer}
     */const sortfunction=(a,b)=>{return index(b)-index(a);};selectedElements.sort(sortfunction);for(i=0;i<len;++i){elem=selectedElements[i];if(!elem){break;}}// use slice to quickly get the subset of elements we need
  const copiedElements=selectedElements.slice(0,i);svgCanvas$4.clearSelection(true);// note that we loop in the reverse way because of the way elements are added
  // to the selectedElements array (top-first)
  const drawing=svgCanvas$4.getDrawing();i=copiedElements.length;while(i--){// clone each element and replace it within copiedElements
  elem=copiedElements[i]=drawing.copyElem(copiedElements[i]);(currentGroup||drawing.getCurrentLayer()).append(elem);batchCmd.addSubCommand(new InsertElementCommand$1(elem));}if(!batchCmd.isEmpty()){svgCanvas$4.addToSelection(copiedElements.reverse());// Need to reverse for correct selection-adding
  moveSelectedElements(x,y,false);svgCanvas$4.addCommandToHistory(batchCmd);}};/**
   * Aligns selected elements.
   * @function module:selected-elem.SvgCanvas#alignSelectedElements
   * @param {string} type - String with single character indicating the alignment type
   * @param {"selected"|"largest"|"smallest"|"page"} relativeTo
   * @returns {void}
   */const alignSelectedElements=(type,relativeTo)=>{const selectedElements=svgCanvas$4.getSelectedElements();const bboxes=[];// angles = [];
  const len=selectedElements.length;if(!len){return;}let minx=Number.MAX_VALUE;let maxx=Number.MIN_VALUE;let miny=Number.MAX_VALUE;let maxy=Number.MIN_VALUE;const isHorizontalAlign=type=>['l','c','r','left','center','right'].includes(type);const isVerticalAlign=type=>['t','m','b','top','middle','bottom'].includes(type);for(let i=0;i<len;++i){if(!selectedElements[i]){break;}const elem=selectedElements[i];bboxes[i]=getStrokedBBoxDefaultVisible([elem]);}// distribute horizontal and vertical align is not support smallest and largest
  if(['smallest','largest'].includes(relativeTo)&&['dh','distrib_horiz','dv','distrib_verti'].includes(type)){relativeTo='selected';}switch(relativeTo){case'smallest':if(isHorizontalAlign(type)||isVerticalAlign(type)){const sortedBboxes=bboxes.slice().sort((a,b)=>a.width-b.width);const minBbox=sortedBboxes[0];minx=minBbox.x;miny=minBbox.y;maxx=minBbox.x+minBbox.width;maxy=minBbox.y+minBbox.height;}break;case'largest':if(isHorizontalAlign(type)||isVerticalAlign(type)){const sortedBboxes=bboxes.slice().sort((a,b)=>a.width-b.width);const maxBbox=sortedBboxes[bboxes.length-1];minx=maxBbox.x;miny=maxBbox.y;maxx=maxBbox.x+maxBbox.width;maxy=maxBbox.y+maxBbox.height;}break;case'page':minx=0;miny=0;maxx=svgCanvas$4.getContentW();maxy=svgCanvas$4.getContentH();break;default:// 'selected'
  minx=Math.min(...bboxes.map(box=>box.x));miny=Math.min(...bboxes.map(box=>box.y));maxx=Math.max(...bboxes.map(box=>box.x+box.width));maxy=Math.max(...bboxes.map(box=>box.y+box.height));break;}// adjust min/max
  let dx=[];let dy=[];if(['dh','distrib_horiz'].includes(type)){// distribute horizontal align
  [dx,dy]=_getDistributeHorizontalDistances(relativeTo,selectedElements,bboxes,minx,maxx,miny,maxy);}else if(['dv','distrib_verti'].includes(type)){// distribute vertical align
  [dx,dy]=_getDistributeVerticalDistances(relativeTo,selectedElements,bboxes,minx,maxx,miny,maxy);}else {// normal align (top, left, right, ...)
  [dx,dy]=_getNormalDistances(type,selectedElements,bboxes,minx,maxx,miny,maxy);}moveSelectedElements(dx,dy);};/**
   * Aligns selected elements.
   * @function module:selected-elem.SvgCanvas#alignSelectedElements
   * @param {string} type - String with single character indicating the alignment type
   * @param {"selected"|"largest"|"smallest"|"page"} relativeTo
   * @returns {void}
   */ /**
   * get distribution horizontal distances.
   * (internal call only)
   *
   * @param {string} relativeTo
   * @param {Element[]} selectedElements - the array with selected DOM elements
   * @param {module:utilities.BBoxObject} bboxes - bounding box objects
   * @param {Float} minx - selected area min-x
   * @param {Float} maxx - selected area max-x
   * @param {Float} miny - selected area min-y
   * @param {Float} maxy - selected area max-y
   * @returns {Array.Float[]} x and y distances array
   * @private
   */const _getDistributeHorizontalDistances=(relativeTo,selectedElements,bboxes,minx,maxx,miny,maxy)=>{const dx=[];const dy=[];for(let i=0;i<selectedElements.length;i++){dy[i]=0;}const bboxesSortedClone=bboxes.slice().sort((firstBox,secondBox)=>{const firstMaxX=firstBox.x+firstBox.width;const secondMaxX=secondBox.x+secondBox.width;if(firstMaxX===secondMaxX){return 0;}else if(firstMaxX>secondMaxX){return 1;}else {return -1;}});if(relativeTo==='page'){bboxesSortedClone.unshift({x:0,y:0,width:0,height:maxy});// virtual left box
  bboxesSortedClone.push({x:maxx,y:0,width:0,height:maxy});// virtual right box
  }const totalWidth=maxx-minx;const totalBoxWidth=bboxesSortedClone.map(b=>b.width).reduce((w1,w2)=>w1+w2,0);const space=(totalWidth-totalBoxWidth)/(bboxesSortedClone.length-1);const _dx=[];for(let i=0;i<bboxesSortedClone.length;++i){_dx[i]=0;if(i===0){continue;}const orgX=bboxesSortedClone[i].x;bboxesSortedClone[i].x=bboxesSortedClone[i-1].x+bboxesSortedClone[i-1].width+space;_dx[i]=bboxesSortedClone[i].x-orgX;}bboxesSortedClone.forEach((boxClone,idx)=>{const orgIdx=bboxes.findIndex(box=>box===boxClone);if(orgIdx!==-1){dx[orgIdx]=_dx[idx];}});return [dx,dy];};/**
   * get distribution vertical distances.
   * (internal call only)
   *
   * @param {string} relativeTo
   * @param {Element[]} selectedElements - the array with selected DOM elements
   * @param {module:utilities.BBoxObject} bboxes - bounding box objects
   * @param {Float} minx - selected area min-x
   * @param {Float} maxx - selected area max-x
   * @param {Float} miny - selected area min-y
   * @param {Float} maxy - selected area max-y
   * @returns {Array.Float[]}} x and y distances array
   * @private
   */const _getDistributeVerticalDistances=(relativeTo,selectedElements,bboxes,minx,maxx,miny,maxy)=>{const dx=[];const dy=[];for(let i=0;i<selectedElements.length;i++){dx[i]=0;}const bboxesSortedClone=bboxes.slice().sort((firstBox,secondBox)=>{const firstMaxY=firstBox.y+firstBox.height;const secondMaxY=secondBox.y+secondBox.height;if(firstMaxY===secondMaxY){return 0;}else if(firstMaxY>secondMaxY){return 1;}else {return -1;}});if(relativeTo==='page'){bboxesSortedClone.unshift({x:0,y:0,width:maxx,height:0});// virtual top box
  bboxesSortedClone.push({x:0,y:maxy,width:maxx,height:0});// virtual bottom box
  }const totalHeight=maxy-miny;const totalBoxHeight=bboxesSortedClone.map(b=>b.height).reduce((h1,h2)=>h1+h2,0);const space=(totalHeight-totalBoxHeight)/(bboxesSortedClone.length-1);const _dy=[];for(let i=0;i<bboxesSortedClone.length;++i){_dy[i]=0;if(i===0){continue;}const orgY=bboxesSortedClone[i].y;bboxesSortedClone[i].y=bboxesSortedClone[i-1].y+bboxesSortedClone[i-1].height+space;_dy[i]=bboxesSortedClone[i].y-orgY;}bboxesSortedClone.forEach((boxClone,idx)=>{const orgIdx=bboxes.findIndex(box=>box===boxClone);if(orgIdx!==-1){dy[orgIdx]=_dy[idx];}});return [dx,dy];};/**
   * get normal align distances.
   * (internal call only)
   *
   * @param {string} type
   * @param {Element[]} selectedElements - the array with selected DOM elements
   * @param {module:utilities.BBoxObject} bboxes - bounding box objects
   * @param {Float} minx - selected area min-x
   * @param {Float} maxx - selected area max-x
   * @param {Float} miny - selected area min-y
   * @param {Float} maxy - selected area max-y
   * @returns {Array.Float[]} x and y distances array
   * @private
   */const _getNormalDistances=(type,selectedElements,bboxes,minx,maxx,miny,maxy)=>{const len=selectedElements.length;const dx=new Array(len);const dy=new Array(len);for(let i=0;i<len;++i){if(!selectedElements[i]){break;}// const elem = selectedElements[i];
  const bbox=bboxes[i];dx[i]=0;dy[i]=0;switch(type){case'l':// left (horizontal)
  case'left':// left (horizontal)
  dx[i]=minx-bbox.x;break;case'c':// center (horizontal)
  case'center':// center (horizontal)
  dx[i]=(minx+maxx)/2-(bbox.x+bbox.width/2);break;case'r':// right (horizontal)
  case'right':// right (horizontal)
  dx[i]=maxx-(bbox.x+bbox.width);break;case't':// top (vertical)
  case'top':// top (vertical)
  dy[i]=miny-bbox.y;break;case'm':// middle (vertical)
  case'middle':// middle (vertical)
  dy[i]=(miny+maxy)/2-(bbox.y+bbox.height/2);break;case'b':// bottom (vertical)
  case'bottom':// bottom (vertical)
  dy[i]=maxy-(bbox.y+bbox.height);break;}}return [dx,dy];};/**
   * Removes all selected elements from the DOM and adds the change to the
   * history stack.
   * @function module:selected-elem.SvgCanvas#deleteSelectedElements
   * @fires module:selected-elem.SvgCanvas#event:changed
   * @returns {void}
   */const deleteSelectedElements=()=>{const selectedElements=svgCanvas$4.getSelectedElements();const batchCmd=new BatchCommand$1('Delete Elements');const selectedCopy=[];// selectedElements is being deleted
  selectedElements.forEach(selected=>{if(selected){let parent=selected.parentNode;let t=selected;// this will unselect the element and remove the selectedOutline
  svgCanvas$4.gettingSelectorManager().releaseSelector(t);// Remove the path if present.
  removePath_(t.id);// Get the parent if it's a single-child anchor
  if(parent.tagName==='a'&&parent.childNodes.length===1){t=parent;parent=parent.parentNode;}const{nextSibling}=t;t.remove();const elem=t;selectedCopy.push(selected);// for the copy
  batchCmd.addSubCommand(new RemoveElementCommand$1(elem,nextSibling,parent));}});svgCanvas$4.setEmptySelectedElements();if(!batchCmd.isEmpty()){svgCanvas$4.addCommandToHistory(batchCmd);}svgCanvas$4.call('changed',selectedCopy);svgCanvas$4.clearSelection();};/**
   * Remembers the current selected elements on the clipboard.
   * @function module:selected-elem.SvgCanvas#copySelectedElements
   * @returns {void}
   */const copySelectedElements=()=>{const selectedElements=svgCanvas$4.getSelectedElements();const data=JSON.stringify(selectedElements.map(x=>svgCanvas$4.getJsonFromSvgElements(x)));// Use sessionStorage for the clipboard data.
  sessionStorage.setItem(svgCanvas$4.getClipboardID(),data);svgCanvas$4.flashStorage();// Context menu might not exist (it is provided by editor.js).
  const canvMenu=document.getElementById('se-cmenu_canvas');canvMenu.setAttribute('enablemenuitems','#paste,#paste_in_place');};/**
   * Wraps all the selected elements in a group (`g`) element.
   * @function module:selected-elem.SvgCanvas#groupSelectedElements
   * @param {"a"|"g"} [type="g"] - type of element to group into, defaults to `<g>`
   * @param {string} [urlArg]
   * @returns {void}
   */const groupSelectedElements=(type,urlArg)=>{const selectedElements=svgCanvas$4.getSelectedElements();if(!type){type='g';}let cmdStr='';let url;switch(type){case'a':{cmdStr='Make hyperlink';url=urlArg||'';break;}default:{type='g';cmdStr='Group Elements';break;}}const batchCmd=new BatchCommand$1(cmdStr);// create and insert the group element
  const g=svgCanvas$4.addSVGElementsFromJson({element:type,attr:{id:svgCanvas$4.getNextId()}});if(type==='a'){setHref(g,url);}batchCmd.addSubCommand(new InsertElementCommand$1(g));// now move all children into the group
  let i=selectedElements.length;while(i--){let elem=selectedElements[i];if(!elem){continue;}if(elem.parentNode.tagName==='a'&&elem.parentNode.childNodes.length===1){elem=elem.parentNode;}const oldNextSibling=elem.nextSibling;const oldParent=elem.parentNode;g.append(elem);batchCmd.addSubCommand(new MoveElementCommand(elem,oldNextSibling,oldParent));}if(!batchCmd.isEmpty()){svgCanvas$4.addCommandToHistory(batchCmd);}// update selection
  svgCanvas$4.selectOnly([g],true);};/**
   * Pushes all appropriate parent group properties down to its children, then
   * removes them from the group.
   * @function module:selected-elem.SvgCanvas#pushGroupProperty
   * @param {SVGAElement|SVGGElement} g
   * @param {boolean} undoable
   * @returns {BatchCommand|void}
   */const pushGroupProperty=(g,undoable)=>{const children=g.childNodes;const len=children.length;const xform=g.getAttribute('transform');const glist=g.transform.baseVal;const m=transformListToTransform(glist).matrix;const batchCmd=new BatchCommand$1('Push group properties');// TODO: get all fill/stroke properties from the group that we are about to destroy
  // "fill", "fill-opacity", "fill-rule", "stroke", "stroke-dasharray", "stroke-dashoffset",
  // "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity",
  // "stroke-width"
  // and then for each child, if they do not have the attribute (or the value is 'inherit')
  // then set the child's attribute
  const gangle=getRotationAngle(g);const gattrs={filter:g.getAttribute('filter'),opacity:g.getAttribute('opacity')};let gfilter;let gblur;let changes;const drawing=svgCanvas$4.getDrawing();for(let i=0;i<len;i++){var _elem$transform2;const elem=children[i];if(elem.nodeType!==1){continue;}if(gattrs.opacity!==null&&gattrs.opacity!==1){// const c_opac = elem.getAttribute('opacity') || 1;
  const newOpac=Math.round((elem.getAttribute('opacity')||1)*gattrs.opacity*100)/100;svgCanvas$4.changeSelectedAttribute('opacity',newOpac,[elem]);}if(gattrs.filter){let cblur=svgCanvas$4.getBlur(elem);const origCblur=cblur;if(!gblur){gblur=svgCanvas$4.getBlur(g);}if(cblur){// Is this formula correct?
  cblur=Number(gblur)+Number(cblur);}else if(cblur===0){cblur=gblur;}// If child has no current filter, get group's filter or clone it.
  if(!origCblur){// Set group's filter to use first child's ID
  if(!gfilter){gfilter=getRefElem(gattrs.filter);}else {// Clone the group's filter
  gfilter=drawing.copyElem(gfilter);findDefs().append(gfilter);// const filterElem = getRefElem(gfilter);
  const blurElem=getFeGaussianBlur(gfilter);// Change this in future for different filters
  const suffix=(blurElem===null||blurElem===void 0?void 0:blurElem.tagName)==='feGaussianBlur'?'blur':'filter';gfilter.id=elem.id+'_'+suffix;svgCanvas$4.changeSelectedAttribute('filter','url(#'+gfilter.id+')',[elem]);}}else {gfilter=getRefElem(elem.getAttribute('filter'));}// const filterElem = getRefElem(gfilter);
  const blurElem=getFeGaussianBlur(gfilter);// Update blur value
  if(cblur){svgCanvas$4.changeSelectedAttribute('stdDeviation',cblur,[blurElem]);svgCanvas$4.setBlurOffsets(gfilter,cblur);}}let chtlist=(_elem$transform2=elem.transform)===null||_elem$transform2===void 0?void 0:_elem$transform2.baseVal;// Don't process gradient transforms
  if(elem.tagName.includes('Gradient')){chtlist=null;}// Hopefully not a problem to add this. Necessary for elements like <desc/>
  if(!chtlist){continue;}// Apparently <defs> can get get a transformlist, but we don't want it to have one!
  if(elem.tagName==='defs'){continue;}if(glist.numberOfItems){// TODO: if the group's transform is just a rotate, we can always transfer the
  // rotate() down to the children (collapsing consecutive rotates and factoring
  // out any translates)
  if(gangle&&glist.numberOfItems===1){// [Rg] [Rc] [Mc]
  // we want [Tr] [Rc2] [Mc] where:
  //  - [Rc2] is at the child's current center but has the
  // sum of the group and child's rotation angles
  //  - [Tr] is the equivalent translation that this child
  // undergoes if the group wasn't there
  // [Tr] = [Rg] [Rc] [Rc2_inv]
  // get group's rotation matrix (Rg)
  const rgm=glist.getItem(0).matrix;// get child's rotation matrix (Rc)
  let rcm=svgCanvas$4.getSvgRoot().createSVGMatrix();const cangle=getRotationAngle(elem);if(cangle){rcm=chtlist.getItem(0).matrix;}// get child's old center of rotation
  const cbox=getBBox(elem);const ceqm=transformListToTransform(chtlist).matrix;const coldc=transformPoint(cbox.x+cbox.width/2,cbox.y+cbox.height/2,ceqm);// sum group and child's angles
  const sangle=gangle+cangle;// get child's rotation at the old center (Rc2_inv)
  const r2=svgCanvas$4.getSvgRoot().createSVGTransform();r2.setRotate(sangle,coldc.x,coldc.y);// calculate equivalent translate
  const trm=matrixMultiply(rgm,rcm,r2.matrix.inverse());// set up tlist
  if(cangle){chtlist.removeItem(0);}if(sangle){if(chtlist.numberOfItems){chtlist.insertItemBefore(r2,0);}else {chtlist.appendItem(r2);}}if(trm.e||trm.f){const tr=svgCanvas$4.getSvgRoot().createSVGTransform();tr.setTranslate(trm.e,trm.f);if(chtlist.numberOfItems){chtlist.insertItemBefore(tr,0);}else {chtlist.appendItem(tr);}}}else {// more complicated than just a rotate
  // transfer the group's transform down to each child and then
  // call recalculateDimensions()
  const oldxform=elem.getAttribute('transform');changes={};changes.transform=oldxform||'';const newxform=svgCanvas$4.getSvgRoot().createSVGTransform();// [ gm ] [ chm ] = [ chm ] [ gm' ]
  // [ gm' ] = [ chmInv ] [ gm ] [ chm ]
  const chm=transformListToTransform(chtlist).matrix;const chmInv=chm.inverse();const gm=matrixMultiply(chmInv,m,chm);newxform.setMatrix(gm);chtlist.appendItem(newxform);}const cmd=recalculateDimensions(elem);if(cmd){batchCmd.addSubCommand(cmd);}}}// remove transform and make it undo-able
  if(xform){changes={};changes.transform=xform;g.setAttribute('transform','');g.removeAttribute('transform');batchCmd.addSubCommand(new ChangeElementCommand$1(g,changes));}if(undoable&&!batchCmd.isEmpty()){return batchCmd;}return undefined;};/**
   * Converts selected/given `<use>` or child SVG element to a group.
   * @function module:selected-elem.SvgCanvas#convertToGroup
   * @param {Element} elem
   * @fires module:selected-elem.SvgCanvas#event:selected
   * @returns {void}
   */const convertToGroup=elem=>{const selectedElements=svgCanvas$4.getSelectedElements();if(!elem){elem=selectedElements[0];}const $elem=elem;const batchCmd=new BatchCommand$1();let ts;const dataStorage=svgCanvas$4.getDataStorage();if(dataStorage.has($elem,'gsvg')){// Use the gsvg as the new group
  const svg=elem.firstChild;const pt={x:Number(svg.getAttribute('x')),y:Number(svg.getAttribute('y'))};// $(elem.firstChild.firstChild).unwrap();
  const firstChild=elem.firstChild.firstChild;if(firstChild){firstChild.outerHTML=firstChild.innerHTML;}dataStorage.remove(elem,'gsvg');const tlist=elem.transform.baseVal;const xform=svgCanvas$4.getSvgRoot().createSVGTransform();xform.setTranslate(pt.x,pt.y);tlist.appendItem(xform);recalculateDimensions(elem);svgCanvas$4.call('selected',[elem]);}else if(dataStorage.has($elem,'symbol')){elem=dataStorage.get($elem,'symbol');ts=$elem.getAttribute('transform')||'';const pos={x:Number($elem.getAttribute('x')),y:Number($elem.getAttribute('y'))};const vb=elem.getAttribute('viewBox');if(vb){const nums=vb.split(' ');pos.x-=Number(nums[0]);pos.y-=Number(nums[1]);}// Not ideal, but works
  ts+=' translate('+(pos.x||0)+','+(pos.y||0)+')';const prev=$elem.previousElementSibling;// Remove <use> element
  batchCmd.addSubCommand(new RemoveElementCommand$1($elem,$elem.nextElementSibling,$elem.parentNode));$elem.remove();// See if other elements reference this symbol
  const svgContent=svgCanvas$4.getSvgContent();// const hasMore = svgContent.querySelectorAll('use:data(symbol)').length;
  // @todo review this logic
  const hasMore=svgContent.querySelectorAll('use').length;const g=svgCanvas$4.getDOMDocument().createElementNS(NS.SVG,'g');const childs=elem.childNodes;let i;for(i=0;i<childs.length;i++){g.append(childs[i].cloneNode(true));}// Duplicate the gradients for Gecko, since they weren't included in the <symbol>
  if(isGecko$1()){const svgElement=findDefs();const gradients=svgElement.querySelectorAll('linearGradient,radialGradient,pattern');for(let i=0,im=gradients.length;im>i;i++){g.appendChild(gradients[i].cloneNode(true));}}if(ts){g.setAttribute('transform',ts);}const parent=elem.parentNode;svgCanvas$4.uniquifyElems(g);// Put the dupe gradients back into <defs> (after uniquifying them)
  if(isGecko$1()){const svgElement=findDefs();const elements=g.querySelectorAll('linearGradient,radialGradient,pattern');for(let i=0,im=elements.length;im>i;i++){svgElement.appendChild(elements[i]);}}// now give the g itself a new id
  g.id=svgCanvas$4.getNextId();prev.after(g);if(parent){if(!hasMore){// remove symbol/svg element
  const{nextSibling}=elem;elem.remove();batchCmd.addSubCommand(new RemoveElementCommand$1(elem,nextSibling,parent));}batchCmd.addSubCommand(new InsertElementCommand$1(g));}svgCanvas$4.setUseData(g);if(isGecko$1()){svgCanvas$4.convertGradients(findDefs());}else {svgCanvas$4.convertGradients(g);}// recalculate dimensions on the top-level children so that unnecessary transforms
  // are removed
  walkTreePost(g,n=>{try{recalculateDimensions(n);}catch(e){console.error(e);}});// Give ID for any visible element missing one
  const visElems=g.querySelectorAll(svgCanvas$4.getVisElems());Array.prototype.forEach.call(visElems,el=>{if(!el.id){el.id=svgCanvas$4.getNextId();}});svgCanvas$4.selectOnly([g]);const cm=pushGroupProperty(g,true);if(cm){batchCmd.addSubCommand(cm);}svgCanvas$4.addCommandToHistory(batchCmd);}else {console.warn('Unexpected element to ungroup:',elem);}};/**
   * Unwraps all the elements in a selected group (`g`) element. This requires
   * significant recalculations to apply group's transforms, etc. to its children.
   * @function module:selected-elem.SvgCanvas#ungroupSelectedElement
   * @returns {void}
   */const ungroupSelectedElement=()=>{const selectedElements=svgCanvas$4.getSelectedElements();const dataStorage=svgCanvas$4.getDataStorage();let g=selectedElements[0];if(!g){return;}if(dataStorage.has(g,'gsvg')||dataStorage.has(g,'symbol')){// Is svg, so actually convert to group
  convertToGroup(g);return;}if(g.tagName==='use'){// Somehow doesn't have data set, so retrieve
  const symbol=getElement(getHref(g).substr(1));dataStorage.put(g,'symbol',symbol);dataStorage.put(g,'ref',symbol);convertToGroup(g);return;}const parentsA=getParents(g.parentNode,'a');if(parentsA!==null&&parentsA!==void 0&&parentsA.length){g=parentsA[0];}// Look for parent "a"
  if(g.tagName==='g'||g.tagName==='a'){const batchCmd=new BatchCommand$1('Ungroup Elements');const cmd=pushGroupProperty(g,true);if(cmd){batchCmd.addSubCommand(cmd);}const parent=g.parentNode;const anchor=g.nextSibling;const children=new Array(g.childNodes.length);let i=0;while(g.firstChild){const elem=g.firstChild;const oldNextSibling=elem.nextSibling;const oldParent=elem.parentNode;// Remove child title elements
  if(elem.tagName==='title'){const{nextSibling}=elem;batchCmd.addSubCommand(new RemoveElementCommand$1(elem,nextSibling,oldParent));elem.remove();continue;}children[i++]=parent.insertBefore(elem,anchor);batchCmd.addSubCommand(new MoveElementCommand(elem,oldNextSibling,oldParent));}// remove the group from the selection
  svgCanvas$4.clearSelection();// delete the group element (but make undo-able)
  const gNextSibling=g.nextSibling;g.remove();batchCmd.addSubCommand(new RemoveElementCommand$1(g,gNextSibling,parent));if(!batchCmd.isEmpty()){svgCanvas$4.addCommandToHistory(batchCmd);}// update selection
  svgCanvas$4.addToSelection(children);}};/**
   * Updates the editor canvas width/height/position after a zoom has occurred.
   * @function module:svgcanvas.SvgCanvas#updateCanvas
   * @param {Float} w - Float with the new width
   * @param {Float} h - Float with the new height
   * @fires module:svgcanvas.SvgCanvas#event:ext_canvasUpdated
   * @returns {module:svgcanvas.CanvasInfo}
   */const updateCanvas=(w,h)=>{svgCanvas$4.getSvgRoot().setAttribute('width',w);svgCanvas$4.getSvgRoot().setAttribute('height',h);const zoom=svgCanvas$4.getZoom();const bg=document.getElementById('canvasBackground');const oldX=Number(svgCanvas$4.getSvgContent().getAttribute('x'));const oldY=Number(svgCanvas$4.getSvgContent().getAttribute('y'));const x=(w-svgCanvas$4.contentW*zoom)/2;const y=(h-svgCanvas$4.contentH*zoom)/2;assignAttributes(svgCanvas$4.getSvgContent(),{width:svgCanvas$4.contentW*zoom,height:svgCanvas$4.contentH*zoom,x,y,viewBox:'0 0 '+svgCanvas$4.contentW+' '+svgCanvas$4.contentH});assignAttributes(bg,{width:svgCanvas$4.getSvgContent().getAttribute('width'),height:svgCanvas$4.getSvgContent().getAttribute('height'),x,y});const bgImg=getElement('background_image');if(bgImg){assignAttributes(bgImg,{width:'100%',height:'100%'});}svgCanvas$4.selectorManager.selectorParentGroup.setAttribute('transform','translate('+x+','+y+')');/**
     * Invoked upon updates to the canvas.
     * @event module:svgcanvas.SvgCanvas#event:ext_canvasUpdated
     * @type {PlainObject}
     * @property {Integer} new_x
     * @property {Integer} new_y
     * @property {string} old_x (Of Integer)
     * @property {string} old_y (Of Integer)
     * @property {Integer} d_x
     * @property {Integer} d_y
     */svgCanvas$4.runExtensions('canvasUpdated',/**
     * @type {module:svgcanvas.SvgCanvas#event:ext_canvasUpdated}
     */{new_x:x,new_y:y,old_x:oldX,old_y:oldY,d_x:x-oldX,d_y:y-oldY});return {x,y,old_x:oldX,old_y:oldY,d_x:x-oldX,d_y:y-oldY};};/**
   * Select the next/previous element within the current layer.
   * @function module:svgcanvas.SvgCanvas#cycleElement
   * @param {boolean} next - true = next and false = previous element
   * @fires module:svgcanvas.SvgCanvas#event:selected
   * @returns {void}
   */const cycleElement=next=>{const selectedElements=svgCanvas$4.getSelectedElements();const currentGroup=svgCanvas$4.getCurrentGroup();let num;const curElem=selectedElements[0];let elem=false;const allElems=getVisibleElements(currentGroup||svgCanvas$4.getCurrentDrawing().getCurrentLayer());if(!allElems.length){return;}if(!curElem){num=next?allElems.length-1:0;elem=allElems[num];}else {let i=allElems.length;while(i--){if(allElems[i]===curElem){num=next?i-1:i+1;if(num>=allElems.length){num=0;}else if(num<0){num=allElems.length-1;}elem=allElems[num];break;}}}svgCanvas$4.selectOnly([elem],true);svgCanvas$4.call('selected',selectedElements);};/**
   * Tools for blur event.
   * @module blur
   * @license MIT
   * @copyright 2011 Jeff Schiller
   */let svgCanvas$3=null;/**
  * @function module:blur.init
  * @param {module:blur.blurContext} blurContext
  * @returns {void}
  */const init$3=canvas=>{svgCanvas$3=canvas;};/**
  * Sets the `stdDeviation` blur value on the selected element without being undoable.
  * @function module:svgcanvas.SvgCanvas#setBlurNoUndo
  * @param {Float} val - The new `stdDeviation` value
  * @returns {void}
  */const setBlurNoUndo=function(val){const selectedElements=svgCanvas$3.getSelectedElements();if(!svgCanvas$3.getFilter()){svgCanvas$3.setBlur(val);return;}if(val===0){// Don't change the StdDev, as that will hide the element.
  // Instead, just remove the value for "filter"
  svgCanvas$3.changeSelectedAttributeNoUndo('filter','');svgCanvas$3.setFilterHidden(true);}else {const elem=selectedElements[0];if(svgCanvas$3.getFilterHidden()){svgCanvas$3.changeSelectedAttributeNoUndo('filter','url(#'+elem.id+'_blur)');}const filter=svgCanvas$3.getFilter();svgCanvas$3.changeSelectedAttributeNoUndo('stdDeviation',val,[filter.firstChild]);svgCanvas$3.setBlurOffsets(filter,val);}};/**
  *
  * @returns {void}
  */function finishChange(){const bCmd=svgCanvas$3.undoMgr.finishUndoableChange();svgCanvas$3.getCurCommand().addSubCommand(bCmd);svgCanvas$3.addCommandToHistory(svgCanvas$3.getCurCommand());svgCanvas$3.setCurCommand(null);svgCanvas$3.setFilter(null);}/**
  * Sets the `x`, `y`, `width`, `height` values of the filter element in order to
  * make the blur not be clipped. Removes them if not neeeded.
  * @function module:svgcanvas.SvgCanvas#setBlurOffsets
  * @param {Element} filterElem - The filter DOM element to update
  * @param {Float} stdDev - The standard deviation value on which to base the offset size
  * @returns {void}
  */const setBlurOffsets=function(filterElem,stdDev){if(stdDev>3){// TODO: Create algorithm here where size is based on expected blur
  svgCanvas$3.assignAttributes(filterElem,{x:'-50%',y:'-50%',width:'200%',height:'200%'},100);}else {filterElem.removeAttribute('x');filterElem.removeAttribute('y');filterElem.removeAttribute('width');filterElem.removeAttribute('height');}};/**
  * Adds/updates the blur filter to the selected element.
  * @function module:svgcanvas.SvgCanvas#setBlur
  * @param {Float} val - Float with the new `stdDeviation` blur value
  * @param {boolean} complete - Whether or not the action should be completed (to add to the undo manager)
  * @returns {void}
  */const setBlur=function(val,complete){const{InsertElementCommand,ChangeElementCommand,BatchCommand}=svgCanvas$3.history;const selectedElements=svgCanvas$3.getSelectedElements();if(svgCanvas$3.getCurCommand()){finishChange();return;}// Looks for associated blur, creates one if not found
  const elem=selectedElements[0];const elemId=elem.id;svgCanvas$3.setFilter(svgCanvas$3.getElement(elemId+'_blur'));val-=0;const batchCmd=new BatchCommand();// Blur found!
  if(svgCanvas$3.getFilter()){if(val===0){svgCanvas$3.setFilter(null);}}else {// Not found, so create
  const newblur=svgCanvas$3.addSVGElementsFromJson({element:'feGaussianBlur',attr:{in:'SourceGraphic',stdDeviation:val}});svgCanvas$3.setFilter(svgCanvas$3.addSVGElementsFromJson({element:'filter',attr:{id:elemId+'_blur'}}));svgCanvas$3.getFilter().append(newblur);svgCanvas$3.findDefs().append(svgCanvas$3.getFilter());batchCmd.addSubCommand(new InsertElementCommand(svgCanvas$3.getFilter()));}const changes={filter:elem.getAttribute('filter')};if(val===0){elem.removeAttribute('filter');batchCmd.addSubCommand(new ChangeElementCommand(elem,changes));return;}svgCanvas$3.changeSelectedAttribute('filter','url(#'+elemId+'_blur)');batchCmd.addSubCommand(new ChangeElementCommand(elem,changes));svgCanvas$3.setBlurOffsets(svgCanvas$3.getFilter(),val);const filter=svgCanvas$3.getFilter();svgCanvas$3.setCurCommand(batchCmd);svgCanvas$3.undoMgr.beginUndoableChange('stdDeviation',[filter?filter.firstChild:null]);if(complete){svgCanvas$3.setBlurNoUndo(val);finishChange();}};/**
   * Tools for SVG sanitization.
   * @module sanitize
   * @license MIT
   *
   * @copyright 2010 Alexis Deveria, 2010 Jeff Schiller
   */const REVERSE_NS=getReverseNS();// Todo: Split out into core attributes, presentation attributes, etc. so consistent
  /**
   * This defines which elements and attributes that we support (or at least
   * don't remove).
   * @type {PlainObject}
   */ /* eslint-disable max-len */const svgGenericWhiteList=['class','id','display','transform','style'];const svgWhiteList_={// SVG Elements
  a:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','mask','opacity','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','xlink:href','xlink:title'],circle:['clip-path','clip-rule','cx','cy','enable-background','fill','fill-opacity','fill-rule','filter','mask','opacity','r','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage'],clipPath:['clipPathUnits'],defs:[],desc:[],ellipse:['clip-path','clip-rule','cx','cy','fill','fill-opacity','fill-rule','filter','mask','opacity','requiredFeatures','rx','ry','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage'],feBlend:['in','in2'],feColorMatrix:['in','type','value','result','values'],feComposite:['in','operator','result','in2'],feFlood:['flood-color','in','result','flood-opacity'],feGaussianBlur:['color-interpolation-filters','in','requiredFeatures','stdDeviation','result'],feMerge:[],feMergeNode:['in'],feMorphology:['in','operator','radius'],feOffset:['dx','in','dy','result'],filter:['color-interpolation-filters','filterRes','filterUnits','height','primitiveUnits','requiredFeatures','width','x','xlink:href','y'],foreignObject:['font-size','height','opacity','requiredFeatures','width','x','y'],g:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','mask','opacity','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','font-family','font-size','font-style','font-weight','text-anchor'],image:['clip-path','clip-rule','filter','height','mask','opacity','requiredFeatures','systemLanguage','width','x','xlink:href','xlink:title','y'],line:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','marker-end','marker-mid','marker-start','mask','opacity','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','x1','x2','y1','y2'],linearGradient:['gradientTransform','gradientUnits','requiredFeatures','spreadMethod','systemLanguage','x1','x2','xlink:href','y1','y2'],marker:['markerHeight','markerUnits','markerWidth','orient','preserveAspectRatio','refX','refY','se_type','systemLanguage','viewBox'],mask:['height','maskContentUnits','maskUnits','width','x','y'],metadata:[],path:['clip-path','clip-rule','d','enable-background','fill','fill-opacity','fill-rule','filter','marker-end','marker-mid','marker-start','mask','opacity','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage'],pattern:['height','patternContentUnits','patternTransform','patternUnits','requiredFeatures','systemLanguage','viewBox','width','x','xlink:href','y'],polygon:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','marker-end','marker-mid','marker-start','mask','opacity','points','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','sides','shape','edge','point','starRadiusMultiplier','r','radialshift','r2','orient','cx','cy'],polyline:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','marker-end','marker-mid','marker-start','mask','opacity','points','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','se:connector'],radialGradient:['cx','cy','fx','fy','gradientTransform','gradientUnits','r','requiredFeatures','spreadMethod','systemLanguage','xlink:href'],rect:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','height','mask','opacity','requiredFeatures','rx','ry','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','width','x','y'],stop:['offset','requiredFeatures','stop-opacity','systemLanguage','stop-color','gradientUnits','gradientTransform'],style:['type'],svg:['clip-path','clip-rule','enable-background','filter','height','mask','preserveAspectRatio','requiredFeatures','systemLanguage','version','viewBox','width','x','xmlns','xmlns:se','xmlns:xlink','xmlns:oi','oi:animations','y','stroke-linejoin','fill-rule','aria-label','stroke-width','fill-rule','xml:space'],switch:['requiredFeatures','systemLanguage'],symbol:['fill','fill-opacity','fill-rule','filter','font-family','font-size','font-style','font-weight','opacity','overflow','preserveAspectRatio','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','viewBox','width','height'],text:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','font-family','font-size','font-style','font-weight','mask','opacity','requiredFeatures','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','text-anchor','letter-spacing','word-spacing','text-decoration','textLength','lengthAdjust','x','xml:space','y'],textPath:['method','requiredFeatures','spacing','startOffset','systemLanguage','xlink:href'],title:[],tspan:['clip-path','clip-rule','dx','dy','fill','fill-opacity','fill-rule','filter','font-family','font-size','font-style','font-weight','mask','opacity','requiredFeatures','rotate','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','systemLanguage','text-anchor','textLength','x','xml:space','y'],use:['clip-path','clip-rule','fill','fill-opacity','fill-rule','filter','height','mask','stroke','stroke-dasharray','stroke-dashoffset','stroke-linecap','stroke-linejoin','stroke-miterlimit','stroke-opacity','stroke-width','width','x','xlink:href','y','overflow'],// MathML Elements
  annotation:['encoding'],'annotation-xml':['encoding'],maction:['actiontype','other','selection'],math:['xmlns'],menclose:['notation'],merror:[],mfrac:['linethickness'],mi:['mathvariant'],mmultiscripts:[],mn:[],mo:['fence','lspace','maxsize','minsize','rspace','stretchy'],mover:[],mpadded:['lspace','width','height','depth','voffset'],mphantom:[],mprescripts:[],mroot:[],mrow:['xlink:href','xlink:type','xmlns:xlink'],mspace:['depth','height','width'],msqrt:[],mstyle:['displaystyle','mathbackground','mathcolor','mathvariant','scriptlevel'],msub:[],msubsup:[],msup:[],mtable:['align','columnalign','columnlines','columnspacing','displaystyle','equalcolumns','equalrows','frame','rowalign','rowlines','rowspacing','width'],mtd:['columnalign','columnspan','rowalign','rowspan'],mtext:[],mtr:['columnalign','rowalign'],munder:[],munderover:[],none:[],semantics:[]};/* eslint-enable max-len */ // add generic attributes to all elements of the whitelist
  Object.keys(svgWhiteList_).forEach(element=>{svgWhiteList_[element]=[...svgWhiteList_[element],...svgGenericWhiteList];});// Produce a Namespace-aware version of svgWhitelist
  const svgWhiteListNS_={};Object.entries(svgWhiteList_).forEach(_ref11=>{let[elt,atts]=_ref11;const attNS={};Object.entries(atts).forEach(_ref12=>{let[_i,att]=_ref12;if(att.includes(':')){const v=att.split(':');attNS[v[1]]=NS[v[0].toUpperCase()];}else {attNS[att]=att==='xmlns'?NS.XMLNS:null;}});svgWhiteListNS_[elt]=attNS;});/**
  * Sanitizes the input node and its children.
  * It only keeps what is allowed from our whitelist defined above.
  * @function module:sanitize.sanitizeSvg
  * @param {Text|Element} node - The DOM element to be checked (we'll also check its children) or text node to be cleaned up
  * @returns {void}
  */const sanitizeSvg=node=>{// Cleanup text nodes
  if(node.nodeType===3){// 3 === TEXT_NODE
  // Trim whitespace
  node.nodeValue=node.nodeValue.trim();// Remove if empty
  if(!node.nodeValue.length){node.remove();}}// We only care about element nodes.
  // Automatically return for all non-element nodes, such as comments, etc.
  if(node.nodeType!==1){// 1 == ELEMENT_NODE
  return;}const doc=node.ownerDocument;const parent=node.parentNode;// can parent ever be null here?  I think the root node's parent is the document...
  if(!doc||!parent){return;}const allowedAttrs=svgWhiteList_[node.nodeName];const allowedAttrsNS=svgWhiteListNS_[node.nodeName];// if this element is supported, sanitize it
  if(typeof allowedAttrs!=='undefined'){const seAttrs=[];let i=node.attributes.length;while(i--){// if the attribute is not in our whitelist, then remove it
  const attr=node.attributes.item(i);const attrName=attr.nodeName;const attrLocalName=attr.localName;const attrNsURI=attr.namespaceURI;// Check that an attribute with the correct localName in the correct namespace is on
  // our whitelist or is a namespace declaration for one of our allowed namespaces
  if(attrNsURI!==allowedAttrsNS[attrLocalName]&&attrNsURI!==NS.XMLNS&&!(attrNsURI===NS.XMLNS&&REVERSE_NS[attr.value])){// Bypassing the whitelist to allow se: and oi: prefixes
  // We can add specific namepaces on demand for now.
  // Is there a more appropriate way to do this?
  if(attrName.startsWith('se:')||attrName.startsWith('oi:')||attrName.startsWith('data-')){// We should bypass the namespace aswell
  const seAttrNS=attrName.startsWith('se:')?NS.SE:attrName.startsWith('oi:')?NS.OI:null;seAttrs.push([attrName,attr.value,seAttrNS]);}else {console.warn(`sanitizeSvg: attribute ${attrName} in element ${node.nodeName} not in whitelist is removed`);node.removeAttributeNS(attrNsURI,attrLocalName);}}// For the style attribute, rewrite it in terms of XML presentational attributes
  if(attrName==='style'){const props=attr.value.split(';');let p=props.length;while(p--){const[name,val]=props[p].split(':');const styleAttrName=(name||'').trim();const styleAttrVal=(val||'').trim();// Now check that this attribute is supported
  if(allowedAttrs.includes(styleAttrName)){node.setAttribute(styleAttrName,styleAttrVal);}}node.removeAttribute('style');}}Object.values(seAttrs).forEach(_ref13=>{let[att,val,ns]=_ref13;node.setAttributeNS(ns,att,val);});// for some elements that have a xlink:href, ensure the URI refers to a local element
  // (but not for links)
  const href=getHref(node);if(href&&['filter','linearGradient','pattern','radialGradient','textPath','use'].includes(node.nodeName)&&href[0]!=='#'){// remove the attribute (but keep the element)
  setHref(node,'');console.warn(`sanitizeSvg: attribute href in element ${node.nodeName} pointing to a non-local reference (${href}) is removed`);node.removeAttributeNS(NS.XLINK,'href');}// Safari crashes on a <use> without a xlink:href, so we just remove the node here
  if(node.nodeName==='use'&&!getHref(node)){console.warn(`sanitizeSvg: element ${node.nodeName} without a xlink:href is removed`);node.remove();return;}// if the element has attributes pointing to a non-local reference,
  // need to remove the attribute
  Object.values(['clip-path','fill','filter','marker-end','marker-mid','marker-start','mask','stroke'],attr=>{let val=node.getAttribute(attr);if(val){val=getUrlFromAttr(val);// simply check for first character being a '#'
  if(val&&val[0]!=='#'){node.setAttribute(attr,'');console.warn(`sanitizeSvg: attribute ${attr} in element ${node.nodeName} pointing to a non-local reference (${val}) is removed`);node.removeAttribute(attr);}}});// recurse to children
  i=node.childNodes.length;while(i--){sanitizeSvg(node.childNodes.item(i));}// else (element not supported), remove it
  }else {// remove all children from this node and insert them before this node
  // TODO: in the case of animation elements this will hardly ever be correct
  console.warn(`sanitizeSvg: element ${node.nodeName} not supported is removed`);const children=[];while(node.hasChildNodes()){children.push(parent.insertBefore(node.firstChild,node));}// remove this node from the document altogether
  node.remove();// call sanitizeSvg on each of those children
  let i=children.length;while(i--){sanitizeSvg(children[i]);}}};function _typeof$1(obj){"@babel/helpers - typeof";return _typeof$1="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof$1(obj);}// DEFLATE is a complex format; to read this code, you should probably check the RFC first:
  // aliases for shorter compressed code (most minifers don't do this)
  var u8=Uint8Array,u16=Uint16Array,u32=Uint32Array;// fixed length extra bits
  var fleb=new u8([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,/* unused */0,0,/* impossible */0]);// fixed distance extra bits
  // see fleb note
  var fdeb=new u8([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,/* unused */0,0]);// code length index map
  var clim=new u8([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]);// get base, reverse index map from extra bits
  var freb=function(eb,start){var b=new u16(31);for(var i=0;i<31;++i){b[i]=start+=1<<eb[i-1];}// numbers here are at max 18 bits
  var r=new u32(b[30]);for(var i=1;i<30;++i){for(var j=b[i];j<b[i+1];++j){r[j]=j-b[i]<<5|i;}}return [b,r];};var _a=freb(fleb,2),fl=_a[0],revfl=_a[1];// we can ignore the fact that the other numbers are wrong; they never happen anyway
  fl[28]=258,revfl[258]=28;var _b=freb(fdeb,0),fd=_b[0],revfd=_b[1];// map of value to reverse (assuming 16 bits)
  var rev=new u16(32768);for(var i$3=0;i$3<32768;++i$3){// reverse table algorithm from SO
  var x$1=(i$3&0xAAAA)>>>1|(i$3&0x5555)<<1;x$1=(x$1&0xCCCC)>>>2|(x$1&0x3333)<<2;x$1=(x$1&0xF0F0)>>>4|(x$1&0x0F0F)<<4;rev[i$3]=((x$1&0xFF00)>>>8|(x$1&0x00FF)<<8)>>>1;}// create huffman tree from u8 "map": index -> code length for code index
  // mb (max bits) must be at most 15
  // TODO: optimize/split up?
  var hMap=function(cd,mb,r){var s=cd.length;// index
  var i=0;// u16 "map": index -> # of codes with bit length = index
  var l=new u16(mb);// length of cd must be 288 (total # of codes)
  for(;i<s;++i)++l[cd[i]-1];// u16 "map": index -> minimum code for bit length = index
  var le=new u16(mb);for(i=0;i<mb;++i){le[i]=le[i-1]+l[i-1]<<1;}var co;if(r){// u16 "map": index -> number of actual bits, symbol for code
  co=new u16(1<<mb);// bits to remove for reverser
  var rvb=15-mb;for(i=0;i<s;++i){// ignore 0 lengths
  if(cd[i]){// num encoding both symbol and bits read
  var sv=i<<4|cd[i];// free bits
  var r_1=mb-cd[i];// start value
  var v=le[cd[i]-1]++<<r_1;// m is end value
  for(var m=v|(1<<r_1)-1;v<=m;++v){// every 16 bit value starting with the code yields the same result
  co[rev[v]>>>rvb]=sv;}}}}else {co=new u16(s);for(i=0;i<s;++i)co[i]=rev[le[cd[i]-1]++]>>>15-cd[i];}return co;};// fixed length tree
  var flt=new u8(288);for(var i$3=0;i$3<144;++i$3)flt[i$3]=8;for(var i$3=144;i$3<256;++i$3)flt[i$3]=9;for(var i$3=256;i$3<280;++i$3)flt[i$3]=7;for(var i$3=280;i$3<288;++i$3)flt[i$3]=8;// fixed distance tree
  var fdt=new u8(32);for(var i$3=0;i$3<32;++i$3)fdt[i$3]=5;// fixed length map
  var flm=/*#__PURE__*/hMap(flt,9,0),flrm=/*#__PURE__*/hMap(flt,9,1);// fixed distance map
  var fdm=/*#__PURE__*/hMap(fdt,5,0),fdrm=/*#__PURE__*/hMap(fdt,5,1);// find max of array
  var max$3=function(a){var m=a[0];for(var i=1;i<a.length;++i){if(a[i]>m)m=a[i];}return m;};// read d, starting at bit p and mask with m
  var bits=function(d,p,m){var o=p/8>>0;return (d[o]|d[o+1]<<8)>>>(p&7)&m;};// read d, starting at bit p continuing for at least 16 bits
  var bits16=function(d,p){var o=p/8>>0;return (d[o]|d[o+1]<<8|d[o+2]<<16)>>>(p&7);};// get end of byte
  var shft=function(p){return (p/8>>0)+(p&7&&1);};// typed array slice - allows garbage collector to free original reference,
  // while being more compatible than .slice
  var slc=function(v,s,e){if(s==null||s<0)s=0;if(e==null||e>v.length)e=v.length;// can't use .constructor in case user-supplied
  var n=new(v instanceof u16?u16:v instanceof u32?u32:u8)(e-s);n.set(v.subarray(s,e));return n;};// expands raw DEFLATE data
  var inflt=function(dat,buf,st){// source length
  var sl=dat.length;// have to estimate size
  var noBuf=!buf||st;// no state
  var noSt=!st||st.i;if(!st)st={};// Assumes roughly 33% compression ratio average
  if(!buf)buf=new u8(sl*3);// ensure buffer can fit at least l elements
  var cbuf=function(l){var bl=buf.length;// need to increase size to fit
  if(l>bl){// Double or set to necessary, whichever is greater
  var nbuf=new u8(Math.max(bl*2,l));nbuf.set(buf);buf=nbuf;}};//  last chunk         bitpos           bytes
  var final=st.f||0,pos=st.p||0,bt=st.b||0,lm=st.l,dm=st.d,lbt=st.m,dbt=st.n;// total bits
  var tbts=sl*8;do{if(!lm){// BFINAL - this is only 1 when last chunk is next
  st.f=final=bits(dat,pos,1);// type: 0 = no compression, 1 = fixed huffman, 2 = dynamic huffman
  var type=bits(dat,pos+1,3);pos+=3;if(!type){// go to end of byte boundary
  var s=shft(pos)+4,l=dat[s-4]|dat[s-3]<<8,t=s+l;if(t>sl){if(noSt)throw 'unexpected EOF';break;}// ensure size
  if(noBuf)cbuf(bt+l);// Copy over uncompressed data
  buf.set(dat.subarray(s,t),bt);// Get new bitpos, update byte count
  st.b=bt+=l,st.p=pos=t*8;continue;}else if(type==1)lm=flrm,dm=fdrm,lbt=9,dbt=5;else if(type==2){//  literal                            lengths
  var hLit=bits(dat,pos,31)+257,hcLen=bits(dat,pos+10,15)+4;var tl=hLit+bits(dat,pos+5,31)+1;pos+=14;// length+distance tree
  var ldt=new u8(tl);// code length tree
  var clt=new u8(19);for(var i=0;i<hcLen;++i){// use index map to get real code
  clt[clim[i]]=bits(dat,pos+i*3,7);}pos+=hcLen*3;// code lengths bits
  var clb=max$3(clt),clbmsk=(1<<clb)-1;if(!noSt&&pos+tl*(clb+7)>tbts)break;// code lengths map
  var clm=hMap(clt,clb,1);for(var i=0;i<tl;){var r=clm[bits(dat,pos,clbmsk)];// bits read
  pos+=r&15;// symbol
  var s=r>>>4;// code length to copy
  if(s<16){ldt[i++]=s;}else {//  copy   count
  var c=0,n=0;if(s==16)n=3+bits(dat,pos,3),pos+=2,c=ldt[i-1];else if(s==17)n=3+bits(dat,pos,7),pos+=3;else if(s==18)n=11+bits(dat,pos,127),pos+=7;while(n--)ldt[i++]=c;}}//    length tree                 distance tree
  var lt=ldt.subarray(0,hLit),dt=ldt.subarray(hLit);// max length bits
  lbt=max$3(lt);// max dist bits
  dbt=max$3(dt);lm=hMap(lt,lbt,1);dm=hMap(dt,dbt,1);}else throw 'invalid block type';if(pos>tbts)throw 'unexpected EOF';}// Make sure the buffer can hold this + the largest possible addition
  // Maximum chunk size (practically, theoretically infinite) is 2^17;
  if(noBuf)cbuf(bt+131072);var lms=(1<<lbt)-1,dms=(1<<dbt)-1;var mxa=lbt+dbt+18;while(noSt||pos+mxa<tbts){// bits read, code
  var c=lm[bits16(dat,pos)&lms],sym=c>>>4;pos+=c&15;if(pos>tbts)throw 'unexpected EOF';if(!c)throw 'invalid length/literal';if(sym<256)buf[bt++]=sym;else if(sym==256){lm=null;break;}else {var add=sym-254;// no extra bits needed if less
  if(sym>264){// index
  var i=sym-257,b=fleb[i];add=bits(dat,pos,(1<<b)-1)+fl[i];pos+=b;}// dist
  var d=dm[bits16(dat,pos)&dms],dsym=d>>>4;if(!d)throw 'invalid distance';pos+=d&15;var dt=fd[dsym];if(dsym>3){var b=fdeb[dsym];dt+=bits16(dat,pos)&(1<<b)-1,pos+=b;}if(pos>tbts)throw 'unexpected EOF';if(noBuf)cbuf(bt+131072);var end=bt+add;for(;bt<end;bt+=4){buf[bt]=buf[bt-dt];buf[bt+1]=buf[bt+1-dt];buf[bt+2]=buf[bt+2-dt];buf[bt+3]=buf[bt+3-dt];}bt=end;}}st.l=lm,st.p=pos,st.b=bt;if(lm)final=1,st.m=lbt,st.d=dm,st.n=dbt;}while(!final);return bt==buf.length?buf:slc(buf,0,bt);};// starting at p, write the minimum number of bits that can hold v to d
  var wbits=function(d,p,v){v<<=p&7;var o=p/8>>0;d[o]|=v;d[o+1]|=v>>>8;};// starting at p, write the minimum number of bits (>8) that can hold v to d
  var wbits16=function(d,p,v){v<<=p&7;var o=p/8>>0;d[o]|=v;d[o+1]|=v>>>8;d[o+2]|=v>>>16;};// creates code lengths from a frequency table
  var hTree=function(d,mb){// Need extra info to make a tree
  var t=[];for(var i=0;i<d.length;++i){if(d[i])t.push({s:i,f:d[i]});}var s=t.length;var t2=t.slice();if(!s)return [new u8(0),0];if(s==1){var v=new u8(t[0].s+1);v[t[0].s]=1;return [v,1];}t.sort(function(a,b){return a.f-b.f;});// after i2 reaches last ind, will be stopped
  // freq must be greater than largest possible number of symbols
  t.push({s:-1,f:25001});var l=t[0],r=t[1],i0=0,i1=1,i2=2;t[0]={s:-1,f:l.f+r.f,l:l,r:r};// efficient algorithm from UZIP.js
  // i0 is lookbehind, i2 is lookahead - after processing two low-freq
  // symbols that combined have high freq, will start processing i2 (high-freq,
  // non-composite) symbols instead
  // see https://reddit.com/r/photopea/comments/ikekht/uzipjs_questions/
  while(i1!=s-1){l=t[t[i0].f<t[i2].f?i0++:i2++];r=t[i0!=i1&&t[i0].f<t[i2].f?i0++:i2++];t[i1++]={s:-1,f:l.f+r.f,l:l,r:r};}var maxSym=t2[0].s;for(var i=1;i<s;++i){if(t2[i].s>maxSym)maxSym=t2[i].s;}// code lengths
  var tr=new u16(maxSym+1);// max bits in tree
  var mbt=ln(t[i1-1],tr,0);if(mbt>mb){// more algorithms from UZIP.js
  // TODO: find out how this code works (debt)
  //  ind    debt
  var i=0,dt=0;//    left            cost
  var lft=mbt-mb,cst=1<<lft;t2.sort(function(a,b){return tr[b.s]-tr[a.s]||a.f-b.f;});for(;i<s;++i){var i2_1=t2[i].s;if(tr[i2_1]>mb){dt+=cst-(1<<mbt-tr[i2_1]);tr[i2_1]=mb;}else break;}dt>>>=lft;while(dt>0){var i2_2=t2[i].s;if(tr[i2_2]<mb)dt-=1<<mb-tr[i2_2]++-1;else ++i;}for(;i>=0&&dt;--i){var i2_3=t2[i].s;if(tr[i2_3]==mb){--tr[i2_3];++dt;}}mbt=mb;}return [new u8(tr),mbt];};// get the max length and assign length codes
  var ln=function(n,l,d){return n.s==-1?Math.max(ln(n.l,l,d+1),ln(n.r,l,d+1)):l[n.s]=d;};// length codes generation
  var lc=function(c){var s=c.length;// Note that the semicolon was intentional
  while(s&&!c[--s]);var cl=new u16(++s);//  ind      num         streak
  var cli=0,cln=c[0],cls=1;var w=function(v){cl[cli++]=v;};for(var i=1;i<=s;++i){if(c[i]==cln&&i!=s)++cls;else {if(!cln&&cls>2){for(;cls>138;cls-=138)w(32754);if(cls>2){w(cls>10?cls-11<<5|28690:cls-3<<5|12305);cls=0;}}else if(cls>3){w(cln),--cls;for(;cls>6;cls-=6)w(8304);if(cls>2)w(cls-3<<5|8208),cls=0;}while(cls--)w(cln);cls=1;cln=c[i];}}return [cl.subarray(0,cli),s];};// calculate the length of output from tree, code lengths
  var clen=function(cf,cl){var l=0;for(var i=0;i<cl.length;++i)l+=cf[i]*cl[i];return l;};// writes a fixed block
  // returns the new bit pos
  var wfblk=function(out,pos,dat){// no need to write 00 as type: TypedArray defaults to 0
  var s=dat.length;var o=shft(pos+2);out[o]=s&255;out[o+1]=s>>>8;out[o+2]=out[o]^255;out[o+3]=out[o+1]^255;for(var i=0;i<s;++i)out[o+i+4]=dat[i];return (o+4+s)*8;};// writes a block
  var wblk=function(dat,out,final,syms,lf,df,eb,li,bs,bl,p){wbits(out,p++,final);++lf[256];var _a=hTree(lf,15),dlt=_a[0],mlb=_a[1];var _b=hTree(df,15),ddt=_b[0],mdb=_b[1];var _c=lc(dlt),lclt=_c[0],nlc=_c[1];var _d=lc(ddt),lcdt=_d[0],ndc=_d[1];var lcfreq=new u16(19);for(var i=0;i<lclt.length;++i)lcfreq[lclt[i]&31]++;for(var i=0;i<lcdt.length;++i)lcfreq[lcdt[i]&31]++;var _e=hTree(lcfreq,7),lct=_e[0],mlcb=_e[1];var nlcc=19;for(;nlcc>4&&!lct[clim[nlcc-1]];--nlcc);var flen=bl+5<<3;var ftlen=clen(lf,flt)+clen(df,fdt)+eb;var dtlen=clen(lf,dlt)+clen(df,ddt)+eb+14+3*nlcc+clen(lcfreq,lct)+(2*lcfreq[16]+3*lcfreq[17]+7*lcfreq[18]);if(flen<=ftlen&&flen<=dtlen)return wfblk(out,p,dat.subarray(bs,bs+bl));var lm,ll,dm,dl;wbits(out,p,1+(dtlen<ftlen)),p+=2;if(dtlen<ftlen){lm=hMap(dlt,mlb,0),ll=dlt,dm=hMap(ddt,mdb,0),dl=ddt;var llm=hMap(lct,mlcb,0);wbits(out,p,nlc-257);wbits(out,p+5,ndc-1);wbits(out,p+10,nlcc-4);p+=14;for(var i=0;i<nlcc;++i)wbits(out,p+3*i,lct[clim[i]]);p+=3*nlcc;var lcts=[lclt,lcdt];for(var it=0;it<2;++it){var clct=lcts[it];for(var i=0;i<clct.length;++i){var len=clct[i]&31;wbits(out,p,llm[len]),p+=lct[len];if(len>15)wbits(out,p,clct[i]>>>5&127),p+=clct[i]>>>12;}}}else {lm=flm,ll=flt,dm=fdm,dl=fdt;}for(var i=0;i<li;++i){if(syms[i]>255){var len=syms[i]>>>18&31;wbits16(out,p,lm[len+257]),p+=ll[len+257];if(len>7)wbits(out,p,syms[i]>>>23&31),p+=fleb[len];var dst=syms[i]&31;wbits16(out,p,dm[dst]),p+=dl[dst];if(dst>3)wbits16(out,p,syms[i]>>>5&8191),p+=fdeb[dst];}else {wbits16(out,p,lm[syms[i]]),p+=ll[syms[i]];}}wbits16(out,p,lm[256]);return p+ll[256];};// deflate options (nice << 13) | chain
  var deo=/*#__PURE__*/new u32([65540,131080,131088,131104,262176,1048704,1048832,2114560,2117632]);// empty
  var et$1=/*#__PURE__*/new u8(0);// compresses data into a raw DEFLATE buffer
  var dflt=function(dat,lvl,plvl,pre,post,lst){var s=dat.length;var o=new u8(pre+s+5*(1+Math.floor(s/7000))+post);// writing to this writes to the output buffer
  var w=o.subarray(pre,o.length-post);var pos=0;if(!lvl||s<8){for(var i=0;i<=s;i+=65535){// end
  var e=i+65535;if(e<s){// write full block
  pos=wfblk(w,pos,dat.subarray(i,e));}else {// write final block
  w[i]=lst;pos=wfblk(w,pos,dat.subarray(i,s));}}}else {var opt=deo[lvl-1];var n=opt>>>13,c=opt&8191;var msk_1=(1<<plvl)-1;//    prev 2-byte val map    curr 2-byte val map
  var prev=new u16(32768),head=new u16(msk_1+1);var bs1_1=Math.ceil(plvl/3),bs2_1=2*bs1_1;var hsh=function(i){return (dat[i]^dat[i+1]<<bs1_1^dat[i+2]<<bs2_1)&msk_1;};// 24576 is an arbitrary number of maximum symbols per block
  // 424 buffer for last block
  var syms=new u32(25000);// length/literal freq   distance freq
  var lf=new u16(288),df=new u16(32);//  l/lcnt  exbits  index  l/lind  waitdx  bitpos
  var lc_1=0,eb=0,i=0,li=0,wi=0,bs=0;for(;i<s;++i){// hash value
  var hv=hsh(i);// index mod 32768
  var imod=i&32767;// previous index with this value
  var pimod=head[hv];prev[imod]=pimod;head[hv]=imod;// We always should modify head and prev, but only add symbols if
  // this data is not yet processed ("wait" for wait index)
  if(wi<=i){// bytes remaining
  var rem=s-i;if((lc_1>7000||li>24576)&&rem>423){pos=wblk(dat,w,0,syms,lf,df,eb,li,bs,i-bs,pos);li=lc_1=eb=0,bs=i;for(var j=0;j<286;++j)lf[j]=0;for(var j=0;j<30;++j)df[j]=0;}//  len    dist   chain
  var l=2,d=0,ch_1=c,dif=imod-pimod&32767;if(rem>2&&hv==hsh(i-dif)){var maxn=Math.min(n,rem)-1;var maxd=Math.min(32767,i);// max possible length
  // not capped at dif because decompressors implement "rolling" index population
  var ml=Math.min(258,rem);while(dif<=maxd&&--ch_1&&imod!=pimod){if(dat[i+l]==dat[i+l-dif]){var nl=0;for(;nl<ml&&dat[i+nl]==dat[i+nl-dif];++nl);if(nl>l){l=nl,d=dif;// break out early when we reach "nice" (we are satisfied enough)
  if(nl>maxn)break;// now, find the rarest 2-byte sequence within this
  // length of literals and search for that instead.
  // Much faster than just using the start
  var mmd=Math.min(dif,nl-2);var md=0;for(var j=0;j<mmd;++j){var ti=i-dif+j+32768&32767;var pti=prev[ti];var cd=ti-pti+32768&32767;if(cd>md)md=cd,pimod=ti;}}}// check the previous match
  imod=pimod,pimod=prev[imod];dif+=imod-pimod+32768&32767;}}// d will be nonzero only when a match was found
  if(d){// store both dist and len data in one Uint32
  // Make sure this is recognized as a len/dist with 28th bit (2^28)
  syms[li++]=268435456|revfl[l]<<18|revfd[d];var lin=revfl[l]&31,din=revfd[d]&31;eb+=fleb[lin]+fdeb[din];++lf[257+lin];++df[din];wi=i+l;++lc_1;}else {syms[li++]=dat[i];++lf[dat[i]];}}}pos=wblk(dat,w,lst,syms,lf,df,eb,li,bs,i-bs,pos);// this is the easiest way to avoid needing to maintain state
  if(!lst)pos=wfblk(w,pos,et$1);}return slc(o,0,pre+shft(pos)+post);};// Alder32
  var adler=function(){var a=1,b=0;return {p:function(d){// closures have awful performance
  var n=a,m=b;var l=d.length;for(var i=0;i!=l;){var e=Math.min(i+5552,l);for(;i<e;++i)n+=d[i],m+=n;n%=65521,m%=65521;}a=n,b=m;},d:function(){return (a>>>8<<16|(b&255)<<8|b>>>8)+((a&255)<<23)*2;}};};// deflate with opts
  var dopt=function(dat,opt,pre,post,st){return dflt(dat,opt.level==null?6:opt.level,opt.mem==null?Math.ceil(Math.max(8,Math.min(13,Math.log(dat.length)))*1.5):12+opt.mem,pre,post,!st);};// write bytes
  var wbytes=function(d,b,v){for(;v;++b)d[b]=v,v>>>=8;};// zlib header
  var zlh=function(c,o){var lv=o.level,fl=lv==0?0:lv<6?1:lv==9?3:2;c[0]=120,c[1]=fl<<6|(fl?32-2*fl:1);};// zlib valid
  var zlv=function(d){if((d[0]&15)!=8||d[0]>>>4>7||(d[0]<<8|d[1])%31)throw 'invalid zlib data';if(d[1]&32)throw 'invalid zlib data: preset dictionaries not supported';};/**
   * Compress data with Zlib
   * @param data The data to compress
   * @param opts The compression options
   * @returns The zlib-compressed version of the data
   */function zlibSync(data,opts){if(opts===void 0){opts={};}var a=adler();a.p(data);var d=dopt(data,opts,2,4);return zlh(d,opts),wbytes(d,d.length-4,a.d()),d;}/**
   * Expands Zlib data
   * @param data The data to decompress
   * @param out Where to write the data. Saves memory if you know the decompressed size and provide an output buffer of that length.
   * @returns The decompressed version of the data
   */function unzlibSync(data,out){return inflt((zlv(data),data.subarray(2,-4)),out);}/** @license
   *
   * jsPDF - PDF Document creation from JavaScript
   * Version 2.5.1 Built on 2022-01-28T15:37:57.791Z
   *                      CommitID 00000000
   *
   * Copyright (c) 2010-2021 James Hall <james@parall.ax>, https://github.com/MrRio/jsPDF
   *               2015-2021 yWorks GmbH, http://www.yworks.com
   *               2015-2021 Lukas Holländer <lukas.hollaender@yworks.com>, https://github.com/HackbrettXXX
   *               2016-2018 Aras Abbasi <aras.abbasi@gmail.com>
   *               2010 Aaron Spike, https://github.com/acspike
   *               2012 Willow Systems Corporation, https://github.com/willowsystems
   *               2012 Pablo Hess, https://github.com/pablohess
   *               2012 Florian Jenett, https://github.com/fjenett
   *               2013 Warren Weckesser, https://github.com/warrenweckesser
   *               2013 Youssef Beddad, https://github.com/lifof
   *               2013 Lee Driscoll, https://github.com/lsdriscoll
   *               2013 Stefan Slonevskiy, https://github.com/stefslon
   *               2013 Jeremy Morel, https://github.com/jmorel
   *               2013 Christoph Hartmann, https://github.com/chris-rock
   *               2014 Juan Pablo Gaviria, https://github.com/juanpgaviria
   *               2014 James Makes, https://github.com/dollaruw
   *               2014 Diego Casorran, https://github.com/diegocr
   *               2014 Steven Spungin, https://github.com/Flamenco
   *               2014 Kenneth Glassey, https://github.com/Gavvers
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   *
   * Contributor(s):
   *    siefkenj, ahwolf, rickygu, Midnith, saintclair, eaparango,
   *    kim3er, mfo, alnorth, Flamenco
   */var n$1=function(){return "undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this;}();function i$2(){n$1.console&&"function"==typeof n$1.console.log&&n$1.console.log.apply(n$1.console,arguments);}var a$1={log:i$2,warn:function(t){n$1.console&&("function"==typeof n$1.console.warn?n$1.console.warn.apply(n$1.console,arguments):i$2.call(null,arguments));},error:function(t){n$1.console&&("function"==typeof n$1.console.error?n$1.console.error.apply(n$1.console,arguments):i$2(t));}};function o$1(t,e,r){var n=new XMLHttpRequest();n.open("GET",t),n.responseType="blob",n.onload=function(){l$1(n.response,e,r);},n.onerror=function(){a$1.error("could not download file");},n.send();}function s$1(t){var e=new XMLHttpRequest();e.open("HEAD",t,!1);try{e.send();}catch(t){}return e.status>=200&&e.status<=299;}function c$2(t){try{t.dispatchEvent(new MouseEvent("click"));}catch(r){var e=document.createEvent("MouseEvents");e.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),t.dispatchEvent(e);}}var u$1,h$1,l$1=n$1.saveAs||("object"!==("undefined"==typeof window?"undefined":_typeof$1(window))||window!==n$1?function(){}:"undefined"!=typeof HTMLAnchorElement&&"download"in HTMLAnchorElement.prototype?function(t,e,r){var i=n$1.URL||n$1.webkitURL,a=document.createElement("a");e=e||t.name||"download",a.download=e,a.rel="noopener","string"==typeof t?(a.href=t,a.origin!==location.origin?s$1(a.href)?o$1(t,e,r):c$2(a,a.target="_blank"):c$2(a)):(a.href=i.createObjectURL(t),setTimeout(function(){i.revokeObjectURL(a.href);},4e4),setTimeout(function(){c$2(a);},0));}:"msSaveOrOpenBlob"in navigator?function(e,r,n){if(r=r||e.name||"download","string"==typeof e){if(s$1(e))o$1(e,r,n);else {var i=document.createElement("a");i.href=e,i.target="_blank",setTimeout(function(){c$2(i);});}}else navigator.msSaveOrOpenBlob(function(e,r){return void 0===r?r={autoBom:!1}:"object"!==_typeof$1(r)&&(a$1.warn("Deprecated: Expected third argument to be a object"),r={autoBom:!r}),r.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e.type)?new Blob([String.fromCharCode(65279),e],{type:e.type}):e;}(e,n),r);}:function(e,r,i,a){if((a=a||open("","_blank"))&&(a.document.title=a.document.body.innerText="downloading..."),"string"==typeof e)return o$1(e,r,i);var s="application/octet-stream"===e.type,c=/constructor/i.test(n$1.HTMLElement)||n$1.safari,u=/CriOS\/[\d]+/.test(navigator.userAgent);if((u||s&&c)&&"object"===("undefined"==typeof FileReader?"undefined":_typeof$1(FileReader))){var h=new FileReader();h.onloadend=function(){var t=h.result;t=u?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"),a?a.location.href=t:location=t,a=null;},h.readAsDataURL(e);}else {var l=n$1.URL||n$1.webkitURL,f=l.createObjectURL(e);a?a.location=f:location.href=f,a=null,setTimeout(function(){l.revokeObjectURL(f);},4e4);}});/**
   * A class to parse color values
   * @author Stoyan Stefanov <sstoo@gmail.com>
   * {@link   http://www.phpied.com/rgb-color-parser-in-javascript/}
   * @license Use it if you like it
   */function f$1(t){var e;t=t||"",this.ok=!1,"#"==t.charAt(0)&&(t=t.substr(1,6));t={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"}[t=(t=t.replace(/ /g,"")).toLowerCase()]||t;for(var r=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(t){return [parseInt(t[1]),parseInt(t[2]),parseInt(t[3])];}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(t){return [parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)];}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(t){return [parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)];}}],n=0;n<r.length;n++){var i=r[n].re,a=r[n].process,o=i.exec(t);o&&(e=a(o),this.r=e[0],this.g=e[1],this.b=e[2],this.ok=!0);}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.toRGB=function(){return "rgb("+this.r+", "+this.g+", "+this.b+")";},this.toHex=function(){var t=this.r.toString(16),e=this.g.toString(16),r=this.b.toString(16);return 1==t.length&&(t="0"+t),1==e.length&&(e="0"+e),1==r.length&&(r="0"+r),"#"+t+e+r;};}/**
   * @license
   * Joseph Myers does not specify a particular license for his work.
   *
   * Author: Joseph Myers
   * Accessed from: http://www.myersdaily.org/joseph/javascript/md5.js
   *
   * Modified by: Owen Leong
   */function d(t,e){var r=t[0],n=t[1],i=t[2],a=t[3];r=g(r,n,i,a,e[0],7,-680876936),a=g(a,r,n,i,e[1],12,-389564586),i=g(i,a,r,n,e[2],17,606105819),n=g(n,i,a,r,e[3],22,-1044525330),r=g(r,n,i,a,e[4],7,-176418897),a=g(a,r,n,i,e[5],12,1200080426),i=g(i,a,r,n,e[6],17,-1473231341),n=g(n,i,a,r,e[7],22,-45705983),r=g(r,n,i,a,e[8],7,1770035416),a=g(a,r,n,i,e[9],12,-1958414417),i=g(i,a,r,n,e[10],17,-42063),n=g(n,i,a,r,e[11],22,-1990404162),r=g(r,n,i,a,e[12],7,1804603682),a=g(a,r,n,i,e[13],12,-40341101),i=g(i,a,r,n,e[14],17,-1502002290),r=m$2(r,n=g(n,i,a,r,e[15],22,1236535329),i,a,e[1],5,-165796510),a=m$2(a,r,n,i,e[6],9,-1069501632),i=m$2(i,a,r,n,e[11],14,643717713),n=m$2(n,i,a,r,e[0],20,-373897302),r=m$2(r,n,i,a,e[5],5,-701558691),a=m$2(a,r,n,i,e[10],9,38016083),i=m$2(i,a,r,n,e[15],14,-660478335),n=m$2(n,i,a,r,e[4],20,-405537848),r=m$2(r,n,i,a,e[9],5,568446438),a=m$2(a,r,n,i,e[14],9,-1019803690),i=m$2(i,a,r,n,e[3],14,-187363961),n=m$2(n,i,a,r,e[8],20,1163531501),r=m$2(r,n,i,a,e[13],5,-1444681467),a=m$2(a,r,n,i,e[2],9,-51403784),i=m$2(i,a,r,n,e[7],14,1735328473),r=v$1(r,n=m$2(n,i,a,r,e[12],20,-1926607734),i,a,e[5],4,-378558),a=v$1(a,r,n,i,e[8],11,-2022574463),i=v$1(i,a,r,n,e[11],16,1839030562),n=v$1(n,i,a,r,e[14],23,-35309556),r=v$1(r,n,i,a,e[1],4,-1530992060),a=v$1(a,r,n,i,e[4],11,1272893353),i=v$1(i,a,r,n,e[7],16,-155497632),n=v$1(n,i,a,r,e[10],23,-1094730640),r=v$1(r,n,i,a,e[13],4,681279174),a=v$1(a,r,n,i,e[0],11,-358537222),i=v$1(i,a,r,n,e[3],16,-722521979),n=v$1(n,i,a,r,e[6],23,76029189),r=v$1(r,n,i,a,e[9],4,-640364487),a=v$1(a,r,n,i,e[12],11,-421815835),i=v$1(i,a,r,n,e[15],16,530742520),r=b(r,n=v$1(n,i,a,r,e[2],23,-995338651),i,a,e[0],6,-198630844),a=b(a,r,n,i,e[7],10,1126891415),i=b(i,a,r,n,e[14],15,-1416354905),n=b(n,i,a,r,e[5],21,-57434055),r=b(r,n,i,a,e[12],6,1700485571),a=b(a,r,n,i,e[3],10,-1894986606),i=b(i,a,r,n,e[10],15,-1051523),n=b(n,i,a,r,e[1],21,-2054922799),r=b(r,n,i,a,e[8],6,1873313359),a=b(a,r,n,i,e[15],10,-30611744),i=b(i,a,r,n,e[6],15,-1560198380),n=b(n,i,a,r,e[13],21,1309151649),r=b(r,n,i,a,e[4],6,-145523070),a=b(a,r,n,i,e[11],10,-1120210379),i=b(i,a,r,n,e[2],15,718787259),n=b(n,i,a,r,e[9],21,-343485551),t[0]=_$1(r,t[0]),t[1]=_$1(n,t[1]),t[2]=_$1(i,t[2]),t[3]=_$1(a,t[3]);}function p$1(t,e,r,n,i,a){return e=_$1(_$1(e,t),_$1(n,a)),_$1(e<<i|e>>>32-i,r);}function g(t,e,r,n,i,a,o){return p$1(e&r|~e&n,t,e,i,a,o);}function m$2(t,e,r,n,i,a,o){return p$1(e&n|r&~n,t,e,i,a,o);}function v$1(t,e,r,n,i,a,o){return p$1(e^r^n,t,e,i,a,o);}function b(t,e,r,n,i,a,o){return p$1(r^(e|~n),t,e,i,a,o);}function y$1(t){var e,r=t.length,n=[1732584193,-271733879,-1732584194,271733878];for(e=64;e<=t.length;e+=64)d(n,w(t.substring(e-64,e)));t=t.substring(e-64);var i=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(e=0;e<t.length;e++)i[e>>2]|=t.charCodeAt(e)<<(e%4<<3);if(i[e>>2]|=128<<(e%4<<3),e>55)for(d(n,i),e=0;e<16;e++)i[e]=0;return i[14]=8*r,d(n,i),n;}function w(t){var e,r=[];for(e=0;e<64;e+=4)r[e>>2]=t.charCodeAt(e)+(t.charCodeAt(e+1)<<8)+(t.charCodeAt(e+2)<<16)+(t.charCodeAt(e+3)<<24);return r;}u$1=n$1.atob.bind(n$1),h$1=n$1.btoa.bind(n$1);var N$1="0123456789abcdef".split("");function L(t){for(var e="",r=0;r<4;r++)e+=N$1[t>>8*r+4&15]+N$1[t>>8*r&15];return e;}function A(t){return String.fromCharCode((255&t)>>0,(65280&t)>>8,(16711680&t)>>16,(4278190080&t)>>24);}function x(t){return y$1(t).map(A).join("");}var S="5d41402abc4b2a76b9719d911017c592"!=function(t){for(var e=0;e<t.length;e++)t[e]=L(t[e]);return t.join("");}(y$1("hello"));function _$1(t,e){if(S){var r=(65535&t)+(65535&e);return (t>>16)+(e>>16)+(r>>16)<<16|65535&r;}return t+e&4294967295;}/**
   * @license
   * FPDF is released under a permissive license: there is no usage restriction.
   * You may embed it freely in your application (commercial or not), with or
   * without modifications.
   *
   * Reference: http://www.fpdf.org/en/script/script37.php
   */function P(t,e){var r,n,i,a;if(t!==r){for(var o=(i=t,a=1+(256/t.length>>0),new Array(a+1).join(i)),s=[],c=0;c<256;c++)s[c]=c;var u=0;for(c=0;c<256;c++){var h=s[c];u=(u+h+o.charCodeAt(c))%256,s[c]=s[u],s[u]=h;}r=t,n=s;}else s=n;var l=e.length,f=0,d=0,p="";for(c=0;c<l;c++)d=(d+(h=s[f=(f+1)%256]))%256,s[f]=s[d],s[d]=h,o=s[(s[f]+s[d])%256],p+=String.fromCharCode(e.charCodeAt(c)^o);return p;}/**
   * @license
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   * Author: Owen Leong (@owenl131)
   * Date: 15 Oct 2020
   * References:
   * https://www.cs.cmu.edu/~dst/Adobe/Gallery/anon21jul01-pdf-encryption.txt
   * https://github.com/foliojs/pdfkit/blob/master/lib/security.js
   * http://www.fpdf.org/en/script/script37.php
   */var k={print:4,modify:8,copy:16,"annot-forms":32};function I(t,e,r,n){this.v=1,this.r=2;var i=192;t.forEach(function(t){if(void 0!==k.perm)throw new Error("Invalid permission: "+t);i+=k[t];}),this.padding="(¿N^NuAd\0NVÿú\b..\0¶Ðh>/\f©þdSiz";var a=(e+this.padding).substr(0,32),o=(r+this.padding).substr(0,32);this.O=this.processOwnerPassword(a,o),this.P=-(1+(255^i)),this.encryptionKey=x(a+this.O+this.lsbFirstWord(this.P)+this.hexToBytes(n)).substr(0,5),this.U=P(this.encryptionKey,this.padding);}function F(t){if(/[^\u0000-\u00ff]/.test(t))throw new Error("Invalid PDF Name Object: "+t+", Only accept ASCII characters.");for(var e="",r=t.length,n=0;n<r;n++){var i=t.charCodeAt(n);if(i<33||35===i||37===i||40===i||41===i||47===i||60===i||62===i||91===i||93===i||123===i||125===i||i>126)e+="#"+("0"+i.toString(16)).slice(-2);else e+=t[n];}return e;}function C(e){if("object"!==_typeof$1(e))throw new Error("Invalid Context passed to initialize PubSub (jsPDF-module)");var r={};this.subscribe=function(t,e,n){if(n=n||!1,"string"!=typeof t||"function"!=typeof e||"boolean"!=typeof n)throw new Error("Invalid arguments passed to PubSub.subscribe (jsPDF-module)");r.hasOwnProperty(t)||(r[t]={});var i=Math.random().toString(35);return r[t][i]=[e,!!n],i;},this.unsubscribe=function(t){for(var e in r)if(r[e][t])return delete r[e][t],0===Object.keys(r[e]).length&&delete r[e],!0;return !1;},this.publish=function(t){if(r.hasOwnProperty(t)){var i=Array.prototype.slice.call(arguments,1),o=[];for(var s in r[t]){var c=r[t][s];try{c[0].apply(e,i);}catch(t){n$1.console&&a$1.error("jsPDF PubSub Error",t.message,t);}c[1]&&o.push(s);}o.length&&o.forEach(this.unsubscribe);}},this.getTopics=function(){return r;};}function j(t){if(!(this instanceof j))return new j(t);var e="opacity,stroke-opacity".split(",");for(var r in t)t.hasOwnProperty(r)&&e.indexOf(r)>=0&&(this[r]=t[r]);this.id="",this.objectNumber=-1;}function O$1(t,e){this.gState=t,this.matrix=e,this.id="",this.objectNumber=-1;}function B(t,e,r,n,i){if(!(this instanceof B))return new B(t,e,r,n,i);this.type="axial"===t?2:3,this.coords=e,this.colors=r,O$1.call(this,n,i);}function M(t,e,r,n,i){if(!(this instanceof M))return new M(t,e,r,n,i);this.boundingBox=t,this.xStep=e,this.yStep=r,this.stream="",this.cloneIndex=0,O$1.call(this,n,i);}function E(e){var r,i="string"==typeof arguments[0]?arguments[0]:"p",o=arguments[1],s=arguments[2],c=arguments[3],u=[],d=1,p=16,g="S",m=null;"object"===_typeof$1(e=e||{})&&(i=e.orientation,o=e.unit||o,s=e.format||s,c=e.compress||e.compressPdf||c,null!==(m=e.encryption||null)&&(m.userPassword=m.userPassword||"",m.ownerPassword=m.ownerPassword||"",m.userPermissions=m.userPermissions||[]),d="number"==typeof e.userUnit?Math.abs(e.userUnit):1,void 0!==e.precision&&(r=e.precision),void 0!==e.floatPrecision&&(p=e.floatPrecision),g=e.defaultPathOperation||"S"),u=e.filters||(!0===c?["FlateEncode"]:u),o=o||"mm",i=(""+(i||"P")).toLowerCase();var v=e.putOnlyUsedFonts||!1,b={},y={internal:{},__private__:{}};y.__private__.PubSub=C;var w="1.3",N=y.__private__.getPdfVersion=function(){return w;};y.__private__.setPdfVersion=function(t){w=t;};var L={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],"government-letter":[576,756],legal:[612,1008],"junior-legal":[576,360],ledger:[1224,792],tabloid:[792,1224],"credit-card":[153,243]};y.__private__.getPageFormats=function(){return L;};var A=y.__private__.getPageFormat=function(t){return L[t];};s=s||"a4";var x={COMPAT:"compat",ADVANCED:"advanced"},S=x.COMPAT;function _(){this.saveGraphicsState(),lt(new Vt(_t,0,0,-_t,0,Rr()*_t).toString()+" cm"),this.setFontSize(this.getFontSize()/_t),g="n",S=x.ADVANCED;}function P(){this.restoreGraphicsState(),g="S",S=x.COMPAT;}var k=y.__private__.combineFontStyleAndFontWeight=function(t,e){if("bold"==t&&"normal"==e||"bold"==t&&400==e||"normal"==t&&"italic"==e||"bold"==t&&"italic"==e)throw new Error("Invalid Combination of fontweight and fontstyle");return e&&(t=400==e||"normal"===e?"italic"===t?"italic":"normal":700!=e&&"bold"!==e||"normal"!==t?(700==e?"bold":e)+""+t:"bold"),t;};y.advancedAPI=function(t){var e=S===x.COMPAT;return e&&_.call(this),"function"!=typeof t||(t(this),e&&P.call(this)),this;},y.compatAPI=function(t){var e=S===x.ADVANCED;return e&&P.call(this),"function"!=typeof t||(t(this),e&&_.call(this)),this;},y.isAdvancedAPI=function(){return S===x.ADVANCED;};var O,q=function(t){if(S!==x.ADVANCED)throw new Error(t+" is only available in 'advanced' API mode. You need to call advancedAPI() first.");},D=y.roundToPrecision=y.__private__.roundToPrecision=function(t,e){var n=r||e;if(isNaN(t)||isNaN(n))throw new Error("Invalid argument passed to jsPDF.roundToPrecision");return t.toFixed(n).replace(/0+$/,"");};O=y.hpf=y.__private__.hpf="number"==typeof p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,p);}:"smart"===p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,t>-1&&t<1?16:5);}:function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,16);};var R=y.f2=y.__private__.f2=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f2");return D(t,2);},T=y.__private__.f3=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f3");return D(t,3);},U=y.scale=y.__private__.scale=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.scale");return S===x.COMPAT?t*_t:S===x.ADVANCED?t:void 0;},z=function(t){return S===x.COMPAT?Rr()-t:S===x.ADVANCED?t:void 0;},H=function(t){return U(z(t));};y.__private__.setPrecision=y.setPrecision=function(t){"number"==typeof parseInt(t,10)&&(r=parseInt(t,10));};var W,V="00000000000000000000000000000000",G=y.__private__.getFileId=function(){return V;},Y=y.__private__.setFileId=function(t){return V=void 0!==t&&/^[a-fA-F0-9]{32}$/.test(t)?t.toUpperCase():V.split("").map(function(){return "ABCDEF0123456789".charAt(Math.floor(16*Math.random()));}).join(""),null!==m&&(Ye=new I(m.userPermissions,m.userPassword,m.ownerPassword,V)),V;};y.setFileId=function(t){return Y(t),this;},y.getFileId=function(){return G();};var J=y.__private__.convertDateToPDFDate=function(t){var e=t.getTimezoneOffset(),r=e<0?"+":"-",n=Math.floor(Math.abs(e/60)),i=Math.abs(e%60),a=[r,Q(n),"'",Q(i),"'"].join("");return ["D:",t.getFullYear(),Q(t.getMonth()+1),Q(t.getDate()),Q(t.getHours()),Q(t.getMinutes()),Q(t.getSeconds()),a].join("");},X=y.__private__.convertPDFDateToDate=function(t){var e=parseInt(t.substr(2,4),10),r=parseInt(t.substr(6,2),10)-1,n=parseInt(t.substr(8,2),10),i=parseInt(t.substr(10,2),10),a=parseInt(t.substr(12,2),10),o=parseInt(t.substr(14,2),10);return new Date(e,r,n,i,a,o,0);},K=y.__private__.setCreationDate=function(t){var e;if(void 0===t&&(t=new Date()),t instanceof Date)e=J(t);else {if(!/^D:(20[0-2][0-9]|203[0-7]|19[7-9][0-9])(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])(0[0-9]|1[0-9]|2[0-3])(0[0-9]|[1-5][0-9])(0[0-9]|[1-5][0-9])(\+0[0-9]|\+1[0-4]|-0[0-9]|-1[0-1])'(0[0-9]|[1-5][0-9])'?$/.test(t))throw new Error("Invalid argument passed to jsPDF.setCreationDate");e=t;}return W=e;},Z=y.__private__.getCreationDate=function(t){var e=W;return "jsDate"===t&&(e=X(W)),e;};y.setCreationDate=function(t){return K(t),this;},y.getCreationDate=function(t){return Z(t);};var $,Q=y.__private__.padd2=function(t){return ("0"+parseInt(t)).slice(-2);},tt=y.__private__.padd2Hex=function(t){return ("00"+(t=t.toString())).substr(t.length);},et=0,rt=[],nt=[],it=0,at=[],ot=[],st=!1,ct=nt,ut=function(){et=0,it=0,nt=[],rt=[],at=[],Qt=Kt(),te=Kt();};y.__private__.setCustomOutputDestination=function(t){st=!0,ct=t;};var ht=function(t){st||(ct=t);};y.__private__.resetCustomOutputDestination=function(){st=!1,ct=nt;};var lt=y.__private__.out=function(t){return t=t.toString(),it+=t.length+1,ct.push(t),ct;},ft=y.__private__.write=function(t){return lt(1===arguments.length?t.toString():Array.prototype.join.call(arguments," "));},dt=y.__private__.getArrayBuffer=function(t){for(var e=t.length,r=new ArrayBuffer(e),n=new Uint8Array(r);e--;)n[e]=t.charCodeAt(e);return r;},pt=[["Helvetica","helvetica","normal","WinAnsiEncoding"],["Helvetica-Bold","helvetica","bold","WinAnsiEncoding"],["Helvetica-Oblique","helvetica","italic","WinAnsiEncoding"],["Helvetica-BoldOblique","helvetica","bolditalic","WinAnsiEncoding"],["Courier","courier","normal","WinAnsiEncoding"],["Courier-Bold","courier","bold","WinAnsiEncoding"],["Courier-Oblique","courier","italic","WinAnsiEncoding"],["Courier-BoldOblique","courier","bolditalic","WinAnsiEncoding"],["Times-Roman","times","normal","WinAnsiEncoding"],["Times-Bold","times","bold","WinAnsiEncoding"],["Times-Italic","times","italic","WinAnsiEncoding"],["Times-BoldItalic","times","bolditalic","WinAnsiEncoding"],["ZapfDingbats","zapfdingbats","normal",null],["Symbol","symbol","normal",null]];y.__private__.getStandardFonts=function(){return pt;};var gt=e.fontSize||16;y.__private__.setFontSize=y.setFontSize=function(t){return gt=S===x.ADVANCED?t/_t:t,this;};var mt,vt=y.__private__.getFontSize=y.getFontSize=function(){return S===x.COMPAT?gt:gt*_t;},bt=e.R2L||!1;y.__private__.setR2L=y.setR2L=function(t){return bt=t,this;},y.__private__.getR2L=y.getR2L=function(){return bt;};var yt,wt=y.__private__.setZoomMode=function(t){var e=[void 0,null,"fullwidth","fullheight","fullpage","original"];if(/^(?:\d+\.\d*|\d*\.\d+|\d+)%$/.test(t))mt=t;else if(isNaN(t)){if(-1===e.indexOf(t))throw new Error('zoom must be Integer (e.g. 2), a percentage Value (e.g. 300%) or fullwidth, fullheight, fullpage, original. "'+t+'" is not recognized.');mt=t;}else mt=parseInt(t,10);};y.__private__.getZoomMode=function(){return mt;};var Nt,Lt=y.__private__.setPageMode=function(t){if(-1==[void 0,null,"UseNone","UseOutlines","UseThumbs","FullScreen"].indexOf(t))throw new Error('Page mode must be one of UseNone, UseOutlines, UseThumbs, or FullScreen. "'+t+'" is not recognized.');yt=t;};y.__private__.getPageMode=function(){return yt;};var At=y.__private__.setLayoutMode=function(t){if(-1==[void 0,null,"continuous","single","twoleft","tworight","two"].indexOf(t))throw new Error('Layout mode must be one of continuous, single, twoleft, tworight. "'+t+'" is not recognized.');Nt=t;};y.__private__.getLayoutMode=function(){return Nt;},y.__private__.setDisplayMode=y.setDisplayMode=function(t,e,r){return wt(t),At(e),Lt(r),this;};var xt={title:"",subject:"",author:"",keywords:"",creator:""};y.__private__.getDocumentProperty=function(t){if(-1===Object.keys(xt).indexOf(t))throw new Error("Invalid argument passed to jsPDF.getDocumentProperty");return xt[t];},y.__private__.getDocumentProperties=function(){return xt;},y.__private__.setDocumentProperties=y.setProperties=y.setDocumentProperties=function(t){for(var e in xt)xt.hasOwnProperty(e)&&t[e]&&(xt[e]=t[e]);return this;},y.__private__.setDocumentProperty=function(t,e){if(-1===Object.keys(xt).indexOf(t))throw new Error("Invalid arguments passed to jsPDF.setDocumentProperty");return xt[t]=e;};var St,_t,Pt,kt,It,Ft={},Ct={},jt=[],Ot={},Bt={},Mt={},Et={},qt=null,Dt=0,Rt=[],Tt=new C(y),Ut=e.hotfixes||[],zt={},Ht={},Wt=[],Vt=function t(e,r,n,i,a,o){if(!(this instanceof t))return new t(e,r,n,i,a,o);isNaN(e)&&(e=1),isNaN(r)&&(r=0),isNaN(n)&&(n=0),isNaN(i)&&(i=1),isNaN(a)&&(a=0),isNaN(o)&&(o=0),this._matrix=[e,r,n,i,a,o];};Object.defineProperty(Vt.prototype,"sx",{get:function(){return this._matrix[0];},set:function(t){this._matrix[0]=t;}}),Object.defineProperty(Vt.prototype,"shy",{get:function(){return this._matrix[1];},set:function(t){this._matrix[1]=t;}}),Object.defineProperty(Vt.prototype,"shx",{get:function(){return this._matrix[2];},set:function(t){this._matrix[2]=t;}}),Object.defineProperty(Vt.prototype,"sy",{get:function(){return this._matrix[3];},set:function(t){this._matrix[3]=t;}}),Object.defineProperty(Vt.prototype,"tx",{get:function(){return this._matrix[4];},set:function(t){this._matrix[4]=t;}}),Object.defineProperty(Vt.prototype,"ty",{get:function(){return this._matrix[5];},set:function(t){this._matrix[5]=t;}}),Object.defineProperty(Vt.prototype,"a",{get:function(){return this._matrix[0];},set:function(t){this._matrix[0]=t;}}),Object.defineProperty(Vt.prototype,"b",{get:function(){return this._matrix[1];},set:function(t){this._matrix[1]=t;}}),Object.defineProperty(Vt.prototype,"c",{get:function(){return this._matrix[2];},set:function(t){this._matrix[2]=t;}}),Object.defineProperty(Vt.prototype,"d",{get:function(){return this._matrix[3];},set:function(t){this._matrix[3]=t;}}),Object.defineProperty(Vt.prototype,"e",{get:function(){return this._matrix[4];},set:function(t){this._matrix[4]=t;}}),Object.defineProperty(Vt.prototype,"f",{get:function(){return this._matrix[5];},set:function(t){this._matrix[5]=t;}}),Object.defineProperty(Vt.prototype,"rotation",{get:function(){return Math.atan2(this.shx,this.sx);}}),Object.defineProperty(Vt.prototype,"scaleX",{get:function(){return this.decompose().scale.sx;}}),Object.defineProperty(Vt.prototype,"scaleY",{get:function(){return this.decompose().scale.sy;}}),Object.defineProperty(Vt.prototype,"isIdentity",{get:function(){return 1===this.sx&&0===this.shy&&0===this.shx&&1===this.sy&&0===this.tx&&0===this.ty;}}),Vt.prototype.join=function(t){return [this.sx,this.shy,this.shx,this.sy,this.tx,this.ty].map(O).join(t);},Vt.prototype.multiply=function(t){var e=t.sx*this.sx+t.shy*this.shx,r=t.sx*this.shy+t.shy*this.sy,n=t.shx*this.sx+t.sy*this.shx,i=t.shx*this.shy+t.sy*this.sy,a=t.tx*this.sx+t.ty*this.shx+this.tx,o=t.tx*this.shy+t.ty*this.sy+this.ty;return new Vt(e,r,n,i,a,o);},Vt.prototype.decompose=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,o=Math.sqrt(t*t+e*e),s=(t/=o)*r+(e/=o)*n;r-=t*s,n-=e*s;var c=Math.sqrt(r*r+n*n);return s/=c,t*(n/=c)<e*(r/=c)&&(t=-t,e=-e,s=-s,o=-o),{scale:new Vt(o,0,0,c,0,0),translate:new Vt(1,0,0,1,i,a),rotate:new Vt(t,e,-e,t,0,0),skew:new Vt(1,0,s,1,0,0)};},Vt.prototype.toString=function(t){return this.join(" ");},Vt.prototype.inversed=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,o=1/(t*n-e*r),s=n*o,c=-e*o,u=-r*o,h=t*o;return new Vt(s,c,u,h,-s*i-u*a,-c*i-h*a);},Vt.prototype.applyToPoint=function(t){var e=t.x*this.sx+t.y*this.shx+this.tx,r=t.x*this.shy+t.y*this.sy+this.ty;return new Cr(e,r);},Vt.prototype.applyToRectangle=function(t){var e=this.applyToPoint(t),r=this.applyToPoint(new Cr(t.x+t.w,t.y+t.h));return new jr(e.x,e.y,r.x-e.x,r.y-e.y);},Vt.prototype.clone=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty;return new Vt(t,e,r,n,i,a);},y.Matrix=Vt;var Gt=y.matrixMult=function(t,e){return e.multiply(t);},Yt=new Vt(1,0,0,1,0,0);y.unitMatrix=y.identityMatrix=Yt;var Jt=function(t,e){if(!Bt[t]){var r=(e instanceof B?"Sh":"P")+(Object.keys(Ot).length+1).toString(10);e.id=r,Bt[t]=r,Ot[r]=e,Tt.publish("addPattern",e);}};y.ShadingPattern=B,y.TilingPattern=M,y.addShadingPattern=function(t,e){return q("addShadingPattern()"),Jt(t,e),this;},y.beginTilingPattern=function(t){q("beginTilingPattern()"),Br(t.boundingBox[0],t.boundingBox[1],t.boundingBox[2]-t.boundingBox[0],t.boundingBox[3]-t.boundingBox[1],t.matrix);},y.endTilingPattern=function(t,e){q("endTilingPattern()"),e.stream=ot[$].join("\n"),Jt(t,e),Tt.publish("endTilingPattern",e),Wt.pop().restore();};var Xt=y.__private__.newObject=function(){var t=Kt();return Zt(t,!0),t;},Kt=y.__private__.newObjectDeferred=function(){return et++,rt[et]=function(){return it;},et;},Zt=function(t,e){return e="boolean"==typeof e&&e,rt[t]=it,e&&lt(t+" 0 obj"),t;},$t=y.__private__.newAdditionalObject=function(){var t={objId:Kt(),content:""};return at.push(t),t;},Qt=Kt(),te=Kt(),ee=y.__private__.decodeColorString=function(t){var e=t.split(" ");if(2!==e.length||"g"!==e[1]&&"G"!==e[1]){if(5===e.length&&("k"===e[4]||"K"===e[4])){e=[(1-e[0])*(1-e[3]),(1-e[1])*(1-e[3]),(1-e[2])*(1-e[3]),"r"];}}else {var r=parseFloat(e[0]);e=[r,r,r,"r"];}for(var n="#",i=0;i<3;i++)n+=("0"+Math.floor(255*parseFloat(e[i])).toString(16)).slice(-2);return n;},re=y.__private__.encodeColorString=function(e){var r;"string"==typeof e&&(e={ch1:e});var n=e.ch1,i=e.ch2,a=e.ch3,o=e.ch4,s="draw"===e.pdfColorType?["G","RG","K"]:["g","rg","k"];if("string"==typeof n&&"#"!==n.charAt(0)){var c=new f$1(n);if(c.ok)n=c.toHex();else if(!/^\d*\.?\d*$/.test(n))throw new Error('Invalid color "'+n+'" passed to jsPDF.encodeColorString.');}if("string"==typeof n&&/^#[0-9A-Fa-f]{3}$/.test(n)&&(n="#"+n[1]+n[1]+n[2]+n[2]+n[3]+n[3]),"string"==typeof n&&/^#[0-9A-Fa-f]{6}$/.test(n)){var u=parseInt(n.substr(1),16);n=u>>16&255,i=u>>8&255,a=255&u;}if(void 0===i||void 0===o&&n===i&&i===a){if("string"==typeof n)r=n+" "+s[0];else switch(e.precision){case 2:r=R(n/255)+" "+s[0];break;case 3:default:r=T(n/255)+" "+s[0];}}else if(void 0===o||"object"===_typeof$1(o)){if(o&&!isNaN(o.a)&&0===o.a)return r=["1.","1.","1.",s[1]].join(" ");if("string"==typeof n)r=[n,i,a,s[1]].join(" ");else switch(e.precision){case 2:r=[R(n/255),R(i/255),R(a/255),s[1]].join(" ");break;default:case 3:r=[T(n/255),T(i/255),T(a/255),s[1]].join(" ");}}else if("string"==typeof n)r=[n,i,a,o,s[2]].join(" ");else switch(e.precision){case 2:r=[R(n),R(i),R(a),R(o),s[2]].join(" ");break;case 3:default:r=[T(n),T(i),T(a),T(o),s[2]].join(" ");}return r;},ne=y.__private__.getFilters=function(){return u;},ie=y.__private__.putStream=function(t){var e=(t=t||{}).data||"",r=t.filters||ne(),n=t.alreadyAppliedFilters||[],i=t.addLength1||!1,a=e.length,o=t.objectId,s=function(t){return t;};if(null!==m&&void 0===o)throw new Error("ObjectId must be passed to putStream for file encryption");null!==m&&(s=Ye.encryptor(o,0));var c={};!0===r&&(r=["FlateEncode"]);var u=t.additionalKeyValues||[],h=(c=void 0!==E.API.processDataByFilters?E.API.processDataByFilters(e,r):{data:e,reverseChain:[]}).reverseChain+(Array.isArray(n)?n.join(" "):n.toString());if(0!==c.data.length&&(u.push({key:"Length",value:c.data.length}),!0===i&&u.push({key:"Length1",value:a})),0!=h.length)if(h.split("/").length-1==1)u.push({key:"Filter",value:h});else {u.push({key:"Filter",value:"["+h+"]"});for(var l=0;l<u.length;l+=1)if("DecodeParms"===u[l].key){for(var f=[],d=0;d<c.reverseChain.split("/").length-1;d+=1)f.push("null");f.push(u[l].value),u[l].value="["+f.join(" ")+"]";}}lt("<<");for(var p=0;p<u.length;p++)lt("/"+u[p].key+" "+u[p].value);lt(">>"),0!==c.data.length&&(lt("stream"),lt(s(c.data)),lt("endstream"));},ae=y.__private__.putPage=function(t){var e=t.number,r=t.data,n=t.objId,i=t.contentsObjId;Zt(n,!0),lt("<</Type /Page"),lt("/Parent "+t.rootDictionaryObjId+" 0 R"),lt("/Resources "+t.resourceDictionaryObjId+" 0 R"),lt("/MediaBox ["+parseFloat(O(t.mediaBox.bottomLeftX))+" "+parseFloat(O(t.mediaBox.bottomLeftY))+" "+O(t.mediaBox.topRightX)+" "+O(t.mediaBox.topRightY)+"]"),null!==t.cropBox&&lt("/CropBox ["+O(t.cropBox.bottomLeftX)+" "+O(t.cropBox.bottomLeftY)+" "+O(t.cropBox.topRightX)+" "+O(t.cropBox.topRightY)+"]"),null!==t.bleedBox&&lt("/BleedBox ["+O(t.bleedBox.bottomLeftX)+" "+O(t.bleedBox.bottomLeftY)+" "+O(t.bleedBox.topRightX)+" "+O(t.bleedBox.topRightY)+"]"),null!==t.trimBox&&lt("/TrimBox ["+O(t.trimBox.bottomLeftX)+" "+O(t.trimBox.bottomLeftY)+" "+O(t.trimBox.topRightX)+" "+O(t.trimBox.topRightY)+"]"),null!==t.artBox&&lt("/ArtBox ["+O(t.artBox.bottomLeftX)+" "+O(t.artBox.bottomLeftY)+" "+O(t.artBox.topRightX)+" "+O(t.artBox.topRightY)+"]"),"number"==typeof t.userUnit&&1!==t.userUnit&&lt("/UserUnit "+t.userUnit),Tt.publish("putPage",{objId:n,pageContext:Rt[e],pageNumber:e,page:r}),lt("/Contents "+i+" 0 R"),lt(">>"),lt("endobj");var a=r.join("\n");return S===x.ADVANCED&&(a+="\nQ"),Zt(i,!0),ie({data:a,filters:ne(),objectId:i}),lt("endobj"),n;},oe=y.__private__.putPages=function(){var t,e,r=[];for(t=1;t<=Dt;t++)Rt[t].objId=Kt(),Rt[t].contentsObjId=Kt();for(t=1;t<=Dt;t++)r.push(ae({number:t,data:ot[t],objId:Rt[t].objId,contentsObjId:Rt[t].contentsObjId,mediaBox:Rt[t].mediaBox,cropBox:Rt[t].cropBox,bleedBox:Rt[t].bleedBox,trimBox:Rt[t].trimBox,artBox:Rt[t].artBox,userUnit:Rt[t].userUnit,rootDictionaryObjId:Qt,resourceDictionaryObjId:te}));Zt(Qt,!0),lt("<</Type /Pages");var n="/Kids [";for(e=0;e<Dt;e++)n+=r[e]+" 0 R ";lt(n+"]"),lt("/Count "+Dt),lt(">>"),lt("endobj"),Tt.publish("postPutPages");},se=function(t){Tt.publish("putFont",{font:t,out:lt,newObject:Xt,putStream:ie}),!0!==t.isAlreadyPutted&&(t.objectNumber=Xt(),lt("<<"),lt("/Type /Font"),lt("/BaseFont /"+F(t.postScriptName)),lt("/Subtype /Type1"),"string"==typeof t.encoding&&lt("/Encoding /"+t.encoding),lt("/FirstChar 32"),lt("/LastChar 255"),lt(">>"),lt("endobj"));},ce=f