/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.Spdy3;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameValueBlockReader
implements Closeable {
    private final DataInputStream nameValueBlockIn;
    private final FillableInflaterInputStream fillableInflaterInputStream;
    private int compressedLimit;

    NameValueBlockReader(final InputStream in) {
        InputStream throttleStream = new InputStream(){

            public int read() throws IOException {
                return Util.readSingleByte(this);
            }

            public int read(byte[] buffer, int offset, int byteCount) throws IOException {
                byteCount = Math.min(byteCount, NameValueBlockReader.this.compressedLimit);
                int consumed = in.read(buffer, offset, byteCount);
                NameValueBlockReader.this.compressedLimit -= consumed;
                return consumed;
            }

            public void close() throws IOException {
                in.close();
            }
        };
        Inflater inflater = new Inflater(){

            public int inflate(byte[] buffer, int offset, int count) throws DataFormatException {
                int result = super.inflate(buffer, offset, count);
                if (result == 0 && this.needsDictionary()) {
                    this.setDictionary(Spdy3.DICTIONARY);
                    result = super.inflate(buffer, offset, count);
                }
                return result;
            }
        };
        this.fillableInflaterInputStream = new FillableInflaterInputStream(throttleStream, inflater);
        this.nameValueBlockIn = new DataInputStream(this.fillableInflaterInputStream);
    }

    public List<String> readNameValueBlock(int length) throws IOException {
        this.compressedLimit += length;
        try {
            int numberOfPairs = this.nameValueBlockIn.readInt();
            if (numberOfPairs < 0) {
                throw new IOException("numberOfPairs < 0: " + numberOfPairs);
            }
            if (numberOfPairs > 1024) {
                throw new IOException("numberOfPairs > 1024: " + numberOfPairs);
            }
            ArrayList<String> entries = new ArrayList<String>(numberOfPairs * 2);
            for (int i = 0; i < numberOfPairs; ++i) {
                String name = this.readString();
                String values = this.readString();
                if (name.length() == 0) {
                    throw new IOException("name.length == 0");
                }
                entries.add(name);
                entries.add(values);
            }
            this.doneReading();
            return entries;
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void doneReading() throws IOException {
        if (this.compressedLimit == 0) {
            return;
        }
        this.fillableInflaterInputStream.fill();
        if (this.compressedLimit != 0) {
            throw new IOException("compressedLimit > 0: " + this.compressedLimit);
        }
    }

    private String readString() throws DataFormatException, IOException {
        int length = this.nameValueBlockIn.readInt();
        byte[] bytes = new byte[length];
        Util.readFully(this.nameValueBlockIn, bytes);
        return new String(bytes, 0, length, "UTF-8");
    }

    @Override
    public void close() throws IOException {
        this.nameValueBlockIn.close();
    }

    static class FillableInflaterInputStream
    extends InflaterInputStream {
        public FillableInflaterInputStream(InputStream in, Inflater inf) {
            super(in, inf);
        }

        public void fill() throws IOException {
            super.fill();
        }
    }
}

