/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.NameValueBlockReader;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.Variant;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.List;
import java.util.zip.Deflater;

final class Spdy3
implements Variant {
    static final int TYPE_DATA = 0;
    static final int TYPE_SYN_STREAM = 1;
    static final int TYPE_SYN_REPLY = 2;
    static final int TYPE_RST_STREAM = 3;
    static final int TYPE_SETTINGS = 4;
    static final int TYPE_NOOP = 5;
    static final int TYPE_PING = 6;
    static final int TYPE_GOAWAY = 7;
    static final int TYPE_HEADERS = 8;
    static final int TYPE_WINDOW_UPDATE = 9;
    static final int TYPE_CREDENTIAL = 16;
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int VERSION = 3;
    static final byte[] DICTIONARY;

    Spdy3() {
    }

    public FrameReader newReader(InputStream in, boolean client) {
        return new Reader(in, client);
    }

    public FrameWriter newWriter(OutputStream out, boolean client) {
        return new Writer(out, client);
    }

    static {
        try {
            DICTIONARY = "\u0000\u0000\u0000\u0007options\u0000\u0000\u0000\u0004head\u0000\u0000\u0000\u0004post\u0000\u0000\u0000\u0003put\u0000\u0000\u0000\u0006delete\u0000\u0000\u0000\u0005trace\u0000\u0000\u0000\u0006accept\u0000\u0000\u0000\u000eaccept-charset\u0000\u0000\u0000\u000faccept-encoding\u0000\u0000\u0000\u000faccept-language\u0000\u0000\u0000\raccept-ranges\u0000\u0000\u0000\u0003age\u0000\u0000\u0000\u0005allow\u0000\u0000\u0000\rauthorization\u0000\u0000\u0000\rcache-control\u0000\u0000\u0000\nconnection\u0000\u0000\u0000\fcontent-base\u0000\u0000\u0000\u0010content-encoding\u0000\u0000\u0000\u0010content-language\u0000\u0000\u0000\u000econtent-length\u0000\u0000\u0000\u0010content-location\u0000\u0000\u0000\u000bcontent-md5\u0000\u0000\u0000\rcontent-range\u0000\u0000\u0000\fcontent-type\u0000\u0000\u0000\u0004date\u0000\u0000\u0000\u0004etag\u0000\u0000\u0000\u0006expect\u0000\u0000\u0000\u0007expires\u0000\u0000\u0000\u0004from\u0000\u0000\u0000\u0004host\u0000\u0000\u0000\bif-match\u0000\u0000\u0000\u0011if-modified-since\u0000\u0000\u0000\rif-none-match\u0000\u0000\u0000\bif-range\u0000\u0000\u0000\u0013if-unmodified-since\u0000\u0000\u0000\rlast-modified\u0000\u0000\u0000\blocation\u0000\u0000\u0000\fmax-forwards\u0000\u0000\u0000\u0006pragma\u0000\u0000\u0000\u0012proxy-authenticate\u0000\u0000\u0000\u0013proxy-authorization\u0000\u0000\u0000\u0005range\u0000\u0000\u0000\u0007referer\u0000\u0000\u0000\u000bretry-after\u0000\u0000\u0000\u0006server\u0000\u0000\u0000\u0002te\u0000\u0000\u0000\u0007trailer\u0000\u0000\u0000\u0011transfer-encoding\u0000\u0000\u0000\u0007upgrade\u0000\u0000\u0000\nuser-agent\u0000\u0000\u0000\u0004vary\u0000\u0000\u0000\u0003via\u0000\u0000\u0000\u0007warning\u0000\u0000\u0000\u0010www-authenticate\u0000\u0000\u0000\u0006method\u0000\u0000\u0000\u0003get\u0000\u0000\u0000\u0006status\u0000\u0000\u0000\u0006200 OK\u0000\u0000\u0000\u0007version\u0000\u0000\u0000\bHTTP/1.1\u0000\u0000\u0000\u0003url\u0000\u0000\u0000\u0006public\u0000\u0000\u0000\nset-cookie\u0000\u0000\u0000\nkeep-alive\u0000\u0000\u0000\u0006origin100101201202205206300302303304305306307402405406407408409410411412413414415416417502504505203 Non-Authoritative Information204 No Content301 Moved Permanently400 Bad Request401 Unauthorized403 Forbidden404 Not Found500 Internal Server Error501 Not Implemented503 Service UnavailableJan Feb Mar Apr May Jun Jul Aug Sept Oct Nov Dec 00:00:00 Mon, Tue, Wed, Thu, Fri, Sat, Sun, GMTchunked,text/html,image/png,image/jpg,image/gif,application/xml,application/xhtml+xml,text/plain,text/javascript,publicprivatemax-age=gzip,deflate,sdchcharset=utf-8charset=iso-8859-1,utf-,*,enq=0.".getBytes(Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Writer
    implements FrameWriter {
        private final DataOutputStream out;
        private final ByteArrayOutputStream nameValueBlockBuffer;
        private final DataOutputStream nameValueBlockOut;
        private final boolean client;

        Writer(OutputStream out, boolean client) {
            this.out = new DataOutputStream(out);
            this.client = client;
            Deflater deflater = new Deflater();
            deflater.setDictionary(DICTIONARY);
            this.nameValueBlockBuffer = new ByteArrayOutputStream();
            this.nameValueBlockOut = new DataOutputStream(Platform.get().newDeflaterOutputStream(this.nameValueBlockBuffer, deflater, true));
        }

        @Override
        public synchronized void connectionHeader() {
        }

        @Override
        public synchronized void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public synchronized void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, int priority, int slot, List<String> nameValueBlock) throws IOException {
            this.writeNameValueBlockToBuffer(nameValueBlock);
            int length = 10 + this.nameValueBlockBuffer.size();
            int type = 1;
            int flags = (outFinished ? 1 : 0) | (inFinished ? 2 : 0);
            int unused = 0;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.out.writeInt(associatedStreamId & Integer.MAX_VALUE);
            this.out.writeShort((priority & 7) << 13 | (unused & 0x1F) << 8 | slot & 0xFF);
            this.nameValueBlockBuffer.writeTo(this.out);
            this.out.flush();
        }

        @Override
        public synchronized void synReply(boolean outFinished, int streamId, List<String> nameValueBlock) throws IOException {
            this.writeNameValueBlockToBuffer(nameValueBlock);
            int type = 2;
            int flags = outFinished ? 1 : 0;
            int length = this.nameValueBlockBuffer.size() + 4;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.nameValueBlockBuffer.writeTo(this.out);
            this.out.flush();
        }

        @Override
        public synchronized void headers(int streamId, List<String> nameValueBlock) throws IOException {
            this.writeNameValueBlockToBuffer(nameValueBlock);
            int flags = 0;
            int type = 8;
            int length = this.nameValueBlockBuffer.size() + 4;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.nameValueBlockBuffer.writeTo(this.out);
            this.out.flush();
        }

        @Override
        public synchronized void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            if (errorCode.spdyRstCode == -1) {
                throw new IllegalArgumentException();
            }
            int flags = 0;
            int type = 3;
            int length = 8;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.out.writeInt(errorCode.spdyRstCode);
            this.out.flush();
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, byte[] data) throws IOException {
            this.data(outFinished, streamId, data, 0, data.length);
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, byte[] data, int offset, int byteCount) throws IOException {
            int flags = outFinished ? 1 : 0;
            this.out.writeInt(streamId & Integer.MAX_VALUE);
            this.out.writeInt((flags & 0xFF) << 24 | byteCount & 0xFFFFFF);
            this.out.write(data, offset, byteCount);
        }

        private void writeNameValueBlockToBuffer(List<String> nameValueBlock) throws IOException {
            this.nameValueBlockBuffer.reset();
            int numberOfPairs = nameValueBlock.size() / 2;
            this.nameValueBlockOut.writeInt(numberOfPairs);
            for (String s : nameValueBlock) {
                this.nameValueBlockOut.writeInt(s.length());
                this.nameValueBlockOut.write(s.getBytes("UTF-8"));
            }
            this.nameValueBlockOut.flush();
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            int type = 4;
            int flags = 0;
            int size = settings.size();
            int length = 4 + size * 8;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(size);
            for (int i = 0; i <= 10; ++i) {
                if (!settings.isSet(i)) continue;
                int settingsFlags = settings.flags(i);
                this.out.writeInt((settingsFlags & 0xFF) << 24 | i & 0xFFFFFF);
                this.out.writeInt(settings.get(i));
            }
            this.out.flush();
        }

        @Override
        public synchronized void noop() throws IOException {
            int type = 5;
            int length = 0;
            int flags = 0;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.flush();
        }

        @Override
        public synchronized void ping(boolean reply, int payload1, int payload2) throws IOException {
            boolean payloadIsReply;
            boolean bl = payloadIsReply = this.client != (payload1 % 2 == 1);
            if (reply != payloadIsReply) {
                throw new IllegalArgumentException("payload != reply");
            }
            int type = 6;
            int flags = 0;
            int length = 4;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(payload1);
            this.out.flush();
        }

        @Override
        public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode) throws IOException {
            if (errorCode.spdyGoAwayCode == -1) {
                throw new IllegalArgumentException();
            }
            int type = 7;
            int flags = 0;
            int length = 8;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(lastGoodStreamId);
            this.out.writeInt(errorCode.spdyGoAwayCode);
            this.out.flush();
        }

        @Override
        public synchronized void windowUpdate(int streamId, int deltaWindowSize) throws IOException {
            int type = 9;
            int flags = 0;
            int length = 8;
            this.out.writeInt(0x80030000 | type & 0xFFFF);
            this.out.writeInt((flags & 0xFF) << 24 | length & 0xFFFFFF);
            this.out.writeInt(streamId);
            this.out.writeInt(deltaWindowSize);
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            Util.closeAll(this.out, this.nameValueBlockOut);
        }
    }

    static final class Reader
    implements FrameReader {
        private final DataInputStream in;
        private final boolean client;
        private final NameValueBlockReader nameValueBlockReader;

        Reader(InputStream in, boolean client) {
            this.in = new DataInputStream(in);
            this.nameValueBlockReader = new NameValueBlockReader(in);
            this.client = client;
        }

        public void readConnectionHeader() {
        }

        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            int w1;
            try {
                w1 = this.in.readInt();
            }
            catch (IOException e) {
                return false;
            }
            int w2 = this.in.readInt();
            boolean control = (w1 & Integer.MIN_VALUE) != 0;
            int flags = (w2 & 0xFF000000) >>> 24;
            int length = w2 & 0xFFFFFF;
            if (control) {
                int version = (w1 & 0x7FFF0000) >>> 16;
                int type = w1 & 0xFFFF;
                if (version != 3) {
                    throw new ProtocolException("version != 3: " + version);
                }
                switch (type) {
                    case 1: {
                        this.readSynStream(handler, flags, length);
                        return true;
                    }
                    case 2: {
                        this.readSynReply(handler, flags, length);
                        return true;
                    }
                    case 3: {
                        this.readRstStream(handler, flags, length);
                        return true;
                    }
                    case 4: {
                        this.readSettings(handler, flags, length);
                        return true;
                    }
                    case 5: {
                        if (length != 0) {
                            throw Reader.ioException("TYPE_NOOP length: %d != 0", length);
                        }
                        handler.noop();
                        return true;
                    }
                    case 6: {
                        this.readPing(handler, flags, length);
                        return true;
                    }
                    case 7: {
                        this.readGoAway(handler, flags, length);
                        return true;
                    }
                    case 8: {
                        this.readHeaders(handler, flags, length);
                        return true;
                    }
                    case 9: {
                        this.readWindowUpdate(handler, flags, length);
                        return true;
                    }
                    case 16: {
                        Util.skipByReading(this.in, length);
                        throw new UnsupportedOperationException("TODO");
                    }
                }
                throw new IOException("Unexpected frame");
            }
            int streamId = w1 & Integer.MAX_VALUE;
            boolean inFinished = (flags & 1) != 0;
            handler.data(inFinished, streamId, this.in, length);
            return true;
        }

        private void readSynStream(FrameReader.Handler handler, int flags, int length) throws IOException {
            int w1 = this.in.readInt();
            int w2 = this.in.readInt();
            short s3 = this.in.readShort();
            int streamId = w1 & Integer.MAX_VALUE;
            int associatedStreamId = w2 & Integer.MAX_VALUE;
            int priority = (s3 & 0xE000) >>> 13;
            int slot = s3 & 0xFF;
            List<String> nameValueBlock = this.nameValueBlockReader.readNameValueBlock(length - 10);
            boolean inFinished = (flags & 1) != 0;
            boolean outFinished = (flags & 2) != 0;
            handler.headers(outFinished, inFinished, streamId, associatedStreamId, priority, nameValueBlock, HeadersMode.SPDY_SYN_STREAM);
        }

        private void readSynReply(FrameReader.Handler handler, int flags, int length) throws IOException {
            int w1 = this.in.readInt();
            int streamId = w1 & Integer.MAX_VALUE;
            List<String> nameValueBlock = this.nameValueBlockReader.readNameValueBlock(length - 4);
            boolean inFinished = (flags & 1) != 0;
            handler.headers(false, inFinished, streamId, -1, -1, nameValueBlock, HeadersMode.SPDY_REPLY);
        }

        private void readRstStream(FrameReader.Handler handler, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_RST_STREAM length: %d != 8", length);
            }
            int streamId = this.in.readInt() & Integer.MAX_VALUE;
            int errorCodeInt = this.in.readInt();
            ErrorCode errorCode = ErrorCode.fromSpdy3Rst(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_RST_STREAM unexpected error code: %d", errorCodeInt);
            }
            handler.rstStream(streamId, errorCode);
        }

        private void readHeaders(FrameReader.Handler handler, int flags, int length) throws IOException {
            int w1 = this.in.readInt();
            int streamId = w1 & Integer.MAX_VALUE;
            List<String> nameValueBlock = this.nameValueBlockReader.readNameValueBlock(length - 4);
            handler.headers(false, false, streamId, -1, -1, nameValueBlock, HeadersMode.SPDY_HEADERS);
        }

        private void readWindowUpdate(FrameReader.Handler handler, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", length);
            }
            int w1 = this.in.readInt();
            int w2 = this.in.readInt();
            int streamId = w1 & Integer.MAX_VALUE;
            int deltaWindowSize = w2 & Integer.MAX_VALUE;
            handler.windowUpdate(streamId, deltaWindowSize, false);
        }

        private void readPing(FrameReader.Handler handler, int flags, int length) throws IOException {
            if (length != 4) {
                throw Reader.ioException("TYPE_PING length: %d != 4", length);
            }
            int id = this.in.readInt();
            boolean reply = this.client == (id % 2 == 1);
            handler.ping(reply, id, 0);
        }

        private void readGoAway(FrameReader.Handler handler, int flags, int length) throws IOException {
            if (length != 8) {
                throw Reader.ioException("TYPE_GOAWAY length: %d != 8", length);
            }
            int lastGoodStreamId = this.in.readInt() & Integer.MAX_VALUE;
            int errorCodeInt = this.in.readInt();
            ErrorCode errorCode = ErrorCode.fromSpdyGoAway(errorCodeInt);
            if (errorCode == null) {
                throw Reader.ioException("TYPE_GOAWAY unexpected error code: %d", errorCodeInt);
            }
            handler.goAway(lastGoodStreamId, errorCode);
        }

        private void readSettings(FrameReader.Handler handler, int flags, int length) throws IOException {
            int numberOfEntries = this.in.readInt();
            if (length != 4 + 8 * numberOfEntries) {
                throw Reader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", length, numberOfEntries);
            }
            Settings settings = new Settings();
            for (int i = 0; i < numberOfEntries; ++i) {
                int w1 = this.in.readInt();
                int value = this.in.readInt();
                int idFlags = (w1 & 0xFF000000) >>> 24;
                int id = w1 & 0xFFFFFF;
                settings.set(id, idFlags, value);
            }
            boolean clearPrevious = (flags & 1) != 0;
            handler.settings(clearPrevious, settings);
        }

        private static IOException ioException(String message, Object ... args) throws IOException {
            throw new IOException(String.format(message, args));
        }

        public void close() throws IOException {
            Util.closeAll(this.in, this.nameValueBlockReader);
        }
    }
}

