/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.Ping;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import com.squareup.okhttp.internal.spdy.Variant;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpdyConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.daemonThreadFactory("OkHttp SpdyConnection"));
    final Variant variant;
    final boolean client;
    private final IncomingStreamHandler handler;
    private final FrameReader frameReader;
    private final FrameWriter frameWriter;
    private final Map<Integer, SpdyStream> streams = new HashMap<Integer, SpdyStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private Map<Integer, Ping> pings;
    private int nextPingId;
    Settings settings;

    private SpdyConnection(Builder builder) {
        this.variant = builder.variant;
        this.client = builder.client;
        this.handler = builder.handler;
        this.frameReader = this.variant.newReader(builder.in, this.client);
        this.frameWriter = this.variant.newWriter(builder.out, this.client);
        this.nextStreamId = builder.client ? 1 : 2;
        this.nextPingId = builder.client ? 1 : 2;
        this.hostName = builder.hostName;
        new Thread((Runnable)new Reader(), "Spdy Reader " + this.hostName).start();
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    private synchronized SpdyStream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized SpdyStream removeStream(int streamId) {
        SpdyStream stream = this.streams.remove(streamId);
        if (stream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        return stream;
    }

    private synchronized void setIdle(boolean value) {
        this.idleStartTimeNs = value ? System.nanoTime() : Long.MAX_VALUE;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyStream newStream(List<String> requestHeaders, boolean out, boolean in) throws IOException {
        SpdyStream stream;
        boolean outFinished = !out;
        boolean inFinished = !in;
        int associatedStreamId = 0;
        int priority = 0;
        int slot = 0;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int streamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new SpdyStream(streamId, this, outFinished, inFinished, priority, requestHeaders, this.settings);
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                    this.setIdle(false);
                }
            }
            this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, priority, slot, requestHeaders);
        }
        return stream;
    }

    void writeSynReply(int streamId, boolean outFinished, List<String> alternating) throws IOException {
        this.frameWriter.synReply(outFinished, streamId, alternating);
    }

    public void writeData(int streamId, boolean outFinished, byte[] buffer, int offset, int byteCount) throws IOException {
        this.frameWriter.data(outFinished, streamId, buffer, offset, byteCount);
    }

    void writeSynResetLater(final int streamId, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s stream %d", new Object[]{this.hostName, streamId}){

            public void execute() {
                try {
                    SpdyConnection.this.writeSynReset(streamId, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, ErrorCode statusCode) throws IOException {
        this.frameWriter.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final int deltaWindowSize) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s stream %d", new Object[]{this.hostName, streamId}){

            public void execute() {
                try {
                    SpdyConnection.this.writeWindowUpdate(streamId, deltaWindowSize);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeWindowUpdate(int streamId, int deltaWindowSize) throws IOException {
        this.frameWriter.windowUpdate(streamId, deltaWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(false, pingId, 1330343787, ping);
        return ping;
    }

    private void writePingLater(final boolean reply, final int payload1, final int payload2, final Ping ping) {
        executor.submit(new NamedRunnable("OkHttp SPDY Writer %s ping %08x%08x", new Object[]{this.hostName, payload1, payload2}){

            public void execute() {
                try {
                    SpdyConnection.this.writePing(reply, payload1, payload2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(reply, payload1, payload2);
        }
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void noop() throws IOException {
        this.frameWriter.noop();
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode statusCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int lastGoodStreamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(lastGoodStreamId, statusCode);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode connectionCode, ErrorCode streamCode) throws IOException {
        IOException thrown;
        block19: {
            assert (!Thread.holdsLock(this));
            thrown = null;
            try {
                this.shutdown(connectionCode);
            }
            catch (IOException e) {
                thrown = e;
            }
            SpdyStream[] streamsToClose = null;
            Ping[] pingsToCancel = null;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new SpdyStream[this.streams.size()]);
                    this.streams.clear();
                    this.setIdle(false);
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
            }
            if (streamsToClose != null) {
                for (SpdyStream spdyStream : streamsToClose) {
                    try {
                        spdyStream.close(streamCode);
                    }
                    catch (IOException e) {
                        if (thrown == null) continue;
                        thrown = e;
                    }
                }
            }
            if (pingsToCancel != null) {
                for (SpdyStream spdyStream : pingsToCancel) {
                    ((Ping)((Object)spdyStream)).cancel();
                }
            }
            try {
                this.frameReader.close();
            }
            catch (IOException e) {
                thrown = e;
            }
            try {
                this.frameWriter.close();
            }
            catch (IOException e) {
                if (thrown != null) break block19;
                thrown = e;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    public void sendConnectionHeader() throws IOException {
        this.frameWriter.connectionHeader();
        this.frameWriter.settings(new Settings());
    }

    public void readConnectionHeader() throws IOException {
        this.frameReader.readConnectionHeader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reader
    implements Runnable,
    FrameReader.Handler {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            try {
                while (SpdyConnection.this.frameReader.nextFrame(this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    SpdyConnection.this.close(connectionErrorCode, streamErrorCode);
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, InputStream in, int length) throws IOException {
            SpdyStream dataStream = SpdyConnection.this.getStream(streamId);
            if (dataStream == null) {
                SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                Util.skipByReading(in, length);
                return;
            }
            dataStream.receiveData(in, length);
            if (inFinished) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, int priority, List<String> nameValueBlock, HeadersMode headersMode) {
            SpdyStream stream;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                if (SpdyConnection.this.shutdown) {
                    return;
                }
                stream = SpdyConnection.this.getStream(streamId);
                if (stream == null) {
                    if (headersMode.failIfStreamAbsent()) {
                        SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                        return;
                    }
                    if (streamId <= SpdyConnection.this.lastGoodStreamId) {
                        return;
                    }
                    if (streamId % 2 == SpdyConnection.this.nextStreamId % 2) {
                        return;
                    }
                    final SpdyStream newStream = new SpdyStream(streamId, SpdyConnection.this, outFinished, inFinished, priority, nameValueBlock, SpdyConnection.this.settings);
                    SpdyConnection.this.lastGoodStreamId = streamId;
                    SpdyConnection.this.streams.put(streamId, newStream);
                    executor.submit(new NamedRunnable("OkHttp Callback %s stream %d", new Object[]{SpdyConnection.this.hostName, streamId}){

                        public void execute() {
                            try {
                                SpdyConnection.this.handler.receive(newStream);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return;
                }
            }
            if (headersMode.failIfStreamPresent()) {
                stream.closeLater(ErrorCode.PROTOCOL_ERROR);
                SpdyConnection.this.removeStream(streamId);
                return;
            }
            stream.receiveHeaders(nameValueBlock, headersMode);
            if (inFinished) {
                stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            SpdyStream rstStream = SpdyConnection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings newSettings) {
            SpdyStream[] streamsToNotify = null;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                if (SpdyConnection.this.settings == null || clearPrevious) {
                    SpdyConnection.this.settings = newSettings;
                } else {
                    SpdyConnection.this.settings.merge(newSettings);
                }
                if (!SpdyConnection.this.streams.isEmpty()) {
                    streamsToNotify = SpdyConnection.this.streams.values().toArray(new SpdyStream[SpdyConnection.this.streams.size()]);
                }
            }
            if (streamsToNotify != null) {
                SpdyStream[] arr$ = streamsToNotify;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    SpdyStream stream;
                    SpdyStream spdyStream = stream = arr$[i$];
                    synchronized (spdyStream) {
                        SpdyConnection spdyConnection2 = SpdyConnection.this;
                        synchronized (spdyConnection2) {
                            stream.receiveSettings(SpdyConnection.this.settings);
                        }
                    }
                }
            }
        }

        @Override
        public void noop() {
        }

        @Override
        public void ping(boolean reply, int payload1, int payload2) {
            if (reply) {
                Ping ping = SpdyConnection.this.removePing(payload1);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                SpdyConnection.this.writePingLater(true, payload1, payload2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode) {
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                SpdyConnection.this.shutdown = true;
                Iterator i = SpdyConnection.this.streams.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    int streamId = (Integer)entry.getKey();
                    if (streamId <= lastGoodStreamId || !((SpdyStream)entry.getValue()).isLocallyInitiated()) continue;
                    ((SpdyStream)entry.getValue()).receiveRstStream(ErrorCode.REFUSED_STREAM);
                    i.remove();
                }
            }
        }

        @Override
        public void windowUpdate(int streamId, int deltaWindowSize, boolean endFlowControl) {
            if (streamId == 0) {
                return;
            }
            SpdyStream stream = SpdyConnection.this.getStream(streamId);
            if (stream != null) {
                stream.receiveWindowUpdate(deltaWindowSize);
            }
        }

        @Override
        public void priority(int streamId, int priority) {
        }
    }

    public static class Builder {
        private String hostName;
        private InputStream in;
        private OutputStream out;
        private IncomingStreamHandler handler = IncomingStreamHandler.REFUSE_INCOMING_STREAMS;
        private Variant variant = Variant.SPDY3;
        private boolean client;

        public Builder(boolean client, Socket socket) throws IOException {
            this("", client, socket.getInputStream(), socket.getOutputStream());
        }

        public Builder(boolean client, InputStream in, OutputStream out) {
            this("", client, in, out);
        }

        public Builder(String hostName, boolean client, Socket socket) throws IOException {
            this(hostName, client, socket.getInputStream(), socket.getOutputStream());
        }

        public Builder(String hostName, boolean client, InputStream in, OutputStream out) {
            this.hostName = hostName;
            this.client = client;
            this.in = in;
            this.out = out;
        }

        public Builder handler(IncomingStreamHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder spdy3() {
            this.variant = Variant.SPDY3;
            return this;
        }

        public Builder http20Draft06() {
            this.variant = Variant.HTTP_20_DRAFT_06;
            return this;
        }

        public SpdyConnection build() {
            return new SpdyConnection(this);
        }
    }
}

