/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public final class SpdyStream {
    public static final int WINDOW_UPDATE_THRESHOLD = 32768;
    private final int id;
    private final SpdyConnection connection;
    private final int priority;
    private long readTimeoutMillis = 0L;
    private int writeWindowSize;
    private final List<String> requestHeaders;
    private List<String> responseHeaders;
    private final SpdyDataInputStream in = new SpdyDataInputStream();
    private final SpdyDataOutputStream out = new SpdyDataOutputStream();
    private ErrorCode errorCode = null;

    SpdyStream(int id, SpdyConnection connection, boolean outFinished, boolean inFinished, int priority, List<String> requestHeaders, Settings settings) {
        if (connection == null) {
            throw new NullPointerException("connection == null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = id;
        this.connection = connection;
        this.in.finished = inFinished;
        this.out.finished = outFinished;
        this.priority = priority;
        this.requestHeaders = requestHeaders;
        this.setSettings(settings);
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.in.finished && !this.in.closed || !this.out.finished && !this.out.closed || this.responseHeaders == null;
    }

    public boolean isLocallyInitiated() {
        boolean streamIsClient;
        boolean bl = streamIsClient = this.id % 2 == 1;
        return this.connection.client == streamIsClient;
    }

    public SpdyConnection getConnection() {
        return this.connection;
    }

    public List<String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public synchronized List<String> getResponseHeaders() throws IOException {
        long remaining = 0L;
        long start = 0L;
        if (this.readTimeoutMillis != 0L) {
            start = System.nanoTime() / 1000000L;
            remaining = this.readTimeoutMillis;
        }
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                if (this.readTimeoutMillis == 0L) {
                    this.wait();
                    continue;
                }
                if (remaining > 0L) {
                    this.wait(remaining);
                    remaining = start + this.readTimeoutMillis - System.nanoTime() / 1000000L;
                    continue;
                }
                throw new SocketTimeoutException("Read response header timeout. readTimeoutMillis: " + this.readTimeoutMillis);
            }
            if (this.responseHeaders != null) {
                return this.responseHeaders;
            }
            throw new IOException("stream was reset: " + (Object)((Object)this.errorCode));
        }
        catch (InterruptedException e) {
            InterruptedIOException rethrow = new InterruptedIOException();
            rethrow.initCause(e);
            throw rethrow;
        }
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(List<String> responseHeaders, boolean out) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean outFinished = false;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (responseHeaders == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.isLocallyInitiated()) {
                throw new IllegalStateException("cannot reply to a locally initiated stream");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = responseHeaders;
            if (!out) {
                this.out.finished = true;
                outFinished = true;
            }
        }
        this.connection.writeSynReply(this.id, outFinished, responseHeaders);
    }

    public void setReadTimeout(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() {
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the output stream");
            }
        }
        return this.out;
    }

    public void close(ErrorCode rstStatusCode) throws IOException {
        if (!this.closeInternal(rstStatusCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, rstStatusCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            block7: {
                block6: {
                    if (this.errorCode == null) break block6;
                    return false;
                }
                if (!this.in.finished || !this.out.finished) break block7;
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<String> headers, HeadersMode headersMode) {
        assert (!Thread.holdsLock(this));
        ErrorCode errorCode = null;
        boolean open = true;
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            if (this.responseHeaders == null) {
                if (headersMode.failIfHeadersAbsent()) {
                    errorCode = ErrorCode.PROTOCOL_ERROR;
                } else {
                    this.responseHeaders = headers;
                    open = this.isOpen();
                    this.notifyAll();
                }
            } else if (headersMode.failIfHeadersPresent()) {
                errorCode = ErrorCode.STREAM_IN_USE;
            } else {
                ArrayList<String> newHeaders = new ArrayList<String>();
                newHeaders.addAll(this.responseHeaders);
                newHeaders.addAll(headers);
                this.responseHeaders = newHeaders;
            }
        }
        if (errorCode != null) {
            this.closeLater(errorCode);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    void receiveData(InputStream in, int length) throws IOException {
        assert (!Thread.holdsLock(this));
        this.in.receive(in, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        boolean open;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            this.in.finished = true;
            open = this.isOpen();
            this.notifyAll();
        }
        if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    private void setSettings(Settings settings) {
        assert (Thread.holdsLock(this.connection));
        this.writeWindowSize = settings != null ? settings.getInitialWindowSize(65536) : 65536;
    }

    void receiveSettings(Settings settings) {
        assert (Thread.holdsLock(this));
        this.setSettings(settings);
        this.notifyAll();
    }

    synchronized void receiveWindowUpdate(int deltaWindowSize) {
        SpdyDataOutputStream spdyDataOutputStream = this.out;
        spdyDataOutputStream.unacknowledgedBytes = spdyDataOutputStream.unacknowledgedBytes - deltaWindowSize;
        this.notifyAll();
    }

    int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStreamIfNecessary() throws IOException {
        boolean open;
        boolean cancel;
        assert (!Thread.holdsLock(this));
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            cancel = !this.in.finished && this.in.closed && (this.out.finished || this.out.closed);
            open = this.isOpen();
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    private final class SpdyDataInputStream
    extends InputStream {
        private final byte[] buffer = new byte[65536];
        private int pos = -1;
        private int limit;
        private boolean closed;
        private boolean finished;
        private int unacknowledgedBytes = 0;

        private SpdyDataInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                block5: {
                    this.checkNotClosed();
                    if (this.pos != -1) break block5;
                    return 0;
                }
                if (this.limit > this.pos) {
                    return this.limit - this.pos;
                }
                return this.limit + (this.buffer.length - this.pos);
            }
        }

        @Override
        public int read() throws IOException {
            return Util.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int offset, int count) throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                int bytesToCopy;
                block9: {
                    Util.checkOffsetAndCount(b.length, offset, count);
                    this.waitUntilReadable();
                    this.checkNotClosed();
                    if (this.pos != -1) break block9;
                    return -1;
                }
                int copied = 0;
                if (this.limit <= this.pos) {
                    bytesToCopy = Math.min(count, this.buffer.length - this.pos);
                    System.arraycopy(this.buffer, this.pos, b, offset, bytesToCopy);
                    this.pos += bytesToCopy;
                    copied += bytesToCopy;
                    if (this.pos == this.buffer.length) {
                        this.pos = 0;
                    }
                }
                if (copied < count) {
                    bytesToCopy = Math.min(this.limit - this.pos, count - copied);
                    System.arraycopy(this.buffer, this.pos, b, offset + copied, bytesToCopy);
                    this.pos += bytesToCopy;
                    copied += bytesToCopy;
                }
                this.unacknowledgedBytes += copied;
                if (this.unacknowledgedBytes >= 32768) {
                    SpdyStream.this.connection.writeWindowUpdateLater(SpdyStream.this.id, this.unacknowledgedBytes);
                    this.unacknowledgedBytes = 0;
                }
                if (this.pos == this.limit) {
                    this.pos = -1;
                    this.limit = 0;
                }
                return copied;
            }
        }

        private void waitUntilReadable() throws IOException {
            long start = 0L;
            long remaining = 0L;
            if (SpdyStream.this.readTimeoutMillis != 0L) {
                start = System.nanoTime() / 1000000L;
                remaining = SpdyStream.this.readTimeoutMillis;
            }
            try {
                while (this.pos == -1 && !this.finished && !this.closed && SpdyStream.this.errorCode == null) {
                    if (SpdyStream.this.readTimeoutMillis == 0L) {
                        SpdyStream.this.wait();
                        continue;
                    }
                    if (remaining > 0L) {
                        SpdyStream.this.wait(remaining);
                        remaining = start + SpdyStream.this.readTimeoutMillis - System.nanoTime() / 1000000L;
                        continue;
                    }
                    throw new SocketTimeoutException();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(InputStream in, int byteCount) throws IOException {
            boolean flowControlError;
            int limit;
            int firstNewByte;
            int pos;
            boolean finished;
            assert (!Thread.holdsLock(SpdyStream.this));
            if (byteCount == 0) {
                return;
            }
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                finished = this.finished;
                pos = this.pos;
                firstNewByte = this.limit;
                limit = this.limit;
                flowControlError = byteCount > this.buffer.length - this.available();
            }
            if (flowControlError) {
                Util.skipByReading(in, byteCount);
                SpdyStream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                return;
            }
            if (finished) {
                Util.skipByReading(in, byteCount);
                return;
            }
            if (pos < limit) {
                int firstCopyCount = Math.min(byteCount, this.buffer.length - limit);
                Util.readFully(in, this.buffer, limit, firstCopyCount);
                byteCount -= firstCopyCount;
                if ((limit += firstCopyCount) == this.buffer.length) {
                    limit = 0;
                }
            }
            if (byteCount > 0) {
                Util.readFully(in, this.buffer, limit, byteCount);
                limit += byteCount;
            }
            SpdyStream spdyStream2 = SpdyStream.this;
            synchronized (spdyStream2) {
                this.limit = limit;
                if (this.pos == -1) {
                    this.pos = firstNewByte;
                    SpdyStream.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.closed = true;
                SpdyStream.this.notifyAll();
            }
            SpdyStream.this.cancelStreamIfNecessary();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (SpdyStream.this.errorCode != null) {
                throw new IOException("stream was reset: " + (Object)((Object)SpdyStream.this.errorCode));
            }
        }
    }

    private final class SpdyDataOutputStream
    extends OutputStream {
        private final byte[] buffer = new byte[8192];
        private int pos = 0;
        private boolean closed;
        private boolean finished;
        private int unacknowledgedBytes = 0;

        private SpdyDataOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            Util.writeSingleByte(this, b);
        }

        @Override
        public void write(byte[] bytes, int offset, int count) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            Util.checkOffsetAndCount(bytes.length, offset, count);
            this.checkNotClosed();
            while (count > 0) {
                if (this.pos == this.buffer.length) {
                    this.writeFrame(false);
                }
                int bytesToCopy = Math.min(count, this.buffer.length - this.pos);
                System.arraycopy(bytes, offset, this.buffer, this.pos, bytesToCopy);
                this.pos += bytesToCopy;
                offset += bytesToCopy;
                count -= bytesToCopy;
            }
        }

        @Override
        public void flush() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            this.checkNotClosed();
            if (this.pos > 0) {
                this.writeFrame(false);
                SpdyStream.this.connection.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            if (!((SpdyStream)SpdyStream.this).out.finished) {
                this.writeFrame(true);
            }
            SpdyStream.this.connection.flush();
            SpdyStream.this.cancelStreamIfNecessary();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFrame(boolean outFinished) throws IOException {
            assert (!Thread.holdsLock(SpdyStream.this));
            int length = this.pos;
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                this.waitUntilWritable(length, outFinished);
                this.unacknowledgedBytes += length;
            }
            SpdyStream.this.connection.writeData(SpdyStream.this.id, outFinished, this.buffer, 0, this.pos);
            this.pos = 0;
        }

        private void waitUntilWritable(int count, boolean last) throws IOException {
            try {
                while (this.unacknowledgedBytes + count >= SpdyStream.this.writeWindowSize) {
                    SpdyStream.this.wait();
                    if (!last && this.closed) {
                        throw new IOException("stream closed");
                    }
                    if (this.finished) {
                        throw new IOException("stream finished");
                    }
                    if (SpdyStream.this.errorCode == null) continue;
                    throw new IOException("stream was reset: " + (Object)((Object)SpdyStream.this.errorCode));
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotClosed() throws IOException {
            SpdyStream spdyStream = SpdyStream.this;
            synchronized (spdyStream) {
                if (this.closed) {
                    throw new IOException("stream closed");
                }
                if (this.finished) {
                    throw new IOException("stream finished");
                }
                if (SpdyStream.this.errorCode != null) {
                    throw new IOException("stream was reset: " + (Object)((Object)SpdyStream.this.errorCode));
                }
            }
        }
    }
}

