/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;

public class PluginEntry {
    public String service = "";
    public String pluginClass = "";
    public CordovaPlugin plugin = null;
    public boolean onload = false;

    public PluginEntry(String service, String pluginClass, boolean onload) {
        this.service = service;
        this.pluginClass = pluginClass;
        this.onload = onload;
    }

    public PluginEntry(String service, CordovaPlugin plugin) {
        this.service = service;
        this.plugin = plugin;
        this.pluginClass = plugin.getClass().getName();
        this.onload = false;
    }

    public CordovaPlugin createPlugin(CordovaWebView webView, CordovaInterface ctx) {
        if (this.plugin != null) {
            return this.plugin;
        }
        try {
            Class c = this.getClassByName(this.pluginClass);
            if (this.isCordovaPlugin(c)) {
                this.plugin = (CordovaPlugin)c.newInstance();
                this.plugin.initialize(ctx, webView);
                return this.plugin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + this.pluginClass + ".");
        }
        return null;
    }

    private Class getClassByName(String clazz) throws ClassNotFoundException {
        Class<?> c = null;
        if (clazz != null && !"".equals(clazz)) {
            c = Class.forName(clazz);
        }
        return c;
    }

    private boolean isCordovaPlugin(Class c) {
        if (c != null) {
            return CordovaPlugin.class.isAssignableFrom(c);
        }
        return false;
    }
}

