import java.text.DecimalFormat;
import java.util.Scanner;

public class MoneyConversion {

	public static double conversionRate = 0.74;
	
	public static void main(String[] args) {
		StartApp();
		
		while (RunAgain()) {
			StartApp();
		}
		
		StopApp();
	}
	
	public static void StartApp() {
		ClearScreen();
		ShowWelcomeScreen();
		
		double usTotal = GetUSDollarTotal();
		
		if (usTotal > 0.0) {
			ShowEURDollarConversion(usTotal);	
		}
		else {
			System.out.println("\nUnable to do the conversion.  Please check your input.");
		}
	}
	
	public static boolean RunAgain() {
		System.out.print("Do you want to run this again? (Y/N)\t");
		Scanner s = new Scanner(System.in);
		String runAgainValue = s.nextLine();
		
		if (runAgainValue.toUpperCase().equals("Y")) {
			return true;
		}
		else {
			return false;
		}
	}
	
	public static void StopApp() {
		ClearScreen();
		ShowGoodbyeScreen();
	}
	
	public static void ClearScreen() {
		for (int i=0; i<20; i++) {
			System.out.println("");
		}
	}
	
	public static void ShowWelcomeScreen() {
		System.out.println("__________________________________________________________________\n");
		System.out.println("Money Conversion App\nAaron Lieu\nSept 26, 2013\n\n\tConversion Rule\n\tUS dollars -> EUR dollars\n");
		System.out.println("__________________________________________________________________\n");
	}
	
	public static void ShowGoodbyeScreen() {
		System.out.println("Thanks for using my app.\n\nGoodbye.");
	}

	public static double GetUSDollarTotal() {
		System.out.print("US dollars : \t\t$");
		Scanner s = new Scanner(System.in);
		String userUSTotal = s.nextLine();
		
		double usTotal;
		
		try {
			usTotal = Double.parseDouble(userUSTotal);
		}
		catch (NumberFormatException e) {
			usTotal = -1.0;
		}
		finally {
		}
		
		return usTotal;
	}
	
	public static void ShowEURDollarConversion(double usTotal) {
		double eurTotal = usTotal * conversionRate;
		DecimalFormat formatter = new DecimalFormat("###,###,###.00");
		System.out.println("EUR dollars : \t\t$" + String.valueOf(formatter.format(eurTotal)) + "\n");
	}
}
