package com.amyllykoski;

/**
 * DAC MAD Q1: Basics of Programming: Android (ART - 40544)
 * 
 * @author Antti Myllykoski 
 * September 25, 2013.
 * 
 * Homework Week 1. Scanner class currency exchanger.
 * 
 * Creates a currency exchanger that converts USD to EUR. 
 * The current exchange rate is 1USD = .74EUR
 */

import java.util.Scanner;

public class CurrencyExchanger {

	// Current exchange rate.
	private static float exchangeRate = .74f;

	/**
	 * Converts the given amount of USD to EUR.
	 * 
	 * @param amount
	 *            in USD
	 * @return corresponding amount in EUR
	 */
	private float convert(final float amount) {
		return amount * exchangeRate;
	}

	/**
	 * Executes a loop asking USD amounts to be converted to EUR. Returns when
	 * user enters 'quit'.
	 */
	public void run() {

		Scanner input = new Scanner(System.in);
		String resp = "";

		while (true) {

			System.out.print("Enter USD amount (type quit to quit) ");
			resp = input.nextLine();

			if ("quit".equals(resp))
				break;

			try {

				Float amount = Float.parseFloat(resp);
				if (amount < 0)
					throw new NumberFormatException();

				System.out.println("Exchange rate for " + amount + " is "
						+ convert(amount) + "EUR.\n");

			} catch (NumberFormatException ne) {
				System.out.println("Please enter a valid USD amount.\n");
			}
		}
	}

	/**
	 * Main function.
	 * 
	 * @param args
	 *            no arguments supported in this version
	 */
	public static void main(String[] args) {
		new CurrencyExchanger().run();
		System.out.println("\nFinished.\n");
	}
}
