Docs = {"data":{"showPrintButton":false,"videos":[{"items":[{"title":"Sencha Touch Introduction","thumb":"http://b.vimeocdn.com/ts/712/681/71268191_200.jpg","id":"12636777","description":"A quick overview of many of the components built into Sencha Touch"},{"title":"Hello World!","thumb":"http://b.vimeocdn.com/ts/113/695/113695030_200.jpg","id":"18134446","description":"Ready to build your first mobile web app with Sencha Touch? We recently conducted a great introductory webinar, which provides step-by-step instructions for getting started with Sencha Touch. We run through the absolute basics of building your first Sencha Touch app in the time-honored tradition of displaying the words \"Hello World.\"\n\nPresented by James Pearce.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"Sencha Touch Charts","thumb":"http://b.vimeocdn.com/ts/176/207/176207932_200.jpg","id":"26651228","description":"Introducing Sencha Touch Charts — the world’s first HTML5-based, mobile charting and drawing product. Sencha Touch Charts enables you to build complex radar, bar, line, stacked, and pie charts wiith stunning interactivity and incredible ease of use. Visualizing rich data on the mobile web has never been easier."}],"title":"Overview"},{"items":[{"title":"Intro to Layouts","thumb":"http://b.vimeocdn.com/ts/964/302/96430249_200.jpg","id":"15888504","description":"Drew Neil (@nelstrom) describes the basics of how layouts work in Sencha Touch. This tutorial is perfect for beginners who want to understand how to create components and buttons inside their Sencha Touch mobile app.\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices. Learn more at http://sencha.com/touch"},{"title":"Intro to Listeners","thumb":"http://b.vimeocdn.com/ts/108/175/108175461_200.jpg","id":"17414405","description":"Drew Neil (@nelstrom) describes the basics of how listeners work in Sencha Touch. This tutorial is perfect for beginners who want to understand how to create custom behavior and functionality inside their Sencha Touch mobile app.\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices. Learn more at http://sencha.com/touch\n\nGitHub repo: http://github.com/nelstrom/Sencha-Touch-listeners-demo"},{"title":"XTemplates, Part 1","thumb":"http://b.vimeocdn.com/ts/995/102/99510249_200.jpg","id":"16289757","description":"Drew Neil (@nelstrom) has created a two-part series describing how to use XTemplates, a powerful templating system in Ext JS and Sencha Touch that allows developers to easily format views around dynamic data.\n\nCheck out part 2 here: http://vimeo.com/16289990\n\nGitHub repo: http://github.com/nelstrom/Sencha-Touch-templates-demo\n\nRead more about Sencha Touch at http://sencha.com/touch/"},{"title":"XTemplates, Part 2","thumb":"http://b.vimeocdn.com/ts/995/124/99512436_200.jpg","id":"16289990","description":"Drew Neil (@nelstrom) has created a two-part series describing how to use XTemplates, a powerful templating system in Ext JS and Sencha Touch that allows developers to easily format views around dynamic data.\n\nCheck out part 1 here: http://vimeo.com/16289757\n\nGithub repo: http://github.com/nelstrom/Sencha-Touch-templates-demo\n\nRead more about Sencha Touch at http://sencha.com/touch/"}],"title":"Concepts"},{"items":[{"title":"Intro to Panels","thumb":"http://b.vimeocdn.com/ts/964/296/96429682_200.jpg","id":"15879797","description":"Drew Neil (@nelstrom) describes the basics of how panels work in Sencha Touch. This tutorial is perfect for beginners who want to understand how to create components and buttons inside their Sencha Touch mobile app.\n\nGithub repo: http://github.com/nelstrom/Sencha-Touch-panels-demo\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices. Learn more at http://sencha.com/touch"},{"title":"Working With Forms","thumb":"http://b.vimeocdn.com/ts/177/225/177225322_200.jpg","id":"26784522","description":"Drew Neil (@nelstrom) demonstrates how to use Sencha Touch to create applications that allow users to interact with data through forms, and using a simple MVC pattern.\n\nThe GitHub repo for the application is at https://github.com/senchalearn/Forms-demo\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS, BlackBerry OS, and Google Android devices. Learn more at http://sencha.com/​touch"},{"title":"Working with Carousels","thumb":"http://b.vimeocdn.com/ts/160/390/160390728_200.jpg","id":"24475654","description":"Drew Neil (@nelstrom) demonstrates how to use Sencha Touch to create carousel-based apps, such as this artist's portfolio.\n\nHe also gives a brief introduction to the src.sencha.io resizing service.\n\nThe GitHub repo for the application is at https://github.com/nelstrom/Sencha-Touch-Carousel-demo\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS, BlackBerry OS, and Google Android devices. Learn more at http://sencha.com/​touch"},{"title":"Using Tabs and Toolbars","thumb":"http://b.vimeocdn.com/ts/143/657/143657434_200.jpg","id":"22251762","description":"Drew Neil (@nelstrom) demonstrates how to use Sencha Touch to create a tabbed interface with icons, and how toolbars can be used to hold buttons, or a titlebar.\n\nGitHub repo: https://github.com/nelstrom/Sencha-Touch-tabs-and-toolbars-demo\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices. Learn more at http://sencha.com/touch"},{"title":"Working with Lists","thumb":"http://b.vimeocdn.com/ts/144/050/144050468_200.jpg","id":"19245335","description":"Drew Neil (@nelstrom) demonstrates using the List Component in Sencha Touch. Sencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices.\n\nGitHub repo: https://github.com/nelstrom/Sencha-Touch-list-view-demo"},{"title":"Using the Nested List","thumb":"http://b.vimeocdn.com/ts/144/050/144050526_200.jpg","id":"20580117","description":"Drew Neil (@nelstrom) demonstrates using the NestedList Component in Sencha Touch. Sencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices.\n\nGitHub repo: https://github.com/nelstrom/Sencha-Touch-nested-list-demo"}],"title":"Components"},{"items":[{"title":"Layouts Walkthrough","thumb":"http://b.vimeocdn.com/ts/947/950/94795088_200.jpg","id":"15672257","description":"Brian Suda describes and demonstrates how Sencha Touch layouts work in this nine minute tutorial. \n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices.\n\nHopefully these tutorials give you a head start on your next great mobile web app! Enter our App Contest today! http://sencha.com/contest"},{"title":"Sencha Touch UI for iPad","thumb":"http://b.vimeocdn.com/ts/143/765/143765029_200.jpg","id":"22264545","description":"Sencha Touch user interface walkthrough for large touchscreens like Apple iPad.\n\nThis video showcases Sencha Touch 1.0, which was released November 14th, 2010. Learn more at http://sencha.com/touch"},{"title":"Sencha Touch - Create a Twitter App w/ Geolocation","thumb":"http://b.vimeocdn.com/ts/948/005/94800528_200.jpg","id":"15672696","description":"Drew Neil (@nelstrom) demonstrates how to create a Geolocation-powered Twitter mobile app with Sencha Touch in this 12:30 tutorial video.\n\nSencha Touch is a JavaScript framework for mobile touchscreens like Apple iOS and Google Android devices. Learn more at http://sencha.com/touch"}],"title":"Walkthroughs"},{"items":[{"title":"Sencha Touch & PhoneGap demo,          SourceDevCon 2011","thumb":"http://b.vimeocdn.com/ts/152/004/152004852_200.jpg","id":"23358554","description":"This is the final demo from James Pearce's PhoneGap session at Source DevCon, 2011.\n\nThe standard SeattleBars application is enhanced to add a button to each detail page, which in turn fires the createContact() function, containing the code to add a new record via the PhoneGap contacts API.\n\nThe new contact record contains name, telephone number, and photo. The PhoneGap notification API is used to alert the user to the API's success.\n\nThe source code for this demo can be found in Jesse MacFadyen's fork of the app: https://github.com/purplecabbage/seattlebars"},{"title":"Sencha Touch running on a Sony Touch TV/PC","thumb":"http://b.vimeocdn.com/ts/145/472/145472382_200.jpg","id":"22499845","description":"The Sencha Touch kitchen sync demo app, running on a Sony Touch TV/PC"},{"title":"Sencha Labs EventRecorder for Android","thumb":"http://b.vimeocdn.com/ts/132/808/132808875_200.jpg","id":"20672408","description":"The WebKit team at Sencha Inc. has created an open source tool essential to anyone doing web app development on Android mobile devices.\n\nRead more about this project on our blog: http://www.sencha.com/blog/event-recorder-for-android-web-applications/"}],"title":"Running on real devices"},{"items":[{"title":"Sencha Touch for the Mobile Web","thumb":"http://b.vimeocdn.com/ts/110/201/110201978_200.jpg","id":"17677004","description":"Sencha Touch leverages HTML5 and CSS3 to provide a robust web app framework for webkit based mobile browsers. This session is a high-level introduction to Sencha Touch. We will cover components and data handling, theming, best practices, and deployment, and talk about the roadmap for Sencha Touch 2.0.\n\nPresented by David Kaneda.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Structuring Your Sencha Touch Application","thumb":"http://b.vimeocdn.com/ts/110/423/110423355_200.jpg","id":"17705448","description":"In this session you'll learn about the recommended application structure for Sencha Touch (or Ext JS) applications. The new application structure enables any Sencha developer to quickly understand any Sencha application using the new Sencha MVC package.\n\nPresented by Tommy Maintz.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Mobile Development Challenges & Solutions","thumb":"http://b.vimeocdn.com/ts/111/434/111434781_200.jpg","id":"17838527","description":"Mobile web development is becoming exciting again! HTML5 capable mobile devices have blown away the old conventions about how to develop mobile web experiences. But significant challenges still remain. Please join our panel of mobile technology and device experts as they discuss the big challenges in mobile web development as well as what's next for the mobile web. Panel.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Creating Native Apps with Sencha and PhoneGap","thumb":"http://b.vimeocdn.com/ts/111/189/111189208_200.jpg","id":"17806772","description":"Creating native, cross-platform mobile applications doesn't need to be any more complicated than creating a mobile web app. In this session, we will discuss using PhoneGap to create installable web apps that work seamlessly across iOS, Android, BlackBerry and other platforms. We'll look at what features of your web server you can port to the client side, and how to manage syncing with a remote server to create the best mobile experience, online or off.\n\nPresented by Andrew Lunny.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Developing Mobile Web Apps for RIM BB6","thumb":"http://b.vimeocdn.com/ts/111/138/111138013_200.jpg","id":"17799772","description":"After years of false starts, the mobile web is finally getting it right by essentially keeping desktop web standards as is, providing enticing HTML5 capabilities, and having frameworks addressing user experience issues unique to the mobile form factor. RIM has built its BlackBerry WebWorks platform using de-facto standards such as WebKit, and great implementations of key web standards such as HTML5, CSS3, SVG and JavaScript. BlackBerry WebWorks enables developers to use modern web technologies to build mobile applications. In this session, we will review the core aspects of this new platform, and provide a few best practices and code samples.\n\nPresented by Laurent Hasson.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Performance Optimization for Sencha Touch","thumb":"http://b.vimeocdn.com/ts/110/383/110383037_200.jpg","id":"17699976","description":"Mobile devices have very limited processing power compared to modern desktops. It's essential to keep performance optimization in mind when developing Touch applications. Here, we'll discuss how to keep your mobile web app fast and lightweight. We'll learn about such techniques as keeping your DOM slim, managing troublesome CSS3 properties, and other ways to keep your app sleek and responsive.\n\nPresented by Tommy Maintz.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Developing Mobile Web Apps for RIM BB6","thumb":"http://b.vimeocdn.com/ts/116/043/116043775_200.jpg","id":"18446970","description":"After years of false starts, the mobile web is finally getting it right by essentially keeping desktop web standards as is, providing enticing HTML5 capabilities, and having frameworks addressing user experience issues unique to the mobile form factor. RIM has built its BlackBerry WebWorks platform using de-facto standards such as WebKit, and great implementations of key web standards such as HTML5, CSS3, SVG and JavaScript. BlackBerry WebWorks enables developers to use modern web technologies to build mobile applications. In this session, we will review the core aspects of this new platform, and provide a few best practices and code samples.\n\nPresented by Laurent Hasson.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"Serving Mobile Apps from Content Management Systems","thumb":"http://b.vimeocdn.com/ts/112/915/112915586_200.jpg","id":"18036452","description":"Hundreds of millions of web sites around the world are served from Content Management Systems like WordPress and Drupal. How do you equip these platforms to deal with the inevitable rise of mobile web technologies? In this session, we will explore how to create great mobile sites and apps from your existing content, using Sencha Touch.\n\nPresented by James Pearce.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"Performance Optimization for Sencha Touch","thumb":"http://b.vimeocdn.com/ts/111/768/111768410_200.jpg","id":"17882927","description":"Mobile devices have very limited processing power compared to modern desktops. It's essential to keep performance optimization in mind when developing Touch applications. Here, we'll discuss how to keep your mobile web app fast and lightweight. We'll learn about such techniques as keeping your DOM slim, managing troublesome CSS3 properties, and other ways to keep your app sleek and responsive. \n\nPresented by Tommy Maintz.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Theming Sencha Touch","thumb":"http://b.vimeocdn.com/ts/111/744/111744470_200.jpg","id":"17879651","description":"Sencha Touch features a novel theming system built on top of SASS & Compass. This session will show you how to quickly customize the look and feel of your application, extend core styles, and optimize your stylesheets to download faster. Lot of code samples and walkthroughs included. \n\nPresented by David Kaneda.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Debugging Sencha Touch Apps","thumb":"http://b.vimeocdn.com/ts/111/533/111533399_200.jpg","id":"17853133","description":"Debugging applications on mobile devices is challenging. Although simulators exist, tooling is limited. Luckily, with some accomodations, you can debug your mobile web applications using most desktop tools. In this session, we'll go over what works, what doesn't and how to use tools appropriately to debug your mobile web app. \n\nPresented by Tommy Maintz.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Designing The Mobile User Experience","thumb":"http://b.vimeocdn.com/ts/113/368/113368889_200.jpg","id":"18093057","description":"Creating mobile applications that people love to use is a challenging task. In this session, we'll go over the steps required to create a great user experience for different categories of applications and use contexts. We'll review great, and not-so-great mobile design examples and provide practical tips and best practices.\n\nPresented by Brian Fling.\n\nCheck out http://sencha.com/​conference for more session videos."}],"title":"SenchaCon 2010 Videos"}],"stats":[],"touchExamplesUi":true,"guides":[{"items":[{"name":"getting_started","title":"Getting Started with Touch 2","description":"A short introduction to what Sencha Touch is and how to use it for your first app"},{"name":"whats_new","title":"What's new in Touch 2.0","description":"Everything that changed since 1.x, including performance upgrades, API improvements, MVC, DataView and class system improvements"},{"name":"upgrade_1_to_2","title":"Migrating from 1.x","description":"Guides you through the process of migrating your application from Sencha Touch 1"},{"name":"building","title":"Using and Creating Builds","description":"Explains the Sencha Touch builds available out of the box, and how to create your own"}],"title":"Overview"},{"items":[{"name":"first_app","title":"Building your First App","description":"How to build your first app in 15 minutes flat"},{"name":"apps_intro","title":"All about Applications","description":"Introduces the core concepts about writing applications in Sencha Touch 2 - introduces MVC, routing, device profiles and more"},{"name":"profiles","title":"Device Profiles","description":"Device Profiles enable you to easily write universal apps that can present customized UIs on phones and tablets"},{"name":"controllers","title":"Controllers","description":"Introduces all of the core concepts around Controllers, including refs, control and routes"},{"name":"history_support","title":"History Support","description":"Sencha Touch 2 has full history support and a powerful routing system"}],"title":"Writing Applications"},{"items":[{"name":"components","title":"Components","description":"All of the Components in Sencha Touch follow the same pattern and API conventions - this guide teaches you all about it"},{"name":"layouts","title":"Layouts","description":"Sencha Touch employs a powerful layout engine that makes it easy to size and position your components on screen"},{"name":"class_system","title":"The Class System","description":"Tells you all you need to know about the Sencha Touch class. We suggest you read this before you start your first app"}],"title":"Concepts"},{"items":[{"name":"forms","title":"Using Forms","description":"Introduces Form Panels and the fields that they can contain. Shows how to load data, submit to the server and more"},{"name":"dataview","title":"Using DataView","description":"DataViews are a great way to generate lots of components based on a Store. Great for lists, mailboxes, settings screens and more"},{"name":"carousel","title":"Using Carousel","description":"Carousels allow you to swipe between screens and work well on tablets and phone screens"},{"name":"list","title":"Using List","description":"Lists are great at showing lots of information, and pack loads of functionality in out of the box. Find out how to use them here"},{"name":"tabs","title":"Using TabPanel","description":"TabPanels are useful to swapping between different pages of an app, with either top or bottom tabs"},{"name":"nested_list","title":"Using Nested List","description":"Nested List provides a miller column interface to navigate between nested sets of data with a clean and easy to use interface"},{"name":"navigation_view","title":"Using Navigation View","description":"Navigation Views allow you to push items into a stack of views and provides built-in back button and animation support"}],"title":"Components"},{"items":[{"name":"data","title":"Data Package Overview","description":"Introduces the Data Package as a whole, showing you how everything is connected. See the other data guides for more detail"},{"name":"models","title":"Using Models","description":"Introduces the concept of a Model, where they are used and how to configure fields, validations, associations and more"},{"name":"stores","title":"Using Stores","description":"Introduces the concept of Stores, which load data and underpin data-bound Components such as Lists and DataViews"},{"name":"proxies","title":"Using Proxies","description":"Introduces the concept of a Proxy, which is responsible for loading and saving data in your Models and Stores"}],"title":"Data"},{"items":[{"name":"native_packaging","title":"Native iOS Packaging","description":"Native Packaging for iOS on Mac"},{"name":"native_android","title":"Native Android Packaging","description":"Native Packaging for Android on Mac"}],"title":"Packaging"}],"classes":[{"icon":"icon-class","extends":null,"private":false,"name":"Array"},{"icon":"icon-class","extends":null,"private":false,"name":"Boolean"},{"icon":"icon-class","extends":null,"private":false,"name":"Date"},{"icon":"icon-class","extends":null,"private":false,"name":"Function"},{"icon":"icon-class","extends":null,"private":false,"name":"Number"},{"icon":"icon-class","extends":null,"private":false,"name":"Object"},{"icon":"icon-class","extends":null,"private":false,"name":"RegExp"},{"icon":"icon-class","extends":null,"private":false,"name":"String"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext"},{"icon":"icon-class","extends":null,"private":false,"name":"Ext.Version"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.String"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Array"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Number"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Object"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Function"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.JSON"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Date"},{"icon":"icon-class","extends":null,"private":true,"name":"Ext.Base"},{"icon":"icon-class","extends":null,"private":true,"name":"Ext.Class"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.ClassManager"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Loader"},{"icon":"icon-singleton","extends":null,"private":true,"name":"Ext.EventManager"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.env.Browser"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.env.OS"},{"icon":"icon-class","extends":null,"private":true,"name":"Ext.is"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.env.Feature"},{"icon":"icon-class","extends":null,"private":false,"name":"Ext.feature.has"},{"icon":"icon-class","extends":null,"private":false,"name":"Ext.supports"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.DomQuery"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.DomHelper"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.dom.Element"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.dom.CompositeElementLite"},{"icon":"icon-singleton","extends":"Ext.Base","private":true,"name":"Ext.ComponentManager"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.ComponentQuery"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.XTemplateParser"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.app.Action"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.app.Route"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.app.Router"},{"icon":"icon-singleton","extends":null,"private":true,"name":"Ext.Router"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.behavior.Behavior"},{"icon":"icon-singleton","extends":"Ext.Base","private":false,"name":"Ext.data.JsonP"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.Operation"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.Request"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.ResultSet"},{"icon":"icon-singleton","extends":"Ext.Base","private":false,"name":"Ext.data.SortTypes"},{"icon":"icon-singleton","extends":"Ext.Base","private":false,"name":"Ext.data.Types"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.data.Validations"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.identifier.Simple"},{"icon":"icon-class","extends":"Ext.data.identifier.Simple","private":false,"name":"Ext.data.identifier.Uuid"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.writer.Writer"},{"icon":"icon-class","extends":"Ext.data.writer.Writer","private":false,"name":"Ext.data.writer.Xml"},{"icon":"icon-class","extends":"Ext.dom.CompositeElementLite","private":false,"name":"Ext.dom.CompositeElement"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.event.Event"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.fx.State"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.fx.easing.Abstract"},{"icon":"icon-class","extends":"Ext.fx.easing.Abstract","private":true,"name":"Ext.fx.easing.Bounce"},{"icon":"icon-class","extends":"Ext.fx.easing.Abstract","private":true,"name":"Ext.fx.easing.Linear"},{"icon":"icon-class","extends":"Ext.fx.easing.Abstract","private":true,"name":"Ext.fx.easing.Momentum"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Logger"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.mixin.Identifiable"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.mixin.Mixin"},{"icon":"icon-class","extends":"Ext.mixin.Mixin","private":true,"name":"Ext.mixin.Selectable"},{"icon":"icon-class","extends":"Ext.mixin.Mixin","private":true,"name":"Ext.mixin.Traversable"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.DelayedTask"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Filter"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Point"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Region"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Sorter"},{"icon":"icon-singleton","extends":"Ext.Base","private":false,"name":"Ext.util.Inflector"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.Anim"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.anims"},{"icon":"icon-class","extends":"Ext.XTemplateParser","private":true,"name":"Ext.XTemplateCompiler"},{"icon":"icon-class","extends":null,"private":false,"name":"Ext.data.Field"},{"icon":"icon-class","extends":"Ext.data.identifier.Simple","private":false,"name":"Ext.data.identifier.Sequential"},{"icon":"icon-class","extends":"Ext.data.writer.Writer","private":false,"name":"Ext.data.writer.Json"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.event.recognizer.Recognizer"},{"icon":"icon-class","extends":"Ext.event.recognizer.Recognizer","private":true,"name":"Ext.event.recognizer.Touch"},{"icon":"icon-class","extends":"Ext.event.recognizer.Touch","private":true,"name":"Ext.event.recognizer.MultiTouch"},{"icon":"icon-class","extends":"Ext.event.recognizer.MultiTouch","private":true,"name":"Ext.event.recognizer.Pinch"},{"icon":"icon-class","extends":"Ext.event.recognizer.MultiTouch","private":true,"name":"Ext.event.recognizer.Rotate"},{"icon":"icon-class","extends":"Ext.event.recognizer.Touch","private":true,"name":"Ext.event.recognizer.SingleTouch"},{"icon":"icon-class","extends":"Ext.event.recognizer.SingleTouch","private":true,"name":"Ext.event.recognizer.DoubleTap"},{"icon":"icon-class","extends":"Ext.event.recognizer.SingleTouch","private":true,"name":"Ext.event.recognizer.Drag"},{"icon":"icon-class","extends":"Ext.event.recognizer.SingleTouch","private":true,"name":"Ext.event.recognizer.LongPress"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.event.recognizer.Tap"},{"icon":"icon-singleton","extends":null,"private":false,"name":"Ext.DateExtras"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.fx.Easing"},{"icon":"icon-class","extends":"Ext.fx.easing.Abstract","private":false,"name":"Ext.fx.easing.BoundMomentum"},{"icon":"icon-class","extends":"Ext.fx.easing.Linear","private":true,"name":"Ext.fx.easing.EaseIn"},{"icon":"icon-class","extends":"Ext.fx.easing.Linear","private":true,"name":"Ext.fx.easing.EaseOut"},{"icon":"icon-class","extends":"Ext.mixin.Mixin","private":true,"name":"Ext.mixin.Filterable"},{"icon":"icon-class","extends":"Ext.mixin.Mixin","private":false,"name":"Ext.mixin.Observable"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.Evented"},{"icon":"icon-class","extends":"Ext.Evented","private":true,"name":"Ext.AbstractComponent"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.app.Controller"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.app.History"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.app.Profile"},{"icon":"icon-class","extends":"Ext.app.Controller","private":false,"name":"Ext.app.Application"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.Batch"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.Connection"},{"icon":"icon-singleton","extends":"Ext.data.Connection","private":false,"name":"Ext.Ajax"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.reader.Reader"},{"icon":"icon-class","extends":"Ext.data.reader.Reader","private":false,"name":"Ext.data.reader.Json"},{"icon":"icon-class","extends":"Ext.Evented","private":false,"name":"Ext.data.proxy.Proxy"},{"icon":"icon-class","extends":"Ext.data.proxy.Proxy","private":true,"name":"Ext.data.proxy.Client"},{"icon":"icon-class","extends":"Ext.data.proxy.Client","private":false,"name":"Ext.data.proxy.Memory"},{"icon":"icon-class","extends":"Ext.data.proxy.Proxy","private":true,"name":"Ext.data.proxy.Server"},{"icon":"icon-class","extends":"Ext.data.proxy.Server","private":false,"name":"Ext.data.proxy.JsonP"},{"icon":"icon-class","extends":"Ext.data.proxy.Client","private":true,"name":"Ext.data.proxy.WebStorage"},{"icon":"icon-class","extends":"Ext.data.proxy.WebStorage","private":false,"name":"Ext.data.proxy.LocalStorage"},{"icon":"icon-class","extends":"Ext.data.proxy.WebStorage","private":false,"name":"Ext.data.proxy.SessionStorage"},{"icon":"icon-class","extends":"Ext.data.reader.Json","private":false,"name":"Ext.data.reader.Array"},{"icon":"icon-class","extends":"Ext.data.reader.Reader","private":false,"name":"Ext.data.reader.Xml"},{"icon":"icon-class","extends":"Ext.Evented","private":true,"name":"Ext.fx.animation.Abstract"},{"icon":"icon-class","extends":"Ext.fx.animation.Abstract","private":true,"name":"Ext.fx.animation.Cube"},{"icon":"icon-class","extends":"Ext.fx.animation.Abstract","private":true,"name":"Ext.fx.animation.Fade"},{"icon":"icon-class","extends":"Ext.fx.animation.Fade","private":true,"name":"Ext.fx.animation.FadeOut"},{"icon":"icon-class","extends":"Ext.fx.animation.Abstract","private":true,"name":"Ext.fx.animation.Flip"},{"icon":"icon-class","extends":"Ext.fx.animation.Abstract","private":true,"name":"Ext.fx.animation.Pop"},{"icon":"icon-class","extends":"Ext.fx.animation.Pop","private":true,"name":"Ext.fx.animation.PopOut"},{"icon":"icon-class","extends":"Ext.fx.animation.Abstract","private":true,"name":"Ext.fx.animation.Slide"},{"icon":"icon-class","extends":"Ext.fx.animation.Slide","private":true,"name":"Ext.fx.animation.SlideOut"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.fx.Animation"},{"icon":"icon-class","extends":"Ext.Evented","private":true,"name":"Ext.fx.layout.card.Abstract"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Abstract","private":true,"name":"Ext.fx.layout.card.Scroll"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Abstract","private":true,"name":"Ext.fx.layout.card.Style"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Cover"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Cube"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Fade"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Flip"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Pop"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Reveal"},{"icon":"icon-class","extends":"Ext.fx.layout.card.Style","private":true,"name":"Ext.fx.layout.card.Slide"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.fx.layout.Card"},{"icon":"icon-class","extends":"Ext.Evented","private":true,"name":"Ext.fx.runner.Css"},{"icon":"icon-class","extends":"Ext.fx.runner.Css","private":true,"name":"Ext.fx.runner.CssTransition"},{"icon":"icon-class","extends":"Ext.Evented","private":false,"name":"Ext.layout.Default"},{"icon":"icon-class","extends":"Ext.layout.Default","private":false,"name":"Ext.layout.AbstractBox"},{"icon":"icon-class","extends":"Ext.layout.Default","private":false,"name":"Ext.layout.Fit"},{"icon":"icon-class","extends":"Ext.layout.Fit","private":false,"name":"Ext.layout.Card"},{"icon":"icon-class","extends":"Ext.layout.AbstractBox","private":false,"name":"Ext.layout.HBox"},{"icon":"icon-class","extends":"Ext.layout.AbstractBox","private":false,"name":"Ext.layout.VBox"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.layout.Layout"},{"icon":"icon-class","extends":"Ext.mixin.Mixin","private":true,"name":"Ext.mixin.Sortable"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.util.AbstractMixedCollection"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.util.Collection"},{"icon":"icon-singleton","extends":"Ext.util.Collection","private":false,"name":"Ext.data.StoreManager"},{"icon":"icon-singleton","extends":"Ext.Base","private":false,"name":"Ext.util.Format"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.Template"},{"icon":"icon-class","extends":"Ext.Template","private":false,"name":"Ext.XTemplate"},{"icon":"icon-class","extends":"Ext.Evented","private":false,"name":"Ext.util.GeoLocation"},{"icon":"icon-class","extends":"Ext.util.Sorter","private":true,"name":"Ext.util.Grouper"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.HashMap"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.AbstractManager"},{"icon":"icon-singleton","extends":"Ext.AbstractManager","private":false,"name":"Ext.data.ModelManager"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.NodeInterface"},{"icon":"icon-class","extends":null,"private":false,"name":"Ext.data.association.Association"},{"icon":"icon-class","extends":"Ext.data.association.Association","private":false,"name":"Ext.data.association.BelongsTo"},{"icon":"icon-class","extends":"Ext.data.association.Association","private":false,"name":"Ext.data.association.HasMany"},{"icon":"icon-class","extends":"Ext.data.association.Association","private":false,"name":"Ext.data.association.HasOne"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.LineSegment"},{"icon":"icon-class","extends":"Ext.Evented","private":true,"name":"Ext.util.SizeMonitor"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.scroll.Scroller"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Sortable"},{"icon":"icon-class","extends":"Ext.util.AbstractMixedCollection","private":false,"name":"Ext.util.MixedCollection"},{"icon":"icon-class","extends":"Ext.util.MixedCollection","private":true,"name":"Ext.ItemCollection"},{"icon":"icon-class","extends":"Ext.util.MixedCollection","private":false,"name":"Ext.data.Error"},{"icon":"icon-class","extends":"Ext.util.Collection","private":false,"name":"Ext.data.Errors"},{"icon":"icon-class","extends":"Ext.data.proxy.Server","private":false,"name":"Ext.data.proxy.Ajax"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.data.Model"},{"icon":"icon-class","extends":"Ext.Evented","private":false,"name":"Ext.data.Store"},{"icon":"icon-class","extends":"Ext.data.Store","private":false,"name":"Ext.data.ArrayStore"},{"icon":"icon-class","extends":"Ext.data.Store","private":true,"name":"Ext.data.JsonStore"},{"icon":"icon-class","extends":"Ext.data.Store","private":true,"name":"Ext.data.NodeStore"},{"icon":"icon-class","extends":"Ext.data.NodeStore","private":false,"name":"Ext.data.TreeStore"},{"icon":"icon-class","extends":"Ext.data.proxy.Ajax","private":false,"name":"Ext.data.proxy.Rest"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.TapRepeater"},{"icon":"icon-class","extends":"Ext.behavior.Behavior","private":true,"name":"Ext.behavior.Translatable"},{"icon":"icon-class","extends":"Ext.Base","private":false,"name":"Ext.util.Draggable"},{"icon":"icon-class","extends":"Ext.behavior.Behavior","private":true,"name":"Ext.behavior.Draggable"},{"icon":"icon-component","extends":"Ext.AbstractComponent","private":false,"name":"Ext.Component"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Button"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Decorator"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Img"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Label"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Map"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Mask"},{"icon":"icon-component","extends":"Ext.Mask","private":false,"name":"Ext.LoadMask"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.Media"},{"icon":"icon-component","extends":"Ext.Media","private":false,"name":"Ext.Audio"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Spacer"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.Title"},{"icon":"icon-component","extends":"Ext.Media","private":false,"name":"Ext.Video"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.carousel.Indicator"},{"icon":"icon-component","extends":"Ext.Decorator","private":true,"name":"Ext.carousel.Item"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.dataview.IndexBar"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.dataview.ListItemHeader"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.dataview.element.Container"},{"icon":"icon-component","extends":"Ext.dataview.element.Container","private":true,"name":"Ext.dataview.element.List"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.field.Input"},{"icon":"icon-component","extends":"Ext.Decorator","private":false,"name":"Ext.field.Field"},{"icon":"icon-component","extends":"Ext.field.Field","private":false,"name":"Ext.field.Checkbox"},{"icon":"icon-component","extends":"Ext.field.Field","private":false,"name":"Ext.field.Hidden"},{"icon":"icon-component","extends":"Ext.field.Checkbox","private":false,"name":"Ext.field.Radio"},{"icon":"icon-component","extends":"Ext.field.Field","private":false,"name":"Ext.field.Text"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Email"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Number"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Password"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Search"},{"icon":"icon-component","extends":"Ext.field.Number","private":false,"name":"Ext.field.Spinner"},{"icon":"icon-component","extends":"Ext.field.Input","private":true,"name":"Ext.field.TextAreaInput"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.TextArea"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Url"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.plugin.ListPaging"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.plugin.PullRefresh"},{"icon":"icon-component","extends":"Ext.Component","private":true,"name":"Ext.slider.Thumb"},{"icon":"icon-component","extends":"Ext.Button","private":true,"name":"Ext.tab.Tab"},{"icon":"icon-class","extends":"Ext.event.recognizer.SingleTouch","private":true,"name":"Ext.event.recognizer.Swipe"},{"icon":"icon-class","extends":"Ext.event.recognizer.Swipe","private":true,"name":"Ext.event.recognizer.HorizontalSwipe"},{"icon":"icon-class","extends":"Ext.fx.runner.Css","private":true,"name":"Ext.fx.runner.CssAnimation"},{"icon":"icon-class","extends":"Ext.Base","private":true,"name":"Ext.fx.Runner"},{"icon":"icon-class","extends":"Ext.Evented","private":false,"name":"Ext.scroll.View"},{"icon":"icon-class","extends":"Ext.behavior.Behavior","private":true,"name":"Ext.behavior.Scrollable"},{"icon":"icon-component","extends":"Ext.Component","private":false,"name":"Ext.Container"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.Panel"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.SegmentedButton"},{"icon":"icon-component","extends":"Ext.Panel","private":false,"name":"Ext.Sheet"},{"icon":"icon-component","extends":"Ext.Sheet","private":false,"name":"Ext.ActionSheet"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.TitleBar"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.Toolbar"},{"icon":"icon-component","extends":"Ext.Sheet","private":false,"name":"Ext.MessageBox"},{"icon":"icon-singleton","extends":"Ext.MessageBox","private":false,"name":"Ext.Msg"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.carousel.Carousel"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.dataview.component.DataItem"},{"icon":"icon-component","extends":"Ext.Container","private":true,"name":"Ext.dataview.component.Container"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.dataview.DataView"},{"icon":"icon-component","extends":"Ext.dataview.DataView","private":false,"name":"Ext.dataview.List"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.dataview.NestedList"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.form.FieldSet"},{"icon":"icon-component","extends":"Ext.Panel","private":false,"name":"Ext.form.Panel"},{"icon":"icon-component","extends":"Ext.Container","private":true,"name":"Ext.navigation.Bar"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.navigation.View"},{"icon":"icon-component","extends":"Ext.DataView","private":true,"name":"Ext.picker.Slot"},{"icon":"icon-component","extends":"Ext.Sheet","private":false,"name":"Ext.picker.Picker"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.Select"},{"icon":"icon-component","extends":"Ext.picker.Picker","private":false,"name":"Ext.picker.Date"},{"icon":"icon-component","extends":"Ext.field.Text","private":false,"name":"Ext.field.DatePicker"},{"icon":"icon-component","extends":"Ext.Container","private":true,"name":"Ext.slider.Slider"},{"icon":"icon-component","extends":"Ext.field.Field","private":false,"name":"Ext.field.Slider"},{"icon":"icon-component","extends":"Ext.slider.Slider","private":true,"name":"Ext.slider.Toggle"},{"icon":"icon-component","extends":"Ext.field.Slider","private":false,"name":"Ext.field.Toggle"},{"icon":"icon-component","extends":"Ext.Toolbar","private":true,"name":"Ext.tab.Bar"},{"icon":"icon-component","extends":"Ext.Container","private":false,"name":"Ext.tab.Panel"},{"icon":"icon-singleton","extends":"Ext.Container","private":false,"name":"Ext.Viewport"},{"icon":"icon-class","extends":"Ext.event.recognizer.Swipe","private":true,"name":"Ext.event.recognizer.VerticalSwipe"},{"icon":"icon-class","extends":null,"private":false,"name":"Global_CSS"}],"localStorageDb":"touch-2","examples":[{"items":[{"device":"tablet","url":"../examples/kitchensink/index.html","text":"Kitchen Sink","icon":"kitchensink/resources/img/icon.png","desc":"Compact overview of all Sencha Touch components with both a phone and tablet view.","status":"updated"},{"device":"tablet","url":"../examples/twitter/index.html","text":"Twitter","icon":"twitter/resources/images/icon.png","desc":"A simple Twitter client which allows you to search Twitter.","status":"updated"},{"device":"tablet","url":"../examples/kiva/index.html","text":"Kiva","icon":"kiva/resources/images/kiva.png","desc":"A MVC application which provides a mobile interface to Kiva.org.","status":"updated"},{"device":"phone","url":"http://ju.mp/senchajwf","text":"Jog With Friends","icon":"jog-with-friends/resources/images/icon.png","desc":"A Facebook example which allows you to share when you jog.","status":"new"},{"device":"phone","url":"../examples/geocongress/index.html","text":"GeoCongress","icon":"geocongress/resources/img/icon.png","desc":"Find information on your local Legislators","status":"updated"}],"title":"Application Examples"},{"items":[{"device":"phone","url":"../examples/audio/index.html","text":"Audio","icon":"audio/icon.png","desc":"Audio playback on mobile devices."},{"device":"phone","url":"../examples/video/index.html","text":"Video","icon":"video/icon.png","desc":"Video playback on mobile devices."},{"device":"tablet","url":"../examples/carousel/index.html","text":"Carousel","icon":"carousel/resources/images/icon.png","desc":"A component which allows you to swipe through pages."},{"device":"phone","url":"../examples/forms/index.html","text":"Forms","icon":"forms/icon.png","desc":"Demo of the available form fields."},{"device":"phone","url":"../examples/forms_toolbar/index.html","text":"Toolbar Forms","icon":"forms_toolbar/icon.png","desc":"A demo of fields within toolbars."},{"device":"phone","url":"../examples/navigationview/index.html","text":"Navigation View","icon":"nestedlist/icon.png","desc":"A stack based component which allows you to navigate through views."},{"device":"tablet","url":"../examples/icons/index.html","text":"Icons","icon":"icons/icon.png","desc":"Built-in icons for toolbars and tabbars."},{"device":"tablet","url":"../examples/overlays/index.html","text":"Overlays","icon":"overlays/icon.png","desc":"Examples of overlay windows."},{"device":"phone","url":"../examples/map/index.html","text":"Maps","icon":"map/icon.png","desc":"A simple demo of the Google Maps component."},{"device":"phone","url":"../examples/nestedlist/index.html","text":"Nested List","icon":"nestedlist/icon.png","desc":"A miller column interface allowing you to display tree-based data."},{"device":"phone","url":"../examples/list/index.html","text":"List","icon":"list/resources/images/icon.png","desc":"Demo of the list component."},{"device":"phone","url":"../examples/list-search/index.html","text":"Search List","icon":"list-search/resources/images/icon.png","desc":"Demo of a searchable list component."},{"device":"phone","url":"../examples/picker/index.html","text":"Pickers","icon":"picker/icon.png","desc":"An example of the Date Picker component"},{"device":"phone","url":"../examples/tabs/index.html","text":"Tabs","icon":"tabs/resources/images/icon.png","desc":"The simplest tabbar."},{"device":"tablet","url":"../examples/tabs2/index.html","text":"Bottom Tabs","icon":"tabs2/resources/images/icon.png","desc":"A demo of a bottom tabbar."},{"device":"tablet","url":"../examples/toolbars/index.html","text":"Toolbars","icon":"toolbars/icon.png","desc":"Overview of all kinds of different buttons."}],"title":"Component Examples"},{"items":[{"device":"phone","url":"../examples/yql/index.html","text":"YQL","icon":"yql/resources/images/icon.png","desc":"Yahoo! Query Language example."},{"device":"phone","url":"../examples/ajax/index.html","text":"AJAX","icon":"ajax/resources/images/icon.png","desc":"Loading data through JSONP and XMLHttpRequest."}],"title":"Utility Examples"},{"items":[{"device":"phone","url":"../examples/pullrefresh/index.html","text":"Pull to Refresh","icon":"pullrefresh/icon.png","desc":"A pull to refresh plugin for lists."}],"title":"Plugins"}],"signatures":[{"short":"ABS","key":"abstract","long":"abstract"},{"short":"DEP","key":"deprecated","long":"deprecated"},{"short":"PREV","key":"preventable","long":"preventable"},{"short":"PRO","key":"protected","long":"protected"},{"short":"R O","key":"readonly","long":"readonly"},{"short":"REQ","key":"required","long":"required"},{"short":"STA","key":"static","long":"static"},{"short":"TMP","key":"template","long":"template"},{"short":"PRI","key":"private","long":"private"}],"search":[{"type":"class","member":"Array","icon":"class","private":false,"sort":1,"id":"Array","cls":"Array"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Array-method-constructor","cls":"Array"},{"type":"member","member":"concat","icon":"method","private":false,"sort":3,"id":"Array-method-concat","cls":"Array"},{"type":"member","member":"join","icon":"method","private":false,"sort":3,"id":"Array-method-join","cls":"Array"},{"type":"member","member":"pop","icon":"method","private":false,"sort":3,"id":"Array-method-pop","cls":"Array"},{"type":"member","member":"push","icon":"method","private":false,"sort":3,"id":"Array-method-push","cls":"Array"},{"type":"member","member":"reverse","icon":"method","private":false,"sort":3,"id":"Array-method-reverse","cls":"Array"},{"type":"member","member":"shift","icon":"method","private":false,"sort":3,"id":"Array-method-shift","cls":"Array"},{"type":"member","member":"slice","icon":"method","private":false,"sort":3,"id":"Array-method-slice","cls":"Array"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Array-method-sort","cls":"Array"},{"type":"member","member":"splice","icon":"method","private":false,"sort":3,"id":"Array-method-splice","cls":"Array"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Array-method-toString","cls":"Array"},{"type":"member","member":"unshift","icon":"method","private":false,"sort":3,"id":"Array-method-unshift","cls":"Array"},{"type":"member","member":"length","icon":"property","private":false,"sort":3,"id":"Array-property-length","cls":"Array"},{"type":"class","member":"Boolean","icon":"class","private":false,"sort":1,"id":"Boolean","cls":"Boolean"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Boolean-method-constructor","cls":"Boolean"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Boolean-method-toString","cls":"Boolean"},{"type":"member","member":"valueOf","icon":"method","private":false,"sort":3,"id":"Boolean-method-valueOf","cls":"Boolean"},{"type":"class","member":"Date","icon":"class","private":false,"sort":1,"id":"Date","cls":"Date"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Date-method-constructor","cls":"Date"},{"type":"member","member":"getDate","icon":"method","private":false,"sort":3,"id":"Date-method-getDate","cls":"Date"},{"type":"member","member":"getDay","icon":"method","private":false,"sort":3,"id":"Date-method-getDay","cls":"Date"},{"type":"member","member":"getFullYear","icon":"method","private":false,"sort":3,"id":"Date-method-getFullYear","cls":"Date"},{"type":"member","member":"getHours","icon":"method","private":false,"sort":3,"id":"Date-method-getHours","cls":"Date"},{"type":"member","member":"getMilliseconds","icon":"method","private":false,"sort":3,"id":"Date-method-getMilliseconds","cls":"Date"},{"type":"member","member":"getMinutes","icon":"method","private":false,"sort":3,"id":"Date-method-getMinutes","cls":"Date"},{"type":"member","member":"getMonth","icon":"method","private":false,"sort":3,"id":"Date-method-getMonth","cls":"Date"},{"type":"member","member":"getSeconds","icon":"method","private":false,"sort":3,"id":"Date-method-getSeconds","cls":"Date"},{"type":"member","member":"getTime","icon":"method","private":false,"sort":3,"id":"Date-method-getTime","cls":"Date"},{"type":"member","member":"getTimezoneOffset","icon":"method","private":false,"sort":3,"id":"Date-method-getTimezoneOffset","cls":"Date"},{"type":"member","member":"getUTCDate","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCDate","cls":"Date"},{"type":"member","member":"getUTCDay","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCDay","cls":"Date"},{"type":"member","member":"getUTCFullYear","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCFullYear","cls":"Date"},{"type":"member","member":"getUTCHours","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCHours","cls":"Date"},{"type":"member","member":"getUTCMilliseconds","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCMilliseconds","cls":"Date"},{"type":"member","member":"getUTCMinutes","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCMinutes","cls":"Date"},{"type":"member","member":"getUTCMonth","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCMonth","cls":"Date"},{"type":"member","member":"getUTCSeconds","icon":"method","private":false,"sort":3,"id":"Date-method-getUTCSeconds","cls":"Date"},{"type":"member","member":"setDate","icon":"method","private":false,"sort":3,"id":"Date-method-setDate","cls":"Date"},{"type":"member","member":"setFullYear","icon":"method","private":false,"sort":3,"id":"Date-method-setFullYear","cls":"Date"},{"type":"member","member":"setHours","icon":"method","private":false,"sort":3,"id":"Date-method-setHours","cls":"Date"},{"type":"member","member":"setMilliseconds","icon":"method","private":false,"sort":3,"id":"Date-method-setMilliseconds","cls":"Date"},{"type":"member","member":"setMinutes","icon":"method","private":false,"sort":3,"id":"Date-method-setMinutes","cls":"Date"},{"type":"member","member":"setMonth","icon":"method","private":false,"sort":3,"id":"Date-method-setMonth","cls":"Date"},{"type":"member","member":"setSeconds","icon":"method","private":false,"sort":3,"id":"Date-method-setSeconds","cls":"Date"},{"type":"member","member":"setTime","icon":"method","private":false,"sort":3,"id":"Date-method-setTime","cls":"Date"},{"type":"member","member":"setUTCDate","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCDate","cls":"Date"},{"type":"member","member":"setUTCFullYear","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCFullYear","cls":"Date"},{"type":"member","member":"setUTCHours","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCHours","cls":"Date"},{"type":"member","member":"setUTCMilliseconds","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCMilliseconds","cls":"Date"},{"type":"member","member":"setUTCMinutes","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCMinutes","cls":"Date"},{"type":"member","member":"setUTCMonth","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCMonth","cls":"Date"},{"type":"member","member":"setUTCSeconds","icon":"method","private":false,"sort":3,"id":"Date-method-setUTCSeconds","cls":"Date"},{"type":"member","member":"toDateString","icon":"method","private":false,"sort":3,"id":"Date-method-toDateString","cls":"Date"},{"type":"member","member":"toLocaleDateString","icon":"method","private":false,"sort":3,"id":"Date-method-toLocaleDateString","cls":"Date"},{"type":"member","member":"toLocaleString","icon":"method","private":false,"sort":3,"id":"Date-method-toLocaleString","cls":"Date"},{"type":"member","member":"toLocaleTimeString","icon":"method","private":false,"sort":3,"id":"Date-method-toLocaleTimeString","cls":"Date"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Date-method-toString","cls":"Date"},{"type":"member","member":"toTimeString","icon":"method","private":false,"sort":3,"id":"Date-method-toTimeString","cls":"Date"},{"type":"member","member":"toUTCString","icon":"method","private":false,"sort":3,"id":"Date-method-toUTCString","cls":"Date"},{"type":"member","member":"valueOf","icon":"method","private":false,"sort":3,"id":"Date-method-valueOf","cls":"Date"},{"type":"member","member":"UTC","icon":"method","private":false,"sort":3,"id":"Date-static-method-UTC","cls":"Date"},{"type":"member","member":"now","icon":"method","private":false,"sort":3,"id":"Date-static-method-now","cls":"Date"},{"type":"member","member":"parse","icon":"method","private":false,"sort":3,"id":"Date-static-method-parse","cls":"Date"},{"type":"class","member":"Function","icon":"class","private":false,"sort":1,"id":"Function","cls":"Function"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Function-method-constructor","cls":"Function"},{"type":"member","member":"apply","icon":"method","private":false,"sort":3,"id":"Function-method-apply","cls":"Function"},{"type":"member","member":"call","icon":"method","private":false,"sort":3,"id":"Function-method-call","cls":"Function"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Function-method-toString","cls":"Function"},{"type":"member","member":"length","icon":"property","private":false,"sort":3,"id":"Function-property-length","cls":"Function"},{"type":"class","member":"Number","icon":"class","private":false,"sort":1,"id":"Number","cls":"Number"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Number-method-constructor","cls":"Number"},{"type":"member","member":"toExponential","icon":"method","private":false,"sort":3,"id":"Number-method-toExponential","cls":"Number"},{"type":"member","member":"toFixed","icon":"method","private":false,"sort":3,"id":"Number-method-toFixed","cls":"Number"},{"type":"member","member":"toLocaleString","icon":"method","private":false,"sort":3,"id":"Number-method-toLocaleString","cls":"Number"},{"type":"member","member":"toPrecision","icon":"method","private":false,"sort":3,"id":"Number-method-toPrecision","cls":"Number"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Number-method-toString","cls":"Number"},{"type":"member","member":"valueOf","icon":"method","private":false,"sort":3,"id":"Number-method-valueOf","cls":"Number"},{"type":"member","member":"NEGATIVE_INFINITY","icon":"property","private":false,"sort":3,"id":"Number-property-NEGATIVE_INFINITY","cls":"Number"},{"type":"member","member":"POSITIVE_INFINITY","icon":"property","private":false,"sort":3,"id":"Number-property-POSITIVE_INFINITY","cls":"Number"},{"type":"member","member":"MAX_VALUE","icon":"property","private":false,"sort":3,"id":"Number-static-property-MAX_VALUE","cls":"Number"},{"type":"member","member":"MIN_VALUE","icon":"property","private":false,"sort":3,"id":"Number-static-property-MIN_VALUE","cls":"Number"},{"type":"member","member":"NaN","icon":"property","private":false,"sort":3,"id":"Number-static-property-NaN","cls":"Number"},{"type":"class","member":"Object","icon":"class","private":false,"sort":1,"id":"Object","cls":"Object"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Object-method-constructor","cls":"Object"},{"type":"member","member":"hasOwnProperty","icon":"method","private":false,"sort":3,"id":"Object-method-hasOwnProperty","cls":"Object"},{"type":"member","member":"isPrototypeOf","icon":"method","private":false,"sort":3,"id":"Object-method-isPrototypeOf","cls":"Object"},{"type":"member","member":"propertyIsEnumerable","icon":"method","private":false,"sort":3,"id":"Object-method-propertyIsEnumerable","cls":"Object"},{"type":"member","member":"toLocaleString","icon":"method","private":false,"sort":3,"id":"Object-method-toLocaleString","cls":"Object"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Object-method-toString","cls":"Object"},{"type":"member","member":"valueOf","icon":"method","private":false,"sort":3,"id":"Object-method-valueOf","cls":"Object"},{"type":"member","member":"constructor","icon":"property","private":false,"sort":3,"id":"Object-property-constructor","cls":"Object"},{"type":"member","member":"prototype","icon":"property","private":false,"sort":3,"id":"Object-property-prototype","cls":"Object"},{"type":"class","member":"RegExp","icon":"class","private":false,"sort":1,"id":"RegExp","cls":"RegExp"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"RegExp-method-constructor","cls":"RegExp"},{"type":"member","member":"exec","icon":"method","private":false,"sort":3,"id":"RegExp-method-exec","cls":"RegExp"},{"type":"member","member":"test","icon":"method","private":false,"sort":3,"id":"RegExp-method-test","cls":"RegExp"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"RegExp-method-toString","cls":"RegExp"},{"type":"member","member":"global","icon":"property","private":false,"sort":3,"id":"RegExp-property-global","cls":"RegExp"},{"type":"member","member":"ignoreCase","icon":"property","private":false,"sort":3,"id":"RegExp-property-ignoreCase","cls":"RegExp"},{"type":"member","member":"lastIndex","icon":"property","private":false,"sort":3,"id":"RegExp-property-lastIndex","cls":"RegExp"},{"type":"member","member":"multiline","icon":"property","private":false,"sort":3,"id":"RegExp-property-multiline","cls":"RegExp"},{"type":"member","member":"source","icon":"property","private":false,"sort":3,"id":"RegExp-property-source","cls":"RegExp"},{"type":"class","member":"String","icon":"class","private":false,"sort":1,"id":"String","cls":"String"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"String-method-constructor","cls":"String"},{"type":"member","member":"charAt","icon":"method","private":false,"sort":3,"id":"String-method-charAt","cls":"String"},{"type":"member","member":"charCodeAt","icon":"method","private":false,"sort":3,"id":"String-method-charCodeAt","cls":"String"},{"type":"member","member":"concat","icon":"method","private":false,"sort":3,"id":"String-method-concat","cls":"String"},{"type":"member","member":"fromCharCode","icon":"method","private":false,"sort":3,"id":"String-method-fromCharCode","cls":"String"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"String-method-indexOf","cls":"String"},{"type":"member","member":"lastIndexOf","icon":"method","private":false,"sort":3,"id":"String-method-lastIndexOf","cls":"String"},{"type":"member","member":"localeCompare","icon":"method","private":false,"sort":3,"id":"String-method-localeCompare","cls":"String"},{"type":"member","member":"match","icon":"method","private":false,"sort":3,"id":"String-method-match","cls":"String"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"String-method-replace","cls":"String"},{"type":"member","member":"search","icon":"method","private":false,"sort":3,"id":"String-method-search","cls":"String"},{"type":"member","member":"slice","icon":"method","private":false,"sort":3,"id":"String-method-slice","cls":"String"},{"type":"member","member":"split","icon":"method","private":false,"sort":3,"id":"String-method-split","cls":"String"},{"type":"member","member":"substr","icon":"method","private":false,"sort":3,"id":"String-method-substr","cls":"String"},{"type":"member","member":"substring","icon":"method","private":false,"sort":3,"id":"String-method-substring","cls":"String"},{"type":"member","member":"toLocaleLowerCase","icon":"method","private":false,"sort":3,"id":"String-method-toLocaleLowerCase","cls":"String"},{"type":"member","member":"toLocaleUpperCase","icon":"method","private":false,"sort":3,"id":"String-method-toLocaleUpperCase","cls":"String"},{"type":"member","member":"toLowerCase","icon":"method","private":false,"sort":3,"id":"String-method-toLowerCase","cls":"String"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"String-method-toString","cls":"String"},{"type":"member","member":"toUpperCase","icon":"method","private":false,"sort":3,"id":"String-method-toUpperCase","cls":"String"},{"type":"member","member":"valueOf","icon":"method","private":false,"sort":3,"id":"String-method-valueOf","cls":"String"},{"type":"member","member":"length","icon":"property","private":false,"sort":3,"id":"String-property-length","cls":"String"},{"type":"class","member":"Ext","icon":"class","private":false,"sort":1,"id":"Ext","cls":"Ext"},{"type":"member","member":"application","icon":"method","private":false,"sort":3,"id":"Ext-method-application","cls":"Ext"},{"type":"member","member":"apply","icon":"method","private":false,"sort":3,"id":"Ext-method-apply","cls":"Ext"},{"type":"member","member":"applyIf","icon":"method","private":false,"sort":3,"id":"Ext-method-applyIf","cls":"Ext"},{"type":"member","member":"bind","icon":"method","private":false,"sort":3,"id":"Ext-method-bind","cls":"Ext"},{"type":"member","member":"callback","icon":"method","private":false,"sort":3,"id":"Ext-method-callback","cls":"Ext"},{"type":"member","member":"clean","icon":"method","private":false,"sort":3,"id":"Ext-method-clean","cls":"Ext"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext-method-clone","cls":"Ext"},{"type":"member","member":"copyTo","icon":"method","private":false,"sort":3,"id":"Ext-method-copyTo","cls":"Ext"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext-method-create","cls":"Ext"},{"type":"member","member":"createByAlias","icon":"method","private":false,"sort":3,"id":"Ext-method-createByAlias","cls":"Ext"},{"type":"member","member":"createInterceptor","icon":"method","private":false,"sort":3,"id":"Ext-method-createInterceptor","cls":"Ext"},{"type":"member","member":"createWidget","icon":"method","private":false,"sort":3,"id":"Ext-method-createWidget","cls":"Ext"},{"type":"member","member":"decode","icon":"method","private":false,"sort":3,"id":"Ext-method-decode","cls":"Ext"},{"type":"member","member":"defer","icon":"method","private":false,"sort":3,"id":"Ext-method-defer","cls":"Ext"},{"type":"member","member":"define","icon":"method","private":false,"sort":3,"id":"Ext-method-define","cls":"Ext"},{"type":"member","member":"deprecateClassConfigDirectAccess","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateClassConfigDirectAccess","cls":"Ext"},{"type":"member","member":"deprecateClassMember","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateClassMember","cls":"Ext"},{"type":"member","member":"deprecateClassMembers","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateClassMembers","cls":"Ext"},{"type":"member","member":"deprecateClassMethod","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateClassMethod","cls":"Ext"},{"type":"member","member":"deprecateMethod","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateMethod","cls":"Ext"},{"type":"member","member":"deprecateProperty","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecateProperty","cls":"Ext"},{"type":"member","member":"deprecatePropertyValue","icon":"method","private":true,"sort":3,"id":"Ext-method-deprecatePropertyValue","cls":"Ext"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext-method-destroy","cls":"Ext"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext-method-each","cls":"Ext"},{"type":"member","member":"encode","icon":"method","private":false,"sort":3,"id":"Ext-method-encode","cls":"Ext"},{"type":"member","member":"exclude","icon":"method","private":false,"sort":3,"id":"Ext-method-exclude","cls":"Ext"},{"type":"member","member":"extend","icon":"method","private":false,"sort":3,"id":"Ext-method-extend","cls":"Ext"},{"type":"member","member":"factory","icon":"method","private":true,"sort":3,"id":"Ext-method-factory","cls":"Ext"},{"type":"member","member":"factoryConfig","icon":"method","private":true,"sort":3,"id":"Ext-method-factoryConfig","cls":"Ext"},{"type":"member","member":"flatten","icon":"method","private":false,"sort":3,"id":"Ext-method-flatten","cls":"Ext"},{"type":"member","member":"fly","icon":"method","private":false,"sort":3,"id":"Ext-method-fly","cls":"Ext"},{"type":"member","member":"functionFactory","icon":"method","private":true,"sort":3,"id":"Ext-method-functionFactory","cls":"Ext"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext-method-get","cls":"Ext"},{"type":"member","member":"getBody","icon":"method","private":false,"sort":3,"id":"Ext-method-getBody","cls":"Ext"},{"type":"member","member":"getClass","icon":"method","private":false,"sort":3,"id":"Ext-method-getClass","cls":"Ext"},{"type":"member","member":"getClassName","icon":"method","private":false,"sort":3,"id":"Ext-method-getClassName","cls":"Ext"},{"type":"member","member":"getCmp","icon":"method","private":false,"sort":3,"id":"Ext-method-getCmp","cls":"Ext"},{"type":"member","member":"getDoc","icon":"method","private":false,"sort":3,"id":"Ext-method-getDoc","cls":"Ext"},{"type":"member","member":"getDom","icon":"method","private":false,"sort":3,"id":"Ext-method-getDom","cls":"Ext"},{"type":"member","member":"getHead","icon":"method","private":false,"sort":3,"id":"Ext-method-getHead","cls":"Ext"},{"type":"member","member":"getStore","icon":"method","private":false,"sort":3,"id":"Ext-method-getStore","cls":"Ext"},{"type":"member","member":"getUniqueGlobalNamespace","icon":"method","private":true,"sort":3,"id":"Ext-method-getUniqueGlobalNamespace","cls":"Ext"},{"type":"member","member":"htmlDecode","icon":"method","private":false,"sort":3,"id":"Ext-method-htmlDecode","cls":"Ext"},{"type":"member","member":"htmlEncode","icon":"method","private":false,"sort":3,"id":"Ext-method-htmlEncode","cls":"Ext"},{"type":"member","member":"id","icon":"method","private":false,"sort":3,"id":"Ext-method-id","cls":"Ext"},{"type":"member","member":"isArray","icon":"method","private":false,"sort":3,"id":"Ext-method-isArray","cls":"Ext"},{"type":"member","member":"isBoolean","icon":"method","private":false,"sort":3,"id":"Ext-method-isBoolean","cls":"Ext"},{"type":"member","member":"isDate","icon":"method","private":false,"sort":3,"id":"Ext-method-isDate","cls":"Ext"},{"type":"member","member":"isDefined","icon":"method","private":false,"sort":3,"id":"Ext-method-isDefined","cls":"Ext"},{"type":"member","member":"isElement","icon":"method","private":false,"sort":3,"id":"Ext-method-isElement","cls":"Ext"},{"type":"member","member":"isEmpty","icon":"method","private":false,"sort":3,"id":"Ext-method-isEmpty","cls":"Ext"},{"type":"member","member":"isFunction","icon":"method","private":false,"sort":3,"id":"Ext-method-isFunction","cls":"Ext"},{"type":"member","member":"isIterable","icon":"method","private":false,"sort":3,"id":"Ext-method-isIterable","cls":"Ext"},{"type":"member","member":"isNumber","icon":"method","private":false,"sort":3,"id":"Ext-method-isNumber","cls":"Ext"},{"type":"member","member":"isNumeric","icon":"method","private":false,"sort":3,"id":"Ext-method-isNumeric","cls":"Ext"},{"type":"member","member":"isObject","icon":"method","private":false,"sort":3,"id":"Ext-method-isObject","cls":"Ext"},{"type":"member","member":"isPrimitive","icon":"method","private":false,"sort":3,"id":"Ext-method-isPrimitive","cls":"Ext"},{"type":"member","member":"isSimpleObject","icon":"method","private":true,"sort":3,"id":"Ext-method-isSimpleObject","cls":"Ext"},{"type":"member","member":"isString","icon":"method","private":false,"sort":3,"id":"Ext-method-isString","cls":"Ext"},{"type":"member","member":"isTextNode","icon":"method","private":false,"sort":3,"id":"Ext-method-isTextNode","cls":"Ext"},{"type":"member","member":"iterate","icon":"method","private":false,"sort":3,"id":"Ext-method-iterate","cls":"Ext"},{"type":"member","member":"max","icon":"method","private":false,"sort":3,"id":"Ext-method-max","cls":"Ext"},{"type":"member","member":"mean","icon":"method","private":false,"sort":3,"id":"Ext-method-mean","cls":"Ext"},{"type":"member","member":"merge","icon":"method","private":false,"sort":3,"id":"Ext-method-merge","cls":"Ext"},{"type":"member","member":"min","icon":"method","private":false,"sort":3,"id":"Ext-method-min","cls":"Ext"},{"type":"member","member":"namespace","icon":"method","private":false,"sort":3,"id":"Ext-method-namespace","cls":"Ext"},{"type":"member","member":"ns","icon":"method","private":false,"sort":3,"id":"Ext-method-ns","cls":"Ext"},{"type":"member","member":"num","icon":"method","private":false,"sort":3,"id":"Ext-method-num","cls":"Ext"},{"type":"member","member":"onDocumentReady","icon":"method","private":true,"sort":3,"id":"Ext-method-onDocumentReady","cls":"Ext"},{"type":"member","member":"onReady","icon":"method","private":false,"sort":3,"id":"Ext-method-onReady","cls":"Ext"},{"type":"member","member":"onSetup","icon":"method","private":true,"sort":3,"id":"Ext-method-onSetup","cls":"Ext"},{"type":"member","member":"override","icon":"method","private":false,"sort":3,"id":"Ext-method-override","cls":"Ext"},{"type":"member","member":"pass","icon":"method","private":false,"sort":3,"id":"Ext-method-pass","cls":"Ext"},{"type":"member","member":"pluck","icon":"method","private":false,"sort":3,"id":"Ext-method-pluck","cls":"Ext"},{"type":"member","member":"regModel","icon":"method","private":false,"sort":3,"id":"Ext-method-regModel","cls":"Ext"},{"type":"member","member":"regStore","icon":"method","private":false,"sort":3,"id":"Ext-method-regStore","cls":"Ext"},{"type":"member","member":"removeNode","icon":"method","private":false,"sort":3,"id":"Ext-method-removeNode","cls":"Ext"},{"type":"member","member":"repaint","icon":"method","private":false,"sort":3,"id":"Ext-method-repaint","cls":"Ext"},{"type":"member","member":"require","icon":"method","private":false,"sort":3,"id":"Ext-method-require","cls":"Ext"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext-method-select","cls":"Ext"},{"type":"member","member":"setup","icon":"method","private":false,"sort":3,"id":"Ext-method-setup","cls":"Ext"},{"type":"member","member":"showLeaks","icon":"method","private":true,"sort":3,"id":"Ext-method-showLeaks","cls":"Ext"},{"type":"member","member":"sum","icon":"method","private":false,"sort":3,"id":"Ext-method-sum","cls":"Ext"},{"type":"member","member":"syncRequire","icon":"method","private":false,"sort":3,"id":"Ext-method-syncRequire","cls":"Ext"},{"type":"member","member":"toArray","icon":"method","private":false,"sort":3,"id":"Ext-method-toArray","cls":"Ext"},{"type":"member","member":"triggerReady","icon":"method","private":true,"sort":3,"id":"Ext-method-triggerReady","cls":"Ext"},{"type":"member","member":"type","icon":"method","private":false,"sort":3,"id":"Ext-method-type","cls":"Ext"},{"type":"member","member":"typeOf","icon":"method","private":false,"sort":3,"id":"Ext-method-typeOf","cls":"Ext"},{"type":"member","member":"unique","icon":"method","private":false,"sort":3,"id":"Ext-method-unique","cls":"Ext"},{"type":"member","member":"urlAppend","icon":"method","private":false,"sort":3,"id":"Ext-method-urlAppend","cls":"Ext"},{"type":"member","member":"urlDecode","icon":"method","private":false,"sort":3,"id":"Ext-method-urlDecode","cls":"Ext"},{"type":"member","member":"urlEncode","icon":"method","private":false,"sort":3,"id":"Ext-method-urlEncode","cls":"Ext"},{"type":"member","member":"valueFrom","icon":"method","private":false,"sort":3,"id":"Ext-method-valueFrom","cls":"Ext"},{"type":"member","member":"widget","icon":"method","private":false,"sort":3,"id":"Ext-method-widget","cls":"Ext"},{"type":"member","member":"Logger","icon":"property","private":true,"sort":3,"id":"Ext-property-Logger","cls":"Ext"},{"type":"member","member":"defaultSetupConfig","icon":"property","private":true,"sort":3,"id":"Ext-property-defaultSetupConfig","cls":"Ext"},{"type":"member","member":"emptyFn","icon":"property","private":false,"sort":3,"id":"Ext-property-emptyFn","cls":"Ext"},{"type":"member","member":"enumerables","icon":"property","private":false,"sort":3,"id":"Ext-property-enumerables","cls":"Ext"},{"type":"member","member":"globalEval","icon":"property","private":true,"sort":3,"id":"Ext-property-globalEval","cls":"Ext"},{"type":"member","member":"idSeed","icon":"property","private":true,"sort":3,"id":"Ext-property-idSeed","cls":"Ext"},{"type":"member","member":"isReady","icon":"property","private":false,"sort":3,"id":"Ext-property-isReady","cls":"Ext"},{"type":"member","member":"isSetup","icon":"property","private":true,"sort":3,"id":"Ext-property-isSetup","cls":"Ext"},{"type":"member","member":"readyListeners","icon":"property","private":true,"sort":3,"id":"Ext-property-readyListeners","cls":"Ext"},{"type":"member","member":"setupListeners","icon":"property","private":true,"sort":3,"id":"Ext-property-setupListeners","cls":"Ext"},{"type":"member","member":"version","icon":"property","private":false,"sort":3,"id":"Ext-property-version","cls":"Ext"},{"type":"class","member":"Version","icon":"class","private":false,"sort":1,"id":"Ext.Version","cls":"Ext.Version"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-constructor","cls":"Ext.Version"},{"type":"member","member":"deprecate","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-deprecate","cls":"Ext.Version"},{"type":"member","member":"equals","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-equals","cls":"Ext.Version"},{"type":"member","member":"getBuild","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getBuild","cls":"Ext.Version"},{"type":"member","member":"getMajor","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getMajor","cls":"Ext.Version"},{"type":"member","member":"getMinor","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getMinor","cls":"Ext.Version"},{"type":"member","member":"getPatch","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getPatch","cls":"Ext.Version"},{"type":"member","member":"getRelease","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getRelease","cls":"Ext.Version"},{"type":"member","member":"getShortVersion","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getShortVersion","cls":"Ext.Version"},{"type":"member","member":"getVersion","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-getVersion","cls":"Ext.Version"},{"type":"member","member":"gt","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-gt","cls":"Ext.Version"},{"type":"member","member":"gtEq","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-gtEq","cls":"Ext.Version"},{"type":"member","member":"isGreaterThan","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-isGreaterThan","cls":"Ext.Version"},{"type":"member","member":"isGreaterThanOrEqual","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-isGreaterThanOrEqual","cls":"Ext.Version"},{"type":"member","member":"isLessThan","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-isLessThan","cls":"Ext.Version"},{"type":"member","member":"isLessThanOrEqual","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-isLessThanOrEqual","cls":"Ext.Version"},{"type":"member","member":"lt","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-lt","cls":"Ext.Version"},{"type":"member","member":"ltEq","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-ltEq","cls":"Ext.Version"},{"type":"member","member":"match","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-match","cls":"Ext.Version"},{"type":"member","member":"setVersion","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-setVersion","cls":"Ext.Version"},{"type":"member","member":"toArray","icon":"method","private":false,"sort":3,"id":"Ext.Version-method-toArray","cls":"Ext.Version"},{"type":"member","member":"toString","icon":"method","private":true,"sort":3,"id":"Ext.Version-method-toString","cls":"Ext.Version"},{"type":"member","member":"valueOf","icon":"method","private":true,"sort":3,"id":"Ext.Version-method-valueOf","cls":"Ext.Version"},{"type":"member","member":"lastRegisteredVersion","icon":"property","private":true,"sort":3,"id":"Ext.Version-property-lastRegisteredVersion","cls":"Ext.Version"},{"type":"member","member":"versions","icon":"property","private":true,"sort":3,"id":"Ext.Version-property-versions","cls":"Ext.Version"},{"type":"member","member":"compare","icon":"method","private":false,"sort":3,"id":"Ext.Version-static-method-compare","cls":"Ext.Version"},{"type":"member","member":"getComponentValue","icon":"method","private":false,"sort":3,"id":"Ext.Version-static-method-getComponentValue","cls":"Ext.Version"},{"type":"class","member":"String","icon":"class","private":false,"sort":1,"id":"Ext.String","cls":"Ext.String"},{"type":"member","member":"capitalize","icon":"method","private":false,"sort":3,"id":"Ext.String-method-capitalize","cls":"Ext.String"},{"type":"member","member":"ellipsis","icon":"method","private":false,"sort":3,"id":"Ext.String-method-ellipsis","cls":"Ext.String"},{"type":"member","member":"escape","icon":"method","private":false,"sort":3,"id":"Ext.String-method-escape","cls":"Ext.String"},{"type":"member","member":"escapeRegex","icon":"method","private":false,"sort":3,"id":"Ext.String-method-escapeRegex","cls":"Ext.String"},{"type":"member","member":"format","icon":"method","private":false,"sort":3,"id":"Ext.String-method-format","cls":"Ext.String"},{"type":"member","member":"htmlDecode","icon":"method","private":false,"sort":3,"id":"Ext.String-method-htmlDecode","cls":"Ext.String"},{"type":"member","member":"htmlEncode","icon":"method","private":false,"sort":3,"id":"Ext.String-method-htmlEncode","cls":"Ext.String"},{"type":"member","member":"leftPad","icon":"method","private":false,"sort":3,"id":"Ext.String-method-leftPad","cls":"Ext.String"},{"type":"member","member":"repeat","icon":"method","private":false,"sort":3,"id":"Ext.String-method-repeat","cls":"Ext.String"},{"type":"member","member":"toggle","icon":"method","private":false,"sort":3,"id":"Ext.String-method-toggle","cls":"Ext.String"},{"type":"member","member":"trim","icon":"method","private":false,"sort":3,"id":"Ext.String-method-trim","cls":"Ext.String"},{"type":"member","member":"urlAppend","icon":"method","private":false,"sort":3,"id":"Ext.String-method-urlAppend","cls":"Ext.String"},{"type":"class","member":"Array","icon":"class","private":false,"sort":1,"id":"Ext.Array","cls":"Ext.Array"},{"type":"member","member":"clean","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-clean","cls":"Ext.Array"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-clone","cls":"Ext.Array"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-contains","cls":"Ext.Array"},{"type":"member","member":"difference","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-difference","cls":"Ext.Array"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-each","cls":"Ext.Array"},{"type":"member","member":"erase","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-erase","cls":"Ext.Array"},{"type":"member","member":"every","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-every","cls":"Ext.Array"},{"type":"member","member":"filter","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-filter","cls":"Ext.Array"},{"type":"member","member":"flatten","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-flatten","cls":"Ext.Array"},{"type":"member","member":"forEach","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-forEach","cls":"Ext.Array"},{"type":"member","member":"from","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-from","cls":"Ext.Array"},{"type":"member","member":"include","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-include","cls":"Ext.Array"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-indexOf","cls":"Ext.Array"},{"type":"member","member":"insert","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-insert","cls":"Ext.Array"},{"type":"member","member":"intersect","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-intersect","cls":"Ext.Array"},{"type":"member","member":"map","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-map","cls":"Ext.Array"},{"type":"member","member":"max","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-max","cls":"Ext.Array"},{"type":"member","member":"mean","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-mean","cls":"Ext.Array"},{"type":"member","member":"merge","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-merge","cls":"Ext.Array"},{"type":"member","member":"min","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-min","cls":"Ext.Array"},{"type":"member","member":"pluck","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-pluck","cls":"Ext.Array"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-remove","cls":"Ext.Array"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-replace","cls":"Ext.Array"},{"type":"member","member":"slice","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-slice","cls":"Ext.Array"},{"type":"member","member":"some","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-some","cls":"Ext.Array"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-sort","cls":"Ext.Array"},{"type":"member","member":"splice","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-splice","cls":"Ext.Array"},{"type":"member","member":"sum","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-sum","cls":"Ext.Array"},{"type":"member","member":"toArray","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-toArray","cls":"Ext.Array"},{"type":"member","member":"union","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-union","cls":"Ext.Array"},{"type":"member","member":"unique","icon":"method","private":false,"sort":3,"id":"Ext.Array-method-unique","cls":"Ext.Array"},{"type":"class","member":"Number","icon":"class","private":false,"sort":1,"id":"Ext.Number","cls":"Ext.Number"},{"type":"member","member":"constrain","icon":"method","private":false,"sort":3,"id":"Ext.Number-method-constrain","cls":"Ext.Number"},{"type":"member","member":"from","icon":"method","private":false,"sort":3,"id":"Ext.Number-method-from","cls":"Ext.Number"},{"type":"member","member":"snap","icon":"method","private":false,"sort":3,"id":"Ext.Number-method-snap","cls":"Ext.Number"},{"type":"member","member":"toFixed","icon":"method","private":false,"sort":3,"id":"Ext.Number-method-toFixed","cls":"Ext.Number"},{"type":"class","member":"Object","icon":"class","private":false,"sort":1,"id":"Ext.Object","cls":"Ext.Object"},{"type":"member","member":"chain","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-chain","cls":"Ext.Object"},{"type":"member","member":"classify","icon":"method","private":true,"sort":3,"id":"Ext.Object-method-classify","cls":"Ext.Object"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-each","cls":"Ext.Object"},{"type":"member","member":"fromQueryString","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-fromQueryString","cls":"Ext.Object"},{"type":"member","member":"getKey","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-getKey","cls":"Ext.Object"},{"type":"member","member":"getKeys","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-getKeys","cls":"Ext.Object"},{"type":"member","member":"getSize","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-getSize","cls":"Ext.Object"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-getValues","cls":"Ext.Object"},{"type":"member","member":"merge","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-merge","cls":"Ext.Object"},{"type":"member","member":"mergeIf","icon":"method","private":true,"sort":3,"id":"Ext.Object-method-mergeIf","cls":"Ext.Object"},{"type":"member","member":"toQueryObjects","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-toQueryObjects","cls":"Ext.Object"},{"type":"member","member":"toQueryString","icon":"method","private":false,"sort":3,"id":"Ext.Object-method-toQueryString","cls":"Ext.Object"},{"type":"member","member":"mergeIf","icon":"property","private":true,"sort":3,"id":"Ext.Object-property-mergeIf","cls":"Ext.Object"},{"type":"class","member":"Function","icon":"class","private":false,"sort":1,"id":"Ext.Function","cls":"Ext.Function"},{"type":"class","member":"Functions","icon":"subclass","private":false,"sort":2,"id":"Ext.Function","cls":"Ext.util.Functions"},{"type":"member","member":"alias","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-alias","cls":"Ext.Function"},{"type":"member","member":"bind","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-bind","cls":"Ext.Function"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-clone","cls":"Ext.Function"},{"type":"member","member":"createBuffered","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createBuffered","cls":"Ext.Function"},{"type":"member","member":"createDelayed","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createDelayed","cls":"Ext.Function"},{"type":"member","member":"createDelegate","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createDelegate","cls":"Ext.Function"},{"type":"member","member":"createInterceptor","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createInterceptor","cls":"Ext.Function"},{"type":"member","member":"createSequence","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createSequence","cls":"Ext.Function"},{"type":"member","member":"createThrottled","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-createThrottled","cls":"Ext.Function"},{"type":"member","member":"defer","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-defer","cls":"Ext.Function"},{"type":"member","member":"flexSetter","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-flexSetter","cls":"Ext.Function"},{"type":"member","member":"pass","icon":"method","private":false,"sort":3,"id":"Ext.Function-method-pass","cls":"Ext.Function"},{"type":"class","member":"JSON","icon":"class","private":false,"sort":1,"id":"Ext.JSON","cls":"Ext.JSON"},{"type":"member","member":"decode","icon":"method","private":false,"sort":3,"id":"Ext.JSON-method-decode","cls":"Ext.JSON"},{"type":"member","member":"encode","icon":"method","private":false,"sort":3,"id":"Ext.JSON-method-encode","cls":"Ext.JSON"},{"type":"member","member":"encodeDate","icon":"method","private":false,"sort":3,"id":"Ext.JSON-method-encodeDate","cls":"Ext.JSON"},{"type":"class","member":"Date","icon":"class","private":false,"sort":1,"id":"Ext.Date","cls":"Ext.Date"},{"type":"member","member":"toString","icon":"method","private":true,"sort":3,"id":"Ext.Date-method-toString","cls":"Ext.Date"},{"type":"class","member":"Base","icon":"class","private":true,"sort":1,"id":"Ext.Base","cls":"Ext.Base"},{"type":"member","member":"callOverridden","icon":"method","private":false,"sort":3,"id":"Ext.Base-method-callOverridden","cls":"Ext.Base"},{"type":"member","member":"callParent","icon":"method","private":false,"sort":3,"id":"Ext.Base-method-callParent","cls":"Ext.Base"},{"type":"member","member":"destroy","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-destroy","cls":"Ext.Base"},{"type":"member","member":"getConfig","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-getConfig","cls":"Ext.Base"},{"type":"member","member":"getCurrentConfig","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-getCurrentConfig","cls":"Ext.Base"},{"type":"member","member":"getInitialConfig","icon":"method","private":false,"sort":3,"id":"Ext.Base-method-getInitialConfig","cls":"Ext.Base"},{"type":"member","member":"hasConfig","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-hasConfig","cls":"Ext.Base"},{"type":"member","member":"initConfig","icon":"method","private":false,"sort":3,"id":"Ext.Base-method-initConfig","cls":"Ext.Base"},{"type":"member","member":"onConfigUpdate","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-onConfigUpdate","cls":"Ext.Base"},{"type":"member","member":"setConfig","icon":"method","private":true,"sort":3,"id":"Ext.Base-method-setConfig","cls":"Ext.Base"},{"type":"member","member":"statics","icon":"method","private":false,"sort":3,"id":"Ext.Base-method-statics","cls":"Ext.Base"},{"type":"member","member":"self","icon":"property","private":false,"sort":3,"id":"Ext.Base-property-self","cls":"Ext.Base"},{"type":"member","member":"addConfig","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-addConfig","cls":"Ext.Base"},{"type":"member","member":"addInheritableStatics","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-addInheritableStatics","cls":"Ext.Base"},{"type":"member","member":"addMember","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-addMember","cls":"Ext.Base"},{"type":"member","member":"addMembers","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-addMembers","cls":"Ext.Base"},{"type":"member","member":"addStatics","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-addStatics","cls":"Ext.Base"},{"type":"member","member":"addXtype","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-addXtype","cls":"Ext.Base"},{"type":"member","member":"borrow","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-borrow","cls":"Ext.Base"},{"type":"member","member":"callParent","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-callParent","cls":"Ext.Base"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-create","cls":"Ext.Base"},{"type":"member","member":"createAlias","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-createAlias","cls":"Ext.Base"},{"type":"member","member":"extend","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-extend","cls":"Ext.Base"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-getName","cls":"Ext.Base"},{"type":"member","member":"implement","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-implement","cls":"Ext.Base"},{"type":"member","member":"mixin","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-mixin","cls":"Ext.Base"},{"type":"member","member":"onExtended","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-onExtended","cls":"Ext.Base"},{"type":"member","member":"override","icon":"method","private":false,"sort":3,"id":"Ext.Base-static-method-override","cls":"Ext.Base"},{"type":"member","member":"triggerExtended","icon":"method","private":true,"sort":3,"id":"Ext.Base-static-method-triggerExtended","cls":"Ext.Base"},{"type":"member","member":"$onExtended","icon":"property","private":true,"sort":3,"id":"Ext.Base-static-property-S-onExtended","cls":"Ext.Base"},{"type":"class","member":"Class","icon":"class","private":true,"sort":1,"id":"Ext.Class","cls":"Ext.Class"},{"type":"member","member":"alias","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-alias","cls":"Ext.Class"},{"type":"member","member":"alternateClassName","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-alternateClassName","cls":"Ext.Class"},{"type":"member","member":"config","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-config","cls":"Ext.Class"},{"type":"member","member":"extend","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-extend","cls":"Ext.Class"},{"type":"member","member":"inheritableStatics","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-inheritableStatics","cls":"Ext.Class"},{"type":"member","member":"mixins","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-mixins","cls":"Ext.Class"},{"type":"member","member":"singleton","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-singleton","cls":"Ext.Class"},{"type":"member","member":"statics","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-statics","cls":"Ext.Class"},{"type":"member","member":"uses","icon":"cfg","private":false,"sort":3,"id":"Ext.Class-cfg-uses","cls":"Ext.Class"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.Class-method-constructor","cls":"Ext.Class"},{"type":"member","member":"create","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-create","cls":"Ext.Class"},{"type":"member","member":"generateGetter","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-generateGetter","cls":"Ext.Class"},{"type":"member","member":"generateInitGetter","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-generateInitGetter","cls":"Ext.Class"},{"type":"member","member":"generateSetter","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-generateSetter","cls":"Ext.Class"},{"type":"member","member":"getConfigNameMap","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-getConfigNameMap","cls":"Ext.Class"},{"type":"member","member":"getDefaultPreprocessors","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-getDefaultPreprocessors","cls":"Ext.Class"},{"type":"member","member":"getPreprocessor","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-getPreprocessor","cls":"Ext.Class"},{"type":"member","member":"getPreprocessors","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-getPreprocessors","cls":"Ext.Class"},{"type":"member","member":"onBeforeCreated","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-onBeforeCreated","cls":"Ext.Class"},{"type":"member","member":"process","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-process","cls":"Ext.Class"},{"type":"member","member":"registerPreprocessor","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-registerPreprocessor","cls":"Ext.Class"},{"type":"member","member":"setDefaultPreprocessorPosition","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-setDefaultPreprocessorPosition","cls":"Ext.Class"},{"type":"member","member":"setDefaultPreprocessors","icon":"method","private":true,"sort":3,"id":"Ext.Class-static-method-setDefaultPreprocessors","cls":"Ext.Class"},{"type":"member","member":"configNameCache","icon":"property","private":true,"sort":3,"id":"Ext.Class-static-property-configNameCache","cls":"Ext.Class"},{"type":"member","member":"defaultPreprocessors","icon":"property","private":true,"sort":3,"id":"Ext.Class-static-property-defaultPreprocessors","cls":"Ext.Class"},{"type":"member","member":"preprocessors","icon":"property","private":true,"sort":3,"id":"Ext.Class-static-property-preprocessors","cls":"Ext.Class"},{"type":"class","member":"ClassManager","icon":"class","private":false,"sort":1,"id":"Ext.ClassManager","cls":"Ext.ClassManager"},{"type":"member","member":"applyOverrides","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-applyOverrides","cls":"Ext.ClassManager"},{"type":"member","member":"create","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-create","cls":"Ext.ClassManager"},{"type":"member","member":"createNamespaces","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-createNamespaces","cls":"Ext.ClassManager"},{"type":"member","member":"dynInstantiate","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-dynInstantiate","cls":"Ext.ClassManager"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-get","cls":"Ext.ClassManager"},{"type":"member","member":"getAliasesByName","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getAliasesByName","cls":"Ext.ClassManager"},{"type":"member","member":"getByAlias","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getByAlias","cls":"Ext.ClassManager"},{"type":"member","member":"getClass","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getClass","cls":"Ext.ClassManager"},{"type":"member","member":"getDisplayName","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getDisplayName","cls":"Ext.ClassManager"},{"type":"member","member":"getInstantiator","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-getInstantiator","cls":"Ext.ClassManager"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getName","cls":"Ext.ClassManager"},{"type":"member","member":"getNameByAlias","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getNameByAlias","cls":"Ext.ClassManager"},{"type":"member","member":"getNameByAlternate","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getNameByAlternate","cls":"Ext.ClassManager"},{"type":"member","member":"getNamesByExpression","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-getNamesByExpression","cls":"Ext.ClassManager"},{"type":"member","member":"instantiate","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-instantiate","cls":"Ext.ClassManager"},{"type":"member","member":"instantiateByAlias","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-instantiateByAlias","cls":"Ext.ClassManager"},{"type":"member","member":"isCreated","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-isCreated","cls":"Ext.ClassManager"},{"type":"member","member":"onCreated","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-onCreated","cls":"Ext.ClassManager"},{"type":"member","member":"parseNamespace","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-parseNamespace","cls":"Ext.ClassManager"},{"type":"member","member":"registerPostprocessor","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-registerPostprocessor","cls":"Ext.ClassManager"},{"type":"member","member":"set","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-set","cls":"Ext.ClassManager"},{"type":"member","member":"setAlias","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-setAlias","cls":"Ext.ClassManager"},{"type":"member","member":"setDefaultPostprocessorPosition","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-setDefaultPostprocessorPosition","cls":"Ext.ClassManager"},{"type":"member","member":"setDefaultPostprocessors","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-setDefaultPostprocessors","cls":"Ext.ClassManager"},{"type":"member","member":"setNamespace","icon":"method","private":false,"sort":3,"id":"Ext.ClassManager-method-setNamespace","cls":"Ext.ClassManager"},{"type":"member","member":"triggerCreated","icon":"method","private":true,"sort":3,"id":"Ext.ClassManager-method-triggerCreated","cls":"Ext.ClassManager"},{"type":"member","member":"classes","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-classes","cls":"Ext.ClassManager"},{"type":"member","member":"createdListeners","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-createdListeners","cls":"Ext.ClassManager"},{"type":"member","member":"defaultPostprocessors","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-defaultPostprocessors","cls":"Ext.ClassManager"},{"type":"member","member":"enableNamespaceParseCache","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-enableNamespaceParseCache","cls":"Ext.ClassManager"},{"type":"member","member":"existCache","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-existCache","cls":"Ext.ClassManager"},{"type":"member","member":"instantiators","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-instantiators","cls":"Ext.ClassManager"},{"type":"member","member":"maps","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-maps","cls":"Ext.ClassManager"},{"type":"member","member":"nameCreatedListeners","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-nameCreatedListeners","cls":"Ext.ClassManager"},{"type":"member","member":"namespaceParseCache","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-namespaceParseCache","cls":"Ext.ClassManager"},{"type":"member","member":"namespaceRewrites","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-namespaceRewrites","cls":"Ext.ClassManager"},{"type":"member","member":"postprocessors","icon":"property","private":true,"sort":3,"id":"Ext.ClassManager-property-postprocessors","cls":"Ext.ClassManager"},{"type":"class","member":"Loader","icon":"class","private":false,"sort":1,"id":"Ext.Loader","cls":"Ext.Loader"},{"type":"member","member":"disableCaching","icon":"cfg","private":false,"sort":3,"id":"Ext.Loader-cfg-disableCaching","cls":"Ext.Loader"},{"type":"member","member":"disableCachingParam","icon":"cfg","private":false,"sort":3,"id":"Ext.Loader-cfg-disableCachingParam","cls":"Ext.Loader"},{"type":"member","member":"enabled","icon":"cfg","private":false,"sort":3,"id":"Ext.Loader-cfg-enabled","cls":"Ext.Loader"},{"type":"member","member":"paths","icon":"cfg","private":false,"sort":3,"id":"Ext.Loader-cfg-paths","cls":"Ext.Loader"},{"type":"member","member":"addOptionalRequires","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-addOptionalRequires","cls":"Ext.Loader"},{"type":"member","member":"cleanupScriptElement","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-cleanupScriptElement","cls":"Ext.Loader"},{"type":"member","member":"exclude","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-exclude","cls":"Ext.Loader"},{"type":"member","member":"getConfig","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-getConfig","cls":"Ext.Loader"},{"type":"member","member":"getPath","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-getPath","cls":"Ext.Loader"},{"type":"member","member":"getPrefix","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-getPrefix","cls":"Ext.Loader"},{"type":"member","member":"historyPush","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-historyPush","cls":"Ext.Loader"},{"type":"member","member":"injectScriptElement","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-injectScriptElement","cls":"Ext.Loader"},{"type":"member","member":"loadScriptFile","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-loadScriptFile","cls":"Ext.Loader"},{"type":"member","member":"onFileLoadError","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-onFileLoadError","cls":"Ext.Loader"},{"type":"member","member":"onFileLoaded","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-onFileLoaded","cls":"Ext.Loader"},{"type":"member","member":"onReady","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-onReady","cls":"Ext.Loader"},{"type":"member","member":"refreshQueue","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-refreshQueue","cls":"Ext.Loader"},{"type":"member","member":"require","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-require","cls":"Ext.Loader"},{"type":"member","member":"setConfig","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-setConfig","cls":"Ext.Loader"},{"type":"member","member":"setPath","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-setPath","cls":"Ext.Loader"},{"type":"member","member":"syncRequire","icon":"method","private":false,"sort":3,"id":"Ext.Loader-method-syncRequire","cls":"Ext.Loader"},{"type":"member","member":"triggerReady","icon":"method","private":true,"sort":3,"id":"Ext.Loader-method-triggerReady","cls":"Ext.Loader"},{"type":"member","member":"classNameToFilePathMap","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-classNameToFilePathMap","cls":"Ext.Loader"},{"type":"member","member":"config","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-config","cls":"Ext.Loader"},{"type":"member","member":"documentHead","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-documentHead","cls":"Ext.Loader"},{"type":"member","member":"hasFileLoadError","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-hasFileLoadError","cls":"Ext.Loader"},{"type":"member","member":"history","icon":"property","private":false,"sort":3,"id":"Ext.Loader-property-history","cls":"Ext.Loader"},{"type":"member","member":"isClassFileLoaded","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-isClassFileLoaded","cls":"Ext.Loader"},{"type":"member","member":"isFileLoaded","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-isFileLoaded","cls":"Ext.Loader"},{"type":"member","member":"isInHistory","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-isInHistory","cls":"Ext.Loader"},{"type":"member","member":"isLoading","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-isLoading","cls":"Ext.Loader"},{"type":"member","member":"numLoadedFiles","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-numLoadedFiles","cls":"Ext.Loader"},{"type":"member","member":"numPendingFiles","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-numPendingFiles","cls":"Ext.Loader"},{"type":"member","member":"optionalRequires","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-optionalRequires","cls":"Ext.Loader"},{"type":"member","member":"queue","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-queue","cls":"Ext.Loader"},{"type":"member","member":"readyListeners","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-readyListeners","cls":"Ext.Loader"},{"type":"member","member":"requiresMap","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-requiresMap","cls":"Ext.Loader"},{"type":"member","member":"syncModeEnabled","icon":"property","private":true,"sort":3,"id":"Ext.Loader-property-syncModeEnabled","cls":"Ext.Loader"},{"type":"class","member":"EventManager","icon":"class","private":true,"sort":1,"id":"Ext.EventManager","cls":"Ext.EventManager"},{"type":"member","member":"addListener","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-addListener","cls":"Ext.EventManager"},{"type":"member","member":"on","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-on","cls":"Ext.EventManager"},{"type":"member","member":"onWindowResize","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-onWindowResize","cls":"Ext.EventManager"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-removeAll","cls":"Ext.EventManager"},{"type":"member","member":"removeListener","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-removeListener","cls":"Ext.EventManager"},{"type":"member","member":"un","icon":"method","private":false,"sort":3,"id":"Ext.EventManager-method-un","cls":"Ext.EventManager"},{"type":"class","member":"Browser","icon":"class","private":false,"sort":1,"id":"Ext.env.Browser","cls":"Ext.env.Browser"},{"type":"member","member":"is","icon":"method","private":false,"sort":3,"id":"Ext.env.Browser-method-is","cls":"Ext.env.Browser"},{"type":"member","member":"engineName","icon":"property","private":false,"sort":3,"id":"Ext.env.Browser-property-engineName","cls":"Ext.env.Browser"},{"type":"member","member":"engineVersion","icon":"property","private":false,"sort":3,"id":"Ext.env.Browser-property-engineVersion","cls":"Ext.env.Browser"},{"type":"member","member":"name","icon":"property","private":false,"sort":3,"id":"Ext.env.Browser-property-name","cls":"Ext.env.Browser"},{"type":"member","member":"version","icon":"property","private":false,"sort":3,"id":"Ext.env.Browser-property-version","cls":"Ext.env.Browser"},{"type":"class","member":"OS","icon":"class","private":false,"sort":1,"id":"Ext.env.OS","cls":"Ext.env.OS"},{"type":"member","member":"is","icon":"method","private":false,"sort":3,"id":"Ext.env.OS-method-is","cls":"Ext.env.OS"},{"type":"member","member":"name","icon":"property","private":false,"sort":3,"id":"Ext.env.OS-property-name","cls":"Ext.env.OS"},{"type":"member","member":"version","icon":"property","private":false,"sort":3,"id":"Ext.env.OS-property-version","cls":"Ext.env.OS"},{"type":"class","member":"is","icon":"class","private":true,"sort":1,"id":"Ext.is","cls":"Ext.is"},{"type":"class","member":"Feature","icon":"class","private":false,"sort":1,"id":"Ext.env.Feature","cls":"Ext.env.Feature"},{"type":"class","member":"has","icon":"class","private":false,"sort":1,"id":"Ext.feature.has","cls":"Ext.feature.has"},{"type":"member","member":"Audio","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Audio","cls":"Ext.feature.has"},{"type":"member","member":"Canvas","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Canvas","cls":"Ext.feature.has"},{"type":"member","member":"ClassList","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-ClassList","cls":"Ext.feature.has"},{"type":"member","member":"Css3dTransforms","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Css3dTransforms","cls":"Ext.feature.has"},{"type":"member","member":"CssAnimations","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-CssAnimations","cls":"Ext.feature.has"},{"type":"member","member":"CssTransforms","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-CssTransforms","cls":"Ext.feature.has"},{"type":"member","member":"CssTransitions","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-CssTransitions","cls":"Ext.feature.has"},{"type":"member","member":"DeviceMotion","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-DeviceMotion","cls":"Ext.feature.has"},{"type":"member","member":"Geolocation","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Geolocation","cls":"Ext.feature.has"},{"type":"member","member":"History","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-History","cls":"Ext.feature.has"},{"type":"member","member":"Orientation","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Orientation","cls":"Ext.feature.has"},{"type":"member","member":"OrientationChange","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-OrientationChange","cls":"Ext.feature.has"},{"type":"member","member":"SqlDatabase","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-SqlDatabase","cls":"Ext.feature.has"},{"type":"member","member":"Svg","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Svg","cls":"Ext.feature.has"},{"type":"member","member":"Touch","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Touch","cls":"Ext.feature.has"},{"type":"member","member":"Video","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Video","cls":"Ext.feature.has"},{"type":"member","member":"Vml","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-Vml","cls":"Ext.feature.has"},{"type":"member","member":"WebSockets","icon":"property","private":false,"sort":3,"id":"Ext.feature.has-property-WebSockets","cls":"Ext.feature.has"},{"type":"class","member":"supports","icon":"class","private":false,"sort":1,"id":"Ext.supports","cls":"Ext.supports"},{"type":"member","member":"AudioTag","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-AudioTag","cls":"Ext.supports"},{"type":"member","member":"ClassList","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-ClassList","cls":"Ext.supports"},{"type":"member","member":"GeoLocation","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-GeoLocation","cls":"Ext.supports"},{"type":"member","member":"SVG","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-SVG","cls":"Ext.supports"},{"type":"member","member":"Transitions","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-Transitions","cls":"Ext.supports"},{"type":"member","member":"VML","icon":"property","private":false,"sort":3,"id":"Ext.supports-property-VML","cls":"Ext.supports"},{"type":"class","member":"DomQuery","icon":"class","private":false,"sort":1,"id":"Ext.DomQuery","cls":"Ext.DomQuery"},{"type":"member","member":"is","icon":"method","private":false,"sort":3,"id":"Ext.DomQuery-method-is","cls":"Ext.DomQuery"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext.DomQuery-method-select","cls":"Ext.DomQuery"},{"type":"member","member":"selectNode","icon":"method","private":false,"sort":3,"id":"Ext.DomQuery-method-selectNode","cls":"Ext.DomQuery"},{"type":"class","member":"DomHelper","icon":"class","private":false,"sort":1,"id":"Ext.DomHelper","cls":"Ext.DomHelper"},{"type":"member","member":"append","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-append","cls":"Ext.DomHelper"},{"type":"member","member":"applyStyles","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-applyStyles","cls":"Ext.DomHelper"},{"type":"member","member":"generateStyles","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-generateStyles","cls":"Ext.DomHelper"},{"type":"member","member":"insertAfter","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-insertAfter","cls":"Ext.DomHelper"},{"type":"member","member":"insertBefore","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-insertBefore","cls":"Ext.DomHelper"},{"type":"member","member":"insertFirst","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-insertFirst","cls":"Ext.DomHelper"},{"type":"member","member":"insertHtml","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-insertHtml","cls":"Ext.DomHelper"},{"type":"member","member":"markup","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-markup","cls":"Ext.DomHelper"},{"type":"member","member":"overwrite","icon":"method","private":false,"sort":3,"id":"Ext.DomHelper-method-overwrite","cls":"Ext.DomHelper"},{"type":"class","member":"Element","icon":"class","private":false,"sort":1,"id":"Ext.dom.Element","cls":"Ext.dom.Element"},{"type":"class","member":"Element","icon":"subclass","private":false,"sort":2,"id":"Ext.dom.Element","cls":"Ext.Element"},{"type":"class","member":"element","icon":"subclass","private":false,"sort":0,"id":"Ext.dom.Element","cls":"xtype: element"},{"type":"member","member":"addCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-addCls","cls":"Ext.dom.Element"},{"type":"member","member":"appendChild","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-appendChild","cls":"Ext.dom.Element"},{"type":"member","member":"appendTo","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-appendTo","cls":"Ext.dom.Element"},{"type":"member","member":"applyStyles","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-applyStyles","cls":"Ext.dom.Element"},{"type":"member","member":"child","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-child","cls":"Ext.dom.Element"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-contains","cls":"Ext.dom.Element"},{"type":"member","member":"createChild","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-createChild","cls":"Ext.dom.Element"},{"type":"member","member":"down","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-down","cls":"Ext.dom.Element"},{"type":"member","member":"findParent","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-findParent","cls":"Ext.dom.Element"},{"type":"member","member":"findParentNode","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-findParentNode","cls":"Ext.dom.Element"},{"type":"member","member":"first","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-first","cls":"Ext.dom.Element"},{"type":"member","member":"getAlignToXY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getAlignToXY","cls":"Ext.dom.Element"},{"type":"member","member":"getAnchorXY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getAnchorXY","cls":"Ext.dom.Element"},{"type":"member","member":"getAttribute","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getAttribute","cls":"Ext.dom.Element"},{"type":"member","member":"getBorderWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getBorderWidth","cls":"Ext.dom.Element"},{"type":"member","member":"getBottom","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getBottom","cls":"Ext.dom.Element"},{"type":"member","member":"getBox","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getBox","cls":"Ext.dom.Element"},{"type":"member","member":"getHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getHeight","cls":"Ext.dom.Element"},{"type":"member","member":"getLeft","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getLeft","cls":"Ext.dom.Element"},{"type":"member","member":"getMargin","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getMargin","cls":"Ext.dom.Element"},{"type":"member","member":"getOffsetsTo","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getOffsetsTo","cls":"Ext.dom.Element"},{"type":"member","member":"getPadding","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getPadding","cls":"Ext.dom.Element"},{"type":"member","member":"getPageBox","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getPageBox","cls":"Ext.dom.Element"},{"type":"member","member":"getRight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getRight","cls":"Ext.dom.Element"},{"type":"member","member":"getSize","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getSize","cls":"Ext.dom.Element"},{"type":"member","member":"getStyle","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getStyle","cls":"Ext.dom.Element"},{"type":"member","member":"getTop","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getTop","cls":"Ext.dom.Element"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getValue","cls":"Ext.dom.Element"},{"type":"member","member":"getViewSize","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getViewSize","cls":"Ext.dom.Element"},{"type":"member","member":"getWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getWidth","cls":"Ext.dom.Element"},{"type":"member","member":"getX","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getX","cls":"Ext.dom.Element"},{"type":"member","member":"getXY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getXY","cls":"Ext.dom.Element"},{"type":"member","member":"getY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-getY","cls":"Ext.dom.Element"},{"type":"member","member":"hasCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-hasCls","cls":"Ext.dom.Element"},{"type":"member","member":"insertAfter","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-insertAfter","cls":"Ext.dom.Element"},{"type":"member","member":"insertBefore","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-insertBefore","cls":"Ext.dom.Element"},{"type":"member","member":"insertFirst","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-insertFirst","cls":"Ext.dom.Element"},{"type":"member","member":"insertHtml","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-insertHtml","cls":"Ext.dom.Element"},{"type":"member","member":"insertSibling","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-insertSibling","cls":"Ext.dom.Element"},{"type":"member","member":"is","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-is","cls":"Ext.dom.Element"},{"type":"member","member":"isStyle","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-isStyle","cls":"Ext.dom.Element"},{"type":"member","member":"isTransparent","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-isTransparent","cls":"Ext.dom.Element"},{"type":"member","member":"last","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-last","cls":"Ext.dom.Element"},{"type":"member","member":"next","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-next","cls":"Ext.dom.Element"},{"type":"member","member":"parent","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-parent","cls":"Ext.dom.Element"},{"type":"member","member":"prev","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-prev","cls":"Ext.dom.Element"},{"type":"member","member":"query","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-query","cls":"Ext.dom.Element"},{"type":"member","member":"radioCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-radioCls","cls":"Ext.dom.Element"},{"type":"member","member":"removeCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-removeCls","cls":"Ext.dom.Element"},{"type":"member","member":"repaint","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-repaint","cls":"Ext.dom.Element"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-replace","cls":"Ext.dom.Element"},{"type":"member","member":"replaceCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-replaceCls","cls":"Ext.dom.Element"},{"type":"member","member":"replaceWith","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-replaceWith","cls":"Ext.dom.Element"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-select","cls":"Ext.dom.Element"},{"type":"member","member":"serializeForm","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-serializeForm","cls":"Ext.dom.Element"},{"type":"member","member":"set","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-set","cls":"Ext.dom.Element"},{"type":"member","member":"setBottom","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setBottom","cls":"Ext.dom.Element"},{"type":"member","member":"setBox","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setBox","cls":"Ext.dom.Element"},{"type":"member","member":"setHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setHeight","cls":"Ext.dom.Element"},{"type":"member","member":"setLeft","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setLeft","cls":"Ext.dom.Element"},{"type":"member","member":"setMaxHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setMaxHeight","cls":"Ext.dom.Element"},{"type":"member","member":"setMaxWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setMaxWidth","cls":"Ext.dom.Element"},{"type":"member","member":"setMinHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setMinHeight","cls":"Ext.dom.Element"},{"type":"member","member":"setMinWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setMinWidth","cls":"Ext.dom.Element"},{"type":"member","member":"setRight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setRight","cls":"Ext.dom.Element"},{"type":"member","member":"setSize","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setSize","cls":"Ext.dom.Element"},{"type":"member","member":"setStyle","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setStyle","cls":"Ext.dom.Element"},{"type":"member","member":"setTop","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setTop","cls":"Ext.dom.Element"},{"type":"member","member":"setVisibilityMode","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setVisibilityMode","cls":"Ext.dom.Element"},{"type":"member","member":"setVisible","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setVisible","cls":"Ext.dom.Element"},{"type":"member","member":"setWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setWidth","cls":"Ext.dom.Element"},{"type":"member","member":"setX","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setX","cls":"Ext.dom.Element"},{"type":"member","member":"setXY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setXY","cls":"Ext.dom.Element"},{"type":"member","member":"setY","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-setY","cls":"Ext.dom.Element"},{"type":"member","member":"synchronize","icon":"method","private":true,"sort":3,"id":"Ext.dom.Element-method-synchronize","cls":"Ext.dom.Element"},{"type":"member","member":"toggleCls","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-toggleCls","cls":"Ext.dom.Element"},{"type":"member","member":"translatePoints","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-translatePoints","cls":"Ext.dom.Element"},{"type":"member","member":"up","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-up","cls":"Ext.dom.Element"},{"type":"member","member":"wrap","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-method-wrap","cls":"Ext.dom.Element"},{"type":"member","member":"doubletap","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-doubletap","cls":"Ext.dom.Element"},{"type":"member","member":"drag","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-drag","cls":"Ext.dom.Element"},{"type":"member","member":"dragend","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-dragend","cls":"Ext.dom.Element"},{"type":"member","member":"dragstart","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-dragstart","cls":"Ext.dom.Element"},{"type":"member","member":"longpress","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-longpress","cls":"Ext.dom.Element"},{"type":"member","member":"pinch","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-pinch","cls":"Ext.dom.Element"},{"type":"member","member":"pinchend","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-pinchend","cls":"Ext.dom.Element"},{"type":"member","member":"pinchstart","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-pinchstart","cls":"Ext.dom.Element"},{"type":"member","member":"rotate","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-rotate","cls":"Ext.dom.Element"},{"type":"member","member":"rotateend","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-rotateend","cls":"Ext.dom.Element"},{"type":"member","member":"rotatestart","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-rotatestart","cls":"Ext.dom.Element"},{"type":"member","member":"singletap","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-singletap","cls":"Ext.dom.Element"},{"type":"member","member":"swipe","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-swipe","cls":"Ext.dom.Element"},{"type":"member","member":"tap","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-tap","cls":"Ext.dom.Element"},{"type":"member","member":"tapcancel","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-tapcancel","cls":"Ext.dom.Element"},{"type":"member","member":"taphold","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-taphold","cls":"Ext.dom.Element"},{"type":"member","member":"tapstart","icon":"event","private":false,"sort":3,"id":"Ext.dom.Element-event-tapstart","cls":"Ext.dom.Element"},{"type":"member","member":"DISPLAY","icon":"property","private":false,"sort":3,"id":"Ext.dom.Element-property-DISPLAY","cls":"Ext.dom.Element"},{"type":"member","member":"OFFSETS","icon":"property","private":false,"sort":3,"id":"Ext.dom.Element-property-OFFSETS","cls":"Ext.dom.Element"},{"type":"member","member":"VISIBILITY","icon":"property","private":false,"sort":3,"id":"Ext.dom.Element-property-VISIBILITY","cls":"Ext.dom.Element"},{"type":"member","member":"defaultUnit","icon":"property","private":false,"sort":3,"id":"Ext.dom.Element-property-defaultUnit","cls":"Ext.dom.Element"},{"type":"member","member":"styleHooks","icon":"property","private":true,"sort":3,"id":"Ext.dom.Element-property-styleHooks","cls":"Ext.dom.Element"},{"type":"member","member":"addUnits","icon":"method","private":true,"sort":3,"id":"Ext.dom.Element-static-method-addUnits","cls":"Ext.dom.Element"},{"type":"member","member":"fly","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-fly","cls":"Ext.dom.Element"},{"type":"member","member":"fromPoint","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-fromPoint","cls":"Ext.dom.Element"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-get","cls":"Ext.dom.Element"},{"type":"member","member":"getDocumentHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getDocumentHeight","cls":"Ext.dom.Element"},{"type":"member","member":"getDocumentWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getDocumentWidth","cls":"Ext.dom.Element"},{"type":"member","member":"getOrientation","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getOrientation","cls":"Ext.dom.Element"},{"type":"member","member":"getViewSize","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getViewSize","cls":"Ext.dom.Element"},{"type":"member","member":"getViewportHeight","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getViewportHeight","cls":"Ext.dom.Element"},{"type":"member","member":"getViewportWidth","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-getViewportWidth","cls":"Ext.dom.Element"},{"type":"member","member":"isAncestor","icon":"method","private":true,"sort":3,"id":"Ext.dom.Element-static-method-isAncestor","cls":"Ext.dom.Element"},{"type":"member","member":"normalize","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-normalize","cls":"Ext.dom.Element"},{"type":"member","member":"parseBox","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-parseBox","cls":"Ext.dom.Element"},{"type":"member","member":"parseStyles","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-parseStyles","cls":"Ext.dom.Element"},{"type":"member","member":"unitizeBox","icon":"method","private":false,"sort":3,"id":"Ext.dom.Element-static-method-unitizeBox","cls":"Ext.dom.Element"},{"type":"class","member":"CompositeElementLite","icon":"class","private":false,"sort":1,"id":"Ext.dom.CompositeElementLite","cls":"Ext.dom.CompositeElementLite"},{"type":"class","member":"CompositeElementLite","icon":"subclass","private":false,"sort":2,"id":"Ext.dom.CompositeElementLite","cls":"Ext.CompositeElementLite"},{"type":"class","member":"CompositeElement","icon":"subclass","private":false,"sort":2,"id":"Ext.dom.CompositeElementLite","cls":"Ext.CompositeElement"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-add","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-clear","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-contains","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-each","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"fill","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-fill","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"filter","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-filter","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"first","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-first","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-getCount","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-indexOf","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"item","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-item","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"last","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-last","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"removeElement","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-removeElement","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"replaceElement","icon":"method","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-method-replaceElement","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"elements","icon":"property","private":false,"sort":3,"id":"Ext.dom.CompositeElementLite-property-elements","cls":"Ext.dom.CompositeElementLite"},{"type":"member","member":"importElementMethods","icon":"method","private":true,"sort":3,"id":"Ext.dom.CompositeElementLite-static-method-importElementMethods","cls":"Ext.dom.CompositeElementLite"},{"type":"class","member":"ComponentManager","icon":"class","private":true,"sort":1,"id":"Ext.ComponentManager","cls":"Ext.ComponentManager"},{"type":"class","member":"ComponentMgr","icon":"subclass","private":true,"sort":2,"id":"Ext.ComponentManager","cls":"Ext.ComponentMgr"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.ComponentManager-method-create","cls":"Ext.ComponentManager"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.ComponentManager-method-get","cls":"Ext.ComponentManager"},{"type":"member","member":"isRegistered","icon":"method","private":false,"sort":3,"id":"Ext.ComponentManager-method-isRegistered","cls":"Ext.ComponentManager"},{"type":"member","member":"register","icon":"method","private":false,"sort":3,"id":"Ext.ComponentManager-method-register","cls":"Ext.ComponentManager"},{"type":"member","member":"unregister","icon":"method","private":false,"sort":3,"id":"Ext.ComponentManager-method-unregister","cls":"Ext.ComponentManager"},{"type":"class","member":"ComponentQuery","icon":"class","private":false,"sort":1,"id":"Ext.ComponentQuery","cls":"Ext.ComponentQuery"},{"type":"member","member":"execute","icon":"method","private":true,"sort":3,"id":"Ext.ComponentQuery-method-execute","cls":"Ext.ComponentQuery"},{"type":"member","member":"is","icon":"method","private":false,"sort":3,"id":"Ext.ComponentQuery-method-is","cls":"Ext.ComponentQuery"},{"type":"member","member":"query","icon":"method","private":false,"sort":3,"id":"Ext.ComponentQuery-method-query","cls":"Ext.ComponentQuery"},{"type":"class","member":"XTemplateParser","icon":"class","private":true,"sort":1,"id":"Ext.XTemplateParser","cls":"Ext.XTemplateParser"},{"type":"member","member":"doCase","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doCase","cls":"Ext.XTemplateParser"},{"type":"member","member":"doDefault","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doDefault","cls":"Ext.XTemplateParser"},{"type":"member","member":"doElse","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doElse","cls":"Ext.XTemplateParser"},{"type":"member","member":"doElseIf","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doElseIf","cls":"Ext.XTemplateParser"},{"type":"member","member":"doEnd","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doEnd","cls":"Ext.XTemplateParser"},{"type":"member","member":"doEval","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doEval","cls":"Ext.XTemplateParser"},{"type":"member","member":"doExec","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doExec","cls":"Ext.XTemplateParser"},{"type":"member","member":"doExpr","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doExpr","cls":"Ext.XTemplateParser"},{"type":"member","member":"doFor","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doFor","cls":"Ext.XTemplateParser"},{"type":"member","member":"doIf","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doIf","cls":"Ext.XTemplateParser"},{"type":"member","member":"doSwitch","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doSwitch","cls":"Ext.XTemplateParser"},{"type":"member","member":"doTag","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doTag","cls":"Ext.XTemplateParser"},{"type":"member","member":"doText","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doText","cls":"Ext.XTemplateParser"},{"type":"member","member":"doTpl","icon":"method","private":false,"sort":3,"id":"Ext.XTemplateParser-method-doTpl","cls":"Ext.XTemplateParser"},{"type":"member","member":"level","icon":"property","private":false,"sort":3,"id":"Ext.XTemplateParser-property-level","cls":"Ext.XTemplateParser"},{"type":"class","member":"Action","icon":"class","private":true,"sort":1,"id":"Ext.app.Action","cls":"Ext.app.Action"},{"type":"member","member":"action","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-action","cls":"Ext.app.Action"},{"type":"member","member":"application","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-application","cls":"Ext.app.Action"},{"type":"member","member":"args","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-args","cls":"Ext.app.Action"},{"type":"member","member":"beforeFilters","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-beforeFilters","cls":"Ext.app.Action"},{"type":"member","member":"controller","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-controller","cls":"Ext.app.Action"},{"type":"member","member":"scope","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-scope","cls":"Ext.app.Action"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Action-cfg-url","cls":"Ext.app.Action"},{"type":"member","member":"applyController","icon":"method","private":true,"sort":3,"id":"Ext.app.Action-method-applyController","cls":"Ext.app.Action"},{"type":"member","member":"applyUrl","icon":"method","private":true,"sort":3,"id":"Ext.app.Action-method-applyUrl","cls":"Ext.app.Action"},{"type":"member","member":"execute","icon":"method","private":false,"sort":3,"id":"Ext.app.Action-method-execute","cls":"Ext.app.Action"},{"type":"member","member":"getBeforeFilters","icon":"method","private":false,"sort":3,"id":"Ext.app.Action-method-getBeforeFilters","cls":"Ext.app.Action"},{"type":"member","member":"resume","icon":"method","private":false,"sort":3,"id":"Ext.app.Action-method-resume","cls":"Ext.app.Action"},{"type":"member","member":"setBeforeFilters","icon":"method","private":false,"sort":3,"id":"Ext.app.Action-method-setBeforeFilters","cls":"Ext.app.Action"},{"type":"member","member":"urlEncode","icon":"method","private":true,"sort":3,"id":"Ext.app.Action-method-urlEncode","cls":"Ext.app.Action"},{"type":"member","member":"currentFilterIndex","icon":"property","private":true,"sort":3,"id":"Ext.app.Action-property-currentFilterIndex","cls":"Ext.app.Action"},{"type":"class","member":"Route","icon":"class","private":true,"sort":1,"id":"Ext.app.Route","cls":"Ext.app.Route"},{"type":"member","member":"action","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Route-cfg-action","cls":"Ext.app.Route"},{"type":"member","member":"conditions","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Route-cfg-conditions","cls":"Ext.app.Route"},{"type":"member","member":"controller","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Route-cfg-controller","cls":"Ext.app.Route"},{"type":"member","member":"initialized","icon":"cfg","private":true,"sort":3,"id":"Ext.app.Route-cfg-initialized","cls":"Ext.app.Route"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Route-cfg-url","cls":"Ext.app.Route"},{"type":"member","member":"argsFor","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-argsFor","cls":"Ext.app.Route"},{"type":"member","member":"createMatcherRegex","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-createMatcherRegex","cls":"Ext.app.Route"},{"type":"member","member":"initialize","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-initialize","cls":"Ext.app.Route"},{"type":"member","member":"matchesFor","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-matchesFor","cls":"Ext.app.Route"},{"type":"member","member":"recognize","icon":"method","private":false,"sort":3,"id":"Ext.app.Route-method-recognize","cls":"Ext.app.Route"},{"type":"member","member":"recognizes","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-recognizes","cls":"Ext.app.Route"},{"type":"member","member":"urlFor","icon":"method","private":true,"sort":3,"id":"Ext.app.Route-method-urlFor","cls":"Ext.app.Route"},{"type":"member","member":"paramsInMatchString","icon":"property","private":false,"sort":3,"id":"Ext.app.Route-property-paramsInMatchString","cls":"Ext.app.Route"},{"type":"class","member":"Router","icon":"class","private":true,"sort":1,"id":"Ext.app.Router","cls":"Ext.app.Router"},{"type":"member","member":"defaults","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Router-cfg-defaults","cls":"Ext.app.Router"},{"type":"member","member":"routes","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Router-cfg-routes","cls":"Ext.app.Router"},{"type":"member","member":"clear","icon":"method","private":true,"sort":3,"id":"Ext.app.Router-method-clear","cls":"Ext.app.Router"},{"type":"member","member":"connect","icon":"method","private":false,"sort":3,"id":"Ext.app.Router-method-connect","cls":"Ext.app.Router"},{"type":"member","member":"draw","icon":"method","private":false,"sort":3,"id":"Ext.app.Router-method-draw","cls":"Ext.app.Router"},{"type":"member","member":"recognize","icon":"method","private":false,"sort":3,"id":"Ext.app.Router-method-recognize","cls":"Ext.app.Router"},{"type":"class","member":"Router","icon":"class","private":true,"sort":1,"id":"Ext.Router","cls":"Ext.Router"},{"type":"member","member":"setAppInstance","icon":"method","private":false,"sort":3,"id":"Ext.Router-method-setAppInstance","cls":"Ext.Router"},{"type":"class","member":"Behavior","icon":"class","private":true,"sort":1,"id":"Ext.behavior.Behavior","cls":"Ext.behavior.Behavior"},{"type":"class","member":"JsonP","icon":"class","private":false,"sort":1,"id":"Ext.data.JsonP","cls":"Ext.data.JsonP"},{"type":"class","member":"JSONP","icon":"subclass","private":false,"sort":2,"id":"Ext.data.JsonP","cls":"Ext.util.JSONP"},{"type":"member","member":"abort","icon":"method","private":false,"sort":3,"id":"Ext.data.JsonP-method-abort","cls":"Ext.data.JsonP"},{"type":"member","member":"cleanupErrorHandling","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-cleanupErrorHandling","cls":"Ext.data.JsonP"},{"type":"member","member":"createScript","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-createScript","cls":"Ext.data.JsonP"},{"type":"member","member":"handleAbort","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-handleAbort","cls":"Ext.data.JsonP"},{"type":"member","member":"handleError","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-handleError","cls":"Ext.data.JsonP"},{"type":"member","member":"handleResponse","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-handleResponse","cls":"Ext.data.JsonP"},{"type":"member","member":"handleTimeout","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-handleTimeout","cls":"Ext.data.JsonP"},{"type":"member","member":"loadScript","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-loadScript","cls":"Ext.data.JsonP"},{"type":"member","member":"request","icon":"method","private":false,"sort":3,"id":"Ext.data.JsonP-method-request","cls":"Ext.data.JsonP"},{"type":"member","member":"setupErrorHandling","icon":"method","private":true,"sort":3,"id":"Ext.data.JsonP-method-setupErrorHandling","cls":"Ext.data.JsonP"},{"type":"member","member":"callbackKey","icon":"property","private":false,"sort":3,"id":"Ext.data.JsonP-property-callbackKey","cls":"Ext.data.JsonP"},{"type":"member","member":"disableCaching","icon":"property","private":false,"sort":3,"id":"Ext.data.JsonP-property-disableCaching","cls":"Ext.data.JsonP"},{"type":"member","member":"disableCachingParam","icon":"property","private":false,"sort":3,"id":"Ext.data.JsonP-property-disableCachingParam","cls":"Ext.data.JsonP"},{"type":"member","member":"timeout","icon":"property","private":false,"sort":3,"id":"Ext.data.JsonP-property-timeout","cls":"Ext.data.JsonP"},{"type":"class","member":"Operation","icon":"class","private":false,"sort":1,"id":"Ext.data.Operation","cls":"Ext.data.Operation"},{"type":"member","member":"action","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-action","cls":"Ext.data.Operation"},{"type":"member","member":"batch","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-batch","cls":"Ext.data.Operation"},{"type":"member","member":"callback","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-callback","cls":"Ext.data.Operation"},{"type":"member","member":"filters","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-filters","cls":"Ext.data.Operation"},{"type":"member","member":"groupers","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-groupers","cls":"Ext.data.Operation"},{"type":"member","member":"limit","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-limit","cls":"Ext.data.Operation"},{"type":"member","member":"model","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-model","cls":"Ext.data.Operation"},{"type":"member","member":"request","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-request","cls":"Ext.data.Operation"},{"type":"member","member":"response","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-response","cls":"Ext.data.Operation"},{"type":"member","member":"resultSet","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-resultSet","cls":"Ext.data.Operation"},{"type":"member","member":"scope","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-scope","cls":"Ext.data.Operation"},{"type":"member","member":"sorters","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-sorters","cls":"Ext.data.Operation"},{"type":"member","member":"start","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-start","cls":"Ext.data.Operation"},{"type":"member","member":"synchronous","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Operation-cfg-synchronous","cls":"Ext.data.Operation"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-constructor","cls":"Ext.data.Operation"},{"type":"member","member":"allowWrite","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-allowWrite","cls":"Ext.data.Operation"},{"type":"member","member":"getError","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-getError","cls":"Ext.data.Operation"},{"type":"member","member":"hasException","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-hasException","cls":"Ext.data.Operation"},{"type":"member","member":"isComplete","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-isComplete","cls":"Ext.data.Operation"},{"type":"member","member":"isRunning","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-isRunning","cls":"Ext.data.Operation"},{"type":"member","member":"isStarted","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-isStarted","cls":"Ext.data.Operation"},{"type":"member","member":"setCompleted","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-setCompleted","cls":"Ext.data.Operation"},{"type":"member","member":"setException","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-setException","cls":"Ext.data.Operation"},{"type":"member","member":"setStarted","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-setStarted","cls":"Ext.data.Operation"},{"type":"member","member":"setSuccessful","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-setSuccessful","cls":"Ext.data.Operation"},{"type":"member","member":"wasSuccessful","icon":"method","private":false,"sort":3,"id":"Ext.data.Operation-method-wasSuccessful","cls":"Ext.data.Operation"},{"type":"member","member":"complete","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-complete","cls":"Ext.data.Operation"},{"type":"member","member":"error","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-error","cls":"Ext.data.Operation"},{"type":"member","member":"exception","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-exception","cls":"Ext.data.Operation"},{"type":"member","member":"running","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-running","cls":"Ext.data.Operation"},{"type":"member","member":"started","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-started","cls":"Ext.data.Operation"},{"type":"member","member":"success","icon":"property","private":true,"sort":3,"id":"Ext.data.Operation-property-success","cls":"Ext.data.Operation"},{"type":"class","member":"Request","icon":"class","private":false,"sort":1,"id":"Ext.data.Request","cls":"Ext.data.Request"},{"type":"member","member":"action","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-action","cls":"Ext.data.Request"},{"type":"member","member":"callbackKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-callbackKey","cls":"Ext.data.Request"},{"type":"member","member":"disableCaching","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-disableCaching","cls":"Ext.data.Request"},{"type":"member","member":"headers","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-headers","cls":"Ext.data.Request"},{"type":"member","member":"jsonData","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-jsonData","cls":"Ext.data.Request"},{"type":"member","member":"jsonp","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-jsonp","cls":"Ext.data.Request"},{"type":"member","member":"method","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-method","cls":"Ext.data.Request"},{"type":"member","member":"operation","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-operation","cls":"Ext.data.Request"},{"type":"member","member":"params","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-params","cls":"Ext.data.Request"},{"type":"member","member":"proxy","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-proxy","cls":"Ext.data.Request"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-url","cls":"Ext.data.Request"},{"type":"member","member":"xmlData","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Request-cfg-xmlData","cls":"Ext.data.Request"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.Request-method-constructor","cls":"Ext.data.Request"},{"type":"class","member":"ResultSet","icon":"class","private":false,"sort":1,"id":"Ext.data.ResultSet","cls":"Ext.data.ResultSet"},{"type":"member","member":"count","icon":"cfg","private":false,"sort":3,"id":"Ext.data.ResultSet-cfg-count","cls":"Ext.data.ResultSet"},{"type":"member","member":"loaded","icon":"cfg","private":false,"sort":3,"id":"Ext.data.ResultSet-cfg-loaded","cls":"Ext.data.ResultSet"},{"type":"member","member":"records","icon":"cfg","private":false,"sort":3,"id":"Ext.data.ResultSet-cfg-records","cls":"Ext.data.ResultSet"},{"type":"member","member":"success","icon":"cfg","private":false,"sort":3,"id":"Ext.data.ResultSet-cfg-success","cls":"Ext.data.ResultSet"},{"type":"member","member":"total","icon":"cfg","private":false,"sort":3,"id":"Ext.data.ResultSet-cfg-total","cls":"Ext.data.ResultSet"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.ResultSet-method-constructor","cls":"Ext.data.ResultSet"},{"type":"member","member":"updateRecords","icon":"method","private":true,"sort":3,"id":"Ext.data.ResultSet-method-updateRecords","cls":"Ext.data.ResultSet"},{"type":"class","member":"SortTypes","icon":"class","private":false,"sort":1,"id":"Ext.data.SortTypes","cls":"Ext.data.SortTypes"},{"type":"member","member":"asDate","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asDate","cls":"Ext.data.SortTypes"},{"type":"member","member":"asFloat","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asFloat","cls":"Ext.data.SortTypes"},{"type":"member","member":"asInt","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asInt","cls":"Ext.data.SortTypes"},{"type":"member","member":"asText","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asText","cls":"Ext.data.SortTypes"},{"type":"member","member":"asUCString","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asUCString","cls":"Ext.data.SortTypes"},{"type":"member","member":"asUCText","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-asUCText","cls":"Ext.data.SortTypes"},{"type":"member","member":"none","icon":"method","private":false,"sort":3,"id":"Ext.data.SortTypes-method-none","cls":"Ext.data.SortTypes"},{"type":"member","member":"stripTagsRE","icon":"property","private":false,"sort":3,"id":"Ext.data.SortTypes-property-stripTagsRE","cls":"Ext.data.SortTypes"},{"type":"class","member":"Types","icon":"class","private":false,"sort":1,"id":"Ext.data.Types","cls":"Ext.data.Types"},{"type":"member","member":"AUTO","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-AUTO","cls":"Ext.data.Types"},{"type":"member","member":"BOOL","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-BOOL","cls":"Ext.data.Types"},{"type":"member","member":"BOOLEAN","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-BOOLEAN","cls":"Ext.data.Types"},{"type":"member","member":"DATE","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-DATE","cls":"Ext.data.Types"},{"type":"member","member":"FLOAT","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-FLOAT","cls":"Ext.data.Types"},{"type":"member","member":"INT","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-INT","cls":"Ext.data.Types"},{"type":"member","member":"INTEGER","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-INTEGER","cls":"Ext.data.Types"},{"type":"member","member":"NUMBER","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-NUMBER","cls":"Ext.data.Types"},{"type":"member","member":"STRING","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-STRING","cls":"Ext.data.Types"},{"type":"member","member":"stripRe","icon":"property","private":false,"sort":3,"id":"Ext.data.Types-property-stripRe","cls":"Ext.data.Types"},{"type":"class","member":"Validations","icon":"class","private":false,"sort":1,"id":"Ext.data.Validations","cls":"Ext.data.Validations"},{"type":"class","member":"validations","icon":"subclass","private":false,"sort":2,"id":"Ext.data.Validations","cls":"Ext.data.validations"},{"type":"member","member":"email","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-email","cls":"Ext.data.Validations"},{"type":"member","member":"exclusion","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-exclusion","cls":"Ext.data.Validations"},{"type":"member","member":"format","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-format","cls":"Ext.data.Validations"},{"type":"member","member":"getMessage","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-getMessage","cls":"Ext.data.Validations"},{"type":"member","member":"inclusion","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-inclusion","cls":"Ext.data.Validations"},{"type":"member","member":"length","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-length","cls":"Ext.data.Validations"},{"type":"member","member":"presence","icon":"method","private":false,"sort":3,"id":"Ext.data.Validations-method-presence","cls":"Ext.data.Validations"},{"type":"member","member":"emailMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-emailMessage","cls":"Ext.data.Validations"},{"type":"member","member":"emailRe","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-emailRe","cls":"Ext.data.Validations"},{"type":"member","member":"exclusionMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-exclusionMessage","cls":"Ext.data.Validations"},{"type":"member","member":"formatMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-formatMessage","cls":"Ext.data.Validations"},{"type":"member","member":"inclusionMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-inclusionMessage","cls":"Ext.data.Validations"},{"type":"member","member":"lengthMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-lengthMessage","cls":"Ext.data.Validations"},{"type":"member","member":"presenceMessage","icon":"property","private":false,"sort":3,"id":"Ext.data.Validations-property-presenceMessage","cls":"Ext.data.Validations"},{"type":"class","member":"Simple","icon":"class","private":false,"sort":1,"id":"Ext.data.identifier.Simple","cls":"Ext.data.identifier.Simple"},{"type":"class","member":"identifier.simple","icon":"subclass","private":false,"sort":0,"id":"Ext.data.identifier.Simple","cls":"data: identifier.simple"},{"type":"class","member":"Uuid","icon":"class","private":false,"sort":1,"id":"Ext.data.identifier.Uuid","cls":"Ext.data.identifier.Uuid"},{"type":"class","member":"identifier.uuid","icon":"subclass","private":false,"sort":0,"id":"Ext.data.identifier.Uuid","cls":"data: identifier.uuid"},{"type":"member","member":"version","icon":"cfg","private":false,"sort":3,"id":"Ext.data.identifier.Uuid-cfg-version","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"init","icon":"method","private":true,"sort":3,"id":"Ext.data.identifier.Uuid-method-init","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"rand","icon":"method","private":true,"sort":3,"id":"Ext.data.identifier.Uuid-method-rand","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"reconfigure","icon":"method","private":false,"sort":3,"id":"Ext.data.identifier.Uuid-method-reconfigure","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"split","icon":"method","private":true,"sort":3,"id":"Ext.data.identifier.Uuid-method-split","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"toHex","icon":"method","private":true,"sort":3,"id":"Ext.data.identifier.Uuid-method-toHex","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"id","icon":"property","private":false,"sort":3,"id":"Ext.data.identifier.Uuid-property-id","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"salt","icon":"property","private":false,"sort":3,"id":"Ext.data.identifier.Uuid-property-salt","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"timestamp","icon":"property","private":false,"sort":3,"id":"Ext.data.identifier.Uuid-property-timestamp","cls":"Ext.data.identifier.Uuid"},{"type":"member","member":"twoPow14","icon":"property","private":true,"sort":3,"id":"Ext.data.identifier.Uuid-property-twoPow14","cls":"Ext.data.identifier.Uuid"},{"type":"class","member":"Writer","icon":"class","private":false,"sort":1,"id":"Ext.data.writer.Writer","cls":"Ext.data.writer.Writer"},{"type":"class","member":"DataWriter","icon":"subclass","private":false,"sort":2,"id":"Ext.data.writer.Writer","cls":"Ext.data.DataWriter"},{"type":"class","member":"Writer","icon":"subclass","private":false,"sort":2,"id":"Ext.data.writer.Writer","cls":"Ext.data.Writer"},{"type":"class","member":"base","icon":"subclass","private":false,"sort":0,"id":"Ext.data.writer.Writer","cls":"writer: base"},{"type":"member","member":"nameProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Writer-cfg-nameProperty","cls":"Ext.data.writer.Writer"},{"type":"member","member":"writeAllFields","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Writer-cfg-writeAllFields","cls":"Ext.data.writer.Writer"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.writer.Writer-method-constructor","cls":"Ext.data.writer.Writer"},{"type":"member","member":"getRecordData","icon":"method","private":false,"sort":3,"id":"Ext.data.writer.Writer-method-getRecordData","cls":"Ext.data.writer.Writer"},{"type":"member","member":"write","icon":"method","private":false,"sort":3,"id":"Ext.data.writer.Writer-method-write","cls":"Ext.data.writer.Writer"},{"type":"class","member":"Xml","icon":"class","private":false,"sort":1,"id":"Ext.data.writer.Xml","cls":"Ext.data.writer.Xml"},{"type":"class","member":"XmlWriter","icon":"subclass","private":false,"sort":2,"id":"Ext.data.writer.Xml","cls":"Ext.data.XmlWriter"},{"type":"class","member":"xml","icon":"subclass","private":false,"sort":0,"id":"Ext.data.writer.Xml","cls":"writer: xml"},{"type":"member","member":"defaultDocumentRoot","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Xml-cfg-defaultDocumentRoot","cls":"Ext.data.writer.Xml"},{"type":"member","member":"documentRoot","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Xml-cfg-documentRoot","cls":"Ext.data.writer.Xml"},{"type":"member","member":"header","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Xml-cfg-header","cls":"Ext.data.writer.Xml"},{"type":"member","member":"record","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Xml-cfg-record","cls":"Ext.data.writer.Xml"},{"type":"class","member":"CompositeElement","icon":"class","private":false,"sort":1,"id":"Ext.dom.CompositeElement","cls":"Ext.dom.CompositeElement"},{"type":"class","member":"CompositeElement","icon":"subclass","private":false,"sort":2,"id":"Ext.dom.CompositeElement","cls":"Ext.CompositeElement"},{"type":"class","member":"Event","icon":"class","private":false,"sort":1,"id":"Ext.event.Event","cls":"Ext.event.Event"},{"type":"class","member":"EventObject","icon":"subclass","private":false,"sort":2,"id":"Ext.event.Event","cls":"Ext.EventObject"},{"type":"member","member":"getPageX","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-getPageX","cls":"Ext.event.Event"},{"type":"member","member":"getPageY","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-getPageY","cls":"Ext.event.Event"},{"type":"member","member":"getTarget","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-getTarget","cls":"Ext.event.Event"},{"type":"member","member":"getTime","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-getTime","cls":"Ext.event.Event"},{"type":"member","member":"getXY","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-getXY","cls":"Ext.event.Event"},{"type":"member","member":"preventDefault","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-preventDefault","cls":"Ext.event.Event"},{"type":"member","member":"stopEvent","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-stopEvent","cls":"Ext.event.Event"},{"type":"member","member":"stopPropagation","icon":"method","private":false,"sort":3,"id":"Ext.event.Event-method-stopPropagation","cls":"Ext.event.Event"},{"type":"member","member":"angle","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-angle","cls":"Ext.event.Event"},{"type":"member","member":"direction","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-direction","cls":"Ext.event.Event"},{"type":"member","member":"disatance","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-disatance","cls":"Ext.event.Event"},{"type":"member","member":"duration","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-duration","cls":"Ext.event.Event"},{"type":"member","member":"pageX","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-pageX","cls":"Ext.event.Event"},{"type":"member","member":"pageY","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-pageY","cls":"Ext.event.Event"},{"type":"member","member":"rotation","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-rotation","cls":"Ext.event.Event"},{"type":"member","member":"scale","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-scale","cls":"Ext.event.Event"},{"type":"member","member":"target","icon":"property","private":false,"sort":3,"id":"Ext.event.Event-property-target","cls":"Ext.event.Event"},{"type":"class","member":"State","icon":"class","private":false,"sort":1,"id":"Ext.fx.State","cls":"Ext.fx.State"},{"type":"class","member":"Abstract","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.Abstract","cls":"Ext.fx.easing.Abstract"},{"type":"class","member":"Bounce","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.Bounce","cls":"Ext.fx.easing.Bounce"},{"type":"class","member":"Linear","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.Linear","cls":"Ext.fx.easing.Linear"},{"type":"class","member":"linear","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.easing.Linear","cls":"easing: linear"},{"type":"class","member":"Momentum","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.Momentum","cls":"Ext.fx.easing.Momentum"},{"type":"class","member":"Logger","icon":"class","private":false,"sort":1,"id":"Ext.Logger","cls":"Ext.Logger"},{"type":"member","member":"deprecate","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-deprecate","cls":"Ext.Logger"},{"type":"member","member":"error","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-error","cls":"Ext.Logger"},{"type":"member","member":"info","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-info","cls":"Ext.Logger"},{"type":"member","member":"log","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-log","cls":"Ext.Logger"},{"type":"member","member":"verbose","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-verbose","cls":"Ext.Logger"},{"type":"member","member":"warn","icon":"method","private":false,"sort":3,"id":"Ext.Logger-method-warn","cls":"Ext.Logger"},{"type":"class","member":"Identifiable","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Identifiable","cls":"Ext.mixin.Identifiable"},{"type":"member","member":"getId","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Identifiable-method-getId","cls":"Ext.mixin.Identifiable"},{"type":"class","member":"Mixin","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Mixin","cls":"Ext.mixin.Mixin"},{"type":"class","member":"Selectable","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Selectable","cls":"Ext.mixin.Selectable"},{"type":"member","member":"allowDeselect","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-allowDeselect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"deselectOnContainerClick","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-deselectOnContainerClick","cls":"Ext.mixin.Selectable"},{"type":"member","member":"disableSelection","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-disableSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"lastFocused","icon":"cfg","private":true,"sort":3,"id":"Ext.mixin.Selectable-cfg-lastFocused","cls":"Ext.mixin.Selectable"},{"type":"member","member":"lastSelected","icon":"cfg","private":true,"sort":3,"id":"Ext.mixin.Selectable-cfg-lastSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"locked","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-locked","cls":"Ext.mixin.Selectable"},{"type":"member","member":"mode","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-mode","cls":"Ext.mixin.Selectable"},{"type":"member","member":"selected","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Selectable-cfg-selected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"applyMode","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-applyMode","cls":"Ext.mixin.Selectable"},{"type":"member","member":"applySelected","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-applySelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"clearSelections","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-clearSelections","cls":"Ext.mixin.Selectable"},{"type":"member","member":"deselect","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-deselect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"deselectAll","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-deselectAll","cls":"Ext.mixin.Selectable"},{"type":"member","member":"doDeselect","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-doDeselect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"doMultiSelect","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-doMultiSelect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"doSelect","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-doSelect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"doSingleSelect","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-doSingleSelect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getAllowDeselect","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getAllowDeselect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getCount","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getDeselectOnContainerClick","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getDeselectOnContainerClick","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getDisableSelection","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getDisableSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getLastFocused","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-getLastFocused","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getLastSelected","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getLastSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getMode","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getMode","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getSelected","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getSelection","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getSelectionCount","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getSelectionCount","cls":"Ext.mixin.Selectable"},{"type":"member","member":"getSelectionMode","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-getSelectionMode","cls":"Ext.mixin.Selectable"},{"type":"member","member":"hasSelection","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-hasSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"isLocked","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-isLocked","cls":"Ext.mixin.Selectable"},{"type":"member","member":"isSelected","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-isSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"refreshSelection","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-refreshSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-select","cls":"Ext.mixin.Selectable"},{"type":"member","member":"selectAll","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-selectAll","cls":"Ext.mixin.Selectable"},{"type":"member","member":"selectRange","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-selectRange","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setAllowDeselect","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setAllowDeselect","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setDeselectOnContainerClick","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setDeselectOnContainerClick","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setDisableSelection","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setDisableSelection","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setLastFocused","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setLastFocused","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setLastSelected","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-setLastSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setMode","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setMode","cls":"Ext.mixin.Selectable"},{"type":"member","member":"setSelected","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-setSelected","cls":"Ext.mixin.Selectable"},{"type":"member","member":"updateLastFocused","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Selectable-method-updateLastFocused","cls":"Ext.mixin.Selectable"},{"type":"member","member":"updateStore","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Selectable-method-updateStore","cls":"Ext.mixin.Selectable"},{"type":"member","member":"beforeselectionchange","icon":"event","private":false,"sort":3,"id":"Ext.mixin.Selectable-event-beforeselectionchange","cls":"Ext.mixin.Selectable"},{"type":"member","member":"selectionchange","icon":"event","private":false,"sort":3,"id":"Ext.mixin.Selectable-event-selectionchange","cls":"Ext.mixin.Selectable"},{"type":"class","member":"Traversable","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Traversable","cls":"Ext.mixin.Traversable"},{"type":"class","member":"DelayedTask","icon":"class","private":false,"sort":1,"id":"Ext.util.DelayedTask","cls":"Ext.util.DelayedTask"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.DelayedTask-method-constructor","cls":"Ext.util.DelayedTask"},{"type":"member","member":"applyArgs","icon":"method","private":true,"sort":3,"id":"Ext.util.DelayedTask-method-applyArgs","cls":"Ext.util.DelayedTask"},{"type":"member","member":"cancel","icon":"method","private":false,"sort":3,"id":"Ext.util.DelayedTask-method-cancel","cls":"Ext.util.DelayedTask"},{"type":"member","member":"delay","icon":"method","private":false,"sort":3,"id":"Ext.util.DelayedTask-method-delay","cls":"Ext.util.DelayedTask"},{"type":"member","member":"updateInterval","icon":"method","private":true,"sort":3,"id":"Ext.util.DelayedTask-method-updateInterval","cls":"Ext.util.DelayedTask"},{"type":"class","member":"Filter","icon":"class","private":false,"sort":1,"id":"Ext.util.Filter","cls":"Ext.util.Filter"},{"type":"member","member":"anyMatch","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-anyMatch","cls":"Ext.util.Filter"},{"type":"member","member":"caseSensitive","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-caseSensitive","cls":"Ext.util.Filter"},{"type":"member","member":"exactMatch","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-exactMatch","cls":"Ext.util.Filter"},{"type":"member","member":"filterFn","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-filterFn","cls":"Ext.util.Filter"},{"type":"member","member":"id","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-id","cls":"Ext.util.Filter"},{"type":"member","member":"property","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-property","cls":"Ext.util.Filter"},{"type":"member","member":"root","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-root","cls":"Ext.util.Filter"},{"type":"member","member":"scope","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-scope","cls":"Ext.util.Filter"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Filter-cfg-value","cls":"Ext.util.Filter"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.Filter-method-constructor","cls":"Ext.util.Filter"},{"type":"member","member":"createFilterFn","icon":"method","private":true,"sort":3,"id":"Ext.util.Filter-method-createFilterFn","cls":"Ext.util.Filter"},{"type":"member","member":"createValueMatcher","icon":"method","private":true,"sort":3,"id":"Ext.util.Filter-method-createValueMatcher","cls":"Ext.util.Filter"},{"type":"class","member":"Point","icon":"class","private":false,"sort":1,"id":"Ext.util.Point","cls":"Ext.util.Point"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-constructor","cls":"Ext.util.Point"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-clone","cls":"Ext.util.Point"},{"type":"member","member":"copy","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-copy","cls":"Ext.util.Point"},{"type":"member","member":"copyFrom","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-copyFrom","cls":"Ext.util.Point"},{"type":"member","member":"equals","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-equals","cls":"Ext.util.Point"},{"type":"member","member":"from","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-from","cls":"Ext.util.Point"},{"type":"member","member":"isCloseTo","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-isCloseTo","cls":"Ext.util.Point"},{"type":"member","member":"isWithin","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-isWithin","cls":"Ext.util.Point"},{"type":"member","member":"roundedEquals","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-roundedEquals","cls":"Ext.util.Point"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-toString","cls":"Ext.util.Point"},{"type":"member","member":"translate","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-method-translate","cls":"Ext.util.Point"},{"type":"member","member":"fromEvent","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-static-method-fromEvent","cls":"Ext.util.Point"},{"type":"member","member":"fromTouch","icon":"method","private":false,"sort":3,"id":"Ext.util.Point-static-method-fromTouch","cls":"Ext.util.Point"},{"type":"class","member":"Region","icon":"class","private":false,"sort":1,"id":"Ext.util.Region","cls":"Ext.util.Region"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-constructor","cls":"Ext.util.Region"},{"type":"member","member":"adjust","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-adjust","cls":"Ext.util.Region"},{"type":"member","member":"constrainTo","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-constrainTo","cls":"Ext.util.Region"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-contains","cls":"Ext.util.Region"},{"type":"member","member":"copy","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-copy","cls":"Ext.util.Region"},{"type":"member","member":"equals","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-equals","cls":"Ext.util.Region"},{"type":"member","member":"getOutOfBoundOffset","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-getOutOfBoundOffset","cls":"Ext.util.Region"},{"type":"member","member":"getOutOfBoundOffsetX","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-getOutOfBoundOffsetX","cls":"Ext.util.Region"},{"type":"member","member":"getOutOfBoundOffsetY","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-getOutOfBoundOffsetY","cls":"Ext.util.Region"},{"type":"member","member":"intersect","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-intersect","cls":"Ext.util.Region"},{"type":"member","member":"isOutOfBound","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-isOutOfBound","cls":"Ext.util.Region"},{"type":"member","member":"isOutOfBoundX","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-isOutOfBoundX","cls":"Ext.util.Region"},{"type":"member","member":"isOutOfBoundY","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-isOutOfBoundY","cls":"Ext.util.Region"},{"type":"member","member":"round","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-round","cls":"Ext.util.Region"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-toString","cls":"Ext.util.Region"},{"type":"member","member":"translateBy","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-translateBy","cls":"Ext.util.Region"},{"type":"member","member":"union","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-method-union","cls":"Ext.util.Region"},{"type":"member","member":"from","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-static-method-from","cls":"Ext.util.Region"},{"type":"member","member":"getRegion","icon":"method","private":false,"sort":3,"id":"Ext.util.Region-static-method-getRegion","cls":"Ext.util.Region"},{"type":"class","member":"Sorter","icon":"class","private":false,"sort":1,"id":"Ext.util.Sorter","cls":"Ext.util.Sorter"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-direction","cls":"Ext.util.Sorter"},{"type":"member","member":"id","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-id","cls":"Ext.util.Sorter"},{"type":"member","member":"property","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-property","cls":"Ext.util.Sorter"},{"type":"member","member":"root","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-root","cls":"Ext.util.Sorter"},{"type":"member","member":"sorterFn","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-sorterFn","cls":"Ext.util.Sorter"},{"type":"member","member":"transform","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Sorter-cfg-transform","cls":"Ext.util.Sorter"},{"type":"member","member":"createSortFunction","icon":"method","private":true,"sort":3,"id":"Ext.util.Sorter-method-createSortFunction","cls":"Ext.util.Sorter"},{"type":"member","member":"defaultSortFn","icon":"method","private":true,"sort":3,"id":"Ext.util.Sorter-method-defaultSortFn","cls":"Ext.util.Sorter"},{"type":"member","member":"toggle","icon":"method","private":false,"sort":3,"id":"Ext.util.Sorter-method-toggle","cls":"Ext.util.Sorter"},{"type":"class","member":"Inflector","icon":"class","private":false,"sort":1,"id":"Ext.util.Inflector","cls":"Ext.util.Inflector"},{"type":"member","member":"classify","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-classify","cls":"Ext.util.Inflector"},{"type":"member","member":"clearPlurals","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-clearPlurals","cls":"Ext.util.Inflector"},{"type":"member","member":"clearSingulars","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-clearSingulars","cls":"Ext.util.Inflector"},{"type":"member","member":"isTransnumeral","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-isTransnumeral","cls":"Ext.util.Inflector"},{"type":"member","member":"ordinalize","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-ordinalize","cls":"Ext.util.Inflector"},{"type":"member","member":"plural","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-plural","cls":"Ext.util.Inflector"},{"type":"member","member":"pluralize","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-pluralize","cls":"Ext.util.Inflector"},{"type":"member","member":"singular","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-singular","cls":"Ext.util.Inflector"},{"type":"member","member":"singularize","icon":"method","private":false,"sort":3,"id":"Ext.util.Inflector-method-singularize","cls":"Ext.util.Inflector"},{"type":"member","member":"plurals","icon":"property","private":true,"sort":3,"id":"Ext.util.Inflector-property-plurals","cls":"Ext.util.Inflector"},{"type":"member","member":"singulars","icon":"property","private":true,"sort":3,"id":"Ext.util.Inflector-property-singulars","cls":"Ext.util.Inflector"},{"type":"member","member":"uncountable","icon":"property","private":true,"sort":3,"id":"Ext.util.Inflector-property-uncountable","cls":"Ext.util.Inflector"},{"type":"class","member":"Anim","icon":"class","private":false,"sort":1,"id":"Ext.Anim","cls":"Ext.Anim"},{"type":"member","member":"after","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-after","cls":"Ext.Anim"},{"type":"member","member":"autoClear","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-autoClear","cls":"Ext.Anim"},{"type":"member","member":"before","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-before","cls":"Ext.Anim"},{"type":"member","member":"delay","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-delay","cls":"Ext.Anim"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-direction","cls":"Ext.Anim"},{"type":"member","member":"disableAnimations","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-disableAnimations","cls":"Ext.Anim"},{"type":"member","member":"duration","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-duration","cls":"Ext.Anim"},{"type":"member","member":"easing","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-easing","cls":"Ext.Anim"},{"type":"member","member":"from","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-from","cls":"Ext.Anim"},{"type":"member","member":"out","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-out","cls":"Ext.Anim"},{"type":"member","member":"reverse","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-reverse","cls":"Ext.Anim"},{"type":"member","member":"scope","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-scope","cls":"Ext.Anim"},{"type":"member","member":"to","icon":"cfg","private":false,"sort":3,"id":"Ext.Anim-cfg-to","cls":"Ext.Anim"},{"type":"member","member":"run","icon":"method","private":false,"sort":3,"id":"Ext.Anim-method-run","cls":"Ext.Anim"},{"type":"class","member":"anims","icon":"class","private":false,"sort":1,"id":"Ext.anims","cls":"Ext.anims"},{"type":"member","member":"cube","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-cube","cls":"Ext.anims"},{"type":"member","member":"fade","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-fade","cls":"Ext.anims"},{"type":"member","member":"flip","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-flip","cls":"Ext.anims"},{"type":"member","member":"pop","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-pop","cls":"Ext.anims"},{"type":"member","member":"slide","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-slide","cls":"Ext.anims"},{"type":"member","member":"wipe","icon":"property","private":false,"sort":3,"id":"Ext.anims-property-wipe","cls":"Ext.anims"},{"type":"class","member":"XTemplateCompiler","icon":"class","private":true,"sort":1,"id":"Ext.XTemplateCompiler","cls":"Ext.XTemplateCompiler"},{"type":"class","member":"Field","icon":"class","private":false,"sort":1,"id":"Ext.data.Field","cls":"Ext.data.Field"},{"type":"class","member":"field","icon":"subclass","private":false,"sort":0,"id":"Ext.data.Field","cls":"data: field"},{"type":"member","member":"allowBlank","icon":"cfg","private":true,"sort":3,"id":"Ext.data.Field-cfg-allowBlank","cls":"Ext.data.Field"},{"type":"member","member":"allowNull","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-allowNull","cls":"Ext.data.Field"},{"type":"member","member":"convert","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-convert","cls":"Ext.data.Field"},{"type":"member","member":"dateFormat","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-dateFormat","cls":"Ext.data.Field"},{"type":"member","member":"defaultValue","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-defaultValue","cls":"Ext.data.Field"},{"type":"member","member":"mapping","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-mapping","cls":"Ext.data.Field"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-name","cls":"Ext.data.Field"},{"type":"member","member":"persist","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-persist","cls":"Ext.data.Field"},{"type":"member","member":"sortDir","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-sortDir","cls":"Ext.data.Field"},{"type":"member","member":"sortType","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-sortType","cls":"Ext.data.Field"},{"type":"member","member":"type","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Field-cfg-type","cls":"Ext.data.Field"},{"type":"class","member":"Sequential","icon":"class","private":false,"sort":1,"id":"Ext.data.identifier.Sequential","cls":"Ext.data.identifier.Sequential"},{"type":"class","member":"identifier.sequential","icon":"subclass","private":false,"sort":0,"id":"Ext.data.identifier.Sequential","cls":"data: identifier.sequential"},{"type":"member","member":"prefix","icon":"cfg","private":false,"sort":3,"id":"Ext.data.identifier.Sequential-cfg-prefix","cls":"Ext.data.identifier.Sequential"},{"type":"member","member":"seed","icon":"cfg","private":false,"sort":3,"id":"Ext.data.identifier.Sequential-cfg-seed","cls":"Ext.data.identifier.Sequential"},{"type":"class","member":"Json","icon":"class","private":false,"sort":1,"id":"Ext.data.writer.Json","cls":"Ext.data.writer.Json"},{"type":"class","member":"JsonWriter","icon":"subclass","private":false,"sort":2,"id":"Ext.data.writer.Json","cls":"Ext.data.JsonWriter"},{"type":"class","member":"json","icon":"subclass","private":false,"sort":0,"id":"Ext.data.writer.Json","cls":"writer: json"},{"type":"member","member":"allowSingle","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Json-cfg-allowSingle","cls":"Ext.data.writer.Json"},{"type":"member","member":"encode","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Json-cfg-encode","cls":"Ext.data.writer.Json"},{"type":"member","member":"root","icon":"cfg","private":false,"sort":3,"id":"Ext.data.writer.Json-cfg-root","cls":"Ext.data.writer.Json"},{"type":"class","member":"Recognizer","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Recognizer","cls":"Ext.event.recognizer.Recognizer"},{"type":"class","member":"Touch","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Touch","cls":"Ext.event.recognizer.Touch"},{"type":"class","member":"MultiTouch","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.MultiTouch","cls":"Ext.event.recognizer.MultiTouch"},{"type":"class","member":"Pinch","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Pinch","cls":"Ext.event.recognizer.Pinch"},{"type":"class","member":"Rotate","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Rotate","cls":"Ext.event.recognizer.Rotate"},{"type":"class","member":"SingleTouch","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.SingleTouch","cls":"Ext.event.recognizer.SingleTouch"},{"type":"class","member":"DoubleTap","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.DoubleTap","cls":"Ext.event.recognizer.DoubleTap"},{"type":"class","member":"Drag","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Drag","cls":"Ext.event.recognizer.Drag"},{"type":"class","member":"LongPress","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.LongPress","cls":"Ext.event.recognizer.LongPress"},{"type":"class","member":"Tap","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Tap","cls":"Ext.event.recognizer.Tap"},{"type":"class","member":"DateExtras","icon":"class","private":false,"sort":1,"id":"Ext.DateExtras","cls":"Ext.DateExtras"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-add","cls":"Ext.DateExtras"},{"type":"member","member":"between","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-between","cls":"Ext.DateExtras"},{"type":"member","member":"clearTime","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-clearTime","cls":"Ext.DateExtras"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-clone","cls":"Ext.DateExtras"},{"type":"member","member":"format","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-format","cls":"Ext.DateExtras"},{"type":"member","member":"getDayOfYear","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getDayOfYear","cls":"Ext.DateExtras"},{"type":"member","member":"getDaysInMonth","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getDaysInMonth","cls":"Ext.DateExtras"},{"type":"member","member":"getElapsed","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getElapsed","cls":"Ext.DateExtras"},{"type":"member","member":"getFirstDateOfMonth","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getFirstDateOfMonth","cls":"Ext.DateExtras"},{"type":"member","member":"getFirstDayOfMonth","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getFirstDayOfMonth","cls":"Ext.DateExtras"},{"type":"member","member":"getGMTOffset","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getGMTOffset","cls":"Ext.DateExtras"},{"type":"member","member":"getLastDateOfMonth","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getLastDateOfMonth","cls":"Ext.DateExtras"},{"type":"member","member":"getLastDayOfMonth","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getLastDayOfMonth","cls":"Ext.DateExtras"},{"type":"member","member":"getMonthNumber","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getMonthNumber","cls":"Ext.DateExtras"},{"type":"member","member":"getShortDayName","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getShortDayName","cls":"Ext.DateExtras"},{"type":"member","member":"getShortMonthName","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getShortMonthName","cls":"Ext.DateExtras"},{"type":"member","member":"getSuffix","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getSuffix","cls":"Ext.DateExtras"},{"type":"member","member":"getTimezone","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getTimezone","cls":"Ext.DateExtras"},{"type":"member","member":"getWeekOfYear","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-getWeekOfYear","cls":"Ext.DateExtras"},{"type":"member","member":"isDST","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-isDST","cls":"Ext.DateExtras"},{"type":"member","member":"isLeapYear","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-isLeapYear","cls":"Ext.DateExtras"},{"type":"member","member":"isValid","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-isValid","cls":"Ext.DateExtras"},{"type":"member","member":"now","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-now","cls":"Ext.DateExtras"},{"type":"member","member":"parse","icon":"method","private":false,"sort":3,"id":"Ext.DateExtras-method-parse","cls":"Ext.DateExtras"},{"type":"member","member":"DAY","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-DAY","cls":"Ext.DateExtras"},{"type":"member","member":"HOUR","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-HOUR","cls":"Ext.DateExtras"},{"type":"member","member":"MILLI","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-MILLI","cls":"Ext.DateExtras"},{"type":"member","member":"MINUTE","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-MINUTE","cls":"Ext.DateExtras"},{"type":"member","member":"MONTH","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-MONTH","cls":"Ext.DateExtras"},{"type":"member","member":"SECOND","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-SECOND","cls":"Ext.DateExtras"},{"type":"member","member":"YEAR","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-YEAR","cls":"Ext.DateExtras"},{"type":"member","member":"dayNames","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-dayNames","cls":"Ext.DateExtras"},{"type":"member","member":"defaultFormat","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-defaultFormat","cls":"Ext.DateExtras"},{"type":"member","member":"defaults","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-defaults","cls":"Ext.DateExtras"},{"type":"member","member":"formatCodes","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-formatCodes","cls":"Ext.DateExtras"},{"type":"member","member":"formatFunctions","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-formatFunctions","cls":"Ext.DateExtras"},{"type":"member","member":"monthNames","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-monthNames","cls":"Ext.DateExtras"},{"type":"member","member":"monthNumbers","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-monthNumbers","cls":"Ext.DateExtras"},{"type":"member","member":"parseFunctions","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-parseFunctions","cls":"Ext.DateExtras"},{"type":"member","member":"useStrict","icon":"property","private":false,"sort":3,"id":"Ext.DateExtras-property-useStrict","cls":"Ext.DateExtras"},{"type":"class","member":"Easing","icon":"class","private":true,"sort":1,"id":"Ext.fx.Easing","cls":"Ext.fx.Easing"},{"type":"class","member":"BoundMomentum","icon":"class","private":false,"sort":1,"id":"Ext.fx.easing.BoundMomentum","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"bounce","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-cfg-bounce","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"minVelocity","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-cfg-minVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"momentum","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-cfg-momentum","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"startVelocity","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-cfg-startVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"getBounce","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-getBounce","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"getMinVelocity","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-getMinVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"getMomentum","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-getMomentum","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"getStartVelocity","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-getStartVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"setBounce","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-setBounce","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"setMinVelocity","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-setMinVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"setMomentum","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-setMomentum","cls":"Ext.fx.easing.BoundMomentum"},{"type":"member","member":"setStartVelocity","icon":"method","private":false,"sort":3,"id":"Ext.fx.easing.BoundMomentum-method-setStartVelocity","cls":"Ext.fx.easing.BoundMomentum"},{"type":"class","member":"EaseIn","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.EaseIn","cls":"Ext.fx.easing.EaseIn"},{"type":"class","member":"ease-in","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.easing.EaseIn","cls":"easing: ease-in"},{"type":"class","member":"EaseOut","icon":"class","private":true,"sort":1,"id":"Ext.fx.easing.EaseOut","cls":"Ext.fx.easing.EaseOut"},{"type":"class","member":"ease-out","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.easing.EaseOut","cls":"easing: ease-out"},{"type":"class","member":"Filterable","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Filterable","cls":"Ext.mixin.Filterable"},{"type":"member","member":"filterRoot","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Filterable-cfg-filterRoot","cls":"Ext.mixin.Filterable"},{"type":"member","member":"filters","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Filterable-cfg-filters","cls":"Ext.mixin.Filterable"},{"type":"member","member":"addFilter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-addFilter","cls":"Ext.mixin.Filterable"},{"type":"member","member":"addFilters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-addFilters","cls":"Ext.mixin.Filterable"},{"type":"member","member":"filter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-filter","cls":"Ext.mixin.Filterable"},{"type":"member","member":"getFilterFn","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-getFilterFn","cls":"Ext.mixin.Filterable"},{"type":"member","member":"insertFilter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-insertFilter","cls":"Ext.mixin.Filterable"},{"type":"member","member":"insertFilters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-insertFilters","cls":"Ext.mixin.Filterable"},{"type":"member","member":"removeFilters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Filterable-method-removeFilters","cls":"Ext.mixin.Filterable"},{"type":"member","member":"updateFilterFn","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Filterable-method-updateFilterFn","cls":"Ext.mixin.Filterable"},{"type":"member","member":"currentSortFn","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Filterable-property-currentSortFn","cls":"Ext.mixin.Filterable"},{"type":"member","member":"dirtyFilterFn","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Filterable-property-dirtyFilterFn","cls":"Ext.mixin.Filterable"},{"type":"member","member":"filtered","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Filterable-property-filtered","cls":"Ext.mixin.Filterable"},{"type":"class","member":"Observable","icon":"class","private":false,"sort":1,"id":"Ext.mixin.Observable","cls":"Ext.mixin.Observable"},{"type":"class","member":"Observable","icon":"subclass","private":false,"sort":2,"id":"Ext.mixin.Observable","cls":"Ext.util.Observable"},{"type":"member","member":"bubbleEvents","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Observable-cfg-bubbleEvents","cls":"Ext.mixin.Observable"},{"type":"member","member":"listeners","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Observable-cfg-listeners","cls":"Ext.mixin.Observable"},{"type":"member","member":"addListener","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-addListener","cls":"Ext.mixin.Observable"},{"type":"member","member":"changeListener","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Observable-method-changeListener","cls":"Ext.mixin.Observable"},{"type":"member","member":"clearListeners","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-clearListeners","cls":"Ext.mixin.Observable"},{"type":"member","member":"createEventRelayer","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Observable-method-createEventRelayer","cls":"Ext.mixin.Observable"},{"type":"member","member":"doAddListener","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Observable-method-doAddListener","cls":"Ext.mixin.Observable"},{"type":"member","member":"enableBubble","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-enableBubble","cls":"Ext.mixin.Observable"},{"type":"member","member":"fireAction","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-fireAction","cls":"Ext.mixin.Observable"},{"type":"member","member":"fireEvent","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-fireEvent","cls":"Ext.mixin.Observable"},{"type":"member","member":"getBubbleEvents","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-getBubbleEvents","cls":"Ext.mixin.Observable"},{"type":"member","member":"getListeners","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-getListeners","cls":"Ext.mixin.Observable"},{"type":"member","member":"hasListener","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-hasListener","cls":"Ext.mixin.Observable"},{"type":"member","member":"relayEvent","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Observable-method-relayEvent","cls":"Ext.mixin.Observable"},{"type":"member","member":"relayEvents","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-relayEvents","cls":"Ext.mixin.Observable"},{"type":"member","member":"removeListener","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-removeListener","cls":"Ext.mixin.Observable"},{"type":"member","member":"resumeEvents","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-resumeEvents","cls":"Ext.mixin.Observable"},{"type":"member","member":"setBubbleEvents","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-setBubbleEvents","cls":"Ext.mixin.Observable"},{"type":"member","member":"setListeners","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-setListeners","cls":"Ext.mixin.Observable"},{"type":"member","member":"suspendEvents","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Observable-method-suspendEvents","cls":"Ext.mixin.Observable"},{"type":"class","member":"Evented","icon":"class","private":true,"sort":1,"id":"Ext.Evented","cls":"Ext.Evented"},{"type":"class","member":"EventedBase","icon":"subclass","private":true,"sort":2,"id":"Ext.Evented","cls":"Ext.EventedBase"},{"type":"class","member":"AbstractComponent","icon":"class","private":true,"sort":1,"id":"Ext.AbstractComponent","cls":"Ext.AbstractComponent"},{"type":"member","member":"addReferenceNode","icon":"method","private":true,"sort":3,"id":"Ext.AbstractComponent-method-addReferenceNode","cls":"Ext.AbstractComponent"},{"type":"class","member":"Controller","icon":"class","private":false,"sort":1,"id":"Ext.app.Controller","cls":"Ext.app.Controller"},{"type":"member","member":"application","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-application","cls":"Ext.app.Controller"},{"type":"member","member":"before","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-before","cls":"Ext.app.Controller"},{"type":"member","member":"control","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-control","cls":"Ext.app.Controller"},{"type":"member","member":"init","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-init","cls":"Ext.app.Controller"},{"type":"member","member":"launch","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-launch","cls":"Ext.app.Controller"},{"type":"member","member":"refs","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-refs","cls":"Ext.app.Controller"},{"type":"member","member":"routes","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Controller-cfg-routes","cls":"Ext.app.Controller"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-constructor","cls":"Ext.app.Controller"},{"type":"member","member":"applyBefore","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-applyBefore","cls":"Ext.app.Controller"},{"type":"member","member":"applyControl","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-applyControl","cls":"Ext.app.Controller"},{"type":"member","member":"applyRefs","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-applyRefs","cls":"Ext.app.Controller"},{"type":"member","member":"applyRoutes","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-applyRoutes","cls":"Ext.app.Controller"},{"type":"member","member":"control","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-control","cls":"Ext.app.Controller"},{"type":"member","member":"execute","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-execute","cls":"Ext.app.Controller"},{"type":"member","member":"getApplication","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getApplication","cls":"Ext.app.Controller"},{"type":"member","member":"getBefore","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getBefore","cls":"Ext.app.Controller"},{"type":"member","member":"getControl","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getControl","cls":"Ext.app.Controller"},{"type":"member","member":"getController","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getController","cls":"Ext.app.Controller"},{"type":"member","member":"getModel","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getModel","cls":"Ext.app.Controller"},{"type":"member","member":"getRef","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-getRef","cls":"Ext.app.Controller"},{"type":"member","member":"getRefs","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getRefs","cls":"Ext.app.Controller"},{"type":"member","member":"getRoutes","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-getRoutes","cls":"Ext.app.Controller"},{"type":"member","member":"hasRef","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-hasRef","cls":"Ext.app.Controller"},{"type":"member","member":"redirectTo","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-redirectTo","cls":"Ext.app.Controller"},{"type":"member","member":"ref","icon":"method","private":true,"sort":3,"id":"Ext.app.Controller-method-ref","cls":"Ext.app.Controller"},{"type":"member","member":"setApplication","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-setApplication","cls":"Ext.app.Controller"},{"type":"member","member":"setBefore","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-setBefore","cls":"Ext.app.Controller"},{"type":"member","member":"setControl","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-setControl","cls":"Ext.app.Controller"},{"type":"member","member":"setRefs","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-setRefs","cls":"Ext.app.Controller"},{"type":"member","member":"setRoutes","icon":"method","private":false,"sort":3,"id":"Ext.app.Controller-method-setRoutes","cls":"Ext.app.Controller"},{"type":"class","member":"History","icon":"class","private":true,"sort":1,"id":"Ext.app.History","cls":"Ext.app.History"},{"type":"member","member":"actions","icon":"cfg","private":false,"sort":3,"id":"Ext.app.History-cfg-actions","cls":"Ext.app.History"},{"type":"member","member":"token","icon":"cfg","private":false,"sort":3,"id":"Ext.app.History-cfg-token","cls":"Ext.app.History"},{"type":"member","member":"updateUrl","icon":"cfg","private":false,"sort":3,"id":"Ext.app.History-cfg-updateUrl","cls":"Ext.app.History"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.app.History-method-add","cls":"Ext.app.History"},{"type":"member","member":"applyToken","icon":"method","private":true,"sort":3,"id":"Ext.app.History-method-applyToken","cls":"Ext.app.History"},{"type":"member","member":"back","icon":"method","private":true,"sort":3,"id":"Ext.app.History-method-back","cls":"Ext.app.History"},{"type":"member","member":"detectStateChange","icon":"method","private":true,"sort":3,"id":"Ext.app.History-method-detectStateChange","cls":"Ext.app.History"},{"type":"member","member":"onStateChange","icon":"method","private":true,"sort":3,"id":"Ext.app.History-method-onStateChange","cls":"Ext.app.History"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.app.History-event-change","cls":"Ext.app.History"},{"type":"class","member":"Profile","icon":"class","private":false,"sort":1,"id":"Ext.app.Profile","cls":"Ext.app.Profile"},{"type":"member","member":"application","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-application","cls":"Ext.app.Profile"},{"type":"member","member":"controllers","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-controllers","cls":"Ext.app.Profile"},{"type":"member","member":"models","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-models","cls":"Ext.app.Profile"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-name","cls":"Ext.app.Profile"},{"type":"member","member":"namespace","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-namespace","cls":"Ext.app.Profile"},{"type":"member","member":"stores","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-stores","cls":"Ext.app.Profile"},{"type":"member","member":"views","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Profile-cfg-views","cls":"Ext.app.Profile"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-constructor","cls":"Ext.app.Profile"},{"type":"member","member":"applyName","icon":"method","private":true,"sort":3,"id":"Ext.app.Profile-method-applyName","cls":"Ext.app.Profile"},{"type":"member","member":"applyNamespace","icon":"method","private":true,"sort":3,"id":"Ext.app.Profile-method-applyNamespace","cls":"Ext.app.Profile"},{"type":"member","member":"getApplication","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getApplication","cls":"Ext.app.Profile"},{"type":"member","member":"getControllers","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getControllers","cls":"Ext.app.Profile"},{"type":"member","member":"getDependencies","icon":"method","private":true,"sort":3,"id":"Ext.app.Profile-method-getDependencies","cls":"Ext.app.Profile"},{"type":"member","member":"getModels","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getModels","cls":"Ext.app.Profile"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getName","cls":"Ext.app.Profile"},{"type":"member","member":"getNamespace","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getNamespace","cls":"Ext.app.Profile"},{"type":"member","member":"getStores","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getStores","cls":"Ext.app.Profile"},{"type":"member","member":"getViews","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-getViews","cls":"Ext.app.Profile"},{"type":"member","member":"isActive","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-isActive","cls":"Ext.app.Profile"},{"type":"member","member":"launch","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-launch","cls":"Ext.app.Profile"},{"type":"member","member":"setApplication","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setApplication","cls":"Ext.app.Profile"},{"type":"member","member":"setControllers","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setControllers","cls":"Ext.app.Profile"},{"type":"member","member":"setModels","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setModels","cls":"Ext.app.Profile"},{"type":"member","member":"setName","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setName","cls":"Ext.app.Profile"},{"type":"member","member":"setNamespace","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setNamespace","cls":"Ext.app.Profile"},{"type":"member","member":"setStores","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setStores","cls":"Ext.app.Profile"},{"type":"member","member":"setViews","icon":"method","private":false,"sort":3,"id":"Ext.app.Profile-method-setViews","cls":"Ext.app.Profile"},{"type":"class","member":"Application","icon":"class","private":false,"sort":1,"id":"Ext.app.Application","cls":"Ext.app.Application"},{"type":"member","member":"appFolder","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-appFolder","cls":"Ext.app.Application"},{"type":"member","member":"controllerInstances","icon":"cfg","private":true,"sort":3,"id":"Ext.app.Application-cfg-controllerInstances","cls":"Ext.app.Application"},{"type":"member","member":"controllers","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-controllers","cls":"Ext.app.Application"},{"type":"member","member":"currentProfile","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-currentProfile","cls":"Ext.app.Application"},{"type":"member","member":"enableLoader","icon":"cfg","private":true,"sort":3,"id":"Ext.app.Application-cfg-enableLoader","cls":"Ext.app.Application"},{"type":"member","member":"glossOnIcon","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-glossOnIcon","cls":"Ext.app.Application"},{"type":"member","member":"history","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-history","cls":"Ext.app.Application"},{"type":"member","member":"icon","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-icon","cls":"Ext.app.Application"},{"type":"member","member":"launch","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-launch","cls":"Ext.app.Application"},{"type":"member","member":"models","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-models","cls":"Ext.app.Application"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-name","cls":"Ext.app.Application"},{"type":"member","member":"phoneIcon","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-phoneIcon","cls":"Ext.app.Application"},{"type":"member","member":"phoneStartupScreen","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-phoneStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"profileInstances","icon":"cfg","private":true,"sort":3,"id":"Ext.app.Application-cfg-profileInstances","cls":"Ext.app.Application"},{"type":"member","member":"profiles","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-profiles","cls":"Ext.app.Application"},{"type":"member","member":"router","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-router","cls":"Ext.app.Application"},{"type":"member","member":"statusBarStyle","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-statusBarStyle","cls":"Ext.app.Application"},{"type":"member","member":"stores","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-stores","cls":"Ext.app.Application"},{"type":"member","member":"tabletIcon","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-tabletIcon","cls":"Ext.app.Application"},{"type":"member","member":"tabletStartupScreen","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-tabletStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"views","icon":"cfg","private":false,"sort":3,"id":"Ext.app.Application-cfg-views","cls":"Ext.app.Application"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-constructor","cls":"Ext.app.Application"},{"type":"member","member":"applyControllers","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyControllers","cls":"Ext.app.Application"},{"type":"member","member":"applyHistory","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyHistory","cls":"Ext.app.Application"},{"type":"member","member":"applyModels","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyModels","cls":"Ext.app.Application"},{"type":"member","member":"applyName","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyName","cls":"Ext.app.Application"},{"type":"member","member":"applyProfiles","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyProfiles","cls":"Ext.app.Application"},{"type":"member","member":"applyRouter","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyRouter","cls":"Ext.app.Application"},{"type":"member","member":"applyStores","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyStores","cls":"Ext.app.Application"},{"type":"member","member":"applyViews","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-applyViews","cls":"Ext.app.Application"},{"type":"member","member":"control","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-control","cls":"Ext.app.Application"},{"type":"member","member":"dispatch","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-dispatch","cls":"Ext.app.Application"},{"type":"member","member":"gatherDependencies","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-gatherDependencies","cls":"Ext.app.Application"},{"type":"member","member":"getAppFolder","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getAppFolder","cls":"Ext.app.Application"},{"type":"member","member":"getController","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-getController","cls":"Ext.app.Application"},{"type":"member","member":"getControllerInstances","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-getControllerInstances","cls":"Ext.app.Application"},{"type":"member","member":"getControllers","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getControllers","cls":"Ext.app.Application"},{"type":"member","member":"getCurrentProfile","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getCurrentProfile","cls":"Ext.app.Application"},{"type":"member","member":"getEnableLoader","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-getEnableLoader","cls":"Ext.app.Application"},{"type":"member","member":"getGlossOnIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getGlossOnIcon","cls":"Ext.app.Application"},{"type":"member","member":"getHistory","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getHistory","cls":"Ext.app.Application"},{"type":"member","member":"getIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getIcon","cls":"Ext.app.Application"},{"type":"member","member":"getLaunch","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getLaunch","cls":"Ext.app.Application"},{"type":"member","member":"getModels","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getModels","cls":"Ext.app.Application"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getName","cls":"Ext.app.Application"},{"type":"member","member":"getPhoneIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getPhoneIcon","cls":"Ext.app.Application"},{"type":"member","member":"getPhoneStartupScreen","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getPhoneStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"getProfileInstances","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-getProfileInstances","cls":"Ext.app.Application"},{"type":"member","member":"getProfiles","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getProfiles","cls":"Ext.app.Application"},{"type":"member","member":"getRouter","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getRouter","cls":"Ext.app.Application"},{"type":"member","member":"getStatusBarStyle","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getStatusBarStyle","cls":"Ext.app.Application"},{"type":"member","member":"getStores","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getStores","cls":"Ext.app.Application"},{"type":"member","member":"getTabletIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getTabletIcon","cls":"Ext.app.Application"},{"type":"member","member":"getTabletStartupScreen","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getTabletStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"getViews","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-getViews","cls":"Ext.app.Application"},{"type":"member","member":"instantiateControllers","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-instantiateControllers","cls":"Ext.app.Application"},{"type":"member","member":"instantiateStores","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-instantiateStores","cls":"Ext.app.Application"},{"type":"member","member":"loadControllerDependencies","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-loadControllerDependencies","cls":"Ext.app.Application"},{"type":"member","member":"onDependenciesLoaded","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-onDependenciesLoaded","cls":"Ext.app.Application"},{"type":"member","member":"onHistoryChange","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-onHistoryChange","cls":"Ext.app.Application"},{"type":"member","member":"onProfilesLoaded","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-onProfilesLoaded","cls":"Ext.app.Application"},{"type":"member","member":"redirectTo","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-redirectTo","cls":"Ext.app.Application"},{"type":"member","member":"setAppFolder","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setAppFolder","cls":"Ext.app.Application"},{"type":"member","member":"setControllerInstances","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-setControllerInstances","cls":"Ext.app.Application"},{"type":"member","member":"setControllers","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setControllers","cls":"Ext.app.Application"},{"type":"member","member":"setCurrentProfile","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setCurrentProfile","cls":"Ext.app.Application"},{"type":"member","member":"setEnableLoader","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-setEnableLoader","cls":"Ext.app.Application"},{"type":"member","member":"setGlossOnIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setGlossOnIcon","cls":"Ext.app.Application"},{"type":"member","member":"setHistory","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setHistory","cls":"Ext.app.Application"},{"type":"member","member":"setIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setIcon","cls":"Ext.app.Application"},{"type":"member","member":"setLaunch","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setLaunch","cls":"Ext.app.Application"},{"type":"member","member":"setModels","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setModels","cls":"Ext.app.Application"},{"type":"member","member":"setName","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setName","cls":"Ext.app.Application"},{"type":"member","member":"setPhoneIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setPhoneIcon","cls":"Ext.app.Application"},{"type":"member","member":"setPhoneStartupScreen","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setPhoneStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"setProfileInstances","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-setProfileInstances","cls":"Ext.app.Application"},{"type":"member","member":"setProfiles","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setProfiles","cls":"Ext.app.Application"},{"type":"member","member":"setRouter","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setRouter","cls":"Ext.app.Application"},{"type":"member","member":"setStatusBarStyle","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setStatusBarStyle","cls":"Ext.app.Application"},{"type":"member","member":"setStores","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setStores","cls":"Ext.app.Application"},{"type":"member","member":"setTabletIcon","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setTabletIcon","cls":"Ext.app.Application"},{"type":"member","member":"setTabletStartupScreen","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setTabletStartupScreen","cls":"Ext.app.Application"},{"type":"member","member":"setViews","icon":"method","private":false,"sort":3,"id":"Ext.app.Application-method-setViews","cls":"Ext.app.Application"},{"type":"member","member":"updateName","icon":"method","private":true,"sort":3,"id":"Ext.app.Application-method-updateName","cls":"Ext.app.Application"},{"type":"member","member":"dotRe","icon":"property","private":true,"sort":3,"id":"Ext.app.Application-property-dotRe","cls":"Ext.app.Application"},{"type":"class","member":"Batch","icon":"class","private":false,"sort":1,"id":"Ext.data.Batch","cls":"Ext.data.Batch"},{"type":"member","member":"autoStart","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Batch-cfg-autoStart","cls":"Ext.data.Batch"},{"type":"member","member":"pauseOnException","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Batch-cfg-pauseOnException","cls":"Ext.data.Batch"},{"type":"member","member":"proxy","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Batch-cfg-proxy","cls":"Ext.data.Batch"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.Batch-method-constructor","cls":"Ext.data.Batch"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.data.Batch-method-add","cls":"Ext.data.Batch"},{"type":"member","member":"pause","icon":"method","private":false,"sort":3,"id":"Ext.data.Batch-method-pause","cls":"Ext.data.Batch"},{"type":"member","member":"runNextOperation","icon":"method","private":true,"sort":3,"id":"Ext.data.Batch-method-runNextOperation","cls":"Ext.data.Batch"},{"type":"member","member":"runOperation","icon":"method","private":false,"sort":3,"id":"Ext.data.Batch-method-runOperation","cls":"Ext.data.Batch"},{"type":"member","member":"start","icon":"method","private":false,"sort":3,"id":"Ext.data.Batch-method-start","cls":"Ext.data.Batch"},{"type":"member","member":"complete","icon":"event","private":false,"sort":3,"id":"Ext.data.Batch-event-complete","cls":"Ext.data.Batch"},{"type":"member","member":"exception","icon":"event","private":false,"sort":3,"id":"Ext.data.Batch-event-exception","cls":"Ext.data.Batch"},{"type":"member","member":"operationcomplete","icon":"event","private":false,"sort":3,"id":"Ext.data.Batch-event-operationcomplete","cls":"Ext.data.Batch"},{"type":"member","member":"current","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-current","cls":"Ext.data.Batch"},{"type":"member","member":"hasException","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-hasException","cls":"Ext.data.Batch"},{"type":"member","member":"isComplete","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-isComplete","cls":"Ext.data.Batch"},{"type":"member","member":"isRunning","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-isRunning","cls":"Ext.data.Batch"},{"type":"member","member":"operations","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-operations","cls":"Ext.data.Batch"},{"type":"member","member":"total","icon":"property","private":false,"sort":3,"id":"Ext.data.Batch-property-total","cls":"Ext.data.Batch"},{"type":"class","member":"Connection","icon":"class","private":false,"sort":1,"id":"Ext.data.Connection","cls":"Ext.data.Connection"},{"type":"member","member":"defaultHeaders","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-defaultHeaders","cls":"Ext.data.Connection"},{"type":"member","member":"disableCaching","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-disableCaching","cls":"Ext.data.Connection"},{"type":"member","member":"disableCachingParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-disableCachingParam","cls":"Ext.data.Connection"},{"type":"member","member":"extraParams","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-extraParams","cls":"Ext.data.Connection"},{"type":"member","member":"method","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-method","cls":"Ext.data.Connection"},{"type":"member","member":"timeout","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-timeout","cls":"Ext.data.Connection"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Connection-cfg-url","cls":"Ext.data.Connection"},{"type":"member","member":"abort","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-abort","cls":"Ext.data.Connection"},{"type":"member","member":"cleanup","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-cleanup","cls":"Ext.data.Connection"},{"type":"member","member":"clearTimeout","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-clearTimeout","cls":"Ext.data.Connection"},{"type":"member","member":"createException","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-createException","cls":"Ext.data.Connection"},{"type":"member","member":"createResponse","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-createResponse","cls":"Ext.data.Connection"},{"type":"member","member":"getDefaultHeaders","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getDefaultHeaders","cls":"Ext.data.Connection"},{"type":"member","member":"getDisableCaching","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getDisableCaching","cls":"Ext.data.Connection"},{"type":"member","member":"getDisableCachingParam","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getDisableCachingParam","cls":"Ext.data.Connection"},{"type":"member","member":"getExtraParams","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getExtraParams","cls":"Ext.data.Connection"},{"type":"member","member":"getForm","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-getForm","cls":"Ext.data.Connection"},{"type":"member","member":"getTimeout","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getTimeout","cls":"Ext.data.Connection"},{"type":"member","member":"getUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-getUrl","cls":"Ext.data.Connection"},{"type":"member","member":"isFormUpload","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-isFormUpload","cls":"Ext.data.Connection"},{"type":"member","member":"isLoading","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-isLoading","cls":"Ext.data.Connection"},{"type":"member","member":"onComplete","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-onComplete","cls":"Ext.data.Connection"},{"type":"member","member":"onStateChange","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-onStateChange","cls":"Ext.data.Connection"},{"type":"member","member":"parseStatus","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-parseStatus","cls":"Ext.data.Connection"},{"type":"member","member":"request","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-request","cls":"Ext.data.Connection"},{"type":"member","member":"setDefaultHeaders","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setDefaultHeaders","cls":"Ext.data.Connection"},{"type":"member","member":"setDisableCaching","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setDisableCaching","cls":"Ext.data.Connection"},{"type":"member","member":"setDisableCachingParam","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setDisableCachingParam","cls":"Ext.data.Connection"},{"type":"member","member":"setExtraParams","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setExtraParams","cls":"Ext.data.Connection"},{"type":"member","member":"setOptions","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setOptions","cls":"Ext.data.Connection"},{"type":"member","member":"setTimeout","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setTimeout","cls":"Ext.data.Connection"},{"type":"member","member":"setUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-setUrl","cls":"Ext.data.Connection"},{"type":"member","member":"setupHeaders","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-setupHeaders","cls":"Ext.data.Connection"},{"type":"member","member":"setupMethod","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-setupMethod","cls":"Ext.data.Connection"},{"type":"member","member":"setupParams","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-setupParams","cls":"Ext.data.Connection"},{"type":"member","member":"setupUrl","icon":"method","private":true,"sort":3,"id":"Ext.data.Connection-method-setupUrl","cls":"Ext.data.Connection"},{"type":"member","member":"upload","icon":"method","private":false,"sort":3,"id":"Ext.data.Connection-method-upload","cls":"Ext.data.Connection"},{"type":"member","member":"beforerequest","icon":"event","private":false,"sort":3,"id":"Ext.data.Connection-event-beforerequest","cls":"Ext.data.Connection"},{"type":"member","member":"requestcomplete","icon":"event","private":false,"sort":3,"id":"Ext.data.Connection-event-requestcomplete","cls":"Ext.data.Connection"},{"type":"member","member":"requestexception","icon":"event","private":false,"sort":3,"id":"Ext.data.Connection-event-requestexception","cls":"Ext.data.Connection"},{"type":"member","member":"getXhrInstance","icon":"property","private":true,"sort":3,"id":"Ext.data.Connection-property-getXhrInstance","cls":"Ext.data.Connection"},{"type":"class","member":"Ajax","icon":"class","private":false,"sort":1,"id":"Ext.Ajax","cls":"Ext.Ajax"},{"type":"member","member":"autoAbort","icon":"property","private":false,"sort":3,"id":"Ext.Ajax-property-autoAbort","cls":"Ext.Ajax"},{"type":"class","member":"Reader","icon":"class","private":false,"sort":1,"id":"Ext.data.reader.Reader","cls":"Ext.data.reader.Reader"},{"type":"class","member":"Reader","icon":"subclass","private":false,"sort":2,"id":"Ext.data.reader.Reader","cls":"Ext.data.Reader"},{"type":"class","member":"DataReader","icon":"subclass","private":false,"sort":2,"id":"Ext.data.reader.Reader","cls":"Ext.data.DataReader"},{"type":"member","member":"clientIdProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-clientIdProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"idProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-idProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"implicitIncludes","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-implicitIncludes","cls":"Ext.data.reader.Reader"},{"type":"member","member":"messageProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-messageProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"root","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-root","cls":"Ext.data.reader.Reader"},{"type":"member","member":"rootProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-rootProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"successProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-successProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"totalProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Reader-cfg-totalProperty","cls":"Ext.data.reader.Reader"},{"type":"member","member":"buildExtractors","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-buildExtractors","cls":"Ext.data.reader.Reader"},{"type":"member","member":"buildFieldExtractors","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-buildFieldExtractors","cls":"Ext.data.reader.Reader"},{"type":"member","member":"extractData","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-extractData","cls":"Ext.data.reader.Reader"},{"type":"member","member":"getAssociatedDataRoot","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-getAssociatedDataRoot","cls":"Ext.data.reader.Reader"},{"type":"member","member":"getData","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-getData","cls":"Ext.data.reader.Reader"},{"type":"member","member":"getRoot","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-getRoot","cls":"Ext.data.reader.Reader"},{"type":"member","member":"read","icon":"method","private":false,"sort":3,"id":"Ext.data.reader.Reader-method-read","cls":"Ext.data.reader.Reader"},{"type":"member","member":"readAssociated","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Reader-method-readAssociated","cls":"Ext.data.reader.Reader"},{"type":"member","member":"readRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.reader.Reader-method-readRecords","cls":"Ext.data.reader.Reader"},{"type":"member","member":"metaData","icon":"property","private":false,"sort":3,"id":"Ext.data.reader.Reader-property-metaData","cls":"Ext.data.reader.Reader"},{"type":"member","member":"rawData","icon":"property","private":false,"sort":3,"id":"Ext.data.reader.Reader-property-rawData","cls":"Ext.data.reader.Reader"},{"type":"class","member":"Json","icon":"class","private":false,"sort":1,"id":"Ext.data.reader.Json","cls":"Ext.data.reader.Json"},{"type":"class","member":"JsonReader","icon":"subclass","private":false,"sort":2,"id":"Ext.data.reader.Json","cls":"Ext.data.JsonReader"},{"type":"class","member":"json","icon":"subclass","private":false,"sort":0,"id":"Ext.data.reader.Json","cls":"reader: json"},{"type":"member","member":"record","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Json-cfg-record","cls":"Ext.data.reader.Json"},{"type":"member","member":"useSimpleAccessors","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Json-cfg-useSimpleAccessors","cls":"Ext.data.reader.Json"},{"type":"member","member":"createAccessor","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Json-method-createAccessor","cls":"Ext.data.reader.Json"},{"type":"member","member":"extractData","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Json-method-extractData","cls":"Ext.data.reader.Json"},{"type":"member","member":"getRoot","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Json-method-getRoot","cls":"Ext.data.reader.Json"},{"type":"member","member":"exception","icon":"event","private":false,"sort":3,"id":"Ext.data.reader.Json-event-exception","cls":"Ext.data.reader.Json"},{"type":"class","member":"Proxy","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.Proxy","cls":"Ext.data.proxy.Proxy"},{"type":"class","member":"DataProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Proxy","cls":"Ext.data.DataProxy"},{"type":"class","member":"Proxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Proxy","cls":"Ext.data.Proxy"},{"type":"class","member":"proxy","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.Proxy","cls":"proxy: proxy"},{"type":"member","member":"batchActions","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-cfg-batchActions","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"batchOrder","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-cfg-batchOrder","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"model","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-cfg-model","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"reader","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-cfg-reader","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"writer","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-cfg-writer","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"batch","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-method-batch","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-method-create","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-method-destroy","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"onBatchComplete","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Proxy-method-onBatchComplete","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"read","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-method-read","cls":"Ext.data.proxy.Proxy"},{"type":"member","member":"update","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Proxy-method-update","cls":"Ext.data.proxy.Proxy"},{"type":"class","member":"Client","icon":"class","private":true,"sort":1,"id":"Ext.data.proxy.Client","cls":"Ext.data.proxy.Client"},{"type":"class","member":"ClientProxy","icon":"subclass","private":true,"sort":2,"id":"Ext.data.proxy.Client","cls":"Ext.proxy.ClientProxy"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Client-method-clear","cls":"Ext.data.proxy.Client"},{"type":"class","member":"Memory","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.Memory","cls":"Ext.data.proxy.Memory"},{"type":"class","member":"MemoryProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Memory","cls":"Ext.data.MemoryProxy"},{"type":"class","member":"memory","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.Memory","cls":"proxy: memory"},{"type":"member","member":"data","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Memory-cfg-data","cls":"Ext.data.proxy.Memory"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Memory-method-create","cls":"Ext.data.proxy.Memory"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Memory-method-destroy","cls":"Ext.data.proxy.Memory"},{"type":"member","member":"finishOperation","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Memory-method-finishOperation","cls":"Ext.data.proxy.Memory"},{"type":"member","member":"read","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Memory-method-read","cls":"Ext.data.proxy.Memory"},{"type":"member","member":"update","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Memory-method-update","cls":"Ext.data.proxy.Memory"},{"type":"class","member":"Server","icon":"class","private":true,"sort":1,"id":"Ext.data.proxy.Server","cls":"Ext.data.proxy.Server"},{"type":"class","member":"ServerProxy","icon":"subclass","private":true,"sort":2,"id":"Ext.data.proxy.Server","cls":"Ext.data.ServerProxy"},{"type":"class","member":"server","icon":"subclass","private":true,"sort":0,"id":"Ext.data.proxy.Server","cls":"proxy: server"},{"type":"member","member":"api","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-api","cls":"Ext.data.proxy.Server"},{"type":"member","member":"cacheString","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-cacheString","cls":"Ext.data.proxy.Server"},{"type":"member","member":"directionParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-directionParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"enablePagingParams","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-enablePagingParams","cls":"Ext.data.proxy.Server"},{"type":"member","member":"extraParams","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-extraParams","cls":"Ext.data.proxy.Server"},{"type":"member","member":"filterParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-filterParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"groupParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-groupParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"limitParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-limitParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"noCache","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-noCache","cls":"Ext.data.proxy.Server"},{"type":"member","member":"pageParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-pageParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"simpleSortMode","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-simpleSortMode","cls":"Ext.data.proxy.Server"},{"type":"member","member":"sortParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-sortParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"startParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-startParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"timeout","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-timeout","cls":"Ext.data.proxy.Server"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Server-cfg-url","cls":"Ext.data.proxy.Server"},{"type":"member","member":"afterRequest","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-afterRequest","cls":"Ext.data.proxy.Server"},{"type":"member","member":"applyEncoding","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Server-method-applyEncoding","cls":"Ext.data.proxy.Server"},{"type":"member","member":"buildRequest","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-buildRequest","cls":"Ext.data.proxy.Server"},{"type":"member","member":"buildUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-buildUrl","cls":"Ext.data.proxy.Server"},{"type":"member","member":"doRequest","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-doRequest","cls":"Ext.data.proxy.Server"},{"type":"member","member":"encodeFilters","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-encodeFilters","cls":"Ext.data.proxy.Server"},{"type":"member","member":"encodeSorters","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-encodeSorters","cls":"Ext.data.proxy.Server"},{"type":"member","member":"getParams","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Server-method-getParams","cls":"Ext.data.proxy.Server"},{"type":"member","member":"getUrl","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Server-method-getUrl","cls":"Ext.data.proxy.Server"},{"type":"member","member":"processResponse","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-processResponse","cls":"Ext.data.proxy.Server"},{"type":"member","member":"setException","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Server-method-setException","cls":"Ext.data.proxy.Server"},{"type":"member","member":"setExtraParam","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Server-method-setExtraParam","cls":"Ext.data.proxy.Server"},{"type":"member","member":"exception","icon":"event","private":false,"sort":3,"id":"Ext.data.proxy.Server-event-exception","cls":"Ext.data.proxy.Server"},{"type":"class","member":"JsonP","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.JsonP","cls":"Ext.data.proxy.JsonP"},{"type":"class","member":"ScriptTagProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.JsonP","cls":"Ext.data.ScriptTagProxy"},{"type":"class","member":"jsonp","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.JsonP","cls":"proxy: jsonp"},{"type":"class","member":"scripttag","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.JsonP","cls":"proxy: scripttag"},{"type":"member","member":"autoAppendParams","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-cfg-autoAppendParams","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"callbackKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-cfg-callbackKey","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"recordParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-cfg-recordParam","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"abort","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-method-abort","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"buildUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-method-buildUrl","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"createRequestCallback","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.JsonP-method-createRequestCallback","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"doRequest","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.JsonP-method-doRequest","cls":"Ext.data.proxy.JsonP"},{"type":"member","member":"encodeRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.JsonP-method-encodeRecords","cls":"Ext.data.proxy.JsonP"},{"type":"class","member":"WebStorage","icon":"class","private":true,"sort":1,"id":"Ext.data.proxy.WebStorage","cls":"Ext.data.proxy.WebStorage"},{"type":"class","member":"WebStorageProxy","icon":"subclass","private":true,"sort":2,"id":"Ext.data.proxy.WebStorage","cls":"Ext.data.WebStorageProxy"},{"type":"member","member":"id","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.WebStorage-cfg-id","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.WebStorage-method-constructor","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.WebStorage-method-clear","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getIds","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getIds","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getNextId","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getNextId","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getRecord","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getRecord","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getRecordCounterKey","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getRecordCounterKey","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getRecordKey","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getRecordKey","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"getStorageObject","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-getStorageObject","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"initialize","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-initialize","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"removeRecord","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-removeRecord","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"setIds","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.WebStorage-method-setIds","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"setRecord","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.WebStorage-method-setRecord","cls":"Ext.data.proxy.WebStorage"},{"type":"member","member":"cache","icon":"property","private":false,"sort":3,"id":"Ext.data.proxy.WebStorage-property-cache","cls":"Ext.data.proxy.WebStorage"},{"type":"class","member":"LocalStorage","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.LocalStorage","cls":"Ext.data.proxy.LocalStorage"},{"type":"class","member":"LocalStorageProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.LocalStorage","cls":"Ext.data.LocalStorageProxy"},{"type":"class","member":"localstorage","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.LocalStorage","cls":"proxy: localstorage"},{"type":"class","member":"SessionStorage","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.SessionStorage","cls":"Ext.data.proxy.SessionStorage"},{"type":"class","member":"SessionStorageProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.SessionStorage","cls":"Ext.data.SessionStorageProxy"},{"type":"class","member":"sessionstorage","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.SessionStorage","cls":"proxy: sessionstorage"},{"type":"class","member":"Array","icon":"class","private":false,"sort":1,"id":"Ext.data.reader.Array","cls":"Ext.data.reader.Array"},{"type":"class","member":"ArrayReader","icon":"subclass","private":false,"sort":2,"id":"Ext.data.reader.Array","cls":"Ext.data.ArrayReader"},{"type":"class","member":"array","icon":"subclass","private":false,"sort":0,"id":"Ext.data.reader.Array","cls":"reader: array"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.reader.Array-method-constructor","cls":"Ext.data.reader.Array"},{"type":"member","member":"buildFieldExtractors","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Array-method-buildFieldExtractors","cls":"Ext.data.reader.Array"},{"type":"class","member":"Xml","icon":"class","private":false,"sort":1,"id":"Ext.data.reader.Xml","cls":"Ext.data.reader.Xml"},{"type":"class","member":"XmlReader","icon":"subclass","private":false,"sort":2,"id":"Ext.data.reader.Xml","cls":"Ext.data.XmlReader"},{"type":"class","member":"xml","icon":"subclass","private":false,"sort":0,"id":"Ext.data.reader.Xml","cls":"reader: xml"},{"type":"member","member":"record","icon":"cfg","private":false,"sort":3,"id":"Ext.data.reader.Xml-cfg-record","cls":"Ext.data.reader.Xml"},{"type":"member","member":"createAccessor","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Xml-method-createAccessor","cls":"Ext.data.reader.Xml"},{"type":"member","member":"extractData","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Xml-method-extractData","cls":"Ext.data.reader.Xml"},{"type":"member","member":"getAssociatedDataRoot","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Xml-method-getAssociatedDataRoot","cls":"Ext.data.reader.Xml"},{"type":"member","member":"getData","icon":"method","private":false,"sort":3,"id":"Ext.data.reader.Xml-method-getData","cls":"Ext.data.reader.Xml"},{"type":"member","member":"getRoot","icon":"method","private":true,"sort":3,"id":"Ext.data.reader.Xml-method-getRoot","cls":"Ext.data.reader.Xml"},{"type":"member","member":"readRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.reader.Xml-method-readRecords","cls":"Ext.data.reader.Xml"},{"type":"member","member":"exception","icon":"event","private":false,"sort":3,"id":"Ext.data.reader.Xml-event-exception","cls":"Ext.data.reader.Xml"},{"type":"class","member":"Abstract","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Abstract","cls":"Ext.fx.animation.Abstract"},{"type":"class","member":"Cube","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Cube","cls":"Ext.fx.animation.Cube"},{"type":"class","member":"cube","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Cube","cls":"animation: cube"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Cube-cfg-direction","cls":"Ext.fx.animation.Cube"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Cube-method-getDirection","cls":"Ext.fx.animation.Cube"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Cube-method-setDirection","cls":"Ext.fx.animation.Cube"},{"type":"class","member":"Fade","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Fade","cls":"Ext.fx.animation.Fade"},{"type":"class","member":"FadeIn","icon":"subclass","private":true,"sort":2,"id":"Ext.fx.animation.Fade","cls":"Ext.fx.animation.FadeIn"},{"type":"class","member":"fade","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Fade","cls":"animation: fade"},{"type":"class","member":"fadeIn","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Fade","cls":"animation: fadeIn"},{"type":"member","member":"out","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Fade-cfg-out","cls":"Ext.fx.animation.Fade"},{"type":"member","member":"getOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Fade-method-getOut","cls":"Ext.fx.animation.Fade"},{"type":"member","member":"setOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Fade-method-setOut","cls":"Ext.fx.animation.Fade"},{"type":"class","member":"FadeOut","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.FadeOut","cls":"Ext.fx.animation.FadeOut"},{"type":"class","member":"fadeOut","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.FadeOut","cls":"animation: fadeOut"},{"type":"class","member":"Flip","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Flip","cls":"Ext.fx.animation.Flip"},{"type":"class","member":"flip","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Flip","cls":"animation: flip"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Flip-cfg-direction","cls":"Ext.fx.animation.Flip"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Flip-method-getDirection","cls":"Ext.fx.animation.Flip"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Flip-method-setDirection","cls":"Ext.fx.animation.Flip"},{"type":"class","member":"Pop","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Pop","cls":"Ext.fx.animation.Pop"},{"type":"class","member":"PopIn","icon":"subclass","private":true,"sort":2,"id":"Ext.fx.animation.Pop","cls":"Ext.fx.animation.PopIn"},{"type":"class","member":"pop","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Pop","cls":"animation: pop"},{"type":"class","member":"popIn","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Pop","cls":"animation: popIn"},{"type":"member","member":"out","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Pop-cfg-out","cls":"Ext.fx.animation.Pop"},{"type":"member","member":"getOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Pop-method-getOut","cls":"Ext.fx.animation.Pop"},{"type":"member","member":"setOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Pop-method-setOut","cls":"Ext.fx.animation.Pop"},{"type":"class","member":"PopOut","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.PopOut","cls":"Ext.fx.animation.PopOut"},{"type":"class","member":"popOut","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.PopOut","cls":"animation: popOut"},{"type":"class","member":"Slide","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.Slide","cls":"Ext.fx.animation.Slide"},{"type":"class","member":"SlideIn","icon":"subclass","private":true,"sort":2,"id":"Ext.fx.animation.Slide","cls":"Ext.fx.animation.SlideIn"},{"type":"class","member":"slide","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Slide","cls":"animation: slide"},{"type":"class","member":"slideIn","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.Slide","cls":"animation: slideIn"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Slide-cfg-direction","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"offset","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Slide-cfg-offset","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"out","icon":"cfg","private":false,"sort":3,"id":"Ext.fx.animation.Slide-cfg-out","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-getDirection","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"getOffset","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-getOffset","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"getOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-getOut","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-setDirection","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"setOffset","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-setOffset","cls":"Ext.fx.animation.Slide"},{"type":"member","member":"setOut","icon":"method","private":false,"sort":3,"id":"Ext.fx.animation.Slide-method-setOut","cls":"Ext.fx.animation.Slide"},{"type":"class","member":"SlideOut","icon":"class","private":true,"sort":1,"id":"Ext.fx.animation.SlideOut","cls":"Ext.fx.animation.SlideOut"},{"type":"class","member":"slideOut","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.animation.SlideOut","cls":"animation: slideOut"},{"type":"class","member":"Animation","icon":"class","private":false,"sort":1,"id":"Ext.fx.Animation","cls":"Ext.fx.Animation"},{"type":"class","member":"Abstract","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Abstract","cls":"Ext.fx.layout.card.Abstract"},{"type":"class","member":"Scroll","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Scroll","cls":"Ext.fx.layout.card.Scroll"},{"type":"class","member":"layout.card.scroll","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Scroll","cls":"fx: layout.card.scroll"},{"type":"class","member":"Style","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Style","cls":"Ext.fx.layout.card.Style"},{"type":"class","member":"Cover","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Cover","cls":"Ext.fx.layout.card.Cover"},{"type":"class","member":"layout.card.cover","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Cover","cls":"fx: layout.card.cover"},{"type":"class","member":"Cube","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Cube","cls":"Ext.fx.layout.card.Cube"},{"type":"class","member":"layout.card.cube","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Cube","cls":"fx: layout.card.cube"},{"type":"class","member":"Fade","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Fade","cls":"Ext.fx.layout.card.Fade"},{"type":"class","member":"layout.card.fade","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Fade","cls":"fx: layout.card.fade"},{"type":"class","member":"Flip","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Flip","cls":"Ext.fx.layout.card.Flip"},{"type":"class","member":"layout.card.flip","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Flip","cls":"fx: layout.card.flip"},{"type":"class","member":"Pop","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Pop","cls":"Ext.fx.layout.card.Pop"},{"type":"class","member":"layout.card.pop","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Pop","cls":"fx: layout.card.pop"},{"type":"class","member":"Reveal","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Reveal","cls":"Ext.fx.layout.card.Reveal"},{"type":"class","member":"layout.card.reveal","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Reveal","cls":"fx: layout.card.reveal"},{"type":"class","member":"Slide","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.card.Slide","cls":"Ext.fx.layout.card.Slide"},{"type":"class","member":"layout.card.slide","icon":"subclass","private":true,"sort":0,"id":"Ext.fx.layout.card.Slide","cls":"fx: layout.card.slide"},{"type":"class","member":"Card","icon":"class","private":true,"sort":1,"id":"Ext.fx.layout.Card","cls":"Ext.fx.layout.Card"},{"type":"class","member":"Css","icon":"class","private":true,"sort":1,"id":"Ext.fx.runner.Css","cls":"Ext.fx.runner.Css"},{"type":"class","member":"CssTransition","icon":"class","private":true,"sort":1,"id":"Ext.fx.runner.CssTransition","cls":"Ext.fx.runner.CssTransition"},{"type":"class","member":"Default","icon":"class","private":false,"sort":1,"id":"Ext.layout.Default","cls":"Ext.layout.Default"},{"type":"class","member":"AutoContainerLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.Default","cls":"Ext.layout.AutoContainerLayout"},{"type":"class","member":"ContainerLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.Default","cls":"Ext.layout.ContainerLayout"},{"type":"class","member":"auto","icon":"subclass","private":false,"sort":0,"id":"Ext.layout.Default","cls":"layout: auto"},{"type":"class","member":"default","icon":"subclass","private":false,"sort":0,"id":"Ext.layout.Default","cls":"layout: default"},{"type":"member","member":"doItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemAdd","cls":"Ext.layout.Default"},{"type":"member","member":"doItemCenteredChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemCenteredChange","cls":"Ext.layout.Default"},{"type":"member","member":"doItemDockedChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemDockedChange","cls":"Ext.layout.Default"},{"type":"member","member":"doItemFloatingChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemFloatingChange","cls":"Ext.layout.Default"},{"type":"member","member":"doItemMove","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemMove","cls":"Ext.layout.Default"},{"type":"member","member":"doItemRemove","icon":"method","private":true,"sort":3,"id":"Ext.layout.Default-method-doItemRemove","cls":"Ext.layout.Default"},{"type":"class","member":"AbstractBox","icon":"class","private":false,"sort":1,"id":"Ext.layout.AbstractBox","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"align","icon":"cfg","private":false,"sort":3,"id":"Ext.layout.AbstractBox-cfg-align","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"pack","icon":"cfg","private":false,"sort":3,"id":"Ext.layout.AbstractBox-cfg-pack","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"doItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.layout.AbstractBox-method-doItemAdd","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"doItemCenteredChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.AbstractBox-method-doItemCenteredChange","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"doItemDockedChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.AbstractBox-method-doItemDockedChange","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"doItemFloatingChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.AbstractBox-method-doItemFloatingChange","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"doItemRemove","icon":"method","private":true,"sort":3,"id":"Ext.layout.AbstractBox-method-doItemRemove","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"getAlign","icon":"method","private":false,"sort":3,"id":"Ext.layout.AbstractBox-method-getAlign","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"getPack","icon":"method","private":false,"sort":3,"id":"Ext.layout.AbstractBox-method-getPack","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"setAlign","icon":"method","private":false,"sort":3,"id":"Ext.layout.AbstractBox-method-setAlign","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"setItemFlex","icon":"method","private":false,"sort":3,"id":"Ext.layout.AbstractBox-method-setItemFlex","cls":"Ext.layout.AbstractBox"},{"type":"member","member":"setPack","icon":"method","private":false,"sort":3,"id":"Ext.layout.AbstractBox-method-setPack","cls":"Ext.layout.AbstractBox"},{"type":"class","member":"Fit","icon":"class","private":false,"sort":1,"id":"Ext.layout.Fit","cls":"Ext.layout.Fit"},{"type":"class","member":"FitLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.Fit","cls":"Ext.layout.FitLayout"},{"type":"class","member":"fit","icon":"subclass","private":false,"sort":0,"id":"Ext.layout.Fit","cls":"layout: fit"},{"type":"member","member":"doItemRemove","icon":"method","private":true,"sort":3,"id":"Ext.layout.Fit-method-doItemRemove","cls":"Ext.layout.Fit"},{"type":"class","member":"Card","icon":"class","private":false,"sort":1,"id":"Ext.layout.Card","cls":"Ext.layout.Card"},{"type":"class","member":"CardLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.Card","cls":"Ext.layout.CardLayout"},{"type":"member","member":"animation","icon":"cfg","private":false,"sort":3,"id":"Ext.layout.Card-cfg-animation","cls":"Ext.layout.Card"},{"type":"member","member":"applyAnimation","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-applyAnimation","cls":"Ext.layout.Card"},{"type":"member","member":"doActiveItemChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-doActiveItemChange","cls":"Ext.layout.Card"},{"type":"member","member":"doItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-doItemAdd","cls":"Ext.layout.Card"},{"type":"member","member":"doItemRemove","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-doItemRemove","cls":"Ext.layout.Card"},{"type":"member","member":"getAnimation","icon":"method","private":false,"sort":3,"id":"Ext.layout.Card-method-getAnimation","cls":"Ext.layout.Card"},{"type":"member","member":"onContainerActiveItemChange","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-onContainerActiveItemChange","cls":"Ext.layout.Card"},{"type":"member","member":"setAnimation","icon":"method","private":false,"sort":3,"id":"Ext.layout.Card-method-setAnimation","cls":"Ext.layout.Card"},{"type":"member","member":"updateAnimation","icon":"method","private":true,"sort":3,"id":"Ext.layout.Card-method-updateAnimation","cls":"Ext.layout.Card"},{"type":"member","member":"activeitemchange","icon":"event","private":false,"sort":3,"id":"Ext.layout.Card-event-activeitemchange","cls":"Ext.layout.Card"},{"type":"class","member":"HBox","icon":"class","private":false,"sort":1,"id":"Ext.layout.HBox","cls":"Ext.layout.HBox"},{"type":"class","member":"HBoxLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.HBox","cls":"Ext.layout.HBoxLayout"},{"type":"class","member":"hbox","icon":"subclass","private":false,"sort":0,"id":"Ext.layout.HBox","cls":"layout: hbox"},{"type":"class","member":"VBox","icon":"class","private":false,"sort":1,"id":"Ext.layout.VBox","cls":"Ext.layout.VBox"},{"type":"class","member":"VBoxLayout","icon":"subclass","private":false,"sort":2,"id":"Ext.layout.VBox","cls":"Ext.layout.VBoxLayout"},{"type":"class","member":"vbox","icon":"subclass","private":false,"sort":0,"id":"Ext.layout.VBox","cls":"layout: vbox"},{"type":"class","member":"Layout","icon":"class","private":false,"sort":1,"id":"Ext.layout.Layout","cls":"Ext.layout.Layout"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.layout.Layout-method-constructor","cls":"Ext.layout.Layout"},{"type":"class","member":"Sortable","icon":"class","private":true,"sort":1,"id":"Ext.mixin.Sortable","cls":"Ext.mixin.Sortable"},{"type":"member","member":"defaultSortDirection","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Sortable-cfg-defaultSortDirection","cls":"Ext.mixin.Sortable"},{"type":"member","member":"sortRoot","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Sortable-cfg-sortRoot","cls":"Ext.mixin.Sortable"},{"type":"member","member":"sorters","icon":"cfg","private":false,"sort":3,"id":"Ext.mixin.Sortable-cfg-sorters","cls":"Ext.mixin.Sortable"},{"type":"member","member":"addSorter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-addSorter","cls":"Ext.mixin.Sortable"},{"type":"member","member":"addSorters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-addSorters","cls":"Ext.mixin.Sortable"},{"type":"member","member":"findInsertionIndex","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-findInsertionIndex","cls":"Ext.mixin.Sortable"},{"type":"member","member":"getSortFn","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-getSortFn","cls":"Ext.mixin.Sortable"},{"type":"member","member":"insertSorter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-insertSorter","cls":"Ext.mixin.Sortable"},{"type":"member","member":"insertSorters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-insertSorters","cls":"Ext.mixin.Sortable"},{"type":"member","member":"removeSorter","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-removeSorter","cls":"Ext.mixin.Sortable"},{"type":"member","member":"removeSorters","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-removeSorters","cls":"Ext.mixin.Sortable"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Ext.mixin.Sortable-method-sort","cls":"Ext.mixin.Sortable"},{"type":"member","member":"updateSortFn","icon":"method","private":true,"sort":3,"id":"Ext.mixin.Sortable-method-updateSortFn","cls":"Ext.mixin.Sortable"},{"type":"member","member":"currentSortFn","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Sortable-property-currentSortFn","cls":"Ext.mixin.Sortable"},{"type":"member","member":"dirtySortFn","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Sortable-property-dirtySortFn","cls":"Ext.mixin.Sortable"},{"type":"member","member":"sorted","icon":"property","private":false,"sort":3,"id":"Ext.mixin.Sortable-property-sorted","cls":"Ext.mixin.Sortable"},{"type":"class","member":"AbstractMixedCollection","icon":"class","private":true,"sort":1,"id":"Ext.util.AbstractMixedCollection","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"allowFunctions","icon":"cfg","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-cfg-allowFunctions","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-add","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"addAll","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-addAll","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-clear","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-clone","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"collect","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-collect","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-contains","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"containsKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-containsKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"createValueMatcher","icon":"method","private":true,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-createValueMatcher","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-each","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"eachKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-eachKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"extractValues","icon":"method","private":true,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-extractValues","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"filter","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-filter","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"filterBy","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-filterBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"findBy","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-findBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"findIndex","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-findIndex","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"findIndexBy","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-findIndexBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"first","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-first","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-get","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"getAt","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-getAt","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"getByKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-getByKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-getCount","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"getKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-getKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"getRange","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-getRange","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-indexOf","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"indexOfKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-indexOfKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"insert","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-insert","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"last","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-last","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-remove","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-removeAll","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"removeAt","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-removeAt","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"removeAtKey","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-removeAtKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-replace","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"sum","icon":"method","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-method-sum","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"add","icon":"event","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-event-add","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"clear","icon":"event","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-event-clear","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"remove","icon":"event","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-event-remove","cls":"Ext.util.AbstractMixedCollection"},{"type":"member","member":"replace","icon":"event","private":false,"sort":3,"id":"Ext.util.AbstractMixedCollection-event-replace","cls":"Ext.util.AbstractMixedCollection"},{"type":"class","member":"Collection","icon":"class","private":true,"sort":1,"id":"Ext.util.Collection","cls":"Ext.util.Collection"},{"type":"member","member":"filters","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Collection-cfg-filters","cls":"Ext.util.Collection"},{"type":"member","member":"sorters","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Collection-cfg-sorters","cls":"Ext.util.Collection"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-add","cls":"Ext.util.Collection"},{"type":"member","member":"addAll","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-addAll","cls":"Ext.util.Collection"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-clear","cls":"Ext.util.Collection"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-clone","cls":"Ext.util.Collection"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-contains","cls":"Ext.util.Collection"},{"type":"member","member":"containsKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-containsKey","cls":"Ext.util.Collection"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-each","cls":"Ext.util.Collection"},{"type":"member","member":"eachKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-eachKey","cls":"Ext.util.Collection"},{"type":"member","member":"filterBy","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-filterBy","cls":"Ext.util.Collection"},{"type":"member","member":"findBy","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-findBy","cls":"Ext.util.Collection"},{"type":"member","member":"findIndexBy","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-findIndexBy","cls":"Ext.util.Collection"},{"type":"member","member":"first","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-first","cls":"Ext.util.Collection"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-get","cls":"Ext.util.Collection"},{"type":"member","member":"getAt","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-getAt","cls":"Ext.util.Collection"},{"type":"member","member":"getByKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-getByKey","cls":"Ext.util.Collection"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-getCount","cls":"Ext.util.Collection"},{"type":"member","member":"getKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-getKey","cls":"Ext.util.Collection"},{"type":"member","member":"getRange","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-getRange","cls":"Ext.util.Collection"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-indexOf","cls":"Ext.util.Collection"},{"type":"member","member":"indexOfKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-indexOfKey","cls":"Ext.util.Collection"},{"type":"member","member":"insert","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-insert","cls":"Ext.util.Collection"},{"type":"member","member":"last","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-last","cls":"Ext.util.Collection"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-remove","cls":"Ext.util.Collection"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-removeAll","cls":"Ext.util.Collection"},{"type":"member","member":"removeAt","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-removeAt","cls":"Ext.util.Collection"},{"type":"member","member":"removeAtKey","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-removeAtKey","cls":"Ext.util.Collection"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"Ext.util.Collection-method-replace","cls":"Ext.util.Collection"},{"type":"member","member":"all","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-all","cls":"Ext.util.Collection"},{"type":"member","member":"indices","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-indices","cls":"Ext.util.Collection"},{"type":"member","member":"items","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-items","cls":"Ext.util.Collection"},{"type":"member","member":"keys","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-keys","cls":"Ext.util.Collection"},{"type":"member","member":"length","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-length","cls":"Ext.util.Collection"},{"type":"member","member":"map","icon":"property","private":false,"sort":3,"id":"Ext.util.Collection-property-map","cls":"Ext.util.Collection"},{"type":"class","member":"StoreManager","icon":"class","private":false,"sort":1,"id":"Ext.data.StoreManager","cls":"Ext.data.StoreManager"},{"type":"class","member":"StoreMgr","icon":"subclass","private":false,"sort":2,"id":"Ext.data.StoreManager","cls":"Ext.StoreMgr"},{"type":"class","member":"StoreMgr","icon":"subclass","private":false,"sort":2,"id":"Ext.data.StoreManager","cls":"Ext.data.StoreMgr"},{"type":"class","member":"StoreManager","icon":"subclass","private":false,"sort":2,"id":"Ext.data.StoreManager","cls":"Ext.StoreManager"},{"type":"member","member":"listeners","icon":"cfg","private":true,"sort":3,"id":"Ext.data.StoreManager-cfg-listeners","cls":"Ext.data.StoreManager"},{"type":"member","member":"lookup","icon":"method","private":false,"sort":3,"id":"Ext.data.StoreManager-method-lookup","cls":"Ext.data.StoreManager"},{"type":"member","member":"register","icon":"method","private":false,"sort":3,"id":"Ext.data.StoreManager-method-register","cls":"Ext.data.StoreManager"},{"type":"member","member":"unregister","icon":"method","private":false,"sort":3,"id":"Ext.data.StoreManager-method-unregister","cls":"Ext.data.StoreManager"},{"type":"class","member":"Format","icon":"class","private":false,"sort":1,"id":"Ext.util.Format","cls":"Ext.util.Format"},{"type":"member","member":"date","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-date","cls":"Ext.util.Format"},{"type":"member","member":"ellipsis","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-ellipsis","cls":"Ext.util.Format"},{"type":"member","member":"escape","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-escape","cls":"Ext.util.Format"},{"type":"member","member":"escapeRegex","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-escapeRegex","cls":"Ext.util.Format"},{"type":"member","member":"format","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-format","cls":"Ext.util.Format"},{"type":"member","member":"htmlDecode","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-htmlDecode","cls":"Ext.util.Format"},{"type":"member","member":"htmlEncode","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-htmlEncode","cls":"Ext.util.Format"},{"type":"member","member":"leftPad","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-leftPad","cls":"Ext.util.Format"},{"type":"member","member":"toggle","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-toggle","cls":"Ext.util.Format"},{"type":"member","member":"trim","icon":"method","private":false,"sort":3,"id":"Ext.util.Format-method-trim","cls":"Ext.util.Format"},{"type":"member","member":"defaultDateFormat","icon":"property","private":false,"sort":3,"id":"Ext.util.Format-property-defaultDateFormat","cls":"Ext.util.Format"},{"type":"class","member":"Template","icon":"class","private":false,"sort":1,"id":"Ext.Template","cls":"Ext.Template"},{"type":"member","member":"compiled","icon":"cfg","private":false,"sort":3,"id":"Ext.Template-cfg-compiled","cls":"Ext.Template"},{"type":"member","member":"disableFormats","icon":"cfg","private":false,"sort":3,"id":"Ext.Template-cfg-disableFormats","cls":"Ext.Template"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-constructor","cls":"Ext.Template"},{"type":"member","member":"append","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-append","cls":"Ext.Template"},{"type":"member","member":"apply","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-apply","cls":"Ext.Template"},{"type":"member","member":"applyOut","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-applyOut","cls":"Ext.Template"},{"type":"member","member":"applyTemplate","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-applyTemplate","cls":"Ext.Template"},{"type":"member","member":"compile","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-compile","cls":"Ext.Template"},{"type":"member","member":"insertAfter","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-insertAfter","cls":"Ext.Template"},{"type":"member","member":"insertBefore","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-insertBefore","cls":"Ext.Template"},{"type":"member","member":"insertFirst","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-insertFirst","cls":"Ext.Template"},{"type":"member","member":"overwrite","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-overwrite","cls":"Ext.Template"},{"type":"member","member":"set","icon":"method","private":false,"sort":3,"id":"Ext.Template-method-set","cls":"Ext.Template"},{"type":"member","member":"isTemplate","icon":"property","private":false,"sort":3,"id":"Ext.Template-property-isTemplate","cls":"Ext.Template"},{"type":"member","member":"from","icon":"method","private":false,"sort":3,"id":"Ext.Template-static-method-from","cls":"Ext.Template"},{"type":"class","member":"XTemplate","icon":"class","private":false,"sort":1,"id":"Ext.XTemplate","cls":"Ext.XTemplate"},{"type":"member","member":"compiled","icon":"cfg","private":false,"sort":3,"id":"Ext.XTemplate-cfg-compiled","cls":"Ext.XTemplate"},{"type":"member","member":"compile","icon":"method","private":false,"sort":3,"id":"Ext.XTemplate-method-compile","cls":"Ext.XTemplate"},{"type":"member","member":"getTpl","icon":"method","private":false,"sort":3,"id":"Ext.XTemplate-method-getTpl","cls":"Ext.XTemplate"},{"type":"class","member":"GeoLocation","icon":"class","private":false,"sort":1,"id":"Ext.util.GeoLocation","cls":"Ext.util.GeoLocation"},{"type":"member","member":"allowHighAccuracy","icon":"cfg","private":false,"sort":3,"id":"Ext.util.GeoLocation-cfg-allowHighAccuracy","cls":"Ext.util.GeoLocation"},{"type":"member","member":"autoUpdate","icon":"cfg","private":false,"sort":3,"id":"Ext.util.GeoLocation-cfg-autoUpdate","cls":"Ext.util.GeoLocation"},{"type":"member","member":"maximumAge","icon":"cfg","private":false,"sort":3,"id":"Ext.util.GeoLocation-cfg-maximumAge","cls":"Ext.util.GeoLocation"},{"type":"member","member":"timeout","icon":"cfg","private":false,"sort":3,"id":"Ext.util.GeoLocation-cfg-timeout","cls":"Ext.util.GeoLocation"},{"type":"member","member":"updateLocation","icon":"method","private":false,"sort":3,"id":"Ext.util.GeoLocation-method-updateLocation","cls":"Ext.util.GeoLocation"},{"type":"member","member":"locationerror","icon":"event","private":false,"sort":3,"id":"Ext.util.GeoLocation-event-locationerror","cls":"Ext.util.GeoLocation"},{"type":"member","member":"locationupdate","icon":"event","private":false,"sort":3,"id":"Ext.util.GeoLocation-event-locationupdate","cls":"Ext.util.GeoLocation"},{"type":"member","member":"accuracy","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-accuracy","cls":"Ext.util.GeoLocation"},{"type":"member","member":"altitude","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-altitude","cls":"Ext.util.GeoLocation"},{"type":"member","member":"altitudeAccuracy","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-altitudeAccuracy","cls":"Ext.util.GeoLocation"},{"type":"member","member":"heading","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-heading","cls":"Ext.util.GeoLocation"},{"type":"member","member":"latitude","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-latitude","cls":"Ext.util.GeoLocation"},{"type":"member","member":"longitude","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-longitude","cls":"Ext.util.GeoLocation"},{"type":"member","member":"speed","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-speed","cls":"Ext.util.GeoLocation"},{"type":"member","member":"timestamp","icon":"property","private":false,"sort":3,"id":"Ext.util.GeoLocation-property-timestamp","cls":"Ext.util.GeoLocation"},{"type":"class","member":"Grouper","icon":"class","private":true,"sort":1,"id":"Ext.util.Grouper","cls":"Ext.util.Grouper"},{"type":"member","member":"sortProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Grouper-cfg-sortProperty","cls":"Ext.util.Grouper"},{"type":"member","member":"defaultSortFn","icon":"method","private":true,"sort":3,"id":"Ext.util.Grouper-method-defaultSortFn","cls":"Ext.util.Grouper"},{"type":"member","member":"sorterFn","icon":"method","private":true,"sort":3,"id":"Ext.util.Grouper-method-sorterFn","cls":"Ext.util.Grouper"},{"type":"class","member":"HashMap","icon":"class","private":false,"sort":1,"id":"Ext.util.HashMap","cls":"Ext.util.HashMap"},{"type":"member","member":"keyFn","icon":"cfg","private":false,"sort":3,"id":"Ext.util.HashMap-cfg-keyFn","cls":"Ext.util.HashMap"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-constructor","cls":"Ext.util.HashMap"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-add","cls":"Ext.util.HashMap"},{"type":"member","member":"clear","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-clear","cls":"Ext.util.HashMap"},{"type":"member","member":"clone","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-clone","cls":"Ext.util.HashMap"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-contains","cls":"Ext.util.HashMap"},{"type":"member","member":"containsKey","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-containsKey","cls":"Ext.util.HashMap"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-each","cls":"Ext.util.HashMap"},{"type":"member","member":"findKey","icon":"method","private":true,"sort":3,"id":"Ext.util.HashMap-method-findKey","cls":"Ext.util.HashMap"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-get","cls":"Ext.util.HashMap"},{"type":"member","member":"getArray","icon":"method","private":true,"sort":3,"id":"Ext.util.HashMap-method-getArray","cls":"Ext.util.HashMap"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-getCount","cls":"Ext.util.HashMap"},{"type":"member","member":"getData","icon":"method","private":true,"sort":3,"id":"Ext.util.HashMap-method-getData","cls":"Ext.util.HashMap"},{"type":"member","member":"getKey","icon":"method","private":true,"sort":3,"id":"Ext.util.HashMap-method-getKey","cls":"Ext.util.HashMap"},{"type":"member","member":"getKeys","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-getKeys","cls":"Ext.util.HashMap"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-getValues","cls":"Ext.util.HashMap"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-remove","cls":"Ext.util.HashMap"},{"type":"member","member":"removeByKey","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-removeByKey","cls":"Ext.util.HashMap"},{"type":"member","member":"replace","icon":"method","private":false,"sort":3,"id":"Ext.util.HashMap-method-replace","cls":"Ext.util.HashMap"},{"type":"member","member":"add","icon":"event","private":false,"sort":3,"id":"Ext.util.HashMap-event-add","cls":"Ext.util.HashMap"},{"type":"member","member":"clear","icon":"event","private":false,"sort":3,"id":"Ext.util.HashMap-event-clear","cls":"Ext.util.HashMap"},{"type":"member","member":"remove","icon":"event","private":false,"sort":3,"id":"Ext.util.HashMap-event-remove","cls":"Ext.util.HashMap"},{"type":"member","member":"replace","icon":"event","private":false,"sort":3,"id":"Ext.util.HashMap-event-replace","cls":"Ext.util.HashMap"},{"type":"class","member":"AbstractManager","icon":"class","private":true,"sort":1,"id":"Ext.AbstractManager","cls":"Ext.AbstractManager"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-create","cls":"Ext.AbstractManager"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-each","cls":"Ext.AbstractManager"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-get","cls":"Ext.AbstractManager"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-getCount","cls":"Ext.AbstractManager"},{"type":"member","member":"isRegistered","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-isRegistered","cls":"Ext.AbstractManager"},{"type":"member","member":"onAvailable","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-onAvailable","cls":"Ext.AbstractManager"},{"type":"member","member":"register","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-register","cls":"Ext.AbstractManager"},{"type":"member","member":"registerType","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-registerType","cls":"Ext.AbstractManager"},{"type":"member","member":"unregister","icon":"method","private":false,"sort":3,"id":"Ext.AbstractManager-method-unregister","cls":"Ext.AbstractManager"},{"type":"member","member":"all","icon":"property","private":false,"sort":3,"id":"Ext.AbstractManager-property-all","cls":"Ext.AbstractManager"},{"type":"class","member":"ModelManager","icon":"class","private":false,"sort":1,"id":"Ext.data.ModelManager","cls":"Ext.data.ModelManager"},{"type":"class","member":"ModelMgr","icon":"subclass","private":false,"sort":2,"id":"Ext.data.ModelManager","cls":"Ext.ModelMgr"},{"type":"class","member":"ModelManager","icon":"subclass","private":false,"sort":2,"id":"Ext.data.ModelManager","cls":"Ext.ModelManager"},{"type":"member","member":"create","icon":"method","private":false,"sort":3,"id":"Ext.data.ModelManager-method-create","cls":"Ext.data.ModelManager"},{"type":"member","member":"getModel","icon":"method","private":false,"sort":3,"id":"Ext.data.ModelManager-method-getModel","cls":"Ext.data.ModelManager"},{"type":"member","member":"registerType","icon":"method","private":true,"sort":3,"id":"Ext.data.ModelManager-method-registerType","cls":"Ext.data.ModelManager"},{"type":"class","member":"NodeInterface","icon":"class","private":false,"sort":1,"id":"Ext.data.NodeInterface","cls":"Ext.data.NodeInterface"},{"type":"class","member":"Node","icon":"subclass","private":false,"sort":2,"id":"Ext.data.NodeInterface","cls":"Ext.data.Node"},{"type":"member","member":"appendChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-appendChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"bubble","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-bubble","cls":"Ext.data.NodeInterface"},{"type":"member","member":"cascadeBy","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-cascadeBy","cls":"Ext.data.NodeInterface"},{"type":"member","member":"clear","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeInterface-method-clear","cls":"Ext.data.NodeInterface"},{"type":"member","member":"collapse","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-collapse","cls":"Ext.data.NodeInterface"},{"type":"member","member":"contains","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-contains","cls":"Ext.data.NodeInterface"},{"type":"member","member":"copy","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-copy","cls":"Ext.data.NodeInterface"},{"type":"member","member":"createNode","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeInterface-method-createNode","cls":"Ext.data.NodeInterface"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-destroy","cls":"Ext.data.NodeInterface"},{"type":"member","member":"eachChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-eachChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"expand","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-expand","cls":"Ext.data.NodeInterface"},{"type":"member","member":"findChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-findChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"findChildBy","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-findChildBy","cls":"Ext.data.NodeInterface"},{"type":"member","member":"getBubbleTarget","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeInterface-method-getBubbleTarget","cls":"Ext.data.NodeInterface"},{"type":"member","member":"getChildAt","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-getChildAt","cls":"Ext.data.NodeInterface"},{"type":"member","member":"getDepth","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-getDepth","cls":"Ext.data.NodeInterface"},{"type":"member","member":"getPath","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-getPath","cls":"Ext.data.NodeInterface"},{"type":"member","member":"hasChildNodes","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-hasChildNodes","cls":"Ext.data.NodeInterface"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-indexOf","cls":"Ext.data.NodeInterface"},{"type":"member","member":"insertBefore","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-insertBefore","cls":"Ext.data.NodeInterface"},{"type":"member","member":"insertChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-insertChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isAncestor","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isAncestor","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isExpandable","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isExpandable","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isExpanded","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isExpanded","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isFirst","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isFirst","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isLast","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isLast","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isLeaf","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isLeaf","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isLoaded","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isLoaded","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isLoading","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isLoading","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isRoot","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isRoot","cls":"Ext.data.NodeInterface"},{"type":"member","member":"isVisible","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-isVisible","cls":"Ext.data.NodeInterface"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-remove","cls":"Ext.data.NodeInterface"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-removeAll","cls":"Ext.data.NodeInterface"},{"type":"member","member":"removeChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-removeChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"replaceChild","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-replaceChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"setFirstChild","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeInterface-method-setFirstChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"setLastChild","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeInterface-method-setLastChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-sort","cls":"Ext.data.NodeInterface"},{"type":"member","member":"updateInfo","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-method-updateInfo","cls":"Ext.data.NodeInterface"},{"type":"member","member":"append","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-append","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforeappend","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforeappend","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforecollapse","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforecollapse","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforeexpand","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforeexpand","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforeinsert","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforeinsert","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforemove","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforemove","cls":"Ext.data.NodeInterface"},{"type":"member","member":"beforeremove","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-beforeremove","cls":"Ext.data.NodeInterface"},{"type":"member","member":"collapse","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-collapse","cls":"Ext.data.NodeInterface"},{"type":"member","member":"expand","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-expand","cls":"Ext.data.NodeInterface"},{"type":"member","member":"insert","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-insert","cls":"Ext.data.NodeInterface"},{"type":"member","member":"move","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-move","cls":"Ext.data.NodeInterface"},{"type":"member","member":"remove","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-remove","cls":"Ext.data.NodeInterface"},{"type":"member","member":"sort","icon":"event","private":false,"sort":3,"id":"Ext.data.NodeInterface-event-sort","cls":"Ext.data.NodeInterface"},{"type":"member","member":"childNodes","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-childNodes","cls":"Ext.data.NodeInterface"},{"type":"member","member":"firstChild","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-firstChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"lastChild","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-lastChild","cls":"Ext.data.NodeInterface"},{"type":"member","member":"nextSibling","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-nextSibling","cls":"Ext.data.NodeInterface"},{"type":"member","member":"parentNode","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-parentNode","cls":"Ext.data.NodeInterface"},{"type":"member","member":"previousSibling","icon":"property","private":false,"sort":3,"id":"Ext.data.NodeInterface-property-previousSibling","cls":"Ext.data.NodeInterface"},{"type":"member","member":"decorate","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeInterface-static-method-decorate","cls":"Ext.data.NodeInterface"},{"type":"class","member":"Association","icon":"class","private":false,"sort":1,"id":"Ext.data.association.Association","cls":"Ext.data.association.Association"},{"type":"class","member":"Association","icon":"subclass","private":false,"sort":2,"id":"Ext.data.association.Association","cls":"Ext.data.Association"},{"type":"member","member":"associatedModel","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-associatedModel","cls":"Ext.data.association.Association"},{"type":"member","member":"associationKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-associationKey","cls":"Ext.data.association.Association"},{"type":"member","member":"ownerModel","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-ownerModel","cls":"Ext.data.association.Association"},{"type":"member","member":"primaryKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-primaryKey","cls":"Ext.data.association.Association"},{"type":"member","member":"reader","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-reader","cls":"Ext.data.association.Association"},{"type":"member","member":"type","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.Association-cfg-type","cls":"Ext.data.association.Association"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.association.Association-method-constructor","cls":"Ext.data.association.Association"},{"type":"class","member":"BelongsTo","icon":"class","private":false,"sort":1,"id":"Ext.data.association.BelongsTo","cls":"Ext.data.association.BelongsTo"},{"type":"class","member":"BelongsToAssociation","icon":"subclass","private":false,"sort":2,"id":"Ext.data.association.BelongsTo","cls":"Ext.data.BelongsToAssociation"},{"type":"class","member":"belongsto","icon":"subclass","private":false,"sort":0,"id":"Ext.data.association.BelongsTo","cls":"association: belongsto"},{"type":"member","member":"foreignKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.BelongsTo-cfg-foreignKey","cls":"Ext.data.association.BelongsTo"},{"type":"member","member":"getterName","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.BelongsTo-cfg-getterName","cls":"Ext.data.association.BelongsTo"},{"type":"member","member":"setterName","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.BelongsTo-cfg-setterName","cls":"Ext.data.association.BelongsTo"},{"type":"member","member":"createGetter","icon":"method","private":true,"sort":3,"id":"Ext.data.association.BelongsTo-method-createGetter","cls":"Ext.data.association.BelongsTo"},{"type":"member","member":"createSetter","icon":"method","private":true,"sort":3,"id":"Ext.data.association.BelongsTo-method-createSetter","cls":"Ext.data.association.BelongsTo"},{"type":"member","member":"read","icon":"method","private":true,"sort":3,"id":"Ext.data.association.BelongsTo-method-read","cls":"Ext.data.association.BelongsTo"},{"type":"class","member":"HasMany","icon":"class","private":false,"sort":1,"id":"Ext.data.association.HasMany","cls":"Ext.data.association.HasMany"},{"type":"class","member":"HasManyAssociation","icon":"subclass","private":false,"sort":2,"id":"Ext.data.association.HasMany","cls":"Ext.data.HasManyAssociation"},{"type":"class","member":"hasmany","icon":"subclass","private":false,"sort":0,"id":"Ext.data.association.HasMany","cls":"association: hasmany"},{"type":"member","member":"autoLoad","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-autoLoad","cls":"Ext.data.association.HasMany"},{"type":"member","member":"filterProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-filterProperty","cls":"Ext.data.association.HasMany"},{"type":"member","member":"foreignKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-foreignKey","cls":"Ext.data.association.HasMany"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-name","cls":"Ext.data.association.HasMany"},{"type":"member","member":"store","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-store","cls":"Ext.data.association.HasMany"},{"type":"member","member":"storeName","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasMany-cfg-storeName","cls":"Ext.data.association.HasMany"},{"type":"member","member":"applyStore","icon":"method","private":true,"sort":3,"id":"Ext.data.association.HasMany-method-applyStore","cls":"Ext.data.association.HasMany"},{"type":"member","member":"read","icon":"method","private":true,"sort":3,"id":"Ext.data.association.HasMany-method-read","cls":"Ext.data.association.HasMany"},{"type":"class","member":"HasOne","icon":"class","private":false,"sort":1,"id":"Ext.data.association.HasOne","cls":"Ext.data.association.HasOne"},{"type":"class","member":"HasOneAssociation","icon":"subclass","private":false,"sort":2,"id":"Ext.data.association.HasOne","cls":"Ext.data.HasOneAssociation"},{"type":"class","member":"hasone","icon":"subclass","private":false,"sort":0,"id":"Ext.data.association.HasOne","cls":"association: hasone"},{"type":"member","member":"foreignKey","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasOne-cfg-foreignKey","cls":"Ext.data.association.HasOne"},{"type":"member","member":"getterName","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasOne-cfg-getterName","cls":"Ext.data.association.HasOne"},{"type":"member","member":"setterName","icon":"cfg","private":false,"sort":3,"id":"Ext.data.association.HasOne-cfg-setterName","cls":"Ext.data.association.HasOne"},{"type":"member","member":"createGetter","icon":"method","private":true,"sort":3,"id":"Ext.data.association.HasOne-method-createGetter","cls":"Ext.data.association.HasOne"},{"type":"member","member":"createSetter","icon":"method","private":true,"sort":3,"id":"Ext.data.association.HasOne-method-createSetter","cls":"Ext.data.association.HasOne"},{"type":"member","member":"read","icon":"method","private":true,"sort":3,"id":"Ext.data.association.HasOne-method-read","cls":"Ext.data.association.HasOne"},{"type":"class","member":"LineSegment","icon":"class","private":false,"sort":1,"id":"Ext.util.LineSegment","cls":"Ext.util.LineSegment"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.LineSegment-method-constructor","cls":"Ext.util.LineSegment"},{"type":"member","member":"intersects","icon":"method","private":false,"sort":3,"id":"Ext.util.LineSegment-method-intersects","cls":"Ext.util.LineSegment"},{"type":"member","member":"toString","icon":"method","private":false,"sort":3,"id":"Ext.util.LineSegment-method-toString","cls":"Ext.util.LineSegment"},{"type":"class","member":"SizeMonitor","icon":"class","private":true,"sort":1,"id":"Ext.util.SizeMonitor","cls":"Ext.util.SizeMonitor"},{"type":"class","member":"Scroller","icon":"class","private":false,"sort":1,"id":"Ext.scroll.Scroller","cls":"Ext.scroll.Scroller"},{"type":"class","member":"Scroller","icon":"subclass","private":false,"sort":2,"id":"Ext.scroll.Scroller","cls":"Ext.util.Scroller"},{"type":"member","member":"acceleration","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-acceleration","cls":"Ext.scroll.Scroller"},{"type":"member","member":"autoRefresh","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-autoRefresh","cls":"Ext.scroll.Scroller"},{"type":"member","member":"cls","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-cls","cls":"Ext.scroll.Scroller"},{"type":"member","member":"containerCls","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-containerCls","cls":"Ext.scroll.Scroller"},{"type":"member","member":"containerScrollSize","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-containerScrollSize","cls":"Ext.scroll.Scroller"},{"type":"member","member":"containerSize","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-containerSize","cls":"Ext.scroll.Scroller"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-direction","cls":"Ext.scroll.Scroller"},{"type":"member","member":"directionLock","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-directionLock","cls":"Ext.scroll.Scroller"},{"type":"member","member":"disabled","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-disabled","cls":"Ext.scroll.Scroller"},{"type":"member","member":"element","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-element","cls":"Ext.scroll.Scroller"},{"type":"member","member":"fps","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-fps","cls":"Ext.scroll.Scroller"},{"type":"member","member":"friction","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-friction","cls":"Ext.scroll.Scroller"},{"type":"member","member":"initialOffset","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-initialOffset","cls":"Ext.scroll.Scroller"},{"type":"member","member":"maxAbsoluteVelocity","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-maxAbsoluteVelocity","cls":"Ext.scroll.Scroller"},{"type":"member","member":"momentumEasing","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-momentumEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"outOfBoundRestrictFactor","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-outOfBoundRestrictFactor","cls":"Ext.scroll.Scroller"},{"type":"member","member":"size","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-size","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snap","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.Scroller-cfg-snap","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snapEasing","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-snapEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snapOffset","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-snapOffset","cls":"Ext.scroll.Scroller"},{"type":"member","member":"startMomentumResetTime","icon":"cfg","private":true,"sort":3,"id":"Ext.scroll.Scroller-cfg-startMomentumResetTime","cls":"Ext.scroll.Scroller"},{"type":"member","member":"constructor","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-constructor","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applyContainerScrollSize","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applyContainerScrollSize","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applyContainerSize","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applyContainerSize","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applyDirection","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applyDirection","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applyElement","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applyElement","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applyMomentumEasing","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applyMomentumEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applySize","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applySize","cls":"Ext.scroll.Scroller"},{"type":"member","member":"applySnapEasing","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-applySnapEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"attachListeneners","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-attachListeneners","cls":"Ext.scroll.Scroller"},{"type":"member","member":"detachListeners","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-detachListeners","cls":"Ext.scroll.Scroller"},{"type":"member","member":"doAnimationFrame","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-doAnimationFrame","cls":"Ext.scroll.Scroller"},{"type":"member","member":"doRefresh","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-doRefresh","cls":"Ext.scroll.Scroller"},{"type":"member","member":"doScrollTo","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-doScrollTo","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getContainer","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-getContainer","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getDirection","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getDirectionLock","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getDirectionLock","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getDisabled","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getDisabled","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getFps","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getFps","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getMaxPosition","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-getMaxPosition","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getMinPosition","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-getMinPosition","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getMomentumEasing","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getMomentumEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"getSnap","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-getSnap","cls":"Ext.scroll.Scroller"},{"type":"member","member":"isAxisEnabled","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-isAxisEnabled","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onAfterInitialized","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onAfterInitialized","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onAxisDrag","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onAxisDrag","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onDrag","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onDrag","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onDragEnd","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onDragEnd","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onDragStart","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onDragStart","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onScrollEnd","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onScrollEnd","cls":"Ext.scroll.Scroller"},{"type":"member","member":"onTouchStart","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-onTouchStart","cls":"Ext.scroll.Scroller"},{"type":"member","member":"prepareAnimation","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-prepareAnimation","cls":"Ext.scroll.Scroller"},{"type":"member","member":"prepareSnapAnimation","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-prepareSnapAnimation","cls":"Ext.scroll.Scroller"},{"type":"member","member":"refresh","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-refresh","cls":"Ext.scroll.Scroller"},{"type":"member","member":"refreshMaxPosition","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-refreshMaxPosition","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollBy","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollBy","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollByAnimated","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollByAnimated","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollTo","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollTo","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollToAnimated","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollToAnimated","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollToEnd","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollToEnd","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollToEndAnimated","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-scrollToEndAnimated","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollToTop","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-scrollToTop","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setDirection","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setDirectionLock","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setDirectionLock","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setDisabled","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setDisabled","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setFps","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setFps","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setMomentumEasing","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setMomentumEasing","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setOffset","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setOffset","cls":"Ext.scroll.Scroller"},{"type":"member","member":"setSnap","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-setSnap","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snapToBoundary","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-snapToBoundary","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snapToSlot","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-snapToSlot","cls":"Ext.scroll.Scroller"},{"type":"member","member":"snapValueForAxis","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-snapValueForAxis","cls":"Ext.scroll.Scroller"},{"type":"member","member":"startAnimation","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-startAnimation","cls":"Ext.scroll.Scroller"},{"type":"member","member":"stopAnimation","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-stopAnimation","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateAutoRefresh","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-updateAutoRefresh","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateBoundary","icon":"method","private":false,"sort":3,"id":"Ext.scroll.Scroller-method-updateBoundary","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateDirection","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-updateDirection","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateDisabled","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-updateDisabled","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateElement","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-updateElement","cls":"Ext.scroll.Scroller"},{"type":"member","member":"updateFps","icon":"method","private":true,"sort":3,"id":"Ext.scroll.Scroller-method-updateFps","cls":"Ext.scroll.Scroller"},{"type":"member","member":"maxpositionchange","icon":"event","private":false,"sort":3,"id":"Ext.scroll.Scroller-event-maxpositionchange","cls":"Ext.scroll.Scroller"},{"type":"member","member":"refresh","icon":"event","private":false,"sort":3,"id":"Ext.scroll.Scroller-event-refresh","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scroll","icon":"event","private":false,"sort":3,"id":"Ext.scroll.Scroller-event-scroll","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollend","icon":"event","private":false,"sort":3,"id":"Ext.scroll.Scroller-event-scrollend","cls":"Ext.scroll.Scroller"},{"type":"member","member":"scrollstart","icon":"event","private":false,"sort":3,"id":"Ext.scroll.Scroller-event-scrollstart","cls":"Ext.scroll.Scroller"},{"type":"class","member":"Sortable","icon":"class","private":false,"sort":1,"id":"Ext.util.Sortable","cls":"Ext.util.Sortable"},{"type":"member","member":"decodeSorters","icon":"method","private":true,"sort":3,"id":"Ext.util.Sortable-method-decodeSorters","cls":"Ext.util.Sortable"},{"type":"member","member":"initSortable","icon":"method","private":false,"sort":3,"id":"Ext.util.Sortable-method-initSortable","cls":"Ext.util.Sortable"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Ext.util.Sortable-method-sort","cls":"Ext.util.Sortable"},{"type":"member","member":"defaultSortDirection","icon":"property","private":false,"sort":3,"id":"Ext.util.Sortable-property-defaultSortDirection","cls":"Ext.util.Sortable"},{"type":"member","member":"isSortable","icon":"property","private":false,"sort":3,"id":"Ext.util.Sortable-property-isSortable","cls":"Ext.util.Sortable"},{"type":"member","member":"sortRoot","icon":"property","private":false,"sort":3,"id":"Ext.util.Sortable-property-sortRoot","cls":"Ext.util.Sortable"},{"type":"member","member":"sorters","icon":"property","private":false,"sort":3,"id":"Ext.util.Sortable-property-sorters","cls":"Ext.util.Sortable"},{"type":"class","member":"MixedCollection","icon":"class","private":false,"sort":1,"id":"Ext.util.MixedCollection","cls":"Ext.util.MixedCollection"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.MixedCollection-method-constructor","cls":"Ext.util.MixedCollection"},{"type":"member","member":"_sort","icon":"method","private":true,"sort":3,"id":"Ext.util.MixedCollection-method-_sort","cls":"Ext.util.MixedCollection"},{"type":"member","member":"reorder","icon":"method","private":false,"sort":3,"id":"Ext.util.MixedCollection-method-reorder","cls":"Ext.util.MixedCollection"},{"type":"member","member":"sortBy","icon":"method","private":false,"sort":3,"id":"Ext.util.MixedCollection-method-sortBy","cls":"Ext.util.MixedCollection"},{"type":"member","member":"sortByKey","icon":"method","private":false,"sort":3,"id":"Ext.util.MixedCollection-method-sortByKey","cls":"Ext.util.MixedCollection"},{"type":"member","member":"sort","icon":"event","private":false,"sort":3,"id":"Ext.util.MixedCollection-event-sort","cls":"Ext.util.MixedCollection"},{"type":"class","member":"ItemCollection","icon":"class","private":true,"sort":1,"id":"Ext.ItemCollection","cls":"Ext.ItemCollection"},{"type":"class","member":"Error","icon":"class","private":false,"sort":1,"id":"Ext.data.Error","cls":"Ext.data.Error"},{"type":"member","member":"field","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Error-cfg-field","cls":"Ext.data.Error"},{"type":"member","member":"message","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Error-cfg-message","cls":"Ext.data.Error"},{"type":"class","member":"Errors","icon":"class","private":false,"sort":1,"id":"Ext.data.Errors","cls":"Ext.data.Errors"},{"type":"member","member":"getByField","icon":"method","private":false,"sort":3,"id":"Ext.data.Errors-method-getByField","cls":"Ext.data.Errors"},{"type":"member","member":"isValid","icon":"method","private":false,"sort":3,"id":"Ext.data.Errors-method-isValid","cls":"Ext.data.Errors"},{"type":"class","member":"Ajax","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.Ajax","cls":"Ext.data.proxy.Ajax"},{"type":"class","member":"HttpProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Ajax","cls":"Ext.data.HttpProxy"},{"type":"class","member":"AjaxProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Ajax","cls":"Ext.data.AjaxProxy"},{"type":"class","member":"ajax","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.Ajax","cls":"proxy: ajax"},{"type":"member","member":"headers","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Ajax-cfg-headers","cls":"Ext.data.proxy.Ajax"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Ajax-method-constructor","cls":"Ext.data.proxy.Ajax"},{"type":"member","member":"createRequestCallback","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Ajax-method-createRequestCallback","cls":"Ext.data.proxy.Ajax"},{"type":"member","member":"doRequest","icon":"method","private":true,"sort":3,"id":"Ext.data.proxy.Ajax-method-doRequest","cls":"Ext.data.proxy.Ajax"},{"type":"member","member":"getMethod","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Ajax-method-getMethod","cls":"Ext.data.proxy.Ajax"},{"type":"member","member":"actionMethods","icon":"property","private":false,"sort":3,"id":"Ext.data.proxy.Ajax-property-actionMethods","cls":"Ext.data.proxy.Ajax"},{"type":"class","member":"Model","icon":"class","private":false,"sort":1,"id":"Ext.data.Model","cls":"Ext.data.Model"},{"type":"class","member":"Record","icon":"subclass","private":false,"sort":2,"id":"Ext.data.Model","cls":"Ext.data.Record"},{"type":"member","member":"associations","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-associations","cls":"Ext.data.Model"},{"type":"member","member":"belongsTo","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-belongsTo","cls":"Ext.data.Model"},{"type":"member","member":"clientIdProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-clientIdProperty","cls":"Ext.data.Model"},{"type":"member","member":"fields","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-fields","cls":"Ext.data.Model"},{"type":"member","member":"hasMany","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-hasMany","cls":"Ext.data.Model"},{"type":"member","member":"hasOne","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-hasOne","cls":"Ext.data.Model"},{"type":"member","member":"idProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-idProperty","cls":"Ext.data.Model"},{"type":"member","member":"proxy","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-proxy","cls":"Ext.data.Model"},{"type":"member","member":"validations","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Model-cfg-validations","cls":"Ext.data.Model"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-constructor","cls":"Ext.data.Model"},{"type":"member","member":"afterCommit","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-afterCommit","cls":"Ext.data.Model"},{"type":"member","member":"afterEdit","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-afterEdit","cls":"Ext.data.Model"},{"type":"member","member":"afterReject","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-afterReject","cls":"Ext.data.Model"},{"type":"member","member":"beginEdit","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-beginEdit","cls":"Ext.data.Model"},{"type":"member","member":"cancelEdit","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-cancelEdit","cls":"Ext.data.Model"},{"type":"member","member":"changedWhileEditing","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-changedWhileEditing","cls":"Ext.data.Model"},{"type":"member","member":"commit","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-commit","cls":"Ext.data.Model"},{"type":"member","member":"copy","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-copy","cls":"Ext.data.Model"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-destroy","cls":"Ext.data.Model"},{"type":"member","member":"endEdit","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-endEdit","cls":"Ext.data.Model"},{"type":"member","member":"erase","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-erase","cls":"Ext.data.Model"},{"type":"member","member":"get","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-get","cls":"Ext.data.Model"},{"type":"member","member":"getAssociatedData","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getAssociatedData","cls":"Ext.data.Model"},{"type":"member","member":"getChanges","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getChanges","cls":"Ext.data.Model"},{"type":"member","member":"getClientIdProperty","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getClientIdProperty","cls":"Ext.data.Model"},{"type":"member","member":"getData","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getData","cls":"Ext.data.Model"},{"type":"member","member":"getFieldName","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-getFieldName","cls":"Ext.data.Model"},{"type":"member","member":"getFields","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getFields","cls":"Ext.data.Model"},{"type":"member","member":"getId","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getId","cls":"Ext.data.Model"},{"type":"member","member":"getIsErased","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getIsErased","cls":"Ext.data.Model"},{"type":"member","member":"getProxy","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-getProxy","cls":"Ext.data.Model"},{"type":"member","member":"isEqual","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-isEqual","cls":"Ext.data.Model"},{"type":"member","member":"isModified","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-isModified","cls":"Ext.data.Model"},{"type":"member","member":"isValid","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-isValid","cls":"Ext.data.Model"},{"type":"member","member":"join","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-join","cls":"Ext.data.Model"},{"type":"member","member":"mergeData","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-mergeData","cls":"Ext.data.Model"},{"type":"member","member":"notifyStores","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-notifyStores","cls":"Ext.data.Model"},{"type":"member","member":"onClassExtended","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-onClassExtended","cls":"Ext.data.Model"},{"type":"member","member":"prepareAssociatedData","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-prepareAssociatedData","cls":"Ext.data.Model"},{"type":"member","member":"reject","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-reject","cls":"Ext.data.Model"},{"type":"member","member":"save","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-save","cls":"Ext.data.Model"},{"type":"member","member":"set","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-set","cls":"Ext.data.Model"},{"type":"member","member":"setClientIdProperty","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setClientIdProperty","cls":"Ext.data.Model"},{"type":"member","member":"setConvertedData","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setConvertedData","cls":"Ext.data.Model"},{"type":"member","member":"setData","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setData","cls":"Ext.data.Model"},{"type":"member","member":"setDirty","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setDirty","cls":"Ext.data.Model"},{"type":"member","member":"setFields","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setFields","cls":"Ext.data.Model"},{"type":"member","member":"setId","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setId","cls":"Ext.data.Model"},{"type":"member","member":"setProxy","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-setProxy","cls":"Ext.data.Model"},{"type":"member","member":"sortConvertFields","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-sortConvertFields","cls":"Ext.data.Model"},{"type":"member","member":"toUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-toUrl","cls":"Ext.data.Model"},{"type":"member","member":"unjoin","icon":"method","private":true,"sort":3,"id":"Ext.data.Model-method-unjoin","cls":"Ext.data.Model"},{"type":"member","member":"validate","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-method-validate","cls":"Ext.data.Model"},{"type":"member","member":"associations","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-associations","cls":"Ext.data.Model"},{"type":"member","member":"dirty","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-dirty","cls":"Ext.data.Model"},{"type":"member","member":"editing","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-editing","cls":"Ext.data.Model"},{"type":"member","member":"fields","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-fields","cls":"Ext.data.Model"},{"type":"member","member":"modified","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-modified","cls":"Ext.data.Model"},{"type":"member","member":"phantom","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-phantom","cls":"Ext.data.Model"},{"type":"member","member":"raw","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-raw","cls":"Ext.data.Model"},{"type":"member","member":"stores","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-stores","cls":"Ext.data.Model"},{"type":"member","member":"validations","icon":"property","private":false,"sort":3,"id":"Ext.data.Model-property-validations","cls":"Ext.data.Model"},{"type":"member","member":"load","icon":"method","private":false,"sort":3,"id":"Ext.data.Model-static-method-load","cls":"Ext.data.Model"},{"type":"class","member":"Store","icon":"class","private":false,"sort":1,"id":"Ext.data.Store","cls":"Ext.data.Store"},{"type":"class","member":"store","icon":"subclass","private":false,"sort":0,"id":"Ext.data.Store","cls":"store: store"},{"type":"member","member":"autoDestroy","icon":"cfg","private":true,"sort":3,"id":"Ext.data.Store-cfg-autoDestroy","cls":"Ext.data.Store"},{"type":"member","member":"autoLoad","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-autoLoad","cls":"Ext.data.Store"},{"type":"member","member":"autoSync","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-autoSync","cls":"Ext.data.Store"},{"type":"member","member":"clearOnPageLoad","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-clearOnPageLoad","cls":"Ext.data.Store"},{"type":"member","member":"data","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-data","cls":"Ext.data.Store"},{"type":"member","member":"fields","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-fields","cls":"Ext.data.Store"},{"type":"member","member":"filters","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-filters","cls":"Ext.data.Store"},{"type":"member","member":"getGroupString","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-getGroupString","cls":"Ext.data.Store"},{"type":"member","member":"groupDir","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-groupDir","cls":"Ext.data.Store"},{"type":"member","member":"groupField","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-groupField","cls":"Ext.data.Store"},{"type":"member","member":"grouper","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-grouper","cls":"Ext.data.Store"},{"type":"member","member":"model","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-model","cls":"Ext.data.Store"},{"type":"member","member":"pageSize","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-pageSize","cls":"Ext.data.Store"},{"type":"member","member":"proxy","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-proxy","cls":"Ext.data.Store"},{"type":"member","member":"remoteFilter","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-remoteFilter","cls":"Ext.data.Store"},{"type":"member","member":"remoteGroup","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-remoteGroup","cls":"Ext.data.Store"},{"type":"member","member":"remoteSort","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-remoteSort","cls":"Ext.data.Store"},{"type":"member","member":"sorters","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-sorters","cls":"Ext.data.Store"},{"type":"member","member":"storeId","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-storeId","cls":"Ext.data.Store"},{"type":"member","member":"syncRemovedRecords","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-syncRemovedRecords","cls":"Ext.data.Store"},{"type":"member","member":"totalCount","icon":"cfg","private":false,"sort":3,"id":"Ext.data.Store-cfg-totalCount","cls":"Ext.data.Store"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-add","cls":"Ext.data.Store"},{"type":"member","member":"afterCommit","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-afterCommit","cls":"Ext.data.Store"},{"type":"member","member":"afterEdit","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-afterEdit","cls":"Ext.data.Store"},{"type":"member","member":"afterErase","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-afterErase","cls":"Ext.data.Store"},{"type":"member","member":"afterReject","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-afterReject","cls":"Ext.data.Store"},{"type":"member","member":"applyData","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-applyData","cls":"Ext.data.Store"},{"type":"member","member":"average","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-average","cls":"Ext.data.Store"},{"type":"member","member":"clearFilter","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-clearFilter","cls":"Ext.data.Store"},{"type":"member","member":"each","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-each","cls":"Ext.data.Store"},{"type":"member","member":"filter","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-filter","cls":"Ext.data.Store"},{"type":"member","member":"filterBy","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-filterBy","cls":"Ext.data.Store"},{"type":"member","member":"find","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-find","cls":"Ext.data.Store"},{"type":"member","member":"findBy","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-findBy","cls":"Ext.data.Store"},{"type":"member","member":"findExact","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-findExact","cls":"Ext.data.Store"},{"type":"member","member":"findRecord","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-findRecord","cls":"Ext.data.Store"},{"type":"member","member":"first","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-first","cls":"Ext.data.Store"},{"type":"member","member":"getAt","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getAt","cls":"Ext.data.Store"},{"type":"member","member":"getAutoLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getAutoLoad","cls":"Ext.data.Store"},{"type":"member","member":"getAutoSync","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getAutoSync","cls":"Ext.data.Store"},{"type":"member","member":"getBatchListeners","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-getBatchListeners","cls":"Ext.data.Store"},{"type":"member","member":"getById","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getById","cls":"Ext.data.Store"},{"type":"member","member":"getClearOnPageLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getClearOnPageLoad","cls":"Ext.data.Store"},{"type":"member","member":"getCount","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getCount","cls":"Ext.data.Store"},{"type":"member","member":"getData","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getData","cls":"Ext.data.Store"},{"type":"member","member":"getFields","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getFields","cls":"Ext.data.Store"},{"type":"member","member":"getFilters","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getFilters","cls":"Ext.data.Store"},{"type":"member","member":"getGetGroupString","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getGetGroupString","cls":"Ext.data.Store"},{"type":"member","member":"getGroupDir","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getGroupDir","cls":"Ext.data.Store"},{"type":"member","member":"getGroupField","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getGroupField","cls":"Ext.data.Store"},{"type":"member","member":"getGrouper","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getGrouper","cls":"Ext.data.Store"},{"type":"member","member":"getGroups","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getGroups","cls":"Ext.data.Store"},{"type":"member","member":"getModel","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getModel","cls":"Ext.data.Store"},{"type":"member","member":"getNewRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getNewRecords","cls":"Ext.data.Store"},{"type":"member","member":"getPageSize","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getPageSize","cls":"Ext.data.Store"},{"type":"member","member":"getProxy","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getProxy","cls":"Ext.data.Store"},{"type":"member","member":"getRange","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getRange","cls":"Ext.data.Store"},{"type":"member","member":"getRemoteFilter","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getRemoteFilter","cls":"Ext.data.Store"},{"type":"member","member":"getRemoteGroup","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getRemoteGroup","cls":"Ext.data.Store"},{"type":"member","member":"getRemoteSort","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getRemoteSort","cls":"Ext.data.Store"},{"type":"member","member":"getRemovedRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getRemovedRecords","cls":"Ext.data.Store"},{"type":"member","member":"getSorters","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getSorters","cls":"Ext.data.Store"},{"type":"member","member":"getStoreId","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getStoreId","cls":"Ext.data.Store"},{"type":"member","member":"getUpdatedRecords","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-getUpdatedRecords","cls":"Ext.data.Store"},{"type":"member","member":"indexOf","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-indexOf","cls":"Ext.data.Store"},{"type":"member","member":"indexOfId","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-indexOfId","cls":"Ext.data.Store"},{"type":"member","member":"insert","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-insert","cls":"Ext.data.Store"},{"type":"member","member":"isAutoLoading","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-isAutoLoading","cls":"Ext.data.Store"},{"type":"member","member":"isFiltered","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-isFiltered","cls":"Ext.data.Store"},{"type":"member","member":"isGrouped","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-isGrouped","cls":"Ext.data.Store"},{"type":"member","member":"isLoading","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-isLoading","cls":"Ext.data.Store"},{"type":"member","member":"last","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-last","cls":"Ext.data.Store"},{"type":"member","member":"load","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-load","cls":"Ext.data.Store"},{"type":"member","member":"loadData","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-loadData","cls":"Ext.data.Store"},{"type":"member","member":"loadPage","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-loadPage","cls":"Ext.data.Store"},{"type":"member","member":"max","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-max","cls":"Ext.data.Store"},{"type":"member","member":"min","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-min","cls":"Ext.data.Store"},{"type":"member","member":"nextPage","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-nextPage","cls":"Ext.data.Store"},{"type":"member","member":"onBatchComplete","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-onBatchComplete","cls":"Ext.data.Store"},{"type":"member","member":"onProxyLoad","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-onProxyLoad","cls":"Ext.data.Store"},{"type":"member","member":"onProxyWrite","icon":"method","private":true,"sort":3,"id":"Ext.data.Store-method-onProxyWrite","cls":"Ext.data.Store"},{"type":"member","member":"previousPage","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-previousPage","cls":"Ext.data.Store"},{"type":"member","member":"queryBy","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-queryBy","cls":"Ext.data.Store"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-remove","cls":"Ext.data.Store"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-removeAll","cls":"Ext.data.Store"},{"type":"member","member":"removeAt","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-removeAt","cls":"Ext.data.Store"},{"type":"member","member":"setAutoLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setAutoLoad","cls":"Ext.data.Store"},{"type":"member","member":"setAutoSync","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setAutoSync","cls":"Ext.data.Store"},{"type":"member","member":"setClearOnPageLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setClearOnPageLoad","cls":"Ext.data.Store"},{"type":"member","member":"setData","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setData","cls":"Ext.data.Store"},{"type":"member","member":"setFields","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setFields","cls":"Ext.data.Store"},{"type":"member","member":"setFilters","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setFilters","cls":"Ext.data.Store"},{"type":"member","member":"setGetGroupString","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setGetGroupString","cls":"Ext.data.Store"},{"type":"member","member":"setGroupDir","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setGroupDir","cls":"Ext.data.Store"},{"type":"member","member":"setGroupField","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setGroupField","cls":"Ext.data.Store"},{"type":"member","member":"setGrouper","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setGrouper","cls":"Ext.data.Store"},{"type":"member","member":"setModel","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setModel","cls":"Ext.data.Store"},{"type":"member","member":"setPageSize","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setPageSize","cls":"Ext.data.Store"},{"type":"member","member":"setProxy","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setProxy","cls":"Ext.data.Store"},{"type":"member","member":"setRemoteFilter","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setRemoteFilter","cls":"Ext.data.Store"},{"type":"member","member":"setRemoteGroup","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setRemoteGroup","cls":"Ext.data.Store"},{"type":"member","member":"setRemoteSort","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setRemoteSort","cls":"Ext.data.Store"},{"type":"member","member":"setSorters","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setSorters","cls":"Ext.data.Store"},{"type":"member","member":"setStoreId","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-setStoreId","cls":"Ext.data.Store"},{"type":"member","member":"sort","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-sort","cls":"Ext.data.Store"},{"type":"member","member":"sum","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-sum","cls":"Ext.data.Store"},{"type":"member","member":"sync","icon":"method","private":false,"sort":3,"id":"Ext.data.Store-method-sync","cls":"Ext.data.Store"},{"type":"member","member":"addrecords","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-addrecords","cls":"Ext.data.Store"},{"type":"member","member":"beforeload","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-beforeload","cls":"Ext.data.Store"},{"type":"member","member":"beforesync","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-beforesync","cls":"Ext.data.Store"},{"type":"member","member":"clear","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-clear","cls":"Ext.data.Store"},{"type":"member","member":"load","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-load","cls":"Ext.data.Store"},{"type":"member","member":"refresh","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-refresh","cls":"Ext.data.Store"},{"type":"member","member":"removerecords","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-removerecords","cls":"Ext.data.Store"},{"type":"member","member":"update","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-update","cls":"Ext.data.Store"},{"type":"member","member":"updaterecord","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-updaterecord","cls":"Ext.data.Store"},{"type":"member","member":"write","icon":"event","private":false,"sort":3,"id":"Ext.data.Store-event-write","cls":"Ext.data.Store"},{"type":"member","member":"currentPage","icon":"property","private":false,"sort":3,"id":"Ext.data.Store-property-currentPage","cls":"Ext.data.Store"},{"type":"class","member":"ArrayStore","icon":"class","private":false,"sort":1,"id":"Ext.data.ArrayStore","cls":"Ext.data.ArrayStore"},{"type":"class","member":"array","icon":"subclass","private":false,"sort":0,"id":"Ext.data.ArrayStore","cls":"store: array"},{"type":"class","member":"JsonStore","icon":"class","private":true,"sort":1,"id":"Ext.data.JsonStore","cls":"Ext.data.JsonStore"},{"type":"class","member":"jsonstore","icon":"subclass","private":true,"sort":0,"id":"Ext.data.JsonStore","cls":"xtype: jsonstore"},{"type":"class","member":"NodeStore","icon":"class","private":true,"sort":1,"id":"Ext.data.NodeStore","cls":"Ext.data.NodeStore"},{"type":"class","member":"node","icon":"subclass","private":true,"sort":0,"id":"Ext.data.NodeStore","cls":"store: node"},{"type":"member","member":"folderSort","icon":"cfg","private":false,"sort":3,"id":"Ext.data.NodeStore-cfg-folderSort","cls":"Ext.data.NodeStore"},{"type":"member","member":"node","icon":"cfg","private":false,"sort":3,"id":"Ext.data.NodeStore-cfg-node","cls":"Ext.data.NodeStore"},{"type":"member","member":"recursive","icon":"cfg","private":false,"sort":3,"id":"Ext.data.NodeStore-cfg-recursive","cls":"Ext.data.NodeStore"},{"type":"member","member":"rootVisible","icon":"cfg","private":false,"sort":3,"id":"Ext.data.NodeStore-cfg-rootVisible","cls":"Ext.data.NodeStore"},{"type":"member","member":"getNode","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-getNode","cls":"Ext.data.NodeStore"},{"type":"member","member":"getRecursive","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-getRecursive","cls":"Ext.data.NodeStore"},{"type":"member","member":"getRootVisible","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-getRootVisible","cls":"Ext.data.NodeStore"},{"type":"member","member":"retrieveChildNodes","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeStore-method-retrieveChildNodes","cls":"Ext.data.NodeStore"},{"type":"member","member":"setNode","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-setNode","cls":"Ext.data.NodeStore"},{"type":"member","member":"setRecursive","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-setRecursive","cls":"Ext.data.NodeStore"},{"type":"member","member":"setRootVisible","icon":"method","private":false,"sort":3,"id":"Ext.data.NodeStore-method-setRootVisible","cls":"Ext.data.NodeStore"},{"type":"member","member":"treeSortFn","icon":"method","private":true,"sort":3,"id":"Ext.data.NodeStore-method-treeSortFn","cls":"Ext.data.NodeStore"},{"type":"class","member":"TreeStore","icon":"class","private":false,"sort":1,"id":"Ext.data.TreeStore","cls":"Ext.data.TreeStore"},{"type":"class","member":"tree","icon":"subclass","private":false,"sort":0,"id":"Ext.data.TreeStore","cls":"store: tree"},{"type":"member","member":"clearOnLoad","icon":"cfg","private":false,"sort":3,"id":"Ext.data.TreeStore-cfg-clearOnLoad","cls":"Ext.data.TreeStore"},{"type":"member","member":"defaultRootId","icon":"cfg","private":false,"sort":3,"id":"Ext.data.TreeStore-cfg-defaultRootId","cls":"Ext.data.TreeStore"},{"type":"member","member":"defaultRootProperty","icon":"cfg","private":false,"sort":3,"id":"Ext.data.TreeStore-cfg-defaultRootProperty","cls":"Ext.data.TreeStore"},{"type":"member","member":"node","icon":"cfg","private":true,"sort":3,"id":"Ext.data.TreeStore-cfg-node","cls":"Ext.data.TreeStore"},{"type":"member","member":"nodeParam","icon":"cfg","private":false,"sort":3,"id":"Ext.data.TreeStore-cfg-nodeParam","cls":"Ext.data.TreeStore"},{"type":"member","member":"recursive","icon":"cfg","private":true,"sort":3,"id":"Ext.data.TreeStore-cfg-recursive","cls":"Ext.data.TreeStore"},{"type":"member","member":"root","icon":"cfg","private":false,"sort":3,"id":"Ext.data.TreeStore-cfg-root","cls":"Ext.data.TreeStore"},{"type":"member","member":"fillNode","icon":"method","private":true,"sort":3,"id":"Ext.data.TreeStore-method-fillNode","cls":"Ext.data.TreeStore"},{"type":"member","member":"getClearOnLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getClearOnLoad","cls":"Ext.data.TreeStore"},{"type":"member","member":"getDefaultRootId","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getDefaultRootId","cls":"Ext.data.TreeStore"},{"type":"member","member":"getDefaultRootProperty","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getDefaultRootProperty","cls":"Ext.data.TreeStore"},{"type":"member","member":"getNodeById","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getNodeById","cls":"Ext.data.TreeStore"},{"type":"member","member":"getNodeParam","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getNodeParam","cls":"Ext.data.TreeStore"},{"type":"member","member":"getRoot","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getRoot","cls":"Ext.data.TreeStore"},{"type":"member","member":"getRootNode","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-getRootNode","cls":"Ext.data.TreeStore"},{"type":"member","member":"load","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-load","cls":"Ext.data.TreeStore"},{"type":"member","member":"setClearOnLoad","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setClearOnLoad","cls":"Ext.data.TreeStore"},{"type":"member","member":"setDefaultRootId","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setDefaultRootId","cls":"Ext.data.TreeStore"},{"type":"member","member":"setDefaultRootProperty","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setDefaultRootProperty","cls":"Ext.data.TreeStore"},{"type":"member","member":"setNodeParam","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setNodeParam","cls":"Ext.data.TreeStore"},{"type":"member","member":"setRoot","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setRoot","cls":"Ext.data.TreeStore"},{"type":"member","member":"setRootNode","icon":"method","private":false,"sort":3,"id":"Ext.data.TreeStore-method-setRootNode","cls":"Ext.data.TreeStore"},{"type":"member","member":"rootchange","icon":"event","private":false,"sort":3,"id":"Ext.data.TreeStore-event-rootchange","cls":"Ext.data.TreeStore"},{"type":"class","member":"Rest","icon":"class","private":false,"sort":1,"id":"Ext.data.proxy.Rest","cls":"Ext.data.proxy.Rest"},{"type":"class","member":"RestProxy","icon":"subclass","private":false,"sort":2,"id":"Ext.data.proxy.Rest","cls":"Ext.data.RestProxy"},{"type":"class","member":"rest","icon":"subclass","private":false,"sort":0,"id":"Ext.data.proxy.Rest","cls":"proxy: rest"},{"type":"member","member":"appendId","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Rest-cfg-appendId","cls":"Ext.data.proxy.Rest"},{"type":"member","member":"batchActions","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Rest-cfg-batchActions","cls":"Ext.data.proxy.Rest"},{"type":"member","member":"format","icon":"cfg","private":false,"sort":3,"id":"Ext.data.proxy.Rest-cfg-format","cls":"Ext.data.proxy.Rest"},{"type":"member","member":"buildUrl","icon":"method","private":false,"sort":3,"id":"Ext.data.proxy.Rest-method-buildUrl","cls":"Ext.data.proxy.Rest"},{"type":"class","member":"TapRepeater","icon":"class","private":false,"sort":1,"id":"Ext.util.TapRepeater","cls":"Ext.util.TapRepeater"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.TapRepeater-method-constructor","cls":"Ext.util.TapRepeater"},{"type":"member","member":"tap","icon":"event","private":false,"sort":3,"id":"Ext.util.TapRepeater-event-tap","cls":"Ext.util.TapRepeater"},{"type":"member","member":"touchend","icon":"event","private":false,"sort":3,"id":"Ext.util.TapRepeater-event-touchend","cls":"Ext.util.TapRepeater"},{"type":"member","member":"touchstart","icon":"event","private":false,"sort":3,"id":"Ext.util.TapRepeater-event-touchstart","cls":"Ext.util.TapRepeater"},{"type":"class","member":"Translatable","icon":"class","private":true,"sort":1,"id":"Ext.behavior.Translatable","cls":"Ext.behavior.Translatable"},{"type":"class","member":"Draggable","icon":"class","private":false,"sort":1,"id":"Ext.util.Draggable","cls":"Ext.util.Draggable"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.util.Draggable-cfg-direction","cls":"Ext.util.Draggable"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.util.Draggable-method-constructor","cls":"Ext.util.Draggable"},{"type":"member","member":"disable","icon":"method","private":false,"sort":3,"id":"Ext.util.Draggable-method-disable","cls":"Ext.util.Draggable"},{"type":"member","member":"enable","icon":"method","private":false,"sort":3,"id":"Ext.util.Draggable-method-enable","cls":"Ext.util.Draggable"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.util.Draggable-method-getDirection","cls":"Ext.util.Draggable"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.util.Draggable-method-setDirection","cls":"Ext.util.Draggable"},{"type":"member","member":"drag","icon":"event","private":false,"sort":3,"id":"Ext.util.Draggable-event-drag","cls":"Ext.util.Draggable"},{"type":"member","member":"dragend","icon":"event","private":false,"sort":3,"id":"Ext.util.Draggable-event-dragend","cls":"Ext.util.Draggable"},{"type":"member","member":"dragstart","icon":"event","private":false,"sort":3,"id":"Ext.util.Draggable-event-dragstart","cls":"Ext.util.Draggable"},{"type":"class","member":"Draggable","icon":"class","private":true,"sort":1,"id":"Ext.behavior.Draggable","cls":"Ext.behavior.Draggable"},{"type":"class","member":"Component","icon":"class","private":false,"sort":1,"id":"Ext.Component","cls":"Ext.Component"},{"type":"class","member":"Component","icon":"subclass","private":false,"sort":2,"id":"Ext.Component","cls":"Ext.lib.Component"},{"type":"member","member":"baseCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-baseCls","cls":"Ext.Component"},{"type":"member","member":"border","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-border","cls":"Ext.Component"},{"type":"member","member":"bottom","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-bottom","cls":"Ext.Component"},{"type":"member","member":"centered","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-centered","cls":"Ext.Component"},{"type":"member","member":"cls","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-cls","cls":"Ext.Component"},{"type":"member","member":"componentCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-componentCls","cls":"Ext.Component"},{"type":"member","member":"contentEl","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-contentEl","cls":"Ext.Component"},{"type":"member","member":"data","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-data","cls":"Ext.Component"},{"type":"member","member":"disabled","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-disabled","cls":"Ext.Component"},{"type":"member","member":"disabledCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-disabledCls","cls":"Ext.Component"},{"type":"member","member":"docked","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-docked","cls":"Ext.Component"},{"type":"member","member":"draggable","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-draggable","cls":"Ext.Component"},{"type":"member","member":"droppable","icon":"cfg","private":true,"sort":3,"id":"Ext.Component-cfg-droppable","cls":"Ext.Component"},{"type":"member","member":"enterAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-enterAnimation","cls":"Ext.Component"},{"type":"member","member":"exitAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-exitAnimation","cls":"Ext.Component"},{"type":"member","member":"flex","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-flex","cls":"Ext.Component"},{"type":"member","member":"floating","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-floating","cls":"Ext.Component"},{"type":"member","member":"fullscreen","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-fullscreen","cls":"Ext.Component"},{"type":"member","member":"height","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-height","cls":"Ext.Component"},{"type":"member","member":"hidden","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-hidden","cls":"Ext.Component"},{"type":"member","member":"hideAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-hideAnimation","cls":"Ext.Component"},{"type":"member","member":"html","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-html","cls":"Ext.Component"},{"type":"member","member":"itemId","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-itemId","cls":"Ext.Component"},{"type":"member","member":"left","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-left","cls":"Ext.Component"},{"type":"member","member":"margin","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-margin","cls":"Ext.Component"},{"type":"member","member":"maxHeight","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-maxHeight","cls":"Ext.Component"},{"type":"member","member":"maxWidth","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-maxWidth","cls":"Ext.Component"},{"type":"member","member":"minHeight","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-minHeight","cls":"Ext.Component"},{"type":"member","member":"minWidth","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-minWidth","cls":"Ext.Component"},{"type":"member","member":"padding","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-padding","cls":"Ext.Component"},{"type":"member","member":"plugins","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-plugins","cls":"Ext.Component"},{"type":"member","member":"renderTo","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-renderTo","cls":"Ext.Component"},{"type":"member","member":"renderTpl","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-renderTpl","cls":"Ext.Component"},{"type":"member","member":"right","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-right","cls":"Ext.Component"},{"type":"member","member":"showAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-showAnimation","cls":"Ext.Component"},{"type":"member","member":"style","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-style","cls":"Ext.Component"},{"type":"member","member":"styleHtmlCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-styleHtmlCls","cls":"Ext.Component"},{"type":"member","member":"styleHtmlContent","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-styleHtmlContent","cls":"Ext.Component"},{"type":"member","member":"top","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-top","cls":"Ext.Component"},{"type":"member","member":"tpl","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-tpl","cls":"Ext.Component"},{"type":"member","member":"tplWriteMode","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-tplWriteMode","cls":"Ext.Component"},{"type":"member","member":"translatable","icon":"cfg","private":true,"sort":3,"id":"Ext.Component-cfg-translatable","cls":"Ext.Component"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-ui","cls":"Ext.Component"},{"type":"member","member":"width","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-width","cls":"Ext.Component"},{"type":"member","member":"xtype","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-xtype","cls":"Ext.Component"},{"type":"member","member":"zIndex","icon":"cfg","private":false,"sort":3,"id":"Ext.Component-cfg-zIndex","cls":"Ext.Component"},{"type":"member","member":"constructor","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-constructor","cls":"Ext.Component"},{"type":"member","member":"addCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-addCls","cls":"Ext.Component"},{"type":"member","member":"alignTo","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-alignTo","cls":"Ext.Component"},{"type":"member","member":"applyCls","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-applyCls","cls":"Ext.Component"},{"type":"member","member":"applyTpl","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-applyTpl","cls":"Ext.Component"},{"type":"member","member":"beforeInitialize","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-beforeInitialize","cls":"Ext.Component"},{"type":"member","member":"destroy","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-destroy","cls":"Ext.Component"},{"type":"member","member":"disable","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-disable","cls":"Ext.Component"},{"type":"member","member":"enable","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-enable","cls":"Ext.Component"},{"type":"member","member":"getBaseCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getBaseCls","cls":"Ext.Component"},{"type":"member","member":"getBorder","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getBorder","cls":"Ext.Component"},{"type":"member","member":"getBottom","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getBottom","cls":"Ext.Component"},{"type":"member","member":"getCentered","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getCentered","cls":"Ext.Component"},{"type":"member","member":"getCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getCls","cls":"Ext.Component"},{"type":"member","member":"getContentEl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getContentEl","cls":"Ext.Component"},{"type":"member","member":"getData","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getData","cls":"Ext.Component"},{"type":"member","member":"getDisabled","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getDisabled","cls":"Ext.Component"},{"type":"member","member":"getDisabledCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getDisabledCls","cls":"Ext.Component"},{"type":"member","member":"getDocked","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getDocked","cls":"Ext.Component"},{"type":"member","member":"getDraggable","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getDraggable","cls":"Ext.Component"},{"type":"member","member":"getDroppable","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-getDroppable","cls":"Ext.Component"},{"type":"member","member":"getEl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getEl","cls":"Ext.Component"},{"type":"member","member":"getEnterAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getEnterAnimation","cls":"Ext.Component"},{"type":"member","member":"getExitAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getExitAnimation","cls":"Ext.Component"},{"type":"member","member":"getHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getHeight","cls":"Ext.Component"},{"type":"member","member":"getHidden","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getHidden","cls":"Ext.Component"},{"type":"member","member":"getHideAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getHideAnimation","cls":"Ext.Component"},{"type":"member","member":"getHtml","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getHtml","cls":"Ext.Component"},{"type":"member","member":"getItemId","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getItemId","cls":"Ext.Component"},{"type":"member","member":"getLeft","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getLeft","cls":"Ext.Component"},{"type":"member","member":"getMargin","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getMargin","cls":"Ext.Component"},{"type":"member","member":"getMaxHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getMaxHeight","cls":"Ext.Component"},{"type":"member","member":"getMaxWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getMaxWidth","cls":"Ext.Component"},{"type":"member","member":"getMinHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getMinHeight","cls":"Ext.Component"},{"type":"member","member":"getMinWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getMinWidth","cls":"Ext.Component"},{"type":"member","member":"getPadding","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getPadding","cls":"Ext.Component"},{"type":"member","member":"getParent","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getParent","cls":"Ext.Component"},{"type":"member","member":"getPlugins","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getPlugins","cls":"Ext.Component"},{"type":"member","member":"getRenderTo","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getRenderTo","cls":"Ext.Component"},{"type":"member","member":"getRenderTpl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getRenderTpl","cls":"Ext.Component"},{"type":"member","member":"getRight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getRight","cls":"Ext.Component"},{"type":"member","member":"getShowAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getShowAnimation","cls":"Ext.Component"},{"type":"member","member":"getSize","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getSize","cls":"Ext.Component"},{"type":"member","member":"getStyle","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getStyle","cls":"Ext.Component"},{"type":"member","member":"getStyleHtmlCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getStyleHtmlCls","cls":"Ext.Component"},{"type":"member","member":"getStyleHtmlContent","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getStyleHtmlContent","cls":"Ext.Component"},{"type":"member","member":"getTop","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getTop","cls":"Ext.Component"},{"type":"member","member":"getTpl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getTpl","cls":"Ext.Component"},{"type":"member","member":"getTplWriteMode","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getTplWriteMode","cls":"Ext.Component"},{"type":"member","member":"getTranslatable","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-getTranslatable","cls":"Ext.Component"},{"type":"member","member":"getWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getWidth","cls":"Ext.Component"},{"type":"member","member":"getXTypes","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getXTypes","cls":"Ext.Component"},{"type":"member","member":"getZIndex","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-getZIndex","cls":"Ext.Component"},{"type":"member","member":"hasParent","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-hasParent","cls":"Ext.Component"},{"type":"member","member":"hide","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-hide","cls":"Ext.Component"},{"type":"member","member":"initialize","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-initialize","cls":"Ext.Component"},{"type":"member","member":"isDisabled","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-isDisabled","cls":"Ext.Component"},{"type":"member","member":"isHidden","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-isHidden","cls":"Ext.Component"},{"type":"member","member":"isPainted","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-isPainted","cls":"Ext.Component"},{"type":"member","member":"isRendered","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-isRendered","cls":"Ext.Component"},{"type":"member","member":"isXType","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-isXType","cls":"Ext.Component"},{"type":"member","member":"onInitialized","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-onInitialized","cls":"Ext.Component"},{"type":"member","member":"onShowByErased","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-onShowByErased","cls":"Ext.Component"},{"type":"member","member":"removeCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-removeCls","cls":"Ext.Component"},{"type":"member","member":"replaceCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-replaceCls","cls":"Ext.Component"},{"type":"member","member":"setBaseCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setBaseCls","cls":"Ext.Component"},{"type":"member","member":"setBorder","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setBorder","cls":"Ext.Component"},{"type":"member","member":"setBottom","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setBottom","cls":"Ext.Component"},{"type":"member","member":"setCentered","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setCentered","cls":"Ext.Component"},{"type":"member","member":"setCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setCls","cls":"Ext.Component"},{"type":"member","member":"setContentEl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setContentEl","cls":"Ext.Component"},{"type":"member","member":"setData","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setData","cls":"Ext.Component"},{"type":"member","member":"setDisabled","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setDisabled","cls":"Ext.Component"},{"type":"member","member":"setDisabledCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setDisabledCls","cls":"Ext.Component"},{"type":"member","member":"setDocked","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setDocked","cls":"Ext.Component"},{"type":"member","member":"setDraggable","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setDraggable","cls":"Ext.Component"},{"type":"member","member":"setDroppable","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-setDroppable","cls":"Ext.Component"},{"type":"member","member":"setEnterAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setEnterAnimation","cls":"Ext.Component"},{"type":"member","member":"setExitAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setExitAnimation","cls":"Ext.Component"},{"type":"member","member":"setHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setHeight","cls":"Ext.Component"},{"type":"member","member":"setHidden","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setHidden","cls":"Ext.Component"},{"type":"member","member":"setHideAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setHideAnimation","cls":"Ext.Component"},{"type":"member","member":"setHtml","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setHtml","cls":"Ext.Component"},{"type":"member","member":"setItemId","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setItemId","cls":"Ext.Component"},{"type":"member","member":"setLeft","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setLeft","cls":"Ext.Component"},{"type":"member","member":"setMargin","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setMargin","cls":"Ext.Component"},{"type":"member","member":"setMaxHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setMaxHeight","cls":"Ext.Component"},{"type":"member","member":"setMaxWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setMaxWidth","cls":"Ext.Component"},{"type":"member","member":"setMinHeight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setMinHeight","cls":"Ext.Component"},{"type":"member","member":"setMinWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setMinWidth","cls":"Ext.Component"},{"type":"member","member":"setPadding","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setPadding","cls":"Ext.Component"},{"type":"member","member":"setPlugins","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setPlugins","cls":"Ext.Component"},{"type":"member","member":"setRenderTo","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setRenderTo","cls":"Ext.Component"},{"type":"member","member":"setRenderTpl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setRenderTpl","cls":"Ext.Component"},{"type":"member","member":"setRendered","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-setRendered","cls":"Ext.Component"},{"type":"member","member":"setRight","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setRight","cls":"Ext.Component"},{"type":"member","member":"setShowAnimation","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setShowAnimation","cls":"Ext.Component"},{"type":"member","member":"setSize","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setSize","cls":"Ext.Component"},{"type":"member","member":"setStyle","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setStyle","cls":"Ext.Component"},{"type":"member","member":"setStyleHtmlCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setStyleHtmlCls","cls":"Ext.Component"},{"type":"member","member":"setStyleHtmlContent","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setStyleHtmlContent","cls":"Ext.Component"},{"type":"member","member":"setTop","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setTop","cls":"Ext.Component"},{"type":"member","member":"setTpl","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setTpl","cls":"Ext.Component"},{"type":"member","member":"setTplWriteMode","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setTplWriteMode","cls":"Ext.Component"},{"type":"member","member":"setTranslatable","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-setTranslatable","cls":"Ext.Component"},{"type":"member","member":"setVisibility","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-setVisibility","cls":"Ext.Component"},{"type":"member","member":"setWidth","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setWidth","cls":"Ext.Component"},{"type":"member","member":"setZIndex","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-setZIndex","cls":"Ext.Component"},{"type":"member","member":"show","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-show","cls":"Ext.Component"},{"type":"member","member":"showBy","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-showBy","cls":"Ext.Component"},{"type":"member","member":"triggerInitialized","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-triggerInitialized","cls":"Ext.Component"},{"type":"member","member":"up","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-up","cls":"Ext.Component"},{"type":"member","member":"update","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-update","cls":"Ext.Component"},{"type":"member","member":"updateCls","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-updateCls","cls":"Ext.Component"},{"type":"member","member":"updateData","icon":"method","private":true,"sort":3,"id":"Ext.Component-method-updateData","cls":"Ext.Component"},{"type":"member","member":"updateStyleHtmlCls","icon":"method","private":false,"sort":3,"id":"Ext.Component-method-updateStyleHtmlCls","cls":"Ext.Component"},{"type":"member","member":"beforeorientationchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-beforeorientationchange","cls":"Ext.Component"},{"type":"member","member":"bottomchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-bottomchange","cls":"Ext.Component"},{"type":"member","member":"centeredchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-centeredchange","cls":"Ext.Component"},{"type":"member","member":"disabledchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-disabledchange","cls":"Ext.Component"},{"type":"member","member":"dockedchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-dockedchange","cls":"Ext.Component"},{"type":"member","member":"erased","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-erased","cls":"Ext.Component"},{"type":"member","member":"floatingchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-floatingchange","cls":"Ext.Component"},{"type":"member","member":"fullscreen","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-fullscreen","cls":"Ext.Component"},{"type":"member","member":"heightchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-heightchange","cls":"Ext.Component"},{"type":"member","member":"hiddenchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-hiddenchange","cls":"Ext.Component"},{"type":"member","member":"hide","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-hide","cls":"Ext.Component"},{"type":"member","member":"leftchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-leftchange","cls":"Ext.Component"},{"type":"member","member":"maxheightchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-maxheightchange","cls":"Ext.Component"},{"type":"member","member":"maxwidthchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-maxwidthchange","cls":"Ext.Component"},{"type":"member","member":"minheightchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-minheightchange","cls":"Ext.Component"},{"type":"member","member":"minwidthchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-minwidthchange","cls":"Ext.Component"},{"type":"member","member":"orientationchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-orientationchange","cls":"Ext.Component"},{"type":"member","member":"painted","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-painted","cls":"Ext.Component"},{"type":"member","member":"resize","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-resize","cls":"Ext.Component"},{"type":"member","member":"rightchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-rightchange","cls":"Ext.Component"},{"type":"member","member":"show","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-show","cls":"Ext.Component"},{"type":"member","member":"topchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-topchange","cls":"Ext.Component"},{"type":"member","member":"updatedata","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-updatedata","cls":"Ext.Component"},{"type":"member","member":"widthchange","icon":"event","private":false,"sort":3,"id":"Ext.Component-event-widthchange","cls":"Ext.Component"},{"type":"member","member":"alignmentRegex","icon":"property","private":true,"sort":3,"id":"Ext.Component-property-alignmentRegex","cls":"Ext.Component"},{"type":"member","member":"dockPositions","icon":"property","private":false,"sort":3,"id":"Ext.Component-property-dockPositions","cls":"Ext.Component"},{"type":"member","member":"floating","icon":"property","private":true,"sort":3,"id":"Ext.Component-property-floating","cls":"Ext.Component"},{"type":"member","member":"isComponent","icon":"property","private":true,"sort":3,"id":"Ext.Component-property-isComponent","cls":"Ext.Component"},{"type":"member","member":"listenerOptionsRegex","icon":"property","private":true,"sort":3,"id":"Ext.Component-property-listenerOptionsRegex","cls":"Ext.Component"},{"type":"member","member":"rendered","icon":"property","private":true,"sort":3,"id":"Ext.Component-property-rendered","cls":"Ext.Component"},{"type":"class","member":"Button","icon":"class","private":false,"sort":1,"id":"Ext.Button","cls":"Ext.Button"},{"type":"class","member":"button","icon":"subclass","private":false,"sort":0,"id":"Ext.Button","cls":"xtype: button"},{"type":"member","member":"$button-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-button-gradient","cls":"Ext.Button"},{"type":"member","member":"$button-height","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-button-height","cls":"Ext.Button"},{"type":"member","member":"$button-radius","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-button-radius","cls":"Ext.Button"},{"type":"member","member":"$button-stroke-weight","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-button-stroke-weight","cls":"Ext.Button"},{"type":"member","member":"$include-button-highlights","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-include-button-highlights","cls":"Ext.Button"},{"type":"member","member":"$include-button-uis","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-include-button-uis","cls":"Ext.Button"},{"type":"member","member":"$toolbar-icon-size","icon":"css_var","private":false,"sort":3,"id":"Ext.Button-css_var-S-toolbar-icon-size","cls":"Ext.Button"},{"type":"member","member":"sencha-button-ui","icon":"css_mixin","private":false,"sort":3,"id":"Ext.Button-css_mixin-sencha-button-ui","cls":"Ext.Button"},{"type":"member","member":"sencha-buttons","icon":"css_mixin","private":false,"sort":3,"id":"Ext.Button-css_mixin-sencha-buttons","cls":"Ext.Button"},{"type":"member","member":"autoEvent","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-autoEvent","cls":"Ext.Button"},{"type":"member","member":"badge","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-badge","cls":"Ext.Button"},{"type":"member","member":"badgeCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-badgeCls","cls":"Ext.Button"},{"type":"member","member":"badgeText","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-badgeText","cls":"Ext.Button"},{"type":"member","member":"handler","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-handler","cls":"Ext.Button"},{"type":"member","member":"hasBadgeCls","icon":"cfg","private":true,"sort":3,"id":"Ext.Button-cfg-hasBadgeCls","cls":"Ext.Button"},{"type":"member","member":"html","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-html","cls":"Ext.Button"},{"type":"member","member":"icon","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-icon","cls":"Ext.Button"},{"type":"member","member":"iconAlign","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-iconAlign","cls":"Ext.Button"},{"type":"member","member":"iconCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-iconCls","cls":"Ext.Button"},{"type":"member","member":"iconMask","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-iconMask","cls":"Ext.Button"},{"type":"member","member":"iconMaskCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-iconMaskCls","cls":"Ext.Button"},{"type":"member","member":"labelCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-labelCls","cls":"Ext.Button"},{"type":"member","member":"pressedCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-pressedCls","cls":"Ext.Button"},{"type":"member","member":"pressedDelay","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-pressedDelay","cls":"Ext.Button"},{"type":"member","member":"scope","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-scope","cls":"Ext.Button"},{"type":"member","member":"text","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-text","cls":"Ext.Button"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.Button-cfg-ui","cls":"Ext.Button"},{"type":"member","member":"applyUi","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-applyUi","cls":"Ext.Button"},{"type":"member","member":"doTap","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-doTap","cls":"Ext.Button"},{"type":"member","member":"getAutoEvent","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getAutoEvent","cls":"Ext.Button"},{"type":"member","member":"getBadgeCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getBadgeCls","cls":"Ext.Button"},{"type":"member","member":"getBadgeText","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getBadgeText","cls":"Ext.Button"},{"type":"member","member":"getHandler","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getHandler","cls":"Ext.Button"},{"type":"member","member":"getHasBadgeCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-getHasBadgeCls","cls":"Ext.Button"},{"type":"member","member":"getIcon","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getIcon","cls":"Ext.Button"},{"type":"member","member":"getIconAlign","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getIconAlign","cls":"Ext.Button"},{"type":"member","member":"getIconCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getIconCls","cls":"Ext.Button"},{"type":"member","member":"getIconMask","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getIconMask","cls":"Ext.Button"},{"type":"member","member":"getIconMaskCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getIconMaskCls","cls":"Ext.Button"},{"type":"member","member":"getLabelCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getLabelCls","cls":"Ext.Button"},{"type":"member","member":"getPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getPressedCls","cls":"Ext.Button"},{"type":"member","member":"getScope","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getScope","cls":"Ext.Button"},{"type":"member","member":"getText","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getText","cls":"Ext.Button"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-getUi","cls":"Ext.Button"},{"type":"member","member":"hideIconElement","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-hideIconElement","cls":"Ext.Button"},{"type":"member","member":"setAutoEvent","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setAutoEvent","cls":"Ext.Button"},{"type":"member","member":"setBadge","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setBadge","cls":"Ext.Button"},{"type":"member","member":"setBadgeCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setBadgeCls","cls":"Ext.Button"},{"type":"member","member":"setBadgeText","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setBadgeText","cls":"Ext.Button"},{"type":"member","member":"setHandler","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setHandler","cls":"Ext.Button"},{"type":"member","member":"setHasBadgeCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-setHasBadgeCls","cls":"Ext.Button"},{"type":"member","member":"setIcon","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIcon","cls":"Ext.Button"},{"type":"member","member":"setIconAlign","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIconAlign","cls":"Ext.Button"},{"type":"member","member":"setIconClass","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIconClass","cls":"Ext.Button"},{"type":"member","member":"setIconCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIconCls","cls":"Ext.Button"},{"type":"member","member":"setIconMask","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIconMask","cls":"Ext.Button"},{"type":"member","member":"setIconMaskCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setIconMaskCls","cls":"Ext.Button"},{"type":"member","member":"setLabelCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setLabelCls","cls":"Ext.Button"},{"type":"member","member":"setPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setPressedCls","cls":"Ext.Button"},{"type":"member","member":"setScope","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setScope","cls":"Ext.Button"},{"type":"member","member":"setText","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setText","cls":"Ext.Button"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.Button-method-setUi","cls":"Ext.Button"},{"type":"member","member":"showIconElement","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-showIconElement","cls":"Ext.Button"},{"type":"member","member":"updateAutoEvent","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateAutoEvent","cls":"Ext.Button"},{"type":"member","member":"updateBadgeCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateBadgeCls","cls":"Ext.Button"},{"type":"member","member":"updateBadgeText","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateBadgeText","cls":"Ext.Button"},{"type":"member","member":"updateHasBadgeCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateHasBadgeCls","cls":"Ext.Button"},{"type":"member","member":"updateHtml","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateHtml","cls":"Ext.Button"},{"type":"member","member":"updateIcon","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateIcon","cls":"Ext.Button"},{"type":"member","member":"updateIconAlign","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateIconAlign","cls":"Ext.Button"},{"type":"member","member":"updateIconCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateIconCls","cls":"Ext.Button"},{"type":"member","member":"updateIconMask","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateIconMask","cls":"Ext.Button"},{"type":"member","member":"updateIconMaskCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateIconMaskCls","cls":"Ext.Button"},{"type":"member","member":"updateLabelCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateLabelCls","cls":"Ext.Button"},{"type":"member","member":"updatePressedCls","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updatePressedCls","cls":"Ext.Button"},{"type":"member","member":"updateText","icon":"method","private":true,"sort":3,"id":"Ext.Button-method-updateText","cls":"Ext.Button"},{"type":"member","member":"release","icon":"event","private":false,"sort":3,"id":"Ext.Button-event-release","cls":"Ext.Button"},{"type":"member","member":"tap","icon":"event","private":false,"sort":3,"id":"Ext.Button-event-tap","cls":"Ext.Button"},{"type":"class","member":"Decorator","icon":"class","private":false,"sort":1,"id":"Ext.Decorator","cls":"Ext.Decorator"},{"type":"member","member":"component","icon":"cfg","private":false,"sort":3,"id":"Ext.Decorator-cfg-component","cls":"Ext.Decorator"},{"type":"class","member":"Img","icon":"class","private":false,"sort":1,"id":"Ext.Img","cls":"Ext.Img"},{"type":"class","member":"image","icon":"subclass","private":false,"sort":0,"id":"Ext.Img","cls":"xtype: image"},{"type":"class","member":"img","icon":"subclass","private":false,"sort":0,"id":"Ext.Img","cls":"xtype: img"},{"type":"member","member":"src","icon":"cfg","private":false,"sort":3,"id":"Ext.Img-cfg-src","cls":"Ext.Img"},{"type":"member","member":"getSrc","icon":"method","private":false,"sort":3,"id":"Ext.Img-method-getSrc","cls":"Ext.Img"},{"type":"member","member":"setSrc","icon":"method","private":false,"sort":3,"id":"Ext.Img-method-setSrc","cls":"Ext.Img"},{"type":"member","member":"updateSrc","icon":"method","private":true,"sort":3,"id":"Ext.Img-method-updateSrc","cls":"Ext.Img"},{"type":"member","member":"error","icon":"event","private":false,"sort":3,"id":"Ext.Img-event-error","cls":"Ext.Img"},{"type":"member","member":"load","icon":"event","private":false,"sort":3,"id":"Ext.Img-event-load","cls":"Ext.Img"},{"type":"member","member":"tap","icon":"event","private":false,"sort":3,"id":"Ext.Img-event-tap","cls":"Ext.Img"},{"type":"class","member":"Label","icon":"class","private":false,"sort":1,"id":"Ext.Label","cls":"Ext.Label"},{"type":"class","member":"label","icon":"subclass","private":false,"sort":0,"id":"Ext.Label","cls":"xtype: label"},{"type":"member","member":"html","icon":"cfg","private":false,"sort":3,"id":"Ext.Label-cfg-html","cls":"Ext.Label"},{"type":"class","member":"Map","icon":"class","private":false,"sort":1,"id":"Ext.Map","cls":"Ext.Map"},{"type":"class","member":"map","icon":"subclass","private":false,"sort":0,"id":"Ext.Map","cls":"xtype: map"},{"type":"member","member":"baseCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-baseCls","cls":"Ext.Map"},{"type":"member","member":"geo","icon":"cfg","private":true,"sort":3,"id":"Ext.Map-cfg-geo","cls":"Ext.Map"},{"type":"member","member":"map","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-map","cls":"Ext.Map"},{"type":"member","member":"mapOptions","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-mapOptions","cls":"Ext.Map"},{"type":"member","member":"maskMap","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-maskMap","cls":"Ext.Map"},{"type":"member","member":"maskMapCls","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-maskMapCls","cls":"Ext.Map"},{"type":"member","member":"useCurrentLocation","icon":"cfg","private":false,"sort":3,"id":"Ext.Map-cfg-useCurrentLocation","cls":"Ext.Map"},{"type":"member","member":"getBaseCls","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-getBaseCls","cls":"Ext.Map"},{"type":"member","member":"getGeo","icon":"method","private":true,"sort":3,"id":"Ext.Map-method-getGeo","cls":"Ext.Map"},{"type":"member","member":"getMap","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-getMap","cls":"Ext.Map"},{"type":"member","member":"getMapOptions","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-getMapOptions","cls":"Ext.Map"},{"type":"member","member":"getState","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-getState","cls":"Ext.Map"},{"type":"member","member":"getUseCurrentLocation","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-getUseCurrentLocation","cls":"Ext.Map"},{"type":"member","member":"setBaseCls","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-setBaseCls","cls":"Ext.Map"},{"type":"member","member":"setGeo","icon":"method","private":true,"sort":3,"id":"Ext.Map-method-setGeo","cls":"Ext.Map"},{"type":"member","member":"setMap","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-setMap","cls":"Ext.Map"},{"type":"member","member":"setMapCenter","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-setMapCenter","cls":"Ext.Map"},{"type":"member","member":"setMapOptions","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-setMapOptions","cls":"Ext.Map"},{"type":"member","member":"setUseCurrentLocation","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-setUseCurrentLocation","cls":"Ext.Map"},{"type":"member","member":"update","icon":"method","private":false,"sort":3,"id":"Ext.Map-method-update","cls":"Ext.Map"},{"type":"member","member":"centerchange","icon":"event","private":false,"sort":3,"id":"Ext.Map-event-centerchange","cls":"Ext.Map"},{"type":"member","member":"maprender","icon":"event","private":false,"sort":3,"id":"Ext.Map-event-maprender","cls":"Ext.Map"},{"type":"member","member":"typechange","icon":"event","private":false,"sort":3,"id":"Ext.Map-event-typechange","cls":"Ext.Map"},{"type":"member","member":"zoomchange","icon":"event","private":false,"sort":3,"id":"Ext.Map-event-zoomchange","cls":"Ext.Map"},{"type":"class","member":"Mask","icon":"class","private":false,"sort":1,"id":"Ext.Mask","cls":"Ext.Mask"},{"type":"class","member":"mask","icon":"subclass","private":false,"sort":0,"id":"Ext.Mask","cls":"xtype: mask"},{"type":"member","member":"transparent","icon":"cfg","private":false,"sort":3,"id":"Ext.Mask-cfg-transparent","cls":"Ext.Mask"},{"type":"member","member":"tap","icon":"event","private":false,"sort":3,"id":"Ext.Mask-event-tap","cls":"Ext.Mask"},{"type":"member","member":"bottom","icon":"property","private":true,"sort":3,"id":"Ext.Mask-property-bottom","cls":"Ext.Mask"},{"type":"member","member":"left","icon":"property","private":true,"sort":3,"id":"Ext.Mask-property-left","cls":"Ext.Mask"},{"type":"member","member":"right","icon":"property","private":true,"sort":3,"id":"Ext.Mask-property-right","cls":"Ext.Mask"},{"type":"member","member":"top","icon":"property","private":true,"sort":3,"id":"Ext.Mask-property-top","cls":"Ext.Mask"},{"type":"class","member":"LoadMask","icon":"class","private":false,"sort":1,"id":"Ext.LoadMask","cls":"Ext.LoadMask"},{"type":"class","member":"loadmask","icon":"subclass","private":false,"sort":0,"id":"Ext.LoadMask","cls":"xtype: loadmask"},{"type":"member","member":"$loading-spinner-color","icon":"css_var","private":false,"sort":3,"id":"Ext.LoadMask-css_var-S-loading-spinner-color","cls":"Ext.LoadMask"},{"type":"member","member":"sencha-loading-spinner","icon":"css_mixin","private":false,"sort":3,"id":"Ext.LoadMask-css_mixin-sencha-loading-spinner","cls":"Ext.LoadMask"},{"type":"member","member":"indicator","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-indicator","cls":"Ext.LoadMask"},{"type":"member","member":"message","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-message","cls":"Ext.LoadMask"},{"type":"member","member":"messageCls","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-messageCls","cls":"Ext.LoadMask"},{"type":"member","member":"msg","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-msg","cls":"Ext.LoadMask"},{"type":"member","member":"msgCls","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-msgCls","cls":"Ext.LoadMask"},{"type":"member","member":"store","icon":"cfg","private":false,"sort":3,"id":"Ext.LoadMask-cfg-store","cls":"Ext.LoadMask"},{"type":"member","member":"bindStore","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-bindStore","cls":"Ext.LoadMask"},{"type":"member","member":"getIndicator","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-getIndicator","cls":"Ext.LoadMask"},{"type":"member","member":"getMessage","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-getMessage","cls":"Ext.LoadMask"},{"type":"member","member":"getMessageCls","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-getMessageCls","cls":"Ext.LoadMask"},{"type":"member","member":"refreshPosition","icon":"method","private":true,"sort":3,"id":"Ext.LoadMask-method-refreshPosition","cls":"Ext.LoadMask"},{"type":"member","member":"setIndicator","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-setIndicator","cls":"Ext.LoadMask"},{"type":"member","member":"setMessage","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-setMessage","cls":"Ext.LoadMask"},{"type":"member","member":"setMessageCls","icon":"method","private":false,"sort":3,"id":"Ext.LoadMask-method-setMessageCls","cls":"Ext.LoadMask"},{"type":"member","member":"updateIndicator","icon":"method","private":true,"sort":3,"id":"Ext.LoadMask-method-updateIndicator","cls":"Ext.LoadMask"},{"type":"member","member":"updateMessage","icon":"method","private":true,"sort":3,"id":"Ext.LoadMask-method-updateMessage","cls":"Ext.LoadMask"},{"type":"member","member":"updateMessageCls","icon":"method","private":true,"sort":3,"id":"Ext.LoadMask-method-updateMessageCls","cls":"Ext.LoadMask"},{"type":"class","member":"Media","icon":"class","private":true,"sort":1,"id":"Ext.Media","cls":"Ext.Media"},{"type":"class","member":"media","icon":"subclass","private":true,"sort":0,"id":"Ext.Media","cls":"xtype: media"},{"type":"member","member":"autoPause","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-autoPause","cls":"Ext.Media"},{"type":"member","member":"autoResume","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-autoResume","cls":"Ext.Media"},{"type":"member","member":"enableControls","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-enableControls","cls":"Ext.Media"},{"type":"member","member":"loop","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-loop","cls":"Ext.Media"},{"type":"member","member":"media","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-media","cls":"Ext.Media"},{"type":"member","member":"muted","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-muted","cls":"Ext.Media"},{"type":"member","member":"preload","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-preload","cls":"Ext.Media"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-url","cls":"Ext.Media"},{"type":"member","member":"volume","icon":"cfg","private":false,"sort":3,"id":"Ext.Media-cfg-volume","cls":"Ext.Media"},{"type":"member","member":"getAutoPause","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getAutoPause","cls":"Ext.Media"},{"type":"member","member":"getAutoResume","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getAutoResume","cls":"Ext.Media"},{"type":"member","member":"getCurrentTime","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getCurrentTime","cls":"Ext.Media"},{"type":"member","member":"getDuration","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getDuration","cls":"Ext.Media"},{"type":"member","member":"getEnableControls","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getEnableControls","cls":"Ext.Media"},{"type":"member","member":"getLoop","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getLoop","cls":"Ext.Media"},{"type":"member","member":"getMedia","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getMedia","cls":"Ext.Media"},{"type":"member","member":"getMuted","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getMuted","cls":"Ext.Media"},{"type":"member","member":"getPreload","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getPreload","cls":"Ext.Media"},{"type":"member","member":"getUrl","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getUrl","cls":"Ext.Media"},{"type":"member","member":"getVolume","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-getVolume","cls":"Ext.Media"},{"type":"member","member":"isPlaying","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-isPlaying","cls":"Ext.Media"},{"type":"member","member":"pause","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-pause","cls":"Ext.Media"},{"type":"member","member":"play","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-play","cls":"Ext.Media"},{"type":"member","member":"setAutoPause","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setAutoPause","cls":"Ext.Media"},{"type":"member","member":"setAutoResume","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setAutoResume","cls":"Ext.Media"},{"type":"member","member":"setEnableControls","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setEnableControls","cls":"Ext.Media"},{"type":"member","member":"setLoop","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setLoop","cls":"Ext.Media"},{"type":"member","member":"setMedia","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setMedia","cls":"Ext.Media"},{"type":"member","member":"setMuted","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setMuted","cls":"Ext.Media"},{"type":"member","member":"setPreload","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setPreload","cls":"Ext.Media"},{"type":"member","member":"setUrl","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setUrl","cls":"Ext.Media"},{"type":"member","member":"setVolume","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-setVolume","cls":"Ext.Media"},{"type":"member","member":"stop","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-stop","cls":"Ext.Media"},{"type":"member","member":"toggle","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-toggle","cls":"Ext.Media"},{"type":"member","member":"updateEnableControls","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-updateEnableControls","cls":"Ext.Media"},{"type":"member","member":"updateLoop","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-updateLoop","cls":"Ext.Media"},{"type":"member","member":"updateUrl","icon":"method","private":false,"sort":3,"id":"Ext.Media-method-updateUrl","cls":"Ext.Media"},{"type":"member","member":"ended","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-ended","cls":"Ext.Media"},{"type":"member","member":"mutedchange","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-mutedchange","cls":"Ext.Media"},{"type":"member","member":"paused","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-paused","cls":"Ext.Media"},{"type":"member","member":"play","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-play","cls":"Ext.Media"},{"type":"member","member":"stop","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-stop","cls":"Ext.Media"},{"type":"member","member":"timeupdate","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-timeupdate","cls":"Ext.Media"},{"type":"member","member":"volumechange","icon":"event","private":false,"sort":3,"id":"Ext.Media-event-volumechange","cls":"Ext.Media"},{"type":"class","member":"Audio","icon":"class","private":false,"sort":1,"id":"Ext.Audio","cls":"Ext.Audio"},{"type":"class","member":"audio","icon":"subclass","private":false,"sort":0,"id":"Ext.Audio","cls":"xtype: audio"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.Audio-cfg-url","cls":"Ext.Audio"},{"type":"member","member":"getUrl","icon":"method","private":false,"sort":3,"id":"Ext.Audio-method-getUrl","cls":"Ext.Audio"},{"type":"member","member":"setUrl","icon":"method","private":false,"sort":3,"id":"Ext.Audio-method-setUrl","cls":"Ext.Audio"},{"type":"class","member":"Spacer","icon":"class","private":false,"sort":1,"id":"Ext.Spacer","cls":"Ext.Spacer"},{"type":"class","member":"spacer","icon":"subclass","private":false,"sort":0,"id":"Ext.Spacer","cls":"xtype: spacer"},{"type":"member","member":"flex","icon":"cfg","private":false,"sort":3,"id":"Ext.Spacer-cfg-flex","cls":"Ext.Spacer"},{"type":"member","member":"width","icon":"cfg","private":false,"sort":3,"id":"Ext.Spacer-cfg-width","cls":"Ext.Spacer"},{"type":"member","member":"getFlex","icon":"method","private":false,"sort":3,"id":"Ext.Spacer-method-getFlex","cls":"Ext.Spacer"},{"type":"member","member":"getWidth","icon":"method","private":false,"sort":3,"id":"Ext.Spacer-method-getWidth","cls":"Ext.Spacer"},{"type":"member","member":"setFlex","icon":"method","private":false,"sort":3,"id":"Ext.Spacer-method-setFlex","cls":"Ext.Spacer"},{"type":"member","member":"setWidth","icon":"method","private":false,"sort":3,"id":"Ext.Spacer-method-setWidth","cls":"Ext.Spacer"},{"type":"class","member":"Title","icon":"class","private":true,"sort":1,"id":"Ext.Title","cls":"Ext.Title"},{"type":"class","member":"title","icon":"subclass","private":true,"sort":0,"id":"Ext.Title","cls":"xtype: title"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.Title-cfg-title","cls":"Ext.Title"},{"type":"class","member":"Video","icon":"class","private":false,"sort":1,"id":"Ext.Video","cls":"Ext.Video"},{"type":"class","member":"video","icon":"subclass","private":false,"sort":0,"id":"Ext.Video","cls":"xtype: video"},{"type":"member","member":"posterUrl","icon":"cfg","private":false,"sort":3,"id":"Ext.Video-cfg-posterUrl","cls":"Ext.Video"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.Video-cfg-url","cls":"Ext.Video"},{"type":"member","member":"getPosterUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-getPosterUrl","cls":"Ext.Video"},{"type":"member","member":"getUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-getUrl","cls":"Ext.Video"},{"type":"member","member":"onGhostTap","icon":"method","private":true,"sort":3,"id":"Ext.Video-method-onGhostTap","cls":"Ext.Video"},{"type":"member","member":"setPosterUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-setPosterUrl","cls":"Ext.Video"},{"type":"member","member":"setUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-setUrl","cls":"Ext.Video"},{"type":"member","member":"updatePosterUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-updatePosterUrl","cls":"Ext.Video"},{"type":"member","member":"updateUrl","icon":"method","private":false,"sort":3,"id":"Ext.Video-method-updateUrl","cls":"Ext.Video"},{"type":"member","member":"ghost","icon":"property","private":true,"sort":3,"id":"Ext.Video-property-ghost","cls":"Ext.Video"},{"type":"class","member":"Indicator","icon":"class","private":true,"sort":1,"id":"Ext.carousel.Indicator","cls":"Ext.carousel.Indicator"},{"type":"class","member":"Carousel.Indicator","icon":"subclass","private":true,"sort":2,"id":"Ext.carousel.Indicator","cls":"Ext.Carousel.Indicator"},{"type":"class","member":"carouselindicator","icon":"subclass","private":true,"sort":0,"id":"Ext.carousel.Indicator","cls":"xtype: carouselindicator"},{"type":"member","member":"$carousel-indicator-size","icon":"css_var","private":false,"sort":3,"id":"Ext.carousel.Indicator-css_var-S-carousel-indicator-size","cls":"Ext.carousel.Indicator"},{"type":"member","member":"$carousel-indicator-spacing","icon":"css_var","private":false,"sort":3,"id":"Ext.carousel.Indicator-css_var-S-carousel-indicator-spacing","cls":"Ext.carousel.Indicator"},{"type":"member","member":"$carousel-track-size","icon":"css_var","private":false,"sort":3,"id":"Ext.carousel.Indicator-css_var-S-carousel-track-size","cls":"Ext.carousel.Indicator"},{"type":"member","member":"sencha-carousel-indicator-ui","icon":"css_mixin","private":false,"sort":3,"id":"Ext.carousel.Indicator-css_mixin-sencha-carousel-indicator-ui","cls":"Ext.carousel.Indicator"},{"type":"member","member":"next","icon":"event","private":false,"sort":3,"id":"Ext.carousel.Indicator-event-next","cls":"Ext.carousel.Indicator"},{"type":"member","member":"previous","icon":"event","private":false,"sort":3,"id":"Ext.carousel.Indicator-event-previous","cls":"Ext.carousel.Indicator"},{"type":"class","member":"Item","icon":"class","private":true,"sort":1,"id":"Ext.carousel.Item","cls":"Ext.carousel.Item"},{"type":"class","member":"IndexBar","icon":"class","private":false,"sort":1,"id":"Ext.dataview.IndexBar","cls":"Ext.dataview.IndexBar"},{"type":"class","member":"IndexBar","icon":"subclass","private":false,"sort":2,"id":"Ext.dataview.IndexBar","cls":"Ext.IndexBar"},{"type":"member","member":"$index-bar-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.IndexBar-css_var-S-index-bar-bg-color","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"$index-bar-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.IndexBar-css_var-S-index-bar-color","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"$index-bar-width","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.IndexBar-css_var-S-index-bar-width","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"sencha-indexbar","icon":"css_mixin","private":false,"sort":3,"id":"Ext.dataview.IndexBar-css_mixin-sencha-indexbar","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"direction","icon":"cfg","private":true,"sort":3,"id":"Ext.dataview.IndexBar-cfg-direction","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"letters","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.IndexBar-cfg-letters","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"listPrefix","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.IndexBar-cfg-listPrefix","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"getDirection","icon":"method","private":true,"sort":3,"id":"Ext.dataview.IndexBar-method-getDirection","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"getLetters","icon":"method","private":false,"sort":3,"id":"Ext.dataview.IndexBar-method-getLetters","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"getListPrefix","icon":"method","private":false,"sort":3,"id":"Ext.dataview.IndexBar-method-getListPrefix","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"setDirection","icon":"method","private":true,"sort":3,"id":"Ext.dataview.IndexBar-method-setDirection","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"setLetters","icon":"method","private":false,"sort":3,"id":"Ext.dataview.IndexBar-method-setLetters","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"setListPrefix","icon":"method","private":false,"sort":3,"id":"Ext.dataview.IndexBar-method-setListPrefix","cls":"Ext.dataview.IndexBar"},{"type":"member","member":"index","icon":"event","private":false,"sort":3,"id":"Ext.dataview.IndexBar-event-index","cls":"Ext.dataview.IndexBar"},{"type":"class","member":"ListItemHeader","icon":"class","private":true,"sort":1,"id":"Ext.dataview.ListItemHeader","cls":"Ext.dataview.ListItemHeader"},{"type":"class","member":"listitemheader","icon":"subclass","private":true,"sort":0,"id":"Ext.dataview.ListItemHeader","cls":"xtype: listitemheader"},{"type":"class","member":"Container","icon":"class","private":true,"sort":1,"id":"Ext.dataview.element.Container","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemdoubletap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemdoubletap","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemswipe","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemswipe","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemtap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemtap","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemtaphold","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemtaphold","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemtouchend","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemtouchend","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemtouchmove","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemtouchmove","cls":"Ext.dataview.element.Container"},{"type":"member","member":"itemtouchstart","icon":"event","private":false,"sort":3,"id":"Ext.dataview.element.Container-event-itemtouchstart","cls":"Ext.dataview.element.Container"},{"type":"class","member":"List","icon":"class","private":true,"sort":1,"id":"Ext.dataview.element.List","cls":"Ext.dataview.element.List"},{"type":"class","member":"Input","icon":"class","private":true,"sort":1,"id":"Ext.field.Input","cls":"Ext.field.Input"},{"type":"class","member":"input","icon":"subclass","private":true,"sort":0,"id":"Ext.field.Input","cls":"xtype: input"},{"type":"member","member":"autoCapitalize","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-autoCapitalize","cls":"Ext.field.Input"},{"type":"member","member":"autoComplete","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-autoComplete","cls":"Ext.field.Input"},{"type":"member","member":"autoCorrect","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-autoCorrect","cls":"Ext.field.Input"},{"type":"member","member":"checked","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-checked","cls":"Ext.field.Input"},{"type":"member","member":"cls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-cls","cls":"Ext.field.Input"},{"type":"member","member":"disabled","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-disabled","cls":"Ext.field.Input"},{"type":"member","member":"focusCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-focusCls","cls":"Ext.field.Input"},{"type":"member","member":"maxLength","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-maxLength","cls":"Ext.field.Input"},{"type":"member","member":"maxRows","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-maxRows","cls":"Ext.field.Input"},{"type":"member","member":"maxValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-maxValue","cls":"Ext.field.Input"},{"type":"member","member":"minValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-minValue","cls":"Ext.field.Input"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-name","cls":"Ext.field.Input"},{"type":"member","member":"originalValue","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Input-cfg-originalValue","cls":"Ext.field.Input"},{"type":"member","member":"placeHolder","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-placeHolder","cls":"Ext.field.Input"},{"type":"member","member":"readOnly","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-readOnly","cls":"Ext.field.Input"},{"type":"member","member":"startValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-startValue","cls":"Ext.field.Input"},{"type":"member","member":"stepValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-stepValue","cls":"Ext.field.Input"},{"type":"member","member":"tabIndex","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-tabIndex","cls":"Ext.field.Input"},{"type":"member","member":"type","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-type","cls":"Ext.field.Input"},{"type":"member","member":"useMask","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Input-cfg-useMask","cls":"Ext.field.Input"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Input-cfg-value","cls":"Ext.field.Input"},{"type":"member","member":"blur","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-blur","cls":"Ext.field.Input"},{"type":"member","member":"focus","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-focus","cls":"Ext.field.Input"},{"type":"member","member":"getAutoCapitalize","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getAutoCapitalize","cls":"Ext.field.Input"},{"type":"member","member":"getAutoComplete","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getAutoComplete","cls":"Ext.field.Input"},{"type":"member","member":"getAutoCorrect","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getAutoCorrect","cls":"Ext.field.Input"},{"type":"member","member":"getChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getChecked","cls":"Ext.field.Input"},{"type":"member","member":"getCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getCls","cls":"Ext.field.Input"},{"type":"member","member":"getDisabled","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getDisabled","cls":"Ext.field.Input"},{"type":"member","member":"getFocusCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getFocusCls","cls":"Ext.field.Input"},{"type":"member","member":"getMaxLength","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getMaxLength","cls":"Ext.field.Input"},{"type":"member","member":"getMaxRows","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getMaxRows","cls":"Ext.field.Input"},{"type":"member","member":"getMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getMaxValue","cls":"Ext.field.Input"},{"type":"member","member":"getMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getMinValue","cls":"Ext.field.Input"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getName","cls":"Ext.field.Input"},{"type":"member","member":"getPlaceHolder","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getPlaceHolder","cls":"Ext.field.Input"},{"type":"member","member":"getReadOnly","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getReadOnly","cls":"Ext.field.Input"},{"type":"member","member":"getStartValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getStartValue","cls":"Ext.field.Input"},{"type":"member","member":"getStepValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getStepValue","cls":"Ext.field.Input"},{"type":"member","member":"getTabIndex","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getTabIndex","cls":"Ext.field.Input"},{"type":"member","member":"getType","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getType","cls":"Ext.field.Input"},{"type":"member","member":"getUseMask","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-getUseMask","cls":"Ext.field.Input"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-getValue","cls":"Ext.field.Input"},{"type":"member","member":"isDirty","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-isDirty","cls":"Ext.field.Input"},{"type":"member","member":"reset","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-reset","cls":"Ext.field.Input"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-select","cls":"Ext.field.Input"},{"type":"member","member":"setAutoCapitalize","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setAutoCapitalize","cls":"Ext.field.Input"},{"type":"member","member":"setAutoComplete","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setAutoComplete","cls":"Ext.field.Input"},{"type":"member","member":"setAutoCorrect","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setAutoCorrect","cls":"Ext.field.Input"},{"type":"member","member":"setChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setChecked","cls":"Ext.field.Input"},{"type":"member","member":"setCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setCls","cls":"Ext.field.Input"},{"type":"member","member":"setDisabled","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setDisabled","cls":"Ext.field.Input"},{"type":"member","member":"setFocusCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setFocusCls","cls":"Ext.field.Input"},{"type":"member","member":"setMaxLength","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setMaxLength","cls":"Ext.field.Input"},{"type":"member","member":"setMaxRows","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setMaxRows","cls":"Ext.field.Input"},{"type":"member","member":"setMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setMaxValue","cls":"Ext.field.Input"},{"type":"member","member":"setMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setMinValue","cls":"Ext.field.Input"},{"type":"member","member":"setName","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setName","cls":"Ext.field.Input"},{"type":"member","member":"setPlaceHolder","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setPlaceHolder","cls":"Ext.field.Input"},{"type":"member","member":"setReadOnly","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setReadOnly","cls":"Ext.field.Input"},{"type":"member","member":"setStartValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setStartValue","cls":"Ext.field.Input"},{"type":"member","member":"setStepValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setStepValue","cls":"Ext.field.Input"},{"type":"member","member":"setTabIndex","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setTabIndex","cls":"Ext.field.Input"},{"type":"member","member":"setType","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setType","cls":"Ext.field.Input"},{"type":"member","member":"setUseMask","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-setUseMask","cls":"Ext.field.Input"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-setValue","cls":"Ext.field.Input"},{"type":"member","member":"updateAutoCapitalize","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateAutoCapitalize","cls":"Ext.field.Input"},{"type":"member","member":"updateAutoComplete","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateAutoComplete","cls":"Ext.field.Input"},{"type":"member","member":"updateAutoCorrect","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateAutoCorrect","cls":"Ext.field.Input"},{"type":"member","member":"updateChecked","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateChecked","cls":"Ext.field.Input"},{"type":"member","member":"updateCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-updateCls","cls":"Ext.field.Input"},{"type":"member","member":"updateFieldAttribute","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateFieldAttribute","cls":"Ext.field.Input"},{"type":"member","member":"updateMaxLength","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateMaxLength","cls":"Ext.field.Input"},{"type":"member","member":"updateMaxValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateMaxValue","cls":"Ext.field.Input"},{"type":"member","member":"updateMinValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateMinValue","cls":"Ext.field.Input"},{"type":"member","member":"updateName","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateName","cls":"Ext.field.Input"},{"type":"member","member":"updatePlaceHolder","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updatePlaceHolder","cls":"Ext.field.Input"},{"type":"member","member":"updateReadOnly","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateReadOnly","cls":"Ext.field.Input"},{"type":"member","member":"updateStepValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateStepValue","cls":"Ext.field.Input"},{"type":"member","member":"updateTabIndex","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateTabIndex","cls":"Ext.field.Input"},{"type":"member","member":"updateType","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateType","cls":"Ext.field.Input"},{"type":"member","member":"updateUseMask","icon":"method","private":false,"sort":3,"id":"Ext.field.Input-method-updateUseMask","cls":"Ext.field.Input"},{"type":"member","member":"updateValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Input-method-updateValue","cls":"Ext.field.Input"},{"type":"member","member":"blur","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-blur","cls":"Ext.field.Input"},{"type":"member","member":"clearicontap","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-clearicontap","cls":"Ext.field.Input"},{"type":"member","member":"click","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-click","cls":"Ext.field.Input"},{"type":"member","member":"focus","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-focus","cls":"Ext.field.Input"},{"type":"member","member":"keyup","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-keyup","cls":"Ext.field.Input"},{"type":"member","member":"masktap","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-masktap","cls":"Ext.field.Input"},{"type":"member","member":"mousedown","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-mousedown","cls":"Ext.field.Input"},{"type":"member","member":"paste","icon":"event","private":false,"sort":3,"id":"Ext.field.Input-event-paste","cls":"Ext.field.Input"},{"type":"member","member":"isFocused","icon":"property","private":false,"sort":3,"id":"Ext.field.Input-property-isFocused","cls":"Ext.field.Input"},{"type":"member","member":"tag","icon":"property","private":true,"sort":3,"id":"Ext.field.Input-property-tag","cls":"Ext.field.Input"},{"type":"class","member":"Field","icon":"class","private":false,"sort":1,"id":"Ext.field.Field","cls":"Ext.field.Field"},{"type":"class","member":"Field","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Field","cls":"Ext.form.Field"},{"type":"class","member":"field","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Field","cls":"xtype: field"},{"type":"member","member":"$form-dark","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-dark","cls":"Ext.field.Field"},{"type":"member","member":"$form-field-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-field-bg-color","cls":"Ext.field.Field"},{"type":"member","member":"$form-field-height","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-field-height","cls":"Ext.field.Field"},{"type":"member","member":"$form-label-background-color","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-label-background-color","cls":"Ext.field.Field"},{"type":"member","member":"$form-label-width","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-label-width","cls":"Ext.field.Field"},{"type":"member","member":"$form-light","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-light","cls":"Ext.field.Field"},{"type":"member","member":"$form-spacing","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-form-spacing","cls":"Ext.field.Field"},{"type":"member","member":"$toolbar-input-bg","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-toolbar-input-bg","cls":"Ext.field.Field"},{"type":"member","member":"$toolbar-input-border-color","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-toolbar-input-border-color","cls":"Ext.field.Field"},{"type":"member","member":"$toolbar-input-color","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-toolbar-input-color","cls":"Ext.field.Field"},{"type":"member","member":"$toolbar-input-height","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Field-css_var-S-toolbar-input-height","cls":"Ext.field.Field"},{"type":"member","member":"clearIcon","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-clearIcon","cls":"Ext.field.Field"},{"type":"member","member":"component","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-component","cls":"Ext.field.Field"},{"type":"member","member":"fieldCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-fieldCls","cls":"Ext.field.Field"},{"type":"member","member":"fieldLabel","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-fieldLabel","cls":"Ext.field.Field"},{"type":"member","member":"fullscreen","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Field-cfg-fullscreen","cls":"Ext.field.Field"},{"type":"member","member":"inputCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-inputCls","cls":"Ext.field.Field"},{"type":"member","member":"inputType","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-inputType","cls":"Ext.field.Field"},{"type":"member","member":"isFocused","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Field-cfg-isFocused","cls":"Ext.field.Field"},{"type":"member","member":"label","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-label","cls":"Ext.field.Field"},{"type":"member","member":"labelAlign","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-labelAlign","cls":"Ext.field.Field"},{"type":"member","member":"labelCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-labelCls","cls":"Ext.field.Field"},{"type":"member","member":"labelWidth","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-labelWidth","cls":"Ext.field.Field"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-name","cls":"Ext.field.Field"},{"type":"member","member":"required","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-required","cls":"Ext.field.Field"},{"type":"member","member":"requiredCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-requiredCls","cls":"Ext.field.Field"},{"type":"member","member":"tabIndex","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-tabIndex","cls":"Ext.field.Field"},{"type":"member","member":"useClearIcon","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-useClearIcon","cls":"Ext.field.Field"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Field-cfg-value","cls":"Ext.field.Field"},{"type":"member","member":"doInitValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Field-method-doInitValue","cls":"Ext.field.Field"},{"type":"member","member":"getClearIcon","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getClearIcon","cls":"Ext.field.Field"},{"type":"member","member":"getInputType","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getInputType","cls":"Ext.field.Field"},{"type":"member","member":"getLabel","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getLabel","cls":"Ext.field.Field"},{"type":"member","member":"getLabelAlign","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getLabelAlign","cls":"Ext.field.Field"},{"type":"member","member":"getLabelCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getLabelCls","cls":"Ext.field.Field"},{"type":"member","member":"getLabelWidth","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getLabelWidth","cls":"Ext.field.Field"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getName","cls":"Ext.field.Field"},{"type":"member","member":"getRequired","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getRequired","cls":"Ext.field.Field"},{"type":"member","member":"getRequiredCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getRequiredCls","cls":"Ext.field.Field"},{"type":"member","member":"getTabIndex","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getTabIndex","cls":"Ext.field.Field"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-getValue","cls":"Ext.field.Field"},{"type":"member","member":"isDirty","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-isDirty","cls":"Ext.field.Field"},{"type":"member","member":"reset","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-reset","cls":"Ext.field.Field"},{"type":"member","member":"setClearIcon","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setClearIcon","cls":"Ext.field.Field"},{"type":"member","member":"setInputType","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setInputType","cls":"Ext.field.Field"},{"type":"member","member":"setLabel","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setLabel","cls":"Ext.field.Field"},{"type":"member","member":"setLabelAlign","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setLabelAlign","cls":"Ext.field.Field"},{"type":"member","member":"setLabelCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setLabelCls","cls":"Ext.field.Field"},{"type":"member","member":"setLabelWidth","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setLabelWidth","cls":"Ext.field.Field"},{"type":"member","member":"setName","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setName","cls":"Ext.field.Field"},{"type":"member","member":"setRequired","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setRequired","cls":"Ext.field.Field"},{"type":"member","member":"setRequiredCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setRequiredCls","cls":"Ext.field.Field"},{"type":"member","member":"setTabIndex","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setTabIndex","cls":"Ext.field.Field"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Field-method-setValue","cls":"Ext.field.Field"},{"type":"member","member":"updateRequired","icon":"method","private":true,"sort":3,"id":"Ext.field.Field-method-updateRequired","cls":"Ext.field.Field"},{"type":"member","member":"updateRequiredCls","icon":"method","private":true,"sort":3,"id":"Ext.field.Field-method-updateRequiredCls","cls":"Ext.field.Field"},{"type":"member","member":"isField","icon":"property","private":false,"sort":3,"id":"Ext.field.Field-property-isField","cls":"Ext.field.Field"},{"type":"member","member":"labelEl","icon":"property","private":false,"sort":3,"id":"Ext.field.Field-property-labelEl","cls":"Ext.field.Field"},{"type":"member","member":"originalValue","icon":"property","private":false,"sort":3,"id":"Ext.field.Field-property-originalValue","cls":"Ext.field.Field"},{"type":"class","member":"Checkbox","icon":"class","private":false,"sort":1,"id":"Ext.field.Checkbox","cls":"Ext.field.Checkbox"},{"type":"class","member":"Checkbox","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Checkbox","cls":"Ext.form.Checkbox"},{"type":"class","member":"checkboxfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Checkbox","cls":"xtype: checkboxfield"},{"type":"member","member":"checked","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Checkbox-cfg-checked","cls":"Ext.field.Checkbox"},{"type":"member","member":"tabIndex","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Checkbox-cfg-tabIndex","cls":"Ext.field.Checkbox"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Checkbox-cfg-value","cls":"Ext.field.Checkbox"},{"type":"member","member":"check","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-check","cls":"Ext.field.Checkbox"},{"type":"member","member":"doChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-doChecked","cls":"Ext.field.Checkbox"},{"type":"member","member":"doUnChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-doUnChecked","cls":"Ext.field.Checkbox"},{"type":"member","member":"getChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-getChecked","cls":"Ext.field.Checkbox"},{"type":"member","member":"getGroupValues","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-getGroupValues","cls":"Ext.field.Checkbox"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-getValue","cls":"Ext.field.Checkbox"},{"type":"member","member":"isChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-isChecked","cls":"Ext.field.Checkbox"},{"type":"member","member":"resetGroupValues","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-resetGroupValues","cls":"Ext.field.Checkbox"},{"type":"member","member":"setChecked","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-setChecked","cls":"Ext.field.Checkbox"},{"type":"member","member":"setGroupValues","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-setGroupValues","cls":"Ext.field.Checkbox"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-setValue","cls":"Ext.field.Checkbox"},{"type":"member","member":"uncheck","icon":"method","private":false,"sort":3,"id":"Ext.field.Checkbox-method-uncheck","cls":"Ext.field.Checkbox"},{"type":"member","member":"check","icon":"event","private":false,"sort":3,"id":"Ext.field.Checkbox-event-check","cls":"Ext.field.Checkbox"},{"type":"member","member":"uncheck","icon":"event","private":false,"sort":3,"id":"Ext.field.Checkbox-event-uncheck","cls":"Ext.field.Checkbox"},{"type":"class","member":"Hidden","icon":"class","private":false,"sort":1,"id":"Ext.field.Hidden","cls":"Ext.field.Hidden"},{"type":"class","member":"Hidden","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Hidden","cls":"Ext.form.Hidden"},{"type":"class","member":"hiddenfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Hidden","cls":"xtype: hiddenfield"},{"type":"member","member":"hidden","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Hidden-cfg-hidden","cls":"Ext.field.Hidden"},{"type":"member","member":"tabIndex","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Hidden-cfg-tabIndex","cls":"Ext.field.Hidden"},{"type":"class","member":"Radio","icon":"class","private":false,"sort":1,"id":"Ext.field.Radio","cls":"Ext.field.Radio"},{"type":"class","member":"Radio","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Radio","cls":"Ext.form.Radio"},{"type":"class","member":"radiofield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Radio","cls":"xtype: radiofield"},{"type":"member","member":"getGroupValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Radio-method-getGroupValue","cls":"Ext.field.Radio"},{"type":"member","member":"setGroupValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Radio-method-setGroupValue","cls":"Ext.field.Radio"},{"type":"class","member":"Text","icon":"class","private":false,"sort":1,"id":"Ext.field.Text","cls":"Ext.field.Text"},{"type":"class","member":"Text","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Text","cls":"Ext.form.Text"},{"type":"class","member":"textfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Text","cls":"xtype: textfield"},{"type":"member","member":"autoCapitalize","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-autoCapitalize","cls":"Ext.field.Text"},{"type":"member","member":"autoComplete","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-autoComplete","cls":"Ext.field.Text"},{"type":"member","member":"autoCorrect","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-autoCorrect","cls":"Ext.field.Text"},{"type":"member","member":"component","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-component","cls":"Ext.field.Text"},{"type":"member","member":"maxLength","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-maxLength","cls":"Ext.field.Text"},{"type":"member","member":"placeHolder","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-placeHolder","cls":"Ext.field.Text"},{"type":"member","member":"readOnly","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Text-cfg-readOnly","cls":"Ext.field.Text"},{"type":"member","member":"blur","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-blur","cls":"Ext.field.Text"},{"type":"member","member":"doKeyUp","icon":"method","private":true,"sort":3,"id":"Ext.field.Text-method-doKeyUp","cls":"Ext.field.Text"},{"type":"member","member":"focus","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-focus","cls":"Ext.field.Text"},{"type":"member","member":"getAutoCapitalize","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getAutoCapitalize","cls":"Ext.field.Text"},{"type":"member","member":"getAutoComplete","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getAutoComplete","cls":"Ext.field.Text"},{"type":"member","member":"getAutoCorrect","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getAutoCorrect","cls":"Ext.field.Text"},{"type":"member","member":"getMaxLength","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getMaxLength","cls":"Ext.field.Text"},{"type":"member","member":"getPlaceHolder","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getPlaceHolder","cls":"Ext.field.Text"},{"type":"member","member":"getReadOnly","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-getReadOnly","cls":"Ext.field.Text"},{"type":"member","member":"select","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-select","cls":"Ext.field.Text"},{"type":"member","member":"setAutoCapitalize","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setAutoCapitalize","cls":"Ext.field.Text"},{"type":"member","member":"setAutoComplete","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setAutoComplete","cls":"Ext.field.Text"},{"type":"member","member":"setAutoCorrect","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setAutoCorrect","cls":"Ext.field.Text"},{"type":"member","member":"setMaxLength","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setMaxLength","cls":"Ext.field.Text"},{"type":"member","member":"setPlaceHolder","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setPlaceHolder","cls":"Ext.field.Text"},{"type":"member","member":"setReadOnly","icon":"method","private":false,"sort":3,"id":"Ext.field.Text-method-setReadOnly","cls":"Ext.field.Text"},{"type":"member","member":"updateInputCls","icon":"method","private":true,"sort":3,"id":"Ext.field.Text-method-updateInputCls","cls":"Ext.field.Text"},{"type":"member","member":"action","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-action","cls":"Ext.field.Text"},{"type":"member","member":"blur","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-blur","cls":"Ext.field.Text"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-change","cls":"Ext.field.Text"},{"type":"member","member":"clearicontap","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-clearicontap","cls":"Ext.field.Text"},{"type":"member","member":"focus","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-focus","cls":"Ext.field.Text"},{"type":"member","member":"keyup","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-keyup","cls":"Ext.field.Text"},{"type":"member","member":"mousedown","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-mousedown","cls":"Ext.field.Text"},{"type":"member","member":"paste","icon":"event","private":false,"sort":3,"id":"Ext.field.Text-event-paste","cls":"Ext.field.Text"},{"type":"member","member":"startValue","icon":"property","private":false,"sort":3,"id":"Ext.field.Text-property-startValue","cls":"Ext.field.Text"},{"type":"class","member":"Email","icon":"class","private":false,"sort":1,"id":"Ext.field.Email","cls":"Ext.field.Email"},{"type":"class","member":"Email","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Email","cls":"Ext.form.Email"},{"type":"class","member":"emailfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Email","cls":"xtype: emailfield"},{"type":"class","member":"Number","icon":"class","private":false,"sort":1,"id":"Ext.field.Number","cls":"Ext.field.Number"},{"type":"class","member":"Number","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Number","cls":"Ext.form.Number"},{"type":"class","member":"numberfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Number","cls":"xtype: numberfield"},{"type":"member","member":"maxValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Number-cfg-maxValue","cls":"Ext.field.Number"},{"type":"member","member":"minValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Number-cfg-minValue","cls":"Ext.field.Number"},{"type":"member","member":"stepValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Number-cfg-stepValue","cls":"Ext.field.Number"},{"type":"member","member":"getMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-getMaxValue","cls":"Ext.field.Number"},{"type":"member","member":"getMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-getMinValue","cls":"Ext.field.Number"},{"type":"member","member":"getStepValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-getStepValue","cls":"Ext.field.Number"},{"type":"member","member":"setMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-setMaxValue","cls":"Ext.field.Number"},{"type":"member","member":"setMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-setMinValue","cls":"Ext.field.Number"},{"type":"member","member":"setStepValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Number-method-setStepValue","cls":"Ext.field.Number"},{"type":"class","member":"Password","icon":"class","private":false,"sort":1,"id":"Ext.field.Password","cls":"Ext.field.Password"},{"type":"class","member":"Password","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Password","cls":"Ext.form.Password"},{"type":"class","member":"passwordfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Password","cls":"xtype: passwordfield"},{"type":"class","member":"Search","icon":"class","private":false,"sort":1,"id":"Ext.field.Search","cls":"Ext.field.Search"},{"type":"class","member":"Search","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Search","cls":"Ext.form.Search"},{"type":"class","member":"searchfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Search","cls":"xtype: searchfield"},{"type":"class","member":"Spinner","icon":"class","private":false,"sort":1,"id":"Ext.field.Spinner","cls":"Ext.field.Spinner"},{"type":"class","member":"Spinner","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Spinner","cls":"Ext.form.Spinner"},{"type":"class","member":"spinnerfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Spinner","cls":"xtype: spinnerfield"},{"type":"member","member":"accelerateOnTapHold","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-accelerateOnTapHold","cls":"Ext.field.Spinner"},{"type":"member","member":"clearIcon","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Spinner-cfg-clearIcon","cls":"Ext.field.Spinner"},{"type":"member","member":"cycle","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-cycle","cls":"Ext.field.Spinner"},{"type":"member","member":"defaultValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-defaultValue","cls":"Ext.field.Spinner"},{"type":"member","member":"increment","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-increment","cls":"Ext.field.Spinner"},{"type":"member","member":"incrementValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-incrementValue","cls":"Ext.field.Spinner"},{"type":"member","member":"maxValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-maxValue","cls":"Ext.field.Spinner"},{"type":"member","member":"minValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Spinner-cfg-minValue","cls":"Ext.field.Spinner"},{"type":"member","member":"tabIndex","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Spinner-cfg-tabIndex","cls":"Ext.field.Spinner"},{"type":"member","member":"doSetDisabled","icon":"method","private":true,"sort":3,"id":"Ext.field.Spinner-method-doSetDisabled","cls":"Ext.field.Spinner"},{"type":"member","member":"getAccelerateOnTapHold","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-getAccelerateOnTapHold","cls":"Ext.field.Spinner"},{"type":"member","member":"getClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.Spinner-method-getClearIcon","cls":"Ext.field.Spinner"},{"type":"member","member":"getCycle","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-getCycle","cls":"Ext.field.Spinner"},{"type":"member","member":"getIncrement","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-getIncrement","cls":"Ext.field.Spinner"},{"type":"member","member":"getMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-getMaxValue","cls":"Ext.field.Spinner"},{"type":"member","member":"getMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-getMinValue","cls":"Ext.field.Spinner"},{"type":"member","member":"setAccelerateOnTapHold","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-setAccelerateOnTapHold","cls":"Ext.field.Spinner"},{"type":"member","member":"setClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.Spinner-method-setClearIcon","cls":"Ext.field.Spinner"},{"type":"member","member":"setCycle","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-setCycle","cls":"Ext.field.Spinner"},{"type":"member","member":"setDisabled","icon":"method","private":true,"sort":3,"id":"Ext.field.Spinner-method-setDisabled","cls":"Ext.field.Spinner"},{"type":"member","member":"setIncrement","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-setIncrement","cls":"Ext.field.Spinner"},{"type":"member","member":"setMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-setMaxValue","cls":"Ext.field.Spinner"},{"type":"member","member":"setMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-setMinValue","cls":"Ext.field.Spinner"},{"type":"member","member":"updateComponent","icon":"method","private":false,"sort":3,"id":"Ext.field.Spinner-method-updateComponent","cls":"Ext.field.Spinner"},{"type":"member","member":"spin","icon":"event","private":false,"sort":3,"id":"Ext.field.Spinner-event-spin","cls":"Ext.field.Spinner"},{"type":"member","member":"spindown","icon":"event","private":false,"sort":3,"id":"Ext.field.Spinner-event-spindown","cls":"Ext.field.Spinner"},{"type":"member","member":"spinup","icon":"event","private":false,"sort":3,"id":"Ext.field.Spinner-event-spinup","cls":"Ext.field.Spinner"},{"type":"class","member":"TextAreaInput","icon":"class","private":true,"sort":1,"id":"Ext.field.TextAreaInput","cls":"Ext.field.TextAreaInput"},{"type":"class","member":"textareainput","icon":"subclass","private":true,"sort":0,"id":"Ext.field.TextAreaInput","cls":"xtype: textareainput"},{"type":"class","member":"TextArea","icon":"class","private":false,"sort":1,"id":"Ext.field.TextArea","cls":"Ext.field.TextArea"},{"type":"class","member":"TextArea","icon":"subclass","private":false,"sort":2,"id":"Ext.field.TextArea","cls":"Ext.form.TextArea"},{"type":"class","member":"textareafield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.TextArea","cls":"xtype: textareafield"},{"type":"member","member":"$form-textarea-height","icon":"css_var","private":false,"sort":3,"id":"Ext.field.TextArea-css_var-S-form-textarea-height","cls":"Ext.field.TextArea"},{"type":"member","member":"maxRows","icon":"cfg","private":false,"sort":3,"id":"Ext.field.TextArea-cfg-maxRows","cls":"Ext.field.TextArea"},{"type":"member","member":"getMaxRows","icon":"method","private":false,"sort":3,"id":"Ext.field.TextArea-method-getMaxRows","cls":"Ext.field.TextArea"},{"type":"member","member":"setMaxRows","icon":"method","private":false,"sort":3,"id":"Ext.field.TextArea-method-setMaxRows","cls":"Ext.field.TextArea"},{"type":"class","member":"Url","icon":"class","private":false,"sort":1,"id":"Ext.field.Url","cls":"Ext.field.Url"},{"type":"class","member":"Url","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Url","cls":"Ext.form.Url"},{"type":"class","member":"urlfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Url","cls":"xtype: urlfield"},{"type":"class","member":"ListPaging","icon":"class","private":false,"sort":1,"id":"Ext.plugin.ListPaging","cls":"Ext.plugin.ListPaging"},{"type":"class","member":"listpaging","icon":"subclass","private":false,"sort":0,"id":"Ext.plugin.ListPaging","cls":"ptype: listpaging"},{"type":"member","member":"autoPaging","icon":"cfg","private":false,"sort":3,"id":"Ext.plugin.ListPaging-cfg-autoPaging","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"list","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-list","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadMoreCmpAdded","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-loadMoreCmpAdded","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadMoreText","icon":"cfg","private":false,"sort":3,"id":"Ext.plugin.ListPaging-cfg-loadMoreText","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadTpl","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-loadTpl","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loading","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-loading","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadingCls","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-loadingCls","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"noMoreRecordsText","icon":"cfg","private":false,"sort":3,"id":"Ext.plugin.ListPaging-cfg-noMoreRecordsText","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"scroller","icon":"cfg","private":true,"sort":3,"id":"Ext.plugin.ListPaging-cfg-scroller","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"addLoadMoreCmp","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-addLoadMoreCmp","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"applyLoadMoreCmp","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-applyLoadMoreCmp","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"applyLoadTpl","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-applyLoadTpl","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"init","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-init","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadNextPage","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-loadNextPage","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"onScrollEnd","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-onScrollEnd","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"onStoreLoad","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-onStoreLoad","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"storeFullyLoaded","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-storeFullyLoaded","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"updateLoading","icon":"method","private":true,"sort":3,"id":"Ext.plugin.ListPaging-method-updateLoading","cls":"Ext.plugin.ListPaging"},{"type":"member","member":"loadMoreCmp","icon":"property","private":false,"sort":3,"id":"Ext.plugin.ListPaging-property-loadMoreCmp","cls":"Ext.plugin.ListPaging"},{"type":"class","member":"PullRefresh","icon":"class","private":false,"sort":1,"id":"Ext.plugin.PullRefresh","cls":"Ext.plugin.PullRefresh"},{"type":"class","member":"pullrefresh","icon":"subclass","private":false,"sort":0,"id":"Ext.plugin.PullRefresh","cls":"ptype: pullrefresh"},{"type":"member","member":"applyPullTpl","icon":"method","private":true,"sort":3,"id":"Ext.plugin.PullRefresh-method-applyPullTpl","cls":"Ext.plugin.PullRefresh"},{"type":"class","member":"Thumb","icon":"class","private":true,"sort":1,"id":"Ext.slider.Thumb","cls":"Ext.slider.Thumb"},{"type":"class","member":"thumb","icon":"subclass","private":true,"sort":0,"id":"Ext.slider.Thumb","cls":"xtype: thumb"},{"type":"class","member":"Tab","icon":"class","private":true,"sort":1,"id":"Ext.tab.Tab","cls":"Ext.tab.Tab"},{"type":"class","member":"Tab","icon":"subclass","private":true,"sort":2,"id":"Ext.tab.Tab","cls":"Ext.Tab"},{"type":"class","member":"tab","icon":"subclass","private":true,"sort":0,"id":"Ext.tab.Tab","cls":"xtype: tab"},{"type":"member","member":"$tabs-bottom-active-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Tab-css_var-S-tabs-bottom-active-gradient","cls":"Ext.tab.Tab"},{"type":"member","member":"$tabs-bottom-icon-size","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Tab-css_var-S-tabs-bottom-icon-size","cls":"Ext.tab.Tab"},{"type":"member","member":"$tabs-bottom-radius","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Tab-css_var-S-tabs-bottom-radius","cls":"Ext.tab.Tab"},{"type":"member","member":"active","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Tab-cfg-active","cls":"Ext.tab.Tab"},{"type":"member","member":"activeCls","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Tab-cfg-activeCls","cls":"Ext.tab.Tab"},{"type":"member","member":"pressedCls","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Tab-cfg-pressedCls","cls":"Ext.tab.Tab"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Tab-cfg-title","cls":"Ext.tab.Tab"},{"type":"member","member":"getActive","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-getActive","cls":"Ext.tab.Tab"},{"type":"member","member":"getActiveCls","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-getActiveCls","cls":"Ext.tab.Tab"},{"type":"member","member":"getPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-getPressedCls","cls":"Ext.tab.Tab"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-getTitle","cls":"Ext.tab.Tab"},{"type":"member","member":"setActive","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-setActive","cls":"Ext.tab.Tab"},{"type":"member","member":"setActiveCls","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-setActiveCls","cls":"Ext.tab.Tab"},{"type":"member","member":"setPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-setPressedCls","cls":"Ext.tab.Tab"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.tab.Tab-method-setTitle","cls":"Ext.tab.Tab"},{"type":"member","member":"activate","icon":"event","private":false,"sort":3,"id":"Ext.tab.Tab-event-activate","cls":"Ext.tab.Tab"},{"type":"member","member":"deactivate","icon":"event","private":false,"sort":3,"id":"Ext.tab.Tab-event-deactivate","cls":"Ext.tab.Tab"},{"type":"class","member":"Swipe","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.Swipe","cls":"Ext.event.recognizer.Swipe"},{"type":"class","member":"HorizontalSwipe","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.HorizontalSwipe","cls":"Ext.event.recognizer.HorizontalSwipe"},{"type":"class","member":"CssAnimation","icon":"class","private":true,"sort":1,"id":"Ext.fx.runner.CssAnimation","cls":"Ext.fx.runner.CssAnimation"},{"type":"class","member":"Runner","icon":"class","private":true,"sort":1,"id":"Ext.fx.Runner","cls":"Ext.fx.Runner"},{"type":"class","member":"View","icon":"class","private":false,"sort":1,"id":"Ext.scroll.View","cls":"Ext.scroll.View"},{"type":"class","member":"ScrollView","icon":"subclass","private":false,"sort":2,"id":"Ext.scroll.View","cls":"Ext.util.ScrollView"},{"type":"member","member":"flashIndicatorTimeout","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.View-cfg-flashIndicatorTimeout","cls":"Ext.scroll.View"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.scroll.View-cfg-ui","cls":"Ext.scroll.View"},{"type":"member","member":"flashIndicator","icon":"method","private":false,"sort":3,"id":"Ext.scroll.View-method-flashIndicator","cls":"Ext.scroll.View"},{"type":"member","member":"flashIndicators","icon":"method","private":false,"sort":3,"id":"Ext.scroll.View-method-flashIndicators","cls":"Ext.scroll.View"},{"type":"member","member":"getScroller","icon":"method","private":false,"sort":3,"id":"Ext.scroll.View-method-getScroller","cls":"Ext.scroll.View"},{"type":"member","member":"processConfig","icon":"method","private":true,"sort":3,"id":"Ext.scroll.View-method-processConfig","cls":"Ext.scroll.View"},{"type":"class","member":"Scrollable","icon":"class","private":true,"sort":1,"id":"Ext.behavior.Scrollable","cls":"Ext.behavior.Scrollable"},{"type":"class","member":"Container","icon":"class","private":false,"sort":1,"id":"Ext.Container","cls":"Ext.Container"},{"type":"class","member":"Container","icon":"subclass","private":false,"sort":2,"id":"Ext.Container","cls":"Ext.lib.Container"},{"type":"class","member":"container","icon":"subclass","private":false,"sort":0,"id":"Ext.Container","cls":"xtype: container"},{"type":"member","member":"activeItem","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-activeItem","cls":"Ext.Container"},{"type":"member","member":"autoDestroy","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-autoDestroy","cls":"Ext.Container"},{"type":"member","member":"cardSwitchAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-cardSwitchAnimation","cls":"Ext.Container"},{"type":"member","member":"control","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-control","cls":"Ext.Container"},{"type":"member","member":"defaultType","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-defaultType","cls":"Ext.Container"},{"type":"member","member":"defaults","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-defaults","cls":"Ext.Container"},{"type":"member","member":"hideOnMaskTap","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-hideOnMaskTap","cls":"Ext.Container"},{"type":"member","member":"items","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-items","cls":"Ext.Container"},{"type":"member","member":"layout","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-layout","cls":"Ext.Container"},{"type":"member","member":"masked","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-masked","cls":"Ext.Container"},{"type":"member","member":"modal","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-modal","cls":"Ext.Container"},{"type":"member","member":"scroll","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-scroll","cls":"Ext.Container"},{"type":"member","member":"scrollable","icon":"cfg","private":false,"sort":3,"id":"Ext.Container-cfg-scrollable","cls":"Ext.Container"},{"type":"member","member":"add","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-add","cls":"Ext.Container"},{"type":"member","member":"addAll","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-addAll","cls":"Ext.Container"},{"type":"member","member":"animateActiveItem","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-animateActiveItem","cls":"Ext.Container"},{"type":"member","member":"applyActiveItem","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-applyActiveItem","cls":"Ext.Container"},{"type":"member","member":"applyControl","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-applyControl","cls":"Ext.Container"},{"type":"member","member":"applyMasked","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-applyMasked","cls":"Ext.Container"},{"type":"member","member":"applyScrollable","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-applyScrollable","cls":"Ext.Container"},{"type":"member","member":"child","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-child","cls":"Ext.Container"},{"type":"member","member":"doAdd","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-doAdd","cls":"Ext.Container"},{"type":"member","member":"doInsert","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-doInsert","cls":"Ext.Container"},{"type":"member","member":"doSetActiveItem","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-doSetActiveItem","cls":"Ext.Container"},{"type":"member","member":"down","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-down","cls":"Ext.Container"},{"type":"member","member":"getActiveItem","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getActiveItem","cls":"Ext.Container"},{"type":"member","member":"getAt","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getAt","cls":"Ext.Container"},{"type":"member","member":"getAutoDestroy","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getAutoDestroy","cls":"Ext.Container"},{"type":"member","member":"getComponent","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getComponent","cls":"Ext.Container"},{"type":"member","member":"getDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getDefaultType","cls":"Ext.Container"},{"type":"member","member":"getDefaults","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getDefaults","cls":"Ext.Container"},{"type":"member","member":"getDockedComponent","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getDockedComponent","cls":"Ext.Container"},{"type":"member","member":"getDockedItems","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getDockedItems","cls":"Ext.Container"},{"type":"member","member":"getHideOnMaskTap","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getHideOnMaskTap","cls":"Ext.Container"},{"type":"member","member":"getInnerItems","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getInnerItems","cls":"Ext.Container"},{"type":"member","member":"getItems","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getItems","cls":"Ext.Container"},{"type":"member","member":"getLayout","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getLayout","cls":"Ext.Container"},{"type":"member","member":"getMasked","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getMasked","cls":"Ext.Container"},{"type":"member","member":"getModal","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getModal","cls":"Ext.Container"},{"type":"member","member":"getScrollable","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-getScrollable","cls":"Ext.Container"},{"type":"member","member":"getScrollableBehavior","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-getScrollableBehavior","cls":"Ext.Container"},{"type":"member","member":"has","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-has","cls":"Ext.Container"},{"type":"member","member":"hasInnerItem","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-hasInnerItem","cls":"Ext.Container"},{"type":"member","member":"indexOf","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-indexOf","cls":"Ext.Container"},{"type":"member","member":"insert","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-insert","cls":"Ext.Container"},{"type":"member","member":"insertAfter","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-insertAfter","cls":"Ext.Container"},{"type":"member","member":"insertBefore","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-insertBefore","cls":"Ext.Container"},{"type":"member","member":"insertFirst","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-insertFirst","cls":"Ext.Container"},{"type":"member","member":"insertInner","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-insertInner","cls":"Ext.Container"},{"type":"member","member":"insertLast","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-insertLast","cls":"Ext.Container"},{"type":"member","member":"mask","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-mask","cls":"Ext.Container"},{"type":"member","member":"onFirstItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onFirstItemAdd","cls":"Ext.Container"},{"type":"member","member":"onItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemAdd","cls":"Ext.Container"},{"type":"member","member":"onItemCenteredChange","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemCenteredChange","cls":"Ext.Container"},{"type":"member","member":"onItemDockedChange","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemDockedChange","cls":"Ext.Container"},{"type":"member","member":"onItemFloatingChange","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemFloatingChange","cls":"Ext.Container"},{"type":"member","member":"onItemMove","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemMove","cls":"Ext.Container"},{"type":"member","member":"onItemRemove","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-onItemRemove","cls":"Ext.Container"},{"type":"member","member":"query","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-query","cls":"Ext.Container"},{"type":"member","member":"remove","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-remove","cls":"Ext.Container"},{"type":"member","member":"removeAll","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-removeAll","cls":"Ext.Container"},{"type":"member","member":"removeAt","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-removeAt","cls":"Ext.Container"},{"type":"member","member":"removeDocked","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-removeDocked","cls":"Ext.Container"},{"type":"member","member":"removeInner","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-removeInner","cls":"Ext.Container"},{"type":"member","member":"removeInnerAt","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-removeInnerAt","cls":"Ext.Container"},{"type":"member","member":"setActiveItem","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setActiveItem","cls":"Ext.Container"},{"type":"member","member":"setAutoDestroy","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setAutoDestroy","cls":"Ext.Container"},{"type":"member","member":"setDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setDefaultType","cls":"Ext.Container"},{"type":"member","member":"setDefaults","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setDefaults","cls":"Ext.Container"},{"type":"member","member":"setHideOnMaskTap","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setHideOnMaskTap","cls":"Ext.Container"},{"type":"member","member":"setItems","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setItems","cls":"Ext.Container"},{"type":"member","member":"setLayout","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setLayout","cls":"Ext.Container"},{"type":"member","member":"setMasked","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setMasked","cls":"Ext.Container"},{"type":"member","member":"setModal","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setModal","cls":"Ext.Container"},{"type":"member","member":"setRendered","icon":"method","private":true,"sort":3,"id":"Ext.Container-method-setRendered","cls":"Ext.Container"},{"type":"member","member":"setScrollable","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-setScrollable","cls":"Ext.Container"},{"type":"member","member":"unmask","icon":"method","private":false,"sort":3,"id":"Ext.Container-method-unmask","cls":"Ext.Container"},{"type":"member","member":"activate","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-activate","cls":"Ext.Container"},{"type":"member","member":"activeitemchange","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-activeitemchange","cls":"Ext.Container"},{"type":"member","member":"add","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-add","cls":"Ext.Container"},{"type":"member","member":"deactivate","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-deactivate","cls":"Ext.Container"},{"type":"member","member":"move","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-move","cls":"Ext.Container"},{"type":"member","member":"remove","icon":"event","private":false,"sort":3,"id":"Ext.Container-event-remove","cls":"Ext.Container"},{"type":"member","member":"renderedchange","icon":"event","private":true,"sort":3,"id":"Ext.Container-event-renderedchange","cls":"Ext.Container"},{"type":"member","member":"items","icon":"property","private":false,"sort":3,"id":"Ext.Container-property-items","cls":"Ext.Container"},{"type":"class","member":"Panel","icon":"class","private":false,"sort":1,"id":"Ext.Panel","cls":"Ext.Panel"},{"type":"class","member":"Panel","icon":"subclass","private":false,"sort":2,"id":"Ext.Panel","cls":"Ext.lib.Panel"},{"type":"class","member":"panel","icon":"subclass","private":false,"sort":0,"id":"Ext.Panel","cls":"xtype: panel"},{"type":"member","member":"bodyBorder","icon":"cfg","private":false,"sort":3,"id":"Ext.Panel-cfg-bodyBorder","cls":"Ext.Panel"},{"type":"member","member":"bodyMargin","icon":"cfg","private":false,"sort":3,"id":"Ext.Panel-cfg-bodyMargin","cls":"Ext.Panel"},{"type":"member","member":"bodyPadding","icon":"cfg","private":false,"sort":3,"id":"Ext.Panel-cfg-bodyPadding","cls":"Ext.Panel"},{"type":"class","member":"SegmentedButton","icon":"class","private":false,"sort":1,"id":"Ext.SegmentedButton","cls":"Ext.SegmentedButton"},{"type":"class","member":"segmentedbutton","icon":"subclass","private":false,"sort":0,"id":"Ext.SegmentedButton","cls":"xtype: segmentedbutton"},{"type":"member","member":"allowDepress","icon":"cfg","private":false,"sort":3,"id":"Ext.SegmentedButton-cfg-allowDepress","cls":"Ext.SegmentedButton"},{"type":"member","member":"allowMultiple","icon":"cfg","private":false,"sort":3,"id":"Ext.SegmentedButton-cfg-allowMultiple","cls":"Ext.SegmentedButton"},{"type":"member","member":"pressedButtons","icon":"cfg","private":false,"sort":3,"id":"Ext.SegmentedButton-cfg-pressedButtons","cls":"Ext.SegmentedButton"},{"type":"member","member":"pressedCls","icon":"cfg","private":false,"sort":3,"id":"Ext.SegmentedButton-cfg-pressedCls","cls":"Ext.SegmentedButton"},{"type":"member","member":"applyItems","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-applyItems","cls":"Ext.SegmentedButton"},{"type":"member","member":"applyPressedButtons","icon":"method","private":true,"sort":3,"id":"Ext.SegmentedButton-method-applyPressedButtons","cls":"Ext.SegmentedButton"},{"type":"member","member":"doSetDisabled","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-doSetDisabled","cls":"Ext.SegmentedButton"},{"type":"member","member":"getAllowDepress","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-getAllowDepress","cls":"Ext.SegmentedButton"},{"type":"member","member":"getAllowMultiple","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-getAllowMultiple","cls":"Ext.SegmentedButton"},{"type":"member","member":"getPressed","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-getPressed","cls":"Ext.SegmentedButton"},{"type":"member","member":"getPressedButtons","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-getPressedButtons","cls":"Ext.SegmentedButton"},{"type":"member","member":"getPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-getPressedCls","cls":"Ext.SegmentedButton"},{"type":"member","member":"isPressed","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-isPressed","cls":"Ext.SegmentedButton"},{"type":"member","member":"onButtonRelease","icon":"method","private":true,"sort":3,"id":"Ext.SegmentedButton-method-onButtonRelease","cls":"Ext.SegmentedButton"},{"type":"member","member":"setAllowDepress","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-setAllowDepress","cls":"Ext.SegmentedButton"},{"type":"member","member":"setAllowMultiple","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-setAllowMultiple","cls":"Ext.SegmentedButton"},{"type":"member","member":"setPressed","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-setPressed","cls":"Ext.SegmentedButton"},{"type":"member","member":"setPressedButtons","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-setPressedButtons","cls":"Ext.SegmentedButton"},{"type":"member","member":"setPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.SegmentedButton-method-setPressedCls","cls":"Ext.SegmentedButton"},{"type":"member","member":"updatePressedButtons","icon":"method","private":true,"sort":3,"id":"Ext.SegmentedButton-method-updatePressedButtons","cls":"Ext.SegmentedButton"},{"type":"member","member":"toggle","icon":"event","private":false,"sort":3,"id":"Ext.SegmentedButton-event-toggle","cls":"Ext.SegmentedButton"},{"type":"class","member":"Sheet","icon":"class","private":false,"sort":1,"id":"Ext.Sheet","cls":"Ext.Sheet"},{"type":"class","member":"sheet","icon":"subclass","private":false,"sort":0,"id":"Ext.Sheet","cls":"xtype: sheet"},{"type":"member","member":"$sheet-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.Sheet-css_var-S-sheet-bg-color","cls":"Ext.Sheet"},{"type":"member","member":"$sheet-bg-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.Sheet-css_var-S-sheet-bg-gradient","cls":"Ext.Sheet"},{"type":"member","member":"$sheet-button-spacing","icon":"css_var","private":false,"sort":3,"id":"Ext.Sheet-css_var-S-sheet-button-spacing","cls":"Ext.Sheet"},{"type":"member","member":"$sheet-padding","icon":"css_var","private":false,"sort":3,"id":"Ext.Sheet-css_var-S-sheet-padding","cls":"Ext.Sheet"},{"type":"member","member":"sencha-sheet","icon":"css_mixin","private":false,"sort":3,"id":"Ext.Sheet-css_mixin-sencha-sheet","cls":"Ext.Sheet"},{"type":"member","member":"centered","icon":"cfg","private":false,"sort":3,"id":"Ext.Sheet-cfg-centered","cls":"Ext.Sheet"},{"type":"member","member":"enter","icon":"cfg","private":false,"sort":3,"id":"Ext.Sheet-cfg-enter","cls":"Ext.Sheet"},{"type":"member","member":"exit","icon":"cfg","private":false,"sort":3,"id":"Ext.Sheet-cfg-exit","cls":"Ext.Sheet"},{"type":"member","member":"stretchX","icon":"cfg","private":false,"sort":3,"id":"Ext.Sheet-cfg-stretchX","cls":"Ext.Sheet"},{"type":"member","member":"stretchY","icon":"cfg","private":false,"sort":3,"id":"Ext.Sheet-cfg-stretchY","cls":"Ext.Sheet"},{"type":"member","member":"getCentered","icon":"method","private":false,"sort":3,"id":"Ext.Sheet-method-getCentered","cls":"Ext.Sheet"},{"type":"member","member":"setCentered","icon":"method","private":false,"sort":3,"id":"Ext.Sheet-method-setCentered","cls":"Ext.Sheet"},{"type":"member","member":"centeredchange","icon":"event","private":false,"sort":3,"id":"Ext.Sheet-event-centeredchange","cls":"Ext.Sheet"},{"type":"member","member":"hidden","icon":"property","private":false,"sort":3,"id":"Ext.Sheet-property-hidden","cls":"Ext.Sheet"},{"type":"member","member":"hideAnimation","icon":"property","private":false,"sort":3,"id":"Ext.Sheet-property-hideAnimation","cls":"Ext.Sheet"},{"type":"member","member":"modal","icon":"property","private":false,"sort":3,"id":"Ext.Sheet-property-modal","cls":"Ext.Sheet"},{"type":"member","member":"showAnimation","icon":"property","private":false,"sort":3,"id":"Ext.Sheet-property-showAnimation","cls":"Ext.Sheet"},{"type":"class","member":"ActionSheet","icon":"class","private":false,"sort":1,"id":"Ext.ActionSheet","cls":"Ext.ActionSheet"},{"type":"class","member":"actionsheet","icon":"subclass","private":false,"sort":0,"id":"Ext.ActionSheet","cls":"xtype: actionsheet"},{"type":"class","member":"TitleBar","icon":"class","private":false,"sort":1,"id":"Ext.TitleBar","cls":"Ext.TitleBar"},{"type":"class","member":"titlebar","icon":"subclass","private":false,"sort":0,"id":"Ext.TitleBar","cls":"xtype: titlebar"},{"type":"member","member":"defaultType","icon":"cfg","private":false,"sort":3,"id":"Ext.TitleBar-cfg-defaultType","cls":"Ext.TitleBar"},{"type":"member","member":"items","icon":"cfg","private":false,"sort":3,"id":"Ext.TitleBar-cfg-items","cls":"Ext.TitleBar"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.TitleBar-cfg-title","cls":"Ext.TitleBar"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.TitleBar-cfg-ui","cls":"Ext.TitleBar"},{"type":"member","member":"getDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-getDefaultType","cls":"Ext.TitleBar"},{"type":"member","member":"getItems","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-getItems","cls":"Ext.TitleBar"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-getTitle","cls":"Ext.TitleBar"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-getUi","cls":"Ext.TitleBar"},{"type":"member","member":"setDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-setDefaultType","cls":"Ext.TitleBar"},{"type":"member","member":"setItems","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-setItems","cls":"Ext.TitleBar"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-setTitle","cls":"Ext.TitleBar"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.TitleBar-method-setUi","cls":"Ext.TitleBar"},{"type":"member","member":"layout","icon":"property","private":true,"sort":3,"id":"Ext.TitleBar-property-layout","cls":"Ext.TitleBar"},{"type":"member","member":"maxButtonWidth","icon":"property","private":true,"sort":3,"id":"Ext.TitleBar-property-maxButtonWidth","cls":"Ext.TitleBar"},{"type":"class","member":"Toolbar","icon":"class","private":false,"sort":1,"id":"Ext.Toolbar","cls":"Ext.Toolbar"},{"type":"class","member":"toolbar","icon":"subclass","private":false,"sort":0,"id":"Ext.Toolbar","cls":"xtype: toolbar"},{"type":"member","member":"$include-toolbar-uis","icon":"css_var","private":false,"sort":3,"id":"Ext.Toolbar-css_var-S-include-toolbar-uis","cls":"Ext.Toolbar"},{"type":"member","member":"$toolbar-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.Toolbar-css_var-S-toolbar-gradient","cls":"Ext.Toolbar"},{"type":"member","member":"$toolbar-spacing","icon":"css_var","private":false,"sort":3,"id":"Ext.Toolbar-css_var-S-toolbar-spacing","cls":"Ext.Toolbar"},{"type":"member","member":"sencha-toolbar","icon":"css_mixin","private":false,"sort":3,"id":"Ext.Toolbar-css_mixin-sencha-toolbar","cls":"Ext.Toolbar"},{"type":"member","member":"sencha-toolbar-ui","icon":"css_mixin","private":false,"sort":3,"id":"Ext.Toolbar-css_mixin-sencha-toolbar-ui","cls":"Ext.Toolbar"},{"type":"member","member":"defaultType","icon":"cfg","private":false,"sort":3,"id":"Ext.Toolbar-cfg-defaultType","cls":"Ext.Toolbar"},{"type":"member","member":"docked","icon":"cfg","private":false,"sort":3,"id":"Ext.Toolbar-cfg-docked","cls":"Ext.Toolbar"},{"type":"member","member":"layout","icon":"cfg","private":false,"sort":3,"id":"Ext.Toolbar-cfg-layout","cls":"Ext.Toolbar"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.Toolbar-cfg-title","cls":"Ext.Toolbar"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.Toolbar-cfg-ui","cls":"Ext.Toolbar"},{"type":"member","member":"getDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-getDefaultType","cls":"Ext.Toolbar"},{"type":"member","member":"getDocked","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-getDocked","cls":"Ext.Toolbar"},{"type":"member","member":"getLayout","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-getLayout","cls":"Ext.Toolbar"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-getTitle","cls":"Ext.Toolbar"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-getUi","cls":"Ext.Toolbar"},{"type":"member","member":"hideTitle","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-hideTitle","cls":"Ext.Toolbar"},{"type":"member","member":"setDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-setDefaultType","cls":"Ext.Toolbar"},{"type":"member","member":"setDocked","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-setDocked","cls":"Ext.Toolbar"},{"type":"member","member":"setLayout","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-setLayout","cls":"Ext.Toolbar"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-setTitle","cls":"Ext.Toolbar"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-setUi","cls":"Ext.Toolbar"},{"type":"member","member":"showTitle","icon":"method","private":false,"sort":3,"id":"Ext.Toolbar-method-showTitle","cls":"Ext.Toolbar"},{"type":"class","member":"MessageBox","icon":"class","private":false,"sort":1,"id":"Ext.MessageBox","cls":"Ext.MessageBox"},{"type":"member","member":"sencha-msgbox","icon":"css_mixin","private":false,"sort":3,"id":"Ext.MessageBox-css_mixin-sencha-msgbox","cls":"Ext.MessageBox"},{"type":"member","member":"buttons","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-buttons","cls":"Ext.MessageBox"},{"type":"member","member":"defaultTextHeight","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-defaultTextHeight","cls":"Ext.MessageBox"},{"type":"member","member":"icon","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-icon","cls":"Ext.MessageBox"},{"type":"member","member":"iconCls","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-iconCls","cls":"Ext.MessageBox"},{"type":"member","member":"message","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-message","cls":"Ext.MessageBox"},{"type":"member","member":"msg","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-msg","cls":"Ext.MessageBox"},{"type":"member","member":"prompt","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-prompt","cls":"Ext.MessageBox"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.MessageBox-cfg-title","cls":"Ext.MessageBox"},{"type":"member","member":"alert","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-alert","cls":"Ext.MessageBox"},{"type":"member","member":"applyIconCls","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-applyIconCls","cls":"Ext.MessageBox"},{"type":"member","member":"applyMessage","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-applyMessage","cls":"Ext.MessageBox"},{"type":"member","member":"applyPrompt","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-applyPrompt","cls":"Ext.MessageBox"},{"type":"member","member":"applyTitle","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-applyTitle","cls":"Ext.MessageBox"},{"type":"member","member":"confirm","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-confirm","cls":"Ext.MessageBox"},{"type":"member","member":"getDefaultTextHeight","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-getDefaultTextHeight","cls":"Ext.MessageBox"},{"type":"member","member":"getIconCls","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-getIconCls","cls":"Ext.MessageBox"},{"type":"member","member":"getMessage","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-getMessage","cls":"Ext.MessageBox"},{"type":"member","member":"getPrompt","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-getPrompt","cls":"Ext.MessageBox"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-getTitle","cls":"Ext.MessageBox"},{"type":"member","member":"prompt","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-prompt","cls":"Ext.MessageBox"},{"type":"member","member":"setDefaultTextHeight","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setDefaultTextHeight","cls":"Ext.MessageBox"},{"type":"member","member":"setIcon","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setIcon","cls":"Ext.MessageBox"},{"type":"member","member":"setIconCls","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setIconCls","cls":"Ext.MessageBox"},{"type":"member","member":"setMessage","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setMessage","cls":"Ext.MessageBox"},{"type":"member","member":"setPrompt","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setPrompt","cls":"Ext.MessageBox"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-setTitle","cls":"Ext.MessageBox"},{"type":"member","member":"show","icon":"method","private":false,"sort":3,"id":"Ext.MessageBox-method-show","cls":"Ext.MessageBox"},{"type":"member","member":"updateButtons","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-updateButtons","cls":"Ext.MessageBox"},{"type":"member","member":"updateIconCls","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-updateIconCls","cls":"Ext.MessageBox"},{"type":"member","member":"updateMessage","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-updateMessage","cls":"Ext.MessageBox"},{"type":"member","member":"updatePrompt","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-updatePrompt","cls":"Ext.MessageBox"},{"type":"member","member":"updateTitle","icon":"method","private":true,"sort":3,"id":"Ext.MessageBox-method-updateTitle","cls":"Ext.MessageBox"},{"type":"member","member":"zIndex","icon":"property","private":false,"sort":3,"id":"Ext.MessageBox-property-zIndex","cls":"Ext.MessageBox"},{"type":"class","member":"Msg","icon":"class","private":false,"sort":1,"id":"Ext.Msg","cls":"Ext.Msg"},{"type":"class","member":"Carousel","icon":"class","private":false,"sort":1,"id":"Ext.carousel.Carousel","cls":"Ext.carousel.Carousel"},{"type":"class","member":"Carousel","icon":"subclass","private":false,"sort":2,"id":"Ext.carousel.Carousel","cls":"Ext.Carousel"},{"type":"class","member":"carousel","icon":"subclass","private":false,"sort":0,"id":"Ext.carousel.Carousel","cls":"xtype: carousel"},{"type":"member","member":"sencha-carousel","icon":"css_mixin","private":false,"sort":3,"id":"Ext.carousel.Carousel-css_mixin-sencha-carousel","cls":"Ext.carousel.Carousel"},{"type":"member","member":"direction","icon":"cfg","private":false,"sort":3,"id":"Ext.carousel.Carousel-cfg-direction","cls":"Ext.carousel.Carousel"},{"type":"member","member":"indicator","icon":"cfg","private":false,"sort":3,"id":"Ext.carousel.Carousel-cfg-indicator","cls":"Ext.carousel.Carousel"},{"type":"member","member":"layout","icon":"cfg","private":true,"sort":3,"id":"Ext.carousel.Carousel-cfg-layout","cls":"Ext.carousel.Carousel"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.carousel.Carousel-cfg-ui","cls":"Ext.carousel.Carousel"},{"type":"member","member":"getActiveIndex","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-getActiveIndex","cls":"Ext.carousel.Carousel"},{"type":"member","member":"getDirection","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-getDirection","cls":"Ext.carousel.Carousel"},{"type":"member","member":"getIndicator","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-getIndicator","cls":"Ext.carousel.Carousel"},{"type":"member","member":"getLayout","icon":"method","private":true,"sort":3,"id":"Ext.carousel.Carousel-method-getLayout","cls":"Ext.carousel.Carousel"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-getUi","cls":"Ext.carousel.Carousel"},{"type":"member","member":"next","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-next","cls":"Ext.carousel.Carousel"},{"type":"member","member":"previous","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-previous","cls":"Ext.carousel.Carousel"},{"type":"member","member":"setDirection","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-setDirection","cls":"Ext.carousel.Carousel"},{"type":"member","member":"setIndicator","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-setIndicator","cls":"Ext.carousel.Carousel"},{"type":"member","member":"setLayout","icon":"method","private":true,"sort":3,"id":"Ext.carousel.Carousel-method-setLayout","cls":"Ext.carousel.Carousel"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.carousel.Carousel-method-setUi","cls":"Ext.carousel.Carousel"},{"type":"class","member":"DataItem","icon":"class","private":false,"sort":1,"id":"Ext.dataview.component.DataItem","cls":"Ext.dataview.component.DataItem"},{"type":"class","member":"dataitem","icon":"subclass","private":false,"sort":0,"id":"Ext.dataview.component.DataItem","cls":"xtype: dataitem"},{"type":"member","member":"dataMap","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-cfg-dataMap","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"itemCls","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-cfg-itemCls","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"record","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-cfg-record","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"getItemCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-method-getItemCls","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"getRecord","icon":"method","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-method-getRecord","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"setItemCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-method-setItemCls","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"setRecord","icon":"method","private":false,"sort":3,"id":"Ext.dataview.component.DataItem-method-setRecord","cls":"Ext.dataview.component.DataItem"},{"type":"member","member":"updateRecord","icon":"method","private":true,"sort":3,"id":"Ext.dataview.component.DataItem-method-updateRecord","cls":"Ext.dataview.component.DataItem"},{"type":"class","member":"Container","icon":"class","private":true,"sort":1,"id":"Ext.dataview.component.Container","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemdoubletap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemdoubletap","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemswipe","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemswipe","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemtap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemtap","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemtaphold","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemtaphold","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemtouchend","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemtouchend","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemtouchmove","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemtouchmove","cls":"Ext.dataview.component.Container"},{"type":"member","member":"itemtouchstart","icon":"event","private":false,"sort":3,"id":"Ext.dataview.component.Container-event-itemtouchstart","cls":"Ext.dataview.component.Container"},{"type":"class","member":"DataView","icon":"class","private":false,"sort":1,"id":"Ext.dataview.DataView","cls":"Ext.dataview.DataView"},{"type":"class","member":"DataView","icon":"subclass","private":false,"sort":2,"id":"Ext.dataview.DataView","cls":"Ext.DataView"},{"type":"class","member":"dataview","icon":"subclass","private":false,"sort":0,"id":"Ext.dataview.DataView","cls":"xtype: dataview"},{"type":"member","member":"defaultType","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-defaultType","cls":"Ext.dataview.DataView"},{"type":"member","member":"deferEmptyText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-deferEmptyText","cls":"Ext.dataview.DataView"},{"type":"member","member":"deselectOnContainerClick","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-deselectOnContainerClick","cls":"Ext.dataview.DataView"},{"type":"member","member":"emptyText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-emptyText","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemCls","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-itemCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemConfig","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-itemConfig","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemTpl","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-itemTpl","cls":"Ext.dataview.DataView"},{"type":"member","member":"layout","icon":"cfg","private":true,"sort":3,"id":"Ext.dataview.DataView-cfg-layout","cls":"Ext.dataview.DataView"},{"type":"member","member":"loadingText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-loadingText","cls":"Ext.dataview.DataView"},{"type":"member","member":"maxItemCache","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-maxItemCache","cls":"Ext.dataview.DataView"},{"type":"member","member":"pressedCls","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-pressedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"pressedDelay","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-pressedDelay","cls":"Ext.dataview.DataView"},{"type":"member","member":"scrollToTopOnRefresh","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-scrollToTopOnRefresh","cls":"Ext.dataview.DataView"},{"type":"member","member":"selectedCls","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-selectedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"store","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-store","cls":"Ext.dataview.DataView"},{"type":"member","member":"triggerCtEvent","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-triggerCtEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"triggerEvent","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-triggerEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"useComponents","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.DataView-cfg-useComponents","cls":"Ext.dataview.DataView"},{"type":"member","member":"bindStore","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-bindStore","cls":"Ext.dataview.DataView"},{"type":"member","member":"getDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getDefaultType","cls":"Ext.dataview.DataView"},{"type":"member","member":"getDeselectOnContainerClick","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getDeselectOnContainerClick","cls":"Ext.dataview.DataView"},{"type":"member","member":"getItemCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getItemCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"getItemConfig","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getItemConfig","cls":"Ext.dataview.DataView"},{"type":"member","member":"getLayout","icon":"method","private":true,"sort":3,"id":"Ext.dataview.DataView-method-getLayout","cls":"Ext.dataview.DataView"},{"type":"member","member":"getMaxItemCache","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getMaxItemCache","cls":"Ext.dataview.DataView"},{"type":"member","member":"getPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getPressedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"getPressedDelay","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getPressedDelay","cls":"Ext.dataview.DataView"},{"type":"member","member":"getScrollToTopOnRefresh","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getScrollToTopOnRefresh","cls":"Ext.dataview.DataView"},{"type":"member","member":"getSelectedCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getSelectedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"getStore","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getStore","cls":"Ext.dataview.DataView"},{"type":"member","member":"getTriggerCtEvent","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getTriggerCtEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"getTriggerEvent","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getTriggerEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"getUseComponents","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-getUseComponents","cls":"Ext.dataview.DataView"},{"type":"member","member":"prepareData","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-prepareData","cls":"Ext.dataview.DataView"},{"type":"member","member":"refresh","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-refresh","cls":"Ext.dataview.DataView"},{"type":"member","member":"setDefaultType","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setDefaultType","cls":"Ext.dataview.DataView"},{"type":"member","member":"setDeselectOnContainerClick","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setDeselectOnContainerClick","cls":"Ext.dataview.DataView"},{"type":"member","member":"setItemCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setItemCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"setItemConfig","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setItemConfig","cls":"Ext.dataview.DataView"},{"type":"member","member":"setLayout","icon":"method","private":true,"sort":3,"id":"Ext.dataview.DataView-method-setLayout","cls":"Ext.dataview.DataView"},{"type":"member","member":"setMaxItemCache","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setMaxItemCache","cls":"Ext.dataview.DataView"},{"type":"member","member":"setPressedCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setPressedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"setPressedDelay","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setPressedDelay","cls":"Ext.dataview.DataView"},{"type":"member","member":"setScrollToTopOnRefresh","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setScrollToTopOnRefresh","cls":"Ext.dataview.DataView"},{"type":"member","member":"setSelectedCls","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setSelectedCls","cls":"Ext.dataview.DataView"},{"type":"member","member":"setStore","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setStore","cls":"Ext.dataview.DataView"},{"type":"member","member":"setTriggerCtEvent","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setTriggerCtEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"setTriggerEvent","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setTriggerEvent","cls":"Ext.dataview.DataView"},{"type":"member","member":"setUseComponents","icon":"method","private":false,"sort":3,"id":"Ext.dataview.DataView-method-setUseComponents","cls":"Ext.dataview.DataView"},{"type":"member","member":"add","icon":"event","private":true,"sort":3,"id":"Ext.dataview.DataView-event-add","cls":"Ext.dataview.DataView"},{"type":"member","member":"deselect","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-deselect","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemdoubletap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemdoubletap","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemswipe","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemswipe","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemtap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemtap","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemtaphold","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemtaphold","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemtouchend","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemtouchend","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemtouchmove","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemtouchmove","cls":"Ext.dataview.DataView"},{"type":"member","member":"itemtouchstart","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-itemtouchstart","cls":"Ext.dataview.DataView"},{"type":"member","member":"move","icon":"event","private":true,"sort":3,"id":"Ext.dataview.DataView-event-move","cls":"Ext.dataview.DataView"},{"type":"member","member":"refresh","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-refresh","cls":"Ext.dataview.DataView"},{"type":"member","member":"remove","icon":"event","private":true,"sort":3,"id":"Ext.dataview.DataView-event-remove","cls":"Ext.dataview.DataView"},{"type":"member","member":"select","icon":"event","private":false,"sort":3,"id":"Ext.dataview.DataView-event-select","cls":"Ext.dataview.DataView"},{"type":"class","member":"List","icon":"class","private":false,"sort":1,"id":"Ext.dataview.List","cls":"Ext.dataview.List"},{"type":"class","member":"List","icon":"subclass","private":false,"sort":2,"id":"Ext.dataview.List","cls":"Ext.List"},{"type":"class","member":"list","icon":"subclass","private":false,"sort":0,"id":"Ext.dataview.List","cls":"xtype: list"},{"type":"member","member":"$include-list-highlights","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-include-list-highlights","cls":"Ext.dataview.List"},{"type":"member","member":"$list-active-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-active-color","cls":"Ext.dataview.List"},{"type":"member","member":"$list-active-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-active-gradient","cls":"Ext.dataview.List"},{"type":"member","member":"$list-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-bg-color","cls":"Ext.dataview.List"},{"type":"member","member":"$list-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-color","cls":"Ext.dataview.List"},{"type":"member","member":"$list-disclosure-size","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-disclosure-size","cls":"Ext.dataview.List"},{"type":"member","member":"$list-header-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-header-bg-color","cls":"Ext.dataview.List"},{"type":"member","member":"$list-header-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-header-gradient","cls":"Ext.dataview.List"},{"type":"member","member":"$list-pressed-color","icon":"css_var","private":false,"sort":3,"id":"Ext.dataview.List-css_var-S-list-pressed-color","cls":"Ext.dataview.List"},{"type":"member","member":"sencha-list","icon":"css_mixin","private":false,"sort":3,"id":"Ext.dataview.List-css_mixin-sencha-list","cls":"Ext.dataview.List"},{"type":"member","member":"clearSelectionOnDeactivate","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-clearSelectionOnDeactivate","cls":"Ext.dataview.List"},{"type":"member","member":"grouped","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-grouped","cls":"Ext.dataview.List"},{"type":"member","member":"indexBar","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-indexBar","cls":"Ext.dataview.List"},{"type":"member","member":"onItemDisclosure","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-onItemDisclosure","cls":"Ext.dataview.List"},{"type":"member","member":"pinHeaders","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-pinHeaders","cls":"Ext.dataview.List"},{"type":"member","member":"preventSelectionOnDisclose","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.List-cfg-preventSelectionOnDisclose","cls":"Ext.dataview.List"},{"type":"member","member":"getGrouped","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-getGrouped","cls":"Ext.dataview.List"},{"type":"member","member":"getIndexBar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-getIndexBar","cls":"Ext.dataview.List"},{"type":"member","member":"getOnItemDisclosure","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-getOnItemDisclosure","cls":"Ext.dataview.List"},{"type":"member","member":"getPinHeaders","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-getPinHeaders","cls":"Ext.dataview.List"},{"type":"member","member":"getPreventSelectionOnDisclose","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-getPreventSelectionOnDisclose","cls":"Ext.dataview.List"},{"type":"member","member":"setActiveGroup","icon":"method","private":true,"sort":3,"id":"Ext.dataview.List-method-setActiveGroup","cls":"Ext.dataview.List"},{"type":"member","member":"setGrouped","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-setGrouped","cls":"Ext.dataview.List"},{"type":"member","member":"setIndexBar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-setIndexBar","cls":"Ext.dataview.List"},{"type":"member","member":"setOnItemDisclosure","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-setOnItemDisclosure","cls":"Ext.dataview.List"},{"type":"member","member":"setPinHeaders","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-setPinHeaders","cls":"Ext.dataview.List"},{"type":"member","member":"setPreventSelectionOnDisclose","icon":"method","private":false,"sort":3,"id":"Ext.dataview.List-method-setPreventSelectionOnDisclose","cls":"Ext.dataview.List"},{"type":"member","member":"disclose","icon":"event","private":false,"sort":3,"id":"Ext.dataview.List-event-disclose","cls":"Ext.dataview.List"},{"type":"class","member":"NestedList","icon":"class","private":false,"sort":1,"id":"Ext.dataview.NestedList","cls":"Ext.dataview.NestedList"},{"type":"class","member":"NestedList","icon":"subclass","private":false,"sort":2,"id":"Ext.dataview.NestedList","cls":"Ext.NestedList"},{"type":"class","member":"nestedlist","icon":"subclass","private":false,"sort":0,"id":"Ext.dataview.NestedList","cls":"xtype: nestedlist"},{"type":"member","member":"allowDeselect","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-allowDeselect","cls":"Ext.dataview.NestedList"},{"type":"member","member":"backButton","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-backButton","cls":"Ext.dataview.NestedList"},{"type":"member","member":"backText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-backText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"cardSwitchAnimation","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-cardSwitchAnimation","cls":"Ext.dataview.NestedList"},{"type":"member","member":"detailCard","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-detailCard","cls":"Ext.dataview.NestedList"},{"type":"member","member":"detailContainer","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-detailContainer","cls":"Ext.dataview.NestedList"},{"type":"member","member":"displayField","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-displayField","cls":"Ext.dataview.NestedList"},{"type":"member","member":"emptyText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-emptyText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"layout","icon":"cfg","private":true,"sort":3,"id":"Ext.dataview.NestedList-cfg-layout","cls":"Ext.dataview.NestedList"},{"type":"member","member":"listConfig","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-listConfig","cls":"Ext.dataview.NestedList"},{"type":"member","member":"loadingText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-loadingText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"onItemDisclosure","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-onItemDisclosure","cls":"Ext.dataview.NestedList"},{"type":"member","member":"store","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-store","cls":"Ext.dataview.NestedList"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-title","cls":"Ext.dataview.NestedList"},{"type":"member","member":"toolbar","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-toolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"updateTitleText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-updateTitleText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"useTitleAsBackText","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-useTitleAsBackText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"useToolbar","icon":"cfg","private":false,"sort":3,"id":"Ext.dataview.NestedList-cfg-useToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getAllowDeselect","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getAllowDeselect","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getBackText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getBackText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getDetailCard","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getDetailCard","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getDetailContainer","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getDetailContainer","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getDisplayField","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getEmptyText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getEmptyText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getItemTextTpl","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getItemTextTpl","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getLayout","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-getLayout","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getList","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-getList","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getLoadingText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getLoadingText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getOnItemDisclosure","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getOnItemDisclosure","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getTitle","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getTitleTextTpl","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getTitleTextTpl","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getToolbar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getUpdateTitleText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getUpdateTitleText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getUseTitleAsBackText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getUseTitleAsBackText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"getUseToolbar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-getUseToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"goToLeaf","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-goToLeaf","cls":"Ext.dataview.NestedList"},{"type":"member","member":"goToNode","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-goToNode","cls":"Ext.dataview.NestedList"},{"type":"member","member":"goToNodeReverseAnimation","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-goToNodeReverseAnimation","cls":"Ext.dataview.NestedList"},{"type":"member","member":"onBackTap","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-onBackTap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"onItemTap","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-onItemTap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"renderTitleText","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-renderTitleText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setAllowDeselect","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setAllowDeselect","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setBackText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setBackText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setDetailCard","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setDetailCard","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setDetailContainer","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setDetailContainer","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setDisplayField","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setEmptyText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setEmptyText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setLayout","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-setLayout","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setLoadingText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setLoadingText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setOnItemDisclosure","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setOnItemDisclosure","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setTitle","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setToolbar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setUpdateTitleText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setUpdateTitleText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setUseTitleAsBackText","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setUseTitleAsBackText","cls":"Ext.dataview.NestedList"},{"type":"member","member":"setUseToolbar","icon":"method","private":false,"sort":3,"id":"Ext.dataview.NestedList-method-setUseToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"syncToolbar","icon":"method","private":true,"sort":3,"id":"Ext.dataview.NestedList-method-syncToolbar","cls":"Ext.dataview.NestedList"},{"type":"member","member":"back","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-back","cls":"Ext.dataview.NestedList"},{"type":"member","member":"beforeload","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-beforeload","cls":"Ext.dataview.NestedList"},{"type":"member","member":"beforeselect","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-beforeselect","cls":"Ext.dataview.NestedList"},{"type":"member","member":"containertap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-containertap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"itemdoubletap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-itemdoubletap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"itemtap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-itemtap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"leafitemtap","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-leafitemtap","cls":"Ext.dataview.NestedList"},{"type":"member","member":"listchange","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-listchange","cls":"Ext.dataview.NestedList"},{"type":"member","member":"load","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-load","cls":"Ext.dataview.NestedList"},{"type":"member","member":"selectionchange","icon":"event","private":false,"sort":3,"id":"Ext.dataview.NestedList-event-selectionchange","cls":"Ext.dataview.NestedList"},{"type":"class","member":"FieldSet","icon":"class","private":false,"sort":1,"id":"Ext.form.FieldSet","cls":"Ext.form.FieldSet"},{"type":"class","member":"fieldset","icon":"subclass","private":false,"sort":0,"id":"Ext.form.FieldSet","cls":"xtype: fieldset"},{"type":"member","member":"$form-fieldset-radius","icon":"css_var","private":false,"sort":3,"id":"Ext.form.FieldSet-css_var-S-form-fieldset-radius","cls":"Ext.form.FieldSet"},{"type":"member","member":"instructions","icon":"cfg","private":false,"sort":3,"id":"Ext.form.FieldSet-cfg-instructions","cls":"Ext.form.FieldSet"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.form.FieldSet-cfg-title","cls":"Ext.form.FieldSet"},{"type":"member","member":"getInstructions","icon":"method","private":false,"sort":3,"id":"Ext.form.FieldSet-method-getInstructions","cls":"Ext.form.FieldSet"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.form.FieldSet-method-getTitle","cls":"Ext.form.FieldSet"},{"type":"member","member":"setInstructions","icon":"method","private":false,"sort":3,"id":"Ext.form.FieldSet-method-setInstructions","cls":"Ext.form.FieldSet"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.form.FieldSet-method-setTitle","cls":"Ext.form.FieldSet"},{"type":"class","member":"Panel","icon":"class","private":false,"sort":1,"id":"Ext.form.Panel","cls":"Ext.form.Panel"},{"type":"class","member":"FormPanel","icon":"subclass","private":false,"sort":2,"id":"Ext.form.Panel","cls":"Ext.form.FormPanel"},{"type":"class","member":"formpanel","icon":"subclass","private":false,"sort":0,"id":"Ext.form.Panel","cls":"xtype: formpanel"},{"type":"member","member":"$form-bg-color","icon":"css_var","private":false,"sort":3,"id":"Ext.form.Panel-css_var-S-form-bg-color","cls":"Ext.form.Panel"},{"type":"member","member":"sencha-form","icon":"css_mixin","private":false,"sort":3,"id":"Ext.form.Panel-css_mixin-sencha-form","cls":"Ext.form.Panel"},{"type":"member","member":"baseParams","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-baseParams","cls":"Ext.form.Panel"},{"type":"member","member":"method","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-method","cls":"Ext.form.Panel"},{"type":"member","member":"record","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-record","cls":"Ext.form.Panel"},{"type":"member","member":"standardSubmit","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-standardSubmit","cls":"Ext.form.Panel"},{"type":"member","member":"submitOnAction","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-submitOnAction","cls":"Ext.form.Panel"},{"type":"member","member":"url","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-url","cls":"Ext.form.Panel"},{"type":"member","member":"waitMsgTarget","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-waitMsgTarget","cls":"Ext.form.Panel"},{"type":"member","member":"waitTpl","icon":"cfg","private":false,"sort":3,"id":"Ext.form.Panel-cfg-waitTpl","cls":"Ext.form.Panel"},{"type":"member","member":"disable","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-disable","cls":"Ext.form.Panel"},{"type":"member","member":"enable","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-enable","cls":"Ext.form.Panel"},{"type":"member","member":"focusNextField","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-focusNextField","cls":"Ext.form.Panel"},{"type":"member","member":"focusPreviousField","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-focusPreviousField","cls":"Ext.form.Panel"},{"type":"member","member":"getBaseParams","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getBaseParams","cls":"Ext.form.Panel"},{"type":"member","member":"getFields","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getFields","cls":"Ext.form.Panel"},{"type":"member","member":"getFieldsArray","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getFieldsArray","cls":"Ext.form.Panel"},{"type":"member","member":"getFieldsAsArray","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getFieldsAsArray","cls":"Ext.form.Panel"},{"type":"member","member":"getFocusedField","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getFocusedField","cls":"Ext.form.Panel"},{"type":"member","member":"getNextField","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getNextField","cls":"Ext.form.Panel"},{"type":"member","member":"getPreviousField","icon":"method","private":true,"sort":3,"id":"Ext.form.Panel-method-getPreviousField","cls":"Ext.form.Panel"},{"type":"member","member":"getRecord","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getRecord","cls":"Ext.form.Panel"},{"type":"member","member":"getStandardSubmit","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getStandardSubmit","cls":"Ext.form.Panel"},{"type":"member","member":"getSubmitOnAction","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getSubmitOnAction","cls":"Ext.form.Panel"},{"type":"member","member":"getUrl","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getUrl","cls":"Ext.form.Panel"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-getValues","cls":"Ext.form.Panel"},{"type":"member","member":"hideMask","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-hideMask","cls":"Ext.form.Panel"},{"type":"member","member":"reset","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-reset","cls":"Ext.form.Panel"},{"type":"member","member":"setBaseParams","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setBaseParams","cls":"Ext.form.Panel"},{"type":"member","member":"setRecord","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setRecord","cls":"Ext.form.Panel"},{"type":"member","member":"setStandardSubmit","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setStandardSubmit","cls":"Ext.form.Panel"},{"type":"member","member":"setSubmitOnAction","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setSubmitOnAction","cls":"Ext.form.Panel"},{"type":"member","member":"setUrl","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setUrl","cls":"Ext.form.Panel"},{"type":"member","member":"setValues","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-setValues","cls":"Ext.form.Panel"},{"type":"member","member":"showMask","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-showMask","cls":"Ext.form.Panel"},{"type":"member","member":"submit","icon":"method","private":false,"sort":3,"id":"Ext.form.Panel-method-submit","cls":"Ext.form.Panel"},{"type":"member","member":"beforesubmit","icon":"event","private":false,"sort":3,"id":"Ext.form.Panel-event-beforesubmit","cls":"Ext.form.Panel"},{"type":"member","member":"exception","icon":"event","private":false,"sort":3,"id":"Ext.form.Panel-event-exception","cls":"Ext.form.Panel"},{"type":"member","member":"submit","icon":"event","private":false,"sort":3,"id":"Ext.form.Panel-event-submit","cls":"Ext.form.Panel"},{"type":"class","member":"Bar","icon":"class","private":true,"sort":1,"id":"Ext.navigation.Bar","cls":"Ext.navigation.Bar"},{"type":"member","member":"animations","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-animations","cls":"Ext.navigation.Bar"},{"type":"member","member":"backButton","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-backButton","cls":"Ext.navigation.Bar"},{"type":"member","member":"defaultBackButtonText","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-defaultBackButtonText","cls":"Ext.navigation.Bar"},{"type":"member","member":"items","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-items","cls":"Ext.navigation.Bar"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.navigation.Bar-cfg-ui","cls":"Ext.navigation.Bar"},{"type":"member","member":"useTitleForBackButtonText","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-useTitleForBackButtonText","cls":"Ext.navigation.Bar"},{"type":"member","member":"view","icon":"cfg","private":true,"sort":3,"id":"Ext.navigation.Bar-cfg-view","cls":"Ext.navigation.Bar"},{"type":"member","member":"animate","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-animate","cls":"Ext.navigation.Bar"},{"type":"member","member":"applyBackButton","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-applyBackButton","cls":"Ext.navigation.Bar"},{"type":"member","member":"createNavigationBarProxy","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-createNavigationBarProxy","cls":"Ext.navigation.Bar"},{"type":"member","member":"createProxy","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-createProxy","cls":"Ext.navigation.Bar"},{"type":"member","member":"doSetHidden","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-doSetHidden","cls":"Ext.navigation.Bar"},{"type":"member","member":"getBackButtonAnimationProperties","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getBackButtonAnimationProperties","cls":"Ext.navigation.Bar"},{"type":"member","member":"getBackButtonAnimationReverseProperties","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getBackButtonAnimationReverseProperties","cls":"Ext.navigation.Bar"},{"type":"member","member":"getBackButtonText","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getBackButtonText","cls":"Ext.navigation.Bar"},{"type":"member","member":"getItems","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getItems","cls":"Ext.navigation.Bar"},{"type":"member","member":"getNavigationBarProxyProperties","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getNavigationBarProxyProperties","cls":"Ext.navigation.Bar"},{"type":"member","member":"getTitleAnimationProperties","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getTitleAnimationProperties","cls":"Ext.navigation.Bar"},{"type":"member","member":"getTitleAnimationReverseProperties","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getTitleAnimationReverseProperties","cls":"Ext.navigation.Bar"},{"type":"member","member":"getTitleText","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-getTitleText","cls":"Ext.navigation.Bar"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.navigation.Bar-method-getUi","cls":"Ext.navigation.Bar"},{"type":"member","member":"onBeforePop","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-onBeforePop","cls":"Ext.navigation.Bar"},{"type":"member","member":"onSizeMonitorChange","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-onSizeMonitorChange","cls":"Ext.navigation.Bar"},{"type":"member","member":"onViewAdd","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-onViewAdd","cls":"Ext.navigation.Bar"},{"type":"member","member":"onViewRemove","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-onViewRemove","cls":"Ext.navigation.Bar"},{"type":"member","member":"popBackButton","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-popBackButton","cls":"Ext.navigation.Bar"},{"type":"member","member":"popBackButtonAnimated","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-popBackButtonAnimated","cls":"Ext.navigation.Bar"},{"type":"member","member":"popTitle","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-popTitle","cls":"Ext.navigation.Bar"},{"type":"member","member":"popTitleAnimated","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-popTitleAnimated","cls":"Ext.navigation.Bar"},{"type":"member","member":"pushBackButton","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-pushBackButton","cls":"Ext.navigation.Bar"},{"type":"member","member":"pushBackButtonAnimated","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-pushBackButtonAnimated","cls":"Ext.navigation.Bar"},{"type":"member","member":"pushTitle","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-pushTitle","cls":"Ext.navigation.Bar"},{"type":"member","member":"pushTitleAnimated","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-pushTitleAnimated","cls":"Ext.navigation.Bar"},{"type":"member","member":"refreshNavigationBarProxy","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-refreshNavigationBarProxy","cls":"Ext.navigation.Bar"},{"type":"member","member":"setItems","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-setItems","cls":"Ext.navigation.Bar"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.navigation.Bar-method-setUi","cls":"Ext.navigation.Bar"},{"type":"member","member":"updateBackButton","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-updateBackButton","cls":"Ext.navigation.Bar"},{"type":"member","member":"updateView","icon":"method","private":true,"sort":3,"id":"Ext.navigation.Bar-method-updateView","cls":"Ext.navigation.Bar"},{"type":"member","member":"defaultType","icon":"property","private":true,"sort":3,"id":"Ext.navigation.Bar-property-defaultType","cls":"Ext.navigation.Bar"},{"type":"member","member":"layout","icon":"property","private":true,"sort":3,"id":"Ext.navigation.Bar-property-layout","cls":"Ext.navigation.Bar"},{"type":"member","member":"minBackButtonWidth","icon":"property","private":true,"sort":3,"id":"Ext.navigation.Bar-property-minBackButtonWidth","cls":"Ext.navigation.Bar"},{"type":"member","member":"title","icon":"property","private":true,"sort":3,"id":"Ext.navigation.Bar-property-title","cls":"Ext.navigation.Bar"},{"type":"class","member":"View","icon":"class","private":false,"sort":1,"id":"Ext.navigation.View","cls":"Ext.navigation.View"},{"type":"class","member":"NavigationView","icon":"subclass","private":false,"sort":2,"id":"Ext.navigation.View","cls":"Ext.NavigationView"},{"type":"class","member":"navigationview","icon":"subclass","private":false,"sort":0,"id":"Ext.navigation.View","cls":"xtype: navigationview"},{"type":"member","member":"defaultBackButtonText","icon":"cfg","private":false,"sort":3,"id":"Ext.navigation.View-cfg-defaultBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"items","icon":"cfg","private":false,"sort":3,"id":"Ext.navigation.View-cfg-items","cls":"Ext.navigation.View"},{"type":"member","member":"navigationBar","icon":"cfg","private":false,"sort":3,"id":"Ext.navigation.View-cfg-navigationBar","cls":"Ext.navigation.View"},{"type":"member","member":"useTitleForBackButtonText","icon":"cfg","private":false,"sort":3,"id":"Ext.navigation.View-cfg-useTitleForBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"applyActiveItem","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-applyActiveItem","cls":"Ext.navigation.View"},{"type":"member","member":"applyLayout","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-applyLayout","cls":"Ext.navigation.View"},{"type":"member","member":"doPop","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-doPop","cls":"Ext.navigation.View"},{"type":"member","member":"doRemove","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-doRemove","cls":"Ext.navigation.View"},{"type":"member","member":"getDefaultBackButtonText","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-getDefaultBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"getItems","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-getItems","cls":"Ext.navigation.View"},{"type":"member","member":"getNavigationBar","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-getNavigationBar","cls":"Ext.navigation.View"},{"type":"member","member":"getPreviousItem","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-getPreviousItem","cls":"Ext.navigation.View"},{"type":"member","member":"getUseTitleForBackButtonText","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-getUseTitleForBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"onBackButtonTap","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-onBackButtonTap","cls":"Ext.navigation.View"},{"type":"member","member":"onBeforePop","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-onBeforePop","cls":"Ext.navigation.View"},{"type":"member","member":"onItemAdd","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-onItemAdd","cls":"Ext.navigation.View"},{"type":"member","member":"pop","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-pop","cls":"Ext.navigation.View"},{"type":"member","member":"push","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-push","cls":"Ext.navigation.View"},{"type":"member","member":"reset","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-reset","cls":"Ext.navigation.View"},{"type":"member","member":"setDefaultBackButtonText","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-setDefaultBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"setItems","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-setItems","cls":"Ext.navigation.View"},{"type":"member","member":"setNavigationBar","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-setNavigationBar","cls":"Ext.navigation.View"},{"type":"member","member":"setUseTitleForBackButtonText","icon":"method","private":false,"sort":3,"id":"Ext.navigation.View-method-setUseTitleForBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"updateUseTitleForBackButtonText","icon":"method","private":true,"sort":3,"id":"Ext.navigation.View-method-updateUseTitleForBackButtonText","cls":"Ext.navigation.View"},{"type":"member","member":"pop","icon":"event","private":false,"sort":3,"id":"Ext.navigation.View-event-pop","cls":"Ext.navigation.View"},{"type":"member","member":"push","icon":"event","private":false,"sort":3,"id":"Ext.navigation.View-event-push","cls":"Ext.navigation.View"},{"type":"member","member":"layout","icon":"property","private":true,"sort":3,"id":"Ext.navigation.View-property-layout","cls":"Ext.navigation.View"},{"type":"class","member":"Slot","icon":"class","private":true,"sort":1,"id":"Ext.picker.Slot","cls":"Ext.picker.Slot"},{"type":"class","member":"Picker.Slot","icon":"subclass","private":true,"sort":2,"id":"Ext.picker.Slot","cls":"Ext.Picker.Slot"},{"type":"class","member":"pickerslot","icon":"subclass","private":true,"sort":0,"id":"Ext.picker.Slot","cls":"xtype: pickerslot"},{"type":"member","member":"align","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-align","cls":"Ext.picker.Slot"},{"type":"member","member":"cls","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Slot-cfg-cls","cls":"Ext.picker.Slot"},{"type":"member","member":"displayField","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-displayField","cls":"Ext.picker.Slot"},{"type":"member","member":"flex","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Slot-cfg-flex","cls":"Ext.picker.Slot"},{"type":"member","member":"itemSelector","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Slot-cfg-itemSelector","cls":"Ext.picker.Slot"},{"type":"member","member":"name","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-name","cls":"Ext.picker.Slot"},{"type":"member","member":"scrollable","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Slot-cfg-scrollable","cls":"Ext.picker.Slot"},{"type":"member","member":"showTitle","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Slot-cfg-showTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"title","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-title","cls":"Ext.picker.Slot"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-value","cls":"Ext.picker.Slot"},{"type":"member","member":"valueField","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Slot-cfg-valueField","cls":"Ext.picker.Slot"},{"type":"member","member":"applyData","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-applyData","cls":"Ext.picker.Slot"},{"type":"member","member":"applyTitle","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-applyTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"getAlign","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-getAlign","cls":"Ext.picker.Slot"},{"type":"member","member":"getCls","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getCls","cls":"Ext.picker.Slot"},{"type":"member","member":"getDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-getDisplayField","cls":"Ext.picker.Slot"},{"type":"member","member":"getFlex","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getFlex","cls":"Ext.picker.Slot"},{"type":"member","member":"getItemSelector","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getItemSelector","cls":"Ext.picker.Slot"},{"type":"member","member":"getName","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-getName","cls":"Ext.picker.Slot"},{"type":"member","member":"getPicker","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getPicker","cls":"Ext.picker.Slot"},{"type":"member","member":"getScrollable","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getScrollable","cls":"Ext.picker.Slot"},{"type":"member","member":"getShowTitle","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getShowTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"getTitle","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-getTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"getValue","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-getValue","cls":"Ext.picker.Slot"},{"type":"member","member":"getValueField","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-getValueField","cls":"Ext.picker.Slot"},{"type":"member","member":"setAlign","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-setAlign","cls":"Ext.picker.Slot"},{"type":"member","member":"setCls","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setCls","cls":"Ext.picker.Slot"},{"type":"member","member":"setDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-setDisplayField","cls":"Ext.picker.Slot"},{"type":"member","member":"setFlex","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setFlex","cls":"Ext.picker.Slot"},{"type":"member","member":"setItemSelector","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setItemSelector","cls":"Ext.picker.Slot"},{"type":"member","member":"setName","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-setName","cls":"Ext.picker.Slot"},{"type":"member","member":"setScrollable","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setScrollable","cls":"Ext.picker.Slot"},{"type":"member","member":"setShowTitle","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setShowTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"setTitle","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-setTitle","cls":"Ext.picker.Slot"},{"type":"member","member":"setValue","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setValue","cls":"Ext.picker.Slot"},{"type":"member","member":"setValueAnimated","icon":"method","private":true,"sort":3,"id":"Ext.picker.Slot-method-setValueAnimated","cls":"Ext.picker.Slot"},{"type":"member","member":"setValueField","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-setValueField","cls":"Ext.picker.Slot"},{"type":"member","member":"updateAlign","icon":"method","private":false,"sort":3,"id":"Ext.picker.Slot-method-updateAlign","cls":"Ext.picker.Slot"},{"type":"member","member":"slotpick","icon":"event","private":false,"sort":3,"id":"Ext.picker.Slot-event-slotpick","cls":"Ext.picker.Slot"},{"type":"member","member":"picker","icon":"property","private":true,"sort":3,"id":"Ext.picker.Slot-property-picker","cls":"Ext.picker.Slot"},{"type":"member","member":"selectedIndex","icon":"property","private":true,"sort":3,"id":"Ext.picker.Slot-property-selectedIndex","cls":"Ext.picker.Slot"},{"type":"class","member":"Picker","icon":"class","private":false,"sort":1,"id":"Ext.picker.Picker","cls":"Ext.picker.Picker"},{"type":"class","member":"Picker","icon":"subclass","private":false,"sort":2,"id":"Ext.picker.Picker","cls":"Ext.Picker"},{"type":"class","member":"picker","icon":"subclass","private":false,"sort":0,"id":"Ext.picker.Picker","cls":"xtype: picker"},{"type":"member","member":"cancelButton","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-cancelButton","cls":"Ext.picker.Picker"},{"type":"member","member":"doneButton","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-doneButton","cls":"Ext.picker.Picker"},{"type":"member","member":"height","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-height","cls":"Ext.picker.Picker"},{"type":"member","member":"slots","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-slots","cls":"Ext.picker.Picker"},{"type":"member","member":"toolbar","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-toolbar","cls":"Ext.picker.Picker"},{"type":"member","member":"useTitles","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-useTitles","cls":"Ext.picker.Picker"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Picker-cfg-value","cls":"Ext.picker.Picker"},{"type":"member","member":"applyCancelButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-applyCancelButton","cls":"Ext.picker.Picker"},{"type":"member","member":"applyDoneButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-applyDoneButton","cls":"Ext.picker.Picker"},{"type":"member","member":"applyToolbar","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-applyToolbar","cls":"Ext.picker.Picker"},{"type":"member","member":"getCancelButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getCancelButton","cls":"Ext.picker.Picker"},{"type":"member","member":"getDoneButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getDoneButton","cls":"Ext.picker.Picker"},{"type":"member","member":"getHeight","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getHeight","cls":"Ext.picker.Picker"},{"type":"member","member":"getSlots","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getSlots","cls":"Ext.picker.Picker"},{"type":"member","member":"getToolbar","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getToolbar","cls":"Ext.picker.Picker"},{"type":"member","member":"getUseTitles","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getUseTitles","cls":"Ext.picker.Picker"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getValue","cls":"Ext.picker.Picker"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-getValues","cls":"Ext.picker.Picker"},{"type":"member","member":"onCancelButtonTap","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-onCancelButtonTap","cls":"Ext.picker.Picker"},{"type":"member","member":"onDoneButtonTap","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-onDoneButtonTap","cls":"Ext.picker.Picker"},{"type":"member","member":"onSlotPick","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-onSlotPick","cls":"Ext.picker.Picker"},{"type":"member","member":"setCancelButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setCancelButton","cls":"Ext.picker.Picker"},{"type":"member","member":"setDoneButton","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setDoneButton","cls":"Ext.picker.Picker"},{"type":"member","member":"setHeight","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setHeight","cls":"Ext.picker.Picker"},{"type":"member","member":"setSlots","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setSlots","cls":"Ext.picker.Picker"},{"type":"member","member":"setToolbar","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setToolbar","cls":"Ext.picker.Picker"},{"type":"member","member":"setUseTitles","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setUseTitles","cls":"Ext.picker.Picker"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-setValue","cls":"Ext.picker.Picker"},{"type":"member","member":"updateSlots","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-updateSlots","cls":"Ext.picker.Picker"},{"type":"member","member":"updateToolbar","icon":"method","private":true,"sort":3,"id":"Ext.picker.Picker-method-updateToolbar","cls":"Ext.picker.Picker"},{"type":"member","member":"updateUseTitles","icon":"method","private":false,"sort":3,"id":"Ext.picker.Picker-method-updateUseTitles","cls":"Ext.picker.Picker"},{"type":"member","member":"cancel","icon":"event","private":false,"sort":3,"id":"Ext.picker.Picker-event-cancel","cls":"Ext.picker.Picker"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.picker.Picker-event-change","cls":"Ext.picker.Picker"},{"type":"member","member":"pick","icon":"event","private":false,"sort":3,"id":"Ext.picker.Picker-event-pick","cls":"Ext.picker.Picker"},{"type":"member","member":"centered","icon":"property","private":true,"sort":3,"id":"Ext.picker.Picker-property-centered","cls":"Ext.picker.Picker"},{"type":"class","member":"Select","icon":"class","private":false,"sort":1,"id":"Ext.field.Select","cls":"Ext.field.Select"},{"type":"class","member":"Select","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Select","cls":"Ext.form.Select"},{"type":"class","member":"selectfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Select","cls":"xtype: selectfield"},{"type":"member","member":"clearIcon","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Select-cfg-clearIcon","cls":"Ext.field.Select"},{"type":"member","member":"defaultPhonePickerConfig","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-defaultPhonePickerConfig","cls":"Ext.field.Select"},{"type":"member","member":"defaultTabletPickerConfig","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-defaultTabletPickerConfig","cls":"Ext.field.Select"},{"type":"member","member":"displayField","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-displayField","cls":"Ext.field.Select"},{"type":"member","member":"hiddenName","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-hiddenName","cls":"Ext.field.Select"},{"type":"member","member":"input","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Select-cfg-input","cls":"Ext.field.Select"},{"type":"member","member":"options","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-options","cls":"Ext.field.Select"},{"type":"member","member":"store","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-store","cls":"Ext.field.Select"},{"type":"member","member":"useClearIcon","icon":"cfg","private":true,"sort":3,"id":"Ext.field.Select-cfg-useClearIcon","cls":"Ext.field.Select"},{"type":"member","member":"usePicker","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-usePicker","cls":"Ext.field.Select"},{"type":"member","member":"valueField","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Select-cfg-valueField","cls":"Ext.field.Select"},{"type":"member","member":"applyUsePicker","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-applyUsePicker","cls":"Ext.field.Select"},{"type":"member","member":"applyValue","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-applyValue","cls":"Ext.field.Select"},{"type":"member","member":"doSetDisabled","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-doSetDisabled","cls":"Ext.field.Select"},{"type":"member","member":"getClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-getClearIcon","cls":"Ext.field.Select"},{"type":"member","member":"getDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getDisplayField","cls":"Ext.field.Select"},{"type":"member","member":"getHiddenName","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getHiddenName","cls":"Ext.field.Select"},{"type":"member","member":"getOptions","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getOptions","cls":"Ext.field.Select"},{"type":"member","member":"getRecord","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getRecord","cls":"Ext.field.Select"},{"type":"member","member":"getStore","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getStore","cls":"Ext.field.Select"},{"type":"member","member":"getValueField","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-getValueField","cls":"Ext.field.Select"},{"type":"member","member":"onStoreDataChanged","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-onStoreDataChanged","cls":"Ext.field.Select"},{"type":"member","member":"reset","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-reset","cls":"Ext.field.Select"},{"type":"member","member":"setClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-setClearIcon","cls":"Ext.field.Select"},{"type":"member","member":"setDisabled","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-setDisabled","cls":"Ext.field.Select"},{"type":"member","member":"setDisplayField","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-setDisplayField","cls":"Ext.field.Select"},{"type":"member","member":"setHiddenName","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-setHiddenName","cls":"Ext.field.Select"},{"type":"member","member":"setOptions","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-setOptions","cls":"Ext.field.Select"},{"type":"member","member":"setStore","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-setStore","cls":"Ext.field.Select"},{"type":"member","member":"setValueField","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-setValueField","cls":"Ext.field.Select"},{"type":"member","member":"showPicker","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-showPicker","cls":"Ext.field.Select"},{"type":"member","member":"updateDefaultPhonePickerConfig","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-updateDefaultPhonePickerConfig","cls":"Ext.field.Select"},{"type":"member","member":"updateDefaultTabletPickerConfig","icon":"method","private":true,"sort":3,"id":"Ext.field.Select-method-updateDefaultTabletPickerConfig","cls":"Ext.field.Select"},{"type":"member","member":"updateOptions","icon":"method","private":false,"sort":3,"id":"Ext.field.Select-method-updateOptions","cls":"Ext.field.Select"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.field.Select-event-change","cls":"Ext.field.Select"},{"type":"class","member":"Date","icon":"class","private":false,"sort":1,"id":"Ext.picker.Date","cls":"Ext.picker.Date"},{"type":"class","member":"DatePicker","icon":"subclass","private":false,"sort":2,"id":"Ext.picker.Date","cls":"Ext.DatePicker"},{"type":"class","member":"datepicker","icon":"subclass","private":false,"sort":0,"id":"Ext.picker.Date","cls":"xtype: datepicker"},{"type":"member","member":"dayText","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-dayText","cls":"Ext.picker.Date"},{"type":"member","member":"monthText","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-monthText","cls":"Ext.picker.Date"},{"type":"member","member":"slotOrder","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-slotOrder","cls":"Ext.picker.Date"},{"type":"member","member":"slots","icon":"cfg","private":true,"sort":3,"id":"Ext.picker.Date-cfg-slots","cls":"Ext.picker.Date"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-value","cls":"Ext.picker.Date"},{"type":"member","member":"yearFrom","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-yearFrom","cls":"Ext.picker.Date"},{"type":"member","member":"yearText","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-yearText","cls":"Ext.picker.Date"},{"type":"member","member":"yearTo","icon":"cfg","private":false,"sort":3,"id":"Ext.picker.Date-cfg-yearTo","cls":"Ext.picker.Date"},{"type":"member","member":"createSlot","icon":"method","private":true,"sort":3,"id":"Ext.picker.Date-method-createSlot","cls":"Ext.picker.Date"},{"type":"member","member":"createSlots","icon":"method","private":true,"sort":3,"id":"Ext.picker.Date-method-createSlots","cls":"Ext.picker.Date"},{"type":"member","member":"getDayText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getDayText","cls":"Ext.picker.Date"},{"type":"member","member":"getMonthText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getMonthText","cls":"Ext.picker.Date"},{"type":"member","member":"getSlotOrder","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getSlotOrder","cls":"Ext.picker.Date"},{"type":"member","member":"getSlots","icon":"method","private":true,"sort":3,"id":"Ext.picker.Date-method-getSlots","cls":"Ext.picker.Date"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getValue","cls":"Ext.picker.Date"},{"type":"member","member":"getYearFrom","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getYearFrom","cls":"Ext.picker.Date"},{"type":"member","member":"getYearText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getYearText","cls":"Ext.picker.Date"},{"type":"member","member":"getYearTo","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-getYearTo","cls":"Ext.picker.Date"},{"type":"member","member":"setDayText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setDayText","cls":"Ext.picker.Date"},{"type":"member","member":"setMonthText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setMonthText","cls":"Ext.picker.Date"},{"type":"member","member":"setSlotOrder","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setSlotOrder","cls":"Ext.picker.Date"},{"type":"member","member":"setSlots","icon":"method","private":true,"sort":3,"id":"Ext.picker.Date-method-setSlots","cls":"Ext.picker.Date"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setValue","cls":"Ext.picker.Date"},{"type":"member","member":"setYearFrom","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setYearFrom","cls":"Ext.picker.Date"},{"type":"member","member":"setYearText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setYearText","cls":"Ext.picker.Date"},{"type":"member","member":"setYearTo","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-setYearTo","cls":"Ext.picker.Date"},{"type":"member","member":"updateDayText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-updateDayText","cls":"Ext.picker.Date"},{"type":"member","member":"updateMonthText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-updateMonthText","cls":"Ext.picker.Date"},{"type":"member","member":"updateYearFrom","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-updateYearFrom","cls":"Ext.picker.Date"},{"type":"member","member":"updateYearText","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-updateYearText","cls":"Ext.picker.Date"},{"type":"member","member":"updateYearTo","icon":"method","private":false,"sort":3,"id":"Ext.picker.Date-method-updateYearTo","cls":"Ext.picker.Date"},{"type":"class","member":"DatePicker","icon":"class","private":false,"sort":1,"id":"Ext.field.DatePicker","cls":"Ext.field.DatePicker"},{"type":"class","member":"DatePicker","icon":"subclass","private":false,"sort":2,"id":"Ext.field.DatePicker","cls":"Ext.form.DatePicker"},{"type":"class","member":"datepickerfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.DatePicker","cls":"xtype: datepickerfield"},{"type":"member","member":"clearIcon","icon":"cfg","private":true,"sort":3,"id":"Ext.field.DatePicker-cfg-clearIcon","cls":"Ext.field.DatePicker"},{"type":"member","member":"component","icon":"cfg","private":true,"sort":3,"id":"Ext.field.DatePicker-cfg-component","cls":"Ext.field.DatePicker"},{"type":"member","member":"dateFormat","icon":"cfg","private":false,"sort":3,"id":"Ext.field.DatePicker-cfg-dateFormat","cls":"Ext.field.DatePicker"},{"type":"member","member":"destroyPickerOnHide","icon":"cfg","private":false,"sort":3,"id":"Ext.field.DatePicker-cfg-destroyPickerOnHide","cls":"Ext.field.DatePicker"},{"type":"member","member":"picker","icon":"cfg","private":false,"sort":3,"id":"Ext.field.DatePicker-cfg-picker","cls":"Ext.field.DatePicker"},{"type":"member","member":"tabIndex","icon":"cfg","private":true,"sort":3,"id":"Ext.field.DatePicker-cfg-tabIndex","cls":"Ext.field.DatePicker"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.field.DatePicker-cfg-value","cls":"Ext.field.DatePicker"},{"type":"member","member":"getClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-getClearIcon","cls":"Ext.field.DatePicker"},{"type":"member","member":"getDestroyPickerOnHide","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-getDestroyPickerOnHide","cls":"Ext.field.DatePicker"},{"type":"member","member":"getFormattedValue","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-getFormattedValue","cls":"Ext.field.DatePicker"},{"type":"member","member":"getPicker","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-getPicker","cls":"Ext.field.DatePicker"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-getValue","cls":"Ext.field.DatePicker"},{"type":"member","member":"onMaskTap","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-onMaskTap","cls":"Ext.field.DatePicker"},{"type":"member","member":"onPickerChange","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-onPickerChange","cls":"Ext.field.DatePicker"},{"type":"member","member":"onPickerHide","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-onPickerHide","cls":"Ext.field.DatePicker"},{"type":"member","member":"setClearIcon","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-setClearIcon","cls":"Ext.field.DatePicker"},{"type":"member","member":"setDestroyPickerOnHide","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-setDestroyPickerOnHide","cls":"Ext.field.DatePicker"},{"type":"member","member":"setPicker","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-setPicker","cls":"Ext.field.DatePicker"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.DatePicker-method-setValue","cls":"Ext.field.DatePicker"},{"type":"member","member":"updateDateFormat","icon":"method","private":true,"sort":3,"id":"Ext.field.DatePicker-method-updateDateFormat","cls":"Ext.field.DatePicker"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.field.DatePicker-event-change","cls":"Ext.field.DatePicker"},{"type":"class","member":"Slider","icon":"class","private":true,"sort":1,"id":"Ext.slider.Slider","cls":"Ext.slider.Slider"},{"type":"class","member":"slider","icon":"subclass","private":true,"sort":0,"id":"Ext.slider.Slider","cls":"xtype: slider"},{"type":"member","member":"allowThumbsOverlapping","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-allowThumbsOverlapping","cls":"Ext.slider.Slider"},{"type":"member","member":"animation","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-animation","cls":"Ext.slider.Slider"},{"type":"member","member":"increment","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-increment","cls":"Ext.slider.Slider"},{"type":"member","member":"maxValue","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-maxValue","cls":"Ext.slider.Slider"},{"type":"member","member":"minValue","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-minValue","cls":"Ext.slider.Slider"},{"type":"member","member":"tabIndex","icon":"cfg","private":true,"sort":3,"id":"Ext.slider.Slider-cfg-tabIndex","cls":"Ext.slider.Slider"},{"type":"member","member":"thumbConfig","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-thumbConfig","cls":"Ext.slider.Slider"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-value","cls":"Ext.slider.Slider"},{"type":"member","member":"values","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Slider-cfg-values","cls":"Ext.slider.Slider"},{"type":"member","member":"constrainValue","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-constrainValue","cls":"Ext.slider.Slider"},{"type":"member","member":"factoryThumb","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-factoryThumb","cls":"Ext.slider.Slider"},{"type":"member","member":"getAllowThumbsOverlapping","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getAllowThumbsOverlapping","cls":"Ext.slider.Slider"},{"type":"member","member":"getAnimation","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getAnimation","cls":"Ext.slider.Slider"},{"type":"member","member":"getIncrement","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getIncrement","cls":"Ext.slider.Slider"},{"type":"member","member":"getMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getMaxValue","cls":"Ext.slider.Slider"},{"type":"member","member":"getMinValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getMinValue","cls":"Ext.slider.Slider"},{"type":"member","member":"getTabIndex","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-getTabIndex","cls":"Ext.slider.Slider"},{"type":"member","member":"getThumb","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-getThumb","cls":"Ext.slider.Slider"},{"type":"member","member":"getThumbConfig","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getThumbConfig","cls":"Ext.slider.Slider"},{"type":"member","member":"getThumbs","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-getThumbs","cls":"Ext.slider.Slider"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getValue","cls":"Ext.slider.Slider"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-getValues","cls":"Ext.slider.Slider"},{"type":"member","member":"refreshValue","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-refreshValue","cls":"Ext.slider.Slider"},{"type":"member","member":"setAllowThumbsOverlapping","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setAllowThumbsOverlapping","cls":"Ext.slider.Slider"},{"type":"member","member":"setAnimation","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setAnimation","cls":"Ext.slider.Slider"},{"type":"member","member":"setIncrement","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setIncrement","cls":"Ext.slider.Slider"},{"type":"member","member":"setMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setMaxValue","cls":"Ext.slider.Slider"},{"type":"member","member":"setMinValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setMinValue","cls":"Ext.slider.Slider"},{"type":"member","member":"setTabIndex","icon":"method","private":true,"sort":3,"id":"Ext.slider.Slider-method-setTabIndex","cls":"Ext.slider.Slider"},{"type":"member","member":"setThumbConfig","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setThumbConfig","cls":"Ext.slider.Slider"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setValue","cls":"Ext.slider.Slider"},{"type":"member","member":"setValues","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-setValues","cls":"Ext.slider.Slider"},{"type":"member","member":"updateValue","icon":"method","private":false,"sort":3,"id":"Ext.slider.Slider-method-updateValue","cls":"Ext.slider.Slider"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.slider.Slider-event-change","cls":"Ext.slider.Slider"},{"type":"member","member":"drag","icon":"event","private":false,"sort":3,"id":"Ext.slider.Slider-event-drag","cls":"Ext.slider.Slider"},{"type":"member","member":"dragend","icon":"event","private":false,"sort":3,"id":"Ext.slider.Slider-event-dragend","cls":"Ext.slider.Slider"},{"type":"member","member":"dragstart","icon":"event","private":false,"sort":3,"id":"Ext.slider.Slider-event-dragstart","cls":"Ext.slider.Slider"},{"type":"class","member":"Slider","icon":"class","private":false,"sort":1,"id":"Ext.field.Slider","cls":"Ext.field.Slider"},{"type":"class","member":"Slider","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Slider","cls":"Ext.form.Slider"},{"type":"class","member":"sliderfield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Slider","cls":"xtype: sliderfield"},{"type":"member","member":"$form-slider-size","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Slider-css_var-S-form-slider-size","cls":"Ext.field.Slider"},{"type":"member","member":"$form-thumb-size","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Slider-css_var-S-form-thumb-size","cls":"Ext.field.Slider"},{"type":"member","member":"sencha-form-sliders","icon":"css_mixin","private":false,"sort":3,"id":"Ext.field.Slider-css_mixin-sencha-form-sliders","cls":"Ext.field.Slider"},{"type":"member","member":"increment","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Slider-cfg-increment","cls":"Ext.field.Slider"},{"type":"member","member":"maxValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Slider-cfg-maxValue","cls":"Ext.field.Slider"},{"type":"member","member":"minValue","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Slider-cfg-minValue","cls":"Ext.field.Slider"},{"type":"member","member":"value","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Slider-cfg-value","cls":"Ext.field.Slider"},{"type":"member","member":"values","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Slider-cfg-values","cls":"Ext.field.Slider"},{"type":"member","member":"getIncrement","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-getIncrement","cls":"Ext.field.Slider"},{"type":"member","member":"getMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-getMaxValue","cls":"Ext.field.Slider"},{"type":"member","member":"getMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-getMinValue","cls":"Ext.field.Slider"},{"type":"member","member":"getValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-getValue","cls":"Ext.field.Slider"},{"type":"member","member":"getValues","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-getValues","cls":"Ext.field.Slider"},{"type":"member","member":"setIncrement","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-setIncrement","cls":"Ext.field.Slider"},{"type":"member","member":"setMaxValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-setMaxValue","cls":"Ext.field.Slider"},{"type":"member","member":"setMinValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-setMinValue","cls":"Ext.field.Slider"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-setValue","cls":"Ext.field.Slider"},{"type":"member","member":"setValues","icon":"method","private":false,"sort":3,"id":"Ext.field.Slider-method-setValues","cls":"Ext.field.Slider"},{"type":"member","member":"change","icon":"event","private":false,"sort":3,"id":"Ext.field.Slider-event-change","cls":"Ext.field.Slider"},{"type":"member","member":"tabIndex","icon":"property","private":false,"sort":3,"id":"Ext.field.Slider-property-tabIndex","cls":"Ext.field.Slider"},{"type":"class","member":"Toggle","icon":"class","private":true,"sort":1,"id":"Ext.slider.Toggle","cls":"Ext.slider.Toggle"},{"type":"member","member":"maxValueCls","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Toggle-cfg-maxValueCls","cls":"Ext.slider.Toggle"},{"type":"member","member":"minValueCls","icon":"cfg","private":false,"sort":3,"id":"Ext.slider.Toggle-cfg-minValueCls","cls":"Ext.slider.Toggle"},{"type":"member","member":"getMaxValueCls","icon":"method","private":false,"sort":3,"id":"Ext.slider.Toggle-method-getMaxValueCls","cls":"Ext.slider.Toggle"},{"type":"member","member":"getMinValueCls","icon":"method","private":false,"sort":3,"id":"Ext.slider.Toggle-method-getMinValueCls","cls":"Ext.slider.Toggle"},{"type":"member","member":"setMaxValueCls","icon":"method","private":false,"sort":3,"id":"Ext.slider.Toggle-method-setMaxValueCls","cls":"Ext.slider.Toggle"},{"type":"member","member":"setMinValueCls","icon":"method","private":false,"sort":3,"id":"Ext.slider.Toggle-method-setMinValueCls","cls":"Ext.slider.Toggle"},{"type":"class","member":"Toggle","icon":"class","private":false,"sort":1,"id":"Ext.field.Toggle","cls":"Ext.field.Toggle"},{"type":"class","member":"Toggle","icon":"subclass","private":false,"sort":2,"id":"Ext.field.Toggle","cls":"Ext.form.Toggle"},{"type":"class","member":"togglefield","icon":"subclass","private":false,"sort":0,"id":"Ext.field.Toggle","cls":"xtype: togglefield"},{"type":"member","member":"$form-toggle-size","icon":"css_var","private":false,"sort":3,"id":"Ext.field.Toggle-css_var-S-form-toggle-size","cls":"Ext.field.Toggle"},{"type":"member","member":"maxValueCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Toggle-cfg-maxValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"minValueCls","icon":"cfg","private":false,"sort":3,"id":"Ext.field.Toggle-cfg-minValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"getMaxValueCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-getMaxValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"getMinValueCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-getMinValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"setMaxValueCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-setMaxValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"setMinValueCls","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-setMinValueCls","cls":"Ext.field.Toggle"},{"type":"member","member":"setValue","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-setValue","cls":"Ext.field.Toggle"},{"type":"member","member":"toggle","icon":"method","private":false,"sort":3,"id":"Ext.field.Toggle-method-toggle","cls":"Ext.field.Toggle"},{"type":"class","member":"Bar","icon":"class","private":true,"sort":1,"id":"Ext.tab.Bar","cls":"Ext.tab.Bar"},{"type":"class","member":"TabBar","icon":"subclass","private":true,"sort":2,"id":"Ext.tab.Bar","cls":"Ext.TabBar"},{"type":"class","member":"tabbar","icon":"subclass","private":true,"sort":0,"id":"Ext.tab.Bar","cls":"xtype: tabbar"},{"type":"member","member":"$include-bottom-tabs","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-include-bottom-tabs","cls":"Ext.tab.Bar"},{"type":"member","member":"$include-tabbar-uis","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-include-tabbar-uis","cls":"Ext.tab.Bar"},{"type":"member","member":"$include-top-tabs","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-include-top-tabs","cls":"Ext.tab.Bar"},{"type":"member","member":"$tabs-bar-gradient","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-tabs-bar-gradient","cls":"Ext.tab.Bar"},{"type":"member","member":"$tabs-dark","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-tabs-dark","cls":"Ext.tab.Bar"},{"type":"member","member":"$tabs-dark-active","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-tabs-dark-active","cls":"Ext.tab.Bar"},{"type":"member","member":"$tabs-light","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-tabs-light","cls":"Ext.tab.Bar"},{"type":"member","member":"$tabs-light-active","icon":"css_var","private":false,"sort":3,"id":"Ext.tab.Bar-css_var-S-tabs-light-active","cls":"Ext.tab.Bar"},{"type":"member","member":"sencha-tabbar-ui","icon":"css_mixin","private":false,"sort":3,"id":"Ext.tab.Bar-css_mixin-sencha-tabbar-ui","cls":"Ext.tab.Bar"},{"type":"member","member":"sencha-tabs","icon":"css_mixin","private":false,"sort":3,"id":"Ext.tab.Bar-css_mixin-sencha-tabs","cls":"Ext.tab.Bar"},{"type":"member","member":"sencha-toolbar-forms","icon":"css_mixin","private":false,"sort":3,"id":"Ext.tab.Bar-css_mixin-sencha-toolbar-forms","cls":"Ext.tab.Bar"},{"type":"member","member":"activeTab","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Bar-cfg-activeTab","cls":"Ext.tab.Bar"},{"type":"member","member":"applyActiveTab","icon":"method","private":true,"sort":3,"id":"Ext.tab.Bar-method-applyActiveTab","cls":"Ext.tab.Bar"},{"type":"member","member":"doActiveTabChange","icon":"method","private":true,"sort":3,"id":"Ext.tab.Bar-method-doActiveTabChange","cls":"Ext.tab.Bar"},{"type":"member","member":"doSetDocked","icon":"method","private":true,"sort":3,"id":"Ext.tab.Bar-method-doSetDocked","cls":"Ext.tab.Bar"},{"type":"member","member":"getActiveTab","icon":"method","private":false,"sort":3,"id":"Ext.tab.Bar-method-getActiveTab","cls":"Ext.tab.Bar"},{"type":"member","member":"parseActiveTab","icon":"method","private":true,"sort":3,"id":"Ext.tab.Bar-method-parseActiveTab","cls":"Ext.tab.Bar"},{"type":"member","member":"setActiveTab","icon":"method","private":false,"sort":3,"id":"Ext.tab.Bar-method-setActiveTab","cls":"Ext.tab.Bar"},{"type":"member","member":"updateActiveTab","icon":"method","private":true,"sort":3,"id":"Ext.tab.Bar-method-updateActiveTab","cls":"Ext.tab.Bar"},{"type":"member","member":"tabchange","icon":"event","private":false,"sort":3,"id":"Ext.tab.Bar-event-tabchange","cls":"Ext.tab.Bar"},{"type":"class","member":"Panel","icon":"class","private":false,"sort":1,"id":"Ext.tab.Panel","cls":"Ext.tab.Panel"},{"type":"class","member":"TabPanel","icon":"subclass","private":false,"sort":2,"id":"Ext.tab.Panel","cls":"Ext.TabPanel"},{"type":"class","member":"tabpanel","icon":"subclass","private":false,"sort":0,"id":"Ext.tab.Panel","cls":"xtype: tabpanel"},{"type":"member","member":"layout","icon":"cfg","private":true,"sort":3,"id":"Ext.tab.Panel-cfg-layout","cls":"Ext.tab.Panel"},{"type":"member","member":"scroll","icon":"cfg","private":true,"sort":3,"id":"Ext.tab.Panel-cfg-scroll","cls":"Ext.tab.Panel"},{"type":"member","member":"scrollable","icon":"cfg","private":true,"sort":3,"id":"Ext.tab.Panel-cfg-scrollable","cls":"Ext.tab.Panel"},{"type":"member","member":"tabBar","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Panel-cfg-tabBar","cls":"Ext.tab.Panel"},{"type":"member","member":"tabBarPosition","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Panel-cfg-tabBarPosition","cls":"Ext.tab.Panel"},{"type":"member","member":"ui","icon":"cfg","private":false,"sort":3,"id":"Ext.tab.Panel-cfg-ui","cls":"Ext.tab.Panel"},{"type":"member","member":"applyScrollable","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-applyScrollable","cls":"Ext.tab.Panel"},{"type":"member","member":"applyTabBar","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-applyTabBar","cls":"Ext.tab.Panel"},{"type":"member","member":"doActiveItemChange","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-doActiveItemChange","cls":"Ext.tab.Panel"},{"type":"member","member":"doSetActiveItem","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-doSetActiveItem","cls":"Ext.tab.Panel"},{"type":"member","member":"doTabChange","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-doTabChange","cls":"Ext.tab.Panel"},{"type":"member","member":"getScrollable","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-getScrollable","cls":"Ext.tab.Panel"},{"type":"member","member":"getTabBar","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-getTabBar","cls":"Ext.tab.Panel"},{"type":"member","member":"getTabBarPosition","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-getTabBarPosition","cls":"Ext.tab.Panel"},{"type":"member","member":"getUi","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-getUi","cls":"Ext.tab.Panel"},{"type":"member","member":"setScrollable","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-setScrollable","cls":"Ext.tab.Panel"},{"type":"member","member":"setTabBar","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-setTabBar","cls":"Ext.tab.Panel"},{"type":"member","member":"setTabBarPosition","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-setTabBarPosition","cls":"Ext.tab.Panel"},{"type":"member","member":"setUi","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-setUi","cls":"Ext.tab.Panel"},{"type":"member","member":"updateTabBar","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-updateTabBar","cls":"Ext.tab.Panel"},{"type":"member","member":"updateTabBarPosition","icon":"method","private":true,"sort":3,"id":"Ext.tab.Panel-method-updateTabBarPosition","cls":"Ext.tab.Panel"},{"type":"member","member":"updateUi","icon":"method","private":false,"sort":3,"id":"Ext.tab.Panel-method-updateUi","cls":"Ext.tab.Panel"},{"type":"class","member":"Viewport","icon":"class","private":false,"sort":1,"id":"Ext.Viewport","cls":"Ext.Viewport"},{"type":"class","member":"viewport","icon":"subclass","private":false,"sort":0,"id":"Ext.Viewport","cls":"xtype: viewport"},{"type":"member","member":"autoMaximize","icon":"cfg","private":false,"sort":3,"id":"Ext.Viewport-cfg-autoMaximize","cls":"Ext.Viewport"},{"type":"member","member":"height","icon":"cfg","private":true,"sort":3,"id":"Ext.Viewport-cfg-height","cls":"Ext.Viewport"},{"type":"member","member":"layout","icon":"cfg","private":false,"sort":3,"id":"Ext.Viewport-cfg-layout","cls":"Ext.Viewport"},{"type":"member","member":"preventPanning","icon":"cfg","private":false,"sort":3,"id":"Ext.Viewport-cfg-preventPanning","cls":"Ext.Viewport"},{"type":"member","member":"preventZooming","icon":"cfg","private":false,"sort":3,"id":"Ext.Viewport-cfg-preventZooming","cls":"Ext.Viewport"},{"type":"member","member":"width","icon":"cfg","private":true,"sort":3,"id":"Ext.Viewport-cfg-width","cls":"Ext.Viewport"},{"type":"member","member":"getAutoMaximize","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getAutoMaximize","cls":"Ext.Viewport"},{"type":"member","member":"getLayout","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getLayout","cls":"Ext.Viewport"},{"type":"member","member":"getOrientation","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getOrientation","cls":"Ext.Viewport"},{"type":"member","member":"getPreventPanning","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getPreventPanning","cls":"Ext.Viewport"},{"type":"member","member":"getPreventZooming","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getPreventZooming","cls":"Ext.Viewport"},{"type":"member","member":"getWindowHeight","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getWindowHeight","cls":"Ext.Viewport"},{"type":"member","member":"getWindowWidth","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-getWindowWidth","cls":"Ext.Viewport"},{"type":"member","member":"hideKeyboard","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-hideKeyboard","cls":"Ext.Viewport"},{"type":"member","member":"setAutoMaximize","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-setAutoMaximize","cls":"Ext.Viewport"},{"type":"member","member":"setLayout","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-setLayout","cls":"Ext.Viewport"},{"type":"member","member":"setPreventPanning","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-setPreventPanning","cls":"Ext.Viewport"},{"type":"member","member":"setPreventZooming","icon":"method","private":false,"sort":3,"id":"Ext.Viewport-method-setPreventZooming","cls":"Ext.Viewport"},{"type":"member","member":"maximize","icon":"event","private":false,"sort":3,"id":"Ext.Viewport-event-maximize","cls":"Ext.Viewport"},{"type":"member","member":"orientationchange","icon":"event","private":false,"sort":3,"id":"Ext.Viewport-event-orientationchange","cls":"Ext.Viewport"},{"type":"member","member":"ready","icon":"event","private":false,"sort":3,"id":"Ext.Viewport-event-ready","cls":"Ext.Viewport"},{"type":"member","member":"resize","icon":"event","private":false,"sort":3,"id":"Ext.Viewport-event-resize","cls":"Ext.Viewport"},{"type":"member","member":"autoRender","icon":"property","private":true,"sort":3,"id":"Ext.Viewport-property-autoRender","cls":"Ext.Viewport"},{"type":"member","member":"fullscreenItemCls","icon":"property","private":true,"sort":3,"id":"Ext.Viewport-property-fullscreenItemCls","cls":"Ext.Viewport"},{"type":"member","member":"isReady","icon":"property","private":false,"sort":3,"id":"Ext.Viewport-property-isReady","cls":"Ext.Viewport"},{"type":"class","member":"VerticalSwipe","icon":"class","private":true,"sort":1,"id":"Ext.event.recognizer.VerticalSwipe","cls":"Ext.event.recognizer.VerticalSwipe"},{"type":"class","member":"Global_CSS","icon":"class","private":false,"sort":1,"id":"Global_CSS","cls":"Global_CSS"},{"type":"member","member":"$active-color","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-active-color","cls":"Global_CSS"},{"type":"member","member":"$alert-color","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-alert-color","cls":"Global_CSS"},{"type":"member","member":"$base-color","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-base-color","cls":"Global_CSS"},{"type":"member","member":"$base-gradient","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-base-gradient","cls":"Global_CSS"},{"type":"member","member":"$basic-slider","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-basic-slider","cls":"Global_CSS"},{"type":"member","member":"$confirm-color","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-confirm-color","cls":"Global_CSS"},{"type":"member","member":"$font-family","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-font-family","cls":"Global_CSS"},{"type":"member","member":"$global-row-height","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-global-row-height","cls":"Global_CSS"},{"type":"member","member":"$include-border-radius","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-border-radius","cls":"Global_CSS"},{"type":"member","member":"$include-default-icons","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-default-icons","cls":"Global_CSS"},{"type":"member","member":"$include-default-uis","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-default-uis","cls":"Global_CSS"},{"type":"member","member":"$include-floating-panels","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-floating-panels","cls":"Global_CSS"},{"type":"member","member":"$include-form-sliders","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-form-sliders","cls":"Global_CSS"},{"type":"member","member":"$include-highlights","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-highlights","cls":"Global_CSS"},{"type":"member","member":"$include-html-style","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-include-html-style","cls":"Global_CSS"},{"type":"member","member":"$page-bg-color","icon":"css_var","private":false,"sort":3,"id":"Global_CSS-css_var-S-page-bg-color","cls":"Global_CSS"},{"type":"member","member":"background-gradient","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-background-gradient","cls":"Global_CSS"},{"type":"member","member":"bevel-box","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-bevel-box","cls":"Global_CSS"},{"type":"member","member":"bevel-by-background","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-bevel-by-background","cls":"Global_CSS"},{"type":"member","member":"bevel-text","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-bevel-text","cls":"Global_CSS"},{"type":"member","member":"color-by-background","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-color-by-background","cls":"Global_CSS"},{"type":"member","member":"ellipsis","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-ellipsis","cls":"Global_CSS"},{"type":"member","member":"insertion","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-insertion","cls":"Global_CSS"},{"type":"member","member":"mask-by-background","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-mask-by-background","cls":"Global_CSS"},{"type":"member","member":"pictos-iconmask","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-pictos-iconmask","cls":"Global_CSS"},{"type":"member","member":"stretch","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-stretch","cls":"Global_CSS"},{"type":"member","member":"toolbar-button","icon":"css_mixin","private":false,"sort":3,"id":"Global_CSS-css_mixin-toolbar-button","cls":"Global_CSS"}]}};
