Ext.data.JsonP.carousel({"title":"Using Carousel","guide":"<h1>Using Carousels in Sencha Touch 2</h1>\n\n<p><a href=\"#!/api/Ext.carousel.Carousel\" rel=\"Ext.carousel.Carousel\" class=\"docClass\">Carousels</a>, like <a href=\"#!/guide/tabs\">tabs</a>, are a great way to allow the user to swipe through multiple full-screen pages.\nA Carousel shows only one of its pages at a time but allows you to swipe through with your finger. You can think of a\nCarousel as a single active item with the rest of the items stretching away left and right. Indicator dots show you how\nmany available screens there are to swipe through:</p>\n\n<p><p class='screenshot'><img src='guides/carousel/carousel.jpg' alt=''><span></span></p></p>\n\n<p>Carousels can be oriented either horizontally or vertically and are easy to configure - they just work like any other\nContainer. Here's how to set up a simple horizontal Carousel:</p>\n\n<pre class='inline-example preview'><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.carousel.Carousel\" rel=\"Ext.carousel.Carousel\" class=\"docClass\">Ext.Carousel</a>', {\n    fullscreen: true,\n\n    defaults: {\n        styleHtmlContent: true\n    },\n\n    items: [\n        {\n            html : 'Item 1',\n            style: 'background-color: #5E99CC'\n        },\n        {\n            html : 'Item 2',\n            style: 'background-color: #759E60'\n        },\n        {\n            html : 'Item 3'\n        }\n    ]\n});\n</code></pre>\n\n<p>Swiping your finger left and right over the carousel now swaps between the two items we defined above. It also updates\nthe indicator icon to let you know which page you're currently on. We can also make Carousels orient themselves\nvertically:</p>\n\n<pre class='inline-example preview'><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.carousel.Carousel\" rel=\"Ext.carousel.Carousel\" class=\"docClass\">Ext.Carousel</a>', {\n    fullscreen: true,\n    direction: 'vertical',\n\n    defaults: {\n        styleHtmlContent: true\n    },\n\n    items: [\n        {\n            html : 'Item 1',\n            style: 'background-color: #759E60'\n        },\n        {\n            html : 'Item 2',\n            style: 'background-color: #5E99CC'\n        }\n    ]\n});\n</code></pre>\n\n<p>You can put anything in a Carousel, for example here we place a list and a form into a horizontal carousel</p>\n\n<pre class='inline-example portrait preview'><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.carousel.Carousel\" rel=\"Ext.carousel.Carousel\" class=\"docClass\">Ext.Carousel</a>', {\n    fullscreen: true,\n\n    items: [\n        {\n            xtype: 'list',\n\n            items: {\n                xtype: 'toolbar',\n                dock: 'top',\n                title: 'Sencha Touch Team'\n            },\n\n            store: {\n                fields: ['name'],\n                data: [\n                    {name: 'Rob'},\n                    {name: 'Ed'},\n                    {name: 'Jacky'},\n                    {name: 'Jamie'},\n                    {name: 'Tommy'},\n                    {name: 'Abe'}\n                ]\n            },\n\n            itemTpl: '{name}'\n        },\n        {\n            xtype: 'fieldset',\n            items: [\n                {\n                    xtype: 'toolbar',\n                    dock: 'top',\n                    title: 'Login'\n                },\n                {\n                    xtype: 'textfield',\n                    label: 'Name'\n                },\n                {\n                    xtype: 'passwordfield',\n                    label: 'Password'\n                }\n            ]\n        }\n    ]\n});\n</code></pre>\n"});