Ext.data.JsonP.dataview({"title":"Using DataView","guide":"<h1>Using DataViews in Sencha Touch 2</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/dataview-section-1'>Creating a Simple DataView</a></li>\n<li><a href='#!/guide/dataview-section-2'>Loading data from a server</a></li>\n<li><a href='#!/guide/dataview-section-3'>Styling a DataView</a></li>\n<li><a href='#!/guide/dataview-section-4'>Component DataView</a></li>\n</ol>\n</div>\n\n<p><a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> makes it easy to create lots of components dynamically, usually based off a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>.\nIt's great for rendering lots of data from your server backend or any other data source and is what powers\ncomponents like <a href=\"#!/api/Ext.dataview.List\" rel=\"Ext.dataview.List\" class=\"docClass\">Ext.List</a>.</p>\n\n<p>Use <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> whenever you want to show sets of the same component many times, for examples in apps like these:</p>\n\n<ul>\n<li>List of messages in an email app</li>\n<li>Showing latest news/tweets</li>\n<li>Tiled set of albums in an HTML5 music player</li>\n</ul>\n\n\n<h2 id='dataview-section-1'>Creating a Simple DataView</h2>\n\n<p>At its simplest, a <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> is just a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> full of data and a simple template that we use to render each item:</p>\n\n<pre class='inline-example '><code>var touchTeam = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        fields: ['name', 'age'],\n        data: [\n            {name: 'Jamie Avins',  age: 100},\n            {name: 'Rob Dougan',   age: 21},\n            {name: 'Tommy Maintz', age: 24},\n            {name: 'Jacky Nguyen', age: 24},\n            {name: 'Ed Spencer',   age: 26}\n        ]\n    },\n\n    itemTpl: '{name} is {age} years old'\n});\n</code></pre>\n\n<p>Here we just defined everything inline so it's all local with nothing being loaded from a server. For each of the 5\ndata items defined in our <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>, <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> will render a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> and pass in the name and age\ndata. The component will use the <a href=\"#!/api/Ext.dataview.DataView-cfg-itemTpl\" rel=\"Ext.dataview.DataView-cfg-itemTpl\" class=\"docClass\">tpl</a> we provided above, rendering the data in the curly bracket placeholders we\nprovided.</p>\n\n<p>Because <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> is integrated with <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>, any changes to the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> are immediately reflected on the screen. For\nexample, if we add a new record to the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> it will be rendered into our <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>:</p>\n\n<pre><code>touchTeam.getStore().add({\n    name: 'Abe Elias',\n    age: 33\n});\n</code></pre>\n\n<p>We didn't have to manually update the <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>, it's just automatically updated. The same happens if we modify one\nof the existing records in the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>:</p>\n\n<pre><code>touchTeam.getStore().getAt(0).set('age', 42);\n</code></pre>\n\n<p>This will get the first record in the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> (Jamie), change the age to 42 and automatically update what's on the\nscreen.</p>\n\n<h2 id='dataview-section-2'>Loading data from a server</h2>\n\n<p>We often want to load data from our server or some other web service so that we don't have to hard code it all\nlocally. Let's say we want to load all of the latest tweets about Sencha Touch into a <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>, and for each one\nrender the user's profile picture, user name and tweet message. To do this all we have to do is modify the\n<a href=\"#!/api/Ext.dataview.DataView-cfg-store\" rel=\"Ext.dataview.DataView-cfg-store\" class=\"docClass\">store</a> and <a href=\"#!/api/Ext.dataview.DataView-cfg-itemTpl\" rel=\"Ext.dataview.DataView-cfg-itemTpl\" class=\"docClass\">itemTpl</a> a little:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        autoLoad: true,\n        fields: ['from_user', 'text', 'profile_image_url'],\n\n        proxy: {\n            type: 'jsonp',\n            url: 'http://search.twitter.com/search.json?q=Sencha Touch',\n\n            reader: {\n                type: 'json',\n                root: 'results'\n            }\n        }\n    },\n\n    itemTpl: '&lt;img src=\"{profile_image_url}\" /&gt;&lt;h2&gt;{from_user}&lt;/h2&gt;&lt;p&gt;{text}&lt;/p&gt;'\n});\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> no longer has hard coded data, instead we've provided a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>, which fetches\nthe data for us. In this case we used a JSON-P proxy so that we can load from Twitter's JSON-P search API. We also\nspecified the fields present for each tweet, and used Store's <a href=\"#!/api/Ext.data.Store-cfg-autoLoad\" rel=\"Ext.data.Store-cfg-autoLoad\" class=\"docClass\">autoLoad</a> configuration\nto load automatically. Finally, we configured a Reader to decode the response from Twitter, telling it to expect\nJSON and that the tweets can be found in the 'results' part of the JSON response.</p>\n\n<p>The last thing we did is update our template to render the image, twitter username and message. All we need to do\nnow is add a little CSS to style the list the way we want it...</p>\n\n<h2 id='dataview-section-3'>Styling a DataView</h2>\n\n<p>You may have realized by now that although our <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> is displaying data from our <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>, it doesn't have any default styling. This is by design, but adding custom CSS is very simple. <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> has two configurations so you can target your custom CSS to your view: <a href=\"#!/api/Ext.dataview.DataView-cfg-baseCls\" rel=\"Ext.dataview.DataView-cfg-baseCls\" class=\"docClass\">baseCls</a> and <a href=\"#!/api/Ext.dataview.DataView-cfg-itemCls\" rel=\"Ext.dataview.DataView-cfg-itemCls\" class=\"docClass\">itemCls</a>. <a href=\"#!/api/Ext.dataview.DataView-cfg-baseCls\" rel=\"Ext.dataview.DataView-cfg-baseCls\" class=\"docClass\">baseCls</a> is used to add a <code>className</code> around the outer element of the <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>. The <a href=\"#!/api/Ext.dataview.DataView-cfg-itemCls\" rel=\"Ext.dataview.DataView-cfg-itemCls\" class=\"docClass\">itemCls</a> you provide is added onto each item that is rendered into our <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>.</p>\n\n<p>If you do <em>not</em> specify a <a href=\"#!/api/Ext.dataview.DataView-cfg-itemCls\" rel=\"Ext.dataview.DataView-cfg-itemCls\" class=\"docClass\">itemCls</a>, it will automatically take the <a href=\"#!/api/Ext.dataview.DataView-cfg-baseCls\" rel=\"Ext.dataview.DataView-cfg-baseCls\" class=\"docClass\">baseCls</a> configuration (which defaults to <code>x-dataview</code>) and prepend <code>-item</code>. So each item would have a className of <code>x-dataview-item</code>.</p>\n\n<p>But we before we add that configuration, we need to create our custom CSS. Here is a simple example below:</p>\n\n<pre><code>.my-dataview-item {\n    background: #ddd;\n    padding: 1em;\n    border-bottom: 1px solid #ccc;\n}\n.my-dataview-item img {\n    float: left;\n    margin-right: 1em;\n}\n.my-dataview-item h2 {\n    font-weight: bold;\n}\n</code></pre>\n\n<p>Once we have that complete, we can go back to our previous Twitter example and add the <a href=\"#!/api/Ext.dataview.DataView-cfg-baseCls\" rel=\"Ext.dataview.DataView-cfg-baseCls\" class=\"docClass\">basecls</a> configuration:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        autoLoad: true,\n        fields: ['from_user', 'text', 'profile_image_url'],\n\n        proxy: {\n            type: 'jsonp',\n            url: 'http://search.twitter.com/search.json?q=Sencha Touch',\n\n            reader: {\n                type: 'json',\n                root: 'results'\n            }\n        }\n    },\n\n    itemTpl: '&lt;img src=\"{profile_image_url}\" /&gt;&lt;h2&gt;{from_user}&lt;/h2&gt;&lt;p&gt;{text}&lt;/p&gt;',\n\n    baseCls: 'my-dataview'\n\n    //As described above, we don't need to set itemCls in most cases as it will already add a className\n    //generated from the baseCls to each item.\n    //itemCls: 'my-dataview-item'\n});\n</code></pre>\n\n<h2 id='dataview-section-4'>Component DataView</h2>\n\n<p>Above we created our <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> with an <a href=\"#!/api/Ext.dataview.DataView-cfg-itemTpl\" rel=\"Ext.dataview.DataView-cfg-itemTpl\" class=\"docClass\">itemTpl</a>, which means each item is rendered from a <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">template</a>. However, sometimes you need each item to be a component so you can provide a rich UI for your users. In Sencha Touch 2, we introduced the <a href=\"#!/api/Ext.dataview.DataView-cfg-useComponents\" rel=\"Ext.dataview.DataView-cfg-useComponents\" class=\"docClass\">useComponents</a> configuration which allows you to do just that.</p>\n\n<p>Creating a component <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> is very similiar to creating a normal template based <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> like above, however you must define the item view used when rendering each item in your list.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyListItem', {\n    extend: '<a href=\"#!/api/Ext.dataview.component.DataItem\" rel=\"Ext.dataview.component.DataItem\" class=\"docClass\">Ext.dataview.component.DataItem</a>',\n    requires: ['<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>'],\n    xtype: 'mylistitem',\n\n    config: {\n        nameButton: true,\n\n        dataMap: {\n            getNameButton: {\n                setText: 'name'\n            }\n        }\n    },\n\n    applyNameButton: function(config) {\n        return Ext.factory(config, <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>, this.getNameButton());\n    },\n\n    updateNameButton: function(newNameButton, oldNameButton) {\n        if (oldNameButton) {\n            this.remove(oldNameButton);\n        }\n\n        if (newNameButton) {\n            this.add(newNameButton);\n        }\n    }\n});\n</code></pre>\n\n<p>Above is an example of how to define your component based <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> item component. There are a few important notes about this:</p>\n\n<ul>\n<li>We must extend <a href=\"#!/api/Ext.dataview.component.DataItem\" rel=\"Ext.dataview.component.DataItem\" class=\"docClass\">Ext.dataview.component.DataItem</a> for each item. This is an abstract class which handles the record handling for each item.</li>\n<li>Below the extend we require <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>. This is simply because we are going to insert a <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">button</a> inside our item component.</li>\n<li>We then specify the <code>xtype</code> for this item component.</li>\n<li>Inside our config block we define <code>nameButton</code>. This is a custom configuration we add to this component which will be transformed into a <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">button</a> by the <a href=\"#!/guide/class_system\">class system</a>. We set it to <code>true</code> by default, but this could also be a configuration block. This configuration will automatically generate getters and setters for our <code>nameButton</code>.</li>\n<li>Next we define the <a href=\"#!/api/Ext.dataview.component.DataItem-cfg-dataMap\" rel=\"Ext.dataview.component.DataItem-cfg-dataMap\" class=\"docClass\">dataMap</a>. The dataMap is a map between the data of a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a> and this view. The <code>getNameButton</code> is the getter for the instance you want to update; so in this case we want to get the <code>nameButton</code> configuration of this component. Then inside that block we give it the setter for that instance; in this case being <code>setText</code> and give it the field of the record we are passing. So, once this item component gets a record it will get the <code>nameButton</code> and then call <code>setText</code> with the <code>name</code> value of the record.</li>\n<li>Then we define the apply method for our <code>nameButton</code>. The apply method uses <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext.factory</a> to transform the configuration passed into an instance of <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>. That instance is then returned, which will then cause <code>updateNameButton</code> to be called. The <code>updateNameButton</code> method simply removes the old nameButton instance if it exists, and adds the new nameButton instance if it exists.</li>\n</ul>\n\n\n<p>Now we have created the item component, we can create our component <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a>, similar to how we done it before.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        fields: ['name', 'age'],\n        data: [\n            {name: 'Jamie Avins',  age: 100},\n            {name: 'Rob Dougan',   age: 21},\n            {name: 'Tommy Maintz', age: 24},\n            {name: 'Jacky Nguyen', age: 24},\n            {name: 'Ed Spencer',   age: 26}\n        ]\n    },\n\n    useComponents: true,\n    defaultType: 'mylistitem'\n});\n</code></pre>\n\n<p>There are two key additions. Firstly, we add the <a href=\"#!/api/Ext.dataview.DataView-cfg-useComponents\" rel=\"Ext.dataview.DataView-cfg-useComponents\" class=\"docClass\">useComponents</a> configuration and set it to <code>true</code>. Secondly, we set the <a href=\"#!/api/Ext.dataview.DataView-cfg-defaultType\" rel=\"Ext.dataview.DataView-cfg-defaultType\" class=\"docClass\">defaultType</a> configuration to our item component <code>mylistitem</code>. This tells the <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> to use our defined item component as the view for each item.</p>\n\n<p>Now if we run this code together, we can see the component <a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">DataView</a> in action.</p>\n\n<pre class='inline-example preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyListItem', {\n    extend: '<a href=\"#!/api/Ext.dataview.component.DataItem\" rel=\"Ext.dataview.component.DataItem\" class=\"docClass\">Ext.dataview.component.DataItem</a>',\n    requires: ['<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>'],\n    xtype: 'mylistitem',\n\n    config: {\n        nameButton: true,\n\n        dataMap: {\n            getNameButton: {\n                setText: 'name'\n            }\n        }\n    },\n\n    applyNameButton: function(config) {\n        return Ext.factory(config, <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>, this.getNameButton());\n    },\n\n    updateNameButton: function(newNameButton, oldNameButton) {\n        if (oldNameButton) {\n            this.remove(oldNameButton);\n        }\n\n        if (newNameButton) {\n            this.add(newNameButton);\n        }\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        fields: ['name', 'age'],\n        data: [\n            {name: 'Jamie Avins',  age: 100},\n            {name: 'Rob Dougan',   age: 21},\n            {name: 'Tommy Maintz', age: 24},\n            {name: 'Jacky Nguyen', age: 24},\n            {name: 'Ed Spencer',   age: 26}\n        ]\n    },\n\n    useComponents: true,\n    defaultType: 'mylistitem'\n});\n</code></pre>\n\n<p>The great thing about this is the flexibilty it can add to your dataviews. Each item component has access to its own <a href=\"#!/api/Ext.dataview.component.DataItem-cfg-record\" rel=\"Ext.dataview.component.DataItem-cfg-record\" class=\"docClass\">record</a>, so you can do just about anything with it.</p>\n\n<p>Below we add a event listener to the tap event on our <code>nameButton</code>, which will then alert the user with the age of the selected person.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyListItem', {\n    //...\n\n    updateNameButton: function(newNameButton, oldNameButton) {\n        if (oldNameButton) {\n            this.remove(oldNameButton);\n        }\n\n        if (newNameButton) {\n            // add an event listeners for the `tap` event onto the new button, and tell it to call the onNameButtonTap method\n            // when it happens\n            newNameButton.on('tap', this.onNameButtonTap, this);\n\n            this.add(newNameButton);\n        }\n    },\n\n    onNameButtonTap: function(button, e) {\n        var record = this.getRecord();\n\n        <a href=\"#!/api/Ext.Msg-method-alert\" rel=\"Ext.Msg-method-alert\" class=\"docClass\">Ext.Msg.alert</a>(\n            record.get('name'), // the title of the alert\n            \"The age of this person is: \" + record.get('age') // the message of the alert\n        );\n    }\n});\n</code></pre>\n\n<p>And when we add this code to our above example, we get the finished result:</p>\n\n<pre class='inline-example preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyListItem', {\n    extend: '<a href=\"#!/api/Ext.dataview.component.DataItem\" rel=\"Ext.dataview.component.DataItem\" class=\"docClass\">Ext.dataview.component.DataItem</a>',\n    requires: ['<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>'],\n    xtype: 'mylistitem',\n\n    config: {\n        nameButton: true,\n\n        dataMap: {\n            getNameButton: {\n                setText: 'name'\n            }\n        }\n    },\n\n    applyNameButton: function(config) {\n        return Ext.factory(config, <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>, this.getNameButton());\n    },\n\n    updateNameButton: function(newNameButton, oldNameButton) {\n        if (oldNameButton) {\n            this.remove(oldNameButton);\n        }\n\n        if (newNameButton) {\n            // add an event listeners for the `tap` event onto the new button, and tell it to call the onNameButtonTap method\n            // when it happens\n            newNameButton.on('tap', this.onNameButtonTap, this);\n\n            this.add(newNameButton);\n        }\n    },\n\n    onNameButtonTap: function(button, e) {\n        var record = this.getRecord();\n\n        <a href=\"#!/api/Ext.Msg-method-alert\" rel=\"Ext.Msg-method-alert\" class=\"docClass\">Ext.Msg.alert</a>(\n            record.get('name'), // the title of the alert\n            \"The age of this person is: \" + record.get('age') // the message of the alert\n        );\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.DataView\" rel=\"Ext.dataview.DataView\" class=\"docClass\">Ext.DataView</a>', {\n    fullscreen: true,\n\n    store: {\n        fields: ['name', 'age'],\n        data: [\n            {name: 'Jamie Avins',  age: 100},\n            {name: 'Rob Dougan',   age: 21},\n            {name: 'Tommy Maintz', age: 24},\n            {name: 'Jacky Nguyen', age: 24},\n            {name: 'Ed Spencer',   age: 26}\n        ]\n    },\n\n    useComponents: true,\n    defaultType: 'mylistitem'\n});\n</code></pre>\n"});